# This file was auto-generated by Fern from our API Definition.

import typing
import urllib.parse
from json.decoder import JSONDecodeError

from ...core.api_error import ApiError
from ...core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ...core.jsonable_encoder import jsonable_encoder
from ...core.remove_none_from_dict import remove_none_from_dict
from ...core.request_options import RequestOptions
from ...fhir.types.bundle import Bundle
from .types.consolidated_bundle_upload import ConsolidatedBundleUpload
from .types.consolidated_count_response import ConsolidatedCountResponse
from .types.get_consolidated_query_status_response import GetConsolidatedQueryStatusResponse
from .types.start_consolidated_query_response import StartConsolidatedQueryResponse

try:
    import pydantic.v1 as pydantic  # type: ignore
except ImportError:
    import pydantic  # type: ignore

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class FhirClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._client_wrapper = client_wrapper

    def start_consolidated_query(
        self,
        id: str,
        *,
        resources: typing.Optional[str] = None,
        date_from: typing.Optional[str] = None,
        date_to: typing.Optional[str] = None,
        conversion_type: typing.Optional[str] = None,
        request: typing.Optional[typing.Dict[str, str]] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> StartConsolidatedQueryResponse:
        """
        Trigger a consolidated data query for the given patient

        Parameters:
            - id: str. The ID of the Patient.

            - resources: typing.Optional[str]. A comma separated, case sensitive list of resources to be returned.
                                               If none are provided all resources will be included.
            - date_from: typing.Optional[str]. The start date (inclusive) for which to filter returned resources -
                                               formatted `YYYY-MM-DD` as per ISO 8601. If not provided,
                                               no start date filter will be applied.
            - date_to: typing.Optional[str]. The end date (inclusive) for which to filter returned resources -
                                             formatted `YYYY-MM-DD` as per ISO 8601. If not provided,
                                             no end date filter will be applied.
            - conversion_type: typing.Optional[str]. The doc type to convert to. Either `html` or `pdf`.

            - request: typing.Optional[typing.Dict[str, str]].

            - request_options: typing.Optional[RequestOptions]. Request-specific configuration.
        ---
        from metriport.client import Metriport

        client = Metriport(
            api_key="YOUR_API_KEY",
        )
        client.medical.fhir.start_consolidated_query(
            id="12345678",
        )
        """
        _response = self._client_wrapper.httpx_client.request(
            "POST",
            urllib.parse.urljoin(
                f"{self._client_wrapper.get_base_url()}/", f"medical/v1/patient/{id}/consolidated/query"
            ),
            params=jsonable_encoder(
                remove_none_from_dict(
                    {
                        "resources": resources,
                        "dateFrom": date_from,
                        "dateTo": date_to,
                        "conversionType": conversion_type,
                        **(
                            request_options.get("additional_query_parameters", {})
                            if request_options is not None
                            else {}
                        ),
                    }
                )
            ),
            json=jsonable_encoder(request)
            if request_options is None or request_options.get("additional_body_parameters") is None
            else {
                **jsonable_encoder(request),
                **(jsonable_encoder(remove_none_from_dict(request_options.get("additional_body_parameters", {})))),
            },
            headers=jsonable_encoder(
                remove_none_from_dict(
                    {
                        **self._client_wrapper.get_headers(),
                        **(request_options.get("additional_headers", {}) if request_options is not None else {}),
                    }
                )
            ),
            timeout=request_options.get("timeout_in_seconds")
            if request_options is not None and request_options.get("timeout_in_seconds") is not None
            else 60,
        )
        if 200 <= _response.status_code < 300:
            return pydantic.parse_obj_as(StartConsolidatedQueryResponse, _response.json())  # type: ignore
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    def get_consolidated_query_status(
        self, id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> GetConsolidatedQueryStatusResponse:
        """
        Get the status of querying for patient's consolidated data.

        Parameters:
            - id: str. The ID of the Patient

            - request_options: typing.Optional[RequestOptions]. Request-specific configuration.
        ---
        from metriport.client import Metriport

        client = Metriport(
            api_key="YOUR_API_KEY",
        )
        client.medical.fhir.get_consolidated_query_status(
            id="12345678",
        )
        """
        _response = self._client_wrapper.httpx_client.request(
            "GET",
            urllib.parse.urljoin(
                f"{self._client_wrapper.get_base_url()}/", f"medical/v1/patient/{id}/consolidated/query"
            ),
            params=jsonable_encoder(
                request_options.get("additional_query_parameters") if request_options is not None else None
            ),
            headers=jsonable_encoder(
                remove_none_from_dict(
                    {
                        **self._client_wrapper.get_headers(),
                        **(request_options.get("additional_headers", {}) if request_options is not None else {}),
                    }
                )
            ),
            timeout=request_options.get("timeout_in_seconds")
            if request_options is not None and request_options.get("timeout_in_seconds") is not None
            else 60,
        )
        if 200 <= _response.status_code < 300:
            return pydantic.parse_obj_as(GetConsolidatedQueryStatusResponse, _response.json())  # type: ignore
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    def create_patient_consolidated(
        self, id: str, *, request: ConsolidatedBundleUpload, request_options: typing.Optional[RequestOptions] = None
    ) -> Bundle:
        """
        Create Patient's Consolidated Data with a FHIR Bundle.

        Parameters:
            - id: str. The ID of the Patient

            - request: ConsolidatedBundleUpload.

            - request_options: typing.Optional[RequestOptions]. Request-specific configuration.
        ---
        from metriport.client import Metriport
        from metriport.medical import ConsolidatedBundleUpload

        client = Metriport(
            api_key="YOUR_API_KEY",
        )
        client.medical.fhir.create_patient_consolidated(
            id="12345678",
            request=ConsolidatedBundleUpload(
                resource_type="Bundle",
                type="collection",
                entry=[
                    {
                        "resource": {
                            "resourceType": "Observation",
                            "code": {"text": "Cancer"},
                            "valueCodeableConcept": {"text": "NEGATIVE"},
                            "status": "final",
                            "category": [
                                {
                                    "coding": [
                                        {
                                            "system": "http://terminology.hl7.org/CodeSystem/observation-category",
                                            "code": "laboratory",
                                        }
                                    ]
                                }
                            ],
                        }
                    }
                ],
            ),
        )
        """
        _response = self._client_wrapper.httpx_client.request(
            "PUT",
            urllib.parse.urljoin(f"{self._client_wrapper.get_base_url()}/", f"medical/v1/patient/{id}/consolidated"),
            params=jsonable_encoder(
                request_options.get("additional_query_parameters") if request_options is not None else None
            ),
            json=jsonable_encoder(request)
            if request_options is None or request_options.get("additional_body_parameters") is None
            else {
                **jsonable_encoder(request),
                **(jsonable_encoder(remove_none_from_dict(request_options.get("additional_body_parameters", {})))),
            },
            headers=jsonable_encoder(
                remove_none_from_dict(
                    {
                        **self._client_wrapper.get_headers(),
                        **(request_options.get("additional_headers", {}) if request_options is not None else {}),
                    }
                )
            ),
            timeout=request_options.get("timeout_in_seconds")
            if request_options is not None and request_options.get("timeout_in_seconds") is not None
            else 60,
        )
        if 200 <= _response.status_code < 300:
            return pydantic.parse_obj_as(Bundle, _response.json())  # type: ignore
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    def count_patient_data(
        self,
        id: str,
        *,
        resources: typing.Optional[str] = None,
        date_from: typing.Optional[str] = None,
        date_to: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> ConsolidatedCountResponse:
        """
        Get a count of a Patient's data per resource.

        Parameters:
            - id: str. The ID of the Patient

            - resources: typing.Optional[str]. A comma separated, case sensitive list of resources to be returned.
                                               If none are provided all resources will be included.
            - date_from: typing.Optional[str]. The start date (inclusive) for which to filter returned resources -
                                               formatted `YYYY-MM-DD` as per ISO 8601. If not provided,
                                               no start date filter will be applied.
            - date_to: typing.Optional[str]. The end date (inclusive) for which to filter returned resources -
                                             formatted `YYYY-MM-DD` as per ISO 8601. If not provided,
                                             no end date filter will be applied.
            - request_options: typing.Optional[RequestOptions]. Request-specific configuration.
        """
        _response = self._client_wrapper.httpx_client.request(
            "GET",
            urllib.parse.urljoin(
                f"{self._client_wrapper.get_base_url()}/", f"medical/v1/patient/{id}/consolidated/count"
            ),
            params=jsonable_encoder(
                remove_none_from_dict(
                    {
                        "resources": resources,
                        "dateFrom": date_from,
                        "dateTo": date_to,
                        **(
                            request_options.get("additional_query_parameters", {})
                            if request_options is not None
                            else {}
                        ),
                    }
                )
            ),
            headers=jsonable_encoder(
                remove_none_from_dict(
                    {
                        **self._client_wrapper.get_headers(),
                        **(request_options.get("additional_headers", {}) if request_options is not None else {}),
                    }
                )
            ),
            timeout=request_options.get("timeout_in_seconds")
            if request_options is not None and request_options.get("timeout_in_seconds") is not None
            else 60,
        )
        if 200 <= _response.status_code < 300:
            return pydantic.parse_obj_as(ConsolidatedCountResponse, _response.json())  # type: ignore
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)


class AsyncFhirClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._client_wrapper = client_wrapper

    async def start_consolidated_query(
        self,
        id: str,
        *,
        resources: typing.Optional[str] = None,
        date_from: typing.Optional[str] = None,
        date_to: typing.Optional[str] = None,
        conversion_type: typing.Optional[str] = None,
        request: typing.Optional[typing.Dict[str, str]] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> StartConsolidatedQueryResponse:
        """
        Trigger a consolidated data query for the given patient

        Parameters:
            - id: str. The ID of the Patient.

            - resources: typing.Optional[str]. A comma separated, case sensitive list of resources to be returned.
                                               If none are provided all resources will be included.
            - date_from: typing.Optional[str]. The start date (inclusive) for which to filter returned resources -
                                               formatted `YYYY-MM-DD` as per ISO 8601. If not provided,
                                               no start date filter will be applied.
            - date_to: typing.Optional[str]. The end date (inclusive) for which to filter returned resources -
                                             formatted `YYYY-MM-DD` as per ISO 8601. If not provided,
                                             no end date filter will be applied.
            - conversion_type: typing.Optional[str]. The doc type to convert to. Either `html` or `pdf`.

            - request: typing.Optional[typing.Dict[str, str]].

            - request_options: typing.Optional[RequestOptions]. Request-specific configuration.
        ---
        from metriport.client import AsyncMetriport

        client = AsyncMetriport(
            api_key="YOUR_API_KEY",
        )
        await client.medical.fhir.start_consolidated_query(
            id="12345678",
        )
        """
        _response = await self._client_wrapper.httpx_client.request(
            "POST",
            urllib.parse.urljoin(
                f"{self._client_wrapper.get_base_url()}/", f"medical/v1/patient/{id}/consolidated/query"
            ),
            params=jsonable_encoder(
                remove_none_from_dict(
                    {
                        "resources": resources,
                        "dateFrom": date_from,
                        "dateTo": date_to,
                        "conversionType": conversion_type,
                        **(
                            request_options.get("additional_query_parameters", {})
                            if request_options is not None
                            else {}
                        ),
                    }
                )
            ),
            json=jsonable_encoder(request)
            if request_options is None or request_options.get("additional_body_parameters") is None
            else {
                **jsonable_encoder(request),
                **(jsonable_encoder(remove_none_from_dict(request_options.get("additional_body_parameters", {})))),
            },
            headers=jsonable_encoder(
                remove_none_from_dict(
                    {
                        **self._client_wrapper.get_headers(),
                        **(request_options.get("additional_headers", {}) if request_options is not None else {}),
                    }
                )
            ),
            timeout=request_options.get("timeout_in_seconds")
            if request_options is not None and request_options.get("timeout_in_seconds") is not None
            else 60,
        )
        if 200 <= _response.status_code < 300:
            return pydantic.parse_obj_as(StartConsolidatedQueryResponse, _response.json())  # type: ignore
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    async def get_consolidated_query_status(
        self, id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> GetConsolidatedQueryStatusResponse:
        """
        Get the status of querying for patient's consolidated data.

        Parameters:
            - id: str. The ID of the Patient

            - request_options: typing.Optional[RequestOptions]. Request-specific configuration.
        ---
        from metriport.client import AsyncMetriport

        client = AsyncMetriport(
            api_key="YOUR_API_KEY",
        )
        await client.medical.fhir.get_consolidated_query_status(
            id="12345678",
        )
        """
        _response = await self._client_wrapper.httpx_client.request(
            "GET",
            urllib.parse.urljoin(
                f"{self._client_wrapper.get_base_url()}/", f"medical/v1/patient/{id}/consolidated/query"
            ),
            params=jsonable_encoder(
                request_options.get("additional_query_parameters") if request_options is not None else None
            ),
            headers=jsonable_encoder(
                remove_none_from_dict(
                    {
                        **self._client_wrapper.get_headers(),
                        **(request_options.get("additional_headers", {}) if request_options is not None else {}),
                    }
                )
            ),
            timeout=request_options.get("timeout_in_seconds")
            if request_options is not None and request_options.get("timeout_in_seconds") is not None
            else 60,
        )
        if 200 <= _response.status_code < 300:
            return pydantic.parse_obj_as(GetConsolidatedQueryStatusResponse, _response.json())  # type: ignore
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    async def create_patient_consolidated(
        self, id: str, *, request: ConsolidatedBundleUpload, request_options: typing.Optional[RequestOptions] = None
    ) -> Bundle:
        """
        Create Patient's Consolidated Data with a FHIR Bundle.

        Parameters:
            - id: str. The ID of the Patient

            - request: ConsolidatedBundleUpload.

            - request_options: typing.Optional[RequestOptions]. Request-specific configuration.
        ---
        from metriport.client import AsyncMetriport
        from metriport.medical import ConsolidatedBundleUpload

        client = AsyncMetriport(
            api_key="YOUR_API_KEY",
        )
        await client.medical.fhir.create_patient_consolidated(
            id="12345678",
            request=ConsolidatedBundleUpload(
                resource_type="Bundle",
                type="collection",
                entry=[
                    {
                        "resource": {
                            "resourceType": "Observation",
                            "code": {"text": "Cancer"},
                            "valueCodeableConcept": {"text": "NEGATIVE"},
                            "status": "final",
                            "category": [
                                {
                                    "coding": [
                                        {
                                            "system": "http://terminology.hl7.org/CodeSystem/observation-category",
                                            "code": "laboratory",
                                        }
                                    ]
                                }
                            ],
                        }
                    }
                ],
            ),
        )
        """
        _response = await self._client_wrapper.httpx_client.request(
            "PUT",
            urllib.parse.urljoin(f"{self._client_wrapper.get_base_url()}/", f"medical/v1/patient/{id}/consolidated"),
            params=jsonable_encoder(
                request_options.get("additional_query_parameters") if request_options is not None else None
            ),
            json=jsonable_encoder(request)
            if request_options is None or request_options.get("additional_body_parameters") is None
            else {
                **jsonable_encoder(request),
                **(jsonable_encoder(remove_none_from_dict(request_options.get("additional_body_parameters", {})))),
            },
            headers=jsonable_encoder(
                remove_none_from_dict(
                    {
                        **self._client_wrapper.get_headers(),
                        **(request_options.get("additional_headers", {}) if request_options is not None else {}),
                    }
                )
            ),
            timeout=request_options.get("timeout_in_seconds")
            if request_options is not None and request_options.get("timeout_in_seconds") is not None
            else 60,
        )
        if 200 <= _response.status_code < 300:
            return pydantic.parse_obj_as(Bundle, _response.json())  # type: ignore
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    async def count_patient_data(
        self,
        id: str,
        *,
        resources: typing.Optional[str] = None,
        date_from: typing.Optional[str] = None,
        date_to: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> ConsolidatedCountResponse:
        """
        Get a count of a Patient's data per resource.

        Parameters:
            - id: str. The ID of the Patient

            - resources: typing.Optional[str]. A comma separated, case sensitive list of resources to be returned.
                                               If none are provided all resources will be included.
            - date_from: typing.Optional[str]. The start date (inclusive) for which to filter returned resources -
                                               formatted `YYYY-MM-DD` as per ISO 8601. If not provided,
                                               no start date filter will be applied.
            - date_to: typing.Optional[str]. The end date (inclusive) for which to filter returned resources -
                                             formatted `YYYY-MM-DD` as per ISO 8601. If not provided,
                                             no end date filter will be applied.
            - request_options: typing.Optional[RequestOptions]. Request-specific configuration.
        """
        _response = await self._client_wrapper.httpx_client.request(
            "GET",
            urllib.parse.urljoin(
                f"{self._client_wrapper.get_base_url()}/", f"medical/v1/patient/{id}/consolidated/count"
            ),
            params=jsonable_encoder(
                remove_none_from_dict(
                    {
                        "resources": resources,
                        "dateFrom": date_from,
                        "dateTo": date_to,
                        **(
                            request_options.get("additional_query_parameters", {})
                            if request_options is not None
                            else {}
                        ),
                    }
                )
            ),
            headers=jsonable_encoder(
                remove_none_from_dict(
                    {
                        **self._client_wrapper.get_headers(),
                        **(request_options.get("additional_headers", {}) if request_options is not None else {}),
                    }
                )
            ),
            timeout=request_options.get("timeout_in_seconds")
            if request_options is not None and request_options.get("timeout_in_seconds") is not None
            else 60,
        )
        if 200 <= _response.status_code < 300:
            return pydantic.parse_obj_as(ConsolidatedCountResponse, _response.json())  # type: ignore
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)
