# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing

from ....core.datetime_utils import serialize_datetime

try:
    import pydantic.v1 as pydantic  # type: ignore
except ImportError:
    import pydantic  # type: ignore


class Filter(pydantic.BaseModel):
    resources: str = pydantic.Field(
        description=(
            "Comma-separated list of resource types. If not specified on the\n" "request, this will be `all`.\n"
        )
    )
    date_from: typing.Optional[str] = pydantic.Field(
        alias="dateFrom",
        default=None,
        description=(
            "The start date (inclusive) for which to filter returned resources -\n"
            "formatted `YYYY-MM-DD` as per ISO 8601. If not provided,\n"
            "no start date filter will be applied.\n"
        ),
    )
    date_to: typing.Optional[str] = pydantic.Field(
        alias="dateTo",
        default=None,
        description=(
            "The end date (inclusive) for which to filter returned resources -\n"
            "formatted `YYYY-MM-DD` as per ISO 8601. If not provided,\n"
            "no end date filter will be applied.\n"
        ),
    )

    def json(self, **kwargs: typing.Any) -> str:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().json(**kwargs_with_defaults)

    def dict(self, **kwargs: typing.Any) -> typing.Dict[str, typing.Any]:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().dict(**kwargs_with_defaults)

    class Config:
        frozen = True
        smart_union = True
        allow_population_by_field_name = True
        json_encoders = {dt.datetime: serialize_datetime}
