# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing

from ....core.datetime_utils import serialize_datetime
from .base_patient import BasePatient
from .facility_id import FacilityId

try:
    import pydantic.v1 as pydantic  # type: ignore
except ImportError:
    import pydantic  # type: ignore


class Patient(BasePatient):
    """
    from metriport import Address, UsState
    from metriport.medical import Patient, PersonalIdentifier_DriversLicense

    Patient(
        id="2.16.840.1.113883.3.666.777",
        first_name="Karen",
        last_name="Lynch",
        dob="1963-12-30",
        gender_at_birth="F",
        personal_identifiers=[
            PersonalIdentifier_DriversLicense(
                type="driversLicense",
                state=UsState.CA,
                value="51227265",
            )
        ],
        address=[
            Address(
                address_line_1="2261 Market Street",
                address_line_2="#4818",
                city="San Francisco",
                state=UsState.CA,
                zip="94114",
                country="USA",
            )
        ],
        facility_ids=["2.16.840.1.113883.3.666.5.2004.4.2005"],
    )
    """

    id: str = pydantic.Field(
        description=(
            "The ID assigned to this Patient. This ID will be used to uniquely\n"
            "identify this Patient in medical documents.\n"
        )
    )
    facility_ids: typing.List[FacilityId] = pydantic.Field(
        alias="facilityIds", description="Array of the IDs of the Facilities where the Patient is receiving care."
    )

    def json(self, **kwargs: typing.Any) -> str:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().json(**kwargs_with_defaults)

    def dict(self, **kwargs: typing.Any) -> typing.Dict[str, typing.Any]:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().dict(**kwargs_with_defaults)

    class Config:
        frozen = True
        smart_union = True
        allow_population_by_field_name = True
        json_encoders = {dt.datetime: serialize_datetime}
