# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing

from ....core.datetime_utils import serialize_datetime
from ....fhir.types.codeable_concept import CodeableConcept

try:
    import pydantic.v1 as pydantic  # type: ignore
except ImportError:
    import pydantic  # type: ignore


class WebhookDocumentDataPayload(pydantic.BaseModel):
    id: str = pydantic.Field(description="The ID of the Document.")
    file_name: str = pydantic.Field(alias="fileName", description="The file name of the document.")
    description: typing.Optional[str] = pydantic.Field(default=None, description="The description of the document.")
    mime_type: typing.Optional[str] = pydantic.Field(
        alias="mimeType", default=None, description="The MIME type of the document."
    )
    size: typing.Optional[int] = pydantic.Field(default=None, description="The size of the document in bytes.")
    url: typing.Optional[str] = pydantic.Field(default=None, description="The URL of the document.")
    status: typing.Optional[str] = pydantic.Field(default=None, description="The status of the document.")
    indexed: typing.Optional[str] = pydantic.Field(
        default=None, description="The indexed date of the document in ISO-8601 format."
    )
    type: typing.Optional[CodeableConcept] = pydantic.Field(default=None, description="The type of the document.")

    def json(self, **kwargs: typing.Any) -> str:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().json(**kwargs_with_defaults)

    def dict(self, **kwargs: typing.Any) -> typing.Dict[str, typing.Any]:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().dict(**kwargs_with_defaults)

    class Config:
        frozen = True
        smart_union = True
        allow_population_by_field_name = True
        json_encoders = {dt.datetime: serialize_datetime}
