# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing

from ....core.datetime_utils import serialize_datetime

try:
    import pydantic.v1 as pydantic  # type: ignore
except ImportError:
    import pydantic  # type: ignore


class WebhookMetadataPayload(pydantic.BaseModel):
    message_id: str = pydantic.Field(alias="messageId", description="The ID of the message.")
    when: str = pydantic.Field(description="The timestamp of when the webhook was triggered.")
    type: str = pydantic.Field(description="The type of the webhook.")
    data: typing.Optional[typing.Any] = pydantic.Field(
        default=None, description="Any additional data associated with the webhook."
    )

    def json(self, **kwargs: typing.Any) -> str:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().json(**kwargs_with_defaults)

    def dict(self, **kwargs: typing.Any) -> typing.Dict[str, typing.Any]:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().dict(**kwargs_with_defaults)

    class Config:
        frozen = True
        smart_union = True
        allow_population_by_field_name = True
        json_encoders = {dt.datetime: serialize_datetime}
