# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing

from ....core.datetime_utils import serialize_datetime
from .mapi_webhook_status import MapiWebhookStatus
from .webhook_document_data_payload import WebhookDocumentDataPayload

try:
    import pydantic.v1 as pydantic  # type: ignore
except ImportError:
    import pydantic  # type: ignore


class WebhookPatientPayload(pydantic.BaseModel):
    patient_id: str = pydantic.Field(alias="patientId", description="The ID of the patient.")
    external_id: typing.Optional[str] = pydantic.Field(
        alias="externalId", default=None, description="The external ID of the patient."
    )
    type: str = pydantic.Field(description="The type of the webhook.")
    documents: typing.Optional[typing.List[WebhookDocumentDataPayload]] = pydantic.Field(
        default=None, description="An array of WebhookDocumentDataPayload objects."
    )
    status: MapiWebhookStatus = pydantic.Field(description="The status of the webhook.")

    def json(self, **kwargs: typing.Any) -> str:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().json(**kwargs_with_defaults)

    def dict(self, **kwargs: typing.Any) -> typing.Dict[str, typing.Any]:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().dict(**kwargs_with_defaults)

    class Config:
        frozen = True
        smart_union = True
        allow_population_by_field_name = True
        json_encoders = {dt.datetime: serialize_datetime}
