"""
@generated by mypy-protobuf.  Do not edit manually!
isort:skip_file
Copyright 2019 The Mezon Authors

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.

*
The Mezon server RPC protocol for games and apps.
"""

import builtins
import collections.abc
import google.protobuf.descriptor
import google.protobuf.internal.containers
import google.protobuf.internal.enum_type_wrapper
import google.protobuf.message
import google.protobuf.struct_pb2
import google.protobuf.timestamp_pb2
import google.protobuf.wrappers_pb2
import sys
import typing

if sys.version_info >= (3, 10):
    import typing as typing_extensions
else:
    import typing_extensions

DESCRIPTOR: google.protobuf.descriptor.FileDescriptor

class _StoreProvider:
    ValueType = typing.NewType("ValueType", builtins.int)
    V: typing_extensions.TypeAlias = ValueType

class _StoreProviderEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[_StoreProvider.ValueType], builtins.type):
    DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
    APPLE_APP_STORE: _StoreProvider.ValueType  # 0
    """Apple App Store"""
    GOOGLE_PLAY_STORE: _StoreProvider.ValueType  # 1
    """Google Play Store"""
    HUAWEI_APP_GALLERY: _StoreProvider.ValueType  # 2
    """Huawei App Gallery"""
    FACEBOOK_INSTANT_STORE: _StoreProvider.ValueType  # 3
    """Facebook Instant Store"""

class StoreProvider(_StoreProvider, metaclass=_StoreProviderEnumTypeWrapper):
    """Validation Provider,"""

APPLE_APP_STORE: StoreProvider.ValueType  # 0
"""Apple App Store"""
GOOGLE_PLAY_STORE: StoreProvider.ValueType  # 1
"""Google Play Store"""
HUAWEI_APP_GALLERY: StoreProvider.ValueType  # 2
"""Huawei App Gallery"""
FACEBOOK_INSTANT_STORE: StoreProvider.ValueType  # 3
"""Facebook Instant Store"""
global___StoreProvider = StoreProvider

class _StoreEnvironment:
    ValueType = typing.NewType("ValueType", builtins.int)
    V: typing_extensions.TypeAlias = ValueType

class _StoreEnvironmentEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[_StoreEnvironment.ValueType], builtins.type):
    DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
    UNKNOWN: _StoreEnvironment.ValueType  # 0
    """Unknown environment."""
    SANDBOX: _StoreEnvironment.ValueType  # 1
    """Sandbox/test environment."""
    PRODUCTION: _StoreEnvironment.ValueType  # 2
    """Production environment."""

class StoreEnvironment(_StoreEnvironment, metaclass=_StoreEnvironmentEnumTypeWrapper):
    """Environment where a purchase/subscription took place,"""

UNKNOWN: StoreEnvironment.ValueType  # 0
"""Unknown environment."""
SANDBOX: StoreEnvironment.ValueType  # 1
"""Sandbox/test environment."""
PRODUCTION: StoreEnvironment.ValueType  # 2
"""Production environment."""
global___StoreEnvironment = StoreEnvironment

class _Operator:
    ValueType = typing.NewType("ValueType", builtins.int)
    V: typing_extensions.TypeAlias = ValueType

class _OperatorEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[_Operator.ValueType], builtins.type):
    DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
    NO_OVERRIDE: _Operator.ValueType  # 0
    """Do not override the leaderboard operator."""
    BEST: _Operator.ValueType  # 1
    """Override the leaderboard operator with BEST."""
    SET: _Operator.ValueType  # 2
    """Override the leaderboard operator with SET."""
    INCREMENT: _Operator.ValueType  # 3
    """Override the leaderboard operator with INCREMENT."""
    DECREMENT: _Operator.ValueType  # 4
    """Override the leaderboard operator with DECREMENT."""

class Operator(_Operator, metaclass=_OperatorEnumTypeWrapper):
    """Operator that can be used to override the one set in the leaderboard."""

NO_OVERRIDE: Operator.ValueType  # 0
"""Do not override the leaderboard operator."""
BEST: Operator.ValueType  # 1
"""Override the leaderboard operator with BEST."""
SET: Operator.ValueType  # 2
"""Override the leaderboard operator with SET."""
INCREMENT: Operator.ValueType  # 3
"""Override the leaderboard operator with INCREMENT."""
DECREMENT: Operator.ValueType  # 4
"""Override the leaderboard operator with DECREMENT."""
global___Operator = Operator

@typing.final
class Account(google.protobuf.message.Message):
    """A user with additional account details. Always the current user."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    USER_FIELD_NUMBER: builtins.int
    EMAIL_FIELD_NUMBER: builtins.int
    QR_CODE_FIELD_NUMBER: builtins.int
    VERIFY_TIME_FIELD_NUMBER: builtins.int
    DISABLE_TIME_FIELD_NUMBER: builtins.int
    LOGO_FIELD_NUMBER: builtins.int
    SPLASH_SCREEN_FIELD_NUMBER: builtins.int
    ENCRYPT_PRIVATE_KEY_FIELD_NUMBER: builtins.int
    PASSWORD_SETTED_FIELD_NUMBER: builtins.int
    email: builtins.str
    """The email address of the user."""
    qr_code: builtins.str
    """The qr code in the user's account."""
    logo: builtins.str
    """Logo url"""
    splash_screen: builtins.str
    """Splash screen url"""
    encrypt_private_key: builtins.str
    """E2ee encrypt private key"""
    password_setted: builtins.bool
    """password is setted"""
    @property
    def user(self) -> global___User:
        """The user object."""

    @property
    def verify_time(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """The UNIX time (for gRPC clients) or ISO string (for REST clients) when the user's email was verified."""

    @property
    def disable_time(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """The UNIX time (for gRPC clients) or ISO string (for REST clients) when the user's account was disabled/banned."""

    def __init__(
        self,
        *,
        user: global___User | None = ...,
        email: builtins.str = ...,
        qr_code: builtins.str = ...,
        verify_time: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        disable_time: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        logo: builtins.str = ...,
        splash_screen: builtins.str = ...,
        encrypt_private_key: builtins.str = ...,
        password_setted: builtins.bool = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["disable_time", b"disable_time", "user", b"user", "verify_time", b"verify_time"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["disable_time", b"disable_time", "email", b"email", "encrypt_private_key", b"encrypt_private_key", "logo", b"logo", "password_setted", b"password_setted", "qr_code", b"qr_code", "splash_screen", b"splash_screen", "user", b"user", "verify_time", b"verify_time"]) -> None: ...

global___Account = Account

@typing.final
class AccountRefresh(google.protobuf.message.Message):
    """Obtain a new authentication token using a refresh token."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    @typing.final
    class VarsEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.str
        value: builtins.str
        def __init__(
            self,
            *,
            key: builtins.str = ...,
            value: builtins.str = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing.Literal["key", b"key", "value", b"value"]) -> None: ...

    TOKEN_FIELD_NUMBER: builtins.int
    VARS_FIELD_NUMBER: builtins.int
    token: builtins.str
    """Refresh token."""
    @property
    def vars(self) -> google.protobuf.internal.containers.ScalarMap[builtins.str, builtins.str]:
        """Extra information that will be bundled in the session token."""

    def __init__(
        self,
        *,
        token: builtins.str = ...,
        vars: collections.abc.Mapping[builtins.str, builtins.str] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["token", b"token", "vars", b"vars"]) -> None: ...

global___AccountRefresh = AccountRefresh

@typing.final
class AddFriendsRequest(google.protobuf.message.Message):
    """Add one or more friends to the current user."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    IDS_FIELD_NUMBER: builtins.int
    USERNAMES_FIELD_NUMBER: builtins.int
    @property
    def ids(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """The account id of a user."""

    @property
    def usernames(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """The account username of a user."""

    def __init__(
        self,
        *,
        ids: collections.abc.Iterable[builtins.str] | None = ...,
        usernames: collections.abc.Iterable[builtins.str] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["ids", b"ids", "usernames", b"usernames"]) -> None: ...

global___AddFriendsRequest = AddFriendsRequest

@typing.final
class AddFriendsResponse(google.protobuf.message.Message):
    """Add one or more friends to the current user."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    IDS_FIELD_NUMBER: builtins.int
    USERNAMES_FIELD_NUMBER: builtins.int
    @property
    def ids(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """The account id of a user."""

    @property
    def usernames(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """The account username of a user."""

    def __init__(
        self,
        *,
        ids: collections.abc.Iterable[builtins.str] | None = ...,
        usernames: collections.abc.Iterable[builtins.str] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["ids", b"ids", "usernames", b"usernames"]) -> None: ...

global___AddFriendsResponse = AddFriendsResponse

@typing.final
class AddGroupUsersRequest(google.protobuf.message.Message):
    """Add users to a group."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    GROUP_ID_FIELD_NUMBER: builtins.int
    USER_IDS_FIELD_NUMBER: builtins.int
    group_id: builtins.str
    """The group to add users to."""
    @property
    def user_ids(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """The users to add."""

    def __init__(
        self,
        *,
        group_id: builtins.str = ...,
        user_ids: collections.abc.Iterable[builtins.str] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["group_id", b"group_id", "user_ids", b"user_ids"]) -> None: ...

global___AddGroupUsersRequest = AddGroupUsersRequest

@typing.final
class SessionRefreshRequest(google.protobuf.message.Message):
    """Authenticate against the server with a refresh token."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    @typing.final
    class VarsEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.str
        value: builtins.str
        def __init__(
            self,
            *,
            key: builtins.str = ...,
            value: builtins.str = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing.Literal["key", b"key", "value", b"value"]) -> None: ...

    TOKEN_FIELD_NUMBER: builtins.int
    VARS_FIELD_NUMBER: builtins.int
    IS_REMEMBER_FIELD_NUMBER: builtins.int
    token: builtins.str
    """Refresh token."""
    @property
    def vars(self) -> google.protobuf.internal.containers.ScalarMap[builtins.str, builtins.str]:
        """Extra information that will be bundled in the session token."""

    @property
    def is_remember(self) -> google.protobuf.wrappers_pb2.BoolValue:
        """Whether to enable "Remember Me" for extended session duration."""

    def __init__(
        self,
        *,
        token: builtins.str = ...,
        vars: collections.abc.Mapping[builtins.str, builtins.str] | None = ...,
        is_remember: google.protobuf.wrappers_pb2.BoolValue | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["is_remember", b"is_remember"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["is_remember", b"is_remember", "token", b"token", "vars", b"vars"]) -> None: ...

global___SessionRefreshRequest = SessionRefreshRequest

@typing.final
class SessionLogoutRequest(google.protobuf.message.Message):
    """Log out a session, invalidate a refresh token, or log out all sessions/refresh tokens for a user."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    TOKEN_FIELD_NUMBER: builtins.int
    REFRESH_TOKEN_FIELD_NUMBER: builtins.int
    DEVICE_ID_FIELD_NUMBER: builtins.int
    FCM_TOKEN_FIELD_NUMBER: builtins.int
    PLATFORM_FIELD_NUMBER: builtins.int
    token: builtins.str
    """Session token to log out."""
    refresh_token: builtins.str
    """Refresh token to invalidate."""
    device_id: builtins.str
    """Device Id"""
    fcm_token: builtins.str
    """FCM token from firebase"""
    platform: builtins.str
    """platform"""
    def __init__(
        self,
        *,
        token: builtins.str = ...,
        refresh_token: builtins.str = ...,
        device_id: builtins.str = ...,
        fcm_token: builtins.str = ...,
        platform: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["device_id", b"device_id", "fcm_token", b"fcm_token", "platform", b"platform", "refresh_token", b"refresh_token", "token", b"token"]) -> None: ...

global___SessionLogoutRequest = SessionLogoutRequest

@typing.final
class BanGroupUsersRequest(google.protobuf.message.Message):
    """Ban users from a group."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    GROUP_ID_FIELD_NUMBER: builtins.int
    USER_IDS_FIELD_NUMBER: builtins.int
    group_id: builtins.str
    """The group to ban users from."""
    @property
    def user_ids(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """The users to ban."""

    def __init__(
        self,
        *,
        group_id: builtins.str = ...,
        user_ids: collections.abc.Iterable[builtins.str] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["group_id", b"group_id", "user_ids", b"user_ids"]) -> None: ...

global___BanGroupUsersRequest = BanGroupUsersRequest

@typing.final
class BlockFriendsRequest(google.protobuf.message.Message):
    """Block one or more friends for the current user."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    IDS_FIELD_NUMBER: builtins.int
    USERNAMES_FIELD_NUMBER: builtins.int
    @property
    def ids(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """The account id of a user."""

    @property
    def usernames(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """The account username of a user."""

    def __init__(
        self,
        *,
        ids: collections.abc.Iterable[builtins.str] | None = ...,
        usernames: collections.abc.Iterable[builtins.str] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["ids", b"ids", "usernames", b"usernames"]) -> None: ...

global___BlockFriendsRequest = BlockFriendsRequest

@typing.final
class ChannelMessage(google.protobuf.message.Message):
    """A message sent on a channel."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CLAN_ID_FIELD_NUMBER: builtins.int
    CHANNEL_ID_FIELD_NUMBER: builtins.int
    MESSAGE_ID_FIELD_NUMBER: builtins.int
    CODE_FIELD_NUMBER: builtins.int
    SENDER_ID_FIELD_NUMBER: builtins.int
    USERNAME_FIELD_NUMBER: builtins.int
    AVATAR_FIELD_NUMBER: builtins.int
    CONTENT_FIELD_NUMBER: builtins.int
    CREATE_TIME_FIELD_NUMBER: builtins.int
    UPDATE_TIME_FIELD_NUMBER: builtins.int
    CHANNEL_LABEL_FIELD_NUMBER: builtins.int
    CLAN_LOGO_FIELD_NUMBER: builtins.int
    CATEGORY_NAME_FIELD_NUMBER: builtins.int
    DISPLAY_NAME_FIELD_NUMBER: builtins.int
    CLAN_NICK_FIELD_NUMBER: builtins.int
    CLAN_AVATAR_FIELD_NUMBER: builtins.int
    REACTIONS_FIELD_NUMBER: builtins.int
    MENTIONS_FIELD_NUMBER: builtins.int
    ATTACHMENTS_FIELD_NUMBER: builtins.int
    REFERENCES_FIELD_NUMBER: builtins.int
    REFERENCED_MESSAGE_FIELD_NUMBER: builtins.int
    CREATE_TIME_SECONDS_FIELD_NUMBER: builtins.int
    UPDATE_TIME_SECONDS_FIELD_NUMBER: builtins.int
    MODE_FIELD_NUMBER: builtins.int
    HIDE_EDITTED_FIELD_NUMBER: builtins.int
    IS_PUBLIC_FIELD_NUMBER: builtins.int
    TOPIC_ID_FIELD_NUMBER: builtins.int
    clan_id: builtins.str
    """The clan this message belong to."""
    channel_id: builtins.str
    """The channel this message belongs to."""
    message_id: builtins.str
    """The unique ID of this message."""
    sender_id: builtins.str
    """Message sender, usually a user ID."""
    username: builtins.str
    """The username of the message sender, if any."""
    avatar: builtins.str
    """The avatar of user who send message"""
    content: builtins.str
    """The content payload."""
    channel_label: builtins.str
    """The name of the chat room, or an empty string if this message was not sent through a chat room."""
    clan_logo: builtins.str
    """The clan logo"""
    category_name: builtins.str
    """The category name"""
    display_name: builtins.str
    """The clan nick name"""
    clan_nick: builtins.str
    """The clan nick name"""
    clan_avatar: builtins.str
    """The clan avatar"""
    reactions: builtins.str
    """Emoji reaction"""
    mentions: builtins.str
    """Message mention"""
    attachments: builtins.str
    """Message attachment"""
    references: builtins.str
    """Message reference"""
    referenced_message: builtins.str
    """referenced message"""
    create_time_seconds: builtins.int
    """create time in ms"""
    update_time_seconds: builtins.int
    """update time in ms"""
    mode: builtins.int
    """channel mode"""
    hide_editted: builtins.bool
    """hide editted"""
    is_public: builtins.bool
    """is public"""
    topic_id: builtins.str
    """topic"""
    @property
    def code(self) -> google.protobuf.wrappers_pb2.Int32Value:
        """The code representing a message type or category."""

    @property
    def create_time(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """The UNIX time (for gRPC clients) or ISO string (for REST clients) when the message was created."""

    @property
    def update_time(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """The UNIX time (for gRPC clients) or ISO string (for REST clients) when the message was last updated."""

    def __init__(
        self,
        *,
        clan_id: builtins.str = ...,
        channel_id: builtins.str = ...,
        message_id: builtins.str = ...,
        code: google.protobuf.wrappers_pb2.Int32Value | None = ...,
        sender_id: builtins.str = ...,
        username: builtins.str = ...,
        avatar: builtins.str = ...,
        content: builtins.str = ...,
        create_time: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        update_time: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        channel_label: builtins.str = ...,
        clan_logo: builtins.str = ...,
        category_name: builtins.str = ...,
        display_name: builtins.str = ...,
        clan_nick: builtins.str = ...,
        clan_avatar: builtins.str = ...,
        reactions: builtins.str = ...,
        mentions: builtins.str = ...,
        attachments: builtins.str = ...,
        references: builtins.str = ...,
        referenced_message: builtins.str = ...,
        create_time_seconds: builtins.int = ...,
        update_time_seconds: builtins.int = ...,
        mode: builtins.int = ...,
        hide_editted: builtins.bool = ...,
        is_public: builtins.bool = ...,
        topic_id: builtins.str = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["code", b"code", "create_time", b"create_time", "update_time", b"update_time"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["attachments", b"attachments", "avatar", b"avatar", "category_name", b"category_name", "channel_id", b"channel_id", "channel_label", b"channel_label", "clan_avatar", b"clan_avatar", "clan_id", b"clan_id", "clan_logo", b"clan_logo", "clan_nick", b"clan_nick", "code", b"code", "content", b"content", "create_time", b"create_time", "create_time_seconds", b"create_time_seconds", "display_name", b"display_name", "hide_editted", b"hide_editted", "is_public", b"is_public", "mentions", b"mentions", "message_id", b"message_id", "mode", b"mode", "reactions", b"reactions", "referenced_message", b"referenced_message", "references", b"references", "sender_id", b"sender_id", "topic_id", b"topic_id", "update_time", b"update_time", "update_time_seconds", b"update_time_seconds", "username", b"username"]) -> None: ...

global___ChannelMessage = ChannelMessage

@typing.final
class MessageMention(google.protobuf.message.Message):
    """Mention to message"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ID_FIELD_NUMBER: builtins.int
    USER_ID_FIELD_NUMBER: builtins.int
    USERNAME_FIELD_NUMBER: builtins.int
    ROLE_ID_FIELD_NUMBER: builtins.int
    ROLENAME_FIELD_NUMBER: builtins.int
    CREATE_TIME_FIELD_NUMBER: builtins.int
    S_FIELD_NUMBER: builtins.int
    E_FIELD_NUMBER: builtins.int
    id: builtins.str
    """Mention id"""
    user_id: builtins.str
    """mention user id"""
    username: builtins.str
    """mention username"""
    role_id: builtins.str
    """role id"""
    rolename: builtins.str
    """role name"""
    s: builtins.int
    """start position from text"""
    e: builtins.int
    """end position from text"""
    @property
    def create_time(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """The UNIX time (for gRPC clients) or ISO string (for REST clients) when the message was created."""

    def __init__(
        self,
        *,
        id: builtins.str = ...,
        user_id: builtins.str = ...,
        username: builtins.str = ...,
        role_id: builtins.str = ...,
        rolename: builtins.str = ...,
        create_time: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        s: builtins.int = ...,
        e: builtins.int = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["create_time", b"create_time"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["create_time", b"create_time", "e", b"e", "id", b"id", "role_id", b"role_id", "rolename", b"rolename", "s", b"s", "user_id", b"user_id", "username", b"username"]) -> None: ...

global___MessageMention = MessageMention

@typing.final
class NotificationInfo(google.protobuf.message.Message):
    """Mention to message"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    USERNAME_FIELD_NUMBER: builtins.int
    AVATAR_FIELD_NUMBER: builtins.int
    CLAN_NICK_FIELD_NUMBER: builtins.int
    CLAN_AVATAR_FIELD_NUMBER: builtins.int
    DISPLAY_NAME_FIELD_NUMBER: builtins.int
    CHANNEL_LABEL_FIELD_NUMBER: builtins.int
    CHANNEL_TYPE_FIELD_NUMBER: builtins.int
    CATEGORY_NAME_FIELD_NUMBER: builtins.int
    CLAN_NAME_FIELD_NUMBER: builtins.int
    CLAN_LOGO_FIELD_NUMBER: builtins.int
    CHANNEL_FIELD_NUMBER: builtins.int
    username: builtins.str
    """username"""
    avatar: builtins.str
    """avatar"""
    clan_nick: builtins.str
    """clan nick name"""
    clan_avatar: builtins.str
    """clan avatar"""
    display_name: builtins.str
    """display name"""
    channel_label: builtins.str
    """channel label"""
    channel_type: builtins.int
    """channel type"""
    category_name: builtins.str
    """category name"""
    clan_name: builtins.str
    """clan name"""
    clan_logo: builtins.str
    """clan logo"""
    @property
    def channel(self) -> global___ChannelDescription:
        """"""

    def __init__(
        self,
        *,
        username: builtins.str = ...,
        avatar: builtins.str = ...,
        clan_nick: builtins.str = ...,
        clan_avatar: builtins.str = ...,
        display_name: builtins.str = ...,
        channel_label: builtins.str = ...,
        channel_type: builtins.int = ...,
        category_name: builtins.str = ...,
        clan_name: builtins.str = ...,
        clan_logo: builtins.str = ...,
        channel: global___ChannelDescription | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["channel", b"channel"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["avatar", b"avatar", "category_name", b"category_name", "channel", b"channel", "channel_label", b"channel_label", "channel_type", b"channel_type", "clan_avatar", b"clan_avatar", "clan_logo", b"clan_logo", "clan_name", b"clan_name", "clan_nick", b"clan_nick", "display_name", b"display_name", "username", b"username"]) -> None: ...

global___NotificationInfo = NotificationInfo

@typing.final
class MessageReaction(google.protobuf.message.Message):
    """Emoji reaction by user"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ID_FIELD_NUMBER: builtins.int
    EMOJI_ID_FIELD_NUMBER: builtins.int
    EMOJI_FIELD_NUMBER: builtins.int
    SENDER_ID_FIELD_NUMBER: builtins.int
    SENDER_NAME_FIELD_NUMBER: builtins.int
    SENDER_AVATAR_FIELD_NUMBER: builtins.int
    ACTION_FIELD_NUMBER: builtins.int
    COUNT_FIELD_NUMBER: builtins.int
    CHANNEL_ID_FIELD_NUMBER: builtins.int
    MESSAGE_ID_FIELD_NUMBER: builtins.int
    CLAN_ID_FIELD_NUMBER: builtins.int
    MODE_FIELD_NUMBER: builtins.int
    MESSAGE_SENDER_ID_FIELD_NUMBER: builtins.int
    IS_PUBLIC_FIELD_NUMBER: builtins.int
    TOPIC_ID_FIELD_NUMBER: builtins.int
    EMOJI_RECENT_ID_FIELD_NUMBER: builtins.int
    id: builtins.str
    """Reaction id"""
    emoji_id: builtins.str
    """An emoji id"""
    emoji: builtins.str
    """An emoji shortname"""
    sender_id: builtins.str
    """User react to message"""
    sender_name: builtins.str
    """Sender name"""
    sender_avatar: builtins.str
    """avatar"""
    action: builtins.bool
    """Action reaction delete or add"""
    count: builtins.int
    """count of emoji"""
    channel_id: builtins.str
    """channel id"""
    message_id: builtins.str
    """message id"""
    clan_id: builtins.str
    """clan id"""
    mode: builtins.int
    """mode"""
    message_sender_id: builtins.str
    """message sender id"""
    is_public: builtins.bool
    """is public"""
    topic_id: builtins.str
    """topic id"""
    emoji_recent_id: builtins.str
    """emoji_recent_id"""
    def __init__(
        self,
        *,
        id: builtins.str = ...,
        emoji_id: builtins.str = ...,
        emoji: builtins.str = ...,
        sender_id: builtins.str = ...,
        sender_name: builtins.str = ...,
        sender_avatar: builtins.str = ...,
        action: builtins.bool = ...,
        count: builtins.int = ...,
        channel_id: builtins.str = ...,
        message_id: builtins.str = ...,
        clan_id: builtins.str = ...,
        mode: builtins.int = ...,
        message_sender_id: builtins.str = ...,
        is_public: builtins.bool = ...,
        topic_id: builtins.str = ...,
        emoji_recent_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["action", b"action", "channel_id", b"channel_id", "clan_id", b"clan_id", "count", b"count", "emoji", b"emoji", "emoji_id", b"emoji_id", "emoji_recent_id", b"emoji_recent_id", "id", b"id", "is_public", b"is_public", "message_id", b"message_id", "message_sender_id", b"message_sender_id", "mode", b"mode", "sender_avatar", b"sender_avatar", "sender_id", b"sender_id", "sender_name", b"sender_name", "topic_id", b"topic_id"]) -> None: ...

global___MessageReaction = MessageReaction

@typing.final
class MessageAttachment(google.protobuf.message.Message):
    """Message attachment"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    FILENAME_FIELD_NUMBER: builtins.int
    SIZE_FIELD_NUMBER: builtins.int
    URL_FIELD_NUMBER: builtins.int
    FILETYPE_FIELD_NUMBER: builtins.int
    WIDTH_FIELD_NUMBER: builtins.int
    HEIGHT_FIELD_NUMBER: builtins.int
    THUMBNAIL_FIELD_NUMBER: builtins.int
    filename: builtins.str
    """Attachment file name"""
    size: builtins.int
    """Attachment file size"""
    url: builtins.str
    """Attachment url"""
    filetype: builtins.str
    """Attachment file type"""
    width: builtins.int
    """Attachment width"""
    height: builtins.int
    """Attachment width"""
    thumbnail: builtins.str
    """thumbnail"""
    def __init__(
        self,
        *,
        filename: builtins.str = ...,
        size: builtins.int = ...,
        url: builtins.str = ...,
        filetype: builtins.str = ...,
        width: builtins.int = ...,
        height: builtins.int = ...,
        thumbnail: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["filename", b"filename", "filetype", b"filetype", "height", b"height", "size", b"size", "thumbnail", b"thumbnail", "url", b"url", "width", b"width"]) -> None: ...

global___MessageAttachment = MessageAttachment

@typing.final
class MessageRef(google.protobuf.message.Message):
    """Message reference"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    MESSAGE_ID_FIELD_NUMBER: builtins.int
    MESSAGE_REF_ID_FIELD_NUMBER: builtins.int
    CONTENT_FIELD_NUMBER: builtins.int
    HAS_ATTACHMENT_FIELD_NUMBER: builtins.int
    REF_TYPE_FIELD_NUMBER: builtins.int
    MESSAGE_SENDER_ID_FIELD_NUMBER: builtins.int
    MESSAGE_SENDER_USERNAME_FIELD_NUMBER: builtins.int
    MESAGES_SENDER_AVATAR_FIELD_NUMBER: builtins.int
    MESSAGE_SENDER_CLAN_NICK_FIELD_NUMBER: builtins.int
    MESSAGE_SENDER_DISPLAY_NAME_FIELD_NUMBER: builtins.int
    message_id: builtins.str
    """A message source"""
    message_ref_id: builtins.str
    """A message reference to"""
    content: builtins.str
    """content reference"""
    has_attachment: builtins.bool
    """has attachment"""
    ref_type: builtins.int
    """Reference type. 0: reply"""
    message_sender_id: builtins.str
    """original message sender"""
    message_sender_username: builtins.str
    """original message sendre username"""
    mesages_sender_avatar: builtins.str
    """original message sender avatar"""
    message_sender_clan_nick: builtins.str
    """original sender clan nick name"""
    message_sender_display_name: builtins.str
    """original sender display name"""
    def __init__(
        self,
        *,
        message_id: builtins.str = ...,
        message_ref_id: builtins.str = ...,
        content: builtins.str = ...,
        has_attachment: builtins.bool = ...,
        ref_type: builtins.int = ...,
        message_sender_id: builtins.str = ...,
        message_sender_username: builtins.str = ...,
        mesages_sender_avatar: builtins.str = ...,
        message_sender_clan_nick: builtins.str = ...,
        message_sender_display_name: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["content", b"content", "has_attachment", b"has_attachment", "mesages_sender_avatar", b"mesages_sender_avatar", "message_id", b"message_id", "message_ref_id", b"message_ref_id", "message_sender_clan_nick", b"message_sender_clan_nick", "message_sender_display_name", b"message_sender_display_name", "message_sender_id", b"message_sender_id", "message_sender_username", b"message_sender_username", "ref_type", b"ref_type"]) -> None: ...

global___MessageRef = MessageRef

@typing.final
class MessageDeleted(google.protobuf.message.Message):
    """Message reference"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    MESSAGE_ID_FIELD_NUMBER: builtins.int
    DELETOR_FIELD_NUMBER: builtins.int
    message_id: builtins.str
    """A deleted message source"""
    deletor: builtins.str
    """Who delete it"""
    def __init__(
        self,
        *,
        message_id: builtins.str = ...,
        deletor: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["deletor", b"deletor", "message_id", b"message_id"]) -> None: ...

global___MessageDeleted = MessageDeleted

@typing.final
class ChannelMessageList(google.protobuf.message.Message):
    """A list of channel messages, usually a result of a list operation."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    MESSAGES_FIELD_NUMBER: builtins.int
    LAST_SEEN_MESSAGE_FIELD_NUMBER: builtins.int
    LAST_SENT_MESSAGE_FIELD_NUMBER: builtins.int
    @property
    def messages(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___ChannelMessage]:
        """A list of messages."""

    @property
    def last_seen_message(self) -> global___ChannelMessageHeader:
        """last seen message id by user"""

    @property
    def last_sent_message(self) -> global___ChannelMessageHeader:
        """last sent message id"""

    def __init__(
        self,
        *,
        messages: collections.abc.Iterable[global___ChannelMessage] | None = ...,
        last_seen_message: global___ChannelMessageHeader | None = ...,
        last_sent_message: global___ChannelMessageHeader | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["last_seen_message", b"last_seen_message", "last_sent_message", b"last_sent_message"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["last_seen_message", b"last_seen_message", "last_sent_message", b"last_sent_message", "messages", b"messages"]) -> None: ...

global___ChannelMessageList = ChannelMessageList

@typing.final
class CreateGroupRequest(google.protobuf.message.Message):
    """Create a group with the current user as owner."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    NAME_FIELD_NUMBER: builtins.int
    DESCRIPTION_FIELD_NUMBER: builtins.int
    LANG_TAG_FIELD_NUMBER: builtins.int
    AVATAR_URL_FIELD_NUMBER: builtins.int
    OPEN_FIELD_NUMBER: builtins.int
    MAX_COUNT_FIELD_NUMBER: builtins.int
    name: builtins.str
    """A unique name for the group."""
    description: builtins.str
    """A description for the group."""
    lang_tag: builtins.str
    """The language expected to be a tag which follows the BCP-47 spec."""
    avatar_url: builtins.str
    """A URL for an avatar image."""
    open: builtins.bool
    """Mark a group as open or not where only admins can accept members."""
    max_count: builtins.int
    """Maximum number of group members."""
    def __init__(
        self,
        *,
        name: builtins.str = ...,
        description: builtins.str = ...,
        lang_tag: builtins.str = ...,
        avatar_url: builtins.str = ...,
        open: builtins.bool = ...,
        max_count: builtins.int = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["avatar_url", b"avatar_url", "description", b"description", "lang_tag", b"lang_tag", "max_count", b"max_count", "name", b"name", "open", b"open"]) -> None: ...

global___CreateGroupRequest = CreateGroupRequest

@typing.final
class DeleteFriendsRequest(google.protobuf.message.Message):
    """Delete one or more friends for the current user."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    IDS_FIELD_NUMBER: builtins.int
    USERNAMES_FIELD_NUMBER: builtins.int
    @property
    def ids(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """The account id of a user."""

    @property
    def usernames(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """The account username of a user."""

    def __init__(
        self,
        *,
        ids: collections.abc.Iterable[builtins.str] | None = ...,
        usernames: collections.abc.Iterable[builtins.str] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["ids", b"ids", "usernames", b"usernames"]) -> None: ...

global___DeleteFriendsRequest = DeleteFriendsRequest

@typing.final
class DeleteGroupRequest(google.protobuf.message.Message):
    """Delete a group the user has access to."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    GROUP_ID_FIELD_NUMBER: builtins.int
    group_id: builtins.str
    """The id of a group."""
    def __init__(
        self,
        *,
        group_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["group_id", b"group_id"]) -> None: ...

global___DeleteGroupRequest = DeleteGroupRequest

@typing.final
class DeleteNotificationsRequest(google.protobuf.message.Message):
    """Delete one or more notifications for the current user."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    IDS_FIELD_NUMBER: builtins.int
    CATEGORY_FIELD_NUMBER: builtins.int
    category: builtins.int
    """The category of notifications."""
    @property
    def ids(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """The id of notifications."""

    def __init__(
        self,
        *,
        ids: collections.abc.Iterable[builtins.str] | None = ...,
        category: builtins.int = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["category", b"category", "ids", b"ids"]) -> None: ...

global___DeleteNotificationsRequest = DeleteNotificationsRequest

@typing.final
class Event(google.protobuf.message.Message):
    """Represents an event to be passed through the server to registered event handlers."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    @typing.final
    class PropertiesEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.str
        value: builtins.str
        def __init__(
            self,
            *,
            key: builtins.str = ...,
            value: builtins.str = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing.Literal["key", b"key", "value", b"value"]) -> None: ...

    NAME_FIELD_NUMBER: builtins.int
    PROPERTIES_FIELD_NUMBER: builtins.int
    TIMESTAMP_FIELD_NUMBER: builtins.int
    EXTERNAL_FIELD_NUMBER: builtins.int
    name: builtins.str
    """An event name, type, category, or identifier."""
    external: builtins.bool
    """True if the event came directly from a client call, false otherwise."""
    @property
    def properties(self) -> google.protobuf.internal.containers.ScalarMap[builtins.str, builtins.str]:
        """Arbitrary event property values."""

    @property
    def timestamp(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """The time when the event was triggered."""

    def __init__(
        self,
        *,
        name: builtins.str = ...,
        properties: collections.abc.Mapping[builtins.str, builtins.str] | None = ...,
        timestamp: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        external: builtins.bool = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["timestamp", b"timestamp"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["external", b"external", "name", b"name", "properties", b"properties", "timestamp", b"timestamp"]) -> None: ...

global___Event = Event

@typing.final
class Friend(google.protobuf.message.Message):
    """A friend of a user."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    class _State:
        ValueType = typing.NewType("ValueType", builtins.int)
        V: typing_extensions.TypeAlias = ValueType

    class _StateEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[Friend._State.ValueType], builtins.type):
        DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
        FRIEND: Friend._State.ValueType  # 0
        """The user is a friend of the current user."""
        INVITE_SENT: Friend._State.ValueType  # 1
        """The current user has sent an invite to the user."""
        INVITE_RECEIVED: Friend._State.ValueType  # 2
        """The current user has received an invite from this user."""
        BLOCKED: Friend._State.ValueType  # 3
        """The current user has blocked this user."""

    class State(_State, metaclass=_StateEnumTypeWrapper):
        """The friendship status."""

    FRIEND: Friend.State.ValueType  # 0
    """The user is a friend of the current user."""
    INVITE_SENT: Friend.State.ValueType  # 1
    """The current user has sent an invite to the user."""
    INVITE_RECEIVED: Friend.State.ValueType  # 2
    """The current user has received an invite from this user."""
    BLOCKED: Friend.State.ValueType  # 3
    """The current user has blocked this user."""

    USER_FIELD_NUMBER: builtins.int
    STATE_FIELD_NUMBER: builtins.int
    UPDATE_TIME_FIELD_NUMBER: builtins.int
    SOURCE_ID_FIELD_NUMBER: builtins.int
    source_id: builtins.str
    """source id"""
    @property
    def user(self) -> global___User:
        """The user object."""

    @property
    def state(self) -> google.protobuf.wrappers_pb2.Int32Value:
        """The friend status.
        one of "Friend.State".
        """

    @property
    def update_time(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """Time of the latest relationship update."""

    def __init__(
        self,
        *,
        user: global___User | None = ...,
        state: google.protobuf.wrappers_pb2.Int32Value | None = ...,
        update_time: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        source_id: builtins.str = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["state", b"state", "update_time", b"update_time", "user", b"user"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["source_id", b"source_id", "state", b"state", "update_time", b"update_time", "user", b"user"]) -> None: ...

global___Friend = Friend

@typing.final
class FriendList(google.protobuf.message.Message):
    """A collection of zero or more friends of the user."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    FRIENDS_FIELD_NUMBER: builtins.int
    CURSOR_FIELD_NUMBER: builtins.int
    cursor: builtins.str
    """Cursor for the next page of results, if any."""
    @property
    def friends(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___Friend]:
        """The Friend objects."""

    def __init__(
        self,
        *,
        friends: collections.abc.Iterable[global___Friend] | None = ...,
        cursor: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["cursor", b"cursor", "friends", b"friends"]) -> None: ...

global___FriendList = FriendList

@typing.final
class UpdateUsersRequest(google.protobuf.message.Message):
    """Fetch a batch of zero or more users from the server."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    DISPLAY_NAME_FIELD_NUMBER: builtins.int
    AVATAR_URL_FIELD_NUMBER: builtins.int
    display_name: builtins.str
    """The account username of a user."""
    avatar_url: builtins.str
    """The avarar_url of a user."""
    def __init__(
        self,
        *,
        display_name: builtins.str = ...,
        avatar_url: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["avatar_url", b"avatar_url", "display_name", b"display_name"]) -> None: ...

global___UpdateUsersRequest = UpdateUsersRequest

@typing.final
class ChannelUserList(google.protobuf.message.Message):
    """A list of users belonging to a channel, along with their role."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    @typing.final
    class ChannelUser(google.protobuf.message.Message):
        """A single user-role pair."""

        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        USER_ID_FIELD_NUMBER: builtins.int
        ROLE_ID_FIELD_NUMBER: builtins.int
        ID_FIELD_NUMBER: builtins.int
        THREAD_ID_FIELD_NUMBER: builtins.int
        CLAN_NICK_FIELD_NUMBER: builtins.int
        CLAN_AVATAR_FIELD_NUMBER: builtins.int
        CLAN_ID_FIELD_NUMBER: builtins.int
        ADDED_BY_FIELD_NUMBER: builtins.int
        IS_BANNED_FIELD_NUMBER: builtins.int
        user_id: builtins.str
        """User."""
        id: builtins.str
        """Id"""
        thread_id: builtins.str
        """thread id"""
        clan_nick: builtins.str
        """clan nick name"""
        clan_avatar: builtins.str
        """clan avatar"""
        clan_id: builtins.str
        """clan Id"""
        added_by: builtins.str
        """added by"""
        is_banned: builtins.bool
        """is banned"""
        @property
        def role_id(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
            """Their relationship to the role."""

        def __init__(
            self,
            *,
            user_id: builtins.str = ...,
            role_id: collections.abc.Iterable[builtins.str] | None = ...,
            id: builtins.str = ...,
            thread_id: builtins.str = ...,
            clan_nick: builtins.str = ...,
            clan_avatar: builtins.str = ...,
            clan_id: builtins.str = ...,
            added_by: builtins.str = ...,
            is_banned: builtins.bool = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing.Literal["added_by", b"added_by", "clan_avatar", b"clan_avatar", "clan_id", b"clan_id", "clan_nick", b"clan_nick", "id", b"id", "is_banned", b"is_banned", "role_id", b"role_id", "thread_id", b"thread_id", "user_id", b"user_id"]) -> None: ...

    CHANNEL_USERS_FIELD_NUMBER: builtins.int
    CURSOR_FIELD_NUMBER: builtins.int
    CHANNEL_ID_FIELD_NUMBER: builtins.int
    cursor: builtins.str
    """Cursor for the next page of results, if any."""
    channel_id: builtins.str
    """channel id"""
    @property
    def channel_users(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___ChannelUserList.ChannelUser]:
        """User-role pairs for a channel."""

    def __init__(
        self,
        *,
        channel_users: collections.abc.Iterable[global___ChannelUserList.ChannelUser] | None = ...,
        cursor: builtins.str = ...,
        channel_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["channel_id", b"channel_id", "channel_users", b"channel_users", "cursor", b"cursor"]) -> None: ...

global___ChannelUserList = ChannelUserList

@typing.final
class VoiceChannelUser(google.protobuf.message.Message):
    """A list of users belonging to a channel, along with their role."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ID_FIELD_NUMBER: builtins.int
    USER_ID_FIELD_NUMBER: builtins.int
    CHANNEL_ID_FIELD_NUMBER: builtins.int
    PARTICIPANT_FIELD_NUMBER: builtins.int
    id: builtins.str
    """voice user join id"""
    user_id: builtins.str
    """User for a channel."""
    channel_id: builtins.str
    """channel id"""
    participant: builtins.str
    """participant"""
    def __init__(
        self,
        *,
        id: builtins.str = ...,
        user_id: builtins.str = ...,
        channel_id: builtins.str = ...,
        participant: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["channel_id", b"channel_id", "id", b"id", "participant", b"participant", "user_id", b"user_id"]) -> None: ...

global___VoiceChannelUser = VoiceChannelUser

@typing.final
class VoiceChannelUserList(google.protobuf.message.Message):
    """A list of users belonging to a channel, along with their role."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    VOICE_CHANNEL_USERS_FIELD_NUMBER: builtins.int
    @property
    def voice_channel_users(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___VoiceChannelUser]:
        """list of voice channel user"""

    def __init__(
        self,
        *,
        voice_channel_users: collections.abc.Iterable[global___VoiceChannelUser] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["voice_channel_users", b"voice_channel_users"]) -> None: ...

global___VoiceChannelUserList = VoiceChannelUserList

@typing.final
class ChannelAttachment(google.protobuf.message.Message):
    """channel attachment"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ID_FIELD_NUMBER: builtins.int
    FILENAME_FIELD_NUMBER: builtins.int
    FILETYPE_FIELD_NUMBER: builtins.int
    FILESIZE_FIELD_NUMBER: builtins.int
    URL_FIELD_NUMBER: builtins.int
    UPLOADER_FIELD_NUMBER: builtins.int
    CREATE_TIME_FIELD_NUMBER: builtins.int
    MESSAGE_ID_FIELD_NUMBER: builtins.int
    WIDTH_FIELD_NUMBER: builtins.int
    HEIGHT_FIELD_NUMBER: builtins.int
    id: builtins.str
    """url attachment"""
    filename: builtins.str
    """file name"""
    filetype: builtins.str
    """filetype"""
    filesize: builtins.str
    """size"""
    url: builtins.str
    """url"""
    uploader: builtins.str
    """uploader"""
    message_id: builtins.str
    """message id."""
    width: builtins.int
    """width"""
    height: builtins.int
    """height"""
    @property
    def create_time(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """The UNIX time (for gRPC clients) or ISO string (for REST clients) when the group was created."""

    def __init__(
        self,
        *,
        id: builtins.str = ...,
        filename: builtins.str = ...,
        filetype: builtins.str = ...,
        filesize: builtins.str = ...,
        url: builtins.str = ...,
        uploader: builtins.str = ...,
        create_time: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        message_id: builtins.str = ...,
        width: builtins.int = ...,
        height: builtins.int = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["create_time", b"create_time"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["create_time", b"create_time", "filename", b"filename", "filesize", b"filesize", "filetype", b"filetype", "height", b"height", "id", b"id", "message_id", b"message_id", "uploader", b"uploader", "url", b"url", "width", b"width"]) -> None: ...

global___ChannelAttachment = ChannelAttachment

@typing.final
class ChannelAttachmentList(google.protobuf.message.Message):
    """channel attachment list"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ATTACHMENTS_FIELD_NUMBER: builtins.int
    @property
    def attachments(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___ChannelAttachment]:
        """list attachment"""

    def __init__(
        self,
        *,
        attachments: collections.abc.Iterable[global___ChannelAttachment] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["attachments", b"attachments"]) -> None: ...

global___ChannelAttachmentList = ChannelAttachmentList

@typing.final
class ClanUserList(google.protobuf.message.Message):
    """A list of users belonging to a clan, along with their role."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    @typing.final
    class ClanUser(google.protobuf.message.Message):
        """A single user-role pair."""

        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        USER_FIELD_NUMBER: builtins.int
        ROLE_ID_FIELD_NUMBER: builtins.int
        CLAN_NICK_FIELD_NUMBER: builtins.int
        CLAN_AVATAR_FIELD_NUMBER: builtins.int
        CLAN_ID_FIELD_NUMBER: builtins.int
        clan_nick: builtins.str
        """from the `nick_name` field in the `clan_desc_profile` table."""
        clan_avatar: builtins.str
        """from the `avatar_url` field in the `clan_desc_profile` table."""
        clan_id: builtins.str
        """"""
        @property
        def user(self) -> global___User:
            """User."""

        @property
        def role_id(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
            """Their relationship to the role."""

        def __init__(
            self,
            *,
            user: global___User | None = ...,
            role_id: collections.abc.Iterable[builtins.str] | None = ...,
            clan_nick: builtins.str = ...,
            clan_avatar: builtins.str = ...,
            clan_id: builtins.str = ...,
        ) -> None: ...
        def HasField(self, field_name: typing.Literal["user", b"user"]) -> builtins.bool: ...
        def ClearField(self, field_name: typing.Literal["clan_avatar", b"clan_avatar", "clan_id", b"clan_id", "clan_nick", b"clan_nick", "role_id", b"role_id", "user", b"user"]) -> None: ...

    CLAN_USERS_FIELD_NUMBER: builtins.int
    CURSOR_FIELD_NUMBER: builtins.int
    CLAN_ID_FIELD_NUMBER: builtins.int
    cursor: builtins.str
    """Cursor for the next page of results, if any."""
    clan_id: builtins.str
    """clan id"""
    @property
    def clan_users(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___ClanUserList.ClanUser]:
        """User-role pairs for a clan."""

    def __init__(
        self,
        *,
        clan_users: collections.abc.Iterable[global___ClanUserList.ClanUser] | None = ...,
        cursor: builtins.str = ...,
        clan_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["clan_id", b"clan_id", "clan_users", b"clan_users", "cursor", b"cursor"]) -> None: ...

global___ClanUserList = ClanUserList

@typing.final
class RegistFcmDeviceTokenRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    TOKEN_FIELD_NUMBER: builtins.int
    DEVICE_ID_FIELD_NUMBER: builtins.int
    PLATFORM_FIELD_NUMBER: builtins.int
    VOIP_TOKEN_FIELD_NUMBER: builtins.int
    token: builtins.str
    """The token"""
    device_id: builtins.str
    """"""
    platform: builtins.str
    """"""
    voip_token: builtins.str
    """voip token for IOS"""
    def __init__(
        self,
        *,
        token: builtins.str = ...,
        device_id: builtins.str = ...,
        platform: builtins.str = ...,
        voip_token: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["device_id", b"device_id", "platform", b"platform", "token", b"token", "voip_token", b"voip_token"]) -> None: ...

global___RegistFcmDeviceTokenRequest = RegistFcmDeviceTokenRequest

@typing.final
class RegistFcmDeviceTokenResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    TOKEN_FIELD_NUMBER: builtins.int
    DEVICE_ID_FIELD_NUMBER: builtins.int
    PLATFORM_FIELD_NUMBER: builtins.int
    token: builtins.str
    """The token"""
    device_id: builtins.str
    """"""
    platform: builtins.str
    """"""
    def __init__(
        self,
        *,
        token: builtins.str = ...,
        device_id: builtins.str = ...,
        platform: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["device_id", b"device_id", "platform", b"platform", "token", b"token"]) -> None: ...

global___RegistFcmDeviceTokenResponse = RegistFcmDeviceTokenResponse

@typing.final
class ListChannelMessagesRequest(google.protobuf.message.Message):
    """List a channel's message history."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CLAN_ID_FIELD_NUMBER: builtins.int
    CHANNEL_ID_FIELD_NUMBER: builtins.int
    MESSAGE_ID_FIELD_NUMBER: builtins.int
    LIMIT_FIELD_NUMBER: builtins.int
    DIRECTION_FIELD_NUMBER: builtins.int
    TOPIC_ID_FIELD_NUMBER: builtins.int
    clan_id: builtins.str
    """the clan id"""
    channel_id: builtins.str
    """The channel ID to list from."""
    message_id: builtins.str
    """The current message ID."""
    topic_id: builtins.str
    """"""
    @property
    def limit(self) -> google.protobuf.wrappers_pb2.Int32Value:
        """Max number of records to return. Between 1 and 100."""

    @property
    def direction(self) -> google.protobuf.wrappers_pb2.Int32Value:
        """True if listing should be older messages to newer, false if reverse."""

    def __init__(
        self,
        *,
        clan_id: builtins.str = ...,
        channel_id: builtins.str = ...,
        message_id: builtins.str = ...,
        limit: google.protobuf.wrappers_pb2.Int32Value | None = ...,
        direction: google.protobuf.wrappers_pb2.Int32Value | None = ...,
        topic_id: builtins.str = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["direction", b"direction", "limit", b"limit"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["channel_id", b"channel_id", "clan_id", b"clan_id", "direction", b"direction", "limit", b"limit", "message_id", b"message_id", "topic_id", b"topic_id"]) -> None: ...

global___ListChannelMessagesRequest = ListChannelMessagesRequest

@typing.final
class ListFriendsRequest(google.protobuf.message.Message):
    """List friends for a user."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    LIMIT_FIELD_NUMBER: builtins.int
    STATE_FIELD_NUMBER: builtins.int
    CURSOR_FIELD_NUMBER: builtins.int
    cursor: builtins.str
    """An optional next page cursor."""
    @property
    def limit(self) -> google.protobuf.wrappers_pb2.Int32Value:
        """Max number of records to return. Between 1 and 100."""

    @property
    def state(self) -> google.protobuf.wrappers_pb2.Int32Value:
        """The friend state to list."""

    def __init__(
        self,
        *,
        limit: google.protobuf.wrappers_pb2.Int32Value | None = ...,
        state: google.protobuf.wrappers_pb2.Int32Value | None = ...,
        cursor: builtins.str = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["limit", b"limit", "state", b"state"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["cursor", b"cursor", "limit", b"limit", "state", b"state"]) -> None: ...

global___ListFriendsRequest = ListFriendsRequest

@typing.final
class ListGroupsRequest(google.protobuf.message.Message):
    """List groups based on given filters."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    NAME_FIELD_NUMBER: builtins.int
    CURSOR_FIELD_NUMBER: builtins.int
    LIMIT_FIELD_NUMBER: builtins.int
    LANG_TAG_FIELD_NUMBER: builtins.int
    MEMBERS_FIELD_NUMBER: builtins.int
    OPEN_FIELD_NUMBER: builtins.int
    name: builtins.str
    """List groups that contain this value in their names."""
    cursor: builtins.str
    """Optional pagination cursor."""
    lang_tag: builtins.str
    """Language tag filter"""
    @property
    def limit(self) -> google.protobuf.wrappers_pb2.Int32Value:
        """Max number of groups to return. Between 1 and 100."""

    @property
    def members(self) -> google.protobuf.wrappers_pb2.Int32Value:
        """Number of group members"""

    @property
    def open(self) -> google.protobuf.wrappers_pb2.BoolValue:
        """Optional Open/Closed filter."""

    def __init__(
        self,
        *,
        name: builtins.str = ...,
        cursor: builtins.str = ...,
        limit: google.protobuf.wrappers_pb2.Int32Value | None = ...,
        lang_tag: builtins.str = ...,
        members: google.protobuf.wrappers_pb2.Int32Value | None = ...,
        open: google.protobuf.wrappers_pb2.BoolValue | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["limit", b"limit", "members", b"members", "open", b"open"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["cursor", b"cursor", "lang_tag", b"lang_tag", "limit", b"limit", "members", b"members", "name", b"name", "open", b"open"]) -> None: ...

global___ListGroupsRequest = ListGroupsRequest

@typing.final
class ListGroupUsersRequest(google.protobuf.message.Message):
    """List all users that are part of a group."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    GROUP_ID_FIELD_NUMBER: builtins.int
    LIMIT_FIELD_NUMBER: builtins.int
    STATE_FIELD_NUMBER: builtins.int
    CURSOR_FIELD_NUMBER: builtins.int
    group_id: builtins.str
    """The group ID to list from."""
    cursor: builtins.str
    """An optional next page cursor."""
    @property
    def limit(self) -> google.protobuf.wrappers_pb2.Int32Value:
        """Max number of records to return. Between 1 and 100."""

    @property
    def state(self) -> google.protobuf.wrappers_pb2.Int32Value:
        """The group user state to list."""

    def __init__(
        self,
        *,
        group_id: builtins.str = ...,
        limit: google.protobuf.wrappers_pb2.Int32Value | None = ...,
        state: google.protobuf.wrappers_pb2.Int32Value | None = ...,
        cursor: builtins.str = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["limit", b"limit", "state", b"state"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["cursor", b"cursor", "group_id", b"group_id", "limit", b"limit", "state", b"state"]) -> None: ...

global___ListGroupUsersRequest = ListGroupUsersRequest

@typing.final
class ListChannelUsersRequest(google.protobuf.message.Message):
    """List all users that are part of a channel."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CLAN_ID_FIELD_NUMBER: builtins.int
    CHANNEL_ID_FIELD_NUMBER: builtins.int
    CHANNEL_TYPE_FIELD_NUMBER: builtins.int
    LIMIT_FIELD_NUMBER: builtins.int
    STATE_FIELD_NUMBER: builtins.int
    CURSOR_FIELD_NUMBER: builtins.int
    clan_id: builtins.str
    """The clan id"""
    channel_id: builtins.str
    """The channel ID to list from."""
    channel_type: builtins.int
    """The channel type"""
    cursor: builtins.str
    """An optional next page cursor."""
    @property
    def limit(self) -> google.protobuf.wrappers_pb2.Int32Value:
        """Max number of records to return. Between 1 and 100."""

    @property
    def state(self) -> google.protobuf.wrappers_pb2.Int32Value:
        """The group user state to list."""

    def __init__(
        self,
        *,
        clan_id: builtins.str = ...,
        channel_id: builtins.str = ...,
        channel_type: builtins.int = ...,
        limit: google.protobuf.wrappers_pb2.Int32Value | None = ...,
        state: google.protobuf.wrappers_pb2.Int32Value | None = ...,
        cursor: builtins.str = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["limit", b"limit", "state", b"state"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["channel_id", b"channel_id", "channel_type", b"channel_type", "clan_id", b"clan_id", "cursor", b"cursor", "limit", b"limit", "state", b"state"]) -> None: ...

global___ListChannelUsersRequest = ListChannelUsersRequest

@typing.final
class ListChannelAttachmentRequest(google.protobuf.message.Message):
    """List all attachments that are part of a channel."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CLAN_ID_FIELD_NUMBER: builtins.int
    CHANNEL_ID_FIELD_NUMBER: builtins.int
    FILE_TYPE_FIELD_NUMBER: builtins.int
    LIMIT_FIELD_NUMBER: builtins.int
    STATE_FIELD_NUMBER: builtins.int
    BEFORE_FIELD_NUMBER: builtins.int
    AFTER_FIELD_NUMBER: builtins.int
    AROUND_FIELD_NUMBER: builtins.int
    clan_id: builtins.str
    """The clan id"""
    channel_id: builtins.str
    """The channel ID to list from."""
    file_type: builtins.str
    """The channel type"""
    before: builtins.int
    """An optional previous id for page."""
    after: builtins.int
    """An optional next id for page."""
    around: builtins.int
    """An optional around id for page."""
    @property
    def limit(self) -> google.protobuf.wrappers_pb2.Int32Value:
        """Max number of records to return. Between 1 and 100."""

    @property
    def state(self) -> google.protobuf.wrappers_pb2.Int32Value:
        """The group user state to list."""

    def __init__(
        self,
        *,
        clan_id: builtins.str = ...,
        channel_id: builtins.str = ...,
        file_type: builtins.str = ...,
        limit: google.protobuf.wrappers_pb2.Int32Value | None = ...,
        state: google.protobuf.wrappers_pb2.Int32Value | None = ...,
        before: builtins.int = ...,
        after: builtins.int = ...,
        around: builtins.int = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["limit", b"limit", "state", b"state"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["after", b"after", "around", b"around", "before", b"before", "channel_id", b"channel_id", "clan_id", b"clan_id", "file_type", b"file_type", "limit", b"limit", "state", b"state"]) -> None: ...

global___ListChannelAttachmentRequest = ListChannelAttachmentRequest

@typing.final
class ListClanUsersRequest(google.protobuf.message.Message):
    """List all users that are part of a clan."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CLAN_ID_FIELD_NUMBER: builtins.int
    clan_id: builtins.str
    """The clan ID to list from."""
    def __init__(
        self,
        *,
        clan_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["clan_id", b"clan_id"]) -> None: ...

global___ListClanUsersRequest = ListClanUsersRequest

@typing.final
class ListNotificationsRequest(google.protobuf.message.Message):
    """Get a list of unexpired notifications."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    LIMIT_FIELD_NUMBER: builtins.int
    CLAN_ID_FIELD_NUMBER: builtins.int
    NOTIFICATION_ID_FIELD_NUMBER: builtins.int
    CATEGORY_FIELD_NUMBER: builtins.int
    DIRECTION_FIELD_NUMBER: builtins.int
    clan_id: builtins.str
    """The clan id"""
    notification_id: builtins.str
    """The current notification Id."""
    category: builtins.int
    """The category (1: mentions, 2: mesages, 3: for you)."""
    @property
    def limit(self) -> google.protobuf.wrappers_pb2.Int32Value:
        """The number of notifications to get. Between 1 and 100."""

    @property
    def direction(self) -> google.protobuf.wrappers_pb2.Int32Value:
        """True if listing should be older notifications to newer, false if reverse."""

    def __init__(
        self,
        *,
        limit: google.protobuf.wrappers_pb2.Int32Value | None = ...,
        clan_id: builtins.str = ...,
        notification_id: builtins.str = ...,
        category: builtins.int = ...,
        direction: google.protobuf.wrappers_pb2.Int32Value | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["direction", b"direction", "limit", b"limit"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["category", b"category", "clan_id", b"clan_id", "direction", b"direction", "limit", b"limit", "notification_id", b"notification_id"]) -> None: ...

global___ListNotificationsRequest = ListNotificationsRequest

@typing.final
class ListUserGroupsRequest(google.protobuf.message.Message):
    """List the groups a user is part of, and their relationship to each."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    USER_ID_FIELD_NUMBER: builtins.int
    LIMIT_FIELD_NUMBER: builtins.int
    STATE_FIELD_NUMBER: builtins.int
    CURSOR_FIELD_NUMBER: builtins.int
    user_id: builtins.str
    """ID of the user."""
    cursor: builtins.str
    """An optional next page cursor."""
    @property
    def limit(self) -> google.protobuf.wrappers_pb2.Int32Value:
        """Max number of records to return. Between 1 and 100."""

    @property
    def state(self) -> google.protobuf.wrappers_pb2.Int32Value:
        """The user group state to list."""

    def __init__(
        self,
        *,
        user_id: builtins.str = ...,
        limit: google.protobuf.wrappers_pb2.Int32Value | None = ...,
        state: google.protobuf.wrappers_pb2.Int32Value | None = ...,
        cursor: builtins.str = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["limit", b"limit", "state", b"state"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["cursor", b"cursor", "limit", b"limit", "state", b"state", "user_id", b"user_id"]) -> None: ...

global___ListUserGroupsRequest = ListUserGroupsRequest

@typing.final
class Notification(google.protobuf.message.Message):
    """A notification in the server."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ID_FIELD_NUMBER: builtins.int
    SUBJECT_FIELD_NUMBER: builtins.int
    CONTENT_FIELD_NUMBER: builtins.int
    CODE_FIELD_NUMBER: builtins.int
    SENDER_ID_FIELD_NUMBER: builtins.int
    CREATE_TIME_FIELD_NUMBER: builtins.int
    PERSISTENT_FIELD_NUMBER: builtins.int
    CLAN_ID_FIELD_NUMBER: builtins.int
    CHANNEL_ID_FIELD_NUMBER: builtins.int
    CHANNEL_TYPE_FIELD_NUMBER: builtins.int
    AVATAR_URL_FIELD_NUMBER: builtins.int
    CHANNEL_FIELD_NUMBER: builtins.int
    TOPIC_ID_FIELD_NUMBER: builtins.int
    CATEGORY_FIELD_NUMBER: builtins.int
    id: builtins.str
    """ID of the Notification."""
    subject: builtins.str
    """Subject of the notification."""
    content: builtins.str
    """Content of the notification in JSON."""
    code: builtins.int
    """Category code for this notification."""
    sender_id: builtins.str
    """ID of the sender, if a user. Otherwise 'null'."""
    persistent: builtins.bool
    """True if this notification was persisted to the database."""
    clan_id: builtins.str
    """ID of clan"""
    channel_id: builtins.str
    """ID of channel"""
    channel_type: builtins.int
    """mode of"""
    avatar_url: builtins.str
    """"""
    topic_id: builtins.str
    """"""
    category: builtins.int
    """category."""
    @property
    def create_time(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """The UNIX time (for gRPC clients) or ISO string (for REST clients) when the notification was created."""

    @property
    def channel(self) -> global___ChannelDescription:
        """"""

    def __init__(
        self,
        *,
        id: builtins.str = ...,
        subject: builtins.str = ...,
        content: builtins.str = ...,
        code: builtins.int = ...,
        sender_id: builtins.str = ...,
        create_time: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        persistent: builtins.bool = ...,
        clan_id: builtins.str = ...,
        channel_id: builtins.str = ...,
        channel_type: builtins.int = ...,
        avatar_url: builtins.str = ...,
        channel: global___ChannelDescription | None = ...,
        topic_id: builtins.str = ...,
        category: builtins.int = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["channel", b"channel", "create_time", b"create_time"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["avatar_url", b"avatar_url", "category", b"category", "channel", b"channel", "channel_id", b"channel_id", "channel_type", b"channel_type", "clan_id", b"clan_id", "code", b"code", "content", b"content", "create_time", b"create_time", "id", b"id", "persistent", b"persistent", "sender_id", b"sender_id", "subject", b"subject", "topic_id", b"topic_id"]) -> None: ...

global___Notification = Notification

@typing.final
class EmojiRecent(google.protobuf.message.Message):
    """"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    EMOJI_RECENTS_ID_FIELD_NUMBER: builtins.int
    EMOJI_ID_FIELD_NUMBER: builtins.int
    UPDATE_TIME_FIELD_NUMBER: builtins.int
    emoji_recents_id: builtins.str
    """ID of the emoji."""
    emoji_id: builtins.str
    """"""
    @property
    def update_time(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """The UNIX time (for gRPC clients) or ISO string (for REST clients) when the emoji was created."""

    def __init__(
        self,
        *,
        emoji_recents_id: builtins.str = ...,
        emoji_id: builtins.str = ...,
        update_time: google.protobuf.timestamp_pb2.Timestamp | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["update_time", b"update_time"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["emoji_id", b"emoji_id", "emoji_recents_id", b"emoji_recents_id", "update_time", b"update_time"]) -> None: ...

global___EmojiRecent = EmojiRecent

@typing.final
class EmojiRecentList(google.protobuf.message.Message):
    """A collection of zero or more notifications."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    EMOJI_RECENTS_FIELD_NUMBER: builtins.int
    @property
    def emoji_recents(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___EmojiRecent]:
        """Collection of emojiRecents."""

    def __init__(
        self,
        *,
        emoji_recents: collections.abc.Iterable[global___EmojiRecent] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["emoji_recents", b"emoji_recents"]) -> None: ...

global___EmojiRecentList = EmojiRecentList

@typing.final
class NotificationList(google.protobuf.message.Message):
    """A collection of zero or more notifications."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    NOTIFICATIONS_FIELD_NUMBER: builtins.int
    CACHEABLE_CURSOR_FIELD_NUMBER: builtins.int
    cacheable_cursor: builtins.str
    """Use this cursor to paginate notifications. Cache this to catch up to new notifications."""
    @property
    def notifications(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___Notification]:
        """Collection of notifications."""

    def __init__(
        self,
        *,
        notifications: collections.abc.Iterable[global___Notification] | None = ...,
        cacheable_cursor: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["cacheable_cursor", b"cacheable_cursor", "notifications", b"notifications"]) -> None: ...

global___NotificationList = NotificationList

@typing.final
class PromoteGroupUsersRequest(google.protobuf.message.Message):
    """Promote a set of users in a group to the next role up."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    GROUP_ID_FIELD_NUMBER: builtins.int
    USER_IDS_FIELD_NUMBER: builtins.int
    group_id: builtins.str
    """The group ID to promote in."""
    @property
    def user_ids(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """The users to promote."""

    def __init__(
        self,
        *,
        group_id: builtins.str = ...,
        user_ids: collections.abc.Iterable[builtins.str] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["group_id", b"group_id", "user_ids", b"user_ids"]) -> None: ...

global___PromoteGroupUsersRequest = PromoteGroupUsersRequest

@typing.final
class DemoteGroupUsersRequest(google.protobuf.message.Message):
    """Demote a set of users in a group to the next role down."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    GROUP_ID_FIELD_NUMBER: builtins.int
    USER_IDS_FIELD_NUMBER: builtins.int
    group_id: builtins.str
    """The group ID to demote in."""
    @property
    def user_ids(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """The users to demote."""

    def __init__(
        self,
        *,
        group_id: builtins.str = ...,
        user_ids: collections.abc.Iterable[builtins.str] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["group_id", b"group_id", "user_ids", b"user_ids"]) -> None: ...

global___DemoteGroupUsersRequest = DemoteGroupUsersRequest

@typing.final
class Rpc(google.protobuf.message.Message):
    """Execute an Lua function on the server."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ID_FIELD_NUMBER: builtins.int
    PAYLOAD_FIELD_NUMBER: builtins.int
    HTTP_KEY_FIELD_NUMBER: builtins.int
    id: builtins.str
    """The identifier of the function."""
    payload: builtins.str
    """The payload of the function which must be a JSON object."""
    http_key: builtins.str
    """The authentication key used when executed as a non-client HTTP request."""
    def __init__(
        self,
        *,
        id: builtins.str = ...,
        payload: builtins.str = ...,
        http_key: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["http_key", b"http_key", "id", b"id", "payload", b"payload"]) -> None: ...

global___Rpc = Rpc

@typing.final
class Session(google.protobuf.message.Message):
    """A user's session used to authenticate messages."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CREATED_FIELD_NUMBER: builtins.int
    TOKEN_FIELD_NUMBER: builtins.int
    REFRESH_TOKEN_FIELD_NUMBER: builtins.int
    USER_ID_FIELD_NUMBER: builtins.int
    IS_REMEMBER_FIELD_NUMBER: builtins.int
    created: builtins.bool
    """True if the corresponding account was just created, false otherwise."""
    token: builtins.str
    """Authentication credentials."""
    refresh_token: builtins.str
    """Refresh token that can be used for session token renewal."""
    user_id: builtins.str
    """User id"""
    is_remember: builtins.bool
    """Whether to enable "Remember Me" for extended session duration."""
    def __init__(
        self,
        *,
        created: builtins.bool = ...,
        token: builtins.str = ...,
        refresh_token: builtins.str = ...,
        user_id: builtins.str = ...,
        is_remember: builtins.bool = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["created", b"created", "is_remember", b"is_remember", "refresh_token", b"refresh_token", "token", b"token", "user_id", b"user_id"]) -> None: ...

global___Session = Session

@typing.final
class UpdateUsernameRequest(google.protobuf.message.Message):
    """Update username"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    USERNAME_FIELD_NUMBER: builtins.int
    username: builtins.str
    def __init__(
        self,
        *,
        username: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["username", b"username"]) -> None: ...

global___UpdateUsernameRequest = UpdateUsernameRequest

@typing.final
class UpdateAccountRequest(google.protobuf.message.Message):
    """Update a user's account details."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    DISPLAY_NAME_FIELD_NUMBER: builtins.int
    AVATAR_URL_FIELD_NUMBER: builtins.int
    LANG_TAG_FIELD_NUMBER: builtins.int
    LOCATION_FIELD_NUMBER: builtins.int
    TIMEZONE_FIELD_NUMBER: builtins.int
    ABOUT_ME_FIELD_NUMBER: builtins.int
    DOB_FIELD_NUMBER: builtins.int
    LOGO_FIELD_NUMBER: builtins.int
    SPLASH_SCREEN_FIELD_NUMBER: builtins.int
    ENCRYPT_PRIVATE_KEY_FIELD_NUMBER: builtins.int
    EMAIL_FIELD_NUMBER: builtins.int
    encrypt_private_key: builtins.str
    """e2ee encrypt private key"""
    @property
    def display_name(self) -> google.protobuf.wrappers_pb2.StringValue:
        """The display name of the user."""

    @property
    def avatar_url(self) -> google.protobuf.wrappers_pb2.StringValue:
        """A URL for an avatar image."""

    @property
    def lang_tag(self) -> google.protobuf.wrappers_pb2.StringValue:
        """The language expected to be a tag which follows the BCP-47 spec."""

    @property
    def location(self) -> google.protobuf.wrappers_pb2.StringValue:
        """The location set by the user."""

    @property
    def timezone(self) -> google.protobuf.wrappers_pb2.StringValue:
        """The timezone set by the user."""

    @property
    def about_me(self) -> google.protobuf.wrappers_pb2.StringValue:
        """update about me"""

    @property
    def dob(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """date of birth"""

    @property
    def logo(self) -> google.protobuf.wrappers_pb2.StringValue:
        """logo url"""

    @property
    def splash_screen(self) -> google.protobuf.wrappers_pb2.StringValue:
        """splash screen"""

    @property
    def email(self) -> google.protobuf.wrappers_pb2.StringValue:
        """The email of the user's account."""

    def __init__(
        self,
        *,
        display_name: google.protobuf.wrappers_pb2.StringValue | None = ...,
        avatar_url: google.protobuf.wrappers_pb2.StringValue | None = ...,
        lang_tag: google.protobuf.wrappers_pb2.StringValue | None = ...,
        location: google.protobuf.wrappers_pb2.StringValue | None = ...,
        timezone: google.protobuf.wrappers_pb2.StringValue | None = ...,
        about_me: google.protobuf.wrappers_pb2.StringValue | None = ...,
        dob: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        logo: google.protobuf.wrappers_pb2.StringValue | None = ...,
        splash_screen: google.protobuf.wrappers_pb2.StringValue | None = ...,
        encrypt_private_key: builtins.str = ...,
        email: google.protobuf.wrappers_pb2.StringValue | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["about_me", b"about_me", "avatar_url", b"avatar_url", "display_name", b"display_name", "dob", b"dob", "email", b"email", "lang_tag", b"lang_tag", "location", b"location", "logo", b"logo", "splash_screen", b"splash_screen", "timezone", b"timezone"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["about_me", b"about_me", "avatar_url", b"avatar_url", "display_name", b"display_name", "dob", b"dob", "email", b"email", "encrypt_private_key", b"encrypt_private_key", "lang_tag", b"lang_tag", "location", b"location", "logo", b"logo", "splash_screen", b"splash_screen", "timezone", b"timezone"]) -> None: ...

global___UpdateAccountRequest = UpdateAccountRequest

@typing.final
class UpdateGroupRequest(google.protobuf.message.Message):
    """Update fields in a given group."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    GROUP_ID_FIELD_NUMBER: builtins.int
    NAME_FIELD_NUMBER: builtins.int
    DESCRIPTION_FIELD_NUMBER: builtins.int
    LANG_TAG_FIELD_NUMBER: builtins.int
    AVATAR_URL_FIELD_NUMBER: builtins.int
    OPEN_FIELD_NUMBER: builtins.int
    group_id: builtins.str
    """The ID of the group to update."""
    @property
    def name(self) -> google.protobuf.wrappers_pb2.StringValue:
        """Name."""

    @property
    def description(self) -> google.protobuf.wrappers_pb2.StringValue:
        """Description string."""

    @property
    def lang_tag(self) -> google.protobuf.wrappers_pb2.StringValue:
        """Lang tag."""

    @property
    def avatar_url(self) -> google.protobuf.wrappers_pb2.StringValue:
        """Avatar URL."""

    @property
    def open(self) -> google.protobuf.wrappers_pb2.BoolValue:
        """Open is true if anyone should be allowed to join, or false if joins must be approved by a group admin."""

    def __init__(
        self,
        *,
        group_id: builtins.str = ...,
        name: google.protobuf.wrappers_pb2.StringValue | None = ...,
        description: google.protobuf.wrappers_pb2.StringValue | None = ...,
        lang_tag: google.protobuf.wrappers_pb2.StringValue | None = ...,
        avatar_url: google.protobuf.wrappers_pb2.StringValue | None = ...,
        open: google.protobuf.wrappers_pb2.BoolValue | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["avatar_url", b"avatar_url", "description", b"description", "lang_tag", b"lang_tag", "name", b"name", "open", b"open"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["avatar_url", b"avatar_url", "description", b"description", "group_id", b"group_id", "lang_tag", b"lang_tag", "name", b"name", "open", b"open"]) -> None: ...

global___UpdateGroupRequest = UpdateGroupRequest

@typing.final
class UpdateCategoryDescRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CATEGORY_ID_FIELD_NUMBER: builtins.int
    CATEGORY_NAME_FIELD_NUMBER: builtins.int
    CLAN_ID_FIELD_NUMBER: builtins.int
    category_id: builtins.str
    """The ID of the group to update."""
    category_name: builtins.str
    clan_id: builtins.str
    def __init__(
        self,
        *,
        category_id: builtins.str = ...,
        category_name: builtins.str = ...,
        clan_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["category_id", b"category_id", "category_name", b"category_name", "clan_id", b"clan_id"]) -> None: ...

global___UpdateCategoryDescRequest = UpdateCategoryDescRequest

@typing.final
class User(google.protobuf.message.Message):
    """A user in the server."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ID_FIELD_NUMBER: builtins.int
    USERNAME_FIELD_NUMBER: builtins.int
    DISPLAY_NAME_FIELD_NUMBER: builtins.int
    AVATAR_URL_FIELD_NUMBER: builtins.int
    LANG_TAG_FIELD_NUMBER: builtins.int
    LOCATION_FIELD_NUMBER: builtins.int
    TIMEZONE_FIELD_NUMBER: builtins.int
    USER_STATUS_FIELD_NUMBER: builtins.int
    ONLINE_FIELD_NUMBER: builtins.int
    PHONE_NUMBER_FIELD_NUMBER: builtins.int
    EDGE_COUNT_FIELD_NUMBER: builtins.int
    CREATE_TIME_FIELD_NUMBER: builtins.int
    UPDATE_TIME_FIELD_NUMBER: builtins.int
    ABOUT_ME_FIELD_NUMBER: builtins.int
    JOIN_TIME_FIELD_NUMBER: builtins.int
    IS_MOBILE_FIELD_NUMBER: builtins.int
    DOB_FIELD_NUMBER: builtins.int
    MEZON_ID_FIELD_NUMBER: builtins.int
    LIST_NICK_NAMES_FIELD_NUMBER: builtins.int
    STATUS_FIELD_NUMBER: builtins.int
    id: builtins.str
    """The id of the user's account."""
    username: builtins.str
    """The username of the user's account."""
    display_name: builtins.str
    """The display name of the user."""
    avatar_url: builtins.str
    """A URL for an avatar image."""
    lang_tag: builtins.str
    """The language expected to be a tag which follows the BCP-47 spec."""
    location: builtins.str
    """The location set by the user."""
    timezone: builtins.str
    """The timezone set by the user."""
    user_status: builtins.str
    """custom status"""
    online: builtins.bool
    """Indicates whether the user is currently online."""
    phone_number: builtins.str
    """The phone number"""
    edge_count: builtins.int
    """Number of related edges to this user."""
    about_me: builtins.str
    """About me"""
    is_mobile: builtins.bool
    """Platform"""
    mezon_id: builtins.str
    """Mezone id"""
    status: builtins.str
    """online, offline, invisible, idle, do not disturb"""
    @property
    def create_time(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """The UNIX time (for gRPC clients) or ISO string (for REST clients) when the user was created."""

    @property
    def update_time(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """The UNIX time (for gRPC clients) or ISO string (for REST clients) when the user was last updated."""

    @property
    def join_time(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """Join time"""

    @property
    def dob(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """dob"""

    @property
    def list_nick_names(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """list clan nick name"""

    def __init__(
        self,
        *,
        id: builtins.str = ...,
        username: builtins.str = ...,
        display_name: builtins.str = ...,
        avatar_url: builtins.str = ...,
        lang_tag: builtins.str = ...,
        location: builtins.str = ...,
        timezone: builtins.str = ...,
        user_status: builtins.str = ...,
        online: builtins.bool = ...,
        phone_number: builtins.str = ...,
        edge_count: builtins.int = ...,
        create_time: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        update_time: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        about_me: builtins.str = ...,
        join_time: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        is_mobile: builtins.bool = ...,
        dob: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        mezon_id: builtins.str = ...,
        list_nick_names: collections.abc.Iterable[builtins.str] | None = ...,
        status: builtins.str = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["create_time", b"create_time", "dob", b"dob", "join_time", b"join_time", "update_time", b"update_time"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["about_me", b"about_me", "avatar_url", b"avatar_url", "create_time", b"create_time", "display_name", b"display_name", "dob", b"dob", "edge_count", b"edge_count", "id", b"id", "is_mobile", b"is_mobile", "join_time", b"join_time", "lang_tag", b"lang_tag", "list_nick_names", b"list_nick_names", "location", b"location", "mezon_id", b"mezon_id", "online", b"online", "phone_number", b"phone_number", "status", b"status", "timezone", b"timezone", "update_time", b"update_time", "user_status", b"user_status", "username", b"username"]) -> None: ...

global___User = User

@typing.final
class Users(google.protobuf.message.Message):
    """A collection of zero or more users."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    USERS_FIELD_NUMBER: builtins.int
    @property
    def users(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___User]:
        """The User objects."""

    def __init__(
        self,
        *,
        users: collections.abc.Iterable[global___User] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["users", b"users"]) -> None: ...

global___Users = Users

@typing.final
class ClanDescProfile(google.protobuf.message.Message):
    """Clan profile information"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CLAN_ID_FIELD_NUMBER: builtins.int
    CREATOR_ID_FIELD_NUMBER: builtins.int
    NICK_NAME_FIELD_NUMBER: builtins.int
    PROFILE_BANNER_FIELD_NUMBER: builtins.int
    PROFILE_THEME_FIELD_NUMBER: builtins.int
    AVATAR_URL_FIELD_NUMBER: builtins.int
    clan_id: builtins.str
    """Clan id"""
    creator_id: builtins.str
    """Clan creator"""
    nick_name: builtins.str
    """Clan nick name"""
    profile_banner: builtins.str
    """Clan profile banner"""
    profile_theme: builtins.str
    """Clan profile theme"""
    avatar_url: builtins.str
    """Clan profile avatar"""
    def __init__(
        self,
        *,
        clan_id: builtins.str = ...,
        creator_id: builtins.str = ...,
        nick_name: builtins.str = ...,
        profile_banner: builtins.str = ...,
        profile_theme: builtins.str = ...,
        avatar_url: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["avatar_url", b"avatar_url", "clan_id", b"clan_id", "creator_id", b"creator_id", "nick_name", b"nick_name", "profile_banner", b"profile_banner", "profile_theme", b"profile_theme"]) -> None: ...

global___ClanDescProfile = ClanDescProfile

@typing.final
class UpdateClanDescProfileRequest(google.protobuf.message.Message):
    """Update Clan profile information"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CLAN_ID_FIELD_NUMBER: builtins.int
    NICK_NAME_FIELD_NUMBER: builtins.int
    PROFILE_BANNER_FIELD_NUMBER: builtins.int
    PROFILE_THEME_FIELD_NUMBER: builtins.int
    AVATAR_URL_FIELD_NUMBER: builtins.int
    clan_id: builtins.str
    """Clan id"""
    nick_name: builtins.str
    """Clan nick name"""
    profile_banner: builtins.str
    """Clan profile banner"""
    profile_theme: builtins.str
    """Clan profile theme"""
    avatar_url: builtins.str
    """Clan profile avatar"""
    def __init__(
        self,
        *,
        clan_id: builtins.str = ...,
        nick_name: builtins.str = ...,
        profile_banner: builtins.str = ...,
        profile_theme: builtins.str = ...,
        avatar_url: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["avatar_url", b"avatar_url", "clan_id", b"clan_id", "nick_name", b"nick_name", "profile_banner", b"profile_banner", "profile_theme", b"profile_theme"]) -> None: ...

global___UpdateClanDescProfileRequest = UpdateClanDescProfileRequest

@typing.final
class ClanDescProfileRequest(google.protobuf.message.Message):
    """Clan profile information"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CLAN_ID_FIELD_NUMBER: builtins.int
    clan_id: builtins.str
    """Clan id"""
    def __init__(
        self,
        *,
        clan_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["clan_id", b"clan_id"]) -> None: ...

global___ClanDescProfileRequest = ClanDescProfileRequest

@typing.final
class ClanDesc(google.protobuf.message.Message):
    """Clan information"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CREATOR_ID_FIELD_NUMBER: builtins.int
    CLAN_NAME_FIELD_NUMBER: builtins.int
    LOGO_FIELD_NUMBER: builtins.int
    BANNER_FIELD_NUMBER: builtins.int
    CLAN_ID_FIELD_NUMBER: builtins.int
    STATUS_FIELD_NUMBER: builtins.int
    BADGE_COUNT_FIELD_NUMBER: builtins.int
    IS_ONBOARDING_FIELD_NUMBER: builtins.int
    WELCOME_CHANNEL_ID_FIELD_NUMBER: builtins.int
    ONBOARDING_BANNER_FIELD_NUMBER: builtins.int
    CLAN_ORDER_FIELD_NUMBER: builtins.int
    IS_COMMUNITY_FIELD_NUMBER: builtins.int
    COMMUNITY_BANNER_FIELD_NUMBER: builtins.int
    DESCRIPTION_FIELD_NUMBER: builtins.int
    ABOUT_FIELD_NUMBER: builtins.int
    SHORT_URL_FIELD_NUMBER: builtins.int
    PREVENT_ANONYMOUS_FIELD_NUMBER: builtins.int
    HAS_UNREAD_MESSAGE_FIELD_NUMBER: builtins.int
    creator_id: builtins.str
    """Clan creator"""
    clan_name: builtins.str
    """Clan name"""
    logo: builtins.str
    """Clan logo"""
    banner: builtins.str
    """Clan banner"""
    clan_id: builtins.str
    """Clan id"""
    status: builtins.int
    """Clan status"""
    badge_count: builtins.int
    """Badge count"""
    is_onboarding: builtins.bool
    """Is onboarding."""
    welcome_channel_id: builtins.str
    """Welcome channel id."""
    onboarding_banner: builtins.str
    """Onboarding_banner."""
    clan_order: builtins.int
    """clan order"""
    is_community: builtins.bool
    """is community"""
    community_banner: builtins.str
    """community banner"""
    description: builtins.str
    """description"""
    about: builtins.str
    """about"""
    short_url: builtins.str
    """short_url"""
    prevent_anonymous: builtins.bool
    """prevent anonymous"""
    has_unread_message: builtins.bool
    """has unread message"""
    def __init__(
        self,
        *,
        creator_id: builtins.str = ...,
        clan_name: builtins.str = ...,
        logo: builtins.str = ...,
        banner: builtins.str = ...,
        clan_id: builtins.str = ...,
        status: builtins.int = ...,
        badge_count: builtins.int = ...,
        is_onboarding: builtins.bool = ...,
        welcome_channel_id: builtins.str = ...,
        onboarding_banner: builtins.str = ...,
        clan_order: builtins.int = ...,
        is_community: builtins.bool = ...,
        community_banner: builtins.str = ...,
        description: builtins.str = ...,
        about: builtins.str = ...,
        short_url: builtins.str = ...,
        prevent_anonymous: builtins.bool = ...,
        has_unread_message: builtins.bool = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["about", b"about", "badge_count", b"badge_count", "banner", b"banner", "clan_id", b"clan_id", "clan_name", b"clan_name", "clan_order", b"clan_order", "community_banner", b"community_banner", "creator_id", b"creator_id", "description", b"description", "has_unread_message", b"has_unread_message", "is_community", b"is_community", "is_onboarding", b"is_onboarding", "logo", b"logo", "onboarding_banner", b"onboarding_banner", "prevent_anonymous", b"prevent_anonymous", "short_url", b"short_url", "status", b"status", "welcome_channel_id", b"welcome_channel_id"]) -> None: ...

global___ClanDesc = ClanDesc

@typing.final
class CreateClanDescRequest(google.protobuf.message.Message):
    """Clan information"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CLAN_NAME_FIELD_NUMBER: builtins.int
    LOGO_FIELD_NUMBER: builtins.int
    BANNER_FIELD_NUMBER: builtins.int
    clan_name: builtins.str
    """Clan name"""
    logo: builtins.str
    """Clan logo"""
    banner: builtins.str
    """Clan banner"""
    def __init__(
        self,
        *,
        clan_name: builtins.str = ...,
        logo: builtins.str = ...,
        banner: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["banner", b"banner", "clan_name", b"clan_name", "logo", b"logo"]) -> None: ...

global___CreateClanDescRequest = CreateClanDescRequest

@typing.final
class UpdateClanDescRequest(google.protobuf.message.Message):
    """Update Clan information"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CLAN_ID_FIELD_NUMBER: builtins.int
    CLAN_NAME_FIELD_NUMBER: builtins.int
    LOGO_FIELD_NUMBER: builtins.int
    BANNER_FIELD_NUMBER: builtins.int
    STATUS_FIELD_NUMBER: builtins.int
    IS_ONBOARDING_FIELD_NUMBER: builtins.int
    WELCOME_CHANNEL_ID_FIELD_NUMBER: builtins.int
    ONBOARDING_BANNER_FIELD_NUMBER: builtins.int
    IS_COMMUNITY_FIELD_NUMBER: builtins.int
    COMMUNITY_BANNER_FIELD_NUMBER: builtins.int
    DESCRIPTION_FIELD_NUMBER: builtins.int
    ABOUT_FIELD_NUMBER: builtins.int
    SHORT_URL_FIELD_NUMBER: builtins.int
    PREVENT_ANONYMOUS_FIELD_NUMBER: builtins.int
    clan_id: builtins.str
    clan_name: builtins.str
    """Clan name"""
    logo: builtins.str
    """Clan logo"""
    status: builtins.int
    """Clan status"""
    welcome_channel_id: builtins.str
    """Welcome channel id."""
    description: builtins.str
    """string description"""
    about: builtins.str
    """About"""
    prevent_anonymous: builtins.bool
    """Prevent anonymous"""
    @property
    def banner(self) -> google.protobuf.wrappers_pb2.StringValue:
        """Clan banner"""

    @property
    def is_onboarding(self) -> google.protobuf.wrappers_pb2.BoolValue:
        """Is onboarding."""

    @property
    def onboarding_banner(self) -> google.protobuf.wrappers_pb2.StringValue:
        """Onboarding_banner."""

    @property
    def is_community(self) -> google.protobuf.wrappers_pb2.BoolValue:
        """Enable community."""

    @property
    def community_banner(self) -> google.protobuf.wrappers_pb2.StringValue:
        """Community banner."""

    @property
    def short_url(self) -> google.protobuf.wrappers_pb2.StringValue:
        """Short url for community"""

    def __init__(
        self,
        *,
        clan_id: builtins.str = ...,
        clan_name: builtins.str = ...,
        logo: builtins.str = ...,
        banner: google.protobuf.wrappers_pb2.StringValue | None = ...,
        status: builtins.int = ...,
        is_onboarding: google.protobuf.wrappers_pb2.BoolValue | None = ...,
        welcome_channel_id: builtins.str = ...,
        onboarding_banner: google.protobuf.wrappers_pb2.StringValue | None = ...,
        is_community: google.protobuf.wrappers_pb2.BoolValue | None = ...,
        community_banner: google.protobuf.wrappers_pb2.StringValue | None = ...,
        description: builtins.str = ...,
        about: builtins.str = ...,
        short_url: google.protobuf.wrappers_pb2.StringValue | None = ...,
        prevent_anonymous: builtins.bool = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["banner", b"banner", "community_banner", b"community_banner", "is_community", b"is_community", "is_onboarding", b"is_onboarding", "onboarding_banner", b"onboarding_banner", "short_url", b"short_url"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["about", b"about", "banner", b"banner", "clan_id", b"clan_id", "clan_name", b"clan_name", "community_banner", b"community_banner", "description", b"description", "is_community", b"is_community", "is_onboarding", b"is_onboarding", "logo", b"logo", "onboarding_banner", b"onboarding_banner", "prevent_anonymous", b"prevent_anonymous", "short_url", b"short_url", "status", b"status", "welcome_channel_id", b"welcome_channel_id"]) -> None: ...

global___UpdateClanDescRequest = UpdateClanDescRequest

@typing.final
class DeleteClanDescRequest(google.protobuf.message.Message):
    """Delete a clan the user has access to."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CLAN_DESC_ID_FIELD_NUMBER: builtins.int
    clan_desc_id: builtins.str
    """The id of a group."""
    def __init__(
        self,
        *,
        clan_desc_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["clan_desc_id", b"clan_desc_id"]) -> None: ...

global___DeleteClanDescRequest = DeleteClanDescRequest

@typing.final
class ListClanDescRequest(google.protobuf.message.Message):
    """List (and optionally filter) channels."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    LIMIT_FIELD_NUMBER: builtins.int
    STATE_FIELD_NUMBER: builtins.int
    CURSOR_FIELD_NUMBER: builtins.int
    cursor: builtins.str
    """Cursor to start from"""
    @property
    def limit(self) -> google.protobuf.wrappers_pb2.Int32Value:
        """Max number of records to return. Between 1 and 100."""

    @property
    def state(self) -> google.protobuf.wrappers_pb2.Int32Value:
        """The friend state to list."""

    def __init__(
        self,
        *,
        limit: google.protobuf.wrappers_pb2.Int32Value | None = ...,
        state: google.protobuf.wrappers_pb2.Int32Value | None = ...,
        cursor: builtins.str = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["limit", b"limit", "state", b"state"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["cursor", b"cursor", "limit", b"limit", "state", b"state"]) -> None: ...

global___ListClanDescRequest = ListClanDescRequest

@typing.final
class ListClanUnreadMsgIndicatorRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CLAN_ID_FIELD_NUMBER: builtins.int
    clan_id: builtins.str
    def __init__(
        self,
        *,
        clan_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["clan_id", b"clan_id"]) -> None: ...

global___ListClanUnreadMsgIndicatorRequest = ListClanUnreadMsgIndicatorRequest

@typing.final
class ListClanUnreadMsgIndicatorResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    HAS_UNREAD_MESSAGE_FIELD_NUMBER: builtins.int
    has_unread_message: builtins.bool
    def __init__(
        self,
        *,
        has_unread_message: builtins.bool = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["has_unread_message", b"has_unread_message"]) -> None: ...

global___ListClanUnreadMsgIndicatorResponse = ListClanUnreadMsgIndicatorResponse

@typing.final
class ClanDescList(google.protobuf.message.Message):
    """A list of clan"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CLANDESC_FIELD_NUMBER: builtins.int
    @property
    def clandesc(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___ClanDesc]:
        """A list of channel."""

    def __init__(
        self,
        *,
        clandesc: collections.abc.Iterable[global___ClanDesc] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["clandesc", b"clandesc"]) -> None: ...

global___ClanDescList = ClanDescList

@typing.final
class LinkInviteUserRequest(google.protobuf.message.Message):
    """Add link invite users to."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CLAN_ID_FIELD_NUMBER: builtins.int
    CHANNEL_ID_FIELD_NUMBER: builtins.int
    EXPIRY_TIME_FIELD_NUMBER: builtins.int
    clan_id: builtins.str
    """id clan to add link to ."""
    channel_id: builtins.str
    """id channel to add link to."""
    expiry_time: builtins.int
    """expiry time"""
    def __init__(
        self,
        *,
        clan_id: builtins.str = ...,
        channel_id: builtins.str = ...,
        expiry_time: builtins.int = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["channel_id", b"channel_id", "clan_id", b"clan_id", "expiry_time", b"expiry_time"]) -> None: ...

global___LinkInviteUserRequest = LinkInviteUserRequest

@typing.final
class InviteUserRequest(google.protobuf.message.Message):
    """Add link invite users to."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    INVITE_ID_FIELD_NUMBER: builtins.int
    invite_id: builtins.str
    """id clan to add link to ."""
    def __init__(
        self,
        *,
        invite_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["invite_id", b"invite_id"]) -> None: ...

global___InviteUserRequest = InviteUserRequest

@typing.final
class InviteUserRes(google.protobuf.message.Message):
    """Add link invite users to."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CLAN_ID_FIELD_NUMBER: builtins.int
    CHANNEL_ID_FIELD_NUMBER: builtins.int
    CLAN_NAME_FIELD_NUMBER: builtins.int
    CHANNEL_LABEL_FIELD_NUMBER: builtins.int
    USER_JOINED_FIELD_NUMBER: builtins.int
    EXPIRY_TIME_FIELD_NUMBER: builtins.int
    CHANNEL_DESC_FIELD_NUMBER: builtins.int
    CLAN_LOGO_FIELD_NUMBER: builtins.int
    MEMBER_COUNT_FIELD_NUMBER: builtins.int
    clan_id: builtins.str
    """id clan to add link to ."""
    channel_id: builtins.str
    """id channel to add link to."""
    clan_name: builtins.str
    """clan name"""
    channel_label: builtins.str
    """channel name"""
    user_joined: builtins.bool
    """check user exist"""
    clan_logo: builtins.str
    member_count: builtins.int
    @property
    def expiry_time(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """expiry_time"""

    @property
    def channel_desc(self) -> global___ChannelDescription:
        """"""

    def __init__(
        self,
        *,
        clan_id: builtins.str = ...,
        channel_id: builtins.str = ...,
        clan_name: builtins.str = ...,
        channel_label: builtins.str = ...,
        user_joined: builtins.bool = ...,
        expiry_time: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        channel_desc: global___ChannelDescription | None = ...,
        clan_logo: builtins.str = ...,
        member_count: builtins.int = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["channel_desc", b"channel_desc", "expiry_time", b"expiry_time"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["channel_desc", b"channel_desc", "channel_id", b"channel_id", "channel_label", b"channel_label", "clan_id", b"clan_id", "clan_logo", b"clan_logo", "clan_name", b"clan_name", "expiry_time", b"expiry_time", "member_count", b"member_count", "user_joined", b"user_joined"]) -> None: ...

global___InviteUserRes = InviteUserRes

@typing.final
class JoinClanChannelRequest(google.protobuf.message.Message):
    """Add link invite users to."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CLAN_ID_FIELD_NUMBER: builtins.int
    CHANNEL_ID_FIELD_NUMBER: builtins.int
    clan_id: builtins.str
    """id clan to add link to ."""
    channel_id: builtins.str
    """id channel to add link to."""
    def __init__(
        self,
        *,
        clan_id: builtins.str = ...,
        channel_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["channel_id", b"channel_id", "clan_id", b"clan_id"]) -> None: ...

global___JoinClanChannelRequest = JoinClanChannelRequest

@typing.final
class LinkInviteUser(google.protobuf.message.Message):
    """Add link invite users to."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CLAN_ID_FIELD_NUMBER: builtins.int
    CREATOR_ID_FIELD_NUMBER: builtins.int
    CHANNEL_ID_FIELD_NUMBER: builtins.int
    INVITE_LINK_FIELD_NUMBER: builtins.int
    CREATE_TIME_FIELD_NUMBER: builtins.int
    EXPIRY_TIME_FIELD_NUMBER: builtins.int
    ID_FIELD_NUMBER: builtins.int
    clan_id: builtins.str
    """id clan"""
    creator_id: builtins.str
    """The user to add."""
    channel_id: builtins.str
    """is clan invite"""
    invite_link: builtins.str
    """link invite"""
    id: builtins.str
    @property
    def create_time(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """create time"""

    @property
    def expiry_time(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """expiry time"""

    def __init__(
        self,
        *,
        clan_id: builtins.str = ...,
        creator_id: builtins.str = ...,
        channel_id: builtins.str = ...,
        invite_link: builtins.str = ...,
        create_time: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        expiry_time: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        id: builtins.str = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["create_time", b"create_time", "expiry_time", b"expiry_time"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["channel_id", b"channel_id", "clan_id", b"clan_id", "create_time", b"create_time", "creator_id", b"creator_id", "expiry_time", b"expiry_time", "id", b"id", "invite_link", b"invite_link"]) -> None: ...

global___LinkInviteUser = LinkInviteUser

@typing.final
class ClanProfile(google.protobuf.message.Message):
    """Get clan profile."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    USER_ID_FIELD_NUMBER: builtins.int
    NICK_NAME_FIELD_NUMBER: builtins.int
    AVATAR_FIELD_NUMBER: builtins.int
    CLAN_ID_FIELD_NUMBER: builtins.int
    ABOUT_FIELD_NUMBER: builtins.int
    user_id: builtins.str
    """id user to find user"""
    nick_name: builtins.str
    """name user"""
    avatar: builtins.str
    """id avatar"""
    clan_id: builtins.str
    """id clan"""
    about: builtins.str
    """about clan"""
    def __init__(
        self,
        *,
        user_id: builtins.str = ...,
        nick_name: builtins.str = ...,
        avatar: builtins.str = ...,
        clan_id: builtins.str = ...,
        about: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["about", b"about", "avatar", b"avatar", "clan_id", b"clan_id", "nick_name", b"nick_name", "user_id", b"user_id"]) -> None: ...

global___ClanProfile = ClanProfile

@typing.final
class ClanProfileRequest(google.protobuf.message.Message):
    """information user by clan requset"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CLAN_ID_FIELD_NUMBER: builtins.int
    clan_id: builtins.str
    """id clanc"""
    def __init__(
        self,
        *,
        clan_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["clan_id", b"clan_id"]) -> None: ...

global___ClanProfileRequest = ClanProfileRequest

@typing.final
class UpdateClanProfileRequest(google.protobuf.message.Message):
    """update nickname user by clan requset"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CLAN_ID_FIELD_NUMBER: builtins.int
    NICK_NAME_FIELD_NUMBER: builtins.int
    AVATAR_FIELD_NUMBER: builtins.int
    clan_id: builtins.str
    """id clanc"""
    nick_name: builtins.str
    """nick_name new"""
    avatar: builtins.str
    """avatar"""
    def __init__(
        self,
        *,
        clan_id: builtins.str = ...,
        nick_name: builtins.str = ...,
        avatar: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["avatar", b"avatar", "clan_id", b"clan_id", "nick_name", b"nick_name"]) -> None: ...

global___UpdateClanProfileRequest = UpdateClanProfileRequest

@typing.final
class UpdateClanOrderRequest(google.protobuf.message.Message):
    """Update Clan Order Request"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    @typing.final
    class ClanOrder(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        ORDER_FIELD_NUMBER: builtins.int
        CLAN_ID_FIELD_NUMBER: builtins.int
        order: builtins.int
        clan_id: builtins.str
        def __init__(
            self,
            *,
            order: builtins.int = ...,
            clan_id: builtins.str = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing.Literal["clan_id", b"clan_id", "order", b"order"]) -> None: ...

    CLANS_ORDER_FIELD_NUMBER: builtins.int
    @property
    def clans_order(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___UpdateClanOrderRequest.ClanOrder]: ...
    def __init__(
        self,
        *,
        clans_order: collections.abc.Iterable[global___UpdateClanOrderRequest.ClanOrder] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["clans_order", b"clans_order"]) -> None: ...

global___UpdateClanOrderRequest = UpdateClanOrderRequest

@typing.final
class CategoryDesc(google.protobuf.message.Message):
    """Category to group the channel"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CREATOR_ID_FIELD_NUMBER: builtins.int
    CLAN_ID_FIELD_NUMBER: builtins.int
    CATEGORY_NAME_FIELD_NUMBER: builtins.int
    CATEGORY_ID_FIELD_NUMBER: builtins.int
    CATEGORY_ORDER_FIELD_NUMBER: builtins.int
    creator_id: builtins.str
    """Category creator"""
    clan_id: builtins.str
    """the Clan that category belong to"""
    category_name: builtins.str
    """Category name"""
    category_id: builtins.str
    category_order: builtins.int
    def __init__(
        self,
        *,
        creator_id: builtins.str = ...,
        clan_id: builtins.str = ...,
        category_name: builtins.str = ...,
        category_id: builtins.str = ...,
        category_order: builtins.int = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["category_id", b"category_id", "category_name", b"category_name", "category_order", b"category_order", "clan_id", b"clan_id", "creator_id", b"creator_id"]) -> None: ...

global___CategoryDesc = CategoryDesc

@typing.final
class UpdateCategoryOrderRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CLAN_ID_FIELD_NUMBER: builtins.int
    CATEGORIES_FIELD_NUMBER: builtins.int
    clan_id: builtins.str
    @property
    def categories(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___CategoryOrderUpdate]: ...
    def __init__(
        self,
        *,
        clan_id: builtins.str = ...,
        categories: collections.abc.Iterable[global___CategoryOrderUpdate] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["categories", b"categories", "clan_id", b"clan_id"]) -> None: ...

global___UpdateCategoryOrderRequest = UpdateCategoryOrderRequest

@typing.final
class UpdateRoleOrderRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CLAN_ID_FIELD_NUMBER: builtins.int
    ROLES_FIELD_NUMBER: builtins.int
    clan_id: builtins.str
    @property
    def roles(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___RoleOrderUpdate]: ...
    def __init__(
        self,
        *,
        clan_id: builtins.str = ...,
        roles: collections.abc.Iterable[global___RoleOrderUpdate] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["clan_id", b"clan_id", "roles", b"roles"]) -> None: ...

global___UpdateRoleOrderRequest = UpdateRoleOrderRequest

@typing.final
class RoleOrderUpdate(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ROLE_ID_FIELD_NUMBER: builtins.int
    ORDER_FIELD_NUMBER: builtins.int
    role_id: builtins.str
    order: builtins.int
    def __init__(
        self,
        *,
        role_id: builtins.str = ...,
        order: builtins.int = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["order", b"order", "role_id", b"role_id"]) -> None: ...

global___RoleOrderUpdate = RoleOrderUpdate

@typing.final
class CategoryOrderUpdate(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CATEGORY_ID_FIELD_NUMBER: builtins.int
    ORDER_FIELD_NUMBER: builtins.int
    category_id: builtins.str
    order: builtins.int
    def __init__(
        self,
        *,
        category_id: builtins.str = ...,
        order: builtins.int = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["category_id", b"category_id", "order", b"order"]) -> None: ...

global___CategoryOrderUpdate = CategoryOrderUpdate

@typing.final
class CreateCategoryDescRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CATEGORY_NAME_FIELD_NUMBER: builtins.int
    CLAN_ID_FIELD_NUMBER: builtins.int
    category_name: builtins.str
    clan_id: builtins.str
    def __init__(
        self,
        *,
        category_name: builtins.str = ...,
        clan_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["category_name", b"category_name", "clan_id", b"clan_id"]) -> None: ...

global___CreateCategoryDescRequest = CreateCategoryDescRequest

@typing.final
class DeleteCategoryDescRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CATEGORY_ID_FIELD_NUMBER: builtins.int
    CLAN_ID_FIELD_NUMBER: builtins.int
    CATEGORY_LABEL_FIELD_NUMBER: builtins.int
    category_id: builtins.str
    clan_id: builtins.str
    category_label: builtins.str
    def __init__(
        self,
        *,
        category_id: builtins.str = ...,
        clan_id: builtins.str = ...,
        category_label: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["category_id", b"category_id", "category_label", b"category_label", "clan_id", b"clan_id"]) -> None: ...

global___DeleteCategoryDescRequest = DeleteCategoryDescRequest

@typing.final
class CategoryDescList(google.protobuf.message.Message):
    """A list of clan"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CATEGORYDESC_FIELD_NUMBER: builtins.int
    @property
    def categorydesc(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___CategoryDesc]:
        """A list of channel."""

    def __init__(
        self,
        *,
        categorydesc: collections.abc.Iterable[global___CategoryDesc] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["categorydesc", b"categorydesc"]) -> None: ...

global___CategoryDescList = CategoryDescList

@typing.final
class ListCategoryDescsRequest(google.protobuf.message.Message):
    """List (and optionally filter) channels."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    LIMIT_FIELD_NUMBER: builtins.int
    STATE_FIELD_NUMBER: builtins.int
    CURSOR_FIELD_NUMBER: builtins.int
    cursor: builtins.str
    """Cursor to start from"""
    @property
    def limit(self) -> google.protobuf.wrappers_pb2.Int32Value:
        """Max number of records to return. Between 1 and 100."""

    @property
    def state(self) -> google.protobuf.wrappers_pb2.Int32Value:
        """The friend state to list."""

    def __init__(
        self,
        *,
        limit: google.protobuf.wrappers_pb2.Int32Value | None = ...,
        state: google.protobuf.wrappers_pb2.Int32Value | None = ...,
        cursor: builtins.str = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["limit", b"limit", "state", b"state"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["cursor", b"cursor", "limit", b"limit", "state", b"state"]) -> None: ...

global___ListCategoryDescsRequest = ListCategoryDescsRequest

@typing.final
class ChannelMessageHeader(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ID_FIELD_NUMBER: builtins.int
    TIMESTAMP_SECONDS_FIELD_NUMBER: builtins.int
    SENDER_ID_FIELD_NUMBER: builtins.int
    CONTENT_FIELD_NUMBER: builtins.int
    ATTACHMENT_FIELD_NUMBER: builtins.int
    REFERENCE_FIELD_NUMBER: builtins.int
    MENTION_FIELD_NUMBER: builtins.int
    REACTION_FIELD_NUMBER: builtins.int
    REPLIERS_FIELD_NUMBER: builtins.int
    id: builtins.str
    """the message id"""
    timestamp_seconds: builtins.int
    """the time stamp"""
    sender_id: builtins.str
    """the sender id"""
    content: builtins.str
    """the content"""
    attachment: builtins.str
    """the attachment"""
    reference: builtins.str
    """the reference"""
    mention: builtins.str
    """the mention"""
    reaction: builtins.str
    """the reactions"""
    @property
    def repliers(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """"""

    def __init__(
        self,
        *,
        id: builtins.str = ...,
        timestamp_seconds: builtins.int = ...,
        sender_id: builtins.str = ...,
        content: builtins.str = ...,
        attachment: builtins.str = ...,
        reference: builtins.str = ...,
        mention: builtins.str = ...,
        reaction: builtins.str = ...,
        repliers: collections.abc.Iterable[builtins.str] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["attachment", b"attachment", "content", b"content", "id", b"id", "mention", b"mention", "reaction", b"reaction", "reference", b"reference", "repliers", b"repliers", "sender_id", b"sender_id", "timestamp_seconds", b"timestamp_seconds"]) -> None: ...

global___ChannelMessageHeader = ChannelMessageHeader

@typing.final
class ChannelDescription(google.protobuf.message.Message):
    """Channel description record"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CLAN_ID_FIELD_NUMBER: builtins.int
    PARENT_ID_FIELD_NUMBER: builtins.int
    CHANNEL_ID_FIELD_NUMBER: builtins.int
    CATEGORY_ID_FIELD_NUMBER: builtins.int
    CATEGORY_NAME_FIELD_NUMBER: builtins.int
    TYPE_FIELD_NUMBER: builtins.int
    CREATOR_ID_FIELD_NUMBER: builtins.int
    CHANNEL_LABEL_FIELD_NUMBER: builtins.int
    CHANNEL_PRIVATE_FIELD_NUMBER: builtins.int
    AVATARS_FIELD_NUMBER: builtins.int
    USER_IDS_FIELD_NUMBER: builtins.int
    LAST_SENT_MESSAGE_FIELD_NUMBER: builtins.int
    LAST_SEEN_MESSAGE_FIELD_NUMBER: builtins.int
    ONLINES_FIELD_NUMBER: builtins.int
    MEETING_CODE_FIELD_NUMBER: builtins.int
    COUNT_MESS_UNREAD_FIELD_NUMBER: builtins.int
    ACTIVE_FIELD_NUMBER: builtins.int
    LAST_PIN_MESSAGE_FIELD_NUMBER: builtins.int
    USERNAMES_FIELD_NUMBER: builtins.int
    CREATOR_NAME_FIELD_NUMBER: builtins.int
    CREATE_TIME_SECONDS_FIELD_NUMBER: builtins.int
    UPDATE_TIME_SECONDS_FIELD_NUMBER: builtins.int
    DISPLAY_NAMES_FIELD_NUMBER: builtins.int
    CHANNEL_AVATAR_FIELD_NUMBER: builtins.int
    CLAN_NAME_FIELD_NUMBER: builtins.int
    APP_ID_FIELD_NUMBER: builtins.int
    IS_MUTE_FIELD_NUMBER: builtins.int
    AGE_RESTRICTED_FIELD_NUMBER: builtins.int
    TOPIC_FIELD_NUMBER: builtins.int
    E2EE_FIELD_NUMBER: builtins.int
    MEMBER_COUNT_FIELD_NUMBER: builtins.int
    clan_id: builtins.str
    """The clan of this channel"""
    parent_id: builtins.str
    """The parent channel this message belongs to."""
    channel_id: builtins.str
    """The channel this message belongs to."""
    category_id: builtins.str
    """The category of channel"""
    category_name: builtins.str
    """The category name"""
    creator_id: builtins.str
    """creator ID."""
    channel_label: builtins.str
    """The channel lable"""
    channel_private: builtins.int
    """The channel private"""
    meeting_code: builtins.str
    """meeting code"""
    count_mess_unread: builtins.int
    """count message unread"""
    active: builtins.int
    """active channel"""
    last_pin_message: builtins.str
    """last pin message"""
    creator_name: builtins.str
    """creator name"""
    create_time_seconds: builtins.int
    """create time ms"""
    update_time_seconds: builtins.int
    """update time ms"""
    channel_avatar: builtins.str
    """channel avatar"""
    clan_name: builtins.str
    """clan_name"""
    app_id: builtins.str
    """app id"""
    is_mute: builtins.bool
    """channel all message"""
    age_restricted: builtins.int
    """age restricted"""
    topic: builtins.str
    """channel description topic"""
    e2ee: builtins.int
    """e2ee"""
    member_count: builtins.int
    """channel member count"""
    @property
    def type(self) -> google.protobuf.wrappers_pb2.Int32Value:
        """The channel type."""

    @property
    def avatars(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """DM avatars"""

    @property
    def user_ids(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """List DM user ids"""

    @property
    def last_sent_message(self) -> global___ChannelMessageHeader:
        """last message id"""

    @property
    def last_seen_message(self) -> global___ChannelMessageHeader:
        """last seen message id"""

    @property
    def onlines(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.bool]:
        """DM status"""

    @property
    def usernames(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """List DM usernames"""

    @property
    def display_names(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """List DM diplay names"""

    def __init__(
        self,
        *,
        clan_id: builtins.str = ...,
        parent_id: builtins.str = ...,
        channel_id: builtins.str = ...,
        category_id: builtins.str = ...,
        category_name: builtins.str = ...,
        type: google.protobuf.wrappers_pb2.Int32Value | None = ...,
        creator_id: builtins.str = ...,
        channel_label: builtins.str = ...,
        channel_private: builtins.int = ...,
        avatars: collections.abc.Iterable[builtins.str] | None = ...,
        user_ids: collections.abc.Iterable[builtins.str] | None = ...,
        last_sent_message: global___ChannelMessageHeader | None = ...,
        last_seen_message: global___ChannelMessageHeader | None = ...,
        onlines: collections.abc.Iterable[builtins.bool] | None = ...,
        meeting_code: builtins.str = ...,
        count_mess_unread: builtins.int = ...,
        active: builtins.int = ...,
        last_pin_message: builtins.str = ...,
        usernames: collections.abc.Iterable[builtins.str] | None = ...,
        creator_name: builtins.str = ...,
        create_time_seconds: builtins.int = ...,
        update_time_seconds: builtins.int = ...,
        display_names: collections.abc.Iterable[builtins.str] | None = ...,
        channel_avatar: builtins.str = ...,
        clan_name: builtins.str = ...,
        app_id: builtins.str = ...,
        is_mute: builtins.bool = ...,
        age_restricted: builtins.int = ...,
        topic: builtins.str = ...,
        e2ee: builtins.int = ...,
        member_count: builtins.int = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["last_seen_message", b"last_seen_message", "last_sent_message", b"last_sent_message", "type", b"type"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["active", b"active", "age_restricted", b"age_restricted", "app_id", b"app_id", "avatars", b"avatars", "category_id", b"category_id", "category_name", b"category_name", "channel_avatar", b"channel_avatar", "channel_id", b"channel_id", "channel_label", b"channel_label", "channel_private", b"channel_private", "clan_id", b"clan_id", "clan_name", b"clan_name", "count_mess_unread", b"count_mess_unread", "create_time_seconds", b"create_time_seconds", "creator_id", b"creator_id", "creator_name", b"creator_name", "display_names", b"display_names", "e2ee", b"e2ee", "is_mute", b"is_mute", "last_pin_message", b"last_pin_message", "last_seen_message", b"last_seen_message", "last_sent_message", b"last_sent_message", "meeting_code", b"meeting_code", "member_count", b"member_count", "onlines", b"onlines", "parent_id", b"parent_id", "topic", b"topic", "type", b"type", "update_time_seconds", b"update_time_seconds", "user_ids", b"user_ids", "usernames", b"usernames"]) -> None: ...

global___ChannelDescription = ChannelDescription

@typing.final
class ChannelDescList(google.protobuf.message.Message):
    """A list of channel description, usually a result of a list operation."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CHANNELDESC_FIELD_NUMBER: builtins.int
    NEXT_CURSOR_FIELD_NUMBER: builtins.int
    PREV_CURSOR_FIELD_NUMBER: builtins.int
    CACHEABLE_CURSOR_FIELD_NUMBER: builtins.int
    PAGE_FIELD_NUMBER: builtins.int
    next_cursor: builtins.str
    """The cursor to send when retrieving the next page, if any."""
    prev_cursor: builtins.str
    """The cursor to send when retrieving the previous page, if any."""
    cacheable_cursor: builtins.str
    """Cacheable cursor to list newer channel description. Durable and designed to be stored, unlike next/prev cursors."""
    page: builtins.int
    """Page thread"""
    @property
    def channeldesc(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___ChannelDescription]:
        """A list of channel."""

    def __init__(
        self,
        *,
        channeldesc: collections.abc.Iterable[global___ChannelDescription] | None = ...,
        next_cursor: builtins.str = ...,
        prev_cursor: builtins.str = ...,
        cacheable_cursor: builtins.str = ...,
        page: builtins.int = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["cacheable_cursor", b"cacheable_cursor", "channeldesc", b"channeldesc", "next_cursor", b"next_cursor", "page", b"page", "prev_cursor", b"prev_cursor"]) -> None: ...

global___ChannelDescList = ChannelDescList

@typing.final
class ListThreadRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    LIMIT_FIELD_NUMBER: builtins.int
    STATE_FIELD_NUMBER: builtins.int
    CLAN_ID_FIELD_NUMBER: builtins.int
    CHANNEL_ID_FIELD_NUMBER: builtins.int
    THREAD_ID_FIELD_NUMBER: builtins.int
    PAGE_FIELD_NUMBER: builtins.int
    clan_id: builtins.str
    """The clan of this channel"""
    channel_id: builtins.str
    """channel id"""
    thread_id: builtins.str
    """thread id"""
    @property
    def limit(self) -> google.protobuf.wrappers_pb2.Int32Value:
        """Max number of records to return. Between 1 and 100."""

    @property
    def state(self) -> google.protobuf.wrappers_pb2.Int32Value:
        """The channel state to list."""

    @property
    def page(self) -> google.protobuf.wrappers_pb2.Int32Value:
        """Number of page"""

    def __init__(
        self,
        *,
        limit: google.protobuf.wrappers_pb2.Int32Value | None = ...,
        state: google.protobuf.wrappers_pb2.Int32Value | None = ...,
        clan_id: builtins.str = ...,
        channel_id: builtins.str = ...,
        thread_id: builtins.str = ...,
        page: google.protobuf.wrappers_pb2.Int32Value | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["limit", b"limit", "page", b"page", "state", b"state"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["channel_id", b"channel_id", "clan_id", b"clan_id", "limit", b"limit", "page", b"page", "state", b"state", "thread_id", b"thread_id"]) -> None: ...

global___ListThreadRequest = ListThreadRequest

@typing.final
class ListChannelDescsRequest(google.protobuf.message.Message):
    """List (and optionally filter) channels."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    LIMIT_FIELD_NUMBER: builtins.int
    STATE_FIELD_NUMBER: builtins.int
    CURSOR_FIELD_NUMBER: builtins.int
    CLAN_ID_FIELD_NUMBER: builtins.int
    CHANNEL_TYPE_FIELD_NUMBER: builtins.int
    IS_MOBILE_FIELD_NUMBER: builtins.int
    cursor: builtins.str
    """Cursor to start from"""
    clan_id: builtins.str
    """The clan of this channel"""
    channel_type: builtins.int
    """channel type"""
    is_mobile: builtins.bool
    """is mobile"""
    @property
    def limit(self) -> google.protobuf.wrappers_pb2.Int32Value:
        """Max number of records to return. Between 1 and 100."""

    @property
    def state(self) -> google.protobuf.wrappers_pb2.Int32Value:
        """The channel state to list."""

    def __init__(
        self,
        *,
        limit: google.protobuf.wrappers_pb2.Int32Value | None = ...,
        state: google.protobuf.wrappers_pb2.Int32Value | None = ...,
        cursor: builtins.str = ...,
        clan_id: builtins.str = ...,
        channel_type: builtins.int = ...,
        is_mobile: builtins.bool = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["limit", b"limit", "state", b"state"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["channel_type", b"channel_type", "clan_id", b"clan_id", "cursor", b"cursor", "is_mobile", b"is_mobile", "limit", b"limit", "state", b"state"]) -> None: ...

global___ListChannelDescsRequest = ListChannelDescsRequest

@typing.final
class ListChannelDetailRequest(google.protobuf.message.Message):
    """List channel description detail"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CHANNEL_ID_FIELD_NUMBER: builtins.int
    channel_id: builtins.str
    """channel id"""
    def __init__(
        self,
        *,
        channel_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["channel_id", b"channel_id"]) -> None: ...

global___ListChannelDetailRequest = ListChannelDetailRequest

@typing.final
class AddRoleChannelDescRequest(google.protobuf.message.Message):
    """Add a role for channel."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ROLE_IDS_FIELD_NUMBER: builtins.int
    CHANNEL_ID_FIELD_NUMBER: builtins.int
    channel_id: builtins.str
    """This is a channel that needs more roles"""
    @property
    def role_ids(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """This is the role that needs to be added to the channel"""

    def __init__(
        self,
        *,
        role_ids: collections.abc.Iterable[builtins.str] | None = ...,
        channel_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["channel_id", b"channel_id", "role_ids", b"role_ids"]) -> None: ...

global___AddRoleChannelDescRequest = AddRoleChannelDescRequest

@typing.final
class CreateChannelDescRequest(google.protobuf.message.Message):
    """Create a channel within clan."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CLAN_ID_FIELD_NUMBER: builtins.int
    PARENT_ID_FIELD_NUMBER: builtins.int
    CHANNEL_ID_FIELD_NUMBER: builtins.int
    CATEGORY_ID_FIELD_NUMBER: builtins.int
    TYPE_FIELD_NUMBER: builtins.int
    CHANNEL_LABEL_FIELD_NUMBER: builtins.int
    CHANNEL_PRIVATE_FIELD_NUMBER: builtins.int
    USER_IDS_FIELD_NUMBER: builtins.int
    APP_ID_FIELD_NUMBER: builtins.int
    clan_id: builtins.str
    """The clan of this channel"""
    parent_id: builtins.str
    """The parent channel this message belongs to."""
    channel_id: builtins.str
    """The channel this message belongs to."""
    category_id: builtins.str
    """The category of channel"""
    channel_label: builtins.str
    """The channel lable"""
    channel_private: builtins.int
    """The channel private"""
    app_id: builtins.str
    """app url for channel type app"""
    @property
    def type(self) -> google.protobuf.wrappers_pb2.Int32Value:
        """The channel type."""

    @property
    def user_ids(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """The users to add."""

    def __init__(
        self,
        *,
        clan_id: builtins.str = ...,
        parent_id: builtins.str = ...,
        channel_id: builtins.str = ...,
        category_id: builtins.str = ...,
        type: google.protobuf.wrappers_pb2.Int32Value | None = ...,
        channel_label: builtins.str = ...,
        channel_private: builtins.int = ...,
        user_ids: collections.abc.Iterable[builtins.str] | None = ...,
        app_id: builtins.str = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["type", b"type"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["app_id", b"app_id", "category_id", b"category_id", "channel_id", b"channel_id", "channel_label", b"channel_label", "channel_private", b"channel_private", "clan_id", b"clan_id", "parent_id", b"parent_id", "type", b"type", "user_ids", b"user_ids"]) -> None: ...

global___CreateChannelDescRequest = CreateChannelDescRequest

@typing.final
class DeleteChannelDescRequest(google.protobuf.message.Message):
    """Delete a channel the user has access to."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CLAN_ID_FIELD_NUMBER: builtins.int
    CHANNEL_ID_FIELD_NUMBER: builtins.int
    clan_id: builtins.str
    """The clan id"""
    channel_id: builtins.str
    """The id of a channel."""
    def __init__(
        self,
        *,
        clan_id: builtins.str = ...,
        channel_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["channel_id", b"channel_id", "clan_id", b"clan_id"]) -> None: ...

global___DeleteChannelDescRequest = DeleteChannelDescRequest

@typing.final
class UpdateChannelDescRequest(google.protobuf.message.Message):
    """Update fields in a given channel."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CLAN_ID_FIELD_NUMBER: builtins.int
    CHANNEL_ID_FIELD_NUMBER: builtins.int
    CHANNEL_LABEL_FIELD_NUMBER: builtins.int
    CATEGORY_ID_FIELD_NUMBER: builtins.int
    APP_ID_FIELD_NUMBER: builtins.int
    TOPIC_FIELD_NUMBER: builtins.int
    AGE_RESTRICTED_FIELD_NUMBER: builtins.int
    E2EE_FIELD_NUMBER: builtins.int
    CHANNEL_AVATAR_FIELD_NUMBER: builtins.int
    clan_id: builtins.str
    """The clan ID"""
    channel_id: builtins.str
    """The ID of the channel to update."""
    app_id: builtins.str
    """app url for channel type app"""
    topic: builtins.str
    """topic"""
    age_restricted: builtins.int
    """"""
    e2ee: builtins.int
    """"""
    @property
    def channel_label(self) -> google.protobuf.wrappers_pb2.StringValue:
        """The channel lable"""

    @property
    def category_id(self) -> google.protobuf.wrappers_pb2.StringValue:
        """The category of channel"""

    @property
    def channel_avatar(self) -> google.protobuf.wrappers_pb2.StringValue:
        """channel avatar"""

    def __init__(
        self,
        *,
        clan_id: builtins.str = ...,
        channel_id: builtins.str = ...,
        channel_label: google.protobuf.wrappers_pb2.StringValue | None = ...,
        category_id: google.protobuf.wrappers_pb2.StringValue | None = ...,
        app_id: builtins.str = ...,
        topic: builtins.str = ...,
        age_restricted: builtins.int = ...,
        e2ee: builtins.int = ...,
        channel_avatar: google.protobuf.wrappers_pb2.StringValue | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["category_id", b"category_id", "channel_avatar", b"channel_avatar", "channel_label", b"channel_label"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["age_restricted", b"age_restricted", "app_id", b"app_id", "category_id", b"category_id", "channel_avatar", b"channel_avatar", "channel_id", b"channel_id", "channel_label", b"channel_label", "clan_id", b"clan_id", "e2ee", b"e2ee", "topic", b"topic"]) -> None: ...

global___UpdateChannelDescRequest = UpdateChannelDescRequest

@typing.final
class ChangeChannelPrivateRequest(google.protobuf.message.Message):
    """Update fields in a given channel."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CLAN_ID_FIELD_NUMBER: builtins.int
    CHANNEL_ID_FIELD_NUMBER: builtins.int
    CHANNEL_PRIVATE_FIELD_NUMBER: builtins.int
    USER_IDS_FIELD_NUMBER: builtins.int
    ROLE_IDS_FIELD_NUMBER: builtins.int
    clan_id: builtins.str
    """The clan ID"""
    channel_id: builtins.str
    """The ID of the channel to update."""
    channel_private: builtins.int
    """The channel private"""
    @property
    def user_ids(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """The users to add."""

    @property
    def role_ids(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """This is the role that needs to be added to the channel"""

    def __init__(
        self,
        *,
        clan_id: builtins.str = ...,
        channel_id: builtins.str = ...,
        channel_private: builtins.int = ...,
        user_ids: collections.abc.Iterable[builtins.str] | None = ...,
        role_ids: collections.abc.Iterable[builtins.str] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["channel_id", b"channel_id", "channel_private", b"channel_private", "clan_id", b"clan_id", "role_ids", b"role_ids", "user_ids", b"user_ids"]) -> None: ...

global___ChangeChannelPrivateRequest = ChangeChannelPrivateRequest

@typing.final
class AddChannelUsersRequest(google.protobuf.message.Message):
    """Add users to a channel."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CHANNEL_ID_FIELD_NUMBER: builtins.int
    USER_IDS_FIELD_NUMBER: builtins.int
    channel_id: builtins.str
    """The channel to add users to."""
    @property
    def user_ids(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """The users to add."""

    def __init__(
        self,
        *,
        channel_id: builtins.str = ...,
        user_ids: collections.abc.Iterable[builtins.str] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["channel_id", b"channel_id", "user_ids", b"user_ids"]) -> None: ...

global___AddChannelUsersRequest = AddChannelUsersRequest

@typing.final
class RemoveChannelUsersRequest(google.protobuf.message.Message):
    """Kick a set of users from a channel."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CHANNEL_ID_FIELD_NUMBER: builtins.int
    USER_IDS_FIELD_NUMBER: builtins.int
    channel_id: builtins.str
    """The channel ID to kick from."""
    @property
    def user_ids(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """The users to kick."""

    def __init__(
        self,
        *,
        channel_id: builtins.str = ...,
        user_ids: collections.abc.Iterable[builtins.str] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["channel_id", b"channel_id", "user_ids", b"user_ids"]) -> None: ...

global___RemoveChannelUsersRequest = RemoveChannelUsersRequest

@typing.final
class RemoveClanUsersRequest(google.protobuf.message.Message):
    """Kick a set of users from a clan."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CLAN_ID_FIELD_NUMBER: builtins.int
    USER_IDS_FIELD_NUMBER: builtins.int
    clan_id: builtins.str
    """The clan ID to kick from."""
    @property
    def user_ids(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """The users to kick."""

    def __init__(
        self,
        *,
        clan_id: builtins.str = ...,
        user_ids: collections.abc.Iterable[builtins.str] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["clan_id", b"clan_id", "user_ids", b"user_ids"]) -> None: ...

global___RemoveClanUsersRequest = RemoveClanUsersRequest

@typing.final
class BanClanUsersRequest(google.protobuf.message.Message):
    """Ban a set of users from a channel."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CLAN_ID_FIELD_NUMBER: builtins.int
    CHANNEL_ID_FIELD_NUMBER: builtins.int
    USER_IDS_FIELD_NUMBER: builtins.int
    BAN_TIME_FIELD_NUMBER: builtins.int
    clan_id: builtins.str
    """The clan ID to kick from."""
    channel_id: builtins.str
    """The channel ID to ban"""
    ban_time: builtins.int
    """ban time"""
    @property
    def user_ids(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """The users to kick."""

    def __init__(
        self,
        *,
        clan_id: builtins.str = ...,
        channel_id: builtins.str = ...,
        user_ids: collections.abc.Iterable[builtins.str] | None = ...,
        ban_time: builtins.int = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["ban_time", b"ban_time", "channel_id", b"channel_id", "clan_id", b"clan_id", "user_ids", b"user_ids"]) -> None: ...

global___BanClanUsersRequest = BanClanUsersRequest

@typing.final
class LeaveThreadRequest(google.protobuf.message.Message):
    """Leave a channel."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CLAN_ID_FIELD_NUMBER: builtins.int
    CHANNEL_ID_FIELD_NUMBER: builtins.int
    clan_id: builtins.str
    channel_id: builtins.str
    """The channel ID to leave."""
    def __init__(
        self,
        *,
        clan_id: builtins.str = ...,
        channel_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["channel_id", b"channel_id", "clan_id", b"clan_id"]) -> None: ...

global___LeaveThreadRequest = LeaveThreadRequest

@typing.final
class Role(google.protobuf.message.Message):
    """Role record"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ID_FIELD_NUMBER: builtins.int
    TITLE_FIELD_NUMBER: builtins.int
    COLOR_FIELD_NUMBER: builtins.int
    ROLE_ICON_FIELD_NUMBER: builtins.int
    SLUG_FIELD_NUMBER: builtins.int
    DESCRIPTION_FIELD_NUMBER: builtins.int
    CREATOR_ID_FIELD_NUMBER: builtins.int
    CLAN_ID_FIELD_NUMBER: builtins.int
    ACTIVE_FIELD_NUMBER: builtins.int
    DISPLAY_ONLINE_FIELD_NUMBER: builtins.int
    ALLOW_MENTION_FIELD_NUMBER: builtins.int
    ROLE_USER_LIST_FIELD_NUMBER: builtins.int
    PERMISSION_LIST_FIELD_NUMBER: builtins.int
    ROLE_CHANNEL_ACTIVE_FIELD_NUMBER: builtins.int
    CHANNEL_IDS_FIELD_NUMBER: builtins.int
    MAX_LEVEL_PERMISSION_FIELD_NUMBER: builtins.int
    ORDER_ROLE_FIELD_NUMBER: builtins.int
    id: builtins.str
    """Role id"""
    title: builtins.str
    color: builtins.str
    role_icon: builtins.str
    slug: builtins.str
    description: builtins.str
    creator_id: builtins.str
    clan_id: builtins.str
    active: builtins.int
    display_online: builtins.int
    allow_mention: builtins.int
    role_channel_active: builtins.int
    max_level_permission: builtins.int
    order_role: builtins.int
    @property
    def role_user_list(self) -> global___RoleUserList: ...
    @property
    def permission_list(self) -> global___PermissionList: ...
    @property
    def channel_ids(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]: ...
    def __init__(
        self,
        *,
        id: builtins.str = ...,
        title: builtins.str = ...,
        color: builtins.str = ...,
        role_icon: builtins.str = ...,
        slug: builtins.str = ...,
        description: builtins.str = ...,
        creator_id: builtins.str = ...,
        clan_id: builtins.str = ...,
        active: builtins.int = ...,
        display_online: builtins.int = ...,
        allow_mention: builtins.int = ...,
        role_user_list: global___RoleUserList | None = ...,
        permission_list: global___PermissionList | None = ...,
        role_channel_active: builtins.int = ...,
        channel_ids: collections.abc.Iterable[builtins.str] | None = ...,
        max_level_permission: builtins.int = ...,
        order_role: builtins.int = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["permission_list", b"permission_list", "role_user_list", b"role_user_list"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["active", b"active", "allow_mention", b"allow_mention", "channel_ids", b"channel_ids", "clan_id", b"clan_id", "color", b"color", "creator_id", b"creator_id", "description", b"description", "display_online", b"display_online", "id", b"id", "max_level_permission", b"max_level_permission", "order_role", b"order_role", "permission_list", b"permission_list", "role_channel_active", b"role_channel_active", "role_icon", b"role_icon", "role_user_list", b"role_user_list", "slug", b"slug", "title", b"title"]) -> None: ...

global___Role = Role

@typing.final
class EventManagement(google.protobuf.message.Message):
    """Event clan"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ID_FIELD_NUMBER: builtins.int
    TITLE_FIELD_NUMBER: builtins.int
    LOGO_FIELD_NUMBER: builtins.int
    DESCRIPTION_FIELD_NUMBER: builtins.int
    ACTIVE_FIELD_NUMBER: builtins.int
    START_EVENT_FIELD_NUMBER: builtins.int
    CREATOR_ID_FIELD_NUMBER: builtins.int
    CLAN_ID_FIELD_NUMBER: builtins.int
    CHANNEL_VOICE_ID_FIELD_NUMBER: builtins.int
    ADDRESS_FIELD_NUMBER: builtins.int
    START_TIME_FIELD_NUMBER: builtins.int
    END_TIME_FIELD_NUMBER: builtins.int
    USER_IDS_FIELD_NUMBER: builtins.int
    CREATE_TIME_FIELD_NUMBER: builtins.int
    MAX_PERMISSION_FIELD_NUMBER: builtins.int
    CHANNEL_ID_FIELD_NUMBER: builtins.int
    EVENT_STATUS_FIELD_NUMBER: builtins.int
    REPEAT_TYPE_FIELD_NUMBER: builtins.int
    IS_PRIVATE_FIELD_NUMBER: builtins.int
    MEET_ROOM_FIELD_NUMBER: builtins.int
    id: builtins.str
    title: builtins.str
    logo: builtins.str
    description: builtins.str
    active: builtins.int
    start_event: builtins.int
    creator_id: builtins.str
    clan_id: builtins.str
    channel_voice_id: builtins.str
    address: builtins.str
    max_permission: builtins.int
    channel_id: builtins.str
    event_status: builtins.int
    repeat_type: builtins.int
    is_private: builtins.bool
    @property
    def start_time(self) -> google.protobuf.timestamp_pb2.Timestamp: ...
    @property
    def end_time(self) -> google.protobuf.timestamp_pb2.Timestamp: ...
    @property
    def user_ids(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]: ...
    @property
    def create_time(self) -> google.protobuf.timestamp_pb2.Timestamp: ...
    @property
    def meet_room(self) -> global___GenerateMezonMeetResponse: ...
    def __init__(
        self,
        *,
        id: builtins.str = ...,
        title: builtins.str = ...,
        logo: builtins.str = ...,
        description: builtins.str = ...,
        active: builtins.int = ...,
        start_event: builtins.int = ...,
        creator_id: builtins.str = ...,
        clan_id: builtins.str = ...,
        channel_voice_id: builtins.str = ...,
        address: builtins.str = ...,
        start_time: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        end_time: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        user_ids: collections.abc.Iterable[builtins.str] | None = ...,
        create_time: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        max_permission: builtins.int = ...,
        channel_id: builtins.str = ...,
        event_status: builtins.int = ...,
        repeat_type: builtins.int = ...,
        is_private: builtins.bool = ...,
        meet_room: global___GenerateMezonMeetResponse | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["create_time", b"create_time", "end_time", b"end_time", "meet_room", b"meet_room", "start_time", b"start_time"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["active", b"active", "address", b"address", "channel_id", b"channel_id", "channel_voice_id", b"channel_voice_id", "clan_id", b"clan_id", "create_time", b"create_time", "creator_id", b"creator_id", "description", b"description", "end_time", b"end_time", "event_status", b"event_status", "id", b"id", "is_private", b"is_private", "logo", b"logo", "max_permission", b"max_permission", "meet_room", b"meet_room", "repeat_type", b"repeat_type", "start_event", b"start_event", "start_time", b"start_time", "title", b"title", "user_ids", b"user_ids"]) -> None: ...

global___EventManagement = EventManagement

@typing.final
class Permission(google.protobuf.message.Message):
    """Permission record"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ID_FIELD_NUMBER: builtins.int
    TITLE_FIELD_NUMBER: builtins.int
    SLUG_FIELD_NUMBER: builtins.int
    DESCRIPTION_FIELD_NUMBER: builtins.int
    ACTIVE_FIELD_NUMBER: builtins.int
    SCOPE_FIELD_NUMBER: builtins.int
    LEVEL_FIELD_NUMBER: builtins.int
    id: builtins.str
    """Permission id"""
    title: builtins.str
    slug: builtins.str
    description: builtins.str
    active: builtins.int
    scope: builtins.int
    level: builtins.int
    def __init__(
        self,
        *,
        id: builtins.str = ...,
        title: builtins.str = ...,
        slug: builtins.str = ...,
        description: builtins.str = ...,
        active: builtins.int = ...,
        scope: builtins.int = ...,
        level: builtins.int = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["active", b"active", "description", b"description", "id", b"id", "level", b"level", "scope", b"scope", "slug", b"slug", "title", b"title"]) -> None: ...

global___Permission = Permission

@typing.final
class NotificationSetting(google.protobuf.message.Message):
    """Notification setting record"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ID_FIELD_NUMBER: builtins.int
    NOTIFICATION_SETTING_TYPE_FIELD_NUMBER: builtins.int
    id: builtins.str
    """Notification id"""
    notification_setting_type: builtins.int
    """Notification title"""
    def __init__(
        self,
        *,
        id: builtins.str = ...,
        notification_setting_type: builtins.int = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["id", b"id", "notification_setting_type", b"notification_setting_type"]) -> None: ...

global___NotificationSetting = NotificationSetting

@typing.final
class DeletePinMessage(google.protobuf.message.Message):
    """"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ID_FIELD_NUMBER: builtins.int
    MESSAGE_ID_FIELD_NUMBER: builtins.int
    CHANNEL_ID_FIELD_NUMBER: builtins.int
    CLAN_ID_FIELD_NUMBER: builtins.int
    id: builtins.str
    """"""
    message_id: builtins.str
    """"""
    channel_id: builtins.str
    """"""
    clan_id: builtins.str
    """"""
    def __init__(
        self,
        *,
        id: builtins.str = ...,
        message_id: builtins.str = ...,
        channel_id: builtins.str = ...,
        clan_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["channel_id", b"channel_id", "clan_id", b"clan_id", "id", b"id", "message_id", b"message_id"]) -> None: ...

global___DeletePinMessage = DeletePinMessage

@typing.final
class PinMessage(google.protobuf.message.Message):
    """"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ID_FIELD_NUMBER: builtins.int
    MESSAGE_ID_FIELD_NUMBER: builtins.int
    CHANNEL_ID_FIELD_NUMBER: builtins.int
    SENDER_ID_FIELD_NUMBER: builtins.int
    CONTENT_FIELD_NUMBER: builtins.int
    USERNAME_FIELD_NUMBER: builtins.int
    AVATAR_FIELD_NUMBER: builtins.int
    CREATE_TIME_FIELD_NUMBER: builtins.int
    CREATE_TIME_SECONDS_FIELD_NUMBER: builtins.int
    ATTACHMENT_FIELD_NUMBER: builtins.int
    id: builtins.str
    """"""
    message_id: builtins.str
    """"""
    channel_id: builtins.str
    """"""
    sender_id: builtins.str
    """"""
    content: builtins.str
    """"""
    username: builtins.str
    """"""
    avatar: builtins.str
    """"""
    create_time_seconds: builtins.int
    """create time in ms"""
    attachment: builtins.str
    """attachment"""
    @property
    def create_time(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """The UNIX time (for gRPC clients) or ISO string (for REST clients) when the message was created."""

    def __init__(
        self,
        *,
        id: builtins.str = ...,
        message_id: builtins.str = ...,
        channel_id: builtins.str = ...,
        sender_id: builtins.str = ...,
        content: builtins.str = ...,
        username: builtins.str = ...,
        avatar: builtins.str = ...,
        create_time: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        create_time_seconds: builtins.int = ...,
        attachment: builtins.str = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["create_time", b"create_time"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["attachment", b"attachment", "avatar", b"avatar", "channel_id", b"channel_id", "content", b"content", "create_time", b"create_time", "create_time_seconds", b"create_time_seconds", "id", b"id", "message_id", b"message_id", "sender_id", b"sender_id", "username", b"username"]) -> None: ...

global___PinMessage = PinMessage

@typing.final
class PinMessagesList(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    PIN_MESSAGES_LIST_FIELD_NUMBER: builtins.int
    @property
    def pin_messages_list(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___PinMessage]: ...
    def __init__(
        self,
        *,
        pin_messages_list: collections.abc.Iterable[global___PinMessage] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["pin_messages_list", b"pin_messages_list"]) -> None: ...

global___PinMessagesList = PinMessagesList

@typing.final
class NotificationUserChannel(google.protobuf.message.Message):
    """Notification channel"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ID_FIELD_NUMBER: builtins.int
    NOTIFICATION_SETTING_TYPE_FIELD_NUMBER: builtins.int
    TIME_MUTE_FIELD_NUMBER: builtins.int
    ACTIVE_FIELD_NUMBER: builtins.int
    CHANNEL_ID_FIELD_NUMBER: builtins.int
    id: builtins.str
    """Notification id"""
    notification_setting_type: builtins.int
    """"""
    active: builtins.int
    """"""
    channel_id: builtins.str
    """"""
    @property
    def time_mute(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """"""

    def __init__(
        self,
        *,
        id: builtins.str = ...,
        notification_setting_type: builtins.int = ...,
        time_mute: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        active: builtins.int = ...,
        channel_id: builtins.str = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["time_mute", b"time_mute"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["active", b"active", "channel_id", b"channel_id", "id", b"id", "notification_setting_type", b"notification_setting_type", "time_mute", b"time_mute"]) -> None: ...

global___NotificationUserChannel = NotificationUserChannel

@typing.final
class NotifiReactMessage(google.protobuf.message.Message):
    """Notification channel"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ID_FIELD_NUMBER: builtins.int
    USER_ID_FIELD_NUMBER: builtins.int
    CHANNEL_ID_FIELD_NUMBER: builtins.int
    id: builtins.str
    """Notification id"""
    user_id: builtins.str
    """"""
    channel_id: builtins.str
    """"""
    def __init__(
        self,
        *,
        id: builtins.str = ...,
        user_id: builtins.str = ...,
        channel_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["channel_id", b"channel_id", "id", b"id", "user_id", b"user_id"]) -> None: ...

global___NotifiReactMessage = NotifiReactMessage

@typing.final
class DefaultNotificationClan(google.protobuf.message.Message):
    """"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CLAN_ID_FIELD_NUMBER: builtins.int
    clan_id: builtins.str
    """"""
    def __init__(
        self,
        *,
        clan_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["clan_id", b"clan_id"]) -> None: ...

global___DefaultNotificationClan = DefaultNotificationClan

@typing.final
class DefaultNotificationCategory(google.protobuf.message.Message):
    """"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CATEGORY_ID_FIELD_NUMBER: builtins.int
    category_id: builtins.str
    """"""
    def __init__(
        self,
        *,
        category_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["category_id", b"category_id"]) -> None: ...

global___DefaultNotificationCategory = DefaultNotificationCategory

@typing.final
class NotificationChannel(google.protobuf.message.Message):
    """"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CHANNEL_ID_FIELD_NUMBER: builtins.int
    channel_id: builtins.str
    """"""
    def __init__(
        self,
        *,
        channel_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["channel_id", b"channel_id"]) -> None: ...

global___NotificationChannel = NotificationChannel

@typing.final
class NotificationClan(google.protobuf.message.Message):
    """"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CLAN_ID_FIELD_NUMBER: builtins.int
    clan_id: builtins.str
    """"""
    def __init__(
        self,
        *,
        clan_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["clan_id", b"clan_id"]) -> None: ...

global___NotificationClan = NotificationClan

@typing.final
class NotificationSettingList(google.protobuf.message.Message):
    """"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    NOTIFICATION_SETTING_FIELD_NUMBER: builtins.int
    @property
    def notification_setting(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___NotificationSetting]:
        """A list of notification setting."""

    def __init__(
        self,
        *,
        notification_setting: collections.abc.Iterable[global___NotificationSetting] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["notification_setting", b"notification_setting"]) -> None: ...

global___NotificationSettingList = NotificationSettingList

@typing.final
class SetNotificationRequest(google.protobuf.message.Message):
    """set notification"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CHANNEL_CATEGORY_ID_FIELD_NUMBER: builtins.int
    NOTIFICATION_TYPE_FIELD_NUMBER: builtins.int
    TIME_MUTE_FIELD_NUMBER: builtins.int
    CLAN_ID_FIELD_NUMBER: builtins.int
    channel_category_id: builtins.str
    """channelId or categoryId"""
    notification_type: builtins.int
    """notification_type"""
    clan_id: builtins.str
    """"""
    @property
    def time_mute(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """time mute channel category"""

    def __init__(
        self,
        *,
        channel_category_id: builtins.str = ...,
        notification_type: builtins.int = ...,
        time_mute: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        clan_id: builtins.str = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["time_mute", b"time_mute"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["channel_category_id", b"channel_category_id", "clan_id", b"clan_id", "notification_type", b"notification_type", "time_mute", b"time_mute"]) -> None: ...

global___SetNotificationRequest = SetNotificationRequest

@typing.final
class PinMessageRequest(google.protobuf.message.Message):
    """"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    MESSAGE_ID_FIELD_NUMBER: builtins.int
    CHANNEL_ID_FIELD_NUMBER: builtins.int
    CLAN_ID_FIELD_NUMBER: builtins.int
    message_id: builtins.str
    channel_id: builtins.str
    clan_id: builtins.str
    def __init__(
        self,
        *,
        message_id: builtins.str = ...,
        channel_id: builtins.str = ...,
        clan_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["channel_id", b"channel_id", "clan_id", b"clan_id", "message_id", b"message_id"]) -> None: ...

global___PinMessageRequest = PinMessageRequest

@typing.final
class SetMuteNotificationRequest(google.protobuf.message.Message):
    """set notification"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ID_FIELD_NUMBER: builtins.int
    NOTIFICATION_TYPE_FIELD_NUMBER: builtins.int
    ACTIVE_FIELD_NUMBER: builtins.int
    id: builtins.str
    """channel_id and category_id"""
    notification_type: builtins.int
    active: builtins.int
    def __init__(
        self,
        *,
        id: builtins.str = ...,
        notification_type: builtins.int = ...,
        active: builtins.int = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["active", b"active", "id", b"id", "notification_type", b"notification_type"]) -> None: ...

global___SetMuteNotificationRequest = SetMuteNotificationRequest

@typing.final
class HashtagDmListRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    USER_ID_FIELD_NUMBER: builtins.int
    LIMIT_FIELD_NUMBER: builtins.int
    @property
    def user_id(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """user Id"""

    @property
    def limit(self) -> google.protobuf.wrappers_pb2.Int32Value:
        """Max number of records to return. Between 1 and 100."""

    def __init__(
        self,
        *,
        user_id: collections.abc.Iterable[builtins.str] | None = ...,
        limit: google.protobuf.wrappers_pb2.Int32Value | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["limit", b"limit"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["limit", b"limit", "user_id", b"user_id"]) -> None: ...

global___HashtagDmListRequest = HashtagDmListRequest

@typing.final
class HashtagDmList(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    HASHTAG_DM_FIELD_NUMBER: builtins.int
    @property
    def hashtag_dm(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___HashtagDm]: ...
    def __init__(
        self,
        *,
        hashtag_dm: collections.abc.Iterable[global___HashtagDm] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["hashtag_dm", b"hashtag_dm"]) -> None: ...

global___HashtagDmList = HashtagDmList

@typing.final
class HashtagDm(google.protobuf.message.Message):
    """hashtagDM"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CHANNEL_ID_FIELD_NUMBER: builtins.int
    CHANNEL_LABEL_FIELD_NUMBER: builtins.int
    CLAN_ID_FIELD_NUMBER: builtins.int
    CLAN_NAME_FIELD_NUMBER: builtins.int
    MEETING_CODE_FIELD_NUMBER: builtins.int
    TYPE_FIELD_NUMBER: builtins.int
    CHANNEL_PRIVATE_FIELD_NUMBER: builtins.int
    PARENT_ID_FIELD_NUMBER: builtins.int
    channel_id: builtins.str
    """The channel id."""
    channel_label: builtins.str
    """The channel lable"""
    clan_id: builtins.str
    """The clan of this channel"""
    clan_name: builtins.str
    """The clan name"""
    meeting_code: builtins.str
    """"""
    type: builtins.int
    """"""
    channel_private: builtins.int
    """"""
    parent_id: builtins.str
    """"""
    def __init__(
        self,
        *,
        channel_id: builtins.str = ...,
        channel_label: builtins.str = ...,
        clan_id: builtins.str = ...,
        clan_name: builtins.str = ...,
        meeting_code: builtins.str = ...,
        type: builtins.int = ...,
        channel_private: builtins.int = ...,
        parent_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["channel_id", b"channel_id", "channel_label", b"channel_label", "channel_private", b"channel_private", "clan_id", b"clan_id", "clan_name", b"clan_name", "meeting_code", b"meeting_code", "parent_id", b"parent_id", "type", b"type"]) -> None: ...

global___HashtagDm = HashtagDm

@typing.final
class NotificationChannelCategorySettingList(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    NOTIFICATION_CHANNEL_CATEGORY_SETTINGS_LIST_FIELD_NUMBER: builtins.int
    @property
    def notification_channel_category_settings_list(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___NotificationChannelCategorySetting]: ...
    def __init__(
        self,
        *,
        notification_channel_category_settings_list: collections.abc.Iterable[global___NotificationChannelCategorySetting] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["notification_channel_category_settings_list", b"notification_channel_category_settings_list"]) -> None: ...

global___NotificationChannelCategorySettingList = NotificationChannelCategorySettingList

@typing.final
class NotificationChannelCategorySetting(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ID_FIELD_NUMBER: builtins.int
    CHANNEL_CATEGORY_LABEL_FIELD_NUMBER: builtins.int
    NOTIFICATION_SETTING_TYPE_FIELD_NUMBER: builtins.int
    CHANNEL_CATEGORY_TITLE_FIELD_NUMBER: builtins.int
    ACTION_FIELD_NUMBER: builtins.int
    id: builtins.str
    """Notification id"""
    channel_category_label: builtins.str
    """"""
    notification_setting_type: builtins.int
    """Notification title"""
    channel_category_title: builtins.str
    """"""
    action: builtins.int
    """"""
    def __init__(
        self,
        *,
        id: builtins.str = ...,
        channel_category_label: builtins.str = ...,
        notification_setting_type: builtins.int = ...,
        channel_category_title: builtins.str = ...,
        action: builtins.int = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["action", b"action", "channel_category_label", b"channel_category_label", "channel_category_title", b"channel_category_title", "id", b"id", "notification_setting_type", b"notification_setting_type"]) -> None: ...

global___NotificationChannelCategorySetting = NotificationChannelCategorySetting

@typing.final
class SetDefaultNotificationRequest(google.protobuf.message.Message):
    """set default notification"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CLAN_ID_FIELD_NUMBER: builtins.int
    NOTIFICATION_TYPE_FIELD_NUMBER: builtins.int
    CATEGORY_ID_FIELD_NUMBER: builtins.int
    clan_id: builtins.str
    notification_type: builtins.int
    category_id: builtins.str
    def __init__(
        self,
        *,
        clan_id: builtins.str = ...,
        notification_type: builtins.int = ...,
        category_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["category_id", b"category_id", "clan_id", b"clan_id", "notification_type", b"notification_type"]) -> None: ...

global___SetDefaultNotificationRequest = SetDefaultNotificationRequest

@typing.final
class RoleList(google.protobuf.message.Message):
    """A list of role description, usually a result of a list operation."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ROLES_FIELD_NUMBER: builtins.int
    NEXT_CURSOR_FIELD_NUMBER: builtins.int
    PREV_CURSOR_FIELD_NUMBER: builtins.int
    CACHEABLE_CURSOR_FIELD_NUMBER: builtins.int
    next_cursor: builtins.str
    """The cursor to send when retrieving the next page, if any."""
    prev_cursor: builtins.str
    """The cursor to send when retrieving the previous page, if any."""
    cacheable_cursor: builtins.str
    """Cacheable cursor to list newer role description. Durable and designed to be stored, unlike next/prev cursors."""
    @property
    def roles(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___Role]:
        """A list of role."""

    def __init__(
        self,
        *,
        roles: collections.abc.Iterable[global___Role] | None = ...,
        next_cursor: builtins.str = ...,
        prev_cursor: builtins.str = ...,
        cacheable_cursor: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["cacheable_cursor", b"cacheable_cursor", "next_cursor", b"next_cursor", "prev_cursor", b"prev_cursor", "roles", b"roles"]) -> None: ...

global___RoleList = RoleList

@typing.final
class EventList(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    EVENTS_FIELD_NUMBER: builtins.int
    @property
    def events(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___EventManagement]:
        """A list of event."""

    def __init__(
        self,
        *,
        events: collections.abc.Iterable[global___EventManagement] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["events", b"events"]) -> None: ...

global___EventList = EventList

@typing.final
class PermissionList(google.protobuf.message.Message):
    """A list of permission description, usually a result of a list operation."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    PERMISSIONS_FIELD_NUMBER: builtins.int
    MAX_LEVEL_PERMISSION_FIELD_NUMBER: builtins.int
    max_level_permission: builtins.int
    """level permission max"""
    @property
    def permissions(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___Permission]:
        """A list of permission."""

    def __init__(
        self,
        *,
        permissions: collections.abc.Iterable[global___Permission] | None = ...,
        max_level_permission: builtins.int = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["max_level_permission", b"max_level_permission", "permissions", b"permissions"]) -> None: ...

global___PermissionList = PermissionList

@typing.final
class ListPermissionsRequest(google.protobuf.message.Message):
    """List (and optionally filter) permissions."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ROLE_ID_FIELD_NUMBER: builtins.int
    role_id: builtins.str
    def __init__(
        self,
        *,
        role_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["role_id", b"role_id"]) -> None: ...

global___ListPermissionsRequest = ListPermissionsRequest

@typing.final
class ListRoleUsersRequest(google.protobuf.message.Message):
    """List (and optionally filter) role-users."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ROLE_ID_FIELD_NUMBER: builtins.int
    LIMIT_FIELD_NUMBER: builtins.int
    CURSOR_FIELD_NUMBER: builtins.int
    role_id: builtins.str
    cursor: builtins.str
    """An optional next page cursor."""
    @property
    def limit(self) -> google.protobuf.wrappers_pb2.Int32Value:
        """Max number of records to return. Between 1 and 100."""

    def __init__(
        self,
        *,
        role_id: builtins.str = ...,
        limit: google.protobuf.wrappers_pb2.Int32Value | None = ...,
        cursor: builtins.str = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["limit", b"limit"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["cursor", b"cursor", "limit", b"limit", "role_id", b"role_id"]) -> None: ...

global___ListRoleUsersRequest = ListRoleUsersRequest

@typing.final
class ListPermissionOfUsersRequest(google.protobuf.message.Message):
    """List Permission Of User In The Clan."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CLAN_ID_FIELD_NUMBER: builtins.int
    CHANNEL_ID_FIELD_NUMBER: builtins.int
    clan_id: builtins.str
    """clan_id."""
    channel_id: builtins.str
    """channel_id"""
    def __init__(
        self,
        *,
        clan_id: builtins.str = ...,
        channel_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["channel_id", b"channel_id", "clan_id", b"clan_id"]) -> None: ...

global___ListPermissionOfUsersRequest = ListPermissionOfUsersRequest

@typing.final
class RoleUserList(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    @typing.final
    class RoleUser(google.protobuf.message.Message):
        """A single user-role pair."""

        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        ID_FIELD_NUMBER: builtins.int
        USERNAME_FIELD_NUMBER: builtins.int
        DISPLAY_NAME_FIELD_NUMBER: builtins.int
        AVATAR_URL_FIELD_NUMBER: builtins.int
        LANG_TAG_FIELD_NUMBER: builtins.int
        LOCATION_FIELD_NUMBER: builtins.int
        ONLINE_FIELD_NUMBER: builtins.int
        id: builtins.str
        """The id of the user's account."""
        username: builtins.str
        """The username of the user's account."""
        display_name: builtins.str
        """The display name of the user."""
        avatar_url: builtins.str
        """A URL for an avatar image."""
        lang_tag: builtins.str
        """The language expected to be a tag which follows the BCP-47 spec."""
        location: builtins.str
        """The location set by the user."""
        online: builtins.bool
        """The timezone set by the user."""
        def __init__(
            self,
            *,
            id: builtins.str = ...,
            username: builtins.str = ...,
            display_name: builtins.str = ...,
            avatar_url: builtins.str = ...,
            lang_tag: builtins.str = ...,
            location: builtins.str = ...,
            online: builtins.bool = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing.Literal["avatar_url", b"avatar_url", "display_name", b"display_name", "id", b"id", "lang_tag", b"lang_tag", "location", b"location", "online", b"online", "username", b"username"]) -> None: ...

    ROLE_USERS_FIELD_NUMBER: builtins.int
    CURSOR_FIELD_NUMBER: builtins.int
    cursor: builtins.str
    """Cursor for the next page of results, if any."""
    @property
    def role_users(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___RoleUserList.RoleUser]:
        """role_users pairs for a clan."""

    def __init__(
        self,
        *,
        role_users: collections.abc.Iterable[global___RoleUserList.RoleUser] | None = ...,
        cursor: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["cursor", b"cursor", "role_users", b"role_users"]) -> None: ...

global___RoleUserList = RoleUserList

@typing.final
class UserEventRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CLAN_ID_FIELD_NUMBER: builtins.int
    EVENT_ID_FIELD_NUMBER: builtins.int
    clan_id: builtins.str
    """The ID of the clan to be updated."""
    event_id: builtins.str
    """The ID of the event to be updated."""
    def __init__(
        self,
        *,
        clan_id: builtins.str = ...,
        event_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["clan_id", b"clan_id", "event_id", b"event_id"]) -> None: ...

global___UserEventRequest = UserEventRequest

@typing.final
class ListEventsRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CLAN_ID_FIELD_NUMBER: builtins.int
    clan_id: builtins.str
    """The clan of this event"""
    def __init__(
        self,
        *,
        clan_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["clan_id", b"clan_id"]) -> None: ...

global___ListEventsRequest = ListEventsRequest

@typing.final
class CreateRoleRequest(google.protobuf.message.Message):
    """Create a role within clan."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    TITLE_FIELD_NUMBER: builtins.int
    COLOR_FIELD_NUMBER: builtins.int
    ROLE_ICON_FIELD_NUMBER: builtins.int
    DESCRIPTION_FIELD_NUMBER: builtins.int
    CLAN_ID_FIELD_NUMBER: builtins.int
    DISPLAY_ONLINE_FIELD_NUMBER: builtins.int
    ALLOW_MENTION_FIELD_NUMBER: builtins.int
    MAX_PERMISSION_ID_FIELD_NUMBER: builtins.int
    ADD_USER_IDS_FIELD_NUMBER: builtins.int
    ACTIVE_PERMISSION_IDS_FIELD_NUMBER: builtins.int
    ORDER_ROLE_FIELD_NUMBER: builtins.int
    title: builtins.str
    color: builtins.str
    role_icon: builtins.str
    description: builtins.str
    clan_id: builtins.str
    display_online: builtins.int
    allow_mention: builtins.int
    max_permission_id: builtins.str
    """id of permission which has max level permission"""
    order_role: builtins.int
    """order role"""
    @property
    def add_user_ids(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """The users to add."""

    @property
    def active_permission_ids(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """The permissions to add."""

    def __init__(
        self,
        *,
        title: builtins.str = ...,
        color: builtins.str = ...,
        role_icon: builtins.str = ...,
        description: builtins.str = ...,
        clan_id: builtins.str = ...,
        display_online: builtins.int = ...,
        allow_mention: builtins.int = ...,
        max_permission_id: builtins.str = ...,
        add_user_ids: collections.abc.Iterable[builtins.str] | None = ...,
        active_permission_ids: collections.abc.Iterable[builtins.str] | None = ...,
        order_role: builtins.int = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["active_permission_ids", b"active_permission_ids", "add_user_ids", b"add_user_ids", "allow_mention", b"allow_mention", "clan_id", b"clan_id", "color", b"color", "description", b"description", "display_online", b"display_online", "max_permission_id", b"max_permission_id", "order_role", b"order_role", "role_icon", b"role_icon", "title", b"title"]) -> None: ...

global___CreateRoleRequest = CreateRoleRequest

@typing.final
class CreateEventRequest(google.protobuf.message.Message):
    """Create a event within clan."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    TITLE_FIELD_NUMBER: builtins.int
    LOGO_FIELD_NUMBER: builtins.int
    DESCRIPTION_FIELD_NUMBER: builtins.int
    CLAN_ID_FIELD_NUMBER: builtins.int
    CHANNEL_VOICE_ID_FIELD_NUMBER: builtins.int
    ADDRESS_FIELD_NUMBER: builtins.int
    START_TIME_FIELD_NUMBER: builtins.int
    END_TIME_FIELD_NUMBER: builtins.int
    EVENT_ID_FIELD_NUMBER: builtins.int
    EVENT_STATUS_FIELD_NUMBER: builtins.int
    CHANNEL_ID_FIELD_NUMBER: builtins.int
    ACTION_FIELD_NUMBER: builtins.int
    REPEAT_TYPE_FIELD_NUMBER: builtins.int
    CREATOR_ID_FIELD_NUMBER: builtins.int
    USER_ID_FIELD_NUMBER: builtins.int
    IS_PRIVATE_FIELD_NUMBER: builtins.int
    MEET_ROOM_FIELD_NUMBER: builtins.int
    title: builtins.str
    logo: builtins.str
    description: builtins.str
    clan_id: builtins.str
    channel_voice_id: builtins.str
    address: builtins.str
    event_id: builtins.str
    event_status: builtins.int
    channel_id: builtins.str
    action: builtins.int
    repeat_type: builtins.int
    creator_id: builtins.str
    user_id: builtins.str
    @property
    def start_time(self) -> google.protobuf.timestamp_pb2.Timestamp: ...
    @property
    def end_time(self) -> google.protobuf.timestamp_pb2.Timestamp: ...
    @property
    def is_private(self) -> google.protobuf.wrappers_pb2.BoolValue: ...
    @property
    def meet_room(self) -> global___GenerateMezonMeetResponse: ...
    def __init__(
        self,
        *,
        title: builtins.str = ...,
        logo: builtins.str = ...,
        description: builtins.str = ...,
        clan_id: builtins.str = ...,
        channel_voice_id: builtins.str = ...,
        address: builtins.str = ...,
        start_time: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        end_time: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        event_id: builtins.str = ...,
        event_status: builtins.int = ...,
        channel_id: builtins.str = ...,
        action: builtins.int = ...,
        repeat_type: builtins.int = ...,
        creator_id: builtins.str = ...,
        user_id: builtins.str = ...,
        is_private: google.protobuf.wrappers_pb2.BoolValue | None = ...,
        meet_room: global___GenerateMezonMeetResponse | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["end_time", b"end_time", "is_private", b"is_private", "meet_room", b"meet_room", "start_time", b"start_time"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["action", b"action", "address", b"address", "channel_id", b"channel_id", "channel_voice_id", b"channel_voice_id", "clan_id", b"clan_id", "creator_id", b"creator_id", "description", b"description", "end_time", b"end_time", "event_id", b"event_id", "event_status", b"event_status", "is_private", b"is_private", "logo", b"logo", "meet_room", b"meet_room", "repeat_type", b"repeat_type", "start_time", b"start_time", "title", b"title", "user_id", b"user_id"]) -> None: ...

global___CreateEventRequest = CreateEventRequest

@typing.final
class UpdateEventRequest(google.protobuf.message.Message):
    """update a event within clan."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    TITLE_FIELD_NUMBER: builtins.int
    LOGO_FIELD_NUMBER: builtins.int
    DESCRIPTION_FIELD_NUMBER: builtins.int
    EVENT_ID_FIELD_NUMBER: builtins.int
    CHANNEL_ID_FIELD_NUMBER: builtins.int
    ADDRESS_FIELD_NUMBER: builtins.int
    START_TIME_FIELD_NUMBER: builtins.int
    END_TIME_FIELD_NUMBER: builtins.int
    CLAN_ID_FIELD_NUMBER: builtins.int
    CREATOR_ID_FIELD_NUMBER: builtins.int
    CHANNEL_VOICE_ID_FIELD_NUMBER: builtins.int
    CHANNEL_ID_OLD_FIELD_NUMBER: builtins.int
    REPEAT_TYPE_FIELD_NUMBER: builtins.int
    title: builtins.str
    logo: builtins.str
    description: builtins.str
    event_id: builtins.str
    channel_id: builtins.str
    address: builtins.str
    clan_id: builtins.str
    creator_id: builtins.str
    channel_voice_id: builtins.str
    channel_id_old: builtins.str
    repeat_type: builtins.int
    @property
    def start_time(self) -> google.protobuf.timestamp_pb2.Timestamp: ...
    @property
    def end_time(self) -> google.protobuf.timestamp_pb2.Timestamp: ...
    def __init__(
        self,
        *,
        title: builtins.str = ...,
        logo: builtins.str = ...,
        description: builtins.str = ...,
        event_id: builtins.str = ...,
        channel_id: builtins.str = ...,
        address: builtins.str = ...,
        start_time: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        end_time: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        clan_id: builtins.str = ...,
        creator_id: builtins.str = ...,
        channel_voice_id: builtins.str = ...,
        channel_id_old: builtins.str = ...,
        repeat_type: builtins.int = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["end_time", b"end_time", "start_time", b"start_time"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["address", b"address", "channel_id", b"channel_id", "channel_id_old", b"channel_id_old", "channel_voice_id", b"channel_voice_id", "clan_id", b"clan_id", "creator_id", b"creator_id", "description", b"description", "end_time", b"end_time", "event_id", b"event_id", "logo", b"logo", "repeat_type", b"repeat_type", "start_time", b"start_time", "title", b"title"]) -> None: ...

global___UpdateEventRequest = UpdateEventRequest

@typing.final
class DeleteRoleRequest(google.protobuf.message.Message):
    """Delete a role the user has access to."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ROLE_ID_FIELD_NUMBER: builtins.int
    CHANNEL_ID_FIELD_NUMBER: builtins.int
    CLAN_ID_FIELD_NUMBER: builtins.int
    ROLE_LABEL_FIELD_NUMBER: builtins.int
    role_id: builtins.str
    """The id of a role."""
    channel_id: builtins.str
    """The id of a channel"""
    clan_id: builtins.str
    """clan_id"""
    role_label: builtins.str
    """role label"""
    def __init__(
        self,
        *,
        role_id: builtins.str = ...,
        channel_id: builtins.str = ...,
        clan_id: builtins.str = ...,
        role_label: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["channel_id", b"channel_id", "clan_id", b"clan_id", "role_id", b"role_id", "role_label", b"role_label"]) -> None: ...

global___DeleteRoleRequest = DeleteRoleRequest

@typing.final
class DeleteEventRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    EVENT_ID_FIELD_NUMBER: builtins.int
    CLAN_ID_FIELD_NUMBER: builtins.int
    CREATOR_ID_FIELD_NUMBER: builtins.int
    EVENT_LABEL_FIELD_NUMBER: builtins.int
    CHANNEL_ID_FIELD_NUMBER: builtins.int
    event_id: builtins.str
    """The id of a event."""
    clan_id: builtins.str
    """clan id"""
    creator_id: builtins.str
    """creator id"""
    event_label: builtins.str
    """event label"""
    channel_id: builtins.str
    """channel id"""
    def __init__(
        self,
        *,
        event_id: builtins.str = ...,
        clan_id: builtins.str = ...,
        creator_id: builtins.str = ...,
        event_label: builtins.str = ...,
        channel_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["channel_id", b"channel_id", "clan_id", b"clan_id", "creator_id", b"creator_id", "event_id", b"event_id", "event_label", b"event_label"]) -> None: ...

global___DeleteEventRequest = DeleteEventRequest

@typing.final
class UpdateRoleRequest(google.protobuf.message.Message):
    """Update fields in a given role."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ROLE_ID_FIELD_NUMBER: builtins.int
    TITLE_FIELD_NUMBER: builtins.int
    COLOR_FIELD_NUMBER: builtins.int
    ROLE_ICON_FIELD_NUMBER: builtins.int
    DESCRIPTION_FIELD_NUMBER: builtins.int
    DISPLAY_ONLINE_FIELD_NUMBER: builtins.int
    ALLOW_MENTION_FIELD_NUMBER: builtins.int
    ADD_USER_IDS_FIELD_NUMBER: builtins.int
    ACTIVE_PERMISSION_IDS_FIELD_NUMBER: builtins.int
    REMOVE_USER_IDS_FIELD_NUMBER: builtins.int
    REMOVE_PERMISSION_IDS_FIELD_NUMBER: builtins.int
    CLAN_ID_FIELD_NUMBER: builtins.int
    MAX_PERMISSION_ID_FIELD_NUMBER: builtins.int
    role_id: builtins.str
    """The ID of the role to update."""
    clan_id: builtins.str
    """the clan id"""
    max_permission_id: builtins.str
    """id of permission which has max level permission"""
    @property
    def title(self) -> google.protobuf.wrappers_pb2.StringValue: ...
    @property
    def color(self) -> google.protobuf.wrappers_pb2.StringValue: ...
    @property
    def role_icon(self) -> google.protobuf.wrappers_pb2.StringValue: ...
    @property
    def description(self) -> google.protobuf.wrappers_pb2.StringValue: ...
    @property
    def display_online(self) -> google.protobuf.wrappers_pb2.Int32Value: ...
    @property
    def allow_mention(self) -> google.protobuf.wrappers_pb2.Int32Value: ...
    @property
    def add_user_ids(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """The users to add."""

    @property
    def active_permission_ids(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """The permissions to add."""

    @property
    def remove_user_ids(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """The users to remove."""

    @property
    def remove_permission_ids(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """The permissions to remove."""

    def __init__(
        self,
        *,
        role_id: builtins.str = ...,
        title: google.protobuf.wrappers_pb2.StringValue | None = ...,
        color: google.protobuf.wrappers_pb2.StringValue | None = ...,
        role_icon: google.protobuf.wrappers_pb2.StringValue | None = ...,
        description: google.protobuf.wrappers_pb2.StringValue | None = ...,
        display_online: google.protobuf.wrappers_pb2.Int32Value | None = ...,
        allow_mention: google.protobuf.wrappers_pb2.Int32Value | None = ...,
        add_user_ids: collections.abc.Iterable[builtins.str] | None = ...,
        active_permission_ids: collections.abc.Iterable[builtins.str] | None = ...,
        remove_user_ids: collections.abc.Iterable[builtins.str] | None = ...,
        remove_permission_ids: collections.abc.Iterable[builtins.str] | None = ...,
        clan_id: builtins.str = ...,
        max_permission_id: builtins.str = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["allow_mention", b"allow_mention", "color", b"color", "description", b"description", "display_online", b"display_online", "role_icon", b"role_icon", "title", b"title"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["active_permission_ids", b"active_permission_ids", "add_user_ids", b"add_user_ids", "allow_mention", b"allow_mention", "clan_id", b"clan_id", "color", b"color", "description", b"description", "display_online", b"display_online", "max_permission_id", b"max_permission_id", "remove_permission_ids", b"remove_permission_ids", "remove_user_ids", b"remove_user_ids", "role_icon", b"role_icon", "role_id", b"role_id", "title", b"title"]) -> None: ...

global___UpdateRoleRequest = UpdateRoleRequest

@typing.final
class UpdateRoleChannelRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ROLE_ID_FIELD_NUMBER: builtins.int
    PERMISSION_UPDATE_FIELD_NUMBER: builtins.int
    MAX_PERMISSION_ID_FIELD_NUMBER: builtins.int
    CHANNEL_ID_FIELD_NUMBER: builtins.int
    USER_ID_FIELD_NUMBER: builtins.int
    ROLE_LABEL_FIELD_NUMBER: builtins.int
    role_id: builtins.str
    """The ID of the role to update."""
    max_permission_id: builtins.str
    """id of permission which has max level permission"""
    channel_id: builtins.str
    """The channel_id"""
    user_id: builtins.str
    """The ID of the role to update."""
    role_label: builtins.str
    """Role label"""
    @property
    def permission_update(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___PermissionUpdate]:
        """The permissions to add."""

    def __init__(
        self,
        *,
        role_id: builtins.str = ...,
        permission_update: collections.abc.Iterable[global___PermissionUpdate] | None = ...,
        max_permission_id: builtins.str = ...,
        channel_id: builtins.str = ...,
        user_id: builtins.str = ...,
        role_label: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["channel_id", b"channel_id", "max_permission_id", b"max_permission_id", "permission_update", b"permission_update", "role_id", b"role_id", "role_label", b"role_label", "user_id", b"user_id"]) -> None: ...

global___UpdateRoleChannelRequest = UpdateRoleChannelRequest

@typing.final
class PermissionUpdate(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    PERMISSION_ID_FIELD_NUMBER: builtins.int
    SLUG_FIELD_NUMBER: builtins.int
    TYPE_FIELD_NUMBER: builtins.int
    permission_id: builtins.str
    """permission_id"""
    slug: builtins.str
    """permission slug"""
    type: builtins.int
    """type set permission"""
    def __init__(
        self,
        *,
        permission_id: builtins.str = ...,
        slug: builtins.str = ...,
        type: builtins.int = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["permission_id", b"permission_id", "slug", b"slug", "type", b"type"]) -> None: ...

global___PermissionUpdate = PermissionUpdate

@typing.final
class UploadAttachmentRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    FILENAME_FIELD_NUMBER: builtins.int
    FILETYPE_FIELD_NUMBER: builtins.int
    SIZE_FIELD_NUMBER: builtins.int
    WIDTH_FIELD_NUMBER: builtins.int
    HEIGHT_FIELD_NUMBER: builtins.int
    filename: builtins.str
    """The name of file that need to upload"""
    filetype: builtins.str
    """The type of file that need to upload"""
    size: builtins.int
    """The size of file that need to upload"""
    width: builtins.int
    """width"""
    height: builtins.int
    """Height"""
    def __init__(
        self,
        *,
        filename: builtins.str = ...,
        filetype: builtins.str = ...,
        size: builtins.int = ...,
        width: builtins.int = ...,
        height: builtins.int = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["filename", b"filename", "filetype", b"filetype", "height", b"height", "size", b"size", "width", b"width"]) -> None: ...

global___UploadAttachmentRequest = UploadAttachmentRequest

@typing.final
class ListMessageMentionRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    LIMIT_FIELD_NUMBER: builtins.int
    FORWARD_FIELD_NUMBER: builtins.int
    CURSOR_FIELD_NUMBER: builtins.int
    cursor: builtins.str
    """A pagination cursor, if any."""
    @property
    def limit(self) -> google.protobuf.wrappers_pb2.Int32Value:
        """Max number of records to return. Between 1 and 100."""

    @property
    def forward(self) -> google.protobuf.wrappers_pb2.BoolValue:
        """True if listing should be older messages to newer, false if reverse."""

    def __init__(
        self,
        *,
        limit: google.protobuf.wrappers_pb2.Int32Value | None = ...,
        forward: google.protobuf.wrappers_pb2.BoolValue | None = ...,
        cursor: builtins.str = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["forward", b"forward", "limit", b"limit"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["cursor", b"cursor", "forward", b"forward", "limit", b"limit"]) -> None: ...

global___ListMessageMentionRequest = ListMessageMentionRequest

@typing.final
class UploadAttachment(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    FILENAME_FIELD_NUMBER: builtins.int
    URL_FIELD_NUMBER: builtins.int
    filename: builtins.str
    """The name of file that need to upload"""
    url: builtins.str
    """The url"""
    def __init__(
        self,
        *,
        filename: builtins.str = ...,
        url: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["filename", b"filename", "url", b"url"]) -> None: ...

global___UploadAttachment = UploadAttachment

@typing.final
class SearchMessageRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    FILTERS_FIELD_NUMBER: builtins.int
    FROM_FIELD_NUMBER: builtins.int
    SIZE_FIELD_NUMBER: builtins.int
    SORTS_FIELD_NUMBER: builtins.int
    @property
    def filters(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___FilterParam]: ...
    @property
    def size(self) -> google.protobuf.wrappers_pb2.Int32Value:
        """Page size"""

    @property
    def sorts(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___SortParam]:
        """Sort information"""

    def __init__(
        self,
        *,
        filters: collections.abc.Iterable[global___FilterParam] | None = ...,
        size: google.protobuf.wrappers_pb2.Int32Value | None = ...,
        sorts: collections.abc.Iterable[global___SortParam] | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["from", b"from", "size", b"size"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["filters", b"filters", "from", b"from", "size", b"size", "sorts", b"sorts"]) -> None: ...

global___SearchMessageRequest = SearchMessageRequest

@typing.final
class SortParam(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    FIELD_NAME_FIELD_NUMBER: builtins.int
    ORDER_FIELD_NUMBER: builtins.int
    field_name: builtins.str
    """Field name to sort by"""
    order: builtins.str
    """Sort order"""
    def __init__(
        self,
        *,
        field_name: builtins.str = ...,
        order: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["field_name", b"field_name", "order", b"order"]) -> None: ...

global___SortParam = SortParam

@typing.final
class FilterParam(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    FIELD_NAME_FIELD_NUMBER: builtins.int
    FIELD_VALUE_FIELD_NUMBER: builtins.int
    field_name: builtins.str
    """Field name to filter by"""
    field_value: builtins.str
    """Filter value"""
    def __init__(
        self,
        *,
        field_name: builtins.str = ...,
        field_value: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["field_name", b"field_name", "field_value", b"field_value"]) -> None: ...

global___FilterParam = FilterParam

@typing.final
class SearchMessageDocument(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    MESSAGE_ID_FIELD_NUMBER: builtins.int
    CHANNEL_ID_FIELD_NUMBER: builtins.int
    CLAN_ID_FIELD_NUMBER: builtins.int
    SENDER_ID_FIELD_NUMBER: builtins.int
    CONTENT_FIELD_NUMBER: builtins.int
    MENTIONS_FIELD_NUMBER: builtins.int
    REACTIONS_FIELD_NUMBER: builtins.int
    ATTACHMENTS_FIELD_NUMBER: builtins.int
    REFERENCES_FIELD_NUMBER: builtins.int
    CREATE_TIME_FIELD_NUMBER: builtins.int
    UPDATE_TIME_FIELD_NUMBER: builtins.int
    CHANNEL_LABEL_FIELD_NUMBER: builtins.int
    CHANNEL_TYPE_FIELD_NUMBER: builtins.int
    CLAN_NAME_FIELD_NUMBER: builtins.int
    USERNAME_FIELD_NUMBER: builtins.int
    DISPLAY_NAME_FIELD_NUMBER: builtins.int
    AVATAR_URL_FIELD_NUMBER: builtins.int
    message_id: builtins.str
    """The message ID."""
    channel_id: builtins.str
    """The channel ID."""
    clan_id: builtins.str
    """The clan ID."""
    sender_id: builtins.str
    """The user ID of sender."""
    content: builtins.str
    """Message content"""
    mentions: builtins.str
    """Mention users"""
    reactions: builtins.str
    """Reactions"""
    references: builtins.str
    """Reference users"""
    create_time: builtins.str
    """Message create time"""
    update_time: builtins.str
    """Message update time"""
    channel_label: builtins.str
    """Channel name"""
    channel_type: builtins.int
    """Channel type"""
    clan_name: builtins.str
    """Clan name"""
    username: builtins.str
    """Sender's username"""
    display_name: builtins.str
    """Sender's display name"""
    avatar_url: builtins.str
    """Sender's avatar URL"""
    @property
    def attachments(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___MessageAttachment]:
        """Attachment"""

    def __init__(
        self,
        *,
        message_id: builtins.str = ...,
        channel_id: builtins.str = ...,
        clan_id: builtins.str = ...,
        sender_id: builtins.str = ...,
        content: builtins.str = ...,
        mentions: builtins.str = ...,
        reactions: builtins.str = ...,
        attachments: collections.abc.Iterable[global___MessageAttachment] | None = ...,
        references: builtins.str = ...,
        create_time: builtins.str = ...,
        update_time: builtins.str = ...,
        channel_label: builtins.str = ...,
        channel_type: builtins.int = ...,
        clan_name: builtins.str = ...,
        username: builtins.str = ...,
        display_name: builtins.str = ...,
        avatar_url: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["attachments", b"attachments", "avatar_url", b"avatar_url", "channel_id", b"channel_id", "channel_label", b"channel_label", "channel_type", b"channel_type", "clan_id", b"clan_id", "clan_name", b"clan_name", "content", b"content", "create_time", b"create_time", "display_name", b"display_name", "mentions", b"mentions", "message_id", b"message_id", "reactions", b"reactions", "references", b"references", "sender_id", b"sender_id", "update_time", b"update_time", "username", b"username"]) -> None: ...

global___SearchMessageDocument = SearchMessageDocument

@typing.final
class SearchMessageResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    MESSAGES_FIELD_NUMBER: builtins.int
    TOTAL_FIELD_NUMBER: builtins.int
    total: builtins.int
    """The total number of messages."""
    @property
    def messages(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___SearchMessageDocument]:
        """List of paged messages."""

    def __init__(
        self,
        *,
        messages: collections.abc.Iterable[global___SearchMessageDocument] | None = ...,
        total: builtins.int = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["messages", b"messages", "total", b"total"]) -> None: ...

global___SearchMessageResponse = SearchMessageResponse

@typing.final
class RegistrationEmailRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    @typing.final
    class VarsEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.str
        value: builtins.str
        def __init__(
            self,
            *,
            key: builtins.str = ...,
            value: builtins.str = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing.Literal["key", b"key", "value", b"value"]) -> None: ...

    EMAIL_FIELD_NUMBER: builtins.int
    PASSWORD_FIELD_NUMBER: builtins.int
    OLD_PASSWORD_FIELD_NUMBER: builtins.int
    USERNAME_FIELD_NUMBER: builtins.int
    DISPLAY_NAME_FIELD_NUMBER: builtins.int
    AVATAR_URL_FIELD_NUMBER: builtins.int
    DOB_FIELD_NUMBER: builtins.int
    VARS_FIELD_NUMBER: builtins.int
    email: builtins.str
    """A valid RFC-5322 email address."""
    password: builtins.str
    """A password for the user account."""
    old_password: builtins.str
    """A old password for the user account."""
    username: builtins.str
    """Set the username on the account at register. Must be unique."""
    display_name: builtins.str
    """Display name"""
    avatar_url: builtins.str
    """Avatar url"""
    dob: builtins.str
    """DOB"""
    @property
    def vars(self) -> google.protobuf.internal.containers.ScalarMap[builtins.str, builtins.str]:
        """Extra information that will be bundled in the session token."""

    def __init__(
        self,
        *,
        email: builtins.str = ...,
        password: builtins.str = ...,
        old_password: builtins.str = ...,
        username: builtins.str = ...,
        display_name: builtins.str = ...,
        avatar_url: builtins.str = ...,
        dob: builtins.str = ...,
        vars: collections.abc.Mapping[builtins.str, builtins.str] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["avatar_url", b"avatar_url", "display_name", b"display_name", "dob", b"dob", "email", b"email", "old_password", b"old_password", "password", b"password", "username", b"username", "vars", b"vars"]) -> None: ...

global___RegistrationEmailRequest = RegistrationEmailRequest

@typing.final
class ClanEmoji(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ID_FIELD_NUMBER: builtins.int
    SRC_FIELD_NUMBER: builtins.int
    SHORTNAME_FIELD_NUMBER: builtins.int
    CATEGORY_FIELD_NUMBER: builtins.int
    CREATOR_ID_FIELD_NUMBER: builtins.int
    CLAN_ID_FIELD_NUMBER: builtins.int
    LOGO_FIELD_NUMBER: builtins.int
    CLAN_NAME_FIELD_NUMBER: builtins.int
    IS_FOR_SALE_FIELD_NUMBER: builtins.int
    id: builtins.str
    src: builtins.str
    """src url"""
    shortname: builtins.str
    """shortname"""
    category: builtins.str
    """category"""
    creator_id: builtins.str
    """creator id"""
    clan_id: builtins.str
    """clan_id"""
    logo: builtins.str
    """clan logo"""
    clan_name: builtins.str
    """clan name"""
    is_for_sale: builtins.bool
    """is for sale"""
    def __init__(
        self,
        *,
        id: builtins.str = ...,
        src: builtins.str = ...,
        shortname: builtins.str = ...,
        category: builtins.str = ...,
        creator_id: builtins.str = ...,
        clan_id: builtins.str = ...,
        logo: builtins.str = ...,
        clan_name: builtins.str = ...,
        is_for_sale: builtins.bool = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["category", b"category", "clan_id", b"clan_id", "clan_name", b"clan_name", "creator_id", b"creator_id", "id", b"id", "is_for_sale", b"is_for_sale", "logo", b"logo", "shortname", b"shortname", "src", b"src"]) -> None: ...

global___ClanEmoji = ClanEmoji

@typing.final
class EmojiListedResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    EMOJI_LIST_FIELD_NUMBER: builtins.int
    @property
    def emoji_list(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___ClanEmoji]: ...
    def __init__(
        self,
        *,
        emoji_list: collections.abc.Iterable[global___ClanEmoji] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["emoji_list", b"emoji_list"]) -> None: ...

global___EmojiListedResponse = EmojiListedResponse

@typing.final
class StickerListedResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    STICKERS_FIELD_NUMBER: builtins.int
    @property
    def stickers(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___ClanSticker]: ...
    def __init__(
        self,
        *,
        stickers: collections.abc.Iterable[global___ClanSticker] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["stickers", b"stickers"]) -> None: ...

global___StickerListedResponse = StickerListedResponse

@typing.final
class ClanSticker(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ID_FIELD_NUMBER: builtins.int
    SOURCE_FIELD_NUMBER: builtins.int
    SHORTNAME_FIELD_NUMBER: builtins.int
    CATEGORY_FIELD_NUMBER: builtins.int
    CREATOR_ID_FIELD_NUMBER: builtins.int
    CREATE_TIME_FIELD_NUMBER: builtins.int
    CLAN_ID_FIELD_NUMBER: builtins.int
    LOGO_FIELD_NUMBER: builtins.int
    CLAN_NAME_FIELD_NUMBER: builtins.int
    MEDIA_TYPE_FIELD_NUMBER: builtins.int
    IS_FOR_SALE_FIELD_NUMBER: builtins.int
    id: builtins.str
    source: builtins.str
    shortname: builtins.str
    category: builtins.str
    creator_id: builtins.str
    clan_id: builtins.str
    logo: builtins.str
    clan_name: builtins.str
    media_type: builtins.int
    is_for_sale: builtins.bool
    """is for sale"""
    @property
    def create_time(self) -> google.protobuf.timestamp_pb2.Timestamp: ...
    def __init__(
        self,
        *,
        id: builtins.str = ...,
        source: builtins.str = ...,
        shortname: builtins.str = ...,
        category: builtins.str = ...,
        creator_id: builtins.str = ...,
        create_time: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        clan_id: builtins.str = ...,
        logo: builtins.str = ...,
        clan_name: builtins.str = ...,
        media_type: builtins.int = ...,
        is_for_sale: builtins.bool = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["create_time", b"create_time"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["category", b"category", "clan_id", b"clan_id", "clan_name", b"clan_name", "create_time", b"create_time", "creator_id", b"creator_id", "id", b"id", "is_for_sale", b"is_for_sale", "logo", b"logo", "media_type", b"media_type", "shortname", b"shortname", "source", b"source"]) -> None: ...

global___ClanSticker = ClanSticker

@typing.final
class AllUsersAddChannelRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CHANNEL_ID_FIELD_NUMBER: builtins.int
    LIMIT_FIELD_NUMBER: builtins.int
    channel_id: builtins.str
    @property
    def limit(self) -> google.protobuf.wrappers_pb2.Int32Value: ...
    def __init__(
        self,
        *,
        channel_id: builtins.str = ...,
        limit: google.protobuf.wrappers_pb2.Int32Value | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["limit", b"limit"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["channel_id", b"channel_id", "limit", b"limit"]) -> None: ...

global___AllUsersAddChannelRequest = AllUsersAddChannelRequest

@typing.final
class AllUsersAddChannelResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CHANNEL_ID_FIELD_NUMBER: builtins.int
    USER_IDS_FIELD_NUMBER: builtins.int
    LIMIT_FIELD_NUMBER: builtins.int
    USERNAMES_FIELD_NUMBER: builtins.int
    DISPLAY_NAMES_FIELD_NUMBER: builtins.int
    AVATARS_FIELD_NUMBER: builtins.int
    ONLINES_FIELD_NUMBER: builtins.int
    channel_id: builtins.str
    @property
    def user_ids(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]: ...
    @property
    def limit(self) -> google.protobuf.wrappers_pb2.Int32Value: ...
    @property
    def usernames(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]: ...
    @property
    def display_names(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]: ...
    @property
    def avatars(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]: ...
    @property
    def onlines(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.bool]: ...
    def __init__(
        self,
        *,
        channel_id: builtins.str = ...,
        user_ids: collections.abc.Iterable[builtins.str] | None = ...,
        limit: google.protobuf.wrappers_pb2.Int32Value | None = ...,
        usernames: collections.abc.Iterable[builtins.str] | None = ...,
        display_names: collections.abc.Iterable[builtins.str] | None = ...,
        avatars: collections.abc.Iterable[builtins.str] | None = ...,
        onlines: collections.abc.Iterable[builtins.bool] | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["limit", b"limit"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["avatars", b"avatars", "channel_id", b"channel_id", "display_names", b"display_names", "limit", b"limit", "onlines", b"onlines", "user_ids", b"user_ids", "usernames", b"usernames"]) -> None: ...

global___AllUsersAddChannelResponse = AllUsersAddChannelResponse

@typing.final
class ClanEmojiCreateRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CLAN_ID_FIELD_NUMBER: builtins.int
    SOURCE_FIELD_NUMBER: builtins.int
    SHORTNAME_FIELD_NUMBER: builtins.int
    CATEGORY_FIELD_NUMBER: builtins.int
    ID_FIELD_NUMBER: builtins.int
    IS_FOR_SALE_FIELD_NUMBER: builtins.int
    clan_id: builtins.str
    source: builtins.str
    shortname: builtins.str
    category: builtins.str
    id: builtins.str
    is_for_sale: builtins.bool
    def __init__(
        self,
        *,
        clan_id: builtins.str = ...,
        source: builtins.str = ...,
        shortname: builtins.str = ...,
        category: builtins.str = ...,
        id: builtins.str = ...,
        is_for_sale: builtins.bool = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["category", b"category", "clan_id", b"clan_id", "id", b"id", "is_for_sale", b"is_for_sale", "shortname", b"shortname", "source", b"source"]) -> None: ...

global___ClanEmojiCreateRequest = ClanEmojiCreateRequest

@typing.final
class ClanEmojiGetByClanIdRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CLAN_ID_FIELD_NUMBER: builtins.int
    clan_id: builtins.str
    def __init__(
        self,
        *,
        clan_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["clan_id", b"clan_id"]) -> None: ...

global___ClanEmojiGetByClanIdRequest = ClanEmojiGetByClanIdRequest

@typing.final
class ClanEmojiDeleteRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ID_FIELD_NUMBER: builtins.int
    CLAN_ID_FIELD_NUMBER: builtins.int
    EMOJI_LABEL_FIELD_NUMBER: builtins.int
    id: builtins.str
    clan_id: builtins.str
    emoji_label: builtins.str
    def __init__(
        self,
        *,
        id: builtins.str = ...,
        clan_id: builtins.str = ...,
        emoji_label: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["clan_id", b"clan_id", "emoji_label", b"emoji_label", "id", b"id"]) -> None: ...

global___ClanEmojiDeleteRequest = ClanEmojiDeleteRequest

@typing.final
class ClanEmojiUpdateRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ID_FIELD_NUMBER: builtins.int
    SHORTNAME_FIELD_NUMBER: builtins.int
    CLAN_ID_FIELD_NUMBER: builtins.int
    id: builtins.str
    shortname: builtins.str
    clan_id: builtins.str
    def __init__(
        self,
        *,
        id: builtins.str = ...,
        shortname: builtins.str = ...,
        clan_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["clan_id", b"clan_id", "id", b"id", "shortname", b"shortname"]) -> None: ...

global___ClanEmojiUpdateRequest = ClanEmojiUpdateRequest

@typing.final
class Webhook(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ID_FIELD_NUMBER: builtins.int
    WEBHOOK_NAME_FIELD_NUMBER: builtins.int
    CHANNEL_ID_FIELD_NUMBER: builtins.int
    ACTIVE_FIELD_NUMBER: builtins.int
    URL_FIELD_NUMBER: builtins.int
    CREATOR_ID_FIELD_NUMBER: builtins.int
    CREATE_TIME_FIELD_NUMBER: builtins.int
    UPDATE_TIME_FIELD_NUMBER: builtins.int
    AVATAR_FIELD_NUMBER: builtins.int
    STATUS_FIELD_NUMBER: builtins.int
    CLAN_ID_FIELD_NUMBER: builtins.int
    id: builtins.str
    webhook_name: builtins.str
    channel_id: builtins.str
    active: builtins.int
    url: builtins.str
    """URL of the webhook, which is automatically generated and different from the avatar"""
    creator_id: builtins.str
    create_time: builtins.str
    update_time: builtins.str
    avatar: builtins.str
    status: builtins.int
    clan_id: builtins.str
    def __init__(
        self,
        *,
        id: builtins.str = ...,
        webhook_name: builtins.str = ...,
        channel_id: builtins.str = ...,
        active: builtins.int = ...,
        url: builtins.str = ...,
        creator_id: builtins.str = ...,
        create_time: builtins.str = ...,
        update_time: builtins.str = ...,
        avatar: builtins.str = ...,
        status: builtins.int = ...,
        clan_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["active", b"active", "avatar", b"avatar", "channel_id", b"channel_id", "clan_id", b"clan_id", "create_time", b"create_time", "creator_id", b"creator_id", "id", b"id", "status", b"status", "update_time", b"update_time", "url", b"url", "webhook_name", b"webhook_name"]) -> None: ...

global___Webhook = Webhook

@typing.final
class WebhookCreateRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    WEBHOOK_NAME_FIELD_NUMBER: builtins.int
    CHANNEL_ID_FIELD_NUMBER: builtins.int
    AVATAR_FIELD_NUMBER: builtins.int
    CLAN_ID_FIELD_NUMBER: builtins.int
    webhook_name: builtins.str
    channel_id: builtins.str
    avatar: builtins.str
    clan_id: builtins.str
    def __init__(
        self,
        *,
        webhook_name: builtins.str = ...,
        channel_id: builtins.str = ...,
        avatar: builtins.str = ...,
        clan_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["avatar", b"avatar", "channel_id", b"channel_id", "clan_id", b"clan_id", "webhook_name", b"webhook_name"]) -> None: ...

global___WebhookCreateRequest = WebhookCreateRequest

@typing.final
class WebhookListRequestById(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ID_FIELD_NUMBER: builtins.int
    id: builtins.str
    def __init__(
        self,
        *,
        id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["id", b"id"]) -> None: ...

global___WebhookListRequestById = WebhookListRequestById

@typing.final
class WebhookUpdateRequestById(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ID_FIELD_NUMBER: builtins.int
    WEBHOOK_NAME_FIELD_NUMBER: builtins.int
    CHANNEL_ID_UPDATE_FIELD_NUMBER: builtins.int
    AVATAR_FIELD_NUMBER: builtins.int
    CHANNEL_ID_FIELD_NUMBER: builtins.int
    CLAN_ID_FIELD_NUMBER: builtins.int
    id: builtins.str
    """webhook Id"""
    webhook_name: builtins.str
    """webhook name"""
    channel_id_update: builtins.str
    """change channel_id of webhook"""
    avatar: builtins.str
    """webhook avatar"""
    channel_id: builtins.str
    """channel id"""
    clan_id: builtins.str
    """clan id"""
    def __init__(
        self,
        *,
        id: builtins.str = ...,
        webhook_name: builtins.str = ...,
        channel_id_update: builtins.str = ...,
        avatar: builtins.str = ...,
        channel_id: builtins.str = ...,
        clan_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["avatar", b"avatar", "channel_id", b"channel_id", "channel_id_update", b"channel_id_update", "clan_id", b"clan_id", "id", b"id", "webhook_name", b"webhook_name"]) -> None: ...

global___WebhookUpdateRequestById = WebhookUpdateRequestById

@typing.final
class WebhookDeleteRequestById(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ID_FIELD_NUMBER: builtins.int
    CLAN_ID_FIELD_NUMBER: builtins.int
    CHANNEL_ID_FIELD_NUMBER: builtins.int
    id: builtins.str
    clan_id: builtins.str
    channel_id: builtins.str
    def __init__(
        self,
        *,
        id: builtins.str = ...,
        clan_id: builtins.str = ...,
        channel_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["channel_id", b"channel_id", "clan_id", b"clan_id", "id", b"id"]) -> None: ...

global___WebhookDeleteRequestById = WebhookDeleteRequestById

@typing.final
class WebhookListRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CHANNEL_ID_FIELD_NUMBER: builtins.int
    CLAN_ID_FIELD_NUMBER: builtins.int
    channel_id: builtins.str
    clan_id: builtins.str
    def __init__(
        self,
        *,
        channel_id: builtins.str = ...,
        clan_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["channel_id", b"channel_id", "clan_id", b"clan_id"]) -> None: ...

global___WebhookListRequest = WebhookListRequest

@typing.final
class WebhookListResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    WEBHOOKS_FIELD_NUMBER: builtins.int
    @property
    def webhooks(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___Webhook]: ...
    def __init__(
        self,
        *,
        webhooks: collections.abc.Iterable[global___Webhook] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["webhooks", b"webhooks"]) -> None: ...

global___WebhookListResponse = WebhookListResponse

@typing.final
class WebhookGenerateResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    URL_FIELD_NUMBER: builtins.int
    HOOK_NAME_FIELD_NUMBER: builtins.int
    CHANNEL_ID_FIELD_NUMBER: builtins.int
    AVATAR_FIELD_NUMBER: builtins.int
    url: builtins.str
    hook_name: builtins.str
    channel_id: builtins.str
    avatar: builtins.str
    def __init__(
        self,
        *,
        url: builtins.str = ...,
        hook_name: builtins.str = ...,
        channel_id: builtins.str = ...,
        avatar: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["avatar", b"avatar", "channel_id", b"channel_id", "hook_name", b"hook_name", "url", b"url"]) -> None: ...

global___WebhookGenerateResponse = WebhookGenerateResponse

@typing.final
class WebhookHandlerRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    BODY_FIELD_NUMBER: builtins.int
    CHANNEL_ID_FIELD_NUMBER: builtins.int
    TOKEN_FIELD_NUMBER: builtins.int
    channel_id: builtins.str
    token: builtins.str
    @property
    def body(self) -> google.protobuf.struct_pb2.Struct: ...
    def __init__(
        self,
        *,
        body: google.protobuf.struct_pb2.Struct | None = ...,
        channel_id: builtins.str = ...,
        token: builtins.str = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["body", b"body"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["body", b"body", "channel_id", b"channel_id", "token", b"token"]) -> None: ...

global___WebhookHandlerRequest = WebhookHandlerRequest

@typing.final
class CheckDuplicateClanNameRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CLAN_NAME_FIELD_NUMBER: builtins.int
    clan_name: builtins.str
    def __init__(
        self,
        *,
        clan_name: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["clan_name", b"clan_name"]) -> None: ...

global___CheckDuplicateClanNameRequest = CheckDuplicateClanNameRequest

@typing.final
class CheckDuplicateClanNameResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    IS_DUPLICATE_FIELD_NUMBER: builtins.int
    is_duplicate: builtins.bool
    def __init__(
        self,
        *,
        is_duplicate: builtins.bool = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["is_duplicate", b"is_duplicate"]) -> None: ...

global___CheckDuplicateClanNameResponse = CheckDuplicateClanNameResponse

@typing.final
class ClanStickerAddRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    SOURCE_FIELD_NUMBER: builtins.int
    SHORTNAME_FIELD_NUMBER: builtins.int
    CATEGORY_FIELD_NUMBER: builtins.int
    CLAN_ID_FIELD_NUMBER: builtins.int
    ID_FIELD_NUMBER: builtins.int
    MEDIA_TYPE_FIELD_NUMBER: builtins.int
    IS_FOR_SALE_FIELD_NUMBER: builtins.int
    source: builtins.str
    shortname: builtins.str
    category: builtins.str
    clan_id: builtins.str
    id: builtins.str
    """UNIQUE include type number"""
    media_type: builtins.int
    """media type for image or audio"""
    is_for_sale: builtins.bool
    """is for sale"""
    def __init__(
        self,
        *,
        source: builtins.str = ...,
        shortname: builtins.str = ...,
        category: builtins.str = ...,
        clan_id: builtins.str = ...,
        id: builtins.str = ...,
        media_type: builtins.int = ...,
        is_for_sale: builtins.bool = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["category", b"category", "clan_id", b"clan_id", "id", b"id", "is_for_sale", b"is_for_sale", "media_type", b"media_type", "shortname", b"shortname", "source", b"source"]) -> None: ...

global___ClanStickerAddRequest = ClanStickerAddRequest

@typing.final
class ClanStickerListByClanIdRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CLAN_ID_FIELD_NUMBER: builtins.int
    clan_id: builtins.str
    def __init__(
        self,
        *,
        clan_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["clan_id", b"clan_id"]) -> None: ...

global___ClanStickerListByClanIdRequest = ClanStickerListByClanIdRequest

@typing.final
class ClanStickerUpdateByIdRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ID_FIELD_NUMBER: builtins.int
    SOURCE_FIELD_NUMBER: builtins.int
    SHORTNAME_FIELD_NUMBER: builtins.int
    CATEGORY_FIELD_NUMBER: builtins.int
    CLAN_ID_FIELD_NUMBER: builtins.int
    id: builtins.str
    source: builtins.str
    shortname: builtins.str
    category: builtins.str
    clan_id: builtins.str
    def __init__(
        self,
        *,
        id: builtins.str = ...,
        source: builtins.str = ...,
        shortname: builtins.str = ...,
        category: builtins.str = ...,
        clan_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["category", b"category", "clan_id", b"clan_id", "id", b"id", "shortname", b"shortname", "source", b"source"]) -> None: ...

global___ClanStickerUpdateByIdRequest = ClanStickerUpdateByIdRequest

@typing.final
class ClanStickerDeleteRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ID_FIELD_NUMBER: builtins.int
    CLAN_ID_FIELD_NUMBER: builtins.int
    STICKER_LABEL_FIELD_NUMBER: builtins.int
    id: builtins.str
    clan_id: builtins.str
    sticker_label: builtins.str
    def __init__(
        self,
        *,
        id: builtins.str = ...,
        clan_id: builtins.str = ...,
        sticker_label: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["clan_id", b"clan_id", "id", b"id", "sticker_label", b"sticker_label"]) -> None: ...

global___ClanStickerDeleteRequest = ClanStickerDeleteRequest

@typing.final
class ChangeChannelCategoryRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CLAN_ID_FIELD_NUMBER: builtins.int
    CHANNEL_ID_FIELD_NUMBER: builtins.int
    NEW_CATEGORY_ID_FIELD_NUMBER: builtins.int
    clan_id: builtins.str
    channel_id: builtins.str
    new_category_id: builtins.str
    def __init__(
        self,
        *,
        clan_id: builtins.str = ...,
        channel_id: builtins.str = ...,
        new_category_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["channel_id", b"channel_id", "clan_id", b"clan_id", "new_category_id", b"new_category_id"]) -> None: ...

global___ChangeChannelCategoryRequest = ChangeChannelCategoryRequest

@typing.final
class App(google.protobuf.message.Message):
    """App information."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ID_FIELD_NUMBER: builtins.int
    APPNAME_FIELD_NUMBER: builtins.int
    CREATOR_ID_FIELD_NUMBER: builtins.int
    APPLOGO_FIELD_NUMBER: builtins.int
    IS_SHADOW_FIELD_NUMBER: builtins.int
    DISABLE_TIME_FIELD_NUMBER: builtins.int
    TOKEN_FIELD_NUMBER: builtins.int
    ROLE_FIELD_NUMBER: builtins.int
    ABOUT_FIELD_NUMBER: builtins.int
    APP_URL_FIELD_NUMBER: builtins.int
    id: builtins.str
    """app id"""
    appname: builtins.str
    """appname"""
    creator_id: builtins.str
    """creator_id"""
    applogo: builtins.str
    """logo"""
    is_shadow: builtins.bool
    """status online"""
    token: builtins.str
    """string token"""
    role: builtins.int
    """role"""
    about: builtins.str
    """about"""
    app_url: builtins.str
    """app url"""
    @property
    def disable_time(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """The UNIX time when the app was disabled."""

    def __init__(
        self,
        *,
        id: builtins.str = ...,
        appname: builtins.str = ...,
        creator_id: builtins.str = ...,
        applogo: builtins.str = ...,
        is_shadow: builtins.bool = ...,
        disable_time: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        token: builtins.str = ...,
        role: builtins.int = ...,
        about: builtins.str = ...,
        app_url: builtins.str = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["disable_time", b"disable_time"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["about", b"about", "app_url", b"app_url", "applogo", b"applogo", "appname", b"appname", "creator_id", b"creator_id", "disable_time", b"disable_time", "id", b"id", "is_shadow", b"is_shadow", "role", b"role", "token", b"token"]) -> None: ...

global___App = App

@typing.final
class AppDeleteRequest(google.protobuf.message.Message):
    """Delete a app."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ID_FIELD_NUMBER: builtins.int
    RECORD_DELETION_FIELD_NUMBER: builtins.int
    id: builtins.str
    """The unique identifier of the app."""
    @property
    def record_deletion(self) -> google.protobuf.wrappers_pb2.BoolValue:
        """Record the app deletion - used for GDPR compliance."""

    def __init__(
        self,
        *,
        id: builtins.str = ...,
        record_deletion: google.protobuf.wrappers_pb2.BoolValue | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["record_deletion", b"record_deletion"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["id", b"id", "record_deletion", b"record_deletion"]) -> None: ...

global___AppDeleteRequest = AppDeleteRequest

@typing.final
class AppList(google.protobuf.message.Message):
    """A list of apps."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    APPS_FIELD_NUMBER: builtins.int
    TOTAL_COUNT_FIELD_NUMBER: builtins.int
    NEXT_CURSOR_FIELD_NUMBER: builtins.int
    total_count: builtins.int
    """Approximate total number of apps."""
    next_cursor: builtins.str
    """Next cursor."""
    @property
    def apps(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___App]:
        """A list of apps."""

    def __init__(
        self,
        *,
        apps: collections.abc.Iterable[global___App] | None = ...,
        total_count: builtins.int = ...,
        next_cursor: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["apps", b"apps", "next_cursor", b"next_cursor", "total_count", b"total_count"]) -> None: ...

global___AppList = AppList

@typing.final
class AddAppRequest(google.protobuf.message.Message):
    """Add a new app"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    APPNAME_FIELD_NUMBER: builtins.int
    TOKEN_FIELD_NUMBER: builtins.int
    CREATOR_ID_FIELD_NUMBER: builtins.int
    ROLE_FIELD_NUMBER: builtins.int
    IS_SHADOW_FIELD_NUMBER: builtins.int
    APP_URL_FIELD_NUMBER: builtins.int
    APP_LOGO_FIELD_NUMBER: builtins.int
    ABOUT_ME_FIELD_NUMBER: builtins.int
    appname: builtins.str
    """The appname."""
    token: builtins.str
    """The password."""
    creator_id: builtins.str
    """Creator of the app."""
    role: builtins.int
    """Role of this app."""
    is_shadow: builtins.bool
    """Is shadow."""
    app_url: builtins.str
    """App url."""
    app_logo: builtins.str
    """app logo"""
    about_me: builtins.str
    """about me"""
    def __init__(
        self,
        *,
        appname: builtins.str = ...,
        token: builtins.str = ...,
        creator_id: builtins.str = ...,
        role: builtins.int = ...,
        is_shadow: builtins.bool = ...,
        app_url: builtins.str = ...,
        app_logo: builtins.str = ...,
        about_me: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["about_me", b"about_me", "app_logo", b"app_logo", "app_url", b"app_url", "appname", b"appname", "creator_id", b"creator_id", "is_shadow", b"is_shadow", "role", b"role", "token", b"token"]) -> None: ...

global___AddAppRequest = AddAppRequest

@typing.final
class ListAppsRequest(google.protobuf.message.Message):
    """List (and optionally filter) users."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    FILTER_FIELD_NUMBER: builtins.int
    TOMBSTONES_FIELD_NUMBER: builtins.int
    CURSOR_FIELD_NUMBER: builtins.int
    filter: builtins.str
    """User ID or username filter."""
    tombstones: builtins.bool
    """Search only recorded deletes."""
    cursor: builtins.str
    """Cursor to start from"""
    def __init__(
        self,
        *,
        filter: builtins.str = ...,
        tombstones: builtins.bool = ...,
        cursor: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["cursor", b"cursor", "filter", b"filter", "tombstones", b"tombstones"]) -> None: ...

global___ListAppsRequest = ListAppsRequest

@typing.final
class UpdateAppRequest(google.protobuf.message.Message):
    """Update app information."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ID_FIELD_NUMBER: builtins.int
    APPNAME_FIELD_NUMBER: builtins.int
    METADATA_FIELD_NUMBER: builtins.int
    APPLOGO_FIELD_NUMBER: builtins.int
    TOKEN_FIELD_NUMBER: builtins.int
    ABOUT_FIELD_NUMBER: builtins.int
    APP_URL_FIELD_NUMBER: builtins.int
    IS_SHADOW_FIELD_NUMBER: builtins.int
    id: builtins.str
    """User ID to update."""
    about: builtins.str
    """about the app."""
    app_url: builtins.str
    """App url."""
    is_shadow: builtins.str
    """need update or not"""
    @property
    def appname(self) -> google.protobuf.wrappers_pb2.StringValue:
        """Username."""

    @property
    def metadata(self) -> google.protobuf.wrappers_pb2.StringValue:
        """Metadata."""

    @property
    def applogo(self) -> google.protobuf.wrappers_pb2.StringValue:
        """Avatar URL."""

    @property
    def token(self) -> google.protobuf.wrappers_pb2.StringValue:
        """Token."""

    def __init__(
        self,
        *,
        id: builtins.str = ...,
        appname: google.protobuf.wrappers_pb2.StringValue | None = ...,
        metadata: google.protobuf.wrappers_pb2.StringValue | None = ...,
        applogo: google.protobuf.wrappers_pb2.StringValue | None = ...,
        token: google.protobuf.wrappers_pb2.StringValue | None = ...,
        about: builtins.str = ...,
        app_url: builtins.str = ...,
        is_shadow: builtins.str = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["applogo", b"applogo", "appname", b"appname", "metadata", b"metadata", "token", b"token"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["about", b"about", "app_url", b"app_url", "applogo", b"applogo", "appname", b"appname", "id", b"id", "is_shadow", b"is_shadow", "metadata", b"metadata", "token", b"token"]) -> None: ...

global___UpdateAppRequest = UpdateAppRequest

@typing.final
class AppId(google.protobuf.message.Message):
    """The identifier for an app."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ID_FIELD_NUMBER: builtins.int
    id: builtins.str
    """The unique identifier of the app."""
    def __init__(
        self,
        *,
        id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["id", b"id"]) -> None: ...

global___AppId = AppId

@typing.final
class AppClan(google.protobuf.message.Message):
    """The identifier for an app."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    APP_ID_FIELD_NUMBER: builtins.int
    CLAN_ID_FIELD_NUMBER: builtins.int
    app_id: builtins.str
    """The unique identifier of the app."""
    clan_id: builtins.str
    def __init__(
        self,
        *,
        app_id: builtins.str = ...,
        clan_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["app_id", b"app_id", "clan_id", b"clan_id"]) -> None: ...

global___AppClan = AppClan

@typing.final
class DeleteChannelMessagesRequest(google.protobuf.message.Message):
    """Delete channel messages by timestamp or/and ids."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    BEFORE_FIELD_NUMBER: builtins.int
    IDS_FIELD_NUMBER: builtins.int
    @property
    def before(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """Timestamp before which messages will be deleted."""

    @property
    def ids(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """IDs of the messages to delete."""

    def __init__(
        self,
        *,
        before: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        ids: collections.abc.Iterable[builtins.str] | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["before", b"before"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["before", b"before", "ids", b"ids"]) -> None: ...

global___DeleteChannelMessagesRequest = DeleteChannelMessagesRequest

@typing.final
class DeleteChannelMessagesResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    TOTAL_FIELD_NUMBER: builtins.int
    total: builtins.int
    """Total number of messages deleted."""
    def __init__(
        self,
        *,
        total: builtins.int = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["total", b"total"]) -> None: ...

global___DeleteChannelMessagesResponse = DeleteChannelMessagesResponse

@typing.final
class SystemMessage(google.protobuf.message.Message):
    """System message details."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ID_FIELD_NUMBER: builtins.int
    CLAN_ID_FIELD_NUMBER: builtins.int
    CHANNEL_ID_FIELD_NUMBER: builtins.int
    WELCOME_RANDOM_FIELD_NUMBER: builtins.int
    WELCOME_STICKER_FIELD_NUMBER: builtins.int
    BOOST_MESSAGE_FIELD_NUMBER: builtins.int
    SETUP_TIPS_FIELD_NUMBER: builtins.int
    HIDE_AUDIT_LOG_FIELD_NUMBER: builtins.int
    id: builtins.str
    """ID"""
    clan_id: builtins.str
    """Clan ID"""
    channel_id: builtins.str
    """Channel ID"""
    welcome_random: builtins.str
    """Welcome random"""
    welcome_sticker: builtins.str
    """Welcome sticker"""
    boost_message: builtins.str
    """Boost message"""
    setup_tips: builtins.str
    """Setup tips"""
    hide_audit_log: builtins.str
    """Hide audit log"""
    def __init__(
        self,
        *,
        id: builtins.str = ...,
        clan_id: builtins.str = ...,
        channel_id: builtins.str = ...,
        welcome_random: builtins.str = ...,
        welcome_sticker: builtins.str = ...,
        boost_message: builtins.str = ...,
        setup_tips: builtins.str = ...,
        hide_audit_log: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["boost_message", b"boost_message", "channel_id", b"channel_id", "clan_id", b"clan_id", "hide_audit_log", b"hide_audit_log", "id", b"id", "setup_tips", b"setup_tips", "welcome_random", b"welcome_random", "welcome_sticker", b"welcome_sticker"]) -> None: ...

global___SystemMessage = SystemMessage

@typing.final
class SystemMessagesList(google.protobuf.message.Message):
    """List of system message."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    SYSTEM_MESSAGES_LIST_FIELD_NUMBER: builtins.int
    @property
    def system_messages_list(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___SystemMessage]: ...
    def __init__(
        self,
        *,
        system_messages_list: collections.abc.Iterable[global___SystemMessage] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["system_messages_list", b"system_messages_list"]) -> None: ...

global___SystemMessagesList = SystemMessagesList

@typing.final
class SystemMessageRequest(google.protobuf.message.Message):
    """Request to get system message by clan and channel IDs."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CLAN_ID_FIELD_NUMBER: builtins.int
    CHANNEL_ID_FIELD_NUMBER: builtins.int
    WELCOME_RANDOM_FIELD_NUMBER: builtins.int
    WELCOME_STICKER_FIELD_NUMBER: builtins.int
    BOOST_MESSAGE_FIELD_NUMBER: builtins.int
    SETUP_TIPS_FIELD_NUMBER: builtins.int
    HIDE_AUDIT_LOG_FIELD_NUMBER: builtins.int
    clan_id: builtins.str
    """Clan ID"""
    channel_id: builtins.str
    """Channel ID"""
    welcome_random: builtins.str
    """Welcome random"""
    welcome_sticker: builtins.str
    """Welcome sticker"""
    boost_message: builtins.str
    """Boost message"""
    setup_tips: builtins.str
    """Setup tips"""
    hide_audit_log: builtins.str
    """Hide audit log"""
    def __init__(
        self,
        *,
        clan_id: builtins.str = ...,
        channel_id: builtins.str = ...,
        welcome_random: builtins.str = ...,
        welcome_sticker: builtins.str = ...,
        boost_message: builtins.str = ...,
        setup_tips: builtins.str = ...,
        hide_audit_log: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["boost_message", b"boost_message", "channel_id", b"channel_id", "clan_id", b"clan_id", "hide_audit_log", b"hide_audit_log", "setup_tips", b"setup_tips", "welcome_random", b"welcome_random", "welcome_sticker", b"welcome_sticker"]) -> None: ...

global___SystemMessageRequest = SystemMessageRequest

@typing.final
class DeleteSystemMessage(google.protobuf.message.Message):
    """Request to delete a system message by clan ID."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CLAN_ID_FIELD_NUMBER: builtins.int
    clan_id: builtins.str
    """Clan ID"""
    def __init__(
        self,
        *,
        clan_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["clan_id", b"clan_id"]) -> None: ...

global___DeleteSystemMessage = DeleteSystemMessage

@typing.final
class GetSystemMessage(google.protobuf.message.Message):
    """Request to get system message by clan ID."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CLAN_ID_FIELD_NUMBER: builtins.int
    clan_id: builtins.str
    """Clan ID"""
    def __init__(
        self,
        *,
        clan_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["clan_id", b"clan_id"]) -> None: ...

global___GetSystemMessage = GetSystemMessage

@typing.final
class DeleteCategoryOrderRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CLAN_ID_FIELD_NUMBER: builtins.int
    clan_id: builtins.str
    def __init__(
        self,
        *,
        clan_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["clan_id", b"clan_id"]) -> None: ...

global___DeleteCategoryOrderRequest = DeleteCategoryOrderRequest

@typing.final
class StreamHttpCallbackRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ID_FIELD_NUMBER: builtins.int
    CLIENT_ID_FIELD_NUMBER: builtins.int
    CLAN_ID_FIELD_NUMBER: builtins.int
    CHANNEL_ID_FIELD_NUMBER: builtins.int
    USER_ID_FIELD_NUMBER: builtins.int
    ACTION_FIELD_NUMBER: builtins.int
    IS_PUBLISHER_FIELD_NUMBER: builtins.int
    TOKEN_FIELD_NUMBER: builtins.int
    id: builtins.str
    """id"""
    client_id: builtins.str
    """client_id"""
    clan_id: builtins.str
    """clan_id"""
    channel_id: builtins.str
    """channel_id"""
    user_id: builtins.str
    """user_id"""
    action: builtins.int
    """action"""
    is_publisher: builtins.bool
    """is_publisher"""
    token: builtins.str
    """token"""
    def __init__(
        self,
        *,
        id: builtins.str = ...,
        client_id: builtins.str = ...,
        clan_id: builtins.str = ...,
        channel_id: builtins.str = ...,
        user_id: builtins.str = ...,
        action: builtins.int = ...,
        is_publisher: builtins.bool = ...,
        token: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["action", b"action", "channel_id", b"channel_id", "clan_id", b"clan_id", "client_id", b"client_id", "id", b"id", "is_publisher", b"is_publisher", "token", b"token", "user_id", b"user_id"]) -> None: ...

global___StreamHttpCallbackRequest = StreamHttpCallbackRequest

@typing.final
class StreamHttpCallbackResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CODE_FIELD_NUMBER: builtins.int
    MSG_FIELD_NUMBER: builtins.int
    msg: builtins.str
    @property
    def code(self) -> google.protobuf.wrappers_pb2.Int32Value: ...
    def __init__(
        self,
        *,
        code: google.protobuf.wrappers_pb2.Int32Value | None = ...,
        msg: builtins.str = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["code", b"code"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["code", b"code", "msg", b"msg"]) -> None: ...

global___StreamHttpCallbackResponse = StreamHttpCallbackResponse

@typing.final
class StreamingChannelUser(google.protobuf.message.Message):
    """A list of users belonging to a channel, along with their role."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ID_FIELD_NUMBER: builtins.int
    USER_ID_FIELD_NUMBER: builtins.int
    CHANNEL_ID_FIELD_NUMBER: builtins.int
    PARTICIPANT_FIELD_NUMBER: builtins.int
    id: builtins.str
    """user join id"""
    user_id: builtins.str
    """user for a channel."""
    channel_id: builtins.str
    """channel id"""
    participant: builtins.str
    """participant"""
    def __init__(
        self,
        *,
        id: builtins.str = ...,
        user_id: builtins.str = ...,
        channel_id: builtins.str = ...,
        participant: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["channel_id", b"channel_id", "id", b"id", "participant", b"participant", "user_id", b"user_id"]) -> None: ...

global___StreamingChannelUser = StreamingChannelUser

@typing.final
class StreamingChannelUserList(google.protobuf.message.Message):
    """A list of users belonging to a channel, along with their role."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    STREAMING_CHANNEL_USERS_FIELD_NUMBER: builtins.int
    @property
    def streaming_channel_users(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___StreamingChannelUser]:
        """list of voice channel user"""

    def __init__(
        self,
        *,
        streaming_channel_users: collections.abc.Iterable[global___StreamingChannelUser] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["streaming_channel_users", b"streaming_channel_users"]) -> None: ...

global___StreamingChannelUserList = StreamingChannelUserList

@typing.final
class RegisterStreamingChannelRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CLAN_ID_FIELD_NUMBER: builtins.int
    CHANNEL_ID_FIELD_NUMBER: builtins.int
    clan_id: builtins.str
    """clan id"""
    channel_id: builtins.str
    """channel id"""
    def __init__(
        self,
        *,
        clan_id: builtins.str = ...,
        channel_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["channel_id", b"channel_id", "clan_id", b"clan_id"]) -> None: ...

global___RegisterStreamingChannelRequest = RegisterStreamingChannelRequest

@typing.final
class RegisterStreamingChannelResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CLAN_ID_FIELD_NUMBER: builtins.int
    CHANNEL_ID_FIELD_NUMBER: builtins.int
    STREAMING_URL_FIELD_NUMBER: builtins.int
    clan_id: builtins.str
    """clan id"""
    channel_id: builtins.str
    """channel id"""
    streaming_url: builtins.str
    """streaming url"""
    def __init__(
        self,
        *,
        clan_id: builtins.str = ...,
        channel_id: builtins.str = ...,
        streaming_url: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["channel_id", b"channel_id", "clan_id", b"clan_id", "streaming_url", b"streaming_url"]) -> None: ...

global___RegisterStreamingChannelResponse = RegisterStreamingChannelResponse

@typing.final
class GiveCoffeeEvent(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    SENDER_ID_FIELD_NUMBER: builtins.int
    RECEIVER_ID_FIELD_NUMBER: builtins.int
    TOKEN_COUNT_FIELD_NUMBER: builtins.int
    MESSAGE_REF_ID_FIELD_NUMBER: builtins.int
    CHANNEL_ID_FIELD_NUMBER: builtins.int
    CLAN_ID_FIELD_NUMBER: builtins.int
    sender_id: builtins.str
    """sender id"""
    receiver_id: builtins.str
    """receiver id"""
    token_count: builtins.int
    """token count"""
    message_ref_id: builtins.str
    """message_ref"""
    channel_id: builtins.str
    """chanel id"""
    clan_id: builtins.str
    """clan id"""
    def __init__(
        self,
        *,
        sender_id: builtins.str = ...,
        receiver_id: builtins.str = ...,
        token_count: builtins.int = ...,
        message_ref_id: builtins.str = ...,
        channel_id: builtins.str = ...,
        clan_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["channel_id", b"channel_id", "clan_id", b"clan_id", "message_ref_id", b"message_ref_id", "receiver_id", b"receiver_id", "sender_id", b"sender_id", "token_count", b"token_count"]) -> None: ...

global___GiveCoffeeEvent = GiveCoffeeEvent

@typing.final
class ListChannelAppsRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CLAN_ID_FIELD_NUMBER: builtins.int
    clan_id: builtins.str
    """clan id"""
    def __init__(
        self,
        *,
        clan_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["clan_id", b"clan_id"]) -> None: ...

global___ListChannelAppsRequest = ListChannelAppsRequest

@typing.final
class ListChannelAppsResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CHANNEL_APPS_FIELD_NUMBER: builtins.int
    @property
    def channel_apps(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___ChannelAppResponse]:
        """list of channel apps"""

    def __init__(
        self,
        *,
        channel_apps: collections.abc.Iterable[global___ChannelAppResponse] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["channel_apps", b"channel_apps"]) -> None: ...

global___ListChannelAppsResponse = ListChannelAppsResponse

@typing.final
class ChannelAppResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ID_FIELD_NUMBER: builtins.int
    CLAN_ID_FIELD_NUMBER: builtins.int
    CHANNEL_ID_FIELD_NUMBER: builtins.int
    APP_ID_FIELD_NUMBER: builtins.int
    APP_URL_FIELD_NUMBER: builtins.int
    id: builtins.str
    """id"""
    clan_id: builtins.str
    """clan id"""
    channel_id: builtins.str
    """channel id"""
    app_id: builtins.str
    """app id"""
    app_url: builtins.str
    """app url"""
    def __init__(
        self,
        *,
        id: builtins.str = ...,
        clan_id: builtins.str = ...,
        channel_id: builtins.str = ...,
        app_id: builtins.str = ...,
        app_url: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["app_id", b"app_id", "app_url", b"app_url", "channel_id", b"channel_id", "clan_id", b"clan_id", "id", b"id"]) -> None: ...

global___ChannelAppResponse = ChannelAppResponse

@typing.final
class AllUserClans(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    USERS_FIELD_NUMBER: builtins.int
    @property
    def users(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___User]: ...
    def __init__(
        self,
        *,
        users: collections.abc.Iterable[global___User] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["users", b"users"]) -> None: ...

global___AllUserClans = AllUserClans

@typing.final
class RoleListEventRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CLAN_ID_FIELD_NUMBER: builtins.int
    LIMIT_FIELD_NUMBER: builtins.int
    STATE_FIELD_NUMBER: builtins.int
    CURSOR_FIELD_NUMBER: builtins.int
    clan_id: builtins.str
    """clan id"""
    limit: builtins.int
    """limit"""
    state: builtins.int
    """state"""
    cursor: builtins.str
    """cursor"""
    def __init__(
        self,
        *,
        clan_id: builtins.str = ...,
        limit: builtins.int = ...,
        state: builtins.int = ...,
        cursor: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["clan_id", b"clan_id", "cursor", b"cursor", "limit", b"limit", "state", b"state"]) -> None: ...

global___RoleListEventRequest = RoleListEventRequest

@typing.final
class RoleListEventResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    LIMIT_FIELD_NUMBER: builtins.int
    STATE_FIELD_NUMBER: builtins.int
    CURSOR_FIELD_NUMBER: builtins.int
    CLANID_FIELD_NUMBER: builtins.int
    ROLES_FIELD_NUMBER: builtins.int
    limit: builtins.int
    """limit"""
    state: builtins.int
    """state"""
    cursor: builtins.str
    """cursor"""
    clanId: builtins.str
    """clan_id"""
    @property
    def roles(self) -> global___RoleList:
        """list of roles"""

    def __init__(
        self,
        *,
        limit: builtins.int = ...,
        state: builtins.int = ...,
        cursor: builtins.str = ...,
        clanId: builtins.str = ...,
        roles: global___RoleList | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["roles", b"roles"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["clanId", b"clanId", "cursor", b"cursor", "limit", b"limit", "roles", b"roles", "state", b"state"]) -> None: ...

global___RoleListEventResponse = RoleListEventResponse

@typing.final
class UserPermissionInChannelListRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CLAN_ID_FIELD_NUMBER: builtins.int
    CHANNEL_ID_FIELD_NUMBER: builtins.int
    clan_id: builtins.str
    """clan id"""
    channel_id: builtins.str
    """channel id"""
    def __init__(
        self,
        *,
        clan_id: builtins.str = ...,
        channel_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["channel_id", b"channel_id", "clan_id", b"clan_id"]) -> None: ...

global___UserPermissionInChannelListRequest = UserPermissionInChannelListRequest

@typing.final
class UserPermissionInChannelListResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CLAN_ID_FIELD_NUMBER: builtins.int
    CHANNEL_ID_FIELD_NUMBER: builtins.int
    PERMISSIONS_FIELD_NUMBER: builtins.int
    clan_id: builtins.str
    """clan id"""
    channel_id: builtins.str
    """channel id"""
    @property
    def permissions(self) -> global___PermissionList:
        """A list of permission."""

    def __init__(
        self,
        *,
        clan_id: builtins.str = ...,
        channel_id: builtins.str = ...,
        permissions: global___PermissionList | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["permissions", b"permissions"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["channel_id", b"channel_id", "clan_id", b"clan_id", "permissions", b"permissions"]) -> None: ...

global___UserPermissionInChannelListResponse = UserPermissionInChannelListResponse

@typing.final
class PermissionRoleChannel(google.protobuf.message.Message):
    """Permission role channel"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    PERMISSION_ID_FIELD_NUMBER: builtins.int
    ACTIVE_FIELD_NUMBER: builtins.int
    permission_id: builtins.str
    """permission id"""
    active: builtins.bool
    """active"""
    def __init__(
        self,
        *,
        permission_id: builtins.str = ...,
        active: builtins.bool = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["active", b"active", "permission_id", b"permission_id"]) -> None: ...

global___PermissionRoleChannel = PermissionRoleChannel

@typing.final
class PermissionRoleChannelListEventRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ROLE_ID_FIELD_NUMBER: builtins.int
    CHANNEL_ID_FIELD_NUMBER: builtins.int
    USER_ID_FIELD_NUMBER: builtins.int
    role_id: builtins.str
    """role id"""
    channel_id: builtins.str
    """channel id"""
    user_id: builtins.str
    """user id"""
    def __init__(
        self,
        *,
        role_id: builtins.str = ...,
        channel_id: builtins.str = ...,
        user_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["channel_id", b"channel_id", "role_id", b"role_id", "user_id", b"user_id"]) -> None: ...

global___PermissionRoleChannelListEventRequest = PermissionRoleChannelListEventRequest

@typing.final
class PermissionRoleChannelListEventResponse(google.protobuf.message.Message):
    """List of permission role channel"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ROLE_ID_FIELD_NUMBER: builtins.int
    CHANNEL_ID_FIELD_NUMBER: builtins.int
    USER_ID_FIELD_NUMBER: builtins.int
    PERMISSION_ROLE_CHANNEL_FIELD_NUMBER: builtins.int
    role_id: builtins.str
    """role id"""
    channel_id: builtins.str
    """channel id"""
    user_id: builtins.str
    """user id"""
    @property
    def permission_role_channel(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___PermissionRoleChannel]:
        """list of permission role channel"""

    def __init__(
        self,
        *,
        role_id: builtins.str = ...,
        channel_id: builtins.str = ...,
        user_id: builtins.str = ...,
        permission_role_channel: collections.abc.Iterable[global___PermissionRoleChannel] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["channel_id", b"channel_id", "permission_role_channel", b"permission_role_channel", "role_id", b"role_id", "user_id", b"user_id"]) -> None: ...

global___PermissionRoleChannelListEventResponse = PermissionRoleChannelListEventResponse

@typing.final
class ChannelSettingListRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CLAN_ID_FIELD_NUMBER: builtins.int
    PARENT_ID_FIELD_NUMBER: builtins.int
    CATEGORY_ID_FIELD_NUMBER: builtins.int
    PRIVATECHANNEL_FIELD_NUMBER: builtins.int
    ACTIVE_FIELD_NUMBER: builtins.int
    STATUS_FIELD_NUMBER: builtins.int
    TYPE_FIELD_NUMBER: builtins.int
    LIMIT_FIELD_NUMBER: builtins.int
    PAGE_FIELD_NUMBER: builtins.int
    CHANNEL_LABEL_FIELD_NUMBER: builtins.int
    clan_id: builtins.str
    """clan id"""
    parent_id: builtins.str
    """parent id of thread"""
    category_id: builtins.str
    """category id"""
    channel_label: builtins.str
    """channel label"""
    @property
    def privateChannel(self) -> google.protobuf.wrappers_pb2.Int32Value:
        """is private channel"""

    @property
    def active(self) -> google.protobuf.wrappers_pb2.Int32Value:
        """is active"""

    @property
    def status(self) -> google.protobuf.wrappers_pb2.Int32Value:
        """status"""

    @property
    def type(self) -> google.protobuf.wrappers_pb2.Int32Value:
        """type"""

    @property
    def limit(self) -> google.protobuf.wrappers_pb2.Int32Value:
        """limit"""

    @property
    def page(self) -> google.protobuf.wrappers_pb2.Int32Value:
        """page"""

    def __init__(
        self,
        *,
        clan_id: builtins.str = ...,
        parent_id: builtins.str = ...,
        category_id: builtins.str = ...,
        privateChannel: google.protobuf.wrappers_pb2.Int32Value | None = ...,
        active: google.protobuf.wrappers_pb2.Int32Value | None = ...,
        status: google.protobuf.wrappers_pb2.Int32Value | None = ...,
        type: google.protobuf.wrappers_pb2.Int32Value | None = ...,
        limit: google.protobuf.wrappers_pb2.Int32Value | None = ...,
        page: google.protobuf.wrappers_pb2.Int32Value | None = ...,
        channel_label: builtins.str = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["active", b"active", "limit", b"limit", "page", b"page", "privateChannel", b"privateChannel", "status", b"status", "type", b"type"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["active", b"active", "category_id", b"category_id", "channel_label", b"channel_label", "clan_id", b"clan_id", "limit", b"limit", "page", b"page", "parent_id", b"parent_id", "privateChannel", b"privateChannel", "status", b"status", "type", b"type"]) -> None: ...

global___ChannelSettingListRequest = ChannelSettingListRequest

@typing.final
class ChannelSettingItem(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ID_FIELD_NUMBER: builtins.int
    CREATOR_ID_FIELD_NUMBER: builtins.int
    PARENT_ID_FIELD_NUMBER: builtins.int
    CHANNEL_LABEL_FIELD_NUMBER: builtins.int
    CATEGORY_ID_FIELD_NUMBER: builtins.int
    MEETING_CODE_FIELD_NUMBER: builtins.int
    CHANNEL_PRIVATE_FIELD_NUMBER: builtins.int
    CHANNEL_TYPE_FIELD_NUMBER: builtins.int
    ACTIVE_FIELD_NUMBER: builtins.int
    USER_IDS_FIELD_NUMBER: builtins.int
    MESSAGE_COUNT_FIELD_NUMBER: builtins.int
    LAST_SENT_MESSAGE_FIELD_NUMBER: builtins.int
    id: builtins.str
    """channel id"""
    creator_id: builtins.str
    """creator id"""
    parent_id: builtins.str
    """parentId"""
    channel_label: builtins.str
    """label of channel"""
    category_id: builtins.str
    """category id"""
    meeting_code: builtins.str
    """meeting code"""
    channel_private: builtins.int
    """channel private"""
    channel_type: builtins.int
    """channel type"""
    active: builtins.int
    """is active"""
    message_count: builtins.int
    """message count"""
    @property
    def user_ids(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """list user in channel"""

    @property
    def last_sent_message(self) -> global___ChannelMessageHeader:
        """last sent message"""

    def __init__(
        self,
        *,
        id: builtins.str = ...,
        creator_id: builtins.str = ...,
        parent_id: builtins.str = ...,
        channel_label: builtins.str = ...,
        category_id: builtins.str = ...,
        meeting_code: builtins.str = ...,
        channel_private: builtins.int = ...,
        channel_type: builtins.int = ...,
        active: builtins.int = ...,
        user_ids: collections.abc.Iterable[builtins.str] | None = ...,
        message_count: builtins.int = ...,
        last_sent_message: global___ChannelMessageHeader | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["last_sent_message", b"last_sent_message"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["active", b"active", "category_id", b"category_id", "channel_label", b"channel_label", "channel_private", b"channel_private", "channel_type", b"channel_type", "creator_id", b"creator_id", "id", b"id", "last_sent_message", b"last_sent_message", "meeting_code", b"meeting_code", "message_count", b"message_count", "parent_id", b"parent_id", "user_ids", b"user_ids"]) -> None: ...

global___ChannelSettingItem = ChannelSettingItem

@typing.final
class ChannelSettingListResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CLAN_ID_FIELD_NUMBER: builtins.int
    CHANNEL_COUNT_FIELD_NUMBER: builtins.int
    THREAD_COUNT_FIELD_NUMBER: builtins.int
    CHANNEL_SETTING_LIST_FIELD_NUMBER: builtins.int
    clan_id: builtins.str
    """clan id"""
    channel_count: builtins.int
    """channel count"""
    thread_count: builtins.int
    """thread count"""
    @property
    def channel_setting_list(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___ChannelSettingItem]:
        """channel setting list"""

    def __init__(
        self,
        *,
        clan_id: builtins.str = ...,
        channel_count: builtins.int = ...,
        thread_count: builtins.int = ...,
        channel_setting_list: collections.abc.Iterable[global___ChannelSettingItem] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["channel_count", b"channel_count", "channel_setting_list", b"channel_setting_list", "clan_id", b"clan_id", "thread_count", b"thread_count"]) -> None: ...

global___ChannelSettingListResponse = ChannelSettingListResponse

@typing.final
class MarkAsReadRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CHANNEL_ID_FIELD_NUMBER: builtins.int
    CATEGORY_ID_FIELD_NUMBER: builtins.int
    CLAN_ID_FIELD_NUMBER: builtins.int
    channel_id: builtins.str
    """channel id"""
    category_id: builtins.str
    """category_id"""
    clan_id: builtins.str
    """clan id"""
    def __init__(
        self,
        *,
        channel_id: builtins.str = ...,
        category_id: builtins.str = ...,
        clan_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["category_id", b"category_id", "channel_id", b"channel_id", "clan_id", b"clan_id"]) -> None: ...

global___MarkAsReadRequest = MarkAsReadRequest

@typing.final
class EditChannelCanvasRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ID_FIELD_NUMBER: builtins.int
    CHANNEL_ID_FIELD_NUMBER: builtins.int
    CLAN_ID_FIELD_NUMBER: builtins.int
    TITLE_FIELD_NUMBER: builtins.int
    CONTENT_FIELD_NUMBER: builtins.int
    IS_DEFAULT_FIELD_NUMBER: builtins.int
    STATUS_FIELD_NUMBER: builtins.int
    channel_id: builtins.str
    """channel id"""
    clan_id: builtins.str
    """clan id"""
    title: builtins.str
    """title"""
    content: builtins.str
    """content"""
    is_default: builtins.bool
    """is default"""
    status: builtins.int
    """status"""
    @property
    def id(self) -> google.protobuf.wrappers_pb2.StringValue:
        """id"""

    def __init__(
        self,
        *,
        id: google.protobuf.wrappers_pb2.StringValue | None = ...,
        channel_id: builtins.str = ...,
        clan_id: builtins.str = ...,
        title: builtins.str = ...,
        content: builtins.str = ...,
        is_default: builtins.bool = ...,
        status: builtins.int = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["id", b"id"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["channel_id", b"channel_id", "clan_id", b"clan_id", "content", b"content", "id", b"id", "is_default", b"is_default", "status", b"status", "title", b"title"]) -> None: ...

global___EditChannelCanvasRequest = EditChannelCanvasRequest

@typing.final
class EditChannelCanvasResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ID_FIELD_NUMBER: builtins.int
    id: builtins.str
    """id"""
    def __init__(
        self,
        *,
        id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["id", b"id"]) -> None: ...

global___EditChannelCanvasResponse = EditChannelCanvasResponse

@typing.final
class DeleteChannelCanvasRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CLAN_ID_FIELD_NUMBER: builtins.int
    CHANNEL_ID_FIELD_NUMBER: builtins.int
    CANVAS_ID_FIELD_NUMBER: builtins.int
    clan_id: builtins.str
    """clan id"""
    channel_id: builtins.str
    """channel id"""
    canvas_id: builtins.str
    """canvas id"""
    def __init__(
        self,
        *,
        clan_id: builtins.str = ...,
        channel_id: builtins.str = ...,
        canvas_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["canvas_id", b"canvas_id", "channel_id", b"channel_id", "clan_id", b"clan_id"]) -> None: ...

global___DeleteChannelCanvasRequest = DeleteChannelCanvasRequest

@typing.final
class ChannelCanvasListRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CLAN_ID_FIELD_NUMBER: builtins.int
    CHANNEL_ID_FIELD_NUMBER: builtins.int
    LIMIT_FIELD_NUMBER: builtins.int
    PAGE_FIELD_NUMBER: builtins.int
    CURSOR_FIELD_NUMBER: builtins.int
    clan_id: builtins.str
    """clan id"""
    channel_id: builtins.str
    """channel id"""
    cursor: builtins.str
    """"""
    @property
    def limit(self) -> google.protobuf.wrappers_pb2.Int32Value:
        """limit"""

    @property
    def page(self) -> google.protobuf.wrappers_pb2.Int32Value:
        """page"""

    def __init__(
        self,
        *,
        clan_id: builtins.str = ...,
        channel_id: builtins.str = ...,
        limit: google.protobuf.wrappers_pb2.Int32Value | None = ...,
        page: google.protobuf.wrappers_pb2.Int32Value | None = ...,
        cursor: builtins.str = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["limit", b"limit", "page", b"page"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["channel_id", b"channel_id", "clan_id", b"clan_id", "cursor", b"cursor", "limit", b"limit", "page", b"page"]) -> None: ...

global___ChannelCanvasListRequest = ChannelCanvasListRequest

@typing.final
class ChannelCanvasItem(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ID_FIELD_NUMBER: builtins.int
    TITLE_FIELD_NUMBER: builtins.int
    IS_DEFAULT_FIELD_NUMBER: builtins.int
    CONTENT_FIELD_NUMBER: builtins.int
    CREATOR_ID_FIELD_NUMBER: builtins.int
    UPDATE_TIME_FIELD_NUMBER: builtins.int
    CREATE_TIME_FIELD_NUMBER: builtins.int
    id: builtins.str
    """id"""
    title: builtins.str
    """title"""
    is_default: builtins.bool
    """is default"""
    content: builtins.str
    """content"""
    creator_id: builtins.str
    """creator"""
    @property
    def update_time(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """"""

    @property
    def create_time(self) -> google.protobuf.timestamp_pb2.Timestamp: ...
    def __init__(
        self,
        *,
        id: builtins.str = ...,
        title: builtins.str = ...,
        is_default: builtins.bool = ...,
        content: builtins.str = ...,
        creator_id: builtins.str = ...,
        update_time: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        create_time: google.protobuf.timestamp_pb2.Timestamp | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["create_time", b"create_time", "update_time", b"update_time"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["content", b"content", "create_time", b"create_time", "creator_id", b"creator_id", "id", b"id", "is_default", b"is_default", "title", b"title", "update_time", b"update_time"]) -> None: ...

global___ChannelCanvasItem = ChannelCanvasItem

@typing.final
class ChannelCanvasListResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CLAN_ID_FIELD_NUMBER: builtins.int
    CHANNEL_ID_FIELD_NUMBER: builtins.int
    CHANNEL_CANVASES_FIELD_NUMBER: builtins.int
    COUNT_FIELD_NUMBER: builtins.int
    clan_id: builtins.str
    """clan id"""
    channel_id: builtins.str
    """channel id"""
    count: builtins.int
    """"""
    @property
    def channel_canvases(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___ChannelCanvasItem]:
        """channel doc item"""

    def __init__(
        self,
        *,
        clan_id: builtins.str = ...,
        channel_id: builtins.str = ...,
        channel_canvases: collections.abc.Iterable[global___ChannelCanvasItem] | None = ...,
        count: builtins.int = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["channel_canvases", b"channel_canvases", "channel_id", b"channel_id", "clan_id", b"clan_id", "count", b"count"]) -> None: ...

global___ChannelCanvasListResponse = ChannelCanvasListResponse

@typing.final
class ChannelCanvasDetailRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ID_FIELD_NUMBER: builtins.int
    CLAN_ID_FIELD_NUMBER: builtins.int
    CHANNEL_ID_FIELD_NUMBER: builtins.int
    id: builtins.str
    """id"""
    clan_id: builtins.str
    """clan id"""
    channel_id: builtins.str
    """channel id"""
    def __init__(
        self,
        *,
        id: builtins.str = ...,
        clan_id: builtins.str = ...,
        channel_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["channel_id", b"channel_id", "clan_id", b"clan_id", "id", b"id"]) -> None: ...

global___ChannelCanvasDetailRequest = ChannelCanvasDetailRequest

@typing.final
class ChannelCanvasDetailResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ID_FIELD_NUMBER: builtins.int
    TITLE_FIELD_NUMBER: builtins.int
    CONTENT_FIELD_NUMBER: builtins.int
    CREATOR_ID_FIELD_NUMBER: builtins.int
    EDITOR_ID_FIELD_NUMBER: builtins.int
    IS_DEFAULT_FIELD_NUMBER: builtins.int
    id: builtins.str
    """id"""
    title: builtins.str
    """title"""
    content: builtins.str
    """content"""
    creator_id: builtins.str
    """creator"""
    editor_id: builtins.str
    """editor"""
    is_default: builtins.bool
    """is default"""
    def __init__(
        self,
        *,
        id: builtins.str = ...,
        title: builtins.str = ...,
        content: builtins.str = ...,
        creator_id: builtins.str = ...,
        editor_id: builtins.str = ...,
        is_default: builtins.bool = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["content", b"content", "creator_id", b"creator_id", "editor_id", b"editor_id", "id", b"id", "is_default", b"is_default", "title", b"title"]) -> None: ...

global___ChannelCanvasDetailResponse = ChannelCanvasDetailResponse

@typing.final
class AddFavoriteChannelRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CHANNEL_ID_FIELD_NUMBER: builtins.int
    CLAN_ID_FIELD_NUMBER: builtins.int
    channel_id: builtins.str
    clan_id: builtins.str
    def __init__(
        self,
        *,
        channel_id: builtins.str = ...,
        clan_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["channel_id", b"channel_id", "clan_id", b"clan_id"]) -> None: ...

global___AddFavoriteChannelRequest = AddFavoriteChannelRequest

@typing.final
class RemoveFavoriteChannelRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CLAN_ID_FIELD_NUMBER: builtins.int
    CHANNEL_ID_FIELD_NUMBER: builtins.int
    clan_id: builtins.str
    channel_id: builtins.str
    def __init__(
        self,
        *,
        clan_id: builtins.str = ...,
        channel_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["channel_id", b"channel_id", "clan_id", b"clan_id"]) -> None: ...

global___RemoveFavoriteChannelRequest = RemoveFavoriteChannelRequest

@typing.final
class AddFavoriteChannelResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CHANNEL_ID_FIELD_NUMBER: builtins.int
    channel_id: builtins.str
    def __init__(
        self,
        *,
        channel_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["channel_id", b"channel_id"]) -> None: ...

global___AddFavoriteChannelResponse = AddFavoriteChannelResponse

@typing.final
class ListFavoriteChannelRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CLAN_ID_FIELD_NUMBER: builtins.int
    clan_id: builtins.str
    def __init__(
        self,
        *,
        clan_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["clan_id", b"clan_id"]) -> None: ...

global___ListFavoriteChannelRequest = ListFavoriteChannelRequest

@typing.final
class ListFavoriteChannelResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CHANNEL_IDS_FIELD_NUMBER: builtins.int
    @property
    def channel_ids(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]: ...
    def __init__(
        self,
        *,
        channel_ids: collections.abc.Iterable[builtins.str] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["channel_ids", b"channel_ids"]) -> None: ...

global___ListFavoriteChannelResponse = ListFavoriteChannelResponse

@typing.final
class UserActivity(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    USER_ID_FIELD_NUMBER: builtins.int
    ACTIVITY_NAME_FIELD_NUMBER: builtins.int
    ACTIVITY_TYPE_FIELD_NUMBER: builtins.int
    ACTIVITY_DESCRIPTION_FIELD_NUMBER: builtins.int
    START_TIME_FIELD_NUMBER: builtins.int
    END_TIME_FIELD_NUMBER: builtins.int
    APPLICATION_ID_FIELD_NUMBER: builtins.int
    STATUS_FIELD_NUMBER: builtins.int
    user_id: builtins.str
    activity_name: builtins.str
    activity_type: builtins.int
    activity_description: builtins.str
    application_id: builtins.str
    status: builtins.int
    @property
    def start_time(self) -> google.protobuf.timestamp_pb2.Timestamp: ...
    @property
    def end_time(self) -> google.protobuf.timestamp_pb2.Timestamp: ...
    def __init__(
        self,
        *,
        user_id: builtins.str = ...,
        activity_name: builtins.str = ...,
        activity_type: builtins.int = ...,
        activity_description: builtins.str = ...,
        start_time: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        end_time: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        application_id: builtins.str = ...,
        status: builtins.int = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["end_time", b"end_time", "start_time", b"start_time"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["activity_description", b"activity_description", "activity_name", b"activity_name", "activity_type", b"activity_type", "application_id", b"application_id", "end_time", b"end_time", "start_time", b"start_time", "status", b"status", "user_id", b"user_id"]) -> None: ...

global___UserActivity = UserActivity

@typing.final
class ListUserActivity(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ACTIVITIES_FIELD_NUMBER: builtins.int
    @property
    def activities(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___UserActivity]: ...
    def __init__(
        self,
        *,
        activities: collections.abc.Iterable[global___UserActivity] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["activities", b"activities"]) -> None: ...

global___ListUserActivity = ListUserActivity

@typing.final
class CreateActivityRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ACTIVITY_NAME_FIELD_NUMBER: builtins.int
    ACTIVITY_TYPE_FIELD_NUMBER: builtins.int
    ACTIVITY_DESCRIPTION_FIELD_NUMBER: builtins.int
    START_TIME_FIELD_NUMBER: builtins.int
    APPLICATION_ID_FIELD_NUMBER: builtins.int
    STATUS_FIELD_NUMBER: builtins.int
    activity_name: builtins.str
    activity_type: builtins.int
    activity_description: builtins.str
    application_id: builtins.str
    status: builtins.int
    @property
    def start_time(self) -> google.protobuf.timestamp_pb2.Timestamp: ...
    def __init__(
        self,
        *,
        activity_name: builtins.str = ...,
        activity_type: builtins.int = ...,
        activity_description: builtins.str = ...,
        start_time: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        application_id: builtins.str = ...,
        status: builtins.int = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["start_time", b"start_time"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["activity_description", b"activity_description", "activity_name", b"activity_name", "activity_type", b"activity_type", "application_id", b"application_id", "start_time", b"start_time", "status", b"status"]) -> None: ...

global___CreateActivityRequest = CreateActivityRequest

@typing.final
class LoginIDResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    LOGIN_ID_FIELD_NUMBER: builtins.int
    STATUS_FIELD_NUMBER: builtins.int
    CREATE_TIME_SECOND_FIELD_NUMBER: builtins.int
    PLATFORM_FIELD_NUMBER: builtins.int
    USER_ID_FIELD_NUMBER: builtins.int
    USERNAME_FIELD_NUMBER: builtins.int
    ADDRESS_FIELD_NUMBER: builtins.int
    login_id: builtins.str
    """loginId"""
    status: builtins.int
    """status login"""
    create_time_second: builtins.int
    """create time"""
    platform: builtins.str
    """platform"""
    user_id: builtins.int
    """user_id"""
    username: builtins.str
    """username"""
    address: builtins.str
    """address"""
    def __init__(
        self,
        *,
        login_id: builtins.str = ...,
        status: builtins.int = ...,
        create_time_second: builtins.int = ...,
        platform: builtins.str = ...,
        user_id: builtins.int = ...,
        username: builtins.str = ...,
        address: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["address", b"address", "create_time_second", b"create_time_second", "login_id", b"login_id", "platform", b"platform", "status", b"status", "user_id", b"user_id", "username", b"username"]) -> None: ...

global___LoginIDResponse = LoginIDResponse

@typing.final
class LoginRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    PLATFORM_FIELD_NUMBER: builtins.int
    ADDRESS_FIELD_NUMBER: builtins.int
    platform: builtins.str
    """platform"""
    address: builtins.str
    """address"""
    def __init__(
        self,
        *,
        platform: builtins.str = ...,
        address: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["address", b"address", "platform", b"platform"]) -> None: ...

global___LoginRequest = LoginRequest

@typing.final
class ConfirmLoginRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    LOGIN_ID_FIELD_NUMBER: builtins.int
    IS_REMEMBER_FIELD_NUMBER: builtins.int
    login_id: builtins.str
    """loginId"""
    @property
    def is_remember(self) -> google.protobuf.wrappers_pb2.BoolValue:
        """Whether to enable "Remember Me" for extended session duration."""

    def __init__(
        self,
        *,
        login_id: builtins.str = ...,
        is_remember: google.protobuf.wrappers_pb2.BoolValue | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["is_remember", b"is_remember"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["is_remember", b"is_remember", "login_id", b"login_id"]) -> None: ...

global___ConfirmLoginRequest = ConfirmLoginRequest

@typing.final
class PubKey(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ENCR_FIELD_NUMBER: builtins.int
    SIGN_FIELD_NUMBER: builtins.int
    encr: builtins.bytes
    sign: builtins.bytes
    def __init__(
        self,
        *,
        encr: builtins.bytes = ...,
        sign: builtins.bytes = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["encr", b"encr", "sign", b"sign"]) -> None: ...

global___PubKey = PubKey

@typing.final
class PushPubKeyRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    PK_FIELD_NUMBER: builtins.int
    @property
    def PK(self) -> global___PubKey: ...
    def __init__(
        self,
        *,
        PK: global___PubKey | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["PK", b"PK"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["PK", b"PK"]) -> None: ...

global___PushPubKeyRequest = PushPubKeyRequest

@typing.final
class GetPubKeysRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    USER_IDS_FIELD_NUMBER: builtins.int
    @property
    def user_ids(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]: ...
    def __init__(
        self,
        *,
        user_ids: collections.abc.Iterable[builtins.str] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["user_ids", b"user_ids"]) -> None: ...

global___GetPubKeysRequest = GetPubKeysRequest

@typing.final
class GetPubKeysResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    @typing.final
    class UserPubKey(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        USER_ID_FIELD_NUMBER: builtins.int
        PK_FIELD_NUMBER: builtins.int
        user_id: builtins.str
        @property
        def PK(self) -> global___PubKey: ...
        def __init__(
            self,
            *,
            user_id: builtins.str = ...,
            PK: global___PubKey | None = ...,
        ) -> None: ...
        def HasField(self, field_name: typing.Literal["PK", b"PK"]) -> builtins.bool: ...
        def ClearField(self, field_name: typing.Literal["PK", b"PK", "user_id", b"user_id"]) -> None: ...

    PUB_KEYS_FIELD_NUMBER: builtins.int
    @property
    def pub_keys(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___GetPubKeysResponse.UserPubKey]: ...
    def __init__(
        self,
        *,
        pub_keys: collections.abc.Iterable[global___GetPubKeysResponse.UserPubKey] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["pub_keys", b"pub_keys"]) -> None: ...

global___GetPubKeysResponse = GetPubKeysResponse

@typing.final
class ChanEncryptionMethod(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    METHOD_FIELD_NUMBER: builtins.int
    CHANNEL_ID_FIELD_NUMBER: builtins.int
    method: builtins.str
    channel_id: builtins.str
    def __init__(
        self,
        *,
        method: builtins.str = ...,
        channel_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["channel_id", b"channel_id", "method", b"method"]) -> None: ...

global___ChanEncryptionMethod = ChanEncryptionMethod

@typing.final
class GetKeyServerResp(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    URL_FIELD_NUMBER: builtins.int
    url: builtins.str
    def __init__(
        self,
        *,
        url: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["url", b"url"]) -> None: ...

global___GetKeyServerResp = GetKeyServerResp

@typing.final
class AuditLog(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ID_FIELD_NUMBER: builtins.int
    USER_ID_FIELD_NUMBER: builtins.int
    CLAN_ID_FIELD_NUMBER: builtins.int
    ACTION_LOG_FIELD_NUMBER: builtins.int
    ENTITY_NAME_FIELD_NUMBER: builtins.int
    ENTITY_ID_FIELD_NUMBER: builtins.int
    DETAILS_FIELD_NUMBER: builtins.int
    TIME_LOG_FIELD_NUMBER: builtins.int
    CHANNEL_ID_FIELD_NUMBER: builtins.int
    CHANNEL_LABEL_FIELD_NUMBER: builtins.int
    id: builtins.str
    user_id: builtins.str
    clan_id: builtins.str
    action_log: builtins.str
    entity_name: builtins.str
    entity_id: builtins.str
    details: builtins.str
    channel_id: builtins.str
    channel_label: builtins.str
    @property
    def time_log(self) -> google.protobuf.timestamp_pb2.Timestamp: ...
    def __init__(
        self,
        *,
        id: builtins.str = ...,
        user_id: builtins.str = ...,
        clan_id: builtins.str = ...,
        action_log: builtins.str = ...,
        entity_name: builtins.str = ...,
        entity_id: builtins.str = ...,
        details: builtins.str = ...,
        time_log: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        channel_id: builtins.str = ...,
        channel_label: builtins.str = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["time_log", b"time_log"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["action_log", b"action_log", "channel_id", b"channel_id", "channel_label", b"channel_label", "clan_id", b"clan_id", "details", b"details", "entity_id", b"entity_id", "entity_name", b"entity_name", "id", b"id", "time_log", b"time_log", "user_id", b"user_id"]) -> None: ...

global___AuditLog = AuditLog

@typing.final
class ListAuditLog(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    TOTAL_COUNT_FIELD_NUMBER: builtins.int
    DATE_LOG_FIELD_NUMBER: builtins.int
    LOGS_FIELD_NUMBER: builtins.int
    total_count: builtins.int
    date_log: builtins.str
    @property
    def logs(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___AuditLog]: ...
    def __init__(
        self,
        *,
        total_count: builtins.int = ...,
        date_log: builtins.str = ...,
        logs: collections.abc.Iterable[global___AuditLog] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["date_log", b"date_log", "logs", b"logs", "total_count", b"total_count"]) -> None: ...

global___ListAuditLog = ListAuditLog

@typing.final
class ListAuditLogRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ACTION_LOG_FIELD_NUMBER: builtins.int
    USER_ID_FIELD_NUMBER: builtins.int
    CLAN_ID_FIELD_NUMBER: builtins.int
    DATE_LOG_FIELD_NUMBER: builtins.int
    action_log: builtins.str
    user_id: builtins.str
    clan_id: builtins.str
    date_log: builtins.str
    def __init__(
        self,
        *,
        action_log: builtins.str = ...,
        user_id: builtins.str = ...,
        clan_id: builtins.str = ...,
        date_log: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["action_log", b"action_log", "clan_id", b"clan_id", "date_log", b"date_log", "user_id", b"user_id"]) -> None: ...

global___ListAuditLogRequest = ListAuditLogRequest

@typing.final
class TokenSentEvent(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    SENDER_ID_FIELD_NUMBER: builtins.int
    SENDER_NAME_FIELD_NUMBER: builtins.int
    RECEIVER_ID_FIELD_NUMBER: builtins.int
    AMOUNT_FIELD_NUMBER: builtins.int
    NOTE_FIELD_NUMBER: builtins.int
    EXTRA_ATTRIBUTE_FIELD_NUMBER: builtins.int
    TRANSACTION_ID_FIELD_NUMBER: builtins.int
    sender_id: builtins.str
    """sender id"""
    sender_name: builtins.str
    """sender name"""
    receiver_id: builtins.str
    """receiver"""
    amount: builtins.int
    """amount of token"""
    note: builtins.str
    """note"""
    extra_attribute: builtins.str
    """extra attribute"""
    transaction_id: builtins.str
    """transaction id"""
    def __init__(
        self,
        *,
        sender_id: builtins.str = ...,
        sender_name: builtins.str = ...,
        receiver_id: builtins.str = ...,
        amount: builtins.int = ...,
        note: builtins.str = ...,
        extra_attribute: builtins.str = ...,
        transaction_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["amount", b"amount", "extra_attribute", b"extra_attribute", "note", b"note", "receiver_id", b"receiver_id", "sender_id", b"sender_id", "sender_name", b"sender_name", "transaction_id", b"transaction_id"]) -> None: ...

global___TokenSentEvent = TokenSentEvent

@typing.final
class UnlockItemRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ITEM_ID_FIELD_NUMBER: builtins.int
    ITEM_TYPE_FIELD_NUMBER: builtins.int
    item_id: builtins.str
    """item id"""
    item_type: builtins.int
    """item type"""
    def __init__(
        self,
        *,
        item_id: builtins.str = ...,
        item_type: builtins.int = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["item_id", b"item_id", "item_type", b"item_type"]) -> None: ...

global___UnlockItemRequest = UnlockItemRequest

@typing.final
class UnlockedItemResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    SOURCE_FIELD_NUMBER: builtins.int
    source: builtins.str
    def __init__(
        self,
        *,
        source: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["source", b"source"]) -> None: ...

global___UnlockedItemResponse = UnlockedItemResponse

@typing.final
class ListOnboardingRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CLAN_ID_FIELD_NUMBER: builtins.int
    GUIDE_TYPE_FIELD_NUMBER: builtins.int
    LIMIT_FIELD_NUMBER: builtins.int
    PAGE_FIELD_NUMBER: builtins.int
    clan_id: builtins.str
    """clan id"""
    @property
    def guide_type(self) -> google.protobuf.wrappers_pb2.Int32Value:
        """guide_type: 0 = greeting, 1 = rule, 2 = task, 3 = question"""

    @property
    def limit(self) -> google.protobuf.wrappers_pb2.Int32Value:
        """limit"""

    @property
    def page(self) -> google.protobuf.wrappers_pb2.Int32Value:
        """page"""

    def __init__(
        self,
        *,
        clan_id: builtins.str = ...,
        guide_type: google.protobuf.wrappers_pb2.Int32Value | None = ...,
        limit: google.protobuf.wrappers_pb2.Int32Value | None = ...,
        page: google.protobuf.wrappers_pb2.Int32Value | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["guide_type", b"guide_type", "limit", b"limit", "page", b"page"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["clan_id", b"clan_id", "guide_type", b"guide_type", "limit", b"limit", "page", b"page"]) -> None: ...

global___ListOnboardingRequest = ListOnboardingRequest

@typing.final
class ListOnboardingResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    LIST_ONBOARDING_FIELD_NUMBER: builtins.int
    @property
    def list_onboarding(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___OnboardingItem]: ...
    def __init__(
        self,
        *,
        list_onboarding: collections.abc.Iterable[global___OnboardingItem] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["list_onboarding", b"list_onboarding"]) -> None: ...

global___ListOnboardingResponse = ListOnboardingResponse

@typing.final
class OnboardingItem(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ID_FIELD_NUMBER: builtins.int
    CLAN_ID_FIELD_NUMBER: builtins.int
    GUIDE_TYPE_FIELD_NUMBER: builtins.int
    TASK_TYPE_FIELD_NUMBER: builtins.int
    CHANNEL_ID_FIELD_NUMBER: builtins.int
    TITLE_FIELD_NUMBER: builtins.int
    CONTENT_FIELD_NUMBER: builtins.int
    IMAGE_URL_FIELD_NUMBER: builtins.int
    ANSWERS_FIELD_NUMBER: builtins.int
    CREATE_TIME_FIELD_NUMBER: builtins.int
    UPDATE_TIME_FIELD_NUMBER: builtins.int
    id: builtins.str
    """id"""
    clan_id: builtins.str
    """clan id"""
    guide_type: builtins.int
    """guide_type: 0 = greeting, 1 = rule, 2 = task, 3 = question"""
    task_type: builtins.int
    """task type"""
    channel_id: builtins.str
    """channel id"""
    title: builtins.str
    """title"""
    content: builtins.str
    """content"""
    image_url: builtins.str
    """image"""
    @property
    def answers(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___OnboardingAnswer]:
        """answers"""

    @property
    def create_time(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """The UNIX time (for gRPC clients) or ISO string (for REST clients) when the message was created."""

    @property
    def update_time(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """The UNIX time (for gRPC clients) or ISO string (for REST clients) when the message was last updated."""

    def __init__(
        self,
        *,
        id: builtins.str = ...,
        clan_id: builtins.str = ...,
        guide_type: builtins.int = ...,
        task_type: builtins.int = ...,
        channel_id: builtins.str = ...,
        title: builtins.str = ...,
        content: builtins.str = ...,
        image_url: builtins.str = ...,
        answers: collections.abc.Iterable[global___OnboardingAnswer] | None = ...,
        create_time: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        update_time: google.protobuf.timestamp_pb2.Timestamp | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["create_time", b"create_time", "update_time", b"update_time"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["answers", b"answers", "channel_id", b"channel_id", "clan_id", b"clan_id", "content", b"content", "create_time", b"create_time", "guide_type", b"guide_type", "id", b"id", "image_url", b"image_url", "task_type", b"task_type", "title", b"title", "update_time", b"update_time"]) -> None: ...

global___OnboardingItem = OnboardingItem

@typing.final
class OnboardingAnswer(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    TITLE_FIELD_NUMBER: builtins.int
    DESCRIPTION_FIELD_NUMBER: builtins.int
    EMOJI_FIELD_NUMBER: builtins.int
    IMAGE_URL_FIELD_NUMBER: builtins.int
    title: builtins.str
    """title"""
    description: builtins.str
    """description"""
    emoji: builtins.str
    """emoji"""
    image_url: builtins.str
    """image"""
    def __init__(
        self,
        *,
        title: builtins.str = ...,
        description: builtins.str = ...,
        emoji: builtins.str = ...,
        image_url: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["description", b"description", "emoji", b"emoji", "image_url", b"image_url", "title", b"title"]) -> None: ...

global___OnboardingAnswer = OnboardingAnswer

@typing.final
class OnboardingContent(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    GUIDE_TYPE_FIELD_NUMBER: builtins.int
    TASK_TYPE_FIELD_NUMBER: builtins.int
    CHANNEL_ID_FIELD_NUMBER: builtins.int
    TITLE_FIELD_NUMBER: builtins.int
    CONTENT_FIELD_NUMBER: builtins.int
    IMAGE_URL_FIELD_NUMBER: builtins.int
    ANSWERS_FIELD_NUMBER: builtins.int
    guide_type: builtins.int
    """guide type"""
    task_type: builtins.int
    """task type"""
    channel_id: builtins.str
    """channel id"""
    title: builtins.str
    """title"""
    content: builtins.str
    """content"""
    image_url: builtins.str
    """image"""
    @property
    def answers(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___OnboardingAnswer]:
        """answers"""

    def __init__(
        self,
        *,
        guide_type: builtins.int = ...,
        task_type: builtins.int = ...,
        channel_id: builtins.str = ...,
        title: builtins.str = ...,
        content: builtins.str = ...,
        image_url: builtins.str = ...,
        answers: collections.abc.Iterable[global___OnboardingAnswer] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["answers", b"answers", "channel_id", b"channel_id", "content", b"content", "guide_type", b"guide_type", "image_url", b"image_url", "task_type", b"task_type", "title", b"title"]) -> None: ...

global___OnboardingContent = OnboardingContent

@typing.final
class CreateOnboardingRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CLAN_ID_FIELD_NUMBER: builtins.int
    CONTENTS_FIELD_NUMBER: builtins.int
    clan_id: builtins.str
    """clan id"""
    @property
    def contents(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___OnboardingContent]:
        """contents"""

    def __init__(
        self,
        *,
        clan_id: builtins.str = ...,
        contents: collections.abc.Iterable[global___OnboardingContent] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["clan_id", b"clan_id", "contents", b"contents"]) -> None: ...

global___CreateOnboardingRequest = CreateOnboardingRequest

@typing.final
class UpdateOnboardingRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ID_FIELD_NUMBER: builtins.int
    CLAN_ID_FIELD_NUMBER: builtins.int
    TASK_TYPE_FIELD_NUMBER: builtins.int
    CHANNEL_ID_FIELD_NUMBER: builtins.int
    TITLE_FIELD_NUMBER: builtins.int
    CONTENT_FIELD_NUMBER: builtins.int
    IMAGE_URL_FIELD_NUMBER: builtins.int
    ANSWERS_FIELD_NUMBER: builtins.int
    id: builtins.str
    """id"""
    clan_id: builtins.str
    """clan id"""
    channel_id: builtins.str
    """channel id"""
    title: builtins.str
    """title"""
    content: builtins.str
    """content"""
    image_url: builtins.str
    """image"""
    @property
    def task_type(self) -> google.protobuf.wrappers_pb2.Int32Value:
        """task type"""

    @property
    def answers(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___OnboardingAnswer]:
        """answers"""

    def __init__(
        self,
        *,
        id: builtins.str = ...,
        clan_id: builtins.str = ...,
        task_type: google.protobuf.wrappers_pb2.Int32Value | None = ...,
        channel_id: builtins.str = ...,
        title: builtins.str = ...,
        content: builtins.str = ...,
        image_url: builtins.str = ...,
        answers: collections.abc.Iterable[global___OnboardingAnswer] | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["task_type", b"task_type"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["answers", b"answers", "channel_id", b"channel_id", "clan_id", b"clan_id", "content", b"content", "id", b"id", "image_url", b"image_url", "task_type", b"task_type", "title", b"title"]) -> None: ...

global___UpdateOnboardingRequest = UpdateOnboardingRequest

@typing.final
class OnboardingRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ID_FIELD_NUMBER: builtins.int
    CLAN_ID_FIELD_NUMBER: builtins.int
    id: builtins.str
    """id"""
    clan_id: builtins.str
    """clan id"""
    def __init__(
        self,
        *,
        id: builtins.str = ...,
        clan_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["clan_id", b"clan_id", "id", b"id"]) -> None: ...

global___OnboardingRequest = OnboardingRequest

@typing.final
class ClanWebhook(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ID_FIELD_NUMBER: builtins.int
    WEBHOOK_NAME_FIELD_NUMBER: builtins.int
    CLAN_ID_FIELD_NUMBER: builtins.int
    ACTIVE_FIELD_NUMBER: builtins.int
    URL_FIELD_NUMBER: builtins.int
    CREATOR_ID_FIELD_NUMBER: builtins.int
    AVATAR_FIELD_NUMBER: builtins.int
    CREATE_TIME_FIELD_NUMBER: builtins.int
    UPDATE_TIME_FIELD_NUMBER: builtins.int
    id: builtins.str
    """id."""
    webhook_name: builtins.str
    """webhook name."""
    clan_id: builtins.str
    """clan id."""
    active: builtins.int
    """active."""
    url: builtins.str
    """URL of the webhook, which is automatically generated and different from the avatar."""
    creator_id: builtins.str
    """creator id."""
    avatar: builtins.str
    """avatar"""
    create_time: builtins.str
    """create time."""
    update_time: builtins.str
    """update time."""
    def __init__(
        self,
        *,
        id: builtins.str = ...,
        webhook_name: builtins.str = ...,
        clan_id: builtins.str = ...,
        active: builtins.int = ...,
        url: builtins.str = ...,
        creator_id: builtins.str = ...,
        avatar: builtins.str = ...,
        create_time: builtins.str = ...,
        update_time: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["active", b"active", "avatar", b"avatar", "clan_id", b"clan_id", "create_time", b"create_time", "creator_id", b"creator_id", "id", b"id", "update_time", b"update_time", "url", b"url", "webhook_name", b"webhook_name"]) -> None: ...

global___ClanWebhook = ClanWebhook

@typing.final
class GenerateClanWebhookRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CLAN_ID_FIELD_NUMBER: builtins.int
    WEBHOOK_NAME_FIELD_NUMBER: builtins.int
    AVATAR_FIELD_NUMBER: builtins.int
    clan_id: builtins.str
    """clan id."""
    webhook_name: builtins.str
    """webhook name."""
    avatar: builtins.str
    """avatar."""
    def __init__(
        self,
        *,
        clan_id: builtins.str = ...,
        webhook_name: builtins.str = ...,
        avatar: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["avatar", b"avatar", "clan_id", b"clan_id", "webhook_name", b"webhook_name"]) -> None: ...

global___GenerateClanWebhookRequest = GenerateClanWebhookRequest

@typing.final
class GenerateClanWebhookResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CLAN_ID_FIELD_NUMBER: builtins.int
    URL_FIELD_NUMBER: builtins.int
    WEBHOOK_NAME_FIELD_NUMBER: builtins.int
    AVATAR_FIELD_NUMBER: builtins.int
    clan_id: builtins.str
    """clan id."""
    url: builtins.str
    """url."""
    webhook_name: builtins.str
    """webhook name."""
    avatar: builtins.str
    """avatar."""
    def __init__(
        self,
        *,
        clan_id: builtins.str = ...,
        url: builtins.str = ...,
        webhook_name: builtins.str = ...,
        avatar: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["avatar", b"avatar", "clan_id", b"clan_id", "url", b"url", "webhook_name", b"webhook_name"]) -> None: ...

global___GenerateClanWebhookResponse = GenerateClanWebhookResponse

@typing.final
class ClanWebhookRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ID_FIELD_NUMBER: builtins.int
    CLAN_ID_FIELD_NUMBER: builtins.int
    id: builtins.str
    """id."""
    clan_id: builtins.str
    """clan id."""
    def __init__(
        self,
        *,
        id: builtins.str = ...,
        clan_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["clan_id", b"clan_id", "id", b"id"]) -> None: ...

global___ClanWebhookRequest = ClanWebhookRequest

@typing.final
class UpdateClanWebhookRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ID_FIELD_NUMBER: builtins.int
    CLAN_ID_FIELD_NUMBER: builtins.int
    WEBHOOK_NAME_FIELD_NUMBER: builtins.int
    AVATAR_FIELD_NUMBER: builtins.int
    RESET_TOKEN_FIELD_NUMBER: builtins.int
    id: builtins.str
    """webhook id."""
    clan_id: builtins.str
    """clan id."""
    webhook_name: builtins.str
    """webhook name."""
    avatar: builtins.str
    """avatar."""
    reset_token: builtins.bool
    """reset token."""
    def __init__(
        self,
        *,
        id: builtins.str = ...,
        clan_id: builtins.str = ...,
        webhook_name: builtins.str = ...,
        avatar: builtins.str = ...,
        reset_token: builtins.bool = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["avatar", b"avatar", "clan_id", b"clan_id", "id", b"id", "reset_token", b"reset_token", "webhook_name", b"webhook_name"]) -> None: ...

global___UpdateClanWebhookRequest = UpdateClanWebhookRequest

@typing.final
class ListClanWebhookRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CLAN_ID_FIELD_NUMBER: builtins.int
    clan_id: builtins.str
    """clan_id."""
    def __init__(
        self,
        *,
        clan_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["clan_id", b"clan_id"]) -> None: ...

global___ListClanWebhookRequest = ListClanWebhookRequest

@typing.final
class ListClanWebhookResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    LIST_CLAN_WEBHOOKS_FIELD_NUMBER: builtins.int
    @property
    def list_clan_webhooks(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___ClanWebhook]:
        """list clan webhook."""

    def __init__(
        self,
        *,
        list_clan_webhooks: collections.abc.Iterable[global___ClanWebhook] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["list_clan_webhooks", b"list_clan_webhooks"]) -> None: ...

global___ListClanWebhookResponse = ListClanWebhookResponse

@typing.final
class ClanWebhookHandlerBody(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CONTENT_FIELD_NUMBER: builtins.int
    ATTACHMENTS_FIELD_NUMBER: builtins.int
    content: builtins.str
    """content"""
    @property
    def attachments(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___MessageAttachment]:
        """list clan webhook."""

    def __init__(
        self,
        *,
        content: builtins.str = ...,
        attachments: collections.abc.Iterable[global___MessageAttachment] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["attachments", b"attachments", "content", b"content"]) -> None: ...

global___ClanWebhookHandlerBody = ClanWebhookHandlerBody

@typing.final
class ClanWebhookHandlerRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    BODY_FIELD_NUMBER: builtins.int
    TOKEN_FIELD_NUMBER: builtins.int
    USERNAME_FIELD_NUMBER: builtins.int
    token: builtins.str
    """token."""
    username: builtins.str
    """username."""
    @property
    def body(self) -> global___ClanWebhookHandlerBody:
        """body."""

    def __init__(
        self,
        *,
        body: global___ClanWebhookHandlerBody | None = ...,
        token: builtins.str = ...,
        username: builtins.str = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["body", b"body"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["body", b"body", "token", b"token", "username", b"username"]) -> None: ...

global___ClanWebhookHandlerRequest = ClanWebhookHandlerRequest

@typing.final
class UserStatus(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    USER_ID_FIELD_NUMBER: builtins.int
    STATUS_FIELD_NUMBER: builtins.int
    user_id: builtins.str
    status: builtins.str
    def __init__(
        self,
        *,
        user_id: builtins.str = ...,
        status: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["status", b"status", "user_id", b"user_id"]) -> None: ...

global___UserStatus = UserStatus

@typing.final
class UserStatusUpdate(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    STATUS_FIELD_NUMBER: builtins.int
    MINUTES_FIELD_NUMBER: builtins.int
    UNTIL_TURN_ON_FIELD_NUMBER: builtins.int
    status: builtins.str
    minutes: builtins.int
    until_turn_on: builtins.bool
    def __init__(
        self,
        *,
        status: builtins.str = ...,
        minutes: builtins.int = ...,
        until_turn_on: builtins.bool = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["minutes", b"minutes", "status", b"status", "until_turn_on", b"until_turn_on"]) -> None: ...

global___UserStatusUpdate = UserStatusUpdate

@typing.final
class OnboardingSteps(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ID_FIELD_NUMBER: builtins.int
    USER_ID_FIELD_NUMBER: builtins.int
    CLAN_ID_FIELD_NUMBER: builtins.int
    ONBOARDING_STEP_FIELD_NUMBER: builtins.int
    id: builtins.str
    """id."""
    user_id: builtins.str
    """user id."""
    clan_id: builtins.str
    """clan id."""
    onboarding_step: builtins.int
    """onboarding step."""
    def __init__(
        self,
        *,
        id: builtins.str = ...,
        user_id: builtins.str = ...,
        clan_id: builtins.str = ...,
        onboarding_step: builtins.int = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["clan_id", b"clan_id", "id", b"id", "onboarding_step", b"onboarding_step", "user_id", b"user_id"]) -> None: ...

global___OnboardingSteps = OnboardingSteps

@typing.final
class ListOnboardingStepResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    LIST_ONBOARDING_STEP_FIELD_NUMBER: builtins.int
    @property
    def list_onboarding_step(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___OnboardingSteps]:
        """list onboarding steps."""

    def __init__(
        self,
        *,
        list_onboarding_step: collections.abc.Iterable[global___OnboardingSteps] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["list_onboarding_step", b"list_onboarding_step"]) -> None: ...

global___ListOnboardingStepResponse = ListOnboardingStepResponse

@typing.final
class ListOnboardingStepRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CLAN_ID_FIELD_NUMBER: builtins.int
    LIMIT_FIELD_NUMBER: builtins.int
    PAGE_FIELD_NUMBER: builtins.int
    clan_id: builtins.str
    """clan id."""
    @property
    def limit(self) -> google.protobuf.wrappers_pb2.Int32Value:
        """limit"""

    @property
    def page(self) -> google.protobuf.wrappers_pb2.Int32Value:
        """page"""

    def __init__(
        self,
        *,
        clan_id: builtins.str = ...,
        limit: google.protobuf.wrappers_pb2.Int32Value | None = ...,
        page: google.protobuf.wrappers_pb2.Int32Value | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["limit", b"limit", "page", b"page"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["clan_id", b"clan_id", "limit", b"limit", "page", b"page"]) -> None: ...

global___ListOnboardingStepRequest = ListOnboardingStepRequest

@typing.final
class UpdateOnboardingStepRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CLAN_ID_FIELD_NUMBER: builtins.int
    ONBOARDING_STEP_FIELD_NUMBER: builtins.int
    clan_id: builtins.str
    """clan id."""
    @property
    def onboarding_step(self) -> google.protobuf.wrappers_pb2.Int32Value:
        """onboarding step."""

    def __init__(
        self,
        *,
        clan_id: builtins.str = ...,
        onboarding_step: google.protobuf.wrappers_pb2.Int32Value | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["onboarding_step", b"onboarding_step"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["clan_id", b"clan_id", "onboarding_step", b"onboarding_step"]) -> None: ...

global___UpdateOnboardingStepRequest = UpdateOnboardingStepRequest

@typing.final
class SdTopic(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ID_FIELD_NUMBER: builtins.int
    CREATOR_ID_FIELD_NUMBER: builtins.int
    MESSAGE_ID_FIELD_NUMBER: builtins.int
    CLAN_ID_FIELD_NUMBER: builtins.int
    CHANNEL_ID_FIELD_NUMBER: builtins.int
    STATUS_FIELD_NUMBER: builtins.int
    CREATE_TIME_FIELD_NUMBER: builtins.int
    UPDATE_TIME_FIELD_NUMBER: builtins.int
    MESSAGE_FIELD_NUMBER: builtins.int
    LAST_SENT_MESSAGE_FIELD_NUMBER: builtins.int
    id: builtins.str
    creator_id: builtins.str
    message_id: builtins.str
    clan_id: builtins.str
    channel_id: builtins.str
    status: builtins.int
    @property
    def create_time(self) -> google.protobuf.timestamp_pb2.Timestamp: ...
    @property
    def update_time(self) -> google.protobuf.timestamp_pb2.Timestamp: ...
    @property
    def message(self) -> global___ChannelMessage: ...
    @property
    def last_sent_message(self) -> global___ChannelMessageHeader: ...
    def __init__(
        self,
        *,
        id: builtins.str = ...,
        creator_id: builtins.str = ...,
        message_id: builtins.str = ...,
        clan_id: builtins.str = ...,
        channel_id: builtins.str = ...,
        status: builtins.int = ...,
        create_time: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        update_time: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        message: global___ChannelMessage | None = ...,
        last_sent_message: global___ChannelMessageHeader | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["create_time", b"create_time", "last_sent_message", b"last_sent_message", "message", b"message", "update_time", b"update_time"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["channel_id", b"channel_id", "clan_id", b"clan_id", "create_time", b"create_time", "creator_id", b"creator_id", "id", b"id", "last_sent_message", b"last_sent_message", "message", b"message", "message_id", b"message_id", "status", b"status", "update_time", b"update_time"]) -> None: ...

global___SdTopic = SdTopic

@typing.final
class SdTopicRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    MESSAGE_ID_FIELD_NUMBER: builtins.int
    CLAN_ID_FIELD_NUMBER: builtins.int
    CHANNEL_ID_FIELD_NUMBER: builtins.int
    message_id: builtins.str
    clan_id: builtins.str
    channel_id: builtins.str
    def __init__(
        self,
        *,
        message_id: builtins.str = ...,
        clan_id: builtins.str = ...,
        channel_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["channel_id", b"channel_id", "clan_id", b"clan_id", "message_id", b"message_id"]) -> None: ...

global___SdTopicRequest = SdTopicRequest

@typing.final
class SdTopicList(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    COUNT_FIELD_NUMBER: builtins.int
    TOPICS_FIELD_NUMBER: builtins.int
    count: builtins.int
    @property
    def topics(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___SdTopic]: ...
    def __init__(
        self,
        *,
        count: builtins.int = ...,
        topics: collections.abc.Iterable[global___SdTopic] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["count", b"count", "topics", b"topics"]) -> None: ...

global___SdTopicList = SdTopicList

@typing.final
class ListSdTopicRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CLAN_ID_FIELD_NUMBER: builtins.int
    LIMIT_FIELD_NUMBER: builtins.int
    clan_id: builtins.str
    limit: builtins.int
    def __init__(
        self,
        *,
        clan_id: builtins.str = ...,
        limit: builtins.int = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["clan_id", b"clan_id", "limit", b"limit"]) -> None: ...

global___ListSdTopicRequest = ListSdTopicRequest

@typing.final
class SdTopicDetailRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    TOPIC_ID_FIELD_NUMBER: builtins.int
    topic_id: builtins.str
    def __init__(
        self,
        *,
        topic_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["topic_id", b"topic_id"]) -> None: ...

global___SdTopicDetailRequest = SdTopicDetailRequest

@typing.final
class DeleteSdTopicRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CHANNEL_ID_FIELD_NUMBER: builtins.int
    ID_FIELD_NUMBER: builtins.int
    CLAN_ID_FIELD_NUMBER: builtins.int
    channel_id: builtins.str
    id: builtins.str
    clan_id: builtins.str
    def __init__(
        self,
        *,
        channel_id: builtins.str = ...,
        id: builtins.str = ...,
        clan_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["channel_id", b"channel_id", "clan_id", b"clan_id", "id", b"id"]) -> None: ...

global___DeleteSdTopicRequest = DeleteSdTopicRequest

@typing.final
class GenerateMeetTokenRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CHANNEL_ID_FIELD_NUMBER: builtins.int
    ROOM_NAME_FIELD_NUMBER: builtins.int
    channel_id: builtins.str
    room_name: builtins.str
    def __init__(
        self,
        *,
        channel_id: builtins.str = ...,
        room_name: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["channel_id", b"channel_id", "room_name", b"room_name"]) -> None: ...

global___GenerateMeetTokenRequest = GenerateMeetTokenRequest

@typing.final
class MeetParticipantRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    USERNAME_FIELD_NUMBER: builtins.int
    ROOM_NAME_FIELD_NUMBER: builtins.int
    CHANNEL_ID_FIELD_NUMBER: builtins.int
    CLAN_ID_FIELD_NUMBER: builtins.int
    username: builtins.str
    room_name: builtins.str
    channel_id: builtins.str
    clan_id: builtins.str
    def __init__(
        self,
        *,
        username: builtins.str = ...,
        room_name: builtins.str = ...,
        channel_id: builtins.str = ...,
        clan_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["channel_id", b"channel_id", "clan_id", b"clan_id", "room_name", b"room_name", "username", b"username"]) -> None: ...

global___MeetParticipantRequest = MeetParticipantRequest

@typing.final
class GenerateMeetTokenResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    TOKEN_FIELD_NUMBER: builtins.int
    token: builtins.str
    def __init__(
        self,
        *,
        token: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["token", b"token"]) -> None: ...

global___GenerateMeetTokenResponse = GenerateMeetTokenResponse

@typing.final
class GenerateMezonMeetResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    MEET_ID_FIELD_NUMBER: builtins.int
    ROOM_NAME_FIELD_NUMBER: builtins.int
    EXTERNAL_LINK_FIELD_NUMBER: builtins.int
    CREATOR_ID_FIELD_NUMBER: builtins.int
    EVENT_ID_FIELD_NUMBER: builtins.int
    meet_id: builtins.str
    room_name: builtins.str
    external_link: builtins.str
    creator_id: builtins.str
    event_id: builtins.str
    def __init__(
        self,
        *,
        meet_id: builtins.str = ...,
        room_name: builtins.str = ...,
        external_link: builtins.str = ...,
        creator_id: builtins.str = ...,
        event_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["creator_id", b"creator_id", "event_id", b"event_id", "external_link", b"external_link", "meet_id", b"meet_id", "room_name", b"room_name"]) -> None: ...

global___GenerateMezonMeetResponse = GenerateMezonMeetResponse

@typing.final
class CreateRoomChannelApps(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CHANNEL_ID_FIELD_NUMBER: builtins.int
    ROOM_NAME_FIELD_NUMBER: builtins.int
    channel_id: builtins.str
    room_name: builtins.str
    def __init__(
        self,
        *,
        channel_id: builtins.str = ...,
        room_name: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["channel_id", b"channel_id", "room_name", b"room_name"]) -> None: ...

global___CreateRoomChannelApps = CreateRoomChannelApps

@typing.final
class MezonOauthClient(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ACCESS_TOKEN_STRATEGY_FIELD_NUMBER: builtins.int
    ALLOWED_CORS_ORIGINS_FIELD_NUMBER: builtins.int
    AUDIENCE_FIELD_NUMBER: builtins.int
    AUTHORIZATION_CODE_GRANT_ACCESS_TOKEN_LIFESPAN_FIELD_NUMBER: builtins.int
    AUTHORIZATION_CODE_GRANT_ID_TOKEN_LIFESPAN_FIELD_NUMBER: builtins.int
    AUTHORIZATION_CODE_GRANT_REFRESH_TOKEN_LIFESPAN_FIELD_NUMBER: builtins.int
    BACKCHANNEL_LOGOUT_SESSION_REQUIRED_FIELD_NUMBER: builtins.int
    BACKCHANNEL_LOGOUT_URI_FIELD_NUMBER: builtins.int
    CLIENT_CREDENTIALS_GRANT_ACCESS_TOKEN_LIFESPAN_FIELD_NUMBER: builtins.int
    CLIENT_ID_FIELD_NUMBER: builtins.int
    CLIENT_NAME_FIELD_NUMBER: builtins.int
    CLIENT_SECRET_FIELD_NUMBER: builtins.int
    CLIENT_SECRET_EXPIRES_AT_FIELD_NUMBER: builtins.int
    CLIENT_URI_FIELD_NUMBER: builtins.int
    CONTACTS_FIELD_NUMBER: builtins.int
    CREATED_AT_FIELD_NUMBER: builtins.int
    FRONTCHANNEL_LOGOUT_SESSION_REQUIRED_FIELD_NUMBER: builtins.int
    FRONTCHANNEL_LOGOUT_URI_FIELD_NUMBER: builtins.int
    GRANT_TYPES_FIELD_NUMBER: builtins.int
    IMPLICIT_GRANT_ACCESS_TOKEN_LIFESPAN_FIELD_NUMBER: builtins.int
    IMPLICIT_GRANT_ID_TOKEN_LIFESPAN_FIELD_NUMBER: builtins.int
    JWKS_FIELD_NUMBER: builtins.int
    JWKS_URI_FIELD_NUMBER: builtins.int
    JWT_BEARER_GRANT_ACCESS_TOKEN_LIFESPAN_FIELD_NUMBER: builtins.int
    LOGO_URI_FIELD_NUMBER: builtins.int
    OWNER_FIELD_NUMBER: builtins.int
    POLICY_URI_FIELD_NUMBER: builtins.int
    POST_LOGOUT_REDIRECT_URIS_FIELD_NUMBER: builtins.int
    REDIRECT_URIS_FIELD_NUMBER: builtins.int
    REFRESH_TOKEN_GRANT_ACCESS_TOKEN_LIFESPAN_FIELD_NUMBER: builtins.int
    REFRESH_TOKEN_GRANT_ID_TOKEN_LIFESPAN_FIELD_NUMBER: builtins.int
    REFRESH_TOKEN_GRANT_REFRESH_TOKEN_LIFESPAN_FIELD_NUMBER: builtins.int
    REGISTRATION_ACCESS_TOKEN_FIELD_NUMBER: builtins.int
    REGISTRATION_CLIENT_URI_FIELD_NUMBER: builtins.int
    REQUEST_OBJECT_SIGNING_ALG_FIELD_NUMBER: builtins.int
    REQUEST_URIS_FIELD_NUMBER: builtins.int
    RESPONSE_TYPES_FIELD_NUMBER: builtins.int
    SCOPE_FIELD_NUMBER: builtins.int
    SECTOR_IDENTIFIER_URI_FIELD_NUMBER: builtins.int
    SKIP_CONSENT_FIELD_NUMBER: builtins.int
    SKIP_LOGOUT_CONSENT_FIELD_NUMBER: builtins.int
    SUBJECT_TYPE_FIELD_NUMBER: builtins.int
    TOKEN_ENDPOINT_AUTH_METHOD_FIELD_NUMBER: builtins.int
    TOKEN_ENDPOINT_AUTH_SIGNING_ALG_FIELD_NUMBER: builtins.int
    TOS_URI_FIELD_NUMBER: builtins.int
    UPDATED_AT_FIELD_NUMBER: builtins.int
    USERINFO_SIGNED_RESPONSE_ALG_FIELD_NUMBER: builtins.int
    access_token_strategy: builtins.str
    authorization_code_grant_access_token_lifespan: builtins.str
    authorization_code_grant_id_token_lifespan: builtins.str
    authorization_code_grant_refresh_token_lifespan: builtins.str
    backchannel_logout_session_required: builtins.bool
    backchannel_logout_uri: builtins.str
    client_credentials_grant_access_token_lifespan: builtins.str
    client_id: builtins.str
    client_name: builtins.str
    client_secret: builtins.str
    client_secret_expires_at: builtins.int
    client_uri: builtins.str
    frontchannel_logout_session_required: builtins.bool
    frontchannel_logout_uri: builtins.str
    implicit_grant_access_token_lifespan: builtins.str
    implicit_grant_id_token_lifespan: builtins.str
    jwks_uri: builtins.str
    jwt_bearer_grant_access_token_lifespan: builtins.str
    logo_uri: builtins.str
    owner: builtins.str
    policy_uri: builtins.str
    refresh_token_grant_access_token_lifespan: builtins.str
    refresh_token_grant_id_token_lifespan: builtins.str
    refresh_token_grant_refresh_token_lifespan: builtins.str
    registration_access_token: builtins.str
    registration_client_uri: builtins.str
    request_object_signing_alg: builtins.str
    scope: builtins.str
    sector_identifier_uri: builtins.str
    skip_consent: builtins.bool
    skip_logout_consent: builtins.bool
    subject_type: builtins.str
    token_endpoint_auth_method: builtins.str
    token_endpoint_auth_signing_alg: builtins.str
    tos_uri: builtins.str
    userinfo_signed_response_alg: builtins.str
    @property
    def allowed_cors_origins(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]: ...
    @property
    def audience(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]: ...
    @property
    def contacts(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]: ...
    @property
    def created_at(self) -> google.protobuf.timestamp_pb2.Timestamp: ...
    @property
    def grant_types(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]: ...
    @property
    def jwks(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]: ...
    @property
    def post_logout_redirect_uris(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]: ...
    @property
    def redirect_uris(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]: ...
    @property
    def request_uris(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]: ...
    @property
    def response_types(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]: ...
    @property
    def updated_at(self) -> google.protobuf.timestamp_pb2.Timestamp: ...
    def __init__(
        self,
        *,
        access_token_strategy: builtins.str = ...,
        allowed_cors_origins: collections.abc.Iterable[builtins.str] | None = ...,
        audience: collections.abc.Iterable[builtins.str] | None = ...,
        authorization_code_grant_access_token_lifespan: builtins.str = ...,
        authorization_code_grant_id_token_lifespan: builtins.str = ...,
        authorization_code_grant_refresh_token_lifespan: builtins.str = ...,
        backchannel_logout_session_required: builtins.bool = ...,
        backchannel_logout_uri: builtins.str = ...,
        client_credentials_grant_access_token_lifespan: builtins.str = ...,
        client_id: builtins.str = ...,
        client_name: builtins.str = ...,
        client_secret: builtins.str = ...,
        client_secret_expires_at: builtins.int = ...,
        client_uri: builtins.str = ...,
        contacts: collections.abc.Iterable[builtins.str] | None = ...,
        created_at: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        frontchannel_logout_session_required: builtins.bool = ...,
        frontchannel_logout_uri: builtins.str = ...,
        grant_types: collections.abc.Iterable[builtins.str] | None = ...,
        implicit_grant_access_token_lifespan: builtins.str = ...,
        implicit_grant_id_token_lifespan: builtins.str = ...,
        jwks: collections.abc.Iterable[builtins.str] | None = ...,
        jwks_uri: builtins.str = ...,
        jwt_bearer_grant_access_token_lifespan: builtins.str = ...,
        logo_uri: builtins.str = ...,
        owner: builtins.str = ...,
        policy_uri: builtins.str = ...,
        post_logout_redirect_uris: collections.abc.Iterable[builtins.str] | None = ...,
        redirect_uris: collections.abc.Iterable[builtins.str] | None = ...,
        refresh_token_grant_access_token_lifespan: builtins.str = ...,
        refresh_token_grant_id_token_lifespan: builtins.str = ...,
        refresh_token_grant_refresh_token_lifespan: builtins.str = ...,
        registration_access_token: builtins.str = ...,
        registration_client_uri: builtins.str = ...,
        request_object_signing_alg: builtins.str = ...,
        request_uris: collections.abc.Iterable[builtins.str] | None = ...,
        response_types: collections.abc.Iterable[builtins.str] | None = ...,
        scope: builtins.str = ...,
        sector_identifier_uri: builtins.str = ...,
        skip_consent: builtins.bool = ...,
        skip_logout_consent: builtins.bool = ...,
        subject_type: builtins.str = ...,
        token_endpoint_auth_method: builtins.str = ...,
        token_endpoint_auth_signing_alg: builtins.str = ...,
        tos_uri: builtins.str = ...,
        updated_at: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        userinfo_signed_response_alg: builtins.str = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["created_at", b"created_at", "updated_at", b"updated_at"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["access_token_strategy", b"access_token_strategy", "allowed_cors_origins", b"allowed_cors_origins", "audience", b"audience", "authorization_code_grant_access_token_lifespan", b"authorization_code_grant_access_token_lifespan", "authorization_code_grant_id_token_lifespan", b"authorization_code_grant_id_token_lifespan", "authorization_code_grant_refresh_token_lifespan", b"authorization_code_grant_refresh_token_lifespan", "backchannel_logout_session_required", b"backchannel_logout_session_required", "backchannel_logout_uri", b"backchannel_logout_uri", "client_credentials_grant_access_token_lifespan", b"client_credentials_grant_access_token_lifespan", "client_id", b"client_id", "client_name", b"client_name", "client_secret", b"client_secret", "client_secret_expires_at", b"client_secret_expires_at", "client_uri", b"client_uri", "contacts", b"contacts", "created_at", b"created_at", "frontchannel_logout_session_required", b"frontchannel_logout_session_required", "frontchannel_logout_uri", b"frontchannel_logout_uri", "grant_types", b"grant_types", "implicit_grant_access_token_lifespan", b"implicit_grant_access_token_lifespan", "implicit_grant_id_token_lifespan", b"implicit_grant_id_token_lifespan", "jwks", b"jwks", "jwks_uri", b"jwks_uri", "jwt_bearer_grant_access_token_lifespan", b"jwt_bearer_grant_access_token_lifespan", "logo_uri", b"logo_uri", "owner", b"owner", "policy_uri", b"policy_uri", "post_logout_redirect_uris", b"post_logout_redirect_uris", "redirect_uris", b"redirect_uris", "refresh_token_grant_access_token_lifespan", b"refresh_token_grant_access_token_lifespan", "refresh_token_grant_id_token_lifespan", b"refresh_token_grant_id_token_lifespan", "refresh_token_grant_refresh_token_lifespan", b"refresh_token_grant_refresh_token_lifespan", "registration_access_token", b"registration_access_token", "registration_client_uri", b"registration_client_uri", "request_object_signing_alg", b"request_object_signing_alg", "request_uris", b"request_uris", "response_types", b"response_types", "scope", b"scope", "sector_identifier_uri", b"sector_identifier_uri", "skip_consent", b"skip_consent", "skip_logout_consent", b"skip_logout_consent", "subject_type", b"subject_type", "token_endpoint_auth_method", b"token_endpoint_auth_method", "token_endpoint_auth_signing_alg", b"token_endpoint_auth_signing_alg", "tos_uri", b"tos_uri", "updated_at", b"updated_at", "userinfo_signed_response_alg", b"userinfo_signed_response_alg"]) -> None: ...

global___MezonOauthClient = MezonOauthClient

@typing.final
class MezonOauthClientList(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    LIST_MEZON_OAUTH_CLIENT_FIELD_NUMBER: builtins.int
    @property
    def list_mezon_oauth_client(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___MezonOauthClient]: ...
    def __init__(
        self,
        *,
        list_mezon_oauth_client: collections.abc.Iterable[global___MezonOauthClient] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["list_mezon_oauth_client", b"list_mezon_oauth_client"]) -> None: ...

global___MezonOauthClientList = MezonOauthClientList

@typing.final
class GetMezonOauthClientRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CLIENT_ID_FIELD_NUMBER: builtins.int
    CLIENT_NAME_FIELD_NUMBER: builtins.int
    client_id: builtins.str
    client_name: builtins.str
    def __init__(
        self,
        *,
        client_id: builtins.str = ...,
        client_name: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["client_id", b"client_id", "client_name", b"client_name"]) -> None: ...

global___GetMezonOauthClientRequest = GetMezonOauthClientRequest

@typing.final
class SearchThreadRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CLAN_ID_FIELD_NUMBER: builtins.int
    CHANNEL_ID_FIELD_NUMBER: builtins.int
    LABEL_FIELD_NUMBER: builtins.int
    clan_id: builtins.str
    channel_id: builtins.str
    label: builtins.str
    def __init__(
        self,
        *,
        clan_id: builtins.str = ...,
        channel_id: builtins.str = ...,
        label: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["channel_id", b"channel_id", "clan_id", b"clan_id", "label", b"label"]) -> None: ...

global___SearchThreadRequest = SearchThreadRequest

@typing.final
class GenerateHashChannelAppsRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    APP_ID_FIELD_NUMBER: builtins.int
    app_id: builtins.str
    def __init__(
        self,
        *,
        app_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["app_id", b"app_id"]) -> None: ...

global___GenerateHashChannelAppsRequest = GenerateHashChannelAppsRequest

@typing.final
class GenerateHashChannelAppsResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    WEB_APP_DATA_FIELD_NUMBER: builtins.int
    web_app_data: builtins.str
    def __init__(
        self,
        *,
        web_app_data: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["web_app_data", b"web_app_data"]) -> None: ...

global___GenerateHashChannelAppsResponse = GenerateHashChannelAppsResponse

@typing.final
class Message2InboxRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    MESSAGE_ID_FIELD_NUMBER: builtins.int
    CHANNEL_ID_FIELD_NUMBER: builtins.int
    CLAN_ID_FIELD_NUMBER: builtins.int
    AVATAR_FIELD_NUMBER: builtins.int
    CONTENT_FIELD_NUMBER: builtins.int
    MENTIONS_FIELD_NUMBER: builtins.int
    ATTACHMENTS_FIELD_NUMBER: builtins.int
    REACTIONS_FIELD_NUMBER: builtins.int
    REFERENCES_FIELD_NUMBER: builtins.int
    message_id: builtins.str
    channel_id: builtins.str
    clan_id: builtins.str
    avatar: builtins.str
    content: builtins.str
    mentions: builtins.str
    attachments: builtins.str
    reactions: builtins.str
    references: builtins.str
    def __init__(
        self,
        *,
        message_id: builtins.str = ...,
        channel_id: builtins.str = ...,
        clan_id: builtins.str = ...,
        avatar: builtins.str = ...,
        content: builtins.str = ...,
        mentions: builtins.str = ...,
        attachments: builtins.str = ...,
        reactions: builtins.str = ...,
        references: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["attachments", b"attachments", "avatar", b"avatar", "channel_id", b"channel_id", "clan_id", b"clan_id", "content", b"content", "mentions", b"mentions", "message_id", b"message_id", "reactions", b"reactions", "references", b"references"]) -> None: ...

global___Message2InboxRequest = Message2InboxRequest

@typing.final
class AccountEmail(google.protobuf.message.Message):
    """Send an email with password to the server. Used with authenticate/link/unlink."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    @typing.final
    class VarsEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.str
        value: builtins.str
        def __init__(
            self,
            *,
            key: builtins.str = ...,
            value: builtins.str = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing.Literal["key", b"key", "value", b"value"]) -> None: ...

    EMAIL_FIELD_NUMBER: builtins.int
    PASSWORD_FIELD_NUMBER: builtins.int
    PREV_EMAIL_FIELD_NUMBER: builtins.int
    VARS_FIELD_NUMBER: builtins.int
    email: builtins.str
    """A valid RFC-5322 email address."""
    password: builtins.str
    """A password for the user account.
    Ignored with unlink operations.
    """
    prev_email: builtins.str
    """Prev email"""
    @property
    def vars(self) -> google.protobuf.internal.containers.ScalarMap[builtins.str, builtins.str]:
        """Extra information that will be bundled in the session token."""

    def __init__(
        self,
        *,
        email: builtins.str = ...,
        password: builtins.str = ...,
        prev_email: builtins.str = ...,
        vars: collections.abc.Mapping[builtins.str, builtins.str] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["email", b"email", "password", b"password", "prev_email", b"prev_email", "vars", b"vars"]) -> None: ...

global___AccountEmail = AccountEmail

@typing.final
class AccountMezon(google.protobuf.message.Message):
    """Send a Mezon token to the server. Used with authenticate/link/unlink."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    @typing.final
    class VarsEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.str
        value: builtins.str
        def __init__(
            self,
            *,
            key: builtins.str = ...,
            value: builtins.str = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing.Literal["key", b"key", "value", b"value"]) -> None: ...

    PHONE_NUMBER_FIELD_NUMBER: builtins.int
    VARS_FIELD_NUMBER: builtins.int
    phone_number: builtins.str
    """The phone number."""
    @property
    def vars(self) -> google.protobuf.internal.containers.ScalarMap[builtins.str, builtins.str]:
        """Extra information that will be bundled in the session token."""

    def __init__(
        self,
        *,
        phone_number: builtins.str = ...,
        vars: collections.abc.Mapping[builtins.str, builtins.str] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["phone_number", b"phone_number", "vars", b"vars"]) -> None: ...

global___AccountMezon = AccountMezon

@typing.final
class LinkAccountConfirmRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    REQ_ID_FIELD_NUMBER: builtins.int
    STATUS_FIELD_NUMBER: builtins.int
    OTP_CODE_FIELD_NUMBER: builtins.int
    req_id: builtins.str
    """The request id"""
    status: builtins.int
    """Status"""
    otp_code: builtins.str
    """The confirm code"""
    def __init__(
        self,
        *,
        req_id: builtins.str = ...,
        status: builtins.int = ...,
        otp_code: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["otp_code", b"otp_code", "req_id", b"req_id", "status", b"status"]) -> None: ...

global___LinkAccountConfirmRequest = LinkAccountConfirmRequest

@typing.final
class QuickMenuAccess(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ID_FIELD_NUMBER: builtins.int
    BOT_ID_FIELD_NUMBER: builtins.int
    CLAN_ID_FIELD_NUMBER: builtins.int
    CHANNEL_ID_FIELD_NUMBER: builtins.int
    MENU_NAME_FIELD_NUMBER: builtins.int
    BACKGROUND_FIELD_NUMBER: builtins.int
    ACTION_MSG_FIELD_NUMBER: builtins.int
    MENU_TYPE_FIELD_NUMBER: builtins.int
    id: builtins.str
    bot_id: builtins.str
    clan_id: builtins.str
    channel_id: builtins.str
    menu_name: builtins.str
    background: builtins.str
    action_msg: builtins.str
    menu_type: builtins.int
    def __init__(
        self,
        *,
        id: builtins.str = ...,
        bot_id: builtins.str = ...,
        clan_id: builtins.str = ...,
        channel_id: builtins.str = ...,
        menu_name: builtins.str = ...,
        background: builtins.str = ...,
        action_msg: builtins.str = ...,
        menu_type: builtins.int = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["action_msg", b"action_msg", "background", b"background", "bot_id", b"bot_id", "channel_id", b"channel_id", "clan_id", b"clan_id", "id", b"id", "menu_name", b"menu_name", "menu_type", b"menu_type"]) -> None: ...

global___QuickMenuAccess = QuickMenuAccess

@typing.final
class ListQuickMenuAccessRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    BOT_ID_FIELD_NUMBER: builtins.int
    CHANNEL_ID_FIELD_NUMBER: builtins.int
    MENU_TYPE_FIELD_NUMBER: builtins.int
    bot_id: builtins.str
    channel_id: builtins.str
    menu_type: builtins.int
    def __init__(
        self,
        *,
        bot_id: builtins.str = ...,
        channel_id: builtins.str = ...,
        menu_type: builtins.int = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["bot_id", b"bot_id", "channel_id", b"channel_id", "menu_type", b"menu_type"]) -> None: ...

global___ListQuickMenuAccessRequest = ListQuickMenuAccessRequest

@typing.final
class QuickMenuAccessList(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    LIST_MENUS_FIELD_NUMBER: builtins.int
    @property
    def list_menus(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___QuickMenuAccess]: ...
    def __init__(
        self,
        *,
        list_menus: collections.abc.Iterable[global___QuickMenuAccess] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["list_menus", b"list_menus"]) -> None: ...

global___QuickMenuAccessList = QuickMenuAccessList

@typing.final
class ListForSaleItemsRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    PAGE_FIELD_NUMBER: builtins.int
    page: builtins.int
    def __init__(
        self,
        *,
        page: builtins.int = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["page", b"page"]) -> None: ...

global___ListForSaleItemsRequest = ListForSaleItemsRequest

@typing.final
class ForSaleItem(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    TYPE_FIELD_NUMBER: builtins.int
    PREVIEW_URL_FIELD_NUMBER: builtins.int
    type: builtins.int
    preview_url: builtins.str
    def __init__(
        self,
        *,
        type: builtins.int = ...,
        preview_url: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["preview_url", b"preview_url", "type", b"type"]) -> None: ...

global___ForSaleItem = ForSaleItem

@typing.final
class ForSaleItemList(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    FOR_SALE_ITEMS_FIELD_NUMBER: builtins.int
    @property
    def for_sale_items(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___ForSaleItem]: ...
    def __init__(
        self,
        *,
        for_sale_items: collections.abc.Iterable[global___ForSaleItem] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["for_sale_items", b"for_sale_items"]) -> None: ...

global___ForSaleItemList = ForSaleItemList

@typing.final
class IsFollowerRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    FOLLOW_ID_FIELD_NUMBER: builtins.int
    follow_id: builtins.str
    def __init__(
        self,
        *,
        follow_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["follow_id", b"follow_id"]) -> None: ...

global___IsFollowerRequest = IsFollowerRequest

@typing.final
class IsFollowerResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    FOLLOW_ID_FIELD_NUMBER: builtins.int
    IS_FOLLOWER_FIELD_NUMBER: builtins.int
    follow_id: builtins.str
    is_follower: builtins.bool
    def __init__(
        self,
        *,
        follow_id: builtins.str = ...,
        is_follower: builtins.bool = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["follow_id", b"follow_id", "is_follower", b"is_follower"]) -> None: ...

global___IsFollowerResponse = IsFollowerResponse

@typing.final
class TransferOwnershipRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CLAN_ID_FIELD_NUMBER: builtins.int
    NEW_OWNER_ID_FIELD_NUMBER: builtins.int
    clan_id: builtins.str
    new_owner_id: builtins.str
    def __init__(
        self,
        *,
        clan_id: builtins.str = ...,
        new_owner_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["clan_id", b"clan_id", "new_owner_id", b"new_owner_id"]) -> None: ...

global___TransferOwnershipRequest = TransferOwnershipRequest
