"""
@generated by mypy-protobuf.  Do not edit manually!
isort:skip_file
Copyright 2019 The Mezon Authors

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.

*
The realtime protocol for Mezon server.
"""

import api.api_pb2
import builtins
import collections.abc
import google.protobuf.descriptor
import google.protobuf.internal.containers
import google.protobuf.internal.enum_type_wrapper
import google.protobuf.message
import google.protobuf.timestamp_pb2
import google.protobuf.wrappers_pb2
import sys
import typing

if sys.version_info >= (3, 10):
    import typing as typing_extensions
else:
    import typing_extensions

DESCRIPTOR: google.protobuf.descriptor.FileDescriptor

@typing.final
class Envelope(google.protobuf.message.Message):
    """An envelope for a realtime message."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CID_FIELD_NUMBER: builtins.int
    CHANNEL_FIELD_NUMBER: builtins.int
    CLAN_JOIN_FIELD_NUMBER: builtins.int
    CHANNEL_JOIN_FIELD_NUMBER: builtins.int
    CHANNEL_LEAVE_FIELD_NUMBER: builtins.int
    CHANNEL_MESSAGE_FIELD_NUMBER: builtins.int
    CHANNEL_MESSAGE_ACK_FIELD_NUMBER: builtins.int
    CHANNEL_MESSAGE_SEND_FIELD_NUMBER: builtins.int
    CHANNEL_MESSAGE_UPDATE_FIELD_NUMBER: builtins.int
    CHANNEL_MESSAGE_REMOVE_FIELD_NUMBER: builtins.int
    CHANNEL_PRESENCE_EVENT_FIELD_NUMBER: builtins.int
    ERROR_FIELD_NUMBER: builtins.int
    NOTIFICATIONS_FIELD_NUMBER: builtins.int
    RPC_FIELD_NUMBER: builtins.int
    STATUS_FIELD_NUMBER: builtins.int
    STATUS_FOLLOW_FIELD_NUMBER: builtins.int
    STATUS_PRESENCE_EVENT_FIELD_NUMBER: builtins.int
    STATUS_UNFOLLOW_FIELD_NUMBER: builtins.int
    STATUS_UPDATE_FIELD_NUMBER: builtins.int
    STREAM_DATA_FIELD_NUMBER: builtins.int
    STREAM_PRESENCE_EVENT_FIELD_NUMBER: builtins.int
    PING_FIELD_NUMBER: builtins.int
    PONG_FIELD_NUMBER: builtins.int
    MESSAGE_TYPING_EVENT_FIELD_NUMBER: builtins.int
    LAST_SEEN_MESSAGE_EVENT_FIELD_NUMBER: builtins.int
    MESSAGE_REACTION_EVENT_FIELD_NUMBER: builtins.int
    VOICE_JOINED_EVENT_FIELD_NUMBER: builtins.int
    VOICE_LEAVED_EVENT_FIELD_NUMBER: builtins.int
    VOICE_STARTED_EVENT_FIELD_NUMBER: builtins.int
    VOICE_ENDED_EVENT_FIELD_NUMBER: builtins.int
    CHANNEL_CREATED_EVENT_FIELD_NUMBER: builtins.int
    CHANNEL_DELETED_EVENT_FIELD_NUMBER: builtins.int
    CHANNEL_UPDATED_EVENT_FIELD_NUMBER: builtins.int
    LAST_PIN_MESSAGE_EVENT_FIELD_NUMBER: builtins.int
    CUSTOM_STATUS_EVENT_FIELD_NUMBER: builtins.int
    USER_CHANNEL_ADDED_EVENT_FIELD_NUMBER: builtins.int
    USER_CHANNEL_REMOVED_EVENT_FIELD_NUMBER: builtins.int
    USER_CLAN_REMOVED_EVENT_FIELD_NUMBER: builtins.int
    CLAN_UPDATED_EVENT_FIELD_NUMBER: builtins.int
    CLAN_PROFILE_UPDATED_EVENT_FIELD_NUMBER: builtins.int
    CHECK_NAME_EXISTED_EVENT_FIELD_NUMBER: builtins.int
    USER_PROFILE_UPDATED_EVENT_FIELD_NUMBER: builtins.int
    ADD_CLAN_USER_EVENT_FIELD_NUMBER: builtins.int
    CLAN_EVENT_CREATED_FIELD_NUMBER: builtins.int
    ROLE_ASSIGN_EVENT_FIELD_NUMBER: builtins.int
    CLAN_DELETED_EVENT_FIELD_NUMBER: builtins.int
    GIVE_COFFEE_EVENT_FIELD_NUMBER: builtins.int
    STICKER_CREATE_EVENT_FIELD_NUMBER: builtins.int
    STICKER_UPDATE_EVENT_FIELD_NUMBER: builtins.int
    STICKER_DELETE_EVENT_FIELD_NUMBER: builtins.int
    ROLE_EVENT_FIELD_NUMBER: builtins.int
    EVENT_EMOJI_FIELD_NUMBER: builtins.int
    STREAMING_JOINED_EVENT_FIELD_NUMBER: builtins.int
    STREAMING_LEAVED_EVENT_FIELD_NUMBER: builtins.int
    STREAMING_STARTED_EVENT_FIELD_NUMBER: builtins.int
    STREAMING_ENDED_EVENT_FIELD_NUMBER: builtins.int
    PERMISSION_SET_EVENT_FIELD_NUMBER: builtins.int
    PERMISSION_CHANGED_EVENT_FIELD_NUMBER: builtins.int
    TOKEN_SENT_EVENT_FIELD_NUMBER: builtins.int
    MESSAGE_BUTTON_CLICKED_FIELD_NUMBER: builtins.int
    UNMUTE_EVENT_FIELD_NUMBER: builtins.int
    WEBRTC_SIGNALING_FWD_FIELD_NUMBER: builtins.int
    LIST_ACTIVITY_FIELD_NUMBER: builtins.int
    DROPDOWN_BOX_SELECTED_FIELD_NUMBER: builtins.int
    INCOMING_CALL_PUSH_FIELD_NUMBER: builtins.int
    SD_TOPIC_EVENT_FIELD_NUMBER: builtins.int
    FOLLOW_EVENT_FIELD_NUMBER: builtins.int
    CHANNEL_APP_EVENT_FIELD_NUMBER: builtins.int
    USER_STATUS_EVENT_FIELD_NUMBER: builtins.int
    REMOVE_FRIEND_FIELD_NUMBER: builtins.int
    WEBHOOK_EVENT_FIELD_NUMBER: builtins.int
    NOTI_USER_CHANNEL_FIELD_NUMBER: builtins.int
    JOIN_CHANNEL_APP_DATA_FIELD_NUMBER: builtins.int
    CANVAS_EVENT_FIELD_NUMBER: builtins.int
    UNPIN_MESSAGE_EVENT_FIELD_NUMBER: builtins.int
    CATEGORY_EVENT_FIELD_NUMBER: builtins.int
    HANDLE_PARTICIPANT_MEET_STATE_EVENT_FIELD_NUMBER: builtins.int
    DELETE_ACCOUNT_EVENT_FIELD_NUMBER: builtins.int
    EPHEMERAL_MESSAGE_SEND_FIELD_NUMBER: builtins.int
    BLOCK_FRIEND_FIELD_NUMBER: builtins.int
    VOICE_REACTION_SEND_FIELD_NUMBER: builtins.int
    MARK_AS_READ_FIELD_NUMBER: builtins.int
    LIST_DATA_SOCKET_FIELD_NUMBER: builtins.int
    QUICK_MENU_EVENT_FIELD_NUMBER: builtins.int
    UN_BLOCK_FRIEND_FIELD_NUMBER: builtins.int
    MEET_PARTICIPANT_EVENT_FIELD_NUMBER: builtins.int
    TRANSFER_OWNERSHIP_EVENT_FIELD_NUMBER: builtins.int
    ADD_FRIEND_FIELD_NUMBER: builtins.int
    BAN_USER_EVENT_FIELD_NUMBER: builtins.int
    cid: builtins.str
    @property
    def channel(self) -> global___Channel:
        """A response from a channel join operation."""

    @property
    def clan_join(self) -> global___ClanJoin:
        """Join a realtime chat clan"""

    @property
    def channel_join(self) -> global___ChannelJoin:
        """Join a realtime chat channel."""

    @property
    def channel_leave(self) -> global___ChannelLeave:
        """Leave a realtime chat channel."""

    @property
    def channel_message(self) -> api.api_pb2.ChannelMessage:
        """An incoming message on a realtime chat channel."""

    @property
    def channel_message_ack(self) -> global___ChannelMessageAck:
        """An acknowledgement received in response to sending a message on a chat channel."""

    @property
    def channel_message_send(self) -> global___ChannelMessageSend:
        """Send a message to a realtime chat channel."""

    @property
    def channel_message_update(self) -> global___ChannelMessageUpdate:
        """Update a message previously sent to a realtime chat channel."""

    @property
    def channel_message_remove(self) -> global___ChannelMessageRemove:
        """Remove a message previously sent to a realtime chat channel."""

    @property
    def channel_presence_event(self) -> global___ChannelPresenceEvent:
        """Presence update for a particular realtime chat channel."""

    @property
    def error(self) -> global___Error:
        """Describes an error which occurred on the server."""

    @property
    def notifications(self) -> global___Notifications:
        """Notifications send by the server."""

    @property
    def rpc(self) -> api.api_pb2.Rpc:
        """RPC call or response."""

    @property
    def status(self) -> global___Status:
        """An incoming status snapshot for some set of users."""

    @property
    def status_follow(self) -> global___StatusFollow:
        """Start following some set of users to receive their status updates."""

    @property
    def status_presence_event(self) -> global___StatusPresenceEvent:
        """An incoming status update."""

    @property
    def status_unfollow(self) -> global___StatusUnfollow:
        """Stop following some set of users to no longer receive their status updates."""

    @property
    def status_update(self) -> global___StatusUpdate:
        """Set the user's own status."""

    @property
    def stream_data(self) -> global___StreamData:
        """A data message delivered over a stream."""

    @property
    def stream_presence_event(self) -> global___StreamPresenceEvent:
        """Presence update for a particular stream."""

    @property
    def ping(self) -> global___Ping:
        """Application-level heartbeat and connection check."""

    @property
    def pong(self) -> global___Pong:
        """Application-level heartbeat and connection check response."""

    @property
    def message_typing_event(self) -> global___MessageTypingEvent:
        """User typing event"""

    @property
    def last_seen_message_event(self) -> global___LastSeenMessageEvent:
        """Last seen message event"""

    @property
    def message_reaction_event(self) -> api.api_pb2.MessageReaction:
        """User send reactoin event"""

    @property
    def voice_joined_event(self) -> global___VoiceJoinedEvent:
        """user join voice channel"""

    @property
    def voice_leaved_event(self) -> global___VoiceLeavedEvent:
        """user leave voice channel"""

    @property
    def voice_started_event(self) -> global___VoiceStartedEvent:
        """voice channel start"""

    @property
    def voice_ended_event(self) -> global___VoiceEndedEvent:
        """voice channel end"""

    @property
    def channel_created_event(self) -> global___ChannelCreatedEvent:
        """channel created event"""

    @property
    def channel_deleted_event(self) -> global___ChannelDeletedEvent:
        """channel deleted event"""

    @property
    def channel_updated_event(self) -> global___ChannelUpdatedEvent:
        """channel deleted event"""

    @property
    def last_pin_message_event(self) -> global___LastPinMessageEvent:
        """Last pin message event"""

    @property
    def custom_status_event(self) -> global___CustomStatusEvent:
        """Update custom status"""

    @property
    def user_channel_added_event(self) -> global___UserChannelAdded:
        """User is added to channel event"""

    @property
    def user_channel_removed_event(self) -> global___UserChannelRemoved:
        """User is removed to channel event"""

    @property
    def user_clan_removed_event(self) -> global___UserClanRemoved:
        """User is removed to clan event"""

    @property
    def clan_updated_event(self) -> global___ClanUpdatedEvent:
        """Clan updated event"""

    @property
    def clan_profile_updated_event(self) -> global___ClanProfileUpdatedEvent:
        """Clan profile updated event"""

    @property
    def check_name_existed_event(self) -> global___CheckNameExistedEvent:
        """Check duplicate clan name event"""

    @property
    def user_profile_updated_event(self) -> global___UserProfileUpdatedEvent:
        """User profile update event"""

    @property
    def add_clan_user_event(self) -> global___AddClanUserEvent:
        """user join clan"""

    @property
    def clan_event_created(self) -> api.api_pb2.CreateEventRequest:
        """clan event created"""

    @property
    def role_assign_event(self) -> global___RoleAssignedEvent:
        """role assigned event"""

    @property
    def clan_deleted_event(self) -> global___ClanDeletedEvent:
        """clan deleted event"""

    @property
    def give_coffee_event(self) -> api.api_pb2.GiveCoffeeEvent:
        """Give a coffe event"""

    @property
    def sticker_create_event(self) -> global___StickerCreateEvent:
        """sticker created event"""

    @property
    def sticker_update_event(self) -> global___StickerUpdateEvent:
        """sticker updated event"""

    @property
    def sticker_delete_event(self) -> global___StickerDeleteEvent:
        """sticker deleted event"""

    @property
    def role_event(self) -> global___RoleEvent:
        """role created event"""

    @property
    def event_emoji(self) -> global___EventEmoji:
        """Event emoji"""

    @property
    def streaming_joined_event(self) -> global___StreamingJoinedEvent:
        """user join streaming channel"""

    @property
    def streaming_leaved_event(self) -> global___StreamingLeavedEvent:
        """user leave streaming channel"""

    @property
    def streaming_started_event(self) -> global___StreamingStartedEvent:
        """streaming channel start"""

    @property
    def streaming_ended_event(self) -> global___StreamingEndedEvent:
        """streaming channel end"""

    @property
    def permission_set_event(self) -> global___PermissionSetEvent:
        """set permission of role/user in channel"""

    @property
    def permission_changed_event(self) -> global___PermissionChangedEvent:
        """permission changed event"""

    @property
    def token_sent_event(self) -> api.api_pb2.TokenSentEvent:
        """token is sent event"""

    @property
    def message_button_clicked(self) -> global___MessageButtonClicked: ...
    @property
    def unmute_event(self) -> global___UnmuteEvent:
        """unmute channel event"""

    @property
    def webrtc_signaling_fwd(self) -> global___WebrtcSignalingFwd:
        """voice call"""

    @property
    def list_activity(self) -> global___ListActivity:
        """List activity event for each user"""

    @property
    def dropdown_box_selected(self) -> global___DropdownBoxSelected:
        """dropdown box selected"""

    @property
    def incoming_call_push(self) -> global___IncomingCallPush:
        """IncomingCallPush"""

    @property
    def sd_topic_event(self) -> global___SdTopicEvent:
        """Sd topic event"""

    @property
    def follow_event(self) -> global___FollowEvent:
        """follower list"""

    @property
    def channel_app_event(self) -> global___ChannelAppEvent:
        """channel app event"""

    @property
    def user_status_event(self) -> global___UserStatusEvent:
        """User custom status event"""

    @property
    def remove_friend(self) -> global___RemoveFriend:
        """"""

    @property
    def webhook_event(self) -> api.api_pb2.Webhook:
        """"""

    @property
    def noti_user_channel(self) -> api.api_pb2.NotificationUserChannel:
        """"""

    @property
    def join_channel_app_data(self) -> global___JoinChannelAppData:
        """"""

    @property
    def canvas_event(self) -> global___ChannelCanvas:
        """channel canvas"""

    @property
    def unpin_message_event(self) -> global___UnpinMessageEvent:
        """unpin message"""

    @property
    def category_event(self) -> global___CategoryEvent:
        """category event"""

    @property
    def handle_participant_meet_state_event(self) -> global___HandleParticipantMeetStateEvent:
        """handle join/leave channel voice"""

    @property
    def delete_account_event(self) -> global___DeleteAccountEvent:
        """delete acc"""

    @property
    def ephemeral_message_send(self) -> global___EphemeralMessageSend:
        """ephemeral message send"""

    @property
    def block_friend(self) -> global___BlockFriend:
        """block friend"""

    @property
    def voice_reaction_send(self) -> global___VoiceReactionSend:
        """voice reaction message"""

    @property
    def mark_as_read(self) -> global___MarkAsRead:
        """Mark As Read"""

    @property
    def list_data_socket(self) -> global___ListDataSocket:
        """list socket data"""

    @property
    def quick_menu_event(self) -> global___QuickMenuDataEvent:
        """quick menu event"""

    @property
    def un_block_friend(self) -> global___UnblockFriend:
        """unblock friend"""

    @property
    def meet_participant_event(self) -> global___MeetParticipantEvent:
        """mezon meet participant event"""

    @property
    def transfer_ownership_event(self) -> global___TransferOwnershipEvent:
        """tranfer ownership event"""

    @property
    def add_friend(self) -> global___AddFriend:
        """Add friend event"""

    @property
    def ban_user_event(self) -> global___BannedUserEvent:
        """Ban channel user"""

    def __init__(
        self,
        *,
        cid: builtins.str = ...,
        channel: global___Channel | None = ...,
        clan_join: global___ClanJoin | None = ...,
        channel_join: global___ChannelJoin | None = ...,
        channel_leave: global___ChannelLeave | None = ...,
        channel_message: api.api_pb2.ChannelMessage | None = ...,
        channel_message_ack: global___ChannelMessageAck | None = ...,
        channel_message_send: global___ChannelMessageSend | None = ...,
        channel_message_update: global___ChannelMessageUpdate | None = ...,
        channel_message_remove: global___ChannelMessageRemove | None = ...,
        channel_presence_event: global___ChannelPresenceEvent | None = ...,
        error: global___Error | None = ...,
        notifications: global___Notifications | None = ...,
        rpc: api.api_pb2.Rpc | None = ...,
        status: global___Status | None = ...,
        status_follow: global___StatusFollow | None = ...,
        status_presence_event: global___StatusPresenceEvent | None = ...,
        status_unfollow: global___StatusUnfollow | None = ...,
        status_update: global___StatusUpdate | None = ...,
        stream_data: global___StreamData | None = ...,
        stream_presence_event: global___StreamPresenceEvent | None = ...,
        ping: global___Ping | None = ...,
        pong: global___Pong | None = ...,
        message_typing_event: global___MessageTypingEvent | None = ...,
        last_seen_message_event: global___LastSeenMessageEvent | None = ...,
        message_reaction_event: api.api_pb2.MessageReaction | None = ...,
        voice_joined_event: global___VoiceJoinedEvent | None = ...,
        voice_leaved_event: global___VoiceLeavedEvent | None = ...,
        voice_started_event: global___VoiceStartedEvent | None = ...,
        voice_ended_event: global___VoiceEndedEvent | None = ...,
        channel_created_event: global___ChannelCreatedEvent | None = ...,
        channel_deleted_event: global___ChannelDeletedEvent | None = ...,
        channel_updated_event: global___ChannelUpdatedEvent | None = ...,
        last_pin_message_event: global___LastPinMessageEvent | None = ...,
        custom_status_event: global___CustomStatusEvent | None = ...,
        user_channel_added_event: global___UserChannelAdded | None = ...,
        user_channel_removed_event: global___UserChannelRemoved | None = ...,
        user_clan_removed_event: global___UserClanRemoved | None = ...,
        clan_updated_event: global___ClanUpdatedEvent | None = ...,
        clan_profile_updated_event: global___ClanProfileUpdatedEvent | None = ...,
        check_name_existed_event: global___CheckNameExistedEvent | None = ...,
        user_profile_updated_event: global___UserProfileUpdatedEvent | None = ...,
        add_clan_user_event: global___AddClanUserEvent | None = ...,
        clan_event_created: api.api_pb2.CreateEventRequest | None = ...,
        role_assign_event: global___RoleAssignedEvent | None = ...,
        clan_deleted_event: global___ClanDeletedEvent | None = ...,
        give_coffee_event: api.api_pb2.GiveCoffeeEvent | None = ...,
        sticker_create_event: global___StickerCreateEvent | None = ...,
        sticker_update_event: global___StickerUpdateEvent | None = ...,
        sticker_delete_event: global___StickerDeleteEvent | None = ...,
        role_event: global___RoleEvent | None = ...,
        event_emoji: global___EventEmoji | None = ...,
        streaming_joined_event: global___StreamingJoinedEvent | None = ...,
        streaming_leaved_event: global___StreamingLeavedEvent | None = ...,
        streaming_started_event: global___StreamingStartedEvent | None = ...,
        streaming_ended_event: global___StreamingEndedEvent | None = ...,
        permission_set_event: global___PermissionSetEvent | None = ...,
        permission_changed_event: global___PermissionChangedEvent | None = ...,
        token_sent_event: api.api_pb2.TokenSentEvent | None = ...,
        message_button_clicked: global___MessageButtonClicked | None = ...,
        unmute_event: global___UnmuteEvent | None = ...,
        webrtc_signaling_fwd: global___WebrtcSignalingFwd | None = ...,
        list_activity: global___ListActivity | None = ...,
        dropdown_box_selected: global___DropdownBoxSelected | None = ...,
        incoming_call_push: global___IncomingCallPush | None = ...,
        sd_topic_event: global___SdTopicEvent | None = ...,
        follow_event: global___FollowEvent | None = ...,
        channel_app_event: global___ChannelAppEvent | None = ...,
        user_status_event: global___UserStatusEvent | None = ...,
        remove_friend: global___RemoveFriend | None = ...,
        webhook_event: api.api_pb2.Webhook | None = ...,
        noti_user_channel: api.api_pb2.NotificationUserChannel | None = ...,
        join_channel_app_data: global___JoinChannelAppData | None = ...,
        canvas_event: global___ChannelCanvas | None = ...,
        unpin_message_event: global___UnpinMessageEvent | None = ...,
        category_event: global___CategoryEvent | None = ...,
        handle_participant_meet_state_event: global___HandleParticipantMeetStateEvent | None = ...,
        delete_account_event: global___DeleteAccountEvent | None = ...,
        ephemeral_message_send: global___EphemeralMessageSend | None = ...,
        block_friend: global___BlockFriend | None = ...,
        voice_reaction_send: global___VoiceReactionSend | None = ...,
        mark_as_read: global___MarkAsRead | None = ...,
        list_data_socket: global___ListDataSocket | None = ...,
        quick_menu_event: global___QuickMenuDataEvent | None = ...,
        un_block_friend: global___UnblockFriend | None = ...,
        meet_participant_event: global___MeetParticipantEvent | None = ...,
        transfer_ownership_event: global___TransferOwnershipEvent | None = ...,
        add_friend: global___AddFriend | None = ...,
        ban_user_event: global___BannedUserEvent | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["add_clan_user_event", b"add_clan_user_event", "add_friend", b"add_friend", "ban_user_event", b"ban_user_event", "block_friend", b"block_friend", "canvas_event", b"canvas_event", "category_event", b"category_event", "channel", b"channel", "channel_app_event", b"channel_app_event", "channel_created_event", b"channel_created_event", "channel_deleted_event", b"channel_deleted_event", "channel_join", b"channel_join", "channel_leave", b"channel_leave", "channel_message", b"channel_message", "channel_message_ack", b"channel_message_ack", "channel_message_remove", b"channel_message_remove", "channel_message_send", b"channel_message_send", "channel_message_update", b"channel_message_update", "channel_presence_event", b"channel_presence_event", "channel_updated_event", b"channel_updated_event", "check_name_existed_event", b"check_name_existed_event", "clan_deleted_event", b"clan_deleted_event", "clan_event_created", b"clan_event_created", "clan_join", b"clan_join", "clan_profile_updated_event", b"clan_profile_updated_event", "clan_updated_event", b"clan_updated_event", "custom_status_event", b"custom_status_event", "delete_account_event", b"delete_account_event", "dropdown_box_selected", b"dropdown_box_selected", "ephemeral_message_send", b"ephemeral_message_send", "error", b"error", "event_emoji", b"event_emoji", "follow_event", b"follow_event", "give_coffee_event", b"give_coffee_event", "handle_participant_meet_state_event", b"handle_participant_meet_state_event", "incoming_call_push", b"incoming_call_push", "join_channel_app_data", b"join_channel_app_data", "last_pin_message_event", b"last_pin_message_event", "last_seen_message_event", b"last_seen_message_event", "list_activity", b"list_activity", "list_data_socket", b"list_data_socket", "mark_as_read", b"mark_as_read", "meet_participant_event", b"meet_participant_event", "message", b"message", "message_button_clicked", b"message_button_clicked", "message_reaction_event", b"message_reaction_event", "message_typing_event", b"message_typing_event", "noti_user_channel", b"noti_user_channel", "notifications", b"notifications", "permission_changed_event", b"permission_changed_event", "permission_set_event", b"permission_set_event", "ping", b"ping", "pong", b"pong", "quick_menu_event", b"quick_menu_event", "remove_friend", b"remove_friend", "role_assign_event", b"role_assign_event", "role_event", b"role_event", "rpc", b"rpc", "sd_topic_event", b"sd_topic_event", "status", b"status", "status_follow", b"status_follow", "status_presence_event", b"status_presence_event", "status_unfollow", b"status_unfollow", "status_update", b"status_update", "sticker_create_event", b"sticker_create_event", "sticker_delete_event", b"sticker_delete_event", "sticker_update_event", b"sticker_update_event", "stream_data", b"stream_data", "stream_presence_event", b"stream_presence_event", "streaming_ended_event", b"streaming_ended_event", "streaming_joined_event", b"streaming_joined_event", "streaming_leaved_event", b"streaming_leaved_event", "streaming_started_event", b"streaming_started_event", "token_sent_event", b"token_sent_event", "transfer_ownership_event", b"transfer_ownership_event", "un_block_friend", b"un_block_friend", "unmute_event", b"unmute_event", "unpin_message_event", b"unpin_message_event", "user_channel_added_event", b"user_channel_added_event", "user_channel_removed_event", b"user_channel_removed_event", "user_clan_removed_event", b"user_clan_removed_event", "user_profile_updated_event", b"user_profile_updated_event", "user_status_event", b"user_status_event", "voice_ended_event", b"voice_ended_event", "voice_joined_event", b"voice_joined_event", "voice_leaved_event", b"voice_leaved_event", "voice_reaction_send", b"voice_reaction_send", "voice_started_event", b"voice_started_event", "webhook_event", b"webhook_event", "webrtc_signaling_fwd", b"webrtc_signaling_fwd"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["add_clan_user_event", b"add_clan_user_event", "add_friend", b"add_friend", "ban_user_event", b"ban_user_event", "block_friend", b"block_friend", "canvas_event", b"canvas_event", "category_event", b"category_event", "channel", b"channel", "channel_app_event", b"channel_app_event", "channel_created_event", b"channel_created_event", "channel_deleted_event", b"channel_deleted_event", "channel_join", b"channel_join", "channel_leave", b"channel_leave", "channel_message", b"channel_message", "channel_message_ack", b"channel_message_ack", "channel_message_remove", b"channel_message_remove", "channel_message_send", b"channel_message_send", "channel_message_update", b"channel_message_update", "channel_presence_event", b"channel_presence_event", "channel_updated_event", b"channel_updated_event", "check_name_existed_event", b"check_name_existed_event", "cid", b"cid", "clan_deleted_event", b"clan_deleted_event", "clan_event_created", b"clan_event_created", "clan_join", b"clan_join", "clan_profile_updated_event", b"clan_profile_updated_event", "clan_updated_event", b"clan_updated_event", "custom_status_event", b"custom_status_event", "delete_account_event", b"delete_account_event", "dropdown_box_selected", b"dropdown_box_selected", "ephemeral_message_send", b"ephemeral_message_send", "error", b"error", "event_emoji", b"event_emoji", "follow_event", b"follow_event", "give_coffee_event", b"give_coffee_event", "handle_participant_meet_state_event", b"handle_participant_meet_state_event", "incoming_call_push", b"incoming_call_push", "join_channel_app_data", b"join_channel_app_data", "last_pin_message_event", b"last_pin_message_event", "last_seen_message_event", b"last_seen_message_event", "list_activity", b"list_activity", "list_data_socket", b"list_data_socket", "mark_as_read", b"mark_as_read", "meet_participant_event", b"meet_participant_event", "message", b"message", "message_button_clicked", b"message_button_clicked", "message_reaction_event", b"message_reaction_event", "message_typing_event", b"message_typing_event", "noti_user_channel", b"noti_user_channel", "notifications", b"notifications", "permission_changed_event", b"permission_changed_event", "permission_set_event", b"permission_set_event", "ping", b"ping", "pong", b"pong", "quick_menu_event", b"quick_menu_event", "remove_friend", b"remove_friend", "role_assign_event", b"role_assign_event", "role_event", b"role_event", "rpc", b"rpc", "sd_topic_event", b"sd_topic_event", "status", b"status", "status_follow", b"status_follow", "status_presence_event", b"status_presence_event", "status_unfollow", b"status_unfollow", "status_update", b"status_update", "sticker_create_event", b"sticker_create_event", "sticker_delete_event", b"sticker_delete_event", "sticker_update_event", b"sticker_update_event", "stream_data", b"stream_data", "stream_presence_event", b"stream_presence_event", "streaming_ended_event", b"streaming_ended_event", "streaming_joined_event", b"streaming_joined_event", "streaming_leaved_event", b"streaming_leaved_event", "streaming_started_event", b"streaming_started_event", "token_sent_event", b"token_sent_event", "transfer_ownership_event", b"transfer_ownership_event", "un_block_friend", b"un_block_friend", "unmute_event", b"unmute_event", "unpin_message_event", b"unpin_message_event", "user_channel_added_event", b"user_channel_added_event", "user_channel_removed_event", b"user_channel_removed_event", "user_clan_removed_event", b"user_clan_removed_event", "user_profile_updated_event", b"user_profile_updated_event", "user_status_event", b"user_status_event", "voice_ended_event", b"voice_ended_event", "voice_joined_event", b"voice_joined_event", "voice_leaved_event", b"voice_leaved_event", "voice_reaction_send", b"voice_reaction_send", "voice_started_event", b"voice_started_event", "webhook_event", b"webhook_event", "webrtc_signaling_fwd", b"webrtc_signaling_fwd"]) -> None: ...
    def WhichOneof(self, oneof_group: typing.Literal["message", b"message"]) -> typing.Literal["channel", "clan_join", "channel_join", "channel_leave", "channel_message", "channel_message_ack", "channel_message_send", "channel_message_update", "channel_message_remove", "channel_presence_event", "error", "notifications", "rpc", "status", "status_follow", "status_presence_event", "status_unfollow", "status_update", "stream_data", "stream_presence_event", "ping", "pong", "message_typing_event", "last_seen_message_event", "message_reaction_event", "voice_joined_event", "voice_leaved_event", "voice_started_event", "voice_ended_event", "channel_created_event", "channel_deleted_event", "channel_updated_event", "last_pin_message_event", "custom_status_event", "user_channel_added_event", "user_channel_removed_event", "user_clan_removed_event", "clan_updated_event", "clan_profile_updated_event", "check_name_existed_event", "user_profile_updated_event", "add_clan_user_event", "clan_event_created", "role_assign_event", "clan_deleted_event", "give_coffee_event", "sticker_create_event", "sticker_update_event", "sticker_delete_event", "role_event", "event_emoji", "streaming_joined_event", "streaming_leaved_event", "streaming_started_event", "streaming_ended_event", "permission_set_event", "permission_changed_event", "token_sent_event", "message_button_clicked", "unmute_event", "webrtc_signaling_fwd", "list_activity", "dropdown_box_selected", "incoming_call_push", "sd_topic_event", "follow_event", "channel_app_event", "user_status_event", "remove_friend", "webhook_event", "noti_user_channel", "join_channel_app_data", "canvas_event", "unpin_message_event", "category_event", "handle_participant_meet_state_event", "delete_account_event", "ephemeral_message_send", "block_friend", "voice_reaction_send", "mark_as_read", "list_data_socket", "quick_menu_event", "un_block_friend", "meet_participant_event", "transfer_ownership_event", "add_friend", "ban_user_event"] | None: ...

global___Envelope = Envelope

@typing.final
class FollowEvent(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    def __init__(
        self,
    ) -> None: ...

global___FollowEvent = FollowEvent

@typing.final
class BannedUserEvent(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    USER_IDS_FIELD_NUMBER: builtins.int
    ACTION_FIELD_NUMBER: builtins.int
    BANNER_ID_FIELD_NUMBER: builtins.int
    action: builtins.int
    banner_id: builtins.str
    @property
    def user_ids(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]: ...
    def __init__(
        self,
        *,
        user_ids: collections.abc.Iterable[builtins.str] | None = ...,
        action: builtins.int = ...,
        banner_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["action", b"action", "banner_id", b"banner_id", "user_ids", b"user_ids"]) -> None: ...

global___BannedUserEvent = BannedUserEvent

@typing.final
class ChannelCanvas(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ID_FIELD_NUMBER: builtins.int
    TITLE_FIELD_NUMBER: builtins.int
    CONTENT_FIELD_NUMBER: builtins.int
    CREATOR_ID_FIELD_NUMBER: builtins.int
    EDITOR_ID_FIELD_NUMBER: builtins.int
    IS_DEFAULT_FIELD_NUMBER: builtins.int
    CHANNEL_ID_FIELD_NUMBER: builtins.int
    STATUS_FIELD_NUMBER: builtins.int
    id: builtins.str
    """id"""
    title: builtins.str
    """title"""
    content: builtins.str
    """content"""
    creator_id: builtins.str
    """creator"""
    editor_id: builtins.str
    """editor"""
    is_default: builtins.bool
    """is default"""
    channel_id: builtins.str
    """channel_id"""
    status: builtins.int
    """status"""
    def __init__(
        self,
        *,
        id: builtins.str = ...,
        title: builtins.str = ...,
        content: builtins.str = ...,
        creator_id: builtins.str = ...,
        editor_id: builtins.str = ...,
        is_default: builtins.bool = ...,
        channel_id: builtins.str = ...,
        status: builtins.int = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["channel_id", b"channel_id", "content", b"content", "creator_id", b"creator_id", "editor_id", b"editor_id", "id", b"id", "is_default", b"is_default", "status", b"status", "title", b"title"]) -> None: ...

global___ChannelCanvas = ChannelCanvas

@typing.final
class IncomingCallPush(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    RECEIVER_ID_FIELD_NUMBER: builtins.int
    JSON_DATA_FIELD_NUMBER: builtins.int
    CHANNEL_ID_FIELD_NUMBER: builtins.int
    CALLER_ID_FIELD_NUMBER: builtins.int
    receiver_id: builtins.str
    json_data: builtins.str
    channel_id: builtins.str
    caller_id: builtins.str
    def __init__(
        self,
        *,
        receiver_id: builtins.str = ...,
        json_data: builtins.str = ...,
        channel_id: builtins.str = ...,
        caller_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["caller_id", b"caller_id", "channel_id", b"channel_id", "json_data", b"json_data", "receiver_id", b"receiver_id"]) -> None: ...

global___IncomingCallPush = IncomingCallPush

@typing.final
class WebrtcSignalingFwd(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    RECEIVER_ID_FIELD_NUMBER: builtins.int
    DATA_TYPE_FIELD_NUMBER: builtins.int
    JSON_DATA_FIELD_NUMBER: builtins.int
    CHANNEL_ID_FIELD_NUMBER: builtins.int
    CALLER_ID_FIELD_NUMBER: builtins.int
    receiver_id: builtins.str
    data_type: builtins.int
    json_data: builtins.str
    channel_id: builtins.str
    caller_id: builtins.str
    def __init__(
        self,
        *,
        receiver_id: builtins.str = ...,
        data_type: builtins.int = ...,
        json_data: builtins.str = ...,
        channel_id: builtins.str = ...,
        caller_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["caller_id", b"caller_id", "channel_id", b"channel_id", "data_type", b"data_type", "json_data", b"json_data", "receiver_id", b"receiver_id"]) -> None: ...

global___WebrtcSignalingFwd = WebrtcSignalingFwd

@typing.final
class SFUSignalingFwd(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CLAN_ID_FIELD_NUMBER: builtins.int
    CHANNEL_ID_FIELD_NUMBER: builtins.int
    DATA_TYPE_FIELD_NUMBER: builtins.int
    JSON_DATA_FIELD_NUMBER: builtins.int
    USER_ID_FIELD_NUMBER: builtins.int
    clan_id: builtins.str
    channel_id: builtins.str
    data_type: builtins.int
    json_data: builtins.str
    user_id: builtins.str
    def __init__(
        self,
        *,
        clan_id: builtins.str = ...,
        channel_id: builtins.str = ...,
        data_type: builtins.int = ...,
        json_data: builtins.str = ...,
        user_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["channel_id", b"channel_id", "clan_id", b"clan_id", "data_type", b"data_type", "json_data", b"json_data", "user_id", b"user_id"]) -> None: ...

global___SFUSignalingFwd = SFUSignalingFwd

@typing.final
class AddClanUserEvent(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CLAN_ID_FIELD_NUMBER: builtins.int
    USER_FIELD_NUMBER: builtins.int
    INVITOR_FIELD_NUMBER: builtins.int
    clan_id: builtins.str
    """the clan id"""
    invitor: builtins.str
    """inviter"""
    @property
    def user(self) -> global___UserProfileRedis:
        """the user"""

    def __init__(
        self,
        *,
        clan_id: builtins.str = ...,
        user: global___UserProfileRedis | None = ...,
        invitor: builtins.str = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["user", b"user"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["clan_id", b"clan_id", "invitor", b"invitor", "user", b"user"]) -> None: ...

global___AddClanUserEvent = AddClanUserEvent

@typing.final
class RoleAssignedEvent(google.protobuf.message.Message):
    """On role assign"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CLANID_FIELD_NUMBER: builtins.int
    ROLE_ID_FIELD_NUMBER: builtins.int
    USER_IDS_ASSIGNED_FIELD_NUMBER: builtins.int
    USER_IDS_REMOVED_FIELD_NUMBER: builtins.int
    ClanId: builtins.str
    """The clan of this role"""
    role_id: builtins.str
    """Role ID"""
    @property
    def user_ids_assigned(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """UserIds Assigned"""

    @property
    def user_ids_removed(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """UserIds Removed"""

    def __init__(
        self,
        *,
        ClanId: builtins.str = ...,
        role_id: builtins.str = ...,
        user_ids_assigned: collections.abc.Iterable[builtins.str] | None = ...,
        user_ids_removed: collections.abc.Iterable[builtins.str] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["ClanId", b"ClanId", "role_id", b"role_id", "user_ids_assigned", b"user_ids_assigned", "user_ids_removed", b"user_ids_removed"]) -> None: ...

global___RoleAssignedEvent = RoleAssignedEvent

@typing.final
class PermissionRoleChannel(google.protobuf.message.Message):
    """Permission role channel"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    PERMISSION_ID_FIELD_NUMBER: builtins.int
    ACTIVE_FIELD_NUMBER: builtins.int
    permission_id: builtins.str
    """Permission id"""
    active: builtins.bool
    """active"""
    def __init__(
        self,
        *,
        permission_id: builtins.str = ...,
        active: builtins.bool = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["active", b"active", "permission_id", b"permission_id"]) -> None: ...

global___PermissionRoleChannel = PermissionRoleChannel

@typing.final
class HashtagDm(google.protobuf.message.Message):
    """hashtagDM"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CHANNEL_ID_FIELD_NUMBER: builtins.int
    CHANNEL_LABEL_FIELD_NUMBER: builtins.int
    CLAN_ID_FIELD_NUMBER: builtins.int
    CLAN_NAME_FIELD_NUMBER: builtins.int
    MEETING_CODE_FIELD_NUMBER: builtins.int
    TYPE_FIELD_NUMBER: builtins.int
    CHANNEL_PRIVATE_FIELD_NUMBER: builtins.int
    PARENT_ID_FIELD_NUMBER: builtins.int
    channel_id: builtins.str
    """The channel id."""
    channel_label: builtins.str
    """The channel lable"""
    clan_id: builtins.str
    """The clan of this channel"""
    clan_name: builtins.str
    """The clan name"""
    meeting_code: builtins.str
    """"""
    type: builtins.int
    """"""
    channel_private: builtins.int
    """"""
    parent_id: builtins.str
    """"""
    def __init__(
        self,
        *,
        channel_id: builtins.str = ...,
        channel_label: builtins.str = ...,
        clan_id: builtins.str = ...,
        clan_name: builtins.str = ...,
        meeting_code: builtins.str = ...,
        type: builtins.int = ...,
        channel_private: builtins.int = ...,
        parent_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["channel_id", b"channel_id", "channel_label", b"channel_label", "channel_private", b"channel_private", "clan_id", b"clan_id", "clan_name", b"clan_name", "meeting_code", b"meeting_code", "parent_id", b"parent_id", "type", b"type"]) -> None: ...

global___HashtagDm = HashtagDm

@typing.final
class ChannelDescription(google.protobuf.message.Message):
    """Channel description record"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CLAN_ID_FIELD_NUMBER: builtins.int
    CHANNEL_ID_FIELD_NUMBER: builtins.int
    TYPE_FIELD_NUMBER: builtins.int
    CHANNEL_LABEL_FIELD_NUMBER: builtins.int
    CHANNEL_PRIVATE_FIELD_NUMBER: builtins.int
    MEETING_CODE_FIELD_NUMBER: builtins.int
    CLAN_NAME_FIELD_NUMBER: builtins.int
    PARENT_ID_FIELD_NUMBER: builtins.int
    LAST_SENT_MESSAGE_FIELD_NUMBER: builtins.int
    clan_id: builtins.str
    """The clan of this channel"""
    channel_id: builtins.str
    """The channel this message belongs to."""
    channel_label: builtins.str
    """The channel lable"""
    channel_private: builtins.int
    """The channel private"""
    meeting_code: builtins.str
    """meeting code"""
    clan_name: builtins.str
    """"""
    parent_id: builtins.str
    """"""
    @property
    def type(self) -> google.protobuf.wrappers_pb2.Int32Value:
        """The channel type."""

    @property
    def last_sent_message(self) -> api.api_pb2.ChannelMessageHeader:
        """"""

    def __init__(
        self,
        *,
        clan_id: builtins.str = ...,
        channel_id: builtins.str = ...,
        type: google.protobuf.wrappers_pb2.Int32Value | None = ...,
        channel_label: builtins.str = ...,
        channel_private: builtins.int = ...,
        meeting_code: builtins.str = ...,
        clan_name: builtins.str = ...,
        parent_id: builtins.str = ...,
        last_sent_message: api.api_pb2.ChannelMessageHeader | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["last_sent_message", b"last_sent_message", "type", b"type"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["channel_id", b"channel_id", "channel_label", b"channel_label", "channel_private", b"channel_private", "clan_id", b"clan_id", "clan_name", b"clan_name", "last_sent_message", b"last_sent_message", "meeting_code", b"meeting_code", "parent_id", b"parent_id", "type", b"type"]) -> None: ...

global___ChannelDescription = ChannelDescription

@typing.final
class ClanEmoji(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ID_FIELD_NUMBER: builtins.int
    SRC_FIELD_NUMBER: builtins.int
    SHORTNAME_FIELD_NUMBER: builtins.int
    CATEGORY_FIELD_NUMBER: builtins.int
    CREATOR_ID_FIELD_NUMBER: builtins.int
    CLAN_ID_FIELD_NUMBER: builtins.int
    LOGO_FIELD_NUMBER: builtins.int
    CLAN_NAME_FIELD_NUMBER: builtins.int
    id: builtins.str
    src: builtins.str
    """src url"""
    shortname: builtins.str
    """shortname"""
    category: builtins.str
    """category"""
    creator_id: builtins.str
    """creator id"""
    clan_id: builtins.str
    """clan_id"""
    logo: builtins.str
    """clan logo"""
    clan_name: builtins.str
    """clan name"""
    def __init__(
        self,
        *,
        id: builtins.str = ...,
        src: builtins.str = ...,
        shortname: builtins.str = ...,
        category: builtins.str = ...,
        creator_id: builtins.str = ...,
        clan_id: builtins.str = ...,
        logo: builtins.str = ...,
        clan_name: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["category", b"category", "clan_id", b"clan_id", "clan_name", b"clan_name", "creator_id", b"creator_id", "id", b"id", "logo", b"logo", "shortname", b"shortname", "src", b"src"]) -> None: ...

global___ClanEmoji = ClanEmoji

@typing.final
class Channel(google.protobuf.message.Message):
    """A realtime chat channel."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ID_FIELD_NUMBER: builtins.int
    PRESENCES_FIELD_NUMBER: builtins.int
    SELF_FIELD_NUMBER: builtins.int
    CHANEL_LABEL_FIELD_NUMBER: builtins.int
    CLAN_LOGO_FIELD_NUMBER: builtins.int
    CATEGORY_NAME_FIELD_NUMBER: builtins.int
    id: builtins.str
    """The ID of the channel."""
    chanel_label: builtins.str
    """The name of the chat room, or an empty string if this message was not sent through a chat room."""
    clan_logo: builtins.str
    """The clan logo"""
    category_name: builtins.str
    """The category name"""
    @property
    def presences(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___UserPresence]:
        """The users currently in the channel."""

    @property
    def self(self) -> global___UserPresence:
        """A reference to the current user's presence in the channel."""

    def __init__(
        self_,  # pyright: ignore[reportSelfClsParameterName]
        *,
        id: builtins.str = ...,
        presences: collections.abc.Iterable[global___UserPresence] | None = ...,
        self: global___UserPresence | None = ...,
        chanel_label: builtins.str = ...,
        clan_logo: builtins.str = ...,
        category_name: builtins.str = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["self", b"self"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["category_name", b"category_name", "chanel_label", b"chanel_label", "clan_logo", b"clan_logo", "id", b"id", "presences", b"presences", "self", b"self"]) -> None: ...

global___Channel = Channel

@typing.final
class ClanJoin(google.protobuf.message.Message):
    """Join operation for a realtime chat channel."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CLAN_ID_FIELD_NUMBER: builtins.int
    clan_id: builtins.str
    """The id of channel or group"""
    def __init__(
        self,
        *,
        clan_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["clan_id", b"clan_id"]) -> None: ...

global___ClanJoin = ClanJoin

@typing.final
class ChannelJoin(google.protobuf.message.Message):
    """Join operation for a realtime chat channel."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CLAN_ID_FIELD_NUMBER: builtins.int
    CHANNEL_ID_FIELD_NUMBER: builtins.int
    CHANNEL_TYPE_FIELD_NUMBER: builtins.int
    IS_PUBLIC_FIELD_NUMBER: builtins.int
    clan_id: builtins.str
    """The clan id"""
    channel_id: builtins.str
    """The id of channel or group"""
    channel_type: builtins.int
    """channel type"""
    is_public: builtins.bool
    """is public"""
    def __init__(
        self,
        *,
        clan_id: builtins.str = ...,
        channel_id: builtins.str = ...,
        channel_type: builtins.int = ...,
        is_public: builtins.bool = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["channel_id", b"channel_id", "channel_type", b"channel_type", "clan_id", b"clan_id", "is_public", b"is_public"]) -> None: ...

global___ChannelJoin = ChannelJoin

@typing.final
class ChannelLeave(google.protobuf.message.Message):
    """Leave a realtime channel."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CLAN_ID_FIELD_NUMBER: builtins.int
    CHANNEL_ID_FIELD_NUMBER: builtins.int
    CHANNEL_TYPE_FIELD_NUMBER: builtins.int
    IS_PUBLIC_FIELD_NUMBER: builtins.int
    clan_id: builtins.str
    """The clan id"""
    channel_id: builtins.str
    """The ID of the channel to leave."""
    channel_type: builtins.int
    """channel type"""
    is_public: builtins.bool
    """is public channel"""
    def __init__(
        self,
        *,
        clan_id: builtins.str = ...,
        channel_id: builtins.str = ...,
        channel_type: builtins.int = ...,
        is_public: builtins.bool = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["channel_id", b"channel_id", "channel_type", b"channel_type", "clan_id", b"clan_id", "is_public", b"is_public"]) -> None: ...

global___ChannelLeave = ChannelLeave

@typing.final
class ChannelMessageAck(google.protobuf.message.Message):
    """A receipt reply from a channel message send operation."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CHANNEL_ID_FIELD_NUMBER: builtins.int
    MESSAGE_ID_FIELD_NUMBER: builtins.int
    CODE_FIELD_NUMBER: builtins.int
    USERNAME_FIELD_NUMBER: builtins.int
    CREATE_TIME_FIELD_NUMBER: builtins.int
    UPDATE_TIME_FIELD_NUMBER: builtins.int
    PERSISTENT_FIELD_NUMBER: builtins.int
    CLAN_LOGO_FIELD_NUMBER: builtins.int
    CATEGORY_NAME_FIELD_NUMBER: builtins.int
    channel_id: builtins.str
    """The channel the message was sent to."""
    message_id: builtins.str
    """The unique ID assigned to the message."""
    username: builtins.str
    """Username of the message sender."""
    clan_logo: builtins.str
    """The clan logo"""
    category_name: builtins.str
    """The category name"""
    @property
    def code(self) -> google.protobuf.wrappers_pb2.Int32Value:
        """The code representing a message type or category."""

    @property
    def create_time(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """The UNIX time (for gRPC clients) or ISO string (for REST clients) when the message was created."""

    @property
    def update_time(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """The UNIX time (for gRPC clients) or ISO string (for REST clients) when the message was last updated."""

    @property
    def persistent(self) -> google.protobuf.wrappers_pb2.BoolValue:
        """True if the message was persisted to the channel's history, false otherwise."""

    def __init__(
        self,
        *,
        channel_id: builtins.str = ...,
        message_id: builtins.str = ...,
        code: google.protobuf.wrappers_pb2.Int32Value | None = ...,
        username: builtins.str = ...,
        create_time: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        update_time: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        persistent: google.protobuf.wrappers_pb2.BoolValue | None = ...,
        clan_logo: builtins.str = ...,
        category_name: builtins.str = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["code", b"code", "create_time", b"create_time", "persistent", b"persistent", "update_time", b"update_time"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["category_name", b"category_name", "channel_id", b"channel_id", "clan_logo", b"clan_logo", "code", b"code", "create_time", b"create_time", "message_id", b"message_id", "persistent", b"persistent", "update_time", b"update_time", "username", b"username"]) -> None: ...

global___ChannelMessageAck = ChannelMessageAck

@typing.final
class EphemeralMessageSend(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    MESSAGE_FIELD_NUMBER: builtins.int
    RECEIVER_ID_FIELD_NUMBER: builtins.int
    receiver_id: builtins.str
    @property
    def message(self) -> global___ChannelMessageSend: ...
    def __init__(
        self,
        *,
        message: global___ChannelMessageSend | None = ...,
        receiver_id: builtins.str = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["message", b"message"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["message", b"message", "receiver_id", b"receiver_id"]) -> None: ...

global___EphemeralMessageSend = EphemeralMessageSend

@typing.final
class QuickMenuDataEvent(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    MENU_NAME_FIELD_NUMBER: builtins.int
    MESSAGE_FIELD_NUMBER: builtins.int
    menu_name: builtins.str
    @property
    def message(self) -> global___ChannelMessageSend: ...
    def __init__(
        self,
        *,
        menu_name: builtins.str = ...,
        message: global___ChannelMessageSend | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["message", b"message"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["menu_name", b"menu_name", "message", b"message"]) -> None: ...

global___QuickMenuDataEvent = QuickMenuDataEvent

@typing.final
class VoiceReactionSend(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    EMOJIS_FIELD_NUMBER: builtins.int
    CHANNEL_ID_FIELD_NUMBER: builtins.int
    SENDER_ID_FIELD_NUMBER: builtins.int
    MEDIA_TYPE_FIELD_NUMBER: builtins.int
    channel_id: builtins.str
    """channel_id"""
    sender_id: builtins.str
    """sender id"""
    media_type: builtins.int
    """type"""
    @property
    def emojis(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """list emoji"""

    def __init__(
        self,
        *,
        emojis: collections.abc.Iterable[builtins.str] | None = ...,
        channel_id: builtins.str = ...,
        sender_id: builtins.str = ...,
        media_type: builtins.int = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["channel_id", b"channel_id", "emojis", b"emojis", "media_type", b"media_type", "sender_id", b"sender_id"]) -> None: ...

global___VoiceReactionSend = VoiceReactionSend

@typing.final
class MarkAsRead(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CHANNEL_ID_FIELD_NUMBER: builtins.int
    CATEGORY_ID_FIELD_NUMBER: builtins.int
    CLAN_ID_FIELD_NUMBER: builtins.int
    channel_id: builtins.str
    """channel id"""
    category_id: builtins.str
    """category_id"""
    clan_id: builtins.str
    """clan id"""
    def __init__(
        self,
        *,
        channel_id: builtins.str = ...,
        category_id: builtins.str = ...,
        clan_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["category_id", b"category_id", "channel_id", b"channel_id", "clan_id", b"clan_id"]) -> None: ...

global___MarkAsRead = MarkAsRead

@typing.final
class ChannelMessageSend(google.protobuf.message.Message):
    """Send a message to a realtime channel."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CLAN_ID_FIELD_NUMBER: builtins.int
    CHANNEL_ID_FIELD_NUMBER: builtins.int
    CONTENT_FIELD_NUMBER: builtins.int
    MENTIONS_FIELD_NUMBER: builtins.int
    ATTACHMENTS_FIELD_NUMBER: builtins.int
    REFERENCES_FIELD_NUMBER: builtins.int
    MODE_FIELD_NUMBER: builtins.int
    ANONYMOUS_MESSAGE_FIELD_NUMBER: builtins.int
    MENTION_EVERYONE_FIELD_NUMBER: builtins.int
    AVATAR_FIELD_NUMBER: builtins.int
    IS_PUBLIC_FIELD_NUMBER: builtins.int
    CODE_FIELD_NUMBER: builtins.int
    TOPIC_ID_FIELD_NUMBER: builtins.int
    clan_id: builtins.str
    """The clan that channel belong to."""
    channel_id: builtins.str
    """The channel to sent to."""
    content: builtins.str
    """Message content."""
    mode: builtins.int
    """Mode"""
    anonymous_message: builtins.bool
    """anonymous message"""
    mention_everyone: builtins.bool
    """mention everyone"""
    avatar: builtins.str
    """clan avatar"""
    is_public: builtins.bool
    """is public"""
    code: builtins.int
    """code"""
    topic_id: builtins.str
    """"""
    @property
    def mentions(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[api.api_pb2.MessageMention]:
        """Message mention"""

    @property
    def attachments(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[api.api_pb2.MessageAttachment]:
        """Message attachment"""

    @property
    def references(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[api.api_pb2.MessageRef]:
        """Message reference"""

    def __init__(
        self,
        *,
        clan_id: builtins.str = ...,
        channel_id: builtins.str = ...,
        content: builtins.str = ...,
        mentions: collections.abc.Iterable[api.api_pb2.MessageMention] | None = ...,
        attachments: collections.abc.Iterable[api.api_pb2.MessageAttachment] | None = ...,
        references: collections.abc.Iterable[api.api_pb2.MessageRef] | None = ...,
        mode: builtins.int = ...,
        anonymous_message: builtins.bool = ...,
        mention_everyone: builtins.bool = ...,
        avatar: builtins.str = ...,
        is_public: builtins.bool = ...,
        code: builtins.int = ...,
        topic_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["anonymous_message", b"anonymous_message", "attachments", b"attachments", "avatar", b"avatar", "channel_id", b"channel_id", "clan_id", b"clan_id", "code", b"code", "content", b"content", "is_public", b"is_public", "mention_everyone", b"mention_everyone", "mentions", b"mentions", "mode", b"mode", "references", b"references", "topic_id", b"topic_id"]) -> None: ...

global___ChannelMessageSend = ChannelMessageSend

@typing.final
class ChannelMessageUpdate(google.protobuf.message.Message):
    """Update a message previously sent to a realtime channel."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CLAN_ID_FIELD_NUMBER: builtins.int
    CHANNEL_ID_FIELD_NUMBER: builtins.int
    MESSAGE_ID_FIELD_NUMBER: builtins.int
    CONTENT_FIELD_NUMBER: builtins.int
    MENTIONS_FIELD_NUMBER: builtins.int
    ATTACHMENTS_FIELD_NUMBER: builtins.int
    MODE_FIELD_NUMBER: builtins.int
    IS_PUBLIC_FIELD_NUMBER: builtins.int
    HIDE_EDITTED_FIELD_NUMBER: builtins.int
    TOPIC_ID_FIELD_NUMBER: builtins.int
    IS_UPDATE_MSG_TOPIC_FIELD_NUMBER: builtins.int
    OLD_MENTIONS_FIELD_NUMBER: builtins.int
    clan_id: builtins.str
    """The clan that channel belong to."""
    channel_id: builtins.str
    """The channel the message was sent to."""
    message_id: builtins.str
    """The ID assigned to the message to update."""
    content: builtins.str
    """New message content."""
    mode: builtins.int
    """The mode"""
    is_public: builtins.bool
    """is public"""
    hide_editted: builtins.bool
    """hide editted"""
    topic_id: builtins.str
    """topic id"""
    is_update_msg_topic: builtins.bool
    """update message topic"""
    old_mentions: builtins.str
    """old mentions"""
    @property
    def mentions(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[api.api_pb2.MessageMention]:
        """The mentions"""

    @property
    def attachments(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[api.api_pb2.MessageAttachment]:
        """Message attachment"""

    def __init__(
        self,
        *,
        clan_id: builtins.str = ...,
        channel_id: builtins.str = ...,
        message_id: builtins.str = ...,
        content: builtins.str = ...,
        mentions: collections.abc.Iterable[api.api_pb2.MessageMention] | None = ...,
        attachments: collections.abc.Iterable[api.api_pb2.MessageAttachment] | None = ...,
        mode: builtins.int = ...,
        is_public: builtins.bool = ...,
        hide_editted: builtins.bool = ...,
        topic_id: builtins.str = ...,
        is_update_msg_topic: builtins.bool = ...,
        old_mentions: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["attachments", b"attachments", "channel_id", b"channel_id", "clan_id", b"clan_id", "content", b"content", "hide_editted", b"hide_editted", "is_public", b"is_public", "is_update_msg_topic", b"is_update_msg_topic", "mentions", b"mentions", "message_id", b"message_id", "mode", b"mode", "old_mentions", b"old_mentions", "topic_id", b"topic_id"]) -> None: ...

global___ChannelMessageUpdate = ChannelMessageUpdate

@typing.final
class ChannelMessageRemove(google.protobuf.message.Message):
    """Remove a message previously sent to a realtime channel."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CLAN_ID_FIELD_NUMBER: builtins.int
    CHANNEL_ID_FIELD_NUMBER: builtins.int
    MESSAGE_ID_FIELD_NUMBER: builtins.int
    MODE_FIELD_NUMBER: builtins.int
    IS_PUBLIC_FIELD_NUMBER: builtins.int
    HAS_ATTACHMENT_FIELD_NUMBER: builtins.int
    TOPIC_ID_FIELD_NUMBER: builtins.int
    MENTIONS_FIELD_NUMBER: builtins.int
    REFERENCES_FIELD_NUMBER: builtins.int
    clan_id: builtins.str
    """The clan that channel belong to."""
    channel_id: builtins.str
    """The channel the message was sent to."""
    message_id: builtins.str
    """The ID assigned to the message to update."""
    mode: builtins.int
    """The mode"""
    is_public: builtins.bool
    """is public"""
    has_attachment: builtins.bool
    """has_attachments."""
    topic_id: builtins.str
    """"""
    mentions: builtins.str
    """Message mention"""
    references: builtins.str
    """Message reference"""
    def __init__(
        self,
        *,
        clan_id: builtins.str = ...,
        channel_id: builtins.str = ...,
        message_id: builtins.str = ...,
        mode: builtins.int = ...,
        is_public: builtins.bool = ...,
        has_attachment: builtins.bool = ...,
        topic_id: builtins.str = ...,
        mentions: builtins.str = ...,
        references: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["channel_id", b"channel_id", "clan_id", b"clan_id", "has_attachment", b"has_attachment", "is_public", b"is_public", "mentions", b"mentions", "message_id", b"message_id", "mode", b"mode", "references", b"references", "topic_id", b"topic_id"]) -> None: ...

global___ChannelMessageRemove = ChannelMessageRemove

@typing.final
class ChannelPresenceEvent(google.protobuf.message.Message):
    """A set of joins and leaves on a particular channel."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CHANNEL_ID_FIELD_NUMBER: builtins.int
    JOINS_FIELD_NUMBER: builtins.int
    LEAVES_FIELD_NUMBER: builtins.int
    CLAN_LOGO_FIELD_NUMBER: builtins.int
    CATEGORY_NAME_FIELD_NUMBER: builtins.int
    MODE_FIELD_NUMBER: builtins.int
    channel_id: builtins.str
    """The channel identifier this event is for."""
    clan_logo: builtins.str
    """The clan logo"""
    category_name: builtins.str
    """The category name"""
    mode: builtins.int
    """The mode"""
    @property
    def joins(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___UserPresence]:
        """Presences joining the channel as part of this event, if any."""

    @property
    def leaves(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___UserPresence]:
        """Presences leaving the channel as part of this event, if any."""

    def __init__(
        self,
        *,
        channel_id: builtins.str = ...,
        joins: collections.abc.Iterable[global___UserPresence] | None = ...,
        leaves: collections.abc.Iterable[global___UserPresence] | None = ...,
        clan_logo: builtins.str = ...,
        category_name: builtins.str = ...,
        mode: builtins.int = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["category_name", b"category_name", "channel_id", b"channel_id", "clan_logo", b"clan_logo", "joins", b"joins", "leaves", b"leaves", "mode", b"mode"]) -> None: ...

global___ChannelPresenceEvent = ChannelPresenceEvent

@typing.final
class Error(google.protobuf.message.Message):
    """A logical error which may occur on the server."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    class _Code:
        ValueType = typing.NewType("ValueType", builtins.int)
        V: typing_extensions.TypeAlias = ValueType

    class _CodeEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[Error._Code.ValueType], builtins.type):
        DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
        RUNTIME_EXCEPTION: Error._Code.ValueType  # 0
        """An unexpected result from the server."""
        UNRECOGNIZED_PAYLOAD: Error._Code.ValueType  # 1
        """The server received a message which is not recognised."""
        MISSING_PAYLOAD: Error._Code.ValueType  # 2
        """A message was expected but contains no content."""
        BAD_INPUT: Error._Code.ValueType  # 3
        """Fields in the message have an invalid format."""
        MATCH_NOT_FOUND: Error._Code.ValueType  # 4
        """The match id was not found."""
        MATCH_JOIN_REJECTED: Error._Code.ValueType  # 5
        """The match join was rejected."""
        RUNTIME_FUNCTION_NOT_FOUND: Error._Code.ValueType  # 6
        """The runtime function does not exist on the server."""
        RUNTIME_FUNCTION_EXCEPTION: Error._Code.ValueType  # 7
        """The runtime function executed with an error."""

    class Code(_Code, metaclass=_CodeEnumTypeWrapper):
        """The selection of possible error codes."""

    RUNTIME_EXCEPTION: Error.Code.ValueType  # 0
    """An unexpected result from the server."""
    UNRECOGNIZED_PAYLOAD: Error.Code.ValueType  # 1
    """The server received a message which is not recognised."""
    MISSING_PAYLOAD: Error.Code.ValueType  # 2
    """A message was expected but contains no content."""
    BAD_INPUT: Error.Code.ValueType  # 3
    """Fields in the message have an invalid format."""
    MATCH_NOT_FOUND: Error.Code.ValueType  # 4
    """The match id was not found."""
    MATCH_JOIN_REJECTED: Error.Code.ValueType  # 5
    """The match join was rejected."""
    RUNTIME_FUNCTION_NOT_FOUND: Error.Code.ValueType  # 6
    """The runtime function does not exist on the server."""
    RUNTIME_FUNCTION_EXCEPTION: Error.Code.ValueType  # 7
    """The runtime function executed with an error."""

    @typing.final
    class ContextEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.str
        value: builtins.str
        def __init__(
            self,
            *,
            key: builtins.str = ...,
            value: builtins.str = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing.Literal["key", b"key", "value", b"value"]) -> None: ...

    CODE_FIELD_NUMBER: builtins.int
    MESSAGE_FIELD_NUMBER: builtins.int
    CONTEXT_FIELD_NUMBER: builtins.int
    code: builtins.int
    """The error code which should be one of "Error.Code" enums."""
    message: builtins.str
    """A message in English to help developers debug the response."""
    @property
    def context(self) -> google.protobuf.internal.containers.ScalarMap[builtins.str, builtins.str]:
        """Additional error details which may be different for each response."""

    def __init__(
        self,
        *,
        code: builtins.int = ...,
        message: builtins.str = ...,
        context: collections.abc.Mapping[builtins.str, builtins.str] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["code", b"code", "context", b"context", "message", b"message"]) -> None: ...

global___Error = Error

@typing.final
class Notifications(google.protobuf.message.Message):
    """A collection of zero or more notifications."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    NOTIFICATIONS_FIELD_NUMBER: builtins.int
    @property
    def notifications(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[api.api_pb2.Notification]:
        """Collection of notifications."""

    def __init__(
        self,
        *,
        notifications: collections.abc.Iterable[api.api_pb2.Notification] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["notifications", b"notifications"]) -> None: ...

global___Notifications = Notifications

@typing.final
class AddFriend(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    USER_ID_FIELD_NUMBER: builtins.int
    USERNAME_FIELD_NUMBER: builtins.int
    DISPLAY_NAME_FIELD_NUMBER: builtins.int
    AVATAR_FIELD_NUMBER: builtins.int
    user_id: builtins.str
    """user id"""
    username: builtins.str
    """username"""
    display_name: builtins.str
    """display name"""
    avatar: builtins.str
    """avatar"""
    def __init__(
        self,
        *,
        user_id: builtins.str = ...,
        username: builtins.str = ...,
        display_name: builtins.str = ...,
        avatar: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["avatar", b"avatar", "display_name", b"display_name", "user_id", b"user_id", "username", b"username"]) -> None: ...

global___AddFriend = AddFriend

@typing.final
class RemoveFriend(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    USER_ID_FIELD_NUMBER: builtins.int
    user_id: builtins.str
    """"""
    def __init__(
        self,
        *,
        user_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["user_id", b"user_id"]) -> None: ...

global___RemoveFriend = RemoveFriend

@typing.final
class BlockFriend(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    USER_ID_FIELD_NUMBER: builtins.int
    user_id: builtins.str
    """"""
    def __init__(
        self,
        *,
        user_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["user_id", b"user_id"]) -> None: ...

global___BlockFriend = BlockFriend

@typing.final
class UnblockFriend(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    USER_ID_FIELD_NUMBER: builtins.int
    USERNAME_FIELD_NUMBER: builtins.int
    AVATAR_FIELD_NUMBER: builtins.int
    DISPLAY_NAME_FIELD_NUMBER: builtins.int
    STATUS_FIELD_NUMBER: builtins.int
    USER_STATUS_FIELD_NUMBER: builtins.int
    user_id: builtins.str
    """"""
    username: builtins.str
    """"""
    avatar: builtins.str
    """"""
    display_name: builtins.str
    """"""
    status: builtins.str
    """"""
    user_status: builtins.str
    """"""
    def __init__(
        self,
        *,
        user_id: builtins.str = ...,
        username: builtins.str = ...,
        avatar: builtins.str = ...,
        display_name: builtins.str = ...,
        status: builtins.str = ...,
        user_status: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["avatar", b"avatar", "display_name", b"display_name", "status", b"status", "user_id", b"user_id", "user_status", b"user_status", "username", b"username"]) -> None: ...

global___UnblockFriend = UnblockFriend

@typing.final
class Ping(google.protobuf.message.Message):
    """Application-level heartbeat and connection check."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    def __init__(
        self,
    ) -> None: ...

global___Ping = Ping

@typing.final
class Pong(google.protobuf.message.Message):
    """Application-level heartbeat and connection check response."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    def __init__(
        self,
    ) -> None: ...

global___Pong = Pong

@typing.final
class Status(google.protobuf.message.Message):
    """A snapshot of statuses for some set of users."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    PRESENCES_FIELD_NUMBER: builtins.int
    @property
    def presences(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___UserPresence]:
        """User statuses."""

    def __init__(
        self,
        *,
        presences: collections.abc.Iterable[global___UserPresence] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["presences", b"presences"]) -> None: ...

global___Status = Status

@typing.final
class StatusFollow(google.protobuf.message.Message):
    """Start receiving status updates for some set of users."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    USER_IDS_FIELD_NUMBER: builtins.int
    USERNAMES_FIELD_NUMBER: builtins.int
    @property
    def user_ids(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """User IDs to follow."""

    @property
    def usernames(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """Usernames to follow."""

    def __init__(
        self,
        *,
        user_ids: collections.abc.Iterable[builtins.str] | None = ...,
        usernames: collections.abc.Iterable[builtins.str] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["user_ids", b"user_ids", "usernames", b"usernames"]) -> None: ...

global___StatusFollow = StatusFollow

@typing.final
class StatusPresenceEvent(google.protobuf.message.Message):
    """A batch of status updates for a given user."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    JOINS_FIELD_NUMBER: builtins.int
    LEAVES_FIELD_NUMBER: builtins.int
    @property
    def joins(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___UserPresence]:
        """New statuses for the user."""

    @property
    def leaves(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___UserPresence]:
        """Previous statuses for the user."""

    def __init__(
        self,
        *,
        joins: collections.abc.Iterable[global___UserPresence] | None = ...,
        leaves: collections.abc.Iterable[global___UserPresence] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["joins", b"joins", "leaves", b"leaves"]) -> None: ...

global___StatusPresenceEvent = StatusPresenceEvent

@typing.final
class LastPinMessageEvent(google.protobuf.message.Message):
    """Last pin message by user"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CLAN_ID_FIELD_NUMBER: builtins.int
    CHANNEL_ID_FIELD_NUMBER: builtins.int
    MESSAGE_ID_FIELD_NUMBER: builtins.int
    MODE_FIELD_NUMBER: builtins.int
    USER_ID_FIELD_NUMBER: builtins.int
    TIMESTAMP_SECONDS_FIELD_NUMBER: builtins.int
    OPERATION_FIELD_NUMBER: builtins.int
    IS_PUBLIC_FIELD_NUMBER: builtins.int
    MESSAGE_SENDER_AVATAR_FIELD_NUMBER: builtins.int
    MESSAGE_SENDER_ID_FIELD_NUMBER: builtins.int
    MESSAGE_SENDER_USERNAME_FIELD_NUMBER: builtins.int
    MESSAGE_CONTENT_FIELD_NUMBER: builtins.int
    MESSAGE_ATTACHMENT_FIELD_NUMBER: builtins.int
    MESSAGE_CREATED_TIME_FIELD_NUMBER: builtins.int
    clan_id: builtins.str
    """The clan id"""
    channel_id: builtins.str
    """The unique ID of this channel."""
    message_id: builtins.str
    """The unique ID of this message."""
    mode: builtins.int
    """The stream mode"""
    user_id: builtins.str
    """The UserID"""
    timestamp_seconds: builtins.int
    """The timestamp"""
    operation: builtins.int
    """operation"""
    is_public: builtins.bool
    """is public"""
    message_sender_avatar: builtins.str
    """avatar"""
    message_sender_id: builtins.str
    """message sender id"""
    message_sender_username: builtins.str
    """message sender username"""
    message_content: builtins.str
    """message content"""
    message_attachment: builtins.str
    """attachment"""
    message_created_time: builtins.str
    """create time"""
    def __init__(
        self,
        *,
        clan_id: builtins.str = ...,
        channel_id: builtins.str = ...,
        message_id: builtins.str = ...,
        mode: builtins.int = ...,
        user_id: builtins.str = ...,
        timestamp_seconds: builtins.int = ...,
        operation: builtins.int = ...,
        is_public: builtins.bool = ...,
        message_sender_avatar: builtins.str = ...,
        message_sender_id: builtins.str = ...,
        message_sender_username: builtins.str = ...,
        message_content: builtins.str = ...,
        message_attachment: builtins.str = ...,
        message_created_time: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["channel_id", b"channel_id", "clan_id", b"clan_id", "is_public", b"is_public", "message_attachment", b"message_attachment", "message_content", b"message_content", "message_created_time", b"message_created_time", "message_id", b"message_id", "message_sender_avatar", b"message_sender_avatar", "message_sender_id", b"message_sender_id", "message_sender_username", b"message_sender_username", "mode", b"mode", "operation", b"operation", "timestamp_seconds", b"timestamp_seconds", "user_id", b"user_id"]) -> None: ...

global___LastPinMessageEvent = LastPinMessageEvent

@typing.final
class LastSeenMessageEvent(google.protobuf.message.Message):
    """Last seen message by user"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CLAN_ID_FIELD_NUMBER: builtins.int
    CHANNEL_ID_FIELD_NUMBER: builtins.int
    MESSAGE_ID_FIELD_NUMBER: builtins.int
    MODE_FIELD_NUMBER: builtins.int
    TIMESTAMP_SECONDS_FIELD_NUMBER: builtins.int
    BADGE_COUNT_FIELD_NUMBER: builtins.int
    clan_id: builtins.str
    """The clan id"""
    channel_id: builtins.str
    """The unique ID of this channel."""
    message_id: builtins.str
    """The unique ID of this message."""
    mode: builtins.int
    """The stream mode"""
    timestamp_seconds: builtins.int
    """The timestamp"""
    badge_count: builtins.int
    """"""
    def __init__(
        self,
        *,
        clan_id: builtins.str = ...,
        channel_id: builtins.str = ...,
        message_id: builtins.str = ...,
        mode: builtins.int = ...,
        timestamp_seconds: builtins.int = ...,
        badge_count: builtins.int = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["badge_count", b"badge_count", "channel_id", b"channel_id", "clan_id", b"clan_id", "message_id", b"message_id", "mode", b"mode", "timestamp_seconds", b"timestamp_seconds"]) -> None: ...

global___LastSeenMessageEvent = LastSeenMessageEvent

@typing.final
class MessageTypingEvent(google.protobuf.message.Message):
    """Message typing event data"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CLAN_ID_FIELD_NUMBER: builtins.int
    CHANNEL_ID_FIELD_NUMBER: builtins.int
    SENDER_ID_FIELD_NUMBER: builtins.int
    MODE_FIELD_NUMBER: builtins.int
    IS_PUBLIC_FIELD_NUMBER: builtins.int
    SENDER_USERNAME_FIELD_NUMBER: builtins.int
    SENDER_DISPLAY_NAME_FIELD_NUMBER: builtins.int
    TOPIC_ID_FIELD_NUMBER: builtins.int
    clan_id: builtins.str
    """The clan id"""
    channel_id: builtins.str
    """* The channel this message belongs to."""
    sender_id: builtins.str
    """* Message sender, usually a user ID."""
    mode: builtins.int
    """mode"""
    is_public: builtins.bool
    """is public"""
    sender_username: builtins.str
    """sender username"""
    sender_display_name: builtins.str
    """sender display name"""
    topic_id: builtins.str
    """topic id"""
    def __init__(
        self,
        *,
        clan_id: builtins.str = ...,
        channel_id: builtins.str = ...,
        sender_id: builtins.str = ...,
        mode: builtins.int = ...,
        is_public: builtins.bool = ...,
        sender_username: builtins.str = ...,
        sender_display_name: builtins.str = ...,
        topic_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["channel_id", b"channel_id", "clan_id", b"clan_id", "is_public", b"is_public", "mode", b"mode", "sender_display_name", b"sender_display_name", "sender_id", b"sender_id", "sender_username", b"sender_username", "topic_id", b"topic_id"]) -> None: ...

global___MessageTypingEvent = MessageTypingEvent

@typing.final
class VoiceLeavedEvent(google.protobuf.message.Message):
    """Voice Joined event"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ID_FIELD_NUMBER: builtins.int
    CLAN_ID_FIELD_NUMBER: builtins.int
    VOICE_CHANNEL_ID_FIELD_NUMBER: builtins.int
    VOICE_USER_ID_FIELD_NUMBER: builtins.int
    id: builtins.str
    """id voice"""
    clan_id: builtins.str
    """The unique identifier of the chat clan."""
    voice_channel_id: builtins.str
    """voice channel name"""
    voice_user_id: builtins.str
    """voice user_id"""
    def __init__(
        self,
        *,
        id: builtins.str = ...,
        clan_id: builtins.str = ...,
        voice_channel_id: builtins.str = ...,
        voice_user_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["clan_id", b"clan_id", "id", b"id", "voice_channel_id", b"voice_channel_id", "voice_user_id", b"voice_user_id"]) -> None: ...

global___VoiceLeavedEvent = VoiceLeavedEvent

@typing.final
class VoiceJoinedEvent(google.protobuf.message.Message):
    """Voice Joined event"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CLAN_ID_FIELD_NUMBER: builtins.int
    CLAN_NAME_FIELD_NUMBER: builtins.int
    ID_FIELD_NUMBER: builtins.int
    PARTICIPANT_FIELD_NUMBER: builtins.int
    USER_ID_FIELD_NUMBER: builtins.int
    VOICE_CHANNEL_LABEL_FIELD_NUMBER: builtins.int
    VOICE_CHANNEL_ID_FIELD_NUMBER: builtins.int
    LAST_SCREENSHOT_FIELD_NUMBER: builtins.int
    clan_id: builtins.str
    """* The unique identifier of the chat clan."""
    clan_name: builtins.str
    """The channel name"""
    id: builtins.str
    """id voice"""
    participant: builtins.str
    """voice participant"""
    user_id: builtins.str
    """user id"""
    voice_channel_label: builtins.str
    """voice channel label"""
    voice_channel_id: builtins.str
    """voice channel id"""
    last_screenshot: builtins.str
    """last screenshot"""
    def __init__(
        self,
        *,
        clan_id: builtins.str = ...,
        clan_name: builtins.str = ...,
        id: builtins.str = ...,
        participant: builtins.str = ...,
        user_id: builtins.str = ...,
        voice_channel_label: builtins.str = ...,
        voice_channel_id: builtins.str = ...,
        last_screenshot: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["clan_id", b"clan_id", "clan_name", b"clan_name", "id", b"id", "last_screenshot", b"last_screenshot", "participant", b"participant", "user_id", b"user_id", "voice_channel_id", b"voice_channel_id", "voice_channel_label", b"voice_channel_label"]) -> None: ...

global___VoiceJoinedEvent = VoiceJoinedEvent

@typing.final
class VoiceStartedEvent(google.protobuf.message.Message):
    """Voice start event"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ID_FIELD_NUMBER: builtins.int
    CLAN_ID_FIELD_NUMBER: builtins.int
    VOICE_CHANNEL_ID_FIELD_NUMBER: builtins.int
    id: builtins.str
    """id voice"""
    clan_id: builtins.str
    """The unique identifier of the chat clan."""
    voice_channel_id: builtins.str
    """voice channel name"""
    def __init__(
        self,
        *,
        id: builtins.str = ...,
        clan_id: builtins.str = ...,
        voice_channel_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["clan_id", b"clan_id", "id", b"id", "voice_channel_id", b"voice_channel_id"]) -> None: ...

global___VoiceStartedEvent = VoiceStartedEvent

@typing.final
class VoiceEndedEvent(google.protobuf.message.Message):
    """Voice start event"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ID_FIELD_NUMBER: builtins.int
    CLAN_ID_FIELD_NUMBER: builtins.int
    VOICE_CHANNEL_ID_FIELD_NUMBER: builtins.int
    id: builtins.str
    """id voice"""
    clan_id: builtins.str
    """The unique identifier of the chat clan."""
    voice_channel_id: builtins.str
    """voice channel name"""
    def __init__(
        self,
        *,
        id: builtins.str = ...,
        clan_id: builtins.str = ...,
        voice_channel_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["clan_id", b"clan_id", "id", b"id", "voice_channel_id", b"voice_channel_id"]) -> None: ...

global___VoiceEndedEvent = VoiceEndedEvent

@typing.final
class StreamingLeavedEvent(google.protobuf.message.Message):
    """Streaming Joined event"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ID_FIELD_NUMBER: builtins.int
    CLAN_ID_FIELD_NUMBER: builtins.int
    STREAMING_CHANNEL_ID_FIELD_NUMBER: builtins.int
    STREAMING_USER_ID_FIELD_NUMBER: builtins.int
    id: builtins.str
    """id"""
    clan_id: builtins.str
    """The unique identifier of the chat clan."""
    streaming_channel_id: builtins.str
    """streaming channel name"""
    streaming_user_id: builtins.str
    """streaming user_id"""
    def __init__(
        self,
        *,
        id: builtins.str = ...,
        clan_id: builtins.str = ...,
        streaming_channel_id: builtins.str = ...,
        streaming_user_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["clan_id", b"clan_id", "id", b"id", "streaming_channel_id", b"streaming_channel_id", "streaming_user_id", b"streaming_user_id"]) -> None: ...

global___StreamingLeavedEvent = StreamingLeavedEvent

@typing.final
class StreamingJoinedEvent(google.protobuf.message.Message):
    """Streaming Joined event"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CLAN_ID_FIELD_NUMBER: builtins.int
    CLAN_NAME_FIELD_NUMBER: builtins.int
    ID_FIELD_NUMBER: builtins.int
    PARTICIPANT_FIELD_NUMBER: builtins.int
    USER_ID_FIELD_NUMBER: builtins.int
    STREAMING_CHANNEL_LABEL_FIELD_NUMBER: builtins.int
    STREAMING_CHANNEL_ID_FIELD_NUMBER: builtins.int
    clan_id: builtins.str
    """* The unique identifier of the chat clan."""
    clan_name: builtins.str
    """The channel name"""
    id: builtins.str
    """id streaming"""
    participant: builtins.str
    """streaming participant"""
    user_id: builtins.str
    """user id"""
    streaming_channel_label: builtins.str
    """streaming channel label"""
    streaming_channel_id: builtins.str
    """streaming channel id"""
    def __init__(
        self,
        *,
        clan_id: builtins.str = ...,
        clan_name: builtins.str = ...,
        id: builtins.str = ...,
        participant: builtins.str = ...,
        user_id: builtins.str = ...,
        streaming_channel_label: builtins.str = ...,
        streaming_channel_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["clan_id", b"clan_id", "clan_name", b"clan_name", "id", b"id", "participant", b"participant", "streaming_channel_id", b"streaming_channel_id", "streaming_channel_label", b"streaming_channel_label", "user_id", b"user_id"]) -> None: ...

global___StreamingJoinedEvent = StreamingJoinedEvent

@typing.final
class StreamingStartedEvent(google.protobuf.message.Message):
    """Streaming start event"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CLAN_ID_FIELD_NUMBER: builtins.int
    CHANNEL_ID_FIELD_NUMBER: builtins.int
    STREAMING_URL_FIELD_NUMBER: builtins.int
    IS_STREAMING_FIELD_NUMBER: builtins.int
    clan_id: builtins.str
    """clan id"""
    channel_id: builtins.str
    """channel id"""
    streaming_url: builtins.str
    """stream url"""
    is_streaming: builtins.bool
    """status"""
    def __init__(
        self,
        *,
        clan_id: builtins.str = ...,
        channel_id: builtins.str = ...,
        streaming_url: builtins.str = ...,
        is_streaming: builtins.bool = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["channel_id", b"channel_id", "clan_id", b"clan_id", "is_streaming", b"is_streaming", "streaming_url", b"streaming_url"]) -> None: ...

global___StreamingStartedEvent = StreamingStartedEvent

@typing.final
class StreamingEndedEvent(google.protobuf.message.Message):
    """Streaming start event"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CLAN_ID_FIELD_NUMBER: builtins.int
    CHANNEL_ID_FIELD_NUMBER: builtins.int
    clan_id: builtins.str
    """clan id"""
    channel_id: builtins.str
    """channel id"""
    def __init__(
        self,
        *,
        clan_id: builtins.str = ...,
        channel_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["channel_id", b"channel_id", "clan_id", b"clan_id"]) -> None: ...

global___StreamingEndedEvent = StreamingEndedEvent

@typing.final
class ChannelCreatedEvent(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CLAN_ID_FIELD_NUMBER: builtins.int
    CATEGORY_ID_FIELD_NUMBER: builtins.int
    CREATOR_ID_FIELD_NUMBER: builtins.int
    PARENT_ID_FIELD_NUMBER: builtins.int
    CHANNEL_ID_FIELD_NUMBER: builtins.int
    CHANNEL_LABEL_FIELD_NUMBER: builtins.int
    CHANNEL_PRIVATE_FIELD_NUMBER: builtins.int
    CHANNEL_TYPE_FIELD_NUMBER: builtins.int
    STATUS_FIELD_NUMBER: builtins.int
    APP_ID_FIELD_NUMBER: builtins.int
    CLAN_NAME_FIELD_NUMBER: builtins.int
    clan_id: builtins.str
    """clan id"""
    category_id: builtins.str
    """category"""
    creator_id: builtins.str
    """creator"""
    parent_id: builtins.str
    """parent id"""
    channel_id: builtins.str
    """channel id"""
    channel_label: builtins.str
    """channel label"""
    channel_private: builtins.int
    """channel private"""
    status: builtins.int
    """status"""
    app_id: builtins.str
    """app id"""
    clan_name: builtins.str
    """clan_name"""
    @property
    def channel_type(self) -> google.protobuf.wrappers_pb2.Int32Value:
        """channel type"""

    def __init__(
        self,
        *,
        clan_id: builtins.str = ...,
        category_id: builtins.str = ...,
        creator_id: builtins.str = ...,
        parent_id: builtins.str = ...,
        channel_id: builtins.str = ...,
        channel_label: builtins.str = ...,
        channel_private: builtins.int = ...,
        channel_type: google.protobuf.wrappers_pb2.Int32Value | None = ...,
        status: builtins.int = ...,
        app_id: builtins.str = ...,
        clan_name: builtins.str = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["channel_type", b"channel_type"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["app_id", b"app_id", "category_id", b"category_id", "channel_id", b"channel_id", "channel_label", b"channel_label", "channel_private", b"channel_private", "channel_type", b"channel_type", "clan_id", b"clan_id", "clan_name", b"clan_name", "creator_id", b"creator_id", "parent_id", b"parent_id", "status", b"status"]) -> None: ...

global___ChannelCreatedEvent = ChannelCreatedEvent

@typing.final
class CategoryEvent(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CREATOR_ID_FIELD_NUMBER: builtins.int
    CLAN_ID_FIELD_NUMBER: builtins.int
    CATEGORY_NAME_FIELD_NUMBER: builtins.int
    ID_FIELD_NUMBER: builtins.int
    STATUS_FIELD_NUMBER: builtins.int
    creator_id: builtins.str
    """Category creator"""
    clan_id: builtins.str
    """the Clan that category belong to"""
    category_name: builtins.str
    """Category name"""
    id: builtins.str
    """"""
    status: builtins.int
    """"""
    def __init__(
        self,
        *,
        creator_id: builtins.str = ...,
        clan_id: builtins.str = ...,
        category_name: builtins.str = ...,
        id: builtins.str = ...,
        status: builtins.int = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["category_name", b"category_name", "clan_id", b"clan_id", "creator_id", b"creator_id", "id", b"id", "status", b"status"]) -> None: ...

global___CategoryEvent = CategoryEvent

@typing.final
class RoleEvent(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ROLE_FIELD_NUMBER: builtins.int
    STATUS_FIELD_NUMBER: builtins.int
    USER_ID_FIELD_NUMBER: builtins.int
    USER_ADD_IDS_FIELD_NUMBER: builtins.int
    USER_REMOVE_IDS_FIELD_NUMBER: builtins.int
    ACTIVE_PERMISSION_IDS_FIELD_NUMBER: builtins.int
    REMOVE_PERMISSION_IDS_FIELD_NUMBER: builtins.int
    status: builtins.int
    user_id: builtins.str
    @property
    def role(self) -> api.api_pb2.Role: ...
    @property
    def user_add_ids(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]: ...
    @property
    def user_remove_ids(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]: ...
    @property
    def active_permission_ids(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]: ...
    @property
    def remove_permission_ids(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]: ...
    def __init__(
        self,
        *,
        role: api.api_pb2.Role | None = ...,
        status: builtins.int = ...,
        user_id: builtins.str = ...,
        user_add_ids: collections.abc.Iterable[builtins.str] | None = ...,
        user_remove_ids: collections.abc.Iterable[builtins.str] | None = ...,
        active_permission_ids: collections.abc.Iterable[builtins.str] | None = ...,
        remove_permission_ids: collections.abc.Iterable[builtins.str] | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["role", b"role"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["active_permission_ids", b"active_permission_ids", "remove_permission_ids", b"remove_permission_ids", "role", b"role", "status", b"status", "user_add_ids", b"user_add_ids", "user_id", b"user_id", "user_remove_ids", b"user_remove_ids"]) -> None: ...

global___RoleEvent = RoleEvent

@typing.final
class ChannelDeletedEvent(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CLAN_ID_FIELD_NUMBER: builtins.int
    CATEGORY_ID_FIELD_NUMBER: builtins.int
    PARENT_ID_FIELD_NUMBER: builtins.int
    CHANNEL_ID_FIELD_NUMBER: builtins.int
    DELETOR_FIELD_NUMBER: builtins.int
    clan_id: builtins.str
    """clan id"""
    category_id: builtins.str
    """category"""
    parent_id: builtins.str
    """parent id"""
    channel_id: builtins.str
    """channel id"""
    deletor: builtins.str
    """deletor"""
    def __init__(
        self,
        *,
        clan_id: builtins.str = ...,
        category_id: builtins.str = ...,
        parent_id: builtins.str = ...,
        channel_id: builtins.str = ...,
        deletor: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["category_id", b"category_id", "channel_id", b"channel_id", "clan_id", b"clan_id", "deletor", b"deletor", "parent_id", b"parent_id"]) -> None: ...

global___ChannelDeletedEvent = ChannelDeletedEvent

@typing.final
class ClanDeletedEvent(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CLAN_ID_FIELD_NUMBER: builtins.int
    DELETOR_FIELD_NUMBER: builtins.int
    clan_id: builtins.str
    """clan id"""
    deletor: builtins.str
    """deletor"""
    def __init__(
        self,
        *,
        clan_id: builtins.str = ...,
        deletor: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["clan_id", b"clan_id", "deletor", b"deletor"]) -> None: ...

global___ClanDeletedEvent = ClanDeletedEvent

@typing.final
class StickerCreateEvent(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CLAN_ID_FIELD_NUMBER: builtins.int
    SOURCE_FIELD_NUMBER: builtins.int
    SHORTNAME_FIELD_NUMBER: builtins.int
    CATEGORY_FIELD_NUMBER: builtins.int
    CREATOR_ID_FIELD_NUMBER: builtins.int
    STICKER_ID_FIELD_NUMBER: builtins.int
    LOGO_FIELD_NUMBER: builtins.int
    CLAN_NAME_FIELD_NUMBER: builtins.int
    clan_id: builtins.str
    """clan id"""
    source: builtins.str
    """source"""
    shortname: builtins.str
    """shortname"""
    category: builtins.str
    """category"""
    creator_id: builtins.str
    """creator_id"""
    sticker_id: builtins.str
    """sticker id"""
    logo: builtins.str
    """logo"""
    clan_name: builtins.str
    """clan name"""
    def __init__(
        self,
        *,
        clan_id: builtins.str = ...,
        source: builtins.str = ...,
        shortname: builtins.str = ...,
        category: builtins.str = ...,
        creator_id: builtins.str = ...,
        sticker_id: builtins.str = ...,
        logo: builtins.str = ...,
        clan_name: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["category", b"category", "clan_id", b"clan_id", "clan_name", b"clan_name", "creator_id", b"creator_id", "logo", b"logo", "shortname", b"shortname", "source", b"source", "sticker_id", b"sticker_id"]) -> None: ...

global___StickerCreateEvent = StickerCreateEvent

@typing.final
class StickerUpdateEvent(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    SHORTNAME_FIELD_NUMBER: builtins.int
    STICKER_ID_FIELD_NUMBER: builtins.int
    USER_ID_FIELD_NUMBER: builtins.int
    shortname: builtins.str
    """shortname"""
    sticker_id: builtins.str
    """sticker id"""
    user_id: builtins.str
    """user id update"""
    def __init__(
        self,
        *,
        shortname: builtins.str = ...,
        sticker_id: builtins.str = ...,
        user_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["shortname", b"shortname", "sticker_id", b"sticker_id", "user_id", b"user_id"]) -> None: ...

global___StickerUpdateEvent = StickerUpdateEvent

@typing.final
class StickerDeleteEvent(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    STICKER_ID_FIELD_NUMBER: builtins.int
    USER_ID_FIELD_NUMBER: builtins.int
    sticker_id: builtins.str
    """sticker id"""
    user_id: builtins.str
    """user id delete"""
    def __init__(
        self,
        *,
        sticker_id: builtins.str = ...,
        user_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["sticker_id", b"sticker_id", "user_id", b"user_id"]) -> None: ...

global___StickerDeleteEvent = StickerDeleteEvent

@typing.final
class ChannelUpdatedEvent(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CLAN_ID_FIELD_NUMBER: builtins.int
    CATEGORY_ID_FIELD_NUMBER: builtins.int
    CREATOR_ID_FIELD_NUMBER: builtins.int
    PARENT_ID_FIELD_NUMBER: builtins.int
    CHANNEL_ID_FIELD_NUMBER: builtins.int
    CHANNEL_LABEL_FIELD_NUMBER: builtins.int
    CHANNEL_TYPE_FIELD_NUMBER: builtins.int
    STATUS_FIELD_NUMBER: builtins.int
    MEETING_CODE_FIELD_NUMBER: builtins.int
    IS_ERROR_FIELD_NUMBER: builtins.int
    CHANNEL_PRIVATE_FIELD_NUMBER: builtins.int
    APP_ID_FIELD_NUMBER: builtins.int
    E2EE_FIELD_NUMBER: builtins.int
    TOPIC_FIELD_NUMBER: builtins.int
    AGE_RESTRICTED_FIELD_NUMBER: builtins.int
    ACTIVE_FIELD_NUMBER: builtins.int
    COUNT_MESS_UNREAD_FIELD_NUMBER: builtins.int
    USER_IDS_FIELD_NUMBER: builtins.int
    ROLE_IDS_FIELD_NUMBER: builtins.int
    CHANNEL_AVATAR_FIELD_NUMBER: builtins.int
    clan_id: builtins.str
    """clan id"""
    category_id: builtins.str
    """category"""
    creator_id: builtins.str
    """creator"""
    parent_id: builtins.str
    """parent id"""
    channel_id: builtins.str
    """channel id"""
    channel_label: builtins.str
    """channel label"""
    status: builtins.int
    """status"""
    meeting_code: builtins.str
    """meeting code"""
    is_error: builtins.bool
    """error"""
    channel_private: builtins.bool
    """channel private"""
    app_id: builtins.str
    """app url"""
    e2ee: builtins.int
    """e2ee"""
    topic: builtins.str
    """topic"""
    age_restricted: builtins.int
    """"""
    active: builtins.int
    """"""
    count_mess_unread: builtins.int
    """count message unread"""
    channel_avatar: builtins.str
    """"""
    @property
    def channel_type(self) -> google.protobuf.wrappers_pb2.Int32Value:
        """channel type"""

    @property
    def user_ids(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """The users to add."""

    @property
    def role_ids(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """This is the role that needs to be added to the channel"""

    def __init__(
        self,
        *,
        clan_id: builtins.str = ...,
        category_id: builtins.str = ...,
        creator_id: builtins.str = ...,
        parent_id: builtins.str = ...,
        channel_id: builtins.str = ...,
        channel_label: builtins.str = ...,
        channel_type: google.protobuf.wrappers_pb2.Int32Value | None = ...,
        status: builtins.int = ...,
        meeting_code: builtins.str = ...,
        is_error: builtins.bool = ...,
        channel_private: builtins.bool = ...,
        app_id: builtins.str = ...,
        e2ee: builtins.int = ...,
        topic: builtins.str = ...,
        age_restricted: builtins.int = ...,
        active: builtins.int = ...,
        count_mess_unread: builtins.int = ...,
        user_ids: collections.abc.Iterable[builtins.str] | None = ...,
        role_ids: collections.abc.Iterable[builtins.str] | None = ...,
        channel_avatar: builtins.str = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["channel_type", b"channel_type"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["active", b"active", "age_restricted", b"age_restricted", "app_id", b"app_id", "category_id", b"category_id", "channel_avatar", b"channel_avatar", "channel_id", b"channel_id", "channel_label", b"channel_label", "channel_private", b"channel_private", "channel_type", b"channel_type", "clan_id", b"clan_id", "count_mess_unread", b"count_mess_unread", "creator_id", b"creator_id", "e2ee", b"e2ee", "is_error", b"is_error", "meeting_code", b"meeting_code", "parent_id", b"parent_id", "role_ids", b"role_ids", "status", b"status", "topic", b"topic", "user_ids", b"user_ids"]) -> None: ...

global___ChannelUpdatedEvent = ChannelUpdatedEvent

@typing.final
class StatusUnfollow(google.protobuf.message.Message):
    """Stop receiving status updates for some set of users."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    USER_IDS_FIELD_NUMBER: builtins.int
    @property
    def user_ids(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """Users to unfollow."""

    def __init__(
        self,
        *,
        user_ids: collections.abc.Iterable[builtins.str] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["user_ids", b"user_ids"]) -> None: ...

global___StatusUnfollow = StatusUnfollow

@typing.final
class StatusUpdate(google.protobuf.message.Message):
    """Set the user's own status."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    STATUS_FIELD_NUMBER: builtins.int
    @property
    def status(self) -> google.protobuf.wrappers_pb2.StringValue:
        """Status string to set, if not present the user will appear offline."""

    def __init__(
        self,
        *,
        status: google.protobuf.wrappers_pb2.StringValue | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["status", b"status"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["status", b"status"]) -> None: ...

global___StatusUpdate = StatusUpdate

@typing.final
class Stream(google.protobuf.message.Message):
    """Represents identifying information for a stream."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    MODE_FIELD_NUMBER: builtins.int
    CHANNEL_ID_FIELD_NUMBER: builtins.int
    CLAN_ID_FIELD_NUMBER: builtins.int
    LABEL_FIELD_NUMBER: builtins.int
    mode: builtins.int
    """Mode identifies the type of stream."""
    channel_id: builtins.str
    """Subject is the primary identifier, if any."""
    clan_id: builtins.str
    """Subcontext is a secondary identifier, if any."""
    label: builtins.str
    """The label is an arbitrary identifying string, if the stream has one."""
    def __init__(
        self,
        *,
        mode: builtins.int = ...,
        channel_id: builtins.str = ...,
        clan_id: builtins.str = ...,
        label: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["channel_id", b"channel_id", "clan_id", b"clan_id", "label", b"label", "mode", b"mode"]) -> None: ...

global___Stream = Stream

@typing.final
class StreamData(google.protobuf.message.Message):
    """A data message delivered over a stream."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    STREAM_FIELD_NUMBER: builtins.int
    SENDER_FIELD_NUMBER: builtins.int
    DATA_FIELD_NUMBER: builtins.int
    RELIABLE_FIELD_NUMBER: builtins.int
    data: builtins.str
    """Arbitrary contents of the data message."""
    reliable: builtins.bool
    """True if this data was delivered reliably, false otherwise."""
    @property
    def stream(self) -> global___Stream:
        """The stream this data message relates to."""

    @property
    def sender(self) -> global___UserPresence:
        """The sender, if any."""

    def __init__(
        self,
        *,
        stream: global___Stream | None = ...,
        sender: global___UserPresence | None = ...,
        data: builtins.str = ...,
        reliable: builtins.bool = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["sender", b"sender", "stream", b"stream"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["data", b"data", "reliable", b"reliable", "sender", b"sender", "stream", b"stream"]) -> None: ...

global___StreamData = StreamData

@typing.final
class StreamPresenceEvent(google.protobuf.message.Message):
    """A set of joins and leaves on a particular stream."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    STREAM_FIELD_NUMBER: builtins.int
    JOINS_FIELD_NUMBER: builtins.int
    LEAVES_FIELD_NUMBER: builtins.int
    @property
    def stream(self) -> global___Stream:
        """The stream this event relates to."""

    @property
    def joins(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___UserPresence]:
        """Presences joining the stream as part of this event, if any."""

    @property
    def leaves(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___UserPresence]:
        """Presences leaving the stream as part of this event, if any."""

    def __init__(
        self,
        *,
        stream: global___Stream | None = ...,
        joins: collections.abc.Iterable[global___UserPresence] | None = ...,
        leaves: collections.abc.Iterable[global___UserPresence] | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["stream", b"stream"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["joins", b"joins", "leaves", b"leaves", "stream", b"stream"]) -> None: ...

global___StreamPresenceEvent = StreamPresenceEvent

@typing.final
class UserPresence(google.protobuf.message.Message):
    """A user session associated to a stream, usually through a list operation or a join/leave event."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    USER_ID_FIELD_NUMBER: builtins.int
    SESSION_ID_FIELD_NUMBER: builtins.int
    USERNAME_FIELD_NUMBER: builtins.int
    STATUS_FIELD_NUMBER: builtins.int
    IS_MOBILE_FIELD_NUMBER: builtins.int
    USER_STATUS_FIELD_NUMBER: builtins.int
    user_id: builtins.str
    """The user this presence belongs to."""
    session_id: builtins.str
    """A unique session ID identifying the particular connection, because the user may have many."""
    username: builtins.str
    """The username for display purposes."""
    is_mobile: builtins.bool
    """"""
    user_status: builtins.str
    """user_status"""
    @property
    def status(self) -> google.protobuf.wrappers_pb2.StringValue:
        """A user-set status message for this stream, if applicable."""

    def __init__(
        self,
        *,
        user_id: builtins.str = ...,
        session_id: builtins.str = ...,
        username: builtins.str = ...,
        status: google.protobuf.wrappers_pb2.StringValue | None = ...,
        is_mobile: builtins.bool = ...,
        user_status: builtins.str = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["status", b"status"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["is_mobile", b"is_mobile", "session_id", b"session_id", "status", b"status", "user_id", b"user_id", "user_status", b"user_status", "username", b"username"]) -> None: ...

global___UserPresence = UserPresence

@typing.final
class CustomStatusEvent(google.protobuf.message.Message):
    """A custom status presence"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CLAN_ID_FIELD_NUMBER: builtins.int
    USER_ID_FIELD_NUMBER: builtins.int
    USERNAME_FIELD_NUMBER: builtins.int
    STATUS_FIELD_NUMBER: builtins.int
    TIME_RESET_FIELD_NUMBER: builtins.int
    NO_CLEAR_FIELD_NUMBER: builtins.int
    clan_id: builtins.str
    """the clan id"""
    user_id: builtins.str
    """the user id"""
    username: builtins.str
    """username"""
    status: builtins.str
    """the status"""
    time_reset: builtins.int
    """time reset"""
    no_clear: builtins.bool
    """no clear"""
    def __init__(
        self,
        *,
        clan_id: builtins.str = ...,
        user_id: builtins.str = ...,
        username: builtins.str = ...,
        status: builtins.str = ...,
        time_reset: builtins.int = ...,
        no_clear: builtins.bool = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["clan_id", b"clan_id", "no_clear", b"no_clear", "status", b"status", "time_reset", b"time_reset", "user_id", b"user_id", "username", b"username"]) -> None: ...

global___CustomStatusEvent = CustomStatusEvent

@typing.final
class UserChannelAdded(google.protobuf.message.Message):
    """A event when user is added to channel"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CHANNEL_DESC_FIELD_NUMBER: builtins.int
    USERS_FIELD_NUMBER: builtins.int
    STATUS_FIELD_NUMBER: builtins.int
    CLAN_ID_FIELD_NUMBER: builtins.int
    CALLER_FIELD_NUMBER: builtins.int
    CREATE_TIME_SECOND_FIELD_NUMBER: builtins.int
    ACTIVE_FIELD_NUMBER: builtins.int
    status: builtins.str
    """the custom status"""
    clan_id: builtins.str
    """the clan id"""
    create_time_second: builtins.int
    """"""
    active: builtins.int
    """"""
    @property
    def channel_desc(self) -> api.api_pb2.ChannelDescription:
        """the channel id"""

    @property
    def users(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___UserProfileRedis]:
        """the user"""

    @property
    def caller(self) -> global___UserProfileRedis:
        """"""

    def __init__(
        self,
        *,
        channel_desc: api.api_pb2.ChannelDescription | None = ...,
        users: collections.abc.Iterable[global___UserProfileRedis] | None = ...,
        status: builtins.str = ...,
        clan_id: builtins.str = ...,
        caller: global___UserProfileRedis | None = ...,
        create_time_second: builtins.int = ...,
        active: builtins.int = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["caller", b"caller", "channel_desc", b"channel_desc"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["active", b"active", "caller", b"caller", "channel_desc", b"channel_desc", "clan_id", b"clan_id", "create_time_second", b"create_time_second", "status", b"status", "users", b"users"]) -> None: ...

global___UserChannelAdded = UserChannelAdded

@typing.final
class UserChannelRemoved(google.protobuf.message.Message):
    """"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CHANNEL_ID_FIELD_NUMBER: builtins.int
    USER_IDS_FIELD_NUMBER: builtins.int
    CHANNEL_TYPE_FIELD_NUMBER: builtins.int
    CLAN_ID_FIELD_NUMBER: builtins.int
    BADGE_COUNTS_FIELD_NUMBER: builtins.int
    channel_id: builtins.str
    """the channel id"""
    channel_type: builtins.int
    """the channel type"""
    clan_id: builtins.str
    """the clan_id"""
    @property
    def user_ids(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """the user"""

    @property
    def badge_counts(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.int]: ...
    def __init__(
        self,
        *,
        channel_id: builtins.str = ...,
        user_ids: collections.abc.Iterable[builtins.str] | None = ...,
        channel_type: builtins.int = ...,
        clan_id: builtins.str = ...,
        badge_counts: collections.abc.Iterable[builtins.int] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["badge_counts", b"badge_counts", "channel_id", b"channel_id", "channel_type", b"channel_type", "clan_id", b"clan_id", "user_ids", b"user_ids"]) -> None: ...

global___UserChannelRemoved = UserChannelRemoved

@typing.final
class UserClanRemoved(google.protobuf.message.Message):
    """"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CLAN_ID_FIELD_NUMBER: builtins.int
    USER_IDS_FIELD_NUMBER: builtins.int
    clan_id: builtins.str
    """the clan id"""
    @property
    def user_ids(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """the user"""

    def __init__(
        self,
        *,
        clan_id: builtins.str = ...,
        user_ids: collections.abc.Iterable[builtins.str] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["clan_id", b"clan_id", "user_ids", b"user_ids"]) -> None: ...

global___UserClanRemoved = UserClanRemoved

@typing.final
class ClanUpdatedEvent(google.protobuf.message.Message):
    """clan updated event"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CLAN_ID_FIELD_NUMBER: builtins.int
    CLAN_NAME_FIELD_NUMBER: builtins.int
    LOGO_FIELD_NUMBER: builtins.int
    BANNER_FIELD_NUMBER: builtins.int
    STATUS_FIELD_NUMBER: builtins.int
    IS_ONBOARDING_FIELD_NUMBER: builtins.int
    WELCOME_CHANNEL_ID_FIELD_NUMBER: builtins.int
    ONBOARDING_BANNER_FIELD_NUMBER: builtins.int
    COMMUNITY_BANNER_FIELD_NUMBER: builtins.int
    IS_COMMUNITY_FIELD_NUMBER: builtins.int
    ABOUT_FIELD_NUMBER: builtins.int
    DESCRIPTION_FIELD_NUMBER: builtins.int
    clan_id: builtins.str
    """clan id"""
    clan_name: builtins.str
    """clan name"""
    logo: builtins.str
    """logo"""
    banner: builtins.str
    """banner"""
    status: builtins.int
    """status"""
    is_onboarding: builtins.bool
    """is onboarding"""
    welcome_channel_id: builtins.str
    """welcome channel id"""
    onboarding_banner: builtins.str
    """onboarding_banner."""
    community_banner: builtins.str
    """community banner"""
    is_community: builtins.bool
    """is community"""
    about: builtins.str
    """about"""
    description: builtins.str
    """description"""
    def __init__(
        self,
        *,
        clan_id: builtins.str = ...,
        clan_name: builtins.str = ...,
        logo: builtins.str = ...,
        banner: builtins.str = ...,
        status: builtins.int = ...,
        is_onboarding: builtins.bool = ...,
        welcome_channel_id: builtins.str = ...,
        onboarding_banner: builtins.str = ...,
        community_banner: builtins.str = ...,
        is_community: builtins.bool = ...,
        about: builtins.str = ...,
        description: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["about", b"about", "banner", b"banner", "clan_id", b"clan_id", "clan_name", b"clan_name", "community_banner", b"community_banner", "description", b"description", "is_community", b"is_community", "is_onboarding", b"is_onboarding", "logo", b"logo", "onboarding_banner", b"onboarding_banner", "status", b"status", "welcome_channel_id", b"welcome_channel_id"]) -> None: ...

global___ClanUpdatedEvent = ClanUpdatedEvent

@typing.final
class ClanProfileUpdatedEvent(google.protobuf.message.Message):
    """clan profile updated event"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    USER_ID_FIELD_NUMBER: builtins.int
    CLAN_NICK_FIELD_NUMBER: builtins.int
    CLAN_AVATAR_FIELD_NUMBER: builtins.int
    CLAN_ID_FIELD_NUMBER: builtins.int
    user_id: builtins.str
    """the user id"""
    clan_nick: builtins.str
    """the clan_nick"""
    clan_avatar: builtins.str
    """the avatar"""
    clan_id: builtins.str
    """the clan_id"""
    def __init__(
        self,
        *,
        user_id: builtins.str = ...,
        clan_nick: builtins.str = ...,
        clan_avatar: builtins.str = ...,
        clan_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["clan_avatar", b"clan_avatar", "clan_id", b"clan_id", "clan_nick", b"clan_nick", "user_id", b"user_id"]) -> None: ...

global___ClanProfileUpdatedEvent = ClanProfileUpdatedEvent

@typing.final
class UserProfileUpdatedEvent(google.protobuf.message.Message):
    """user profile updated event"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    USER_ID_FIELD_NUMBER: builtins.int
    DISPLAY_NAME_FIELD_NUMBER: builtins.int
    AVATAR_FIELD_NUMBER: builtins.int
    ABOUT_ME_FIELD_NUMBER: builtins.int
    CHANNEL_ID_FIELD_NUMBER: builtins.int
    CLAN_ID_FIELD_NUMBER: builtins.int
    ENCRYPT_PRIVATE_KEY_FIELD_NUMBER: builtins.int
    user_id: builtins.str
    """the user id"""
    display_name: builtins.str
    """the display_name"""
    avatar: builtins.str
    """the avatar"""
    about_me: builtins.str
    """the about_me"""
    channel_id: builtins.str
    """the channel_id"""
    clan_id: builtins.str
    """the clan_id"""
    encrypt_private_key: builtins.str
    """the encrypt_private_key"""
    def __init__(
        self,
        *,
        user_id: builtins.str = ...,
        display_name: builtins.str = ...,
        avatar: builtins.str = ...,
        about_me: builtins.str = ...,
        channel_id: builtins.str = ...,
        clan_id: builtins.str = ...,
        encrypt_private_key: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["about_me", b"about_me", "avatar", b"avatar", "channel_id", b"channel_id", "clan_id", b"clan_id", "display_name", b"display_name", "encrypt_private_key", b"encrypt_private_key", "user_id", b"user_id"]) -> None: ...

global___UserProfileUpdatedEvent = UserProfileUpdatedEvent

@typing.final
class UserProfileRedis(google.protobuf.message.Message):
    """A event when user is added to channel"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    USER_ID_FIELD_NUMBER: builtins.int
    USERNAME_FIELD_NUMBER: builtins.int
    AVATAR_FIELD_NUMBER: builtins.int
    DISPLAY_NAME_FIELD_NUMBER: builtins.int
    ABOUT_ME_FIELD_NUMBER: builtins.int
    USER_STATUS_FIELD_NUMBER: builtins.int
    STATUS_FIELD_NUMBER: builtins.int
    CREATE_TIME_SECOND_FIELD_NUMBER: builtins.int
    FCM_TOKENS_FIELD_NUMBER: builtins.int
    ONLINE_FIELD_NUMBER: builtins.int
    IS_DISABLED_FIELD_NUMBER: builtins.int
    JOINED_CLANS_FIELD_NUMBER: builtins.int
    PUBKEY_FIELD_NUMBER: builtins.int
    MEZON_ID_FIELD_NUMBER: builtins.int
    APP_TOKEN_FIELD_NUMBER: builtins.int
    APP_URL_FIELD_NUMBER: builtins.int
    IS_BOT_FIELD_NUMBER: builtins.int
    VOIP_TOKEN_FIELD_NUMBER: builtins.int
    user_id: builtins.str
    """User IDs to follow."""
    username: builtins.str
    """Username to follow."""
    avatar: builtins.str
    """Avatar to follow."""
    display_name: builtins.str
    """Display name"""
    about_me: builtins.str
    """about me"""
    user_status: builtins.str
    """user status"""
    status: builtins.str
    """status online, offline, invisible, idle, do not disturb"""
    create_time_second: builtins.int
    """create time"""
    online: builtins.bool
    """isOnline"""
    is_disabled: builtins.bool
    """is disabled"""
    pubkey: builtins.str
    """public key"""
    mezon_id: builtins.str
    """mezon id"""
    app_token: builtins.str
    """app token"""
    app_url: builtins.str
    """app url"""
    is_bot: builtins.bool
    """is bot"""
    voip_token: builtins.str
    """for call DM iOS"""
    @property
    def fcm_tokens(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___FCMTokens]:
        """FCM token"""

    @property
    def joined_clans(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """clans"""

    def __init__(
        self,
        *,
        user_id: builtins.str = ...,
        username: builtins.str = ...,
        avatar: builtins.str = ...,
        display_name: builtins.str = ...,
        about_me: builtins.str = ...,
        user_status: builtins.str = ...,
        status: builtins.str = ...,
        create_time_second: builtins.int = ...,
        fcm_tokens: collections.abc.Iterable[global___FCMTokens] | None = ...,
        online: builtins.bool = ...,
        is_disabled: builtins.bool = ...,
        joined_clans: collections.abc.Iterable[builtins.str] | None = ...,
        pubkey: builtins.str = ...,
        mezon_id: builtins.str = ...,
        app_token: builtins.str = ...,
        app_url: builtins.str = ...,
        is_bot: builtins.bool = ...,
        voip_token: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["about_me", b"about_me", "app_token", b"app_token", "app_url", b"app_url", "avatar", b"avatar", "create_time_second", b"create_time_second", "display_name", b"display_name", "fcm_tokens", b"fcm_tokens", "is_bot", b"is_bot", "is_disabled", b"is_disabled", "joined_clans", b"joined_clans", "mezon_id", b"mezon_id", "online", b"online", "pubkey", b"pubkey", "status", b"status", "user_id", b"user_id", "user_status", b"user_status", "username", b"username", "voip_token", b"voip_token"]) -> None: ...

global___UserProfileRedis = UserProfileRedis

@typing.final
class FCMTokens(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    DEVICE_ID_FIELD_NUMBER: builtins.int
    TOKEN_ID_FIELD_NUMBER: builtins.int
    PLATFORM_FIELD_NUMBER: builtins.int
    device_id: builtins.str
    """deviceID to follow."""
    token_id: builtins.str
    """tokenID to follow."""
    platform: builtins.str
    """platform to follow."""
    def __init__(
        self,
        *,
        device_id: builtins.str = ...,
        token_id: builtins.str = ...,
        platform: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["device_id", b"device_id", "platform", b"platform", "token_id", b"token_id"]) -> None: ...

global___FCMTokens = FCMTokens

@typing.final
class CheckNameExistedEvent(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    NAME_FIELD_NUMBER: builtins.int
    CONDITION_ID_FIELD_NUMBER: builtins.int
    EXIST_FIELD_NUMBER: builtins.int
    TYPE_FIELD_NUMBER: builtins.int
    name: builtins.str
    """name"""
    condition_id: builtins.str
    """condition_id"""
    exist: builtins.bool
    """is exist"""
    type: builtins.int
    """type check"""
    def __init__(
        self,
        *,
        name: builtins.str = ...,
        condition_id: builtins.str = ...,
        exist: builtins.bool = ...,
        type: builtins.int = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["condition_id", b"condition_id", "exist", b"exist", "name", b"name", "type", b"type"]) -> None: ...

global___CheckNameExistedEvent = CheckNameExistedEvent

@typing.final
class NotificationChannelCategorySetting(google.protobuf.message.Message):
    """Notification setting record"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ID_FIELD_NUMBER: builtins.int
    CHANNEL_CATEGORY_LABEL_FIELD_NUMBER: builtins.int
    NOTIFICATION_SETTING_TYPE_FIELD_NUMBER: builtins.int
    CHANNEL_CATEGORY_TITLE_FIELD_NUMBER: builtins.int
    ACTION_FIELD_NUMBER: builtins.int
    id: builtins.str
    """Notification id"""
    channel_category_label: builtins.str
    """"""
    notification_setting_type: builtins.int
    """Notification title"""
    channel_category_title: builtins.str
    """"""
    action: builtins.int
    """"""
    def __init__(
        self,
        *,
        id: builtins.str = ...,
        channel_category_label: builtins.str = ...,
        notification_setting_type: builtins.int = ...,
        channel_category_title: builtins.str = ...,
        action: builtins.int = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["action", b"action", "channel_category_label", b"channel_category_label", "channel_category_title", b"channel_category_title", "id", b"id", "notification_setting_type", b"notification_setting_type"]) -> None: ...

global___NotificationChannelCategorySetting = NotificationChannelCategorySetting

@typing.final
class EventEmoji(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ID_FIELD_NUMBER: builtins.int
    CLAN_ID_FIELD_NUMBER: builtins.int
    SHORT_NAME_FIELD_NUMBER: builtins.int
    SOURCE_FIELD_NUMBER: builtins.int
    CATEGORY_FIELD_NUMBER: builtins.int
    ACTION_FIELD_NUMBER: builtins.int
    USER_ID_FIELD_NUMBER: builtins.int
    LOGO_FIELD_NUMBER: builtins.int
    CLAN_NAME_FIELD_NUMBER: builtins.int
    IS_FOR_SALE_FIELD_NUMBER: builtins.int
    id: builtins.str
    clan_id: builtins.str
    short_name: builtins.str
    source: builtins.str
    category: builtins.str
    action: builtins.int
    user_id: builtins.str
    logo: builtins.str
    clan_name: builtins.str
    is_for_sale: builtins.bool
    def __init__(
        self,
        *,
        id: builtins.str = ...,
        clan_id: builtins.str = ...,
        short_name: builtins.str = ...,
        source: builtins.str = ...,
        category: builtins.str = ...,
        action: builtins.int = ...,
        user_id: builtins.str = ...,
        logo: builtins.str = ...,
        clan_name: builtins.str = ...,
        is_for_sale: builtins.bool = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["action", b"action", "category", b"category", "clan_id", b"clan_id", "clan_name", b"clan_name", "id", b"id", "is_for_sale", b"is_for_sale", "logo", b"logo", "short_name", b"short_name", "source", b"source", "user_id", b"user_id"]) -> None: ...

global___EventEmoji = EventEmoji

@typing.final
class PermissionSetEvent(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CALLER_FIELD_NUMBER: builtins.int
    ROLE_ID_FIELD_NUMBER: builtins.int
    USER_ID_FIELD_NUMBER: builtins.int
    CHANNEL_ID_FIELD_NUMBER: builtins.int
    PERMISSION_UPDATES_FIELD_NUMBER: builtins.int
    caller: builtins.str
    role_id: builtins.str
    user_id: builtins.str
    channel_id: builtins.str
    @property
    def permission_updates(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[api.api_pb2.PermissionUpdate]: ...
    def __init__(
        self,
        *,
        caller: builtins.str = ...,
        role_id: builtins.str = ...,
        user_id: builtins.str = ...,
        channel_id: builtins.str = ...,
        permission_updates: collections.abc.Iterable[api.api_pb2.PermissionUpdate] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["caller", b"caller", "channel_id", b"channel_id", "permission_updates", b"permission_updates", "role_id", b"role_id", "user_id", b"user_id"]) -> None: ...

global___PermissionSetEvent = PermissionSetEvent

@typing.final
class PermissionChangedEvent(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    USER_ID_FIELD_NUMBER: builtins.int
    CHANNEL_ID_FIELD_NUMBER: builtins.int
    ADD_PERMISSIONS_FIELD_NUMBER: builtins.int
    REMOVE_PERMISSIONS_FIELD_NUMBER: builtins.int
    DEFAULT_PERMISSIONS_FIELD_NUMBER: builtins.int
    user_id: builtins.str
    channel_id: builtins.str
    @property
    def add_permissions(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[api.api_pb2.PermissionUpdate]: ...
    @property
    def remove_permissions(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[api.api_pb2.PermissionUpdate]: ...
    @property
    def default_permissions(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[api.api_pb2.PermissionUpdate]: ...
    def __init__(
        self,
        *,
        user_id: builtins.str = ...,
        channel_id: builtins.str = ...,
        add_permissions: collections.abc.Iterable[api.api_pb2.PermissionUpdate] | None = ...,
        remove_permissions: collections.abc.Iterable[api.api_pb2.PermissionUpdate] | None = ...,
        default_permissions: collections.abc.Iterable[api.api_pb2.PermissionUpdate] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["add_permissions", b"add_permissions", "channel_id", b"channel_id", "default_permissions", b"default_permissions", "remove_permissions", b"remove_permissions", "user_id", b"user_id"]) -> None: ...

global___PermissionChangedEvent = PermissionChangedEvent

@typing.final
class MessageButtonClicked(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    MESSAGE_ID_FIELD_NUMBER: builtins.int
    CHANNEL_ID_FIELD_NUMBER: builtins.int
    BUTTON_ID_FIELD_NUMBER: builtins.int
    SENDER_ID_FIELD_NUMBER: builtins.int
    USER_ID_FIELD_NUMBER: builtins.int
    EXTRA_DATA_FIELD_NUMBER: builtins.int
    message_id: builtins.str
    channel_id: builtins.str
    button_id: builtins.str
    sender_id: builtins.str
    user_id: builtins.str
    extra_data: builtins.str
    def __init__(
        self,
        *,
        message_id: builtins.str = ...,
        channel_id: builtins.str = ...,
        button_id: builtins.str = ...,
        sender_id: builtins.str = ...,
        user_id: builtins.str = ...,
        extra_data: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["button_id", b"button_id", "channel_id", b"channel_id", "extra_data", b"extra_data", "message_id", b"message_id", "sender_id", b"sender_id", "user_id", b"user_id"]) -> None: ...

global___MessageButtonClicked = MessageButtonClicked

@typing.final
class UnmuteEvent(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CHANNEL_ID_FIELD_NUMBER: builtins.int
    CATEGORY_ID_FIELD_NUMBER: builtins.int
    CLAN_ID_FIELD_NUMBER: builtins.int
    channel_id: builtins.str
    """channel id"""
    category_id: builtins.str
    """category id"""
    clan_id: builtins.str
    """clan id"""
    def __init__(
        self,
        *,
        channel_id: builtins.str = ...,
        category_id: builtins.str = ...,
        clan_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["category_id", b"category_id", "channel_id", b"channel_id", "clan_id", b"clan_id"]) -> None: ...

global___UnmuteEvent = UnmuteEvent

@typing.final
class ListActivity(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ACTS_FIELD_NUMBER: builtins.int
    @property
    def acts(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[api.api_pb2.UserActivity]: ...
    def __init__(
        self,
        *,
        acts: collections.abc.Iterable[api.api_pb2.UserActivity] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["acts", b"acts"]) -> None: ...

global___ListActivity = ListActivity

@typing.final
class DropdownBoxSelected(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    MESSAGE_ID_FIELD_NUMBER: builtins.int
    CHANNEL_ID_FIELD_NUMBER: builtins.int
    SELECTBOX_ID_FIELD_NUMBER: builtins.int
    SENDER_ID_FIELD_NUMBER: builtins.int
    USER_ID_FIELD_NUMBER: builtins.int
    VALUES_FIELD_NUMBER: builtins.int
    message_id: builtins.str
    channel_id: builtins.str
    selectbox_id: builtins.str
    sender_id: builtins.str
    user_id: builtins.str
    @property
    def values(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]: ...
    def __init__(
        self,
        *,
        message_id: builtins.str = ...,
        channel_id: builtins.str = ...,
        selectbox_id: builtins.str = ...,
        sender_id: builtins.str = ...,
        user_id: builtins.str = ...,
        values: collections.abc.Iterable[builtins.str] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["channel_id", b"channel_id", "message_id", b"message_id", "selectbox_id", b"selectbox_id", "sender_id", b"sender_id", "user_id", b"user_id", "values", b"values"]) -> None: ...

global___DropdownBoxSelected = DropdownBoxSelected

@typing.final
class SdTopicEvent(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ID_FIELD_NUMBER: builtins.int
    CLAN_ID_FIELD_NUMBER: builtins.int
    CHANNEL_ID_FIELD_NUMBER: builtins.int
    MESSAGE_ID_FIELD_NUMBER: builtins.int
    USER_ID_FIELD_NUMBER: builtins.int
    LAST_SENT_MESSAGE_FIELD_NUMBER: builtins.int
    MESSAGE_FIELD_NUMBER: builtins.int
    id: builtins.str
    clan_id: builtins.str
    channel_id: builtins.str
    message_id: builtins.str
    user_id: builtins.str
    @property
    def last_sent_message(self) -> api.api_pb2.ChannelMessageHeader: ...
    @property
    def message(self) -> api.api_pb2.ChannelMessage: ...
    def __init__(
        self,
        *,
        id: builtins.str = ...,
        clan_id: builtins.str = ...,
        channel_id: builtins.str = ...,
        message_id: builtins.str = ...,
        user_id: builtins.str = ...,
        last_sent_message: api.api_pb2.ChannelMessageHeader | None = ...,
        message: api.api_pb2.ChannelMessage | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["last_sent_message", b"last_sent_message", "message", b"message"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["channel_id", b"channel_id", "clan_id", b"clan_id", "id", b"id", "last_sent_message", b"last_sent_message", "message", b"message", "message_id", b"message_id", "user_id", b"user_id"]) -> None: ...

global___SdTopicEvent = SdTopicEvent

@typing.final
class ChannelAppEvent(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    USER_ID_FIELD_NUMBER: builtins.int
    USERNAME_FIELD_NUMBER: builtins.int
    CLAN_ID_FIELD_NUMBER: builtins.int
    CHANNEL_ID_FIELD_NUMBER: builtins.int
    ACTION_FIELD_NUMBER: builtins.int
    user_id: builtins.str
    username: builtins.str
    clan_id: builtins.str
    channel_id: builtins.str
    action: builtins.int
    def __init__(
        self,
        *,
        user_id: builtins.str = ...,
        username: builtins.str = ...,
        clan_id: builtins.str = ...,
        channel_id: builtins.str = ...,
        action: builtins.int = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["action", b"action", "channel_id", b"channel_id", "clan_id", b"clan_id", "user_id", b"user_id", "username", b"username"]) -> None: ...

global___ChannelAppEvent = ChannelAppEvent

@typing.final
class UserStatusEvent(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    USER_ID_FIELD_NUMBER: builtins.int
    CUSTOM_STATUS_FIELD_NUMBER: builtins.int
    user_id: builtins.str
    custom_status: builtins.str
    def __init__(
        self,
        *,
        user_id: builtins.str = ...,
        custom_status: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["custom_status", b"custom_status", "user_id", b"user_id"]) -> None: ...

global___UserStatusEvent = UserStatusEvent

@typing.final
class JoinChannelAppData(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    USER_ID_FIELD_NUMBER: builtins.int
    USERNAME_FIELD_NUMBER: builtins.int
    HASH_FIELD_NUMBER: builtins.int
    user_id: builtins.str
    username: builtins.str
    hash: builtins.str
    def __init__(
        self,
        *,
        user_id: builtins.str = ...,
        username: builtins.str = ...,
        hash: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["hash", b"hash", "user_id", b"user_id", "username", b"username"]) -> None: ...

global___JoinChannelAppData = JoinChannelAppData

@typing.final
class UnpinMessageEvent(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ID_FIELD_NUMBER: builtins.int
    MESSAGE_ID_FIELD_NUMBER: builtins.int
    CHANNEL_ID_FIELD_NUMBER: builtins.int
    CLAN_ID_FIELD_NUMBER: builtins.int
    id: builtins.str
    message_id: builtins.str
    channel_id: builtins.str
    clan_id: builtins.str
    def __init__(
        self,
        *,
        id: builtins.str = ...,
        message_id: builtins.str = ...,
        channel_id: builtins.str = ...,
        clan_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["channel_id", b"channel_id", "clan_id", b"clan_id", "id", b"id", "message_id", b"message_id"]) -> None: ...

global___UnpinMessageEvent = UnpinMessageEvent

@typing.final
class HandleParticipantMeetStateEvent(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CLAN_ID_FIELD_NUMBER: builtins.int
    CHANNEL_ID_FIELD_NUMBER: builtins.int
    DISPLAY_NAME_FIELD_NUMBER: builtins.int
    STATE_FIELD_NUMBER: builtins.int
    ROOM_NAME_FIELD_NUMBER: builtins.int
    clan_id: builtins.str
    """clan id"""
    channel_id: builtins.str
    """channel id"""
    display_name: builtins.str
    """display name"""
    state: builtins.int
    """state (0: join, 1: leave)"""
    room_name: builtins.str
    """room name"""
    def __init__(
        self,
        *,
        clan_id: builtins.str = ...,
        channel_id: builtins.str = ...,
        display_name: builtins.str = ...,
        state: builtins.int = ...,
        room_name: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["channel_id", b"channel_id", "clan_id", b"clan_id", "display_name", b"display_name", "room_name", b"room_name", "state", b"state"]) -> None: ...

global___HandleParticipantMeetStateEvent = HandleParticipantMeetStateEvent

@typing.final
class DeleteAccountEvent(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    USER_ID_FIELD_NUMBER: builtins.int
    user_id: builtins.str
    """user id"""
    def __init__(
        self,
        *,
        user_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["user_id", b"user_id"]) -> None: ...

global___DeleteAccountEvent = DeleteAccountEvent

@typing.final
class ListDataSocket(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    API_NAME_FIELD_NUMBER: builtins.int
    LIST_CLAN_REQ_FIELD_NUMBER: builtins.int
    CLAN_DESC_LIST_FIELD_NUMBER: builtins.int
    LIST_THREAD_REQ_FIELD_NUMBER: builtins.int
    CHANNEL_DESC_LIST_FIELD_NUMBER: builtins.int
    LIST_CHANNEL_USERS_UC_REQ_FIELD_NUMBER: builtins.int
    CHANNEL_USERS_UC_LIST_FIELD_NUMBER: builtins.int
    LIST_CHANNEL_DETAIL_REQ_FIELD_NUMBER: builtins.int
    CHANNEL_DESC_FIELD_NUMBER: builtins.int
    LIST_CHANNEL_REQ_FIELD_NUMBER: builtins.int
    LIST_CHANNEL_MESSAGE_REQ_FIELD_NUMBER: builtins.int
    CHANNEL_MESSAGE_LIST_FIELD_NUMBER: builtins.int
    LIST_CHANNEL_USERS_REQ_FIELD_NUMBER: builtins.int
    VOICE_USER_LIST_FIELD_NUMBER: builtins.int
    CHANNEL_USER_LIST_FIELD_NUMBER: builtins.int
    LIST_CHANNEL_ATTACHMENT_REQ_FIELD_NUMBER: builtins.int
    CHANNEL_ATTACHMENT_LIST_FIELD_NUMBER: builtins.int
    HASHTAG_DM_REQ_FIELD_NUMBER: builtins.int
    HASHTAG_DM_LIST_FIELD_NUMBER: builtins.int
    CHANNEL_SETTING_REQ_FIELD_NUMBER: builtins.int
    CHANNEL_SETTING_LIST_FIELD_NUMBER: builtins.int
    FAVORITE_CHANNEL_REQ_FIELD_NUMBER: builtins.int
    FAVORITE_CHANNEL_LIST_FIELD_NUMBER: builtins.int
    SEARCH_THREAD_REQ_FIELD_NUMBER: builtins.int
    NOTIFICATION_CHANNEL_FIELD_NUMBER: builtins.int
    NOTIFICAION_USER_CHANNEL_FIELD_NUMBER: builtins.int
    NOTIFICATION_CATEGORY_FIELD_NUMBER: builtins.int
    NOTIFICATION_CLAN_FIELD_NUMBER: builtins.int
    NOTIFICATION_SETTING_FIELD_NUMBER: builtins.int
    NOTIFICATION_MESSAGE_FIELD_NUMBER: builtins.int
    NOTI_CHANNEL_CAT_SETTING_LIST_FIELD_NUMBER: builtins.int
    LIST_NOTIFICATION_REQ_FIELD_NUMBER: builtins.int
    NOTIFICATION_LIST_FIELD_NUMBER: builtins.int
    STICKER_LIST_FIELD_NUMBER: builtins.int
    EMOJI_RECENT_LIST_FIELD_NUMBER: builtins.int
    CLAN_WEBHOOK_REQ_FIELD_NUMBER: builtins.int
    CLAN_WEBHOOK_LIST_FIELD_NUMBER: builtins.int
    WEBHOOK_LIST_REQ_FIELD_NUMBER: builtins.int
    WEBHOOK_LIST_FIELD_NUMBER: builtins.int
    PERMISSION_LIST_REQ_FIELD_NUMBER: builtins.int
    PERMISSION_LIST_FIELD_NUMBER: builtins.int
    ROLE_USER_REQ_FIELD_NUMBER: builtins.int
    ROLE_USER_LIST_FIELD_NUMBER: builtins.int
    PERMISSION_USER_REQ_FIELD_NUMBER: builtins.int
    ROLE_LIST_FIELD_NUMBER: builtins.int
    ROLE_LIST_EVENT_REQ_FIELD_NUMBER: builtins.int
    ROLE_EVENT_LIST_FIELD_NUMBER: builtins.int
    USER_PERMISSION_REQ_FIELD_NUMBER: builtins.int
    USER_PERMISSION_LIST_FIELD_NUMBER: builtins.int
    PERMISSION_ROLE_REQ_FIELD_NUMBER: builtins.int
    PERMISSION_ROLE_LIST_FIELD_NUMBER: builtins.int
    EMOJI_LIST_FIELD_NUMBER: builtins.int
    LIST_FRIEND_REQ_FIELD_NUMBER: builtins.int
    FRIEND_LIST_FIELD_NUMBER: builtins.int
    LIST_APPS_REQ_FIELD_NUMBER: builtins.int
    CHANNEL_APPS_LIST_FIELD_NUMBER: builtins.int
    USER_ACTIVITY_LIST_FIELD_NUMBER: builtins.int
    LIST_CLAN_USER_REQ_FIELD_NUMBER: builtins.int
    CLAN_USER_LIST_FIELD_NUMBER: builtins.int
    LIST_EVENT_REQ_FIELD_NUMBER: builtins.int
    EVENT_LIST_FIELD_NUMBER: builtins.int
    LIST_CATEGORY_REQ_FIELD_NUMBER: builtins.int
    CATEGORY_LIST_FIELD_NUMBER: builtins.int
    STREAM_USER_LIST_FIELD_NUMBER: builtins.int
    LIST_UNREAD_MSG_INDICATOR_REQ_FIELD_NUMBER: builtins.int
    UNREAD_MSG_INDICATOR_FIELD_NUMBER: builtins.int
    api_name: builtins.str
    @property
    def list_clan_req(self) -> api.api_pb2.ListClanDescRequest: ...
    @property
    def clan_desc_list(self) -> api.api_pb2.ClanDescList: ...
    @property
    def list_thread_req(self) -> api.api_pb2.ListThreadRequest: ...
    @property
    def channel_desc_list(self) -> api.api_pb2.ChannelDescList: ...
    @property
    def list_channel_users_uc_req(self) -> api.api_pb2.AllUsersAddChannelRequest: ...
    @property
    def channel_users_uc_list(self) -> api.api_pb2.AllUsersAddChannelResponse: ...
    @property
    def list_channel_detail_req(self) -> api.api_pb2.ListChannelDetailRequest: ...
    @property
    def channel_desc(self) -> api.api_pb2.ChannelDescription: ...
    @property
    def list_channel_req(self) -> api.api_pb2.ListChannelDescsRequest: ...
    @property
    def list_channel_message_req(self) -> api.api_pb2.ListChannelMessagesRequest: ...
    @property
    def channel_message_list(self) -> api.api_pb2.ChannelMessageList: ...
    @property
    def list_channel_users_req(self) -> api.api_pb2.ListChannelUsersRequest: ...
    @property
    def voice_user_list(self) -> api.api_pb2.VoiceChannelUserList: ...
    @property
    def channel_user_list(self) -> api.api_pb2.ChannelUserList: ...
    @property
    def list_channel_attachment_req(self) -> api.api_pb2.ListChannelAttachmentRequest: ...
    @property
    def channel_attachment_list(self) -> api.api_pb2.ChannelAttachmentList: ...
    @property
    def hashtag_dm_req(self) -> api.api_pb2.HashtagDmListRequest: ...
    @property
    def hashtag_dm_list(self) -> api.api_pb2.HashtagDmList: ...
    @property
    def channel_setting_req(self) -> api.api_pb2.ChannelSettingListRequest: ...
    @property
    def channel_setting_list(self) -> api.api_pb2.ChannelSettingListResponse: ...
    @property
    def favorite_channel_req(self) -> api.api_pb2.ListFavoriteChannelRequest: ...
    @property
    def favorite_channel_list(self) -> api.api_pb2.ListFavoriteChannelResponse: ...
    @property
    def search_thread_req(self) -> api.api_pb2.SearchThreadRequest: ...
    @property
    def notification_channel(self) -> api.api_pb2.NotificationChannel: ...
    @property
    def notificaion_user_channel(self) -> api.api_pb2.NotificationUserChannel: ...
    @property
    def notification_category(self) -> api.api_pb2.DefaultNotificationCategory: ...
    @property
    def notification_clan(self) -> api.api_pb2.NotificationClan: ...
    @property
    def notification_setting(self) -> api.api_pb2.NotificationSetting: ...
    @property
    def notification_message(self) -> api.api_pb2.NotifiReactMessage: ...
    @property
    def noti_channel_cat_setting_list(self) -> api.api_pb2.NotificationChannelCategorySettingList: ...
    @property
    def list_notification_req(self) -> api.api_pb2.ListNotificationsRequest: ...
    @property
    def notification_list(self) -> api.api_pb2.NotificationList: ...
    @property
    def sticker_list(self) -> api.api_pb2.StickerListedResponse: ...
    @property
    def emoji_recent_list(self) -> api.api_pb2.EmojiRecentList: ...
    @property
    def clan_webhook_req(self) -> api.api_pb2.ListClanWebhookRequest: ...
    @property
    def clan_webhook_list(self) -> api.api_pb2.ListClanWebhookResponse: ...
    @property
    def webhook_list_req(self) -> api.api_pb2.WebhookListRequest: ...
    @property
    def webhook_list(self) -> api.api_pb2.WebhookListResponse: ...
    @property
    def permission_list_req(self) -> api.api_pb2.ListPermissionsRequest: ...
    @property
    def permission_list(self) -> api.api_pb2.PermissionList: ...
    @property
    def role_user_req(self) -> api.api_pb2.ListRoleUsersRequest: ...
    @property
    def role_user_list(self) -> api.api_pb2.RoleUserList: ...
    @property
    def permission_user_req(self) -> api.api_pb2.ListPermissionOfUsersRequest: ...
    @property
    def role_list(self) -> api.api_pb2.RoleList: ...
    @property
    def role_list_event_req(self) -> api.api_pb2.RoleListEventRequest: ...
    @property
    def role_event_list(self) -> api.api_pb2.RoleListEventResponse: ...
    @property
    def user_permission_req(self) -> api.api_pb2.UserPermissionInChannelListRequest: ...
    @property
    def user_permission_list(self) -> api.api_pb2.UserPermissionInChannelListResponse: ...
    @property
    def permission_role_req(self) -> api.api_pb2.PermissionRoleChannelListEventRequest: ...
    @property
    def permission_role_list(self) -> api.api_pb2.PermissionRoleChannelListEventResponse: ...
    @property
    def emoji_list(self) -> api.api_pb2.EmojiListedResponse: ...
    @property
    def list_friend_req(self) -> api.api_pb2.ListFriendsRequest: ...
    @property
    def friend_list(self) -> api.api_pb2.FriendList: ...
    @property
    def list_apps_req(self) -> api.api_pb2.ListChannelAppsRequest: ...
    @property
    def channel_apps_list(self) -> api.api_pb2.ListChannelAppsResponse: ...
    @property
    def user_activity_list(self) -> api.api_pb2.ListUserActivity: ...
    @property
    def list_clan_user_req(self) -> api.api_pb2.ListClanUsersRequest: ...
    @property
    def clan_user_list(self) -> api.api_pb2.ClanUserList: ...
    @property
    def list_event_req(self) -> api.api_pb2.ListEventsRequest: ...
    @property
    def event_list(self) -> api.api_pb2.EventList: ...
    @property
    def list_category_req(self) -> api.api_pb2.CategoryDesc: ...
    @property
    def category_list(self) -> api.api_pb2.CategoryDescList: ...
    @property
    def stream_user_list(self) -> api.api_pb2.StreamingChannelUserList: ...
    @property
    def list_unread_msg_indicator_req(self) -> api.api_pb2.ListClanUnreadMsgIndicatorRequest: ...
    @property
    def unread_msg_indicator(self) -> api.api_pb2.ListClanUnreadMsgIndicatorResponse: ...
    def __init__(
        self,
        *,
        api_name: builtins.str = ...,
        list_clan_req: api.api_pb2.ListClanDescRequest | None = ...,
        clan_desc_list: api.api_pb2.ClanDescList | None = ...,
        list_thread_req: api.api_pb2.ListThreadRequest | None = ...,
        channel_desc_list: api.api_pb2.ChannelDescList | None = ...,
        list_channel_users_uc_req: api.api_pb2.AllUsersAddChannelRequest | None = ...,
        channel_users_uc_list: api.api_pb2.AllUsersAddChannelResponse | None = ...,
        list_channel_detail_req: api.api_pb2.ListChannelDetailRequest | None = ...,
        channel_desc: api.api_pb2.ChannelDescription | None = ...,
        list_channel_req: api.api_pb2.ListChannelDescsRequest | None = ...,
        list_channel_message_req: api.api_pb2.ListChannelMessagesRequest | None = ...,
        channel_message_list: api.api_pb2.ChannelMessageList | None = ...,
        list_channel_users_req: api.api_pb2.ListChannelUsersRequest | None = ...,
        voice_user_list: api.api_pb2.VoiceChannelUserList | None = ...,
        channel_user_list: api.api_pb2.ChannelUserList | None = ...,
        list_channel_attachment_req: api.api_pb2.ListChannelAttachmentRequest | None = ...,
        channel_attachment_list: api.api_pb2.ChannelAttachmentList | None = ...,
        hashtag_dm_req: api.api_pb2.HashtagDmListRequest | None = ...,
        hashtag_dm_list: api.api_pb2.HashtagDmList | None = ...,
        channel_setting_req: api.api_pb2.ChannelSettingListRequest | None = ...,
        channel_setting_list: api.api_pb2.ChannelSettingListResponse | None = ...,
        favorite_channel_req: api.api_pb2.ListFavoriteChannelRequest | None = ...,
        favorite_channel_list: api.api_pb2.ListFavoriteChannelResponse | None = ...,
        search_thread_req: api.api_pb2.SearchThreadRequest | None = ...,
        notification_channel: api.api_pb2.NotificationChannel | None = ...,
        notificaion_user_channel: api.api_pb2.NotificationUserChannel | None = ...,
        notification_category: api.api_pb2.DefaultNotificationCategory | None = ...,
        notification_clan: api.api_pb2.NotificationClan | None = ...,
        notification_setting: api.api_pb2.NotificationSetting | None = ...,
        notification_message: api.api_pb2.NotifiReactMessage | None = ...,
        noti_channel_cat_setting_list: api.api_pb2.NotificationChannelCategorySettingList | None = ...,
        list_notification_req: api.api_pb2.ListNotificationsRequest | None = ...,
        notification_list: api.api_pb2.NotificationList | None = ...,
        sticker_list: api.api_pb2.StickerListedResponse | None = ...,
        emoji_recent_list: api.api_pb2.EmojiRecentList | None = ...,
        clan_webhook_req: api.api_pb2.ListClanWebhookRequest | None = ...,
        clan_webhook_list: api.api_pb2.ListClanWebhookResponse | None = ...,
        webhook_list_req: api.api_pb2.WebhookListRequest | None = ...,
        webhook_list: api.api_pb2.WebhookListResponse | None = ...,
        permission_list_req: api.api_pb2.ListPermissionsRequest | None = ...,
        permission_list: api.api_pb2.PermissionList | None = ...,
        role_user_req: api.api_pb2.ListRoleUsersRequest | None = ...,
        role_user_list: api.api_pb2.RoleUserList | None = ...,
        permission_user_req: api.api_pb2.ListPermissionOfUsersRequest | None = ...,
        role_list: api.api_pb2.RoleList | None = ...,
        role_list_event_req: api.api_pb2.RoleListEventRequest | None = ...,
        role_event_list: api.api_pb2.RoleListEventResponse | None = ...,
        user_permission_req: api.api_pb2.UserPermissionInChannelListRequest | None = ...,
        user_permission_list: api.api_pb2.UserPermissionInChannelListResponse | None = ...,
        permission_role_req: api.api_pb2.PermissionRoleChannelListEventRequest | None = ...,
        permission_role_list: api.api_pb2.PermissionRoleChannelListEventResponse | None = ...,
        emoji_list: api.api_pb2.EmojiListedResponse | None = ...,
        list_friend_req: api.api_pb2.ListFriendsRequest | None = ...,
        friend_list: api.api_pb2.FriendList | None = ...,
        list_apps_req: api.api_pb2.ListChannelAppsRequest | None = ...,
        channel_apps_list: api.api_pb2.ListChannelAppsResponse | None = ...,
        user_activity_list: api.api_pb2.ListUserActivity | None = ...,
        list_clan_user_req: api.api_pb2.ListClanUsersRequest | None = ...,
        clan_user_list: api.api_pb2.ClanUserList | None = ...,
        list_event_req: api.api_pb2.ListEventsRequest | None = ...,
        event_list: api.api_pb2.EventList | None = ...,
        list_category_req: api.api_pb2.CategoryDesc | None = ...,
        category_list: api.api_pb2.CategoryDescList | None = ...,
        stream_user_list: api.api_pb2.StreamingChannelUserList | None = ...,
        list_unread_msg_indicator_req: api.api_pb2.ListClanUnreadMsgIndicatorRequest | None = ...,
        unread_msg_indicator: api.api_pb2.ListClanUnreadMsgIndicatorResponse | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["category_list", b"category_list", "channel_apps_list", b"channel_apps_list", "channel_attachment_list", b"channel_attachment_list", "channel_desc", b"channel_desc", "channel_desc_list", b"channel_desc_list", "channel_message_list", b"channel_message_list", "channel_setting_list", b"channel_setting_list", "channel_setting_req", b"channel_setting_req", "channel_user_list", b"channel_user_list", "channel_users_uc_list", b"channel_users_uc_list", "clan_desc_list", b"clan_desc_list", "clan_user_list", b"clan_user_list", "clan_webhook_list", b"clan_webhook_list", "clan_webhook_req", b"clan_webhook_req", "emoji_list", b"emoji_list", "emoji_recent_list", b"emoji_recent_list", "event_list", b"event_list", "favorite_channel_list", b"favorite_channel_list", "favorite_channel_req", b"favorite_channel_req", "friend_list", b"friend_list", "hashtag_dm_list", b"hashtag_dm_list", "hashtag_dm_req", b"hashtag_dm_req", "list_apps_req", b"list_apps_req", "list_category_req", b"list_category_req", "list_channel_attachment_req", b"list_channel_attachment_req", "list_channel_detail_req", b"list_channel_detail_req", "list_channel_message_req", b"list_channel_message_req", "list_channel_req", b"list_channel_req", "list_channel_users_req", b"list_channel_users_req", "list_channel_users_uc_req", b"list_channel_users_uc_req", "list_clan_req", b"list_clan_req", "list_clan_user_req", b"list_clan_user_req", "list_event_req", b"list_event_req", "list_friend_req", b"list_friend_req", "list_notification_req", b"list_notification_req", "list_thread_req", b"list_thread_req", "list_unread_msg_indicator_req", b"list_unread_msg_indicator_req", "noti_channel_cat_setting_list", b"noti_channel_cat_setting_list", "notificaion_user_channel", b"notificaion_user_channel", "notification_category", b"notification_category", "notification_channel", b"notification_channel", "notification_clan", b"notification_clan", "notification_list", b"notification_list", "notification_message", b"notification_message", "notification_setting", b"notification_setting", "permission_list", b"permission_list", "permission_list_req", b"permission_list_req", "permission_role_list", b"permission_role_list", "permission_role_req", b"permission_role_req", "permission_user_req", b"permission_user_req", "role_event_list", b"role_event_list", "role_list", b"role_list", "role_list_event_req", b"role_list_event_req", "role_user_list", b"role_user_list", "role_user_req", b"role_user_req", "search_thread_req", b"search_thread_req", "sticker_list", b"sticker_list", "stream_user_list", b"stream_user_list", "unread_msg_indicator", b"unread_msg_indicator", "user_activity_list", b"user_activity_list", "user_permission_list", b"user_permission_list", "user_permission_req", b"user_permission_req", "voice_user_list", b"voice_user_list", "webhook_list", b"webhook_list", "webhook_list_req", b"webhook_list_req"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["api_name", b"api_name", "category_list", b"category_list", "channel_apps_list", b"channel_apps_list", "channel_attachment_list", b"channel_attachment_list", "channel_desc", b"channel_desc", "channel_desc_list", b"channel_desc_list", "channel_message_list", b"channel_message_list", "channel_setting_list", b"channel_setting_list", "channel_setting_req", b"channel_setting_req", "channel_user_list", b"channel_user_list", "channel_users_uc_list", b"channel_users_uc_list", "clan_desc_list", b"clan_desc_list", "clan_user_list", b"clan_user_list", "clan_webhook_list", b"clan_webhook_list", "clan_webhook_req", b"clan_webhook_req", "emoji_list", b"emoji_list", "emoji_recent_list", b"emoji_recent_list", "event_list", b"event_list", "favorite_channel_list", b"favorite_channel_list", "favorite_channel_req", b"favorite_channel_req", "friend_list", b"friend_list", "hashtag_dm_list", b"hashtag_dm_list", "hashtag_dm_req", b"hashtag_dm_req", "list_apps_req", b"list_apps_req", "list_category_req", b"list_category_req", "list_channel_attachment_req", b"list_channel_attachment_req", "list_channel_detail_req", b"list_channel_detail_req", "list_channel_message_req", b"list_channel_message_req", "list_channel_req", b"list_channel_req", "list_channel_users_req", b"list_channel_users_req", "list_channel_users_uc_req", b"list_channel_users_uc_req", "list_clan_req", b"list_clan_req", "list_clan_user_req", b"list_clan_user_req", "list_event_req", b"list_event_req", "list_friend_req", b"list_friend_req", "list_notification_req", b"list_notification_req", "list_thread_req", b"list_thread_req", "list_unread_msg_indicator_req", b"list_unread_msg_indicator_req", "noti_channel_cat_setting_list", b"noti_channel_cat_setting_list", "notificaion_user_channel", b"notificaion_user_channel", "notification_category", b"notification_category", "notification_channel", b"notification_channel", "notification_clan", b"notification_clan", "notification_list", b"notification_list", "notification_message", b"notification_message", "notification_setting", b"notification_setting", "permission_list", b"permission_list", "permission_list_req", b"permission_list_req", "permission_role_list", b"permission_role_list", "permission_role_req", b"permission_role_req", "permission_user_req", b"permission_user_req", "role_event_list", b"role_event_list", "role_list", b"role_list", "role_list_event_req", b"role_list_event_req", "role_user_list", b"role_user_list", "role_user_req", b"role_user_req", "search_thread_req", b"search_thread_req", "sticker_list", b"sticker_list", "stream_user_list", b"stream_user_list", "unread_msg_indicator", b"unread_msg_indicator", "user_activity_list", b"user_activity_list", "user_permission_list", b"user_permission_list", "user_permission_req", b"user_permission_req", "voice_user_list", b"voice_user_list", "webhook_list", b"webhook_list", "webhook_list_req", b"webhook_list_req"]) -> None: ...

global___ListDataSocket = ListDataSocket

@typing.final
class MeetParticipantEvent(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    USERNAME_FIELD_NUMBER: builtins.int
    ROOM_NAME_FIELD_NUMBER: builtins.int
    CHANNEL_ID_FIELD_NUMBER: builtins.int
    CLAN_ID_FIELD_NUMBER: builtins.int
    ACTION_FIELD_NUMBER: builtins.int
    username: builtins.str
    room_name: builtins.str
    channel_id: builtins.str
    clan_id: builtins.str
    action: builtins.int
    def __init__(
        self,
        *,
        username: builtins.str = ...,
        room_name: builtins.str = ...,
        channel_id: builtins.str = ...,
        clan_id: builtins.str = ...,
        action: builtins.int = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["action", b"action", "channel_id", b"channel_id", "clan_id", b"clan_id", "room_name", b"room_name", "username", b"username"]) -> None: ...

global___MeetParticipantEvent = MeetParticipantEvent

@typing.final
class TransferOwnershipEvent(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CLAN_ID_FIELD_NUMBER: builtins.int
    PREV_OWNER_FIELD_NUMBER: builtins.int
    CURR_OWNER_FIELD_NUMBER: builtins.int
    clan_id: builtins.str
    prev_owner: builtins.str
    curr_owner: builtins.str
    def __init__(
        self,
        *,
        clan_id: builtins.str = ...,
        prev_owner: builtins.str = ...,
        curr_owner: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["clan_id", b"clan_id", "curr_owner", b"curr_owner", "prev_owner", b"prev_owner"]) -> None: ...

global___TransferOwnershipEvent = TransferOwnershipEvent
