# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ContentPermissionArgs', 'ContentPermission']

@pulumi.input_type
class ContentPermissionArgs:
    def __init__(__self__, *,
                 content_id: pulumi.Input[str],
                 notify_recipient: pulumi.Input[bool],
                 permissions: pulumi.Input[Sequence[pulumi.Input['ContentPermissionPermissionArgs']]],
                 notification_message: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a ContentPermission resource.
        :param pulumi.Input[str] content_id: The identifier of the content item for which you want to update
               permissions.
        :param pulumi.Input[bool] notify_recipient: Boolean value. Set it to "true" to notify the recipients by email.
        :param pulumi.Input[Sequence[pulumi.Input['ContentPermissionPermissionArgs']]] permissions: Permission block defining permission on the content. See
               permission schema for details.
        :param pulumi.Input[str] notification_message: The notification message to send to the users.
        """
        pulumi.set(__self__, "content_id", content_id)
        pulumi.set(__self__, "notify_recipient", notify_recipient)
        pulumi.set(__self__, "permissions", permissions)
        if notification_message is not None:
            pulumi.set(__self__, "notification_message", notification_message)

    @property
    @pulumi.getter(name="contentId")
    def content_id(self) -> pulumi.Input[str]:
        """
        The identifier of the content item for which you want to update
        permissions.
        """
        return pulumi.get(self, "content_id")

    @content_id.setter
    def content_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "content_id", value)

    @property
    @pulumi.getter(name="notifyRecipient")
    def notify_recipient(self) -> pulumi.Input[bool]:
        """
        Boolean value. Set it to "true" to notify the recipients by email.
        """
        return pulumi.get(self, "notify_recipient")

    @notify_recipient.setter
    def notify_recipient(self, value: pulumi.Input[bool]):
        pulumi.set(self, "notify_recipient", value)

    @property
    @pulumi.getter
    def permissions(self) -> pulumi.Input[Sequence[pulumi.Input['ContentPermissionPermissionArgs']]]:
        """
        Permission block defining permission on the content. See
        permission schema for details.
        """
        return pulumi.get(self, "permissions")

    @permissions.setter
    def permissions(self, value: pulumi.Input[Sequence[pulumi.Input['ContentPermissionPermissionArgs']]]):
        pulumi.set(self, "permissions", value)

    @property
    @pulumi.getter(name="notificationMessage")
    def notification_message(self) -> Optional[pulumi.Input[str]]:
        """
        The notification message to send to the users.
        """
        return pulumi.get(self, "notification_message")

    @notification_message.setter
    def notification_message(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "notification_message", value)


@pulumi.input_type
class _ContentPermissionState:
    def __init__(__self__, *,
                 content_id: Optional[pulumi.Input[str]] = None,
                 notification_message: Optional[pulumi.Input[str]] = None,
                 notify_recipient: Optional[pulumi.Input[bool]] = None,
                 permissions: Optional[pulumi.Input[Sequence[pulumi.Input['ContentPermissionPermissionArgs']]]] = None):
        """
        Input properties used for looking up and filtering ContentPermission resources.
        :param pulumi.Input[str] content_id: The identifier of the content item for which you want to update
               permissions.
        :param pulumi.Input[str] notification_message: The notification message to send to the users.
        :param pulumi.Input[bool] notify_recipient: Boolean value. Set it to "true" to notify the recipients by email.
        :param pulumi.Input[Sequence[pulumi.Input['ContentPermissionPermissionArgs']]] permissions: Permission block defining permission on the content. See
               permission schema for details.
        """
        if content_id is not None:
            pulumi.set(__self__, "content_id", content_id)
        if notification_message is not None:
            pulumi.set(__self__, "notification_message", notification_message)
        if notify_recipient is not None:
            pulumi.set(__self__, "notify_recipient", notify_recipient)
        if permissions is not None:
            pulumi.set(__self__, "permissions", permissions)

    @property
    @pulumi.getter(name="contentId")
    def content_id(self) -> Optional[pulumi.Input[str]]:
        """
        The identifier of the content item for which you want to update
        permissions.
        """
        return pulumi.get(self, "content_id")

    @content_id.setter
    def content_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "content_id", value)

    @property
    @pulumi.getter(name="notificationMessage")
    def notification_message(self) -> Optional[pulumi.Input[str]]:
        """
        The notification message to send to the users.
        """
        return pulumi.get(self, "notification_message")

    @notification_message.setter
    def notification_message(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "notification_message", value)

    @property
    @pulumi.getter(name="notifyRecipient")
    def notify_recipient(self) -> Optional[pulumi.Input[bool]]:
        """
        Boolean value. Set it to "true" to notify the recipients by email.
        """
        return pulumi.get(self, "notify_recipient")

    @notify_recipient.setter
    def notify_recipient(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "notify_recipient", value)

    @property
    @pulumi.getter
    def permissions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ContentPermissionPermissionArgs']]]]:
        """
        Permission block defining permission on the content. See
        permission schema for details.
        """
        return pulumi.get(self, "permissions")

    @permissions.setter
    def permissions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ContentPermissionPermissionArgs']]]]):
        pulumi.set(self, "permissions", value)


class ContentPermission(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 content_id: Optional[pulumi.Input[str]] = None,
                 notification_message: Optional[pulumi.Input[str]] = None,
                 notify_recipient: Optional[pulumi.Input[bool]] = None,
                 permissions: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ContentPermissionPermissionArgs']]]]] = None,
                 __props__=None):
        """
        Provides a way to configure permissions on a content to share it with a user, a role, or the entire
        org. You can read more [here](https://help.sumologic.com/Manage/Content_Sharing/Share-Content).

        There are three permission levels `View`, `Edit` and `Manage`. You can read more about different
        levels [here](https://help.sumologic.com/Manage/Content_Sharing/Share-Content#available-permission-levels).

        > When you add a new permission to a content, all the lower level permissions are added by default.
        For example, giving a user "Manage" permission on a content, implicitly gives them "Edit" and "View"
        permissions on the content. Due to this behavior, when you add a higher level permission, you must
        also add all the lower level permissions. For example, when you give a user "Edit" permission via
        the resource, you must give them "View" permission otherwise state and configuration will be out
        of sync.

        ## Example Usage

        ```python
        import pulumi
        import json
        import pulumi_sumologic as sumologic

        personal_folder = sumologic.get_personal_folder()
        permission_test_content = sumologic.Content("permissionTestContent",
            parent_id=personal_folder.id,
            config=json.dumps({
                "type": "FolderSyncDefinition",
                "name": "test_permission_resource_folder",
                "description": "",
                "children": [],
            }))
        role = sumologic.get_role(name="test_role")
        user = sumologic.get_user(email="user@example.com")
        # Grant user `user@example.com` "Manage" permission and role `test_role`
        # "View" permission on the folder `test_permission_resource_folder`.
        content_permission_test = sumologic.ContentPermission("contentPermissionTest",
            content_id=permission_test_content.id,
            notify_recipient=True,
            notification_message="You now have the permission to access this content",
            permissions=[
                sumologic.ContentPermissionPermissionArgs(
                    permission_name="View",
                    source_type="role",
                    source_id=role.id,
                ),
                sumologic.ContentPermissionPermissionArgs(
                    permission_name="View",
                    source_type="user",
                    source_id=user.id,
                ),
                sumologic.ContentPermissionPermissionArgs(
                    permission_name="Edit",
                    source_type="user",
                    source_id=user.id,
                ),
                sumologic.ContentPermissionPermissionArgs(
                    permission_name="Manage",
                    source_type="user",
                    source_id=user.id,
                ),
            ])
        ```

        ## Import

        Permisions on a content item can be imported using the content identifier, e.g.hcl // import permissions for content item with identifier = 0000000008E0183E

        ```sh
         $ pulumi import sumologic:index/contentPermission:ContentPermission dashboard_permission_import 0000000008E0183E
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] content_id: The identifier of the content item for which you want to update
               permissions.
        :param pulumi.Input[str] notification_message: The notification message to send to the users.
        :param pulumi.Input[bool] notify_recipient: Boolean value. Set it to "true" to notify the recipients by email.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ContentPermissionPermissionArgs']]]] permissions: Permission block defining permission on the content. See
               permission schema for details.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ContentPermissionArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a way to configure permissions on a content to share it with a user, a role, or the entire
        org. You can read more [here](https://help.sumologic.com/Manage/Content_Sharing/Share-Content).

        There are three permission levels `View`, `Edit` and `Manage`. You can read more about different
        levels [here](https://help.sumologic.com/Manage/Content_Sharing/Share-Content#available-permission-levels).

        > When you add a new permission to a content, all the lower level permissions are added by default.
        For example, giving a user "Manage" permission on a content, implicitly gives them "Edit" and "View"
        permissions on the content. Due to this behavior, when you add a higher level permission, you must
        also add all the lower level permissions. For example, when you give a user "Edit" permission via
        the resource, you must give them "View" permission otherwise state and configuration will be out
        of sync.

        ## Example Usage

        ```python
        import pulumi
        import json
        import pulumi_sumologic as sumologic

        personal_folder = sumologic.get_personal_folder()
        permission_test_content = sumologic.Content("permissionTestContent",
            parent_id=personal_folder.id,
            config=json.dumps({
                "type": "FolderSyncDefinition",
                "name": "test_permission_resource_folder",
                "description": "",
                "children": [],
            }))
        role = sumologic.get_role(name="test_role")
        user = sumologic.get_user(email="user@example.com")
        # Grant user `user@example.com` "Manage" permission and role `test_role`
        # "View" permission on the folder `test_permission_resource_folder`.
        content_permission_test = sumologic.ContentPermission("contentPermissionTest",
            content_id=permission_test_content.id,
            notify_recipient=True,
            notification_message="You now have the permission to access this content",
            permissions=[
                sumologic.ContentPermissionPermissionArgs(
                    permission_name="View",
                    source_type="role",
                    source_id=role.id,
                ),
                sumologic.ContentPermissionPermissionArgs(
                    permission_name="View",
                    source_type="user",
                    source_id=user.id,
                ),
                sumologic.ContentPermissionPermissionArgs(
                    permission_name="Edit",
                    source_type="user",
                    source_id=user.id,
                ),
                sumologic.ContentPermissionPermissionArgs(
                    permission_name="Manage",
                    source_type="user",
                    source_id=user.id,
                ),
            ])
        ```

        ## Import

        Permisions on a content item can be imported using the content identifier, e.g.hcl // import permissions for content item with identifier = 0000000008E0183E

        ```sh
         $ pulumi import sumologic:index/contentPermission:ContentPermission dashboard_permission_import 0000000008E0183E
        ```

        :param str resource_name: The name of the resource.
        :param ContentPermissionArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ContentPermissionArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 content_id: Optional[pulumi.Input[str]] = None,
                 notification_message: Optional[pulumi.Input[str]] = None,
                 notify_recipient: Optional[pulumi.Input[bool]] = None,
                 permissions: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ContentPermissionPermissionArgs']]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ContentPermissionArgs.__new__(ContentPermissionArgs)

            if content_id is None and not opts.urn:
                raise TypeError("Missing required property 'content_id'")
            __props__.__dict__["content_id"] = content_id
            __props__.__dict__["notification_message"] = notification_message
            if notify_recipient is None and not opts.urn:
                raise TypeError("Missing required property 'notify_recipient'")
            __props__.__dict__["notify_recipient"] = notify_recipient
            if permissions is None and not opts.urn:
                raise TypeError("Missing required property 'permissions'")
            __props__.__dict__["permissions"] = permissions
        super(ContentPermission, __self__).__init__(
            'sumologic:index/contentPermission:ContentPermission',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            content_id: Optional[pulumi.Input[str]] = None,
            notification_message: Optional[pulumi.Input[str]] = None,
            notify_recipient: Optional[pulumi.Input[bool]] = None,
            permissions: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ContentPermissionPermissionArgs']]]]] = None) -> 'ContentPermission':
        """
        Get an existing ContentPermission resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] content_id: The identifier of the content item for which you want to update
               permissions.
        :param pulumi.Input[str] notification_message: The notification message to send to the users.
        :param pulumi.Input[bool] notify_recipient: Boolean value. Set it to "true" to notify the recipients by email.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ContentPermissionPermissionArgs']]]] permissions: Permission block defining permission on the content. See
               permission schema for details.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ContentPermissionState.__new__(_ContentPermissionState)

        __props__.__dict__["content_id"] = content_id
        __props__.__dict__["notification_message"] = notification_message
        __props__.__dict__["notify_recipient"] = notify_recipient
        __props__.__dict__["permissions"] = permissions
        return ContentPermission(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="contentId")
    def content_id(self) -> pulumi.Output[str]:
        """
        The identifier of the content item for which you want to update
        permissions.
        """
        return pulumi.get(self, "content_id")

    @property
    @pulumi.getter(name="notificationMessage")
    def notification_message(self) -> pulumi.Output[Optional[str]]:
        """
        The notification message to send to the users.
        """
        return pulumi.get(self, "notification_message")

    @property
    @pulumi.getter(name="notifyRecipient")
    def notify_recipient(self) -> pulumi.Output[bool]:
        """
        Boolean value. Set it to "true" to notify the recipients by email.
        """
        return pulumi.get(self, "notify_recipient")

    @property
    @pulumi.getter
    def permissions(self) -> pulumi.Output[Sequence['outputs.ContentPermissionPermission']]:
        """
        Permission block defining permission on the content. See
        permission schema for details.
        """
        return pulumi.get(self, "permissions")

