# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['CseLogMappingArgs', 'CseLogMapping']

@pulumi.input_type
class CseLogMappingArgs:
    def __init__(__self__, *,
                 enabled: pulumi.Input[bool],
                 fields: pulumi.Input[Sequence[pulumi.Input['CseLogMappingFieldArgs']]],
                 product_guid: pulumi.Input[str],
                 record_type: pulumi.Input[str],
                 name: Optional[pulumi.Input[str]] = None,
                 parent_id: Optional[pulumi.Input[str]] = None,
                 relates_entities: Optional[pulumi.Input[bool]] = None,
                 skipped_values: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 structured_inputs: Optional[pulumi.Input[Sequence[pulumi.Input['CseLogMappingStructuredInputArgs']]]] = None,
                 unstructured_fields: Optional[pulumi.Input['CseLogMappingUnstructuredFieldsArgs']] = None):
        """
        The set of arguments for constructing a CseLogMapping resource.
        :param pulumi.Input[bool] enabled: Enabled flag.
        :param pulumi.Input[Sequence[pulumi.Input['CseLogMappingFieldArgs']]] fields: List of fields for the new log mapping. See field_schema for details.
        :param pulumi.Input[str] product_guid: Product GUID.
        :param pulumi.Input[str] record_type: The record type to be created. (possible values: Audit, AuditChange, AuditFile, AuditResourceAccess, Authentication, AuthenticationPrivilegeEscalation, Canary, Email, Endpoint, EndpointModuleLoad, EndpointProcess, Network, NetworkDHCP, NetworkDNS, NetworkFlow, NetworkHTTP, NetworkProxy, Notification, NotificationVulnerability)
        :param pulumi.Input[str] name: The name of the log mapping.
        :param pulumi.Input[str] parent_id: The id of the parent log mapping.
        :param pulumi.Input[bool] relates_entities: Set to true to relate entities.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] skipped_values: List of skipped values.
        :param pulumi.Input[Sequence[pulumi.Input['CseLogMappingStructuredInputArgs']]] structured_inputs: List of structured inputs for the new log mapping. See structured_input_schema for details.
        :param pulumi.Input['CseLogMappingUnstructuredFieldsArgs'] unstructured_fields: Unstructured fields for the new log mapping. See unstructured_field_schema for details.
        """
        pulumi.set(__self__, "enabled", enabled)
        pulumi.set(__self__, "fields", fields)
        pulumi.set(__self__, "product_guid", product_guid)
        pulumi.set(__self__, "record_type", record_type)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if parent_id is not None:
            pulumi.set(__self__, "parent_id", parent_id)
        if relates_entities is not None:
            pulumi.set(__self__, "relates_entities", relates_entities)
        if skipped_values is not None:
            pulumi.set(__self__, "skipped_values", skipped_values)
        if structured_inputs is not None:
            pulumi.set(__self__, "structured_inputs", structured_inputs)
        if unstructured_fields is not None:
            pulumi.set(__self__, "unstructured_fields", unstructured_fields)

    @property
    @pulumi.getter
    def enabled(self) -> pulumi.Input[bool]:
        """
        Enabled flag.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: pulumi.Input[bool]):
        pulumi.set(self, "enabled", value)

    @property
    @pulumi.getter
    def fields(self) -> pulumi.Input[Sequence[pulumi.Input['CseLogMappingFieldArgs']]]:
        """
        List of fields for the new log mapping. See field_schema for details.
        """
        return pulumi.get(self, "fields")

    @fields.setter
    def fields(self, value: pulumi.Input[Sequence[pulumi.Input['CseLogMappingFieldArgs']]]):
        pulumi.set(self, "fields", value)

    @property
    @pulumi.getter(name="productGuid")
    def product_guid(self) -> pulumi.Input[str]:
        """
        Product GUID.
        """
        return pulumi.get(self, "product_guid")

    @product_guid.setter
    def product_guid(self, value: pulumi.Input[str]):
        pulumi.set(self, "product_guid", value)

    @property
    @pulumi.getter(name="recordType")
    def record_type(self) -> pulumi.Input[str]:
        """
        The record type to be created. (possible values: Audit, AuditChange, AuditFile, AuditResourceAccess, Authentication, AuthenticationPrivilegeEscalation, Canary, Email, Endpoint, EndpointModuleLoad, EndpointProcess, Network, NetworkDHCP, NetworkDNS, NetworkFlow, NetworkHTTP, NetworkProxy, Notification, NotificationVulnerability)
        """
        return pulumi.get(self, "record_type")

    @record_type.setter
    def record_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "record_type", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the log mapping.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="parentId")
    def parent_id(self) -> Optional[pulumi.Input[str]]:
        """
        The id of the parent log mapping.
        """
        return pulumi.get(self, "parent_id")

    @parent_id.setter
    def parent_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "parent_id", value)

    @property
    @pulumi.getter(name="relatesEntities")
    def relates_entities(self) -> Optional[pulumi.Input[bool]]:
        """
        Set to true to relate entities.
        """
        return pulumi.get(self, "relates_entities")

    @relates_entities.setter
    def relates_entities(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "relates_entities", value)

    @property
    @pulumi.getter(name="skippedValues")
    def skipped_values(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        List of skipped values.
        """
        return pulumi.get(self, "skipped_values")

    @skipped_values.setter
    def skipped_values(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "skipped_values", value)

    @property
    @pulumi.getter(name="structuredInputs")
    def structured_inputs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['CseLogMappingStructuredInputArgs']]]]:
        """
        List of structured inputs for the new log mapping. See structured_input_schema for details.
        """
        return pulumi.get(self, "structured_inputs")

    @structured_inputs.setter
    def structured_inputs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['CseLogMappingStructuredInputArgs']]]]):
        pulumi.set(self, "structured_inputs", value)

    @property
    @pulumi.getter(name="unstructuredFields")
    def unstructured_fields(self) -> Optional[pulumi.Input['CseLogMappingUnstructuredFieldsArgs']]:
        """
        Unstructured fields for the new log mapping. See unstructured_field_schema for details.
        """
        return pulumi.get(self, "unstructured_fields")

    @unstructured_fields.setter
    def unstructured_fields(self, value: Optional[pulumi.Input['CseLogMappingUnstructuredFieldsArgs']]):
        pulumi.set(self, "unstructured_fields", value)


@pulumi.input_type
class _CseLogMappingState:
    def __init__(__self__, *,
                 enabled: Optional[pulumi.Input[bool]] = None,
                 fields: Optional[pulumi.Input[Sequence[pulumi.Input['CseLogMappingFieldArgs']]]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 parent_id: Optional[pulumi.Input[str]] = None,
                 product_guid: Optional[pulumi.Input[str]] = None,
                 record_type: Optional[pulumi.Input[str]] = None,
                 relates_entities: Optional[pulumi.Input[bool]] = None,
                 skipped_values: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 structured_inputs: Optional[pulumi.Input[Sequence[pulumi.Input['CseLogMappingStructuredInputArgs']]]] = None,
                 unstructured_fields: Optional[pulumi.Input['CseLogMappingUnstructuredFieldsArgs']] = None):
        """
        Input properties used for looking up and filtering CseLogMapping resources.
        :param pulumi.Input[bool] enabled: Enabled flag.
        :param pulumi.Input[Sequence[pulumi.Input['CseLogMappingFieldArgs']]] fields: List of fields for the new log mapping. See field_schema for details.
        :param pulumi.Input[str] name: The name of the log mapping.
        :param pulumi.Input[str] parent_id: The id of the parent log mapping.
        :param pulumi.Input[str] product_guid: Product GUID.
        :param pulumi.Input[str] record_type: The record type to be created. (possible values: Audit, AuditChange, AuditFile, AuditResourceAccess, Authentication, AuthenticationPrivilegeEscalation, Canary, Email, Endpoint, EndpointModuleLoad, EndpointProcess, Network, NetworkDHCP, NetworkDNS, NetworkFlow, NetworkHTTP, NetworkProxy, Notification, NotificationVulnerability)
        :param pulumi.Input[bool] relates_entities: Set to true to relate entities.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] skipped_values: List of skipped values.
        :param pulumi.Input[Sequence[pulumi.Input['CseLogMappingStructuredInputArgs']]] structured_inputs: List of structured inputs for the new log mapping. See structured_input_schema for details.
        :param pulumi.Input['CseLogMappingUnstructuredFieldsArgs'] unstructured_fields: Unstructured fields for the new log mapping. See unstructured_field_schema for details.
        """
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if fields is not None:
            pulumi.set(__self__, "fields", fields)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if parent_id is not None:
            pulumi.set(__self__, "parent_id", parent_id)
        if product_guid is not None:
            pulumi.set(__self__, "product_guid", product_guid)
        if record_type is not None:
            pulumi.set(__self__, "record_type", record_type)
        if relates_entities is not None:
            pulumi.set(__self__, "relates_entities", relates_entities)
        if skipped_values is not None:
            pulumi.set(__self__, "skipped_values", skipped_values)
        if structured_inputs is not None:
            pulumi.set(__self__, "structured_inputs", structured_inputs)
        if unstructured_fields is not None:
            pulumi.set(__self__, "unstructured_fields", unstructured_fields)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Enabled flag.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enabled", value)

    @property
    @pulumi.getter
    def fields(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['CseLogMappingFieldArgs']]]]:
        """
        List of fields for the new log mapping. See field_schema for details.
        """
        return pulumi.get(self, "fields")

    @fields.setter
    def fields(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['CseLogMappingFieldArgs']]]]):
        pulumi.set(self, "fields", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the log mapping.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="parentId")
    def parent_id(self) -> Optional[pulumi.Input[str]]:
        """
        The id of the parent log mapping.
        """
        return pulumi.get(self, "parent_id")

    @parent_id.setter
    def parent_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "parent_id", value)

    @property
    @pulumi.getter(name="productGuid")
    def product_guid(self) -> Optional[pulumi.Input[str]]:
        """
        Product GUID.
        """
        return pulumi.get(self, "product_guid")

    @product_guid.setter
    def product_guid(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "product_guid", value)

    @property
    @pulumi.getter(name="recordType")
    def record_type(self) -> Optional[pulumi.Input[str]]:
        """
        The record type to be created. (possible values: Audit, AuditChange, AuditFile, AuditResourceAccess, Authentication, AuthenticationPrivilegeEscalation, Canary, Email, Endpoint, EndpointModuleLoad, EndpointProcess, Network, NetworkDHCP, NetworkDNS, NetworkFlow, NetworkHTTP, NetworkProxy, Notification, NotificationVulnerability)
        """
        return pulumi.get(self, "record_type")

    @record_type.setter
    def record_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "record_type", value)

    @property
    @pulumi.getter(name="relatesEntities")
    def relates_entities(self) -> Optional[pulumi.Input[bool]]:
        """
        Set to true to relate entities.
        """
        return pulumi.get(self, "relates_entities")

    @relates_entities.setter
    def relates_entities(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "relates_entities", value)

    @property
    @pulumi.getter(name="skippedValues")
    def skipped_values(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        List of skipped values.
        """
        return pulumi.get(self, "skipped_values")

    @skipped_values.setter
    def skipped_values(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "skipped_values", value)

    @property
    @pulumi.getter(name="structuredInputs")
    def structured_inputs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['CseLogMappingStructuredInputArgs']]]]:
        """
        List of structured inputs for the new log mapping. See structured_input_schema for details.
        """
        return pulumi.get(self, "structured_inputs")

    @structured_inputs.setter
    def structured_inputs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['CseLogMappingStructuredInputArgs']]]]):
        pulumi.set(self, "structured_inputs", value)

    @property
    @pulumi.getter(name="unstructuredFields")
    def unstructured_fields(self) -> Optional[pulumi.Input['CseLogMappingUnstructuredFieldsArgs']]:
        """
        Unstructured fields for the new log mapping. See unstructured_field_schema for details.
        """
        return pulumi.get(self, "unstructured_fields")

    @unstructured_fields.setter
    def unstructured_fields(self, value: Optional[pulumi.Input['CseLogMappingUnstructuredFieldsArgs']]):
        pulumi.set(self, "unstructured_fields", value)


class CseLogMapping(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 enabled: Optional[pulumi.Input[bool]] = None,
                 fields: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['CseLogMappingFieldArgs']]]]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 parent_id: Optional[pulumi.Input[str]] = None,
                 product_guid: Optional[pulumi.Input[str]] = None,
                 record_type: Optional[pulumi.Input[str]] = None,
                 relates_entities: Optional[pulumi.Input[bool]] = None,
                 skipped_values: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 structured_inputs: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['CseLogMappingStructuredInputArgs']]]]] = None,
                 unstructured_fields: Optional[pulumi.Input[pulumi.InputType['CseLogMappingUnstructuredFieldsArgs']]] = None,
                 __props__=None):
        """
        Provides a Sumologic CSE Log Mapping.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_sumologic as sumologic

        log_mapping = sumologic.CseLogMapping("logMapping",
            enabled=True,
            fields=[sumologic.CseLogMappingFieldArgs(
                alternate_values=["altValue"],
                case_insensitive=False,
                default_value="",
                field_joins=["and"],
                format="JSON",
                format_parameters=["param"],
                join_delimiter="",
                lookups=[sumologic.CseLogMappingFieldLookupArgs(
                    key="tunnel-up",
                    value="true",
                )],
                name="action",
                skipped_values=["-"],
                split_delimiter=",",
                split_index=0,
                time_zone="UTC",
                value="action",
                value_type="constant",
            )],
            product_guid="003d35b3-3ba8-4e93-8776-e5810b4e243e",
            record_type="Audit",
            relates_entities=True,
            skipped_values=["skipped"],
            structured_inputs=[sumologic.CseLogMappingStructuredInputArgs(
                event_id_pattern="vpn",
                log_format="JSON",
                product="fortinate",
                vendor="fortinate",
            )])
        ```

        ## Import

        Log Mapping can be imported using the field id, e.g.hcl

        ```sh
         $ pulumi import sumologic:index/cseLogMapping:CseLogMapping log_mapping id
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[bool] enabled: Enabled flag.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['CseLogMappingFieldArgs']]]] fields: List of fields for the new log mapping. See field_schema for details.
        :param pulumi.Input[str] name: The name of the log mapping.
        :param pulumi.Input[str] parent_id: The id of the parent log mapping.
        :param pulumi.Input[str] product_guid: Product GUID.
        :param pulumi.Input[str] record_type: The record type to be created. (possible values: Audit, AuditChange, AuditFile, AuditResourceAccess, Authentication, AuthenticationPrivilegeEscalation, Canary, Email, Endpoint, EndpointModuleLoad, EndpointProcess, Network, NetworkDHCP, NetworkDNS, NetworkFlow, NetworkHTTP, NetworkProxy, Notification, NotificationVulnerability)
        :param pulumi.Input[bool] relates_entities: Set to true to relate entities.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] skipped_values: List of skipped values.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['CseLogMappingStructuredInputArgs']]]] structured_inputs: List of structured inputs for the new log mapping. See structured_input_schema for details.
        :param pulumi.Input[pulumi.InputType['CseLogMappingUnstructuredFieldsArgs']] unstructured_fields: Unstructured fields for the new log mapping. See unstructured_field_schema for details.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: CseLogMappingArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a Sumologic CSE Log Mapping.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_sumologic as sumologic

        log_mapping = sumologic.CseLogMapping("logMapping",
            enabled=True,
            fields=[sumologic.CseLogMappingFieldArgs(
                alternate_values=["altValue"],
                case_insensitive=False,
                default_value="",
                field_joins=["and"],
                format="JSON",
                format_parameters=["param"],
                join_delimiter="",
                lookups=[sumologic.CseLogMappingFieldLookupArgs(
                    key="tunnel-up",
                    value="true",
                )],
                name="action",
                skipped_values=["-"],
                split_delimiter=",",
                split_index=0,
                time_zone="UTC",
                value="action",
                value_type="constant",
            )],
            product_guid="003d35b3-3ba8-4e93-8776-e5810b4e243e",
            record_type="Audit",
            relates_entities=True,
            skipped_values=["skipped"],
            structured_inputs=[sumologic.CseLogMappingStructuredInputArgs(
                event_id_pattern="vpn",
                log_format="JSON",
                product="fortinate",
                vendor="fortinate",
            )])
        ```

        ## Import

        Log Mapping can be imported using the field id, e.g.hcl

        ```sh
         $ pulumi import sumologic:index/cseLogMapping:CseLogMapping log_mapping id
        ```

        :param str resource_name: The name of the resource.
        :param CseLogMappingArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(CseLogMappingArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 enabled: Optional[pulumi.Input[bool]] = None,
                 fields: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['CseLogMappingFieldArgs']]]]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 parent_id: Optional[pulumi.Input[str]] = None,
                 product_guid: Optional[pulumi.Input[str]] = None,
                 record_type: Optional[pulumi.Input[str]] = None,
                 relates_entities: Optional[pulumi.Input[bool]] = None,
                 skipped_values: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 structured_inputs: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['CseLogMappingStructuredInputArgs']]]]] = None,
                 unstructured_fields: Optional[pulumi.Input[pulumi.InputType['CseLogMappingUnstructuredFieldsArgs']]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = CseLogMappingArgs.__new__(CseLogMappingArgs)

            if enabled is None and not opts.urn:
                raise TypeError("Missing required property 'enabled'")
            __props__.__dict__["enabled"] = enabled
            if fields is None and not opts.urn:
                raise TypeError("Missing required property 'fields'")
            __props__.__dict__["fields"] = fields
            __props__.__dict__["name"] = name
            __props__.__dict__["parent_id"] = parent_id
            if product_guid is None and not opts.urn:
                raise TypeError("Missing required property 'product_guid'")
            __props__.__dict__["product_guid"] = product_guid
            if record_type is None and not opts.urn:
                raise TypeError("Missing required property 'record_type'")
            __props__.__dict__["record_type"] = record_type
            __props__.__dict__["relates_entities"] = relates_entities
            __props__.__dict__["skipped_values"] = skipped_values
            __props__.__dict__["structured_inputs"] = structured_inputs
            __props__.__dict__["unstructured_fields"] = unstructured_fields
        super(CseLogMapping, __self__).__init__(
            'sumologic:index/cseLogMapping:CseLogMapping',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            enabled: Optional[pulumi.Input[bool]] = None,
            fields: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['CseLogMappingFieldArgs']]]]] = None,
            name: Optional[pulumi.Input[str]] = None,
            parent_id: Optional[pulumi.Input[str]] = None,
            product_guid: Optional[pulumi.Input[str]] = None,
            record_type: Optional[pulumi.Input[str]] = None,
            relates_entities: Optional[pulumi.Input[bool]] = None,
            skipped_values: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            structured_inputs: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['CseLogMappingStructuredInputArgs']]]]] = None,
            unstructured_fields: Optional[pulumi.Input[pulumi.InputType['CseLogMappingUnstructuredFieldsArgs']]] = None) -> 'CseLogMapping':
        """
        Get an existing CseLogMapping resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[bool] enabled: Enabled flag.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['CseLogMappingFieldArgs']]]] fields: List of fields for the new log mapping. See field_schema for details.
        :param pulumi.Input[str] name: The name of the log mapping.
        :param pulumi.Input[str] parent_id: The id of the parent log mapping.
        :param pulumi.Input[str] product_guid: Product GUID.
        :param pulumi.Input[str] record_type: The record type to be created. (possible values: Audit, AuditChange, AuditFile, AuditResourceAccess, Authentication, AuthenticationPrivilegeEscalation, Canary, Email, Endpoint, EndpointModuleLoad, EndpointProcess, Network, NetworkDHCP, NetworkDNS, NetworkFlow, NetworkHTTP, NetworkProxy, Notification, NotificationVulnerability)
        :param pulumi.Input[bool] relates_entities: Set to true to relate entities.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] skipped_values: List of skipped values.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['CseLogMappingStructuredInputArgs']]]] structured_inputs: List of structured inputs for the new log mapping. See structured_input_schema for details.
        :param pulumi.Input[pulumi.InputType['CseLogMappingUnstructuredFieldsArgs']] unstructured_fields: Unstructured fields for the new log mapping. See unstructured_field_schema for details.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _CseLogMappingState.__new__(_CseLogMappingState)

        __props__.__dict__["enabled"] = enabled
        __props__.__dict__["fields"] = fields
        __props__.__dict__["name"] = name
        __props__.__dict__["parent_id"] = parent_id
        __props__.__dict__["product_guid"] = product_guid
        __props__.__dict__["record_type"] = record_type
        __props__.__dict__["relates_entities"] = relates_entities
        __props__.__dict__["skipped_values"] = skipped_values
        __props__.__dict__["structured_inputs"] = structured_inputs
        __props__.__dict__["unstructured_fields"] = unstructured_fields
        return CseLogMapping(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def enabled(self) -> pulumi.Output[bool]:
        """
        Enabled flag.
        """
        return pulumi.get(self, "enabled")

    @property
    @pulumi.getter
    def fields(self) -> pulumi.Output[Sequence['outputs.CseLogMappingField']]:
        """
        List of fields for the new log mapping. See field_schema for details.
        """
        return pulumi.get(self, "fields")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        The name of the log mapping.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="parentId")
    def parent_id(self) -> pulumi.Output[Optional[str]]:
        """
        The id of the parent log mapping.
        """
        return pulumi.get(self, "parent_id")

    @property
    @pulumi.getter(name="productGuid")
    def product_guid(self) -> pulumi.Output[str]:
        """
        Product GUID.
        """
        return pulumi.get(self, "product_guid")

    @property
    @pulumi.getter(name="recordType")
    def record_type(self) -> pulumi.Output[str]:
        """
        The record type to be created. (possible values: Audit, AuditChange, AuditFile, AuditResourceAccess, Authentication, AuthenticationPrivilegeEscalation, Canary, Email, Endpoint, EndpointModuleLoad, EndpointProcess, Network, NetworkDHCP, NetworkDNS, NetworkFlow, NetworkHTTP, NetworkProxy, Notification, NotificationVulnerability)
        """
        return pulumi.get(self, "record_type")

    @property
    @pulumi.getter(name="relatesEntities")
    def relates_entities(self) -> pulumi.Output[Optional[bool]]:
        """
        Set to true to relate entities.
        """
        return pulumi.get(self, "relates_entities")

    @property
    @pulumi.getter(name="skippedValues")
    def skipped_values(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        List of skipped values.
        """
        return pulumi.get(self, "skipped_values")

    @property
    @pulumi.getter(name="structuredInputs")
    def structured_inputs(self) -> pulumi.Output[Optional[Sequence['outputs.CseLogMappingStructuredInput']]]:
        """
        List of structured inputs for the new log mapping. See structured_input_schema for details.
        """
        return pulumi.get(self, "structured_inputs")

    @property
    @pulumi.getter(name="unstructuredFields")
    def unstructured_fields(self) -> pulumi.Output[Optional['outputs.CseLogMappingUnstructuredFields']]:
        """
        Unstructured fields for the new log mapping. See unstructured_field_schema for details.
        """
        return pulumi.get(self, "unstructured_fields")

