# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['HierarchyArgs', 'Hierarchy']

@pulumi.input_type
class HierarchyArgs:
    def __init__(__self__, *,
                 levels: pulumi.Input[Sequence[pulumi.Input['HierarchyLevelArgs']]],
                 filter: Optional[pulumi.Input['HierarchyFilterArgs']] = None,
                 name: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a Hierarchy resource.
        :param pulumi.Input['HierarchyFilterArgs'] filter: An optional clause that a hierarchy requires to be matched.
        :param pulumi.Input[str] name: Name of the hierarchy.
        """
        pulumi.set(__self__, "levels", levels)
        if filter is not None:
            pulumi.set(__self__, "filter", filter)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def levels(self) -> pulumi.Input[Sequence[pulumi.Input['HierarchyLevelArgs']]]:
        return pulumi.get(self, "levels")

    @levels.setter
    def levels(self, value: pulumi.Input[Sequence[pulumi.Input['HierarchyLevelArgs']]]):
        pulumi.set(self, "levels", value)

    @property
    @pulumi.getter
    def filter(self) -> Optional[pulumi.Input['HierarchyFilterArgs']]:
        """
        An optional clause that a hierarchy requires to be matched.
        """
        return pulumi.get(self, "filter")

    @filter.setter
    def filter(self, value: Optional[pulumi.Input['HierarchyFilterArgs']]):
        pulumi.set(self, "filter", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the hierarchy.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)


@pulumi.input_type
class _HierarchyState:
    def __init__(__self__, *,
                 filter: Optional[pulumi.Input['HierarchyFilterArgs']] = None,
                 levels: Optional[pulumi.Input[Sequence[pulumi.Input['HierarchyLevelArgs']]]] = None,
                 name: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering Hierarchy resources.
        :param pulumi.Input['HierarchyFilterArgs'] filter: An optional clause that a hierarchy requires to be matched.
        :param pulumi.Input[str] name: Name of the hierarchy.
        """
        if filter is not None:
            pulumi.set(__self__, "filter", filter)
        if levels is not None:
            pulumi.set(__self__, "levels", levels)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def filter(self) -> Optional[pulumi.Input['HierarchyFilterArgs']]:
        """
        An optional clause that a hierarchy requires to be matched.
        """
        return pulumi.get(self, "filter")

    @filter.setter
    def filter(self, value: Optional[pulumi.Input['HierarchyFilterArgs']]):
        pulumi.set(self, "filter", value)

    @property
    @pulumi.getter
    def levels(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['HierarchyLevelArgs']]]]:
        return pulumi.get(self, "levels")

    @levels.setter
    def levels(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['HierarchyLevelArgs']]]]):
        pulumi.set(self, "levels", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the hierarchy.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)


class Hierarchy(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 filter: Optional[pulumi.Input[pulumi.InputType['HierarchyFilterArgs']]] = None,
                 levels: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['HierarchyLevelArgs']]]]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Provides a [Sumologic Hierarchy](https://help.sumologic.com/Visualizations-and-Alerts/Explore).

        ## Example Usage

        ```python
        import pulumi
        import pulumi_sumologic as sumologic

        example_hierarchy = sumologic.Hierarchy("exampleHierarchy",
            filter=sumologic.HierarchyFilterArgs(
                key="_origin",
                value="kubernetes",
            ),
            levels=[sumologic.HierarchyLevelArgs(
                entity_type="cluster",
                next_level=sumologic.HierarchyLevelNextLevelArgs(
                    entity_type="node",
                ),
                next_levels_with_conditions=[sumologic.HierarchyLevelNextLevelsWithConditionArgs(
                    condition="testCondition",
                    level=sumologic.HierarchyLevelNextLevelsWithConditionLevelArgs(
                        entity_type="namespace",
                    ),
                )],
            )])
        ```

        ## Import

        Hierarchies can be imported using the id, e.g.hcl

        ```sh
         $ pulumi import sumologic:index/hierarchy:Hierarchy test id
        ```

         [1]https://help.sumologic.com/Visualizations-and-Alerts/Explore

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[pulumi.InputType['HierarchyFilterArgs']] filter: An optional clause that a hierarchy requires to be matched.
        :param pulumi.Input[str] name: Name of the hierarchy.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: HierarchyArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a [Sumologic Hierarchy](https://help.sumologic.com/Visualizations-and-Alerts/Explore).

        ## Example Usage

        ```python
        import pulumi
        import pulumi_sumologic as sumologic

        example_hierarchy = sumologic.Hierarchy("exampleHierarchy",
            filter=sumologic.HierarchyFilterArgs(
                key="_origin",
                value="kubernetes",
            ),
            levels=[sumologic.HierarchyLevelArgs(
                entity_type="cluster",
                next_level=sumologic.HierarchyLevelNextLevelArgs(
                    entity_type="node",
                ),
                next_levels_with_conditions=[sumologic.HierarchyLevelNextLevelsWithConditionArgs(
                    condition="testCondition",
                    level=sumologic.HierarchyLevelNextLevelsWithConditionLevelArgs(
                        entity_type="namespace",
                    ),
                )],
            )])
        ```

        ## Import

        Hierarchies can be imported using the id, e.g.hcl

        ```sh
         $ pulumi import sumologic:index/hierarchy:Hierarchy test id
        ```

         [1]https://help.sumologic.com/Visualizations-and-Alerts/Explore

        :param str resource_name: The name of the resource.
        :param HierarchyArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(HierarchyArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 filter: Optional[pulumi.Input[pulumi.InputType['HierarchyFilterArgs']]] = None,
                 levels: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['HierarchyLevelArgs']]]]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = HierarchyArgs.__new__(HierarchyArgs)

            __props__.__dict__["filter"] = filter
            if levels is None and not opts.urn:
                raise TypeError("Missing required property 'levels'")
            __props__.__dict__["levels"] = levels
            __props__.__dict__["name"] = name
        super(Hierarchy, __self__).__init__(
            'sumologic:index/hierarchy:Hierarchy',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            filter: Optional[pulumi.Input[pulumi.InputType['HierarchyFilterArgs']]] = None,
            levels: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['HierarchyLevelArgs']]]]] = None,
            name: Optional[pulumi.Input[str]] = None) -> 'Hierarchy':
        """
        Get an existing Hierarchy resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[pulumi.InputType['HierarchyFilterArgs']] filter: An optional clause that a hierarchy requires to be matched.
        :param pulumi.Input[str] name: Name of the hierarchy.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _HierarchyState.__new__(_HierarchyState)

        __props__.__dict__["filter"] = filter
        __props__.__dict__["levels"] = levels
        __props__.__dict__["name"] = name
        return Hierarchy(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def filter(self) -> pulumi.Output[Optional['outputs.HierarchyFilter']]:
        """
        An optional clause that a hierarchy requires to be matched.
        """
        return pulumi.get(self, "filter")

    @property
    @pulumi.getter
    def levels(self) -> pulumi.Output[Sequence['outputs.HierarchyLevel']]:
        return pulumi.get(self, "levels")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        Name of the hierarchy.
        """
        return pulumi.get(self, "name")

