# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['LookupTableArgs', 'LookupTable']

@pulumi.input_type
class LookupTableArgs:
    def __init__(__self__, *,
                 description: pulumi.Input[str],
                 fields: Optional[pulumi.Input[Sequence[pulumi.Input['LookupTableFieldArgs']]]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 parent_folder_id: Optional[pulumi.Input[str]] = None,
                 primary_keys: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 size_limit_action: Optional[pulumi.Input[str]] = None,
                 ttl: Optional[pulumi.Input[int]] = None):
        """
        The set of arguments for constructing a LookupTable resource.
        :param pulumi.Input[str] description: The description of the lookup table.
        :param pulumi.Input[Sequence[pulumi.Input['LookupTableFieldArgs']]] fields: The list of fields in the lookup table.
        :param pulumi.Input[str] name: The name of the lookup table.
        :param pulumi.Input[str] parent_folder_id: The parent-folder-path identifier of the lookup table in the Library.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] primary_keys: The primary key field names.
        :param pulumi.Input[int] ttl: A time to live for each entry in the lookup table (in minutes). 365 days is the maximum time to live for each entry that you can specify. Setting it to 0 means that the records will not expire automatically.
        """
        pulumi.set(__self__, "description", description)
        if fields is not None:
            pulumi.set(__self__, "fields", fields)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if parent_folder_id is not None:
            pulumi.set(__self__, "parent_folder_id", parent_folder_id)
        if primary_keys is not None:
            pulumi.set(__self__, "primary_keys", primary_keys)
        if size_limit_action is not None:
            pulumi.set(__self__, "size_limit_action", size_limit_action)
        if ttl is not None:
            pulumi.set(__self__, "ttl", ttl)

    @property
    @pulumi.getter
    def description(self) -> pulumi.Input[str]:
        """
        The description of the lookup table.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: pulumi.Input[str]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def fields(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['LookupTableFieldArgs']]]]:
        """
        The list of fields in the lookup table.
        """
        return pulumi.get(self, "fields")

    @fields.setter
    def fields(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['LookupTableFieldArgs']]]]):
        pulumi.set(self, "fields", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the lookup table.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="parentFolderId")
    def parent_folder_id(self) -> Optional[pulumi.Input[str]]:
        """
        The parent-folder-path identifier of the lookup table in the Library.
        """
        return pulumi.get(self, "parent_folder_id")

    @parent_folder_id.setter
    def parent_folder_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "parent_folder_id", value)

    @property
    @pulumi.getter(name="primaryKeys")
    def primary_keys(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The primary key field names.
        """
        return pulumi.get(self, "primary_keys")

    @primary_keys.setter
    def primary_keys(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "primary_keys", value)

    @property
    @pulumi.getter(name="sizeLimitAction")
    def size_limit_action(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "size_limit_action")

    @size_limit_action.setter
    def size_limit_action(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "size_limit_action", value)

    @property
    @pulumi.getter
    def ttl(self) -> Optional[pulumi.Input[int]]:
        """
        A time to live for each entry in the lookup table (in minutes). 365 days is the maximum time to live for each entry that you can specify. Setting it to 0 means that the records will not expire automatically.
        """
        return pulumi.get(self, "ttl")

    @ttl.setter
    def ttl(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "ttl", value)


@pulumi.input_type
class _LookupTableState:
    def __init__(__self__, *,
                 description: Optional[pulumi.Input[str]] = None,
                 fields: Optional[pulumi.Input[Sequence[pulumi.Input['LookupTableFieldArgs']]]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 parent_folder_id: Optional[pulumi.Input[str]] = None,
                 primary_keys: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 size_limit_action: Optional[pulumi.Input[str]] = None,
                 ttl: Optional[pulumi.Input[int]] = None):
        """
        Input properties used for looking up and filtering LookupTable resources.
        :param pulumi.Input[str] description: The description of the lookup table.
        :param pulumi.Input[Sequence[pulumi.Input['LookupTableFieldArgs']]] fields: The list of fields in the lookup table.
        :param pulumi.Input[str] name: The name of the lookup table.
        :param pulumi.Input[str] parent_folder_id: The parent-folder-path identifier of the lookup table in the Library.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] primary_keys: The primary key field names.
        :param pulumi.Input[int] ttl: A time to live for each entry in the lookup table (in minutes). 365 days is the maximum time to live for each entry that you can specify. Setting it to 0 means that the records will not expire automatically.
        """
        if description is not None:
            pulumi.set(__self__, "description", description)
        if fields is not None:
            pulumi.set(__self__, "fields", fields)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if parent_folder_id is not None:
            pulumi.set(__self__, "parent_folder_id", parent_folder_id)
        if primary_keys is not None:
            pulumi.set(__self__, "primary_keys", primary_keys)
        if size_limit_action is not None:
            pulumi.set(__self__, "size_limit_action", size_limit_action)
        if ttl is not None:
            pulumi.set(__self__, "ttl", ttl)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        The description of the lookup table.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def fields(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['LookupTableFieldArgs']]]]:
        """
        The list of fields in the lookup table.
        """
        return pulumi.get(self, "fields")

    @fields.setter
    def fields(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['LookupTableFieldArgs']]]]):
        pulumi.set(self, "fields", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the lookup table.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="parentFolderId")
    def parent_folder_id(self) -> Optional[pulumi.Input[str]]:
        """
        The parent-folder-path identifier of the lookup table in the Library.
        """
        return pulumi.get(self, "parent_folder_id")

    @parent_folder_id.setter
    def parent_folder_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "parent_folder_id", value)

    @property
    @pulumi.getter(name="primaryKeys")
    def primary_keys(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The primary key field names.
        """
        return pulumi.get(self, "primary_keys")

    @primary_keys.setter
    def primary_keys(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "primary_keys", value)

    @property
    @pulumi.getter(name="sizeLimitAction")
    def size_limit_action(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "size_limit_action")

    @size_limit_action.setter
    def size_limit_action(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "size_limit_action", value)

    @property
    @pulumi.getter
    def ttl(self) -> Optional[pulumi.Input[int]]:
        """
        A time to live for each entry in the lookup table (in minutes). 365 days is the maximum time to live for each entry that you can specify. Setting it to 0 means that the records will not expire automatically.
        """
        return pulumi.get(self, "ttl")

    @ttl.setter
    def ttl(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "ttl", value)


class LookupTable(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 fields: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['LookupTableFieldArgs']]]]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 parent_folder_id: Optional[pulumi.Input[str]] = None,
                 primary_keys: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 size_limit_action: Optional[pulumi.Input[str]] = None,
                 ttl: Optional[pulumi.Input[int]] = None,
                 __props__=None):
        """
        Provides a [Sumologic Lookup Table](https://help.sumologic.com/05Search/Lookup_Tables).

        ## Example Usage

        ```python
        import pulumi
        import pulumi_sumologic as sumologic

        lookup_table = sumologic.LookupTable("lookupTable",
            description="some description",
            fields=[
                sumologic.LookupTableFieldArgs(
                    field_name="FieldName1",
                    field_type="boolean",
                ),
                sumologic.LookupTableFieldArgs(
                    field_name="FieldName2",
                    field_type="string",
                ),
            ],
            parent_folder_id="<personal folder id>",
            primary_keys=["FieldName1"],
            size_limit_action="DeleteOldData",
            ttl=100)
        ```
        ## Attributes reference

        The following attributes are exported:

        - `id` - Unique identifier for the partition.

        ## Import

        Lookup Tables can be imported using the id, e.g.hcl

        ```sh
         $ pulumi import sumologic:index/lookupTable:LookupTable test 1234567890
        ```

         [1]https://help.sumologic.com/05Search/Lookup_Tables

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] description: The description of the lookup table.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['LookupTableFieldArgs']]]] fields: The list of fields in the lookup table.
        :param pulumi.Input[str] name: The name of the lookup table.
        :param pulumi.Input[str] parent_folder_id: The parent-folder-path identifier of the lookup table in the Library.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] primary_keys: The primary key field names.
        :param pulumi.Input[int] ttl: A time to live for each entry in the lookup table (in minutes). 365 days is the maximum time to live for each entry that you can specify. Setting it to 0 means that the records will not expire automatically.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: LookupTableArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a [Sumologic Lookup Table](https://help.sumologic.com/05Search/Lookup_Tables).

        ## Example Usage

        ```python
        import pulumi
        import pulumi_sumologic as sumologic

        lookup_table = sumologic.LookupTable("lookupTable",
            description="some description",
            fields=[
                sumologic.LookupTableFieldArgs(
                    field_name="FieldName1",
                    field_type="boolean",
                ),
                sumologic.LookupTableFieldArgs(
                    field_name="FieldName2",
                    field_type="string",
                ),
            ],
            parent_folder_id="<personal folder id>",
            primary_keys=["FieldName1"],
            size_limit_action="DeleteOldData",
            ttl=100)
        ```
        ## Attributes reference

        The following attributes are exported:

        - `id` - Unique identifier for the partition.

        ## Import

        Lookup Tables can be imported using the id, e.g.hcl

        ```sh
         $ pulumi import sumologic:index/lookupTable:LookupTable test 1234567890
        ```

         [1]https://help.sumologic.com/05Search/Lookup_Tables

        :param str resource_name: The name of the resource.
        :param LookupTableArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(LookupTableArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 fields: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['LookupTableFieldArgs']]]]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 parent_folder_id: Optional[pulumi.Input[str]] = None,
                 primary_keys: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 size_limit_action: Optional[pulumi.Input[str]] = None,
                 ttl: Optional[pulumi.Input[int]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = LookupTableArgs.__new__(LookupTableArgs)

            if description is None and not opts.urn:
                raise TypeError("Missing required property 'description'")
            __props__.__dict__["description"] = description
            __props__.__dict__["fields"] = fields
            __props__.__dict__["name"] = name
            __props__.__dict__["parent_folder_id"] = parent_folder_id
            __props__.__dict__["primary_keys"] = primary_keys
            __props__.__dict__["size_limit_action"] = size_limit_action
            __props__.__dict__["ttl"] = ttl
        super(LookupTable, __self__).__init__(
            'sumologic:index/lookupTable:LookupTable',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            description: Optional[pulumi.Input[str]] = None,
            fields: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['LookupTableFieldArgs']]]]] = None,
            name: Optional[pulumi.Input[str]] = None,
            parent_folder_id: Optional[pulumi.Input[str]] = None,
            primary_keys: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            size_limit_action: Optional[pulumi.Input[str]] = None,
            ttl: Optional[pulumi.Input[int]] = None) -> 'LookupTable':
        """
        Get an existing LookupTable resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] description: The description of the lookup table.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['LookupTableFieldArgs']]]] fields: The list of fields in the lookup table.
        :param pulumi.Input[str] name: The name of the lookup table.
        :param pulumi.Input[str] parent_folder_id: The parent-folder-path identifier of the lookup table in the Library.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] primary_keys: The primary key field names.
        :param pulumi.Input[int] ttl: A time to live for each entry in the lookup table (in minutes). 365 days is the maximum time to live for each entry that you can specify. Setting it to 0 means that the records will not expire automatically.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _LookupTableState.__new__(_LookupTableState)

        __props__.__dict__["description"] = description
        __props__.__dict__["fields"] = fields
        __props__.__dict__["name"] = name
        __props__.__dict__["parent_folder_id"] = parent_folder_id
        __props__.__dict__["primary_keys"] = primary_keys
        __props__.__dict__["size_limit_action"] = size_limit_action
        __props__.__dict__["ttl"] = ttl
        return LookupTable(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[str]:
        """
        The description of the lookup table.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def fields(self) -> pulumi.Output[Optional[Sequence['outputs.LookupTableField']]]:
        """
        The list of fields in the lookup table.
        """
        return pulumi.get(self, "fields")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        The name of the lookup table.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="parentFolderId")
    def parent_folder_id(self) -> pulumi.Output[Optional[str]]:
        """
        The parent-folder-path identifier of the lookup table in the Library.
        """
        return pulumi.get(self, "parent_folder_id")

    @property
    @pulumi.getter(name="primaryKeys")
    def primary_keys(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        The primary key field names.
        """
        return pulumi.get(self, "primary_keys")

    @property
    @pulumi.getter(name="sizeLimitAction")
    def size_limit_action(self) -> pulumi.Output[Optional[str]]:
        return pulumi.get(self, "size_limit_action")

    @property
    @pulumi.getter
    def ttl(self) -> pulumi.Output[Optional[int]]:
        """
        A time to live for each entry in the lookup table (in minutes). 365 days is the maximum time to live for each entry that you can specify. Setting it to 0 means that the records will not expire automatically.
        """
        return pulumi.get(self, "ttl")

