# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['MonitorArgs', 'Monitor']

@pulumi.input_type
class MonitorArgs:
    def __init__(__self__, *,
                 monitor_type: pulumi.Input[str],
                 alert_name: Optional[pulumi.Input[str]] = None,
                 content_type: Optional[pulumi.Input[str]] = None,
                 created_at: Optional[pulumi.Input[str]] = None,
                 created_by: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 evaluation_delay: Optional[pulumi.Input[str]] = None,
                 group_notifications: Optional[pulumi.Input[bool]] = None,
                 is_disabled: Optional[pulumi.Input[bool]] = None,
                 is_locked: Optional[pulumi.Input[bool]] = None,
                 is_mutable: Optional[pulumi.Input[bool]] = None,
                 is_system: Optional[pulumi.Input[bool]] = None,
                 modified_at: Optional[pulumi.Input[str]] = None,
                 modified_by: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 notification_group_fields: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 notifications: Optional[pulumi.Input[Sequence[pulumi.Input['MonitorNotificationArgs']]]] = None,
                 obj_permissions: Optional[pulumi.Input[Sequence[pulumi.Input['MonitorObjPermissionArgs']]]] = None,
                 parent_id: Optional[pulumi.Input[str]] = None,
                 playbook: Optional[pulumi.Input[str]] = None,
                 post_request_map: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 queries: Optional[pulumi.Input[Sequence[pulumi.Input['MonitorQueryArgs']]]] = None,
                 slo_id: Optional[pulumi.Input[str]] = None,
                 statuses: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 time_zone: Optional[pulumi.Input[str]] = None,
                 trigger_conditions: Optional[pulumi.Input['MonitorTriggerConditionsArgs']] = None,
                 triggers: Optional[pulumi.Input[Sequence[pulumi.Input['MonitorTriggerArgs']]]] = None,
                 type: Optional[pulumi.Input[str]] = None,
                 version: Optional[pulumi.Input[int]] = None):
        """
        The set of arguments for constructing a Monitor resource.
        :param pulumi.Input[str] monitor_type: The type of monitor. Valid values:
        :param pulumi.Input[str] alert_name: The display name when creating alerts. Monitor name will be used if `alert_name` is not provided. All template variables can be used in `alert_name` except `{{AlertName}}`, `{{AlertResponseURL}}`, `{{ResultsJson}}`, and `{{Playbook}}`.
        :param pulumi.Input[str] content_type: The type of the content object. Valid value:
        :param pulumi.Input[str] description: The description of the monitor.
        :param pulumi.Input[str] evaluation_delay: Evaluation delay as a string consists of the following elements:
               1. `<number>`: number of time units,
               2. `<time_unit>`: time unit; possible values are: `h` (hour), `m` (minute), `s` (second).
               
               Multiple pairs of `<number><time_unit>` may be provided. For example,
               `2m50s` means 2 minutes and 50 seconds.
        :param pulumi.Input[bool] group_notifications: Whether or not to group notifications for individual items that meet the trigger condition. Defaults to true.
        :param pulumi.Input[bool] is_disabled: Whether or not the monitor is disabled. Disabled monitors will not run and will not generate or send notifications.
        :param pulumi.Input[str] name: The name of the monitor. The name must be alphanumeric.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] notification_group_fields: The set of fields to be used to group alerts and notifications for a monitor. The value of this field will be considered only when 'groupNotifications' is true. The fields with very high cardinality such as `_blockid`, `_raw`, `_messagetime`, `_receipttime`, and `_messageid` are not allowed for Alert Grouping.
        :param pulumi.Input[Sequence[pulumi.Input['MonitorNotificationArgs']]] notifications: The notifications the monitor will send when the respective trigger condition is met.
        :param pulumi.Input[Sequence[pulumi.Input['MonitorObjPermissionArgs']]] obj_permissions: `obj_permission` construct represents a Permission Statement associated with this Monitor. A set of `obj_permission` constructs can be specified under a Monitor. An `obj_permission` construct can be used to control permissions Explicitly associated with a Monitor. But, it cannot be used to control permissions Inherited from a Parent / Ancestor. Default FGP would be still set to the Monitor upon creation (e.g. the creating user would have full permission), even if no `obj_permission` construct is specified at a Monitor and the FGP feature is enabled at the account.
        :param pulumi.Input[str] parent_id: The ID of the Monitor Folder that contains this monitor. Defaults to the root folder.
        :param pulumi.Input[str] playbook: Notes such as links and instruction to help you resolve alerts triggered by this monitor. {{Markdown}} supported. It will be enabled only if available for your organization. Please contact your Sumo Logic account team to learn more.
        :param pulumi.Input[Sequence[pulumi.Input['MonitorQueryArgs']]] queries: All queries from the monitor.
        :param pulumi.Input[str] slo_id: Identifier of the SLO definition for the monitor. This is only applicable & required for Slo `monitor_type`.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] statuses: The current status for this monitor. Values are:
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: A map defining tag keys and tag values for the Monitor.
        :param pulumi.Input['MonitorTriggerConditionsArgs'] trigger_conditions: Defines the conditions of when to send notifications. NOTE: `trigger_conditions` supplants the `triggers` argument.
        :param pulumi.Input[Sequence[pulumi.Input['MonitorTriggerArgs']]] triggers: Defines the conditions of when to send notifications.
        :param pulumi.Input[str] type: The type of object model. Valid value:
        """
        pulumi.set(__self__, "monitor_type", monitor_type)
        if alert_name is not None:
            pulumi.set(__self__, "alert_name", alert_name)
        if content_type is not None:
            pulumi.set(__self__, "content_type", content_type)
        if created_at is not None:
            pulumi.set(__self__, "created_at", created_at)
        if created_by is not None:
            pulumi.set(__self__, "created_by", created_by)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if evaluation_delay is not None:
            pulumi.set(__self__, "evaluation_delay", evaluation_delay)
        if group_notifications is not None:
            pulumi.set(__self__, "group_notifications", group_notifications)
        if is_disabled is not None:
            pulumi.set(__self__, "is_disabled", is_disabled)
        if is_locked is not None:
            pulumi.set(__self__, "is_locked", is_locked)
        if is_mutable is not None:
            pulumi.set(__self__, "is_mutable", is_mutable)
        if is_system is not None:
            pulumi.set(__self__, "is_system", is_system)
        if modified_at is not None:
            pulumi.set(__self__, "modified_at", modified_at)
        if modified_by is not None:
            pulumi.set(__self__, "modified_by", modified_by)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if notification_group_fields is not None:
            pulumi.set(__self__, "notification_group_fields", notification_group_fields)
        if notifications is not None:
            pulumi.set(__self__, "notifications", notifications)
        if obj_permissions is not None:
            pulumi.set(__self__, "obj_permissions", obj_permissions)
        if parent_id is not None:
            pulumi.set(__self__, "parent_id", parent_id)
        if playbook is not None:
            pulumi.set(__self__, "playbook", playbook)
        if post_request_map is not None:
            pulumi.set(__self__, "post_request_map", post_request_map)
        if queries is not None:
            pulumi.set(__self__, "queries", queries)
        if slo_id is not None:
            pulumi.set(__self__, "slo_id", slo_id)
        if statuses is not None:
            pulumi.set(__self__, "statuses", statuses)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if time_zone is not None:
            pulumi.set(__self__, "time_zone", time_zone)
        if trigger_conditions is not None:
            pulumi.set(__self__, "trigger_conditions", trigger_conditions)
        if triggers is not None:
            warnings.warn("""The field `triggers` is deprecated and will be removed in a future release of the provider -- please use `trigger_conditions` instead.""", DeprecationWarning)
            pulumi.log.warn("""triggers is deprecated: The field `triggers` is deprecated and will be removed in a future release of the provider -- please use `trigger_conditions` instead.""")
        if triggers is not None:
            pulumi.set(__self__, "triggers", triggers)
        if type is not None:
            pulumi.set(__self__, "type", type)
        if version is not None:
            pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter(name="monitorType")
    def monitor_type(self) -> pulumi.Input[str]:
        """
        The type of monitor. Valid values:
        """
        return pulumi.get(self, "monitor_type")

    @monitor_type.setter
    def monitor_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "monitor_type", value)

    @property
    @pulumi.getter(name="alertName")
    def alert_name(self) -> Optional[pulumi.Input[str]]:
        """
        The display name when creating alerts. Monitor name will be used if `alert_name` is not provided. All template variables can be used in `alert_name` except `{{AlertName}}`, `{{AlertResponseURL}}`, `{{ResultsJson}}`, and `{{Playbook}}`.
        """
        return pulumi.get(self, "alert_name")

    @alert_name.setter
    def alert_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "alert_name", value)

    @property
    @pulumi.getter(name="contentType")
    def content_type(self) -> Optional[pulumi.Input[str]]:
        """
        The type of the content object. Valid value:
        """
        return pulumi.get(self, "content_type")

    @content_type.setter
    def content_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "content_type", value)

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "created_at")

    @created_at.setter
    def created_at(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "created_at", value)

    @property
    @pulumi.getter(name="createdBy")
    def created_by(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "created_by")

    @created_by.setter
    def created_by(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "created_by", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        The description of the monitor.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="evaluationDelay")
    def evaluation_delay(self) -> Optional[pulumi.Input[str]]:
        """
        Evaluation delay as a string consists of the following elements:
        1. `<number>`: number of time units,
        2. `<time_unit>`: time unit; possible values are: `h` (hour), `m` (minute), `s` (second).

        Multiple pairs of `<number><time_unit>` may be provided. For example,
        `2m50s` means 2 minutes and 50 seconds.
        """
        return pulumi.get(self, "evaluation_delay")

    @evaluation_delay.setter
    def evaluation_delay(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "evaluation_delay", value)

    @property
    @pulumi.getter(name="groupNotifications")
    def group_notifications(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether or not to group notifications for individual items that meet the trigger condition. Defaults to true.
        """
        return pulumi.get(self, "group_notifications")

    @group_notifications.setter
    def group_notifications(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "group_notifications", value)

    @property
    @pulumi.getter(name="isDisabled")
    def is_disabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether or not the monitor is disabled. Disabled monitors will not run and will not generate or send notifications.
        """
        return pulumi.get(self, "is_disabled")

    @is_disabled.setter
    def is_disabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_disabled", value)

    @property
    @pulumi.getter(name="isLocked")
    def is_locked(self) -> Optional[pulumi.Input[bool]]:
        return pulumi.get(self, "is_locked")

    @is_locked.setter
    def is_locked(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_locked", value)

    @property
    @pulumi.getter(name="isMutable")
    def is_mutable(self) -> Optional[pulumi.Input[bool]]:
        return pulumi.get(self, "is_mutable")

    @is_mutable.setter
    def is_mutable(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_mutable", value)

    @property
    @pulumi.getter(name="isSystem")
    def is_system(self) -> Optional[pulumi.Input[bool]]:
        return pulumi.get(self, "is_system")

    @is_system.setter
    def is_system(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_system", value)

    @property
    @pulumi.getter(name="modifiedAt")
    def modified_at(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "modified_at")

    @modified_at.setter
    def modified_at(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "modified_at", value)

    @property
    @pulumi.getter(name="modifiedBy")
    def modified_by(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "modified_by")

    @modified_by.setter
    def modified_by(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "modified_by", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the monitor. The name must be alphanumeric.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="notificationGroupFields")
    def notification_group_fields(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The set of fields to be used to group alerts and notifications for a monitor. The value of this field will be considered only when 'groupNotifications' is true. The fields with very high cardinality such as `_blockid`, `_raw`, `_messagetime`, `_receipttime`, and `_messageid` are not allowed for Alert Grouping.
        """
        return pulumi.get(self, "notification_group_fields")

    @notification_group_fields.setter
    def notification_group_fields(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "notification_group_fields", value)

    @property
    @pulumi.getter
    def notifications(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['MonitorNotificationArgs']]]]:
        """
        The notifications the monitor will send when the respective trigger condition is met.
        """
        return pulumi.get(self, "notifications")

    @notifications.setter
    def notifications(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['MonitorNotificationArgs']]]]):
        pulumi.set(self, "notifications", value)

    @property
    @pulumi.getter(name="objPermissions")
    def obj_permissions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['MonitorObjPermissionArgs']]]]:
        """
        `obj_permission` construct represents a Permission Statement associated with this Monitor. A set of `obj_permission` constructs can be specified under a Monitor. An `obj_permission` construct can be used to control permissions Explicitly associated with a Monitor. But, it cannot be used to control permissions Inherited from a Parent / Ancestor. Default FGP would be still set to the Monitor upon creation (e.g. the creating user would have full permission), even if no `obj_permission` construct is specified at a Monitor and the FGP feature is enabled at the account.
        """
        return pulumi.get(self, "obj_permissions")

    @obj_permissions.setter
    def obj_permissions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['MonitorObjPermissionArgs']]]]):
        pulumi.set(self, "obj_permissions", value)

    @property
    @pulumi.getter(name="parentId")
    def parent_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the Monitor Folder that contains this monitor. Defaults to the root folder.
        """
        return pulumi.get(self, "parent_id")

    @parent_id.setter
    def parent_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "parent_id", value)

    @property
    @pulumi.getter
    def playbook(self) -> Optional[pulumi.Input[str]]:
        """
        Notes such as links and instruction to help you resolve alerts triggered by this monitor. {{Markdown}} supported. It will be enabled only if available for your organization. Please contact your Sumo Logic account team to learn more.
        """
        return pulumi.get(self, "playbook")

    @playbook.setter
    def playbook(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "playbook", value)

    @property
    @pulumi.getter(name="postRequestMap")
    def post_request_map(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        return pulumi.get(self, "post_request_map")

    @post_request_map.setter
    def post_request_map(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "post_request_map", value)

    @property
    @pulumi.getter
    def queries(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['MonitorQueryArgs']]]]:
        """
        All queries from the monitor.
        """
        return pulumi.get(self, "queries")

    @queries.setter
    def queries(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['MonitorQueryArgs']]]]):
        pulumi.set(self, "queries", value)

    @property
    @pulumi.getter(name="sloId")
    def slo_id(self) -> Optional[pulumi.Input[str]]:
        """
        Identifier of the SLO definition for the monitor. This is only applicable & required for Slo `monitor_type`.
        """
        return pulumi.get(self, "slo_id")

    @slo_id.setter
    def slo_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "slo_id", value)

    @property
    @pulumi.getter
    def statuses(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The current status for this monitor. Values are:
        """
        return pulumi.get(self, "statuses")

    @statuses.setter
    def statuses(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "statuses", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        A map defining tag keys and tag values for the Monitor.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="timeZone")
    def time_zone(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "time_zone")

    @time_zone.setter
    def time_zone(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "time_zone", value)

    @property
    @pulumi.getter(name="triggerConditions")
    def trigger_conditions(self) -> Optional[pulumi.Input['MonitorTriggerConditionsArgs']]:
        """
        Defines the conditions of when to send notifications. NOTE: `trigger_conditions` supplants the `triggers` argument.
        """
        return pulumi.get(self, "trigger_conditions")

    @trigger_conditions.setter
    def trigger_conditions(self, value: Optional[pulumi.Input['MonitorTriggerConditionsArgs']]):
        pulumi.set(self, "trigger_conditions", value)

    @property
    @pulumi.getter
    def triggers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['MonitorTriggerArgs']]]]:
        """
        Defines the conditions of when to send notifications.
        """
        warnings.warn("""The field `triggers` is deprecated and will be removed in a future release of the provider -- please use `trigger_conditions` instead.""", DeprecationWarning)
        pulumi.log.warn("""triggers is deprecated: The field `triggers` is deprecated and will be removed in a future release of the provider -- please use `trigger_conditions` instead.""")

        return pulumi.get(self, "triggers")

    @triggers.setter
    def triggers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['MonitorTriggerArgs']]]]):
        pulumi.set(self, "triggers", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[str]]:
        """
        The type of object model. Valid value:
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter
    def version(self) -> Optional[pulumi.Input[int]]:
        return pulumi.get(self, "version")

    @version.setter
    def version(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "version", value)


@pulumi.input_type
class _MonitorState:
    def __init__(__self__, *,
                 alert_name: Optional[pulumi.Input[str]] = None,
                 content_type: Optional[pulumi.Input[str]] = None,
                 created_at: Optional[pulumi.Input[str]] = None,
                 created_by: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 evaluation_delay: Optional[pulumi.Input[str]] = None,
                 group_notifications: Optional[pulumi.Input[bool]] = None,
                 is_disabled: Optional[pulumi.Input[bool]] = None,
                 is_locked: Optional[pulumi.Input[bool]] = None,
                 is_mutable: Optional[pulumi.Input[bool]] = None,
                 is_system: Optional[pulumi.Input[bool]] = None,
                 modified_at: Optional[pulumi.Input[str]] = None,
                 modified_by: Optional[pulumi.Input[str]] = None,
                 monitor_type: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 notification_group_fields: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 notifications: Optional[pulumi.Input[Sequence[pulumi.Input['MonitorNotificationArgs']]]] = None,
                 obj_permissions: Optional[pulumi.Input[Sequence[pulumi.Input['MonitorObjPermissionArgs']]]] = None,
                 parent_id: Optional[pulumi.Input[str]] = None,
                 playbook: Optional[pulumi.Input[str]] = None,
                 post_request_map: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 queries: Optional[pulumi.Input[Sequence[pulumi.Input['MonitorQueryArgs']]]] = None,
                 slo_id: Optional[pulumi.Input[str]] = None,
                 statuses: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 time_zone: Optional[pulumi.Input[str]] = None,
                 trigger_conditions: Optional[pulumi.Input['MonitorTriggerConditionsArgs']] = None,
                 triggers: Optional[pulumi.Input[Sequence[pulumi.Input['MonitorTriggerArgs']]]] = None,
                 type: Optional[pulumi.Input[str]] = None,
                 version: Optional[pulumi.Input[int]] = None):
        """
        Input properties used for looking up and filtering Monitor resources.
        :param pulumi.Input[str] alert_name: The display name when creating alerts. Monitor name will be used if `alert_name` is not provided. All template variables can be used in `alert_name` except `{{AlertName}}`, `{{AlertResponseURL}}`, `{{ResultsJson}}`, and `{{Playbook}}`.
        :param pulumi.Input[str] content_type: The type of the content object. Valid value:
        :param pulumi.Input[str] description: The description of the monitor.
        :param pulumi.Input[str] evaluation_delay: Evaluation delay as a string consists of the following elements:
               1. `<number>`: number of time units,
               2. `<time_unit>`: time unit; possible values are: `h` (hour), `m` (minute), `s` (second).
               
               Multiple pairs of `<number><time_unit>` may be provided. For example,
               `2m50s` means 2 minutes and 50 seconds.
        :param pulumi.Input[bool] group_notifications: Whether or not to group notifications for individual items that meet the trigger condition. Defaults to true.
        :param pulumi.Input[bool] is_disabled: Whether or not the monitor is disabled. Disabled monitors will not run and will not generate or send notifications.
        :param pulumi.Input[str] monitor_type: The type of monitor. Valid values:
        :param pulumi.Input[str] name: The name of the monitor. The name must be alphanumeric.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] notification_group_fields: The set of fields to be used to group alerts and notifications for a monitor. The value of this field will be considered only when 'groupNotifications' is true. The fields with very high cardinality such as `_blockid`, `_raw`, `_messagetime`, `_receipttime`, and `_messageid` are not allowed for Alert Grouping.
        :param pulumi.Input[Sequence[pulumi.Input['MonitorNotificationArgs']]] notifications: The notifications the monitor will send when the respective trigger condition is met.
        :param pulumi.Input[Sequence[pulumi.Input['MonitorObjPermissionArgs']]] obj_permissions: `obj_permission` construct represents a Permission Statement associated with this Monitor. A set of `obj_permission` constructs can be specified under a Monitor. An `obj_permission` construct can be used to control permissions Explicitly associated with a Monitor. But, it cannot be used to control permissions Inherited from a Parent / Ancestor. Default FGP would be still set to the Monitor upon creation (e.g. the creating user would have full permission), even if no `obj_permission` construct is specified at a Monitor and the FGP feature is enabled at the account.
        :param pulumi.Input[str] parent_id: The ID of the Monitor Folder that contains this monitor. Defaults to the root folder.
        :param pulumi.Input[str] playbook: Notes such as links and instruction to help you resolve alerts triggered by this monitor. {{Markdown}} supported. It will be enabled only if available for your organization. Please contact your Sumo Logic account team to learn more.
        :param pulumi.Input[Sequence[pulumi.Input['MonitorQueryArgs']]] queries: All queries from the monitor.
        :param pulumi.Input[str] slo_id: Identifier of the SLO definition for the monitor. This is only applicable & required for Slo `monitor_type`.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] statuses: The current status for this monitor. Values are:
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: A map defining tag keys and tag values for the Monitor.
        :param pulumi.Input['MonitorTriggerConditionsArgs'] trigger_conditions: Defines the conditions of when to send notifications. NOTE: `trigger_conditions` supplants the `triggers` argument.
        :param pulumi.Input[Sequence[pulumi.Input['MonitorTriggerArgs']]] triggers: Defines the conditions of when to send notifications.
        :param pulumi.Input[str] type: The type of object model. Valid value:
        """
        if alert_name is not None:
            pulumi.set(__self__, "alert_name", alert_name)
        if content_type is not None:
            pulumi.set(__self__, "content_type", content_type)
        if created_at is not None:
            pulumi.set(__self__, "created_at", created_at)
        if created_by is not None:
            pulumi.set(__self__, "created_by", created_by)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if evaluation_delay is not None:
            pulumi.set(__self__, "evaluation_delay", evaluation_delay)
        if group_notifications is not None:
            pulumi.set(__self__, "group_notifications", group_notifications)
        if is_disabled is not None:
            pulumi.set(__self__, "is_disabled", is_disabled)
        if is_locked is not None:
            pulumi.set(__self__, "is_locked", is_locked)
        if is_mutable is not None:
            pulumi.set(__self__, "is_mutable", is_mutable)
        if is_system is not None:
            pulumi.set(__self__, "is_system", is_system)
        if modified_at is not None:
            pulumi.set(__self__, "modified_at", modified_at)
        if modified_by is not None:
            pulumi.set(__self__, "modified_by", modified_by)
        if monitor_type is not None:
            pulumi.set(__self__, "monitor_type", monitor_type)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if notification_group_fields is not None:
            pulumi.set(__self__, "notification_group_fields", notification_group_fields)
        if notifications is not None:
            pulumi.set(__self__, "notifications", notifications)
        if obj_permissions is not None:
            pulumi.set(__self__, "obj_permissions", obj_permissions)
        if parent_id is not None:
            pulumi.set(__self__, "parent_id", parent_id)
        if playbook is not None:
            pulumi.set(__self__, "playbook", playbook)
        if post_request_map is not None:
            pulumi.set(__self__, "post_request_map", post_request_map)
        if queries is not None:
            pulumi.set(__self__, "queries", queries)
        if slo_id is not None:
            pulumi.set(__self__, "slo_id", slo_id)
        if statuses is not None:
            pulumi.set(__self__, "statuses", statuses)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if time_zone is not None:
            pulumi.set(__self__, "time_zone", time_zone)
        if trigger_conditions is not None:
            pulumi.set(__self__, "trigger_conditions", trigger_conditions)
        if triggers is not None:
            warnings.warn("""The field `triggers` is deprecated and will be removed in a future release of the provider -- please use `trigger_conditions` instead.""", DeprecationWarning)
            pulumi.log.warn("""triggers is deprecated: The field `triggers` is deprecated and will be removed in a future release of the provider -- please use `trigger_conditions` instead.""")
        if triggers is not None:
            pulumi.set(__self__, "triggers", triggers)
        if type is not None:
            pulumi.set(__self__, "type", type)
        if version is not None:
            pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter(name="alertName")
    def alert_name(self) -> Optional[pulumi.Input[str]]:
        """
        The display name when creating alerts. Monitor name will be used if `alert_name` is not provided. All template variables can be used in `alert_name` except `{{AlertName}}`, `{{AlertResponseURL}}`, `{{ResultsJson}}`, and `{{Playbook}}`.
        """
        return pulumi.get(self, "alert_name")

    @alert_name.setter
    def alert_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "alert_name", value)

    @property
    @pulumi.getter(name="contentType")
    def content_type(self) -> Optional[pulumi.Input[str]]:
        """
        The type of the content object. Valid value:
        """
        return pulumi.get(self, "content_type")

    @content_type.setter
    def content_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "content_type", value)

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "created_at")

    @created_at.setter
    def created_at(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "created_at", value)

    @property
    @pulumi.getter(name="createdBy")
    def created_by(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "created_by")

    @created_by.setter
    def created_by(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "created_by", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        The description of the monitor.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="evaluationDelay")
    def evaluation_delay(self) -> Optional[pulumi.Input[str]]:
        """
        Evaluation delay as a string consists of the following elements:
        1. `<number>`: number of time units,
        2. `<time_unit>`: time unit; possible values are: `h` (hour), `m` (minute), `s` (second).

        Multiple pairs of `<number><time_unit>` may be provided. For example,
        `2m50s` means 2 minutes and 50 seconds.
        """
        return pulumi.get(self, "evaluation_delay")

    @evaluation_delay.setter
    def evaluation_delay(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "evaluation_delay", value)

    @property
    @pulumi.getter(name="groupNotifications")
    def group_notifications(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether or not to group notifications for individual items that meet the trigger condition. Defaults to true.
        """
        return pulumi.get(self, "group_notifications")

    @group_notifications.setter
    def group_notifications(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "group_notifications", value)

    @property
    @pulumi.getter(name="isDisabled")
    def is_disabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether or not the monitor is disabled. Disabled monitors will not run and will not generate or send notifications.
        """
        return pulumi.get(self, "is_disabled")

    @is_disabled.setter
    def is_disabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_disabled", value)

    @property
    @pulumi.getter(name="isLocked")
    def is_locked(self) -> Optional[pulumi.Input[bool]]:
        return pulumi.get(self, "is_locked")

    @is_locked.setter
    def is_locked(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_locked", value)

    @property
    @pulumi.getter(name="isMutable")
    def is_mutable(self) -> Optional[pulumi.Input[bool]]:
        return pulumi.get(self, "is_mutable")

    @is_mutable.setter
    def is_mutable(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_mutable", value)

    @property
    @pulumi.getter(name="isSystem")
    def is_system(self) -> Optional[pulumi.Input[bool]]:
        return pulumi.get(self, "is_system")

    @is_system.setter
    def is_system(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_system", value)

    @property
    @pulumi.getter(name="modifiedAt")
    def modified_at(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "modified_at")

    @modified_at.setter
    def modified_at(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "modified_at", value)

    @property
    @pulumi.getter(name="modifiedBy")
    def modified_by(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "modified_by")

    @modified_by.setter
    def modified_by(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "modified_by", value)

    @property
    @pulumi.getter(name="monitorType")
    def monitor_type(self) -> Optional[pulumi.Input[str]]:
        """
        The type of monitor. Valid values:
        """
        return pulumi.get(self, "monitor_type")

    @monitor_type.setter
    def monitor_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "monitor_type", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the monitor. The name must be alphanumeric.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="notificationGroupFields")
    def notification_group_fields(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The set of fields to be used to group alerts and notifications for a monitor. The value of this field will be considered only when 'groupNotifications' is true. The fields with very high cardinality such as `_blockid`, `_raw`, `_messagetime`, `_receipttime`, and `_messageid` are not allowed for Alert Grouping.
        """
        return pulumi.get(self, "notification_group_fields")

    @notification_group_fields.setter
    def notification_group_fields(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "notification_group_fields", value)

    @property
    @pulumi.getter
    def notifications(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['MonitorNotificationArgs']]]]:
        """
        The notifications the monitor will send when the respective trigger condition is met.
        """
        return pulumi.get(self, "notifications")

    @notifications.setter
    def notifications(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['MonitorNotificationArgs']]]]):
        pulumi.set(self, "notifications", value)

    @property
    @pulumi.getter(name="objPermissions")
    def obj_permissions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['MonitorObjPermissionArgs']]]]:
        """
        `obj_permission` construct represents a Permission Statement associated with this Monitor. A set of `obj_permission` constructs can be specified under a Monitor. An `obj_permission` construct can be used to control permissions Explicitly associated with a Monitor. But, it cannot be used to control permissions Inherited from a Parent / Ancestor. Default FGP would be still set to the Monitor upon creation (e.g. the creating user would have full permission), even if no `obj_permission` construct is specified at a Monitor and the FGP feature is enabled at the account.
        """
        return pulumi.get(self, "obj_permissions")

    @obj_permissions.setter
    def obj_permissions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['MonitorObjPermissionArgs']]]]):
        pulumi.set(self, "obj_permissions", value)

    @property
    @pulumi.getter(name="parentId")
    def parent_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the Monitor Folder that contains this monitor. Defaults to the root folder.
        """
        return pulumi.get(self, "parent_id")

    @parent_id.setter
    def parent_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "parent_id", value)

    @property
    @pulumi.getter
    def playbook(self) -> Optional[pulumi.Input[str]]:
        """
        Notes such as links and instruction to help you resolve alerts triggered by this monitor. {{Markdown}} supported. It will be enabled only if available for your organization. Please contact your Sumo Logic account team to learn more.
        """
        return pulumi.get(self, "playbook")

    @playbook.setter
    def playbook(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "playbook", value)

    @property
    @pulumi.getter(name="postRequestMap")
    def post_request_map(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        return pulumi.get(self, "post_request_map")

    @post_request_map.setter
    def post_request_map(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "post_request_map", value)

    @property
    @pulumi.getter
    def queries(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['MonitorQueryArgs']]]]:
        """
        All queries from the monitor.
        """
        return pulumi.get(self, "queries")

    @queries.setter
    def queries(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['MonitorQueryArgs']]]]):
        pulumi.set(self, "queries", value)

    @property
    @pulumi.getter(name="sloId")
    def slo_id(self) -> Optional[pulumi.Input[str]]:
        """
        Identifier of the SLO definition for the monitor. This is only applicable & required for Slo `monitor_type`.
        """
        return pulumi.get(self, "slo_id")

    @slo_id.setter
    def slo_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "slo_id", value)

    @property
    @pulumi.getter
    def statuses(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The current status for this monitor. Values are:
        """
        return pulumi.get(self, "statuses")

    @statuses.setter
    def statuses(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "statuses", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        A map defining tag keys and tag values for the Monitor.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="timeZone")
    def time_zone(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "time_zone")

    @time_zone.setter
    def time_zone(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "time_zone", value)

    @property
    @pulumi.getter(name="triggerConditions")
    def trigger_conditions(self) -> Optional[pulumi.Input['MonitorTriggerConditionsArgs']]:
        """
        Defines the conditions of when to send notifications. NOTE: `trigger_conditions` supplants the `triggers` argument.
        """
        return pulumi.get(self, "trigger_conditions")

    @trigger_conditions.setter
    def trigger_conditions(self, value: Optional[pulumi.Input['MonitorTriggerConditionsArgs']]):
        pulumi.set(self, "trigger_conditions", value)

    @property
    @pulumi.getter
    def triggers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['MonitorTriggerArgs']]]]:
        """
        Defines the conditions of when to send notifications.
        """
        warnings.warn("""The field `triggers` is deprecated and will be removed in a future release of the provider -- please use `trigger_conditions` instead.""", DeprecationWarning)
        pulumi.log.warn("""triggers is deprecated: The field `triggers` is deprecated and will be removed in a future release of the provider -- please use `trigger_conditions` instead.""")

        return pulumi.get(self, "triggers")

    @triggers.setter
    def triggers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['MonitorTriggerArgs']]]]):
        pulumi.set(self, "triggers", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[str]]:
        """
        The type of object model. Valid value:
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter
    def version(self) -> Optional[pulumi.Input[int]]:
        return pulumi.get(self, "version")

    @version.setter
    def version(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "version", value)


class Monitor(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 alert_name: Optional[pulumi.Input[str]] = None,
                 content_type: Optional[pulumi.Input[str]] = None,
                 created_at: Optional[pulumi.Input[str]] = None,
                 created_by: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 evaluation_delay: Optional[pulumi.Input[str]] = None,
                 group_notifications: Optional[pulumi.Input[bool]] = None,
                 is_disabled: Optional[pulumi.Input[bool]] = None,
                 is_locked: Optional[pulumi.Input[bool]] = None,
                 is_mutable: Optional[pulumi.Input[bool]] = None,
                 is_system: Optional[pulumi.Input[bool]] = None,
                 modified_at: Optional[pulumi.Input[str]] = None,
                 modified_by: Optional[pulumi.Input[str]] = None,
                 monitor_type: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 notification_group_fields: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 notifications: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['MonitorNotificationArgs']]]]] = None,
                 obj_permissions: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['MonitorObjPermissionArgs']]]]] = None,
                 parent_id: Optional[pulumi.Input[str]] = None,
                 playbook: Optional[pulumi.Input[str]] = None,
                 post_request_map: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 queries: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['MonitorQueryArgs']]]]] = None,
                 slo_id: Optional[pulumi.Input[str]] = None,
                 statuses: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 time_zone: Optional[pulumi.Input[str]] = None,
                 trigger_conditions: Optional[pulumi.Input[pulumi.InputType['MonitorTriggerConditionsArgs']]] = None,
                 triggers: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['MonitorTriggerArgs']]]]] = None,
                 type: Optional[pulumi.Input[str]] = None,
                 version: Optional[pulumi.Input[int]] = None,
                 __props__=None):
        """
        Provides the ability to create, read, delete, and update [Monitors](https://help.sumologic.com/?cid=10020).
        If Fine Grain Permission (FGP) feature is enabled with Monitors Content at one's Sumo Logic account, one can also set those permission details under this monitor resource. For further details about FGP, please see this [Monitor Permission document](https://help.sumologic.com/Visualizations-and-Alerts/Alerts/Monitors#configure-permissions-for-a-monitor).

        ## Monitor Folders

        <<<<<<< HEAD
        NOTE: Monitor folders are considered a different resource from Library content folders.

        ```python
        import pulumi
        import pulumi_sumologic as sumologic

        tf_monitor_folder1 = sumologic.MonitorFolder("tfMonitorFolder1", description="a folder for monitors")
        ```
        =======
        NOTE: Monitor folders are considered a different resource from Library content folders. See [MonitorFolder][2] for more details.
        > > > > > > > v2.11.0

        ## The `trigger_conditions` block

        A `trigger_conditions` block configures conditions for sending notifications.
        ### Example
        ```python
        import pulumi
        ```
        ### Arguments
        A `trigger_conditions` block contains one or more subblocks of the following types:
        - `logs_static_condition`
        - `metrics_static_condition`
        - `logs_outlier_condition`
        - `metrics_outlier_condition`
        - `logs_missing_data_condition`
        - `metrics_missing_data_condition`
        - `slo_sli_condition`
        - `slo_burn_rate_condition`

        Subblocks should be limited to at most 1 missing data condition and at most 1 static / outlier condition.

        Here is a summary of arguments for each condition type (fields which are not marked as `Required` are optional):
        #### logs_static_condition
          - `field`
          - `critical`
            - `time_range` (Required) : Accepted format: Optional `-` sign followed by `<number>` followed by a `<time_unit>` character: `s` for seconds, `m` for minutes, `h` for hours, `d` for days. Examples: `30m`, `-12h`.
            - `alert` (Required)
              - `threshold`
              - `threshold_type`
            - `resolution` (Required)
              - `threshold`
              - `threshold_type`
              - `resolution_window` Accepted format: `<number>` followed by a `<time_unit>` character: `s` for seconds, `m` for minutes, `h` for hours, `d` for days. Examples: `0s, 30m`.
          - `warning`
            - `time_range` (Required) :  Accepted format: Optional `-` sign followed by `<number>` followed by a `<time_unit>` character: `s` for seconds, `m` for minutes, `h` for hours, `d` for days. Examples: `30m`, `-12h`.
            - `alert` (Required)
              - `threshold`
              - `threshold_type`
            - `resolution` (Required)
              - `threshold`
              - `threshold_type`
              - `resolution_window` Accepted format: `<number>` followed by a `<time_unit>` character: `s` for seconds, `m` for minutes, `h` for hours, `d` for days. Examples: `0s, 30m`.
        #### metrics_static_condition
          - `critical`
            - `time_range` (Required) :  Accepted format: Optional `-` sign followed by `<number>` followed by a `<time_unit>` character: `s` for seconds, `m` for minutes, `h` for hours, `d` for days. Examples: `30m`, `-12h`.
            - `occurrence_type` (Required)
            - `alert` (Required)
              - `threshold`
              - `threshold_type`
              - `min_data_points` (Optional)
            - `resolution` (Required)
              - `threshold`
              - `threshold_type`
              - `min_data_points` (Optional)
            - `warning`
            - `time_range` (Required) :  Accepted format: Optional `-` sign followed by `<number>` followed by a `<time_unit>` character: `s` for seconds, `m` for minutes, `h` for hours, `d` for days. Examples: `30m`, `-12h`.
            - `occurrence_type` (Required)
            - `alert` (Required)
              - `threshold`
              - `threshold_type`
              - `min_data_points` (Optional)
            - `resolution` (Required)
              - `threshold`
              - `threshold_type`
              - `min_data_points` (Optional)
        #### logs_outlier_condition
          - `field`
          - `direction`
          - `critical`
             - `window`
             - `consecutive`
             - `threshold`
          - `warning`
             - `window`
             - `consecutive`
             - `threshold`
        #### metrics_outlier_condition
          - `direction`
          - `critical`
             - `baseline_window`
             - `threshold`
          - `warning`
            - `baseline_window`
            - `threshold`
        #### logs_missing_data_condition
          - `time_range` (Required) :  Accepted format: Optional `-` sign followed by `<number>` followed by a `<time_unit>` character: `s` for seconds, `m` for minutes, `h` for hours, `d` for days. Examples: `30m`, `-12h`.
        #### metrics_missing_data_condition
          - `time_range` (Required) :  Accepted format: Optional `-` sign followed by `<number>` followed by a `<time_unit>` character: `s` for seconds, `m` for minutes, `h` for hours, `d` for days. Examples: `30m`, `-12h`.
        #### slo_sli_condition
          - `critical`
            - `sli_threshold` (Required) : The remaining SLI error budget threshold percentage [0,100).
          - `warning`
            - `sli_threshold` (Required)

        #### slo_burn_rate_condition
          - `critical`
            - `time_range` (Deprecated) : The relative time range for the burn rate percentage evaluation.  Accepted format: Optional `-` sign followed by `<number>` followed by a `<time_unit>` character: `s` for seconds, `m` for minutes, `h` for hours, `d` for days. Examples: `30m`, `-12h`.
            - `burn_rate_threshold` (Deprecated) : The burn rate percentage threshold.
            - `burn_rate` (Required if above two fields are not present): Block to specify burn rate threshold and time range for the condition.
              - `burn_rate_threshold` (Required): The burn rate percentage threshold.
              - `time_range` (Required): The relative time range for the burn rate percentage evaluation.  Accepted format: Optional `-` sign followed by `<number>` followed by a `<time_unit>` character: `s` for seconds, `m` for minutes, `h` for hours, `d` for days. Examples: `30m`, `-12h`.
          - `warning`
            - `time_range` (Deprecated) :  Accepted format: Optional `-` sign followed by `<number>` followed by a `<time_unit>` character: `s` for seconds, `m` for minutes, `h` for hours, `d` for days. Examples: `30m`, `-12h`.
            - `burn_rate_threshold` (Deprecated)
            - `burn_rate` (Required if above two fields are not present): Block to specify burn rate threshold and time range for the condition.
              - `burn_rate_threshold` (Required): The burn rate percentage threshold.
              - `time_range` (Required): The relative time range for the burn rate percentage evaluation.  Accepted format: Optional `-` sign followed by `<number>` followed by a `<time_unit>` character: `s` for seconds, `m` for minutes, `h` for hours, `d` for days. Examples: `30m`, `-12h`.

        ## The `triggers` block

        The `triggers` block is deprecated. Please use `trigger_conditions` to specify notification conditions.

        Here's an example logs monitor that uses `triggers` to specify trigger conditions:
        ```python
        import pulumi
        import pulumi_sumologic as sumologic

        tf_logs_monitor1 = sumologic.Monitor("tfLogsMonitor1",
            content_type="Monitor",
            description="tf logs monitor",
            is_disabled=False,
            monitor_type="Logs",
            notifications=[
                sumologic.MonitorNotificationArgs(
                    notification=sumologic.MonitorNotificationNotificationArgs(
                        connection_type="Email",
                        message_body="Triggered {{TriggerType}} Alert on {{Name}}: {{QueryURL}}",
                        recipients=["abc@example.com"],
                        subject="Monitor Alert: {{TriggerType}} on {{Name}}",
                        time_zone="PST",
                    ),
                    run_for_trigger_types=[
                        "Critical",
                        "ResolvedCritical",
                    ],
                ),
                sumologic.MonitorNotificationArgs(
                    notification=sumologic.MonitorNotificationNotificationArgs(
                        connection_id="0000000000ABC123",
                        connection_type="Webhook",
                    ),
                    run_for_trigger_types=[
                        "Critical",
                        "ResolvedCritical",
                    ],
                ),
            ],
            queries=[sumologic.MonitorQueryArgs(
                query="_sourceCategory=event-action info",
                row_id="A",
            )],
            triggers=[
                sumologic.MonitorTriggerArgs(
                    detection_method="StaticCondition",
                    occurrence_type="ResultCount",
                    threshold=40,
                    threshold_type="GreaterThan",
                    time_range="15m",
                    trigger_source="AllResults",
                    trigger_type="Critical",
                ),
                sumologic.MonitorTriggerArgs(
                    detection_method="StaticCondition",
                    occurrence_type="ResultCount",
                    resolution_window="5m",
                    threshold=40,
                    threshold_type="LessThanOrEqual",
                    time_range="15m",
                    trigger_source="AllResults",
                    trigger_type="ResolvedCritical",
                ),
            ],
            type="MonitorsLibraryMonitor")
        ```

        ## Import

        Monitors can be imported using the monitor ID, such ashcl

        ```sh
         $ pulumi import sumologic:index/monitor:Monitor test 1234567890
        ```

         [1]https://help.sumologic.com/?cid=10020 [2]monitor_folder.html.markdown [3]https://help.sumologic.com/Visualizations-and-Alerts/Alerts/Monitors#configure-permissions-for-a-monitor

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] alert_name: The display name when creating alerts. Monitor name will be used if `alert_name` is not provided. All template variables can be used in `alert_name` except `{{AlertName}}`, `{{AlertResponseURL}}`, `{{ResultsJson}}`, and `{{Playbook}}`.
        :param pulumi.Input[str] content_type: The type of the content object. Valid value:
        :param pulumi.Input[str] description: The description of the monitor.
        :param pulumi.Input[str] evaluation_delay: Evaluation delay as a string consists of the following elements:
               1. `<number>`: number of time units,
               2. `<time_unit>`: time unit; possible values are: `h` (hour), `m` (minute), `s` (second).
               
               Multiple pairs of `<number><time_unit>` may be provided. For example,
               `2m50s` means 2 minutes and 50 seconds.
        :param pulumi.Input[bool] group_notifications: Whether or not to group notifications for individual items that meet the trigger condition. Defaults to true.
        :param pulumi.Input[bool] is_disabled: Whether or not the monitor is disabled. Disabled monitors will not run and will not generate or send notifications.
        :param pulumi.Input[str] monitor_type: The type of monitor. Valid values:
        :param pulumi.Input[str] name: The name of the monitor. The name must be alphanumeric.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] notification_group_fields: The set of fields to be used to group alerts and notifications for a monitor. The value of this field will be considered only when 'groupNotifications' is true. The fields with very high cardinality such as `_blockid`, `_raw`, `_messagetime`, `_receipttime`, and `_messageid` are not allowed for Alert Grouping.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['MonitorNotificationArgs']]]] notifications: The notifications the monitor will send when the respective trigger condition is met.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['MonitorObjPermissionArgs']]]] obj_permissions: `obj_permission` construct represents a Permission Statement associated with this Monitor. A set of `obj_permission` constructs can be specified under a Monitor. An `obj_permission` construct can be used to control permissions Explicitly associated with a Monitor. But, it cannot be used to control permissions Inherited from a Parent / Ancestor. Default FGP would be still set to the Monitor upon creation (e.g. the creating user would have full permission), even if no `obj_permission` construct is specified at a Monitor and the FGP feature is enabled at the account.
        :param pulumi.Input[str] parent_id: The ID of the Monitor Folder that contains this monitor. Defaults to the root folder.
        :param pulumi.Input[str] playbook: Notes such as links and instruction to help you resolve alerts triggered by this monitor. {{Markdown}} supported. It will be enabled only if available for your organization. Please contact your Sumo Logic account team to learn more.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['MonitorQueryArgs']]]] queries: All queries from the monitor.
        :param pulumi.Input[str] slo_id: Identifier of the SLO definition for the monitor. This is only applicable & required for Slo `monitor_type`.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] statuses: The current status for this monitor. Values are:
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: A map defining tag keys and tag values for the Monitor.
        :param pulumi.Input[pulumi.InputType['MonitorTriggerConditionsArgs']] trigger_conditions: Defines the conditions of when to send notifications. NOTE: `trigger_conditions` supplants the `triggers` argument.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['MonitorTriggerArgs']]]] triggers: Defines the conditions of when to send notifications.
        :param pulumi.Input[str] type: The type of object model. Valid value:
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: MonitorArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides the ability to create, read, delete, and update [Monitors](https://help.sumologic.com/?cid=10020).
        If Fine Grain Permission (FGP) feature is enabled with Monitors Content at one's Sumo Logic account, one can also set those permission details under this monitor resource. For further details about FGP, please see this [Monitor Permission document](https://help.sumologic.com/Visualizations-and-Alerts/Alerts/Monitors#configure-permissions-for-a-monitor).

        ## Monitor Folders

        <<<<<<< HEAD
        NOTE: Monitor folders are considered a different resource from Library content folders.

        ```python
        import pulumi
        import pulumi_sumologic as sumologic

        tf_monitor_folder1 = sumologic.MonitorFolder("tfMonitorFolder1", description="a folder for monitors")
        ```
        =======
        NOTE: Monitor folders are considered a different resource from Library content folders. See [MonitorFolder][2] for more details.
        > > > > > > > v2.11.0

        ## The `trigger_conditions` block

        A `trigger_conditions` block configures conditions for sending notifications.
        ### Example
        ```python
        import pulumi
        ```
        ### Arguments
        A `trigger_conditions` block contains one or more subblocks of the following types:
        - `logs_static_condition`
        - `metrics_static_condition`
        - `logs_outlier_condition`
        - `metrics_outlier_condition`
        - `logs_missing_data_condition`
        - `metrics_missing_data_condition`
        - `slo_sli_condition`
        - `slo_burn_rate_condition`

        Subblocks should be limited to at most 1 missing data condition and at most 1 static / outlier condition.

        Here is a summary of arguments for each condition type (fields which are not marked as `Required` are optional):
        #### logs_static_condition
          - `field`
          - `critical`
            - `time_range` (Required) : Accepted format: Optional `-` sign followed by `<number>` followed by a `<time_unit>` character: `s` for seconds, `m` for minutes, `h` for hours, `d` for days. Examples: `30m`, `-12h`.
            - `alert` (Required)
              - `threshold`
              - `threshold_type`
            - `resolution` (Required)
              - `threshold`
              - `threshold_type`
              - `resolution_window` Accepted format: `<number>` followed by a `<time_unit>` character: `s` for seconds, `m` for minutes, `h` for hours, `d` for days. Examples: `0s, 30m`.
          - `warning`
            - `time_range` (Required) :  Accepted format: Optional `-` sign followed by `<number>` followed by a `<time_unit>` character: `s` for seconds, `m` for minutes, `h` for hours, `d` for days. Examples: `30m`, `-12h`.
            - `alert` (Required)
              - `threshold`
              - `threshold_type`
            - `resolution` (Required)
              - `threshold`
              - `threshold_type`
              - `resolution_window` Accepted format: `<number>` followed by a `<time_unit>` character: `s` for seconds, `m` for minutes, `h` for hours, `d` for days. Examples: `0s, 30m`.
        #### metrics_static_condition
          - `critical`
            - `time_range` (Required) :  Accepted format: Optional `-` sign followed by `<number>` followed by a `<time_unit>` character: `s` for seconds, `m` for minutes, `h` for hours, `d` for days. Examples: `30m`, `-12h`.
            - `occurrence_type` (Required)
            - `alert` (Required)
              - `threshold`
              - `threshold_type`
              - `min_data_points` (Optional)
            - `resolution` (Required)
              - `threshold`
              - `threshold_type`
              - `min_data_points` (Optional)
            - `warning`
            - `time_range` (Required) :  Accepted format: Optional `-` sign followed by `<number>` followed by a `<time_unit>` character: `s` for seconds, `m` for minutes, `h` for hours, `d` for days. Examples: `30m`, `-12h`.
            - `occurrence_type` (Required)
            - `alert` (Required)
              - `threshold`
              - `threshold_type`
              - `min_data_points` (Optional)
            - `resolution` (Required)
              - `threshold`
              - `threshold_type`
              - `min_data_points` (Optional)
        #### logs_outlier_condition
          - `field`
          - `direction`
          - `critical`
             - `window`
             - `consecutive`
             - `threshold`
          - `warning`
             - `window`
             - `consecutive`
             - `threshold`
        #### metrics_outlier_condition
          - `direction`
          - `critical`
             - `baseline_window`
             - `threshold`
          - `warning`
            - `baseline_window`
            - `threshold`
        #### logs_missing_data_condition
          - `time_range` (Required) :  Accepted format: Optional `-` sign followed by `<number>` followed by a `<time_unit>` character: `s` for seconds, `m` for minutes, `h` for hours, `d` for days. Examples: `30m`, `-12h`.
        #### metrics_missing_data_condition
          - `time_range` (Required) :  Accepted format: Optional `-` sign followed by `<number>` followed by a `<time_unit>` character: `s` for seconds, `m` for minutes, `h` for hours, `d` for days. Examples: `30m`, `-12h`.
        #### slo_sli_condition
          - `critical`
            - `sli_threshold` (Required) : The remaining SLI error budget threshold percentage [0,100).
          - `warning`
            - `sli_threshold` (Required)

        #### slo_burn_rate_condition
          - `critical`
            - `time_range` (Deprecated) : The relative time range for the burn rate percentage evaluation.  Accepted format: Optional `-` sign followed by `<number>` followed by a `<time_unit>` character: `s` for seconds, `m` for minutes, `h` for hours, `d` for days. Examples: `30m`, `-12h`.
            - `burn_rate_threshold` (Deprecated) : The burn rate percentage threshold.
            - `burn_rate` (Required if above two fields are not present): Block to specify burn rate threshold and time range for the condition.
              - `burn_rate_threshold` (Required): The burn rate percentage threshold.
              - `time_range` (Required): The relative time range for the burn rate percentage evaluation.  Accepted format: Optional `-` sign followed by `<number>` followed by a `<time_unit>` character: `s` for seconds, `m` for minutes, `h` for hours, `d` for days. Examples: `30m`, `-12h`.
          - `warning`
            - `time_range` (Deprecated) :  Accepted format: Optional `-` sign followed by `<number>` followed by a `<time_unit>` character: `s` for seconds, `m` for minutes, `h` for hours, `d` for days. Examples: `30m`, `-12h`.
            - `burn_rate_threshold` (Deprecated)
            - `burn_rate` (Required if above two fields are not present): Block to specify burn rate threshold and time range for the condition.
              - `burn_rate_threshold` (Required): The burn rate percentage threshold.
              - `time_range` (Required): The relative time range for the burn rate percentage evaluation.  Accepted format: Optional `-` sign followed by `<number>` followed by a `<time_unit>` character: `s` for seconds, `m` for minutes, `h` for hours, `d` for days. Examples: `30m`, `-12h`.

        ## The `triggers` block

        The `triggers` block is deprecated. Please use `trigger_conditions` to specify notification conditions.

        Here's an example logs monitor that uses `triggers` to specify trigger conditions:
        ```python
        import pulumi
        import pulumi_sumologic as sumologic

        tf_logs_monitor1 = sumologic.Monitor("tfLogsMonitor1",
            content_type="Monitor",
            description="tf logs monitor",
            is_disabled=False,
            monitor_type="Logs",
            notifications=[
                sumologic.MonitorNotificationArgs(
                    notification=sumologic.MonitorNotificationNotificationArgs(
                        connection_type="Email",
                        message_body="Triggered {{TriggerType}} Alert on {{Name}}: {{QueryURL}}",
                        recipients=["abc@example.com"],
                        subject="Monitor Alert: {{TriggerType}} on {{Name}}",
                        time_zone="PST",
                    ),
                    run_for_trigger_types=[
                        "Critical",
                        "ResolvedCritical",
                    ],
                ),
                sumologic.MonitorNotificationArgs(
                    notification=sumologic.MonitorNotificationNotificationArgs(
                        connection_id="0000000000ABC123",
                        connection_type="Webhook",
                    ),
                    run_for_trigger_types=[
                        "Critical",
                        "ResolvedCritical",
                    ],
                ),
            ],
            queries=[sumologic.MonitorQueryArgs(
                query="_sourceCategory=event-action info",
                row_id="A",
            )],
            triggers=[
                sumologic.MonitorTriggerArgs(
                    detection_method="StaticCondition",
                    occurrence_type="ResultCount",
                    threshold=40,
                    threshold_type="GreaterThan",
                    time_range="15m",
                    trigger_source="AllResults",
                    trigger_type="Critical",
                ),
                sumologic.MonitorTriggerArgs(
                    detection_method="StaticCondition",
                    occurrence_type="ResultCount",
                    resolution_window="5m",
                    threshold=40,
                    threshold_type="LessThanOrEqual",
                    time_range="15m",
                    trigger_source="AllResults",
                    trigger_type="ResolvedCritical",
                ),
            ],
            type="MonitorsLibraryMonitor")
        ```

        ## Import

        Monitors can be imported using the monitor ID, such ashcl

        ```sh
         $ pulumi import sumologic:index/monitor:Monitor test 1234567890
        ```

         [1]https://help.sumologic.com/?cid=10020 [2]monitor_folder.html.markdown [3]https://help.sumologic.com/Visualizations-and-Alerts/Alerts/Monitors#configure-permissions-for-a-monitor

        :param str resource_name: The name of the resource.
        :param MonitorArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(MonitorArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 alert_name: Optional[pulumi.Input[str]] = None,
                 content_type: Optional[pulumi.Input[str]] = None,
                 created_at: Optional[pulumi.Input[str]] = None,
                 created_by: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 evaluation_delay: Optional[pulumi.Input[str]] = None,
                 group_notifications: Optional[pulumi.Input[bool]] = None,
                 is_disabled: Optional[pulumi.Input[bool]] = None,
                 is_locked: Optional[pulumi.Input[bool]] = None,
                 is_mutable: Optional[pulumi.Input[bool]] = None,
                 is_system: Optional[pulumi.Input[bool]] = None,
                 modified_at: Optional[pulumi.Input[str]] = None,
                 modified_by: Optional[pulumi.Input[str]] = None,
                 monitor_type: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 notification_group_fields: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 notifications: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['MonitorNotificationArgs']]]]] = None,
                 obj_permissions: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['MonitorObjPermissionArgs']]]]] = None,
                 parent_id: Optional[pulumi.Input[str]] = None,
                 playbook: Optional[pulumi.Input[str]] = None,
                 post_request_map: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 queries: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['MonitorQueryArgs']]]]] = None,
                 slo_id: Optional[pulumi.Input[str]] = None,
                 statuses: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 time_zone: Optional[pulumi.Input[str]] = None,
                 trigger_conditions: Optional[pulumi.Input[pulumi.InputType['MonitorTriggerConditionsArgs']]] = None,
                 triggers: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['MonitorTriggerArgs']]]]] = None,
                 type: Optional[pulumi.Input[str]] = None,
                 version: Optional[pulumi.Input[int]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = MonitorArgs.__new__(MonitorArgs)

            __props__.__dict__["alert_name"] = alert_name
            __props__.__dict__["content_type"] = content_type
            __props__.__dict__["created_at"] = created_at
            __props__.__dict__["created_by"] = created_by
            __props__.__dict__["description"] = description
            __props__.__dict__["evaluation_delay"] = evaluation_delay
            __props__.__dict__["group_notifications"] = group_notifications
            __props__.__dict__["is_disabled"] = is_disabled
            __props__.__dict__["is_locked"] = is_locked
            __props__.__dict__["is_mutable"] = is_mutable
            __props__.__dict__["is_system"] = is_system
            __props__.__dict__["modified_at"] = modified_at
            __props__.__dict__["modified_by"] = modified_by
            if monitor_type is None and not opts.urn:
                raise TypeError("Missing required property 'monitor_type'")
            __props__.__dict__["monitor_type"] = monitor_type
            __props__.__dict__["name"] = name
            __props__.__dict__["notification_group_fields"] = notification_group_fields
            __props__.__dict__["notifications"] = notifications
            __props__.__dict__["obj_permissions"] = obj_permissions
            __props__.__dict__["parent_id"] = parent_id
            __props__.__dict__["playbook"] = playbook
            __props__.__dict__["post_request_map"] = post_request_map
            __props__.__dict__["queries"] = queries
            __props__.__dict__["slo_id"] = slo_id
            __props__.__dict__["statuses"] = statuses
            __props__.__dict__["tags"] = tags
            __props__.__dict__["time_zone"] = time_zone
            __props__.__dict__["trigger_conditions"] = trigger_conditions
            __props__.__dict__["triggers"] = triggers
            __props__.__dict__["type"] = type
            __props__.__dict__["version"] = version
        super(Monitor, __self__).__init__(
            'sumologic:index/monitor:Monitor',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            alert_name: Optional[pulumi.Input[str]] = None,
            content_type: Optional[pulumi.Input[str]] = None,
            created_at: Optional[pulumi.Input[str]] = None,
            created_by: Optional[pulumi.Input[str]] = None,
            description: Optional[pulumi.Input[str]] = None,
            evaluation_delay: Optional[pulumi.Input[str]] = None,
            group_notifications: Optional[pulumi.Input[bool]] = None,
            is_disabled: Optional[pulumi.Input[bool]] = None,
            is_locked: Optional[pulumi.Input[bool]] = None,
            is_mutable: Optional[pulumi.Input[bool]] = None,
            is_system: Optional[pulumi.Input[bool]] = None,
            modified_at: Optional[pulumi.Input[str]] = None,
            modified_by: Optional[pulumi.Input[str]] = None,
            monitor_type: Optional[pulumi.Input[str]] = None,
            name: Optional[pulumi.Input[str]] = None,
            notification_group_fields: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            notifications: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['MonitorNotificationArgs']]]]] = None,
            obj_permissions: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['MonitorObjPermissionArgs']]]]] = None,
            parent_id: Optional[pulumi.Input[str]] = None,
            playbook: Optional[pulumi.Input[str]] = None,
            post_request_map: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
            queries: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['MonitorQueryArgs']]]]] = None,
            slo_id: Optional[pulumi.Input[str]] = None,
            statuses: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
            time_zone: Optional[pulumi.Input[str]] = None,
            trigger_conditions: Optional[pulumi.Input[pulumi.InputType['MonitorTriggerConditionsArgs']]] = None,
            triggers: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['MonitorTriggerArgs']]]]] = None,
            type: Optional[pulumi.Input[str]] = None,
            version: Optional[pulumi.Input[int]] = None) -> 'Monitor':
        """
        Get an existing Monitor resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] alert_name: The display name when creating alerts. Monitor name will be used if `alert_name` is not provided. All template variables can be used in `alert_name` except `{{AlertName}}`, `{{AlertResponseURL}}`, `{{ResultsJson}}`, and `{{Playbook}}`.
        :param pulumi.Input[str] content_type: The type of the content object. Valid value:
        :param pulumi.Input[str] description: The description of the monitor.
        :param pulumi.Input[str] evaluation_delay: Evaluation delay as a string consists of the following elements:
               1. `<number>`: number of time units,
               2. `<time_unit>`: time unit; possible values are: `h` (hour), `m` (minute), `s` (second).
               
               Multiple pairs of `<number><time_unit>` may be provided. For example,
               `2m50s` means 2 minutes and 50 seconds.
        :param pulumi.Input[bool] group_notifications: Whether or not to group notifications for individual items that meet the trigger condition. Defaults to true.
        :param pulumi.Input[bool] is_disabled: Whether or not the monitor is disabled. Disabled monitors will not run and will not generate or send notifications.
        :param pulumi.Input[str] monitor_type: The type of monitor. Valid values:
        :param pulumi.Input[str] name: The name of the monitor. The name must be alphanumeric.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] notification_group_fields: The set of fields to be used to group alerts and notifications for a monitor. The value of this field will be considered only when 'groupNotifications' is true. The fields with very high cardinality such as `_blockid`, `_raw`, `_messagetime`, `_receipttime`, and `_messageid` are not allowed for Alert Grouping.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['MonitorNotificationArgs']]]] notifications: The notifications the monitor will send when the respective trigger condition is met.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['MonitorObjPermissionArgs']]]] obj_permissions: `obj_permission` construct represents a Permission Statement associated with this Monitor. A set of `obj_permission` constructs can be specified under a Monitor. An `obj_permission` construct can be used to control permissions Explicitly associated with a Monitor. But, it cannot be used to control permissions Inherited from a Parent / Ancestor. Default FGP would be still set to the Monitor upon creation (e.g. the creating user would have full permission), even if no `obj_permission` construct is specified at a Monitor and the FGP feature is enabled at the account.
        :param pulumi.Input[str] parent_id: The ID of the Monitor Folder that contains this monitor. Defaults to the root folder.
        :param pulumi.Input[str] playbook: Notes such as links and instruction to help you resolve alerts triggered by this monitor. {{Markdown}} supported. It will be enabled only if available for your organization. Please contact your Sumo Logic account team to learn more.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['MonitorQueryArgs']]]] queries: All queries from the monitor.
        :param pulumi.Input[str] slo_id: Identifier of the SLO definition for the monitor. This is only applicable & required for Slo `monitor_type`.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] statuses: The current status for this monitor. Values are:
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: A map defining tag keys and tag values for the Monitor.
        :param pulumi.Input[pulumi.InputType['MonitorTriggerConditionsArgs']] trigger_conditions: Defines the conditions of when to send notifications. NOTE: `trigger_conditions` supplants the `triggers` argument.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['MonitorTriggerArgs']]]] triggers: Defines the conditions of when to send notifications.
        :param pulumi.Input[str] type: The type of object model. Valid value:
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _MonitorState.__new__(_MonitorState)

        __props__.__dict__["alert_name"] = alert_name
        __props__.__dict__["content_type"] = content_type
        __props__.__dict__["created_at"] = created_at
        __props__.__dict__["created_by"] = created_by
        __props__.__dict__["description"] = description
        __props__.__dict__["evaluation_delay"] = evaluation_delay
        __props__.__dict__["group_notifications"] = group_notifications
        __props__.__dict__["is_disabled"] = is_disabled
        __props__.__dict__["is_locked"] = is_locked
        __props__.__dict__["is_mutable"] = is_mutable
        __props__.__dict__["is_system"] = is_system
        __props__.__dict__["modified_at"] = modified_at
        __props__.__dict__["modified_by"] = modified_by
        __props__.__dict__["monitor_type"] = monitor_type
        __props__.__dict__["name"] = name
        __props__.__dict__["notification_group_fields"] = notification_group_fields
        __props__.__dict__["notifications"] = notifications
        __props__.__dict__["obj_permissions"] = obj_permissions
        __props__.__dict__["parent_id"] = parent_id
        __props__.__dict__["playbook"] = playbook
        __props__.__dict__["post_request_map"] = post_request_map
        __props__.__dict__["queries"] = queries
        __props__.__dict__["slo_id"] = slo_id
        __props__.__dict__["statuses"] = statuses
        __props__.__dict__["tags"] = tags
        __props__.__dict__["time_zone"] = time_zone
        __props__.__dict__["trigger_conditions"] = trigger_conditions
        __props__.__dict__["triggers"] = triggers
        __props__.__dict__["type"] = type
        __props__.__dict__["version"] = version
        return Monitor(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="alertName")
    def alert_name(self) -> pulumi.Output[Optional[str]]:
        """
        The display name when creating alerts. Monitor name will be used if `alert_name` is not provided. All template variables can be used in `alert_name` except `{{AlertName}}`, `{{AlertResponseURL}}`, `{{ResultsJson}}`, and `{{Playbook}}`.
        """
        return pulumi.get(self, "alert_name")

    @property
    @pulumi.getter(name="contentType")
    def content_type(self) -> pulumi.Output[Optional[str]]:
        """
        The type of the content object. Valid value:
        """
        return pulumi.get(self, "content_type")

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> pulumi.Output[str]:
        return pulumi.get(self, "created_at")

    @property
    @pulumi.getter(name="createdBy")
    def created_by(self) -> pulumi.Output[str]:
        return pulumi.get(self, "created_by")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[str]]:
        """
        The description of the monitor.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="evaluationDelay")
    def evaluation_delay(self) -> pulumi.Output[str]:
        """
        Evaluation delay as a string consists of the following elements:
        1. `<number>`: number of time units,
        2. `<time_unit>`: time unit; possible values are: `h` (hour), `m` (minute), `s` (second).

        Multiple pairs of `<number><time_unit>` may be provided. For example,
        `2m50s` means 2 minutes and 50 seconds.
        """
        return pulumi.get(self, "evaluation_delay")

    @property
    @pulumi.getter(name="groupNotifications")
    def group_notifications(self) -> pulumi.Output[Optional[bool]]:
        """
        Whether or not to group notifications for individual items that meet the trigger condition. Defaults to true.
        """
        return pulumi.get(self, "group_notifications")

    @property
    @pulumi.getter(name="isDisabled")
    def is_disabled(self) -> pulumi.Output[Optional[bool]]:
        """
        Whether or not the monitor is disabled. Disabled monitors will not run and will not generate or send notifications.
        """
        return pulumi.get(self, "is_disabled")

    @property
    @pulumi.getter(name="isLocked")
    def is_locked(self) -> pulumi.Output[bool]:
        return pulumi.get(self, "is_locked")

    @property
    @pulumi.getter(name="isMutable")
    def is_mutable(self) -> pulumi.Output[bool]:
        return pulumi.get(self, "is_mutable")

    @property
    @pulumi.getter(name="isSystem")
    def is_system(self) -> pulumi.Output[bool]:
        return pulumi.get(self, "is_system")

    @property
    @pulumi.getter(name="modifiedAt")
    def modified_at(self) -> pulumi.Output[str]:
        return pulumi.get(self, "modified_at")

    @property
    @pulumi.getter(name="modifiedBy")
    def modified_by(self) -> pulumi.Output[str]:
        return pulumi.get(self, "modified_by")

    @property
    @pulumi.getter(name="monitorType")
    def monitor_type(self) -> pulumi.Output[str]:
        """
        The type of monitor. Valid values:
        """
        return pulumi.get(self, "monitor_type")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        The name of the monitor. The name must be alphanumeric.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="notificationGroupFields")
    def notification_group_fields(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        The set of fields to be used to group alerts and notifications for a monitor. The value of this field will be considered only when 'groupNotifications' is true. The fields with very high cardinality such as `_blockid`, `_raw`, `_messagetime`, `_receipttime`, and `_messageid` are not allowed for Alert Grouping.
        """
        return pulumi.get(self, "notification_group_fields")

    @property
    @pulumi.getter
    def notifications(self) -> pulumi.Output[Optional[Sequence['outputs.MonitorNotification']]]:
        """
        The notifications the monitor will send when the respective trigger condition is met.
        """
        return pulumi.get(self, "notifications")

    @property
    @pulumi.getter(name="objPermissions")
    def obj_permissions(self) -> pulumi.Output[Optional[Sequence['outputs.MonitorObjPermission']]]:
        """
        `obj_permission` construct represents a Permission Statement associated with this Monitor. A set of `obj_permission` constructs can be specified under a Monitor. An `obj_permission` construct can be used to control permissions Explicitly associated with a Monitor. But, it cannot be used to control permissions Inherited from a Parent / Ancestor. Default FGP would be still set to the Monitor upon creation (e.g. the creating user would have full permission), even if no `obj_permission` construct is specified at a Monitor and the FGP feature is enabled at the account.
        """
        return pulumi.get(self, "obj_permissions")

    @property
    @pulumi.getter(name="parentId")
    def parent_id(self) -> pulumi.Output[str]:
        """
        The ID of the Monitor Folder that contains this monitor. Defaults to the root folder.
        """
        return pulumi.get(self, "parent_id")

    @property
    @pulumi.getter
    def playbook(self) -> pulumi.Output[Optional[str]]:
        """
        Notes such as links and instruction to help you resolve alerts triggered by this monitor. {{Markdown}} supported. It will be enabled only if available for your organization. Please contact your Sumo Logic account team to learn more.
        """
        return pulumi.get(self, "playbook")

    @property
    @pulumi.getter(name="postRequestMap")
    def post_request_map(self) -> pulumi.Output[Optional[Mapping[str, str]]]:
        return pulumi.get(self, "post_request_map")

    @property
    @pulumi.getter
    def queries(self) -> pulumi.Output[Optional[Sequence['outputs.MonitorQuery']]]:
        """
        All queries from the monitor.
        """
        return pulumi.get(self, "queries")

    @property
    @pulumi.getter(name="sloId")
    def slo_id(self) -> pulumi.Output[Optional[str]]:
        """
        Identifier of the SLO definition for the monitor. This is only applicable & required for Slo `monitor_type`.
        """
        return pulumi.get(self, "slo_id")

    @property
    @pulumi.getter
    def statuses(self) -> pulumi.Output[Sequence[str]]:
        """
        The current status for this monitor. Values are:
        """
        return pulumi.get(self, "statuses")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, str]]]:
        """
        A map defining tag keys and tag values for the Monitor.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="timeZone")
    def time_zone(self) -> pulumi.Output[Optional[str]]:
        return pulumi.get(self, "time_zone")

    @property
    @pulumi.getter(name="triggerConditions")
    def trigger_conditions(self) -> pulumi.Output[Optional['outputs.MonitorTriggerConditions']]:
        """
        Defines the conditions of when to send notifications. NOTE: `trigger_conditions` supplants the `triggers` argument.
        """
        return pulumi.get(self, "trigger_conditions")

    @property
    @pulumi.getter
    def triggers(self) -> pulumi.Output[Optional[Sequence['outputs.MonitorTrigger']]]:
        """
        Defines the conditions of when to send notifications.
        """
        warnings.warn("""The field `triggers` is deprecated and will be removed in a future release of the provider -- please use `trigger_conditions` instead.""", DeprecationWarning)
        pulumi.log.warn("""triggers is deprecated: The field `triggers` is deprecated and will be removed in a future release of the provider -- please use `trigger_conditions` instead.""")

        return pulumi.get(self, "triggers")

    @property
    @pulumi.getter
    def type(self) -> pulumi.Output[Optional[str]]:
        """
        The type of object model. Valid value:
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def version(self) -> pulumi.Output[int]:
        return pulumi.get(self, "version")

