# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities

__all__ = ['PasswordPolicyArgs', 'PasswordPolicy']

@pulumi.input_type
class PasswordPolicyArgs:
    def __init__(__self__, *,
                 account_lockout_duration_in_mins: Optional[pulumi.Input[int]] = None,
                 account_lockout_threshold: Optional[pulumi.Input[int]] = None,
                 failed_login_reset_duration_in_mins: Optional[pulumi.Input[int]] = None,
                 max_length: Optional[pulumi.Input[int]] = None,
                 max_password_age_in_days: Optional[pulumi.Input[int]] = None,
                 min_length: Optional[pulumi.Input[int]] = None,
                 min_unique_passwords: Optional[pulumi.Input[int]] = None,
                 must_contain_digits: Optional[pulumi.Input[bool]] = None,
                 must_contain_lowercase: Optional[pulumi.Input[bool]] = None,
                 must_contain_special_chars: Optional[pulumi.Input[bool]] = None,
                 must_contain_uppercase: Optional[pulumi.Input[bool]] = None,
                 remember_mfa: Optional[pulumi.Input[bool]] = None,
                 require_mfa: Optional[pulumi.Input[bool]] = None):
        """
        The set of arguments for constructing a PasswordPolicy resource.
        :param pulumi.Input[int] account_lockout_duration_in_mins: The duration of time in minutes that a locked-out account remained locked before getting unlocked automatically. Defaults to 30.
        :param pulumi.Input[int] account_lockout_threshold: Number of failed login attempts allowed before account is locked-out. Defaults to 6.
        :param pulumi.Input[int] failed_login_reset_duration_in_mins: The duration of time in minutes that must elapse from the first failed login attempt after which failed login count is reset to 0. Defaults to 10.
        :param pulumi.Input[int] max_length: The maximum length of the password. Defaults to 128. (128 is now the only accepted value; other values are no longer supported, and this field may be deprecated in the future.)
        :param pulumi.Input[int] max_password_age_in_days: Maximum number of days that a password can be used before user is required to change it. Put -1 if the user should not have to change their password. Defaults to 365.
        :param pulumi.Input[int] min_length: The minimum length of the password. Defaults to 8.
        :param pulumi.Input[int] min_unique_passwords: The minimum number of unique new passwords that a user must use before an old password can be reused. Defaults to 10.
        :param pulumi.Input[bool] must_contain_digits: If the password must contain digits. Defaults to true.
        :param pulumi.Input[bool] must_contain_lowercase: If the password must contain lower case characters. Defaults to true.
        :param pulumi.Input[bool] must_contain_special_chars: If the password must contain special characters. Defaults to true.
        :param pulumi.Input[bool] must_contain_uppercase: If the password must contain upper case characters. Defaults to true.
        :param pulumi.Input[bool] remember_mfa: If MFA should be remembered on the browser. Defaults to true.
               
               [1]: https://help.sumologic.com/Manage/Security/Set-the-Password-Policy
        :param pulumi.Input[bool] require_mfa: If MFA should be required to log in. Defaults to false.
        """
        if account_lockout_duration_in_mins is not None:
            pulumi.set(__self__, "account_lockout_duration_in_mins", account_lockout_duration_in_mins)
        if account_lockout_threshold is not None:
            pulumi.set(__self__, "account_lockout_threshold", account_lockout_threshold)
        if failed_login_reset_duration_in_mins is not None:
            pulumi.set(__self__, "failed_login_reset_duration_in_mins", failed_login_reset_duration_in_mins)
        if max_length is not None:
            pulumi.set(__self__, "max_length", max_length)
        if max_password_age_in_days is not None:
            pulumi.set(__self__, "max_password_age_in_days", max_password_age_in_days)
        if min_length is not None:
            pulumi.set(__self__, "min_length", min_length)
        if min_unique_passwords is not None:
            pulumi.set(__self__, "min_unique_passwords", min_unique_passwords)
        if must_contain_digits is not None:
            pulumi.set(__self__, "must_contain_digits", must_contain_digits)
        if must_contain_lowercase is not None:
            pulumi.set(__self__, "must_contain_lowercase", must_contain_lowercase)
        if must_contain_special_chars is not None:
            pulumi.set(__self__, "must_contain_special_chars", must_contain_special_chars)
        if must_contain_uppercase is not None:
            pulumi.set(__self__, "must_contain_uppercase", must_contain_uppercase)
        if remember_mfa is not None:
            pulumi.set(__self__, "remember_mfa", remember_mfa)
        if require_mfa is not None:
            pulumi.set(__self__, "require_mfa", require_mfa)

    @property
    @pulumi.getter(name="accountLockoutDurationInMins")
    def account_lockout_duration_in_mins(self) -> Optional[pulumi.Input[int]]:
        """
        The duration of time in minutes that a locked-out account remained locked before getting unlocked automatically. Defaults to 30.
        """
        return pulumi.get(self, "account_lockout_duration_in_mins")

    @account_lockout_duration_in_mins.setter
    def account_lockout_duration_in_mins(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "account_lockout_duration_in_mins", value)

    @property
    @pulumi.getter(name="accountLockoutThreshold")
    def account_lockout_threshold(self) -> Optional[pulumi.Input[int]]:
        """
        Number of failed login attempts allowed before account is locked-out. Defaults to 6.
        """
        return pulumi.get(self, "account_lockout_threshold")

    @account_lockout_threshold.setter
    def account_lockout_threshold(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "account_lockout_threshold", value)

    @property
    @pulumi.getter(name="failedLoginResetDurationInMins")
    def failed_login_reset_duration_in_mins(self) -> Optional[pulumi.Input[int]]:
        """
        The duration of time in minutes that must elapse from the first failed login attempt after which failed login count is reset to 0. Defaults to 10.
        """
        return pulumi.get(self, "failed_login_reset_duration_in_mins")

    @failed_login_reset_duration_in_mins.setter
    def failed_login_reset_duration_in_mins(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "failed_login_reset_duration_in_mins", value)

    @property
    @pulumi.getter(name="maxLength")
    def max_length(self) -> Optional[pulumi.Input[int]]:
        """
        The maximum length of the password. Defaults to 128. (128 is now the only accepted value; other values are no longer supported, and this field may be deprecated in the future.)
        """
        return pulumi.get(self, "max_length")

    @max_length.setter
    def max_length(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "max_length", value)

    @property
    @pulumi.getter(name="maxPasswordAgeInDays")
    def max_password_age_in_days(self) -> Optional[pulumi.Input[int]]:
        """
        Maximum number of days that a password can be used before user is required to change it. Put -1 if the user should not have to change their password. Defaults to 365.
        """
        return pulumi.get(self, "max_password_age_in_days")

    @max_password_age_in_days.setter
    def max_password_age_in_days(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "max_password_age_in_days", value)

    @property
    @pulumi.getter(name="minLength")
    def min_length(self) -> Optional[pulumi.Input[int]]:
        """
        The minimum length of the password. Defaults to 8.
        """
        return pulumi.get(self, "min_length")

    @min_length.setter
    def min_length(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "min_length", value)

    @property
    @pulumi.getter(name="minUniquePasswords")
    def min_unique_passwords(self) -> Optional[pulumi.Input[int]]:
        """
        The minimum number of unique new passwords that a user must use before an old password can be reused. Defaults to 10.
        """
        return pulumi.get(self, "min_unique_passwords")

    @min_unique_passwords.setter
    def min_unique_passwords(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "min_unique_passwords", value)

    @property
    @pulumi.getter(name="mustContainDigits")
    def must_contain_digits(self) -> Optional[pulumi.Input[bool]]:
        """
        If the password must contain digits. Defaults to true.
        """
        return pulumi.get(self, "must_contain_digits")

    @must_contain_digits.setter
    def must_contain_digits(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "must_contain_digits", value)

    @property
    @pulumi.getter(name="mustContainLowercase")
    def must_contain_lowercase(self) -> Optional[pulumi.Input[bool]]:
        """
        If the password must contain lower case characters. Defaults to true.
        """
        return pulumi.get(self, "must_contain_lowercase")

    @must_contain_lowercase.setter
    def must_contain_lowercase(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "must_contain_lowercase", value)

    @property
    @pulumi.getter(name="mustContainSpecialChars")
    def must_contain_special_chars(self) -> Optional[pulumi.Input[bool]]:
        """
        If the password must contain special characters. Defaults to true.
        """
        return pulumi.get(self, "must_contain_special_chars")

    @must_contain_special_chars.setter
    def must_contain_special_chars(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "must_contain_special_chars", value)

    @property
    @pulumi.getter(name="mustContainUppercase")
    def must_contain_uppercase(self) -> Optional[pulumi.Input[bool]]:
        """
        If the password must contain upper case characters. Defaults to true.
        """
        return pulumi.get(self, "must_contain_uppercase")

    @must_contain_uppercase.setter
    def must_contain_uppercase(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "must_contain_uppercase", value)

    @property
    @pulumi.getter(name="rememberMfa")
    def remember_mfa(self) -> Optional[pulumi.Input[bool]]:
        """
        If MFA should be remembered on the browser. Defaults to true.

        [1]: https://help.sumologic.com/Manage/Security/Set-the-Password-Policy
        """
        return pulumi.get(self, "remember_mfa")

    @remember_mfa.setter
    def remember_mfa(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "remember_mfa", value)

    @property
    @pulumi.getter(name="requireMfa")
    def require_mfa(self) -> Optional[pulumi.Input[bool]]:
        """
        If MFA should be required to log in. Defaults to false.
        """
        return pulumi.get(self, "require_mfa")

    @require_mfa.setter
    def require_mfa(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "require_mfa", value)


@pulumi.input_type
class _PasswordPolicyState:
    def __init__(__self__, *,
                 account_lockout_duration_in_mins: Optional[pulumi.Input[int]] = None,
                 account_lockout_threshold: Optional[pulumi.Input[int]] = None,
                 failed_login_reset_duration_in_mins: Optional[pulumi.Input[int]] = None,
                 max_length: Optional[pulumi.Input[int]] = None,
                 max_password_age_in_days: Optional[pulumi.Input[int]] = None,
                 min_length: Optional[pulumi.Input[int]] = None,
                 min_unique_passwords: Optional[pulumi.Input[int]] = None,
                 must_contain_digits: Optional[pulumi.Input[bool]] = None,
                 must_contain_lowercase: Optional[pulumi.Input[bool]] = None,
                 must_contain_special_chars: Optional[pulumi.Input[bool]] = None,
                 must_contain_uppercase: Optional[pulumi.Input[bool]] = None,
                 remember_mfa: Optional[pulumi.Input[bool]] = None,
                 require_mfa: Optional[pulumi.Input[bool]] = None):
        """
        Input properties used for looking up and filtering PasswordPolicy resources.
        :param pulumi.Input[int] account_lockout_duration_in_mins: The duration of time in minutes that a locked-out account remained locked before getting unlocked automatically. Defaults to 30.
        :param pulumi.Input[int] account_lockout_threshold: Number of failed login attempts allowed before account is locked-out. Defaults to 6.
        :param pulumi.Input[int] failed_login_reset_duration_in_mins: The duration of time in minutes that must elapse from the first failed login attempt after which failed login count is reset to 0. Defaults to 10.
        :param pulumi.Input[int] max_length: The maximum length of the password. Defaults to 128. (128 is now the only accepted value; other values are no longer supported, and this field may be deprecated in the future.)
        :param pulumi.Input[int] max_password_age_in_days: Maximum number of days that a password can be used before user is required to change it. Put -1 if the user should not have to change their password. Defaults to 365.
        :param pulumi.Input[int] min_length: The minimum length of the password. Defaults to 8.
        :param pulumi.Input[int] min_unique_passwords: The minimum number of unique new passwords that a user must use before an old password can be reused. Defaults to 10.
        :param pulumi.Input[bool] must_contain_digits: If the password must contain digits. Defaults to true.
        :param pulumi.Input[bool] must_contain_lowercase: If the password must contain lower case characters. Defaults to true.
        :param pulumi.Input[bool] must_contain_special_chars: If the password must contain special characters. Defaults to true.
        :param pulumi.Input[bool] must_contain_uppercase: If the password must contain upper case characters. Defaults to true.
        :param pulumi.Input[bool] remember_mfa: If MFA should be remembered on the browser. Defaults to true.
               
               [1]: https://help.sumologic.com/Manage/Security/Set-the-Password-Policy
        :param pulumi.Input[bool] require_mfa: If MFA should be required to log in. Defaults to false.
        """
        if account_lockout_duration_in_mins is not None:
            pulumi.set(__self__, "account_lockout_duration_in_mins", account_lockout_duration_in_mins)
        if account_lockout_threshold is not None:
            pulumi.set(__self__, "account_lockout_threshold", account_lockout_threshold)
        if failed_login_reset_duration_in_mins is not None:
            pulumi.set(__self__, "failed_login_reset_duration_in_mins", failed_login_reset_duration_in_mins)
        if max_length is not None:
            pulumi.set(__self__, "max_length", max_length)
        if max_password_age_in_days is not None:
            pulumi.set(__self__, "max_password_age_in_days", max_password_age_in_days)
        if min_length is not None:
            pulumi.set(__self__, "min_length", min_length)
        if min_unique_passwords is not None:
            pulumi.set(__self__, "min_unique_passwords", min_unique_passwords)
        if must_contain_digits is not None:
            pulumi.set(__self__, "must_contain_digits", must_contain_digits)
        if must_contain_lowercase is not None:
            pulumi.set(__self__, "must_contain_lowercase", must_contain_lowercase)
        if must_contain_special_chars is not None:
            pulumi.set(__self__, "must_contain_special_chars", must_contain_special_chars)
        if must_contain_uppercase is not None:
            pulumi.set(__self__, "must_contain_uppercase", must_contain_uppercase)
        if remember_mfa is not None:
            pulumi.set(__self__, "remember_mfa", remember_mfa)
        if require_mfa is not None:
            pulumi.set(__self__, "require_mfa", require_mfa)

    @property
    @pulumi.getter(name="accountLockoutDurationInMins")
    def account_lockout_duration_in_mins(self) -> Optional[pulumi.Input[int]]:
        """
        The duration of time in minutes that a locked-out account remained locked before getting unlocked automatically. Defaults to 30.
        """
        return pulumi.get(self, "account_lockout_duration_in_mins")

    @account_lockout_duration_in_mins.setter
    def account_lockout_duration_in_mins(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "account_lockout_duration_in_mins", value)

    @property
    @pulumi.getter(name="accountLockoutThreshold")
    def account_lockout_threshold(self) -> Optional[pulumi.Input[int]]:
        """
        Number of failed login attempts allowed before account is locked-out. Defaults to 6.
        """
        return pulumi.get(self, "account_lockout_threshold")

    @account_lockout_threshold.setter
    def account_lockout_threshold(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "account_lockout_threshold", value)

    @property
    @pulumi.getter(name="failedLoginResetDurationInMins")
    def failed_login_reset_duration_in_mins(self) -> Optional[pulumi.Input[int]]:
        """
        The duration of time in minutes that must elapse from the first failed login attempt after which failed login count is reset to 0. Defaults to 10.
        """
        return pulumi.get(self, "failed_login_reset_duration_in_mins")

    @failed_login_reset_duration_in_mins.setter
    def failed_login_reset_duration_in_mins(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "failed_login_reset_duration_in_mins", value)

    @property
    @pulumi.getter(name="maxLength")
    def max_length(self) -> Optional[pulumi.Input[int]]:
        """
        The maximum length of the password. Defaults to 128. (128 is now the only accepted value; other values are no longer supported, and this field may be deprecated in the future.)
        """
        return pulumi.get(self, "max_length")

    @max_length.setter
    def max_length(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "max_length", value)

    @property
    @pulumi.getter(name="maxPasswordAgeInDays")
    def max_password_age_in_days(self) -> Optional[pulumi.Input[int]]:
        """
        Maximum number of days that a password can be used before user is required to change it. Put -1 if the user should not have to change their password. Defaults to 365.
        """
        return pulumi.get(self, "max_password_age_in_days")

    @max_password_age_in_days.setter
    def max_password_age_in_days(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "max_password_age_in_days", value)

    @property
    @pulumi.getter(name="minLength")
    def min_length(self) -> Optional[pulumi.Input[int]]:
        """
        The minimum length of the password. Defaults to 8.
        """
        return pulumi.get(self, "min_length")

    @min_length.setter
    def min_length(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "min_length", value)

    @property
    @pulumi.getter(name="minUniquePasswords")
    def min_unique_passwords(self) -> Optional[pulumi.Input[int]]:
        """
        The minimum number of unique new passwords that a user must use before an old password can be reused. Defaults to 10.
        """
        return pulumi.get(self, "min_unique_passwords")

    @min_unique_passwords.setter
    def min_unique_passwords(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "min_unique_passwords", value)

    @property
    @pulumi.getter(name="mustContainDigits")
    def must_contain_digits(self) -> Optional[pulumi.Input[bool]]:
        """
        If the password must contain digits. Defaults to true.
        """
        return pulumi.get(self, "must_contain_digits")

    @must_contain_digits.setter
    def must_contain_digits(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "must_contain_digits", value)

    @property
    @pulumi.getter(name="mustContainLowercase")
    def must_contain_lowercase(self) -> Optional[pulumi.Input[bool]]:
        """
        If the password must contain lower case characters. Defaults to true.
        """
        return pulumi.get(self, "must_contain_lowercase")

    @must_contain_lowercase.setter
    def must_contain_lowercase(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "must_contain_lowercase", value)

    @property
    @pulumi.getter(name="mustContainSpecialChars")
    def must_contain_special_chars(self) -> Optional[pulumi.Input[bool]]:
        """
        If the password must contain special characters. Defaults to true.
        """
        return pulumi.get(self, "must_contain_special_chars")

    @must_contain_special_chars.setter
    def must_contain_special_chars(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "must_contain_special_chars", value)

    @property
    @pulumi.getter(name="mustContainUppercase")
    def must_contain_uppercase(self) -> Optional[pulumi.Input[bool]]:
        """
        If the password must contain upper case characters. Defaults to true.
        """
        return pulumi.get(self, "must_contain_uppercase")

    @must_contain_uppercase.setter
    def must_contain_uppercase(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "must_contain_uppercase", value)

    @property
    @pulumi.getter(name="rememberMfa")
    def remember_mfa(self) -> Optional[pulumi.Input[bool]]:
        """
        If MFA should be remembered on the browser. Defaults to true.

        [1]: https://help.sumologic.com/Manage/Security/Set-the-Password-Policy
        """
        return pulumi.get(self, "remember_mfa")

    @remember_mfa.setter
    def remember_mfa(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "remember_mfa", value)

    @property
    @pulumi.getter(name="requireMfa")
    def require_mfa(self) -> Optional[pulumi.Input[bool]]:
        """
        If MFA should be required to log in. Defaults to false.
        """
        return pulumi.get(self, "require_mfa")

    @require_mfa.setter
    def require_mfa(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "require_mfa", value)


class PasswordPolicy(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 account_lockout_duration_in_mins: Optional[pulumi.Input[int]] = None,
                 account_lockout_threshold: Optional[pulumi.Input[int]] = None,
                 failed_login_reset_duration_in_mins: Optional[pulumi.Input[int]] = None,
                 max_length: Optional[pulumi.Input[int]] = None,
                 max_password_age_in_days: Optional[pulumi.Input[int]] = None,
                 min_length: Optional[pulumi.Input[int]] = None,
                 min_unique_passwords: Optional[pulumi.Input[int]] = None,
                 must_contain_digits: Optional[pulumi.Input[bool]] = None,
                 must_contain_lowercase: Optional[pulumi.Input[bool]] = None,
                 must_contain_special_chars: Optional[pulumi.Input[bool]] = None,
                 must_contain_uppercase: Optional[pulumi.Input[bool]] = None,
                 remember_mfa: Optional[pulumi.Input[bool]] = None,
                 require_mfa: Optional[pulumi.Input[bool]] = None,
                 __props__=None):
        """
        Sets the [Sumologic Password Policy](https://help.sumologic.com/Manage/Security/Set-the-Password-Policy). Since there is only a single password policy for an organization,
        please ensure that only a single instance of such resource is defined.
        The behavior for defining more than one password policy resources is undefined.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_sumologic as sumologic

        example_password_policy = sumologic.PasswordPolicy("examplePasswordPolicy",
            account_lockout_duration_in_mins=30,
            account_lockout_threshold=6,
            failed_login_reset_duration_in_mins=10,
            max_length=128,
            max_password_age_in_days=365,
            min_length=8,
            min_unique_passwords=10,
            must_contain_digits=True,
            must_contain_lowercase=True,
            must_contain_special_chars=True,
            must_contain_uppercase=True,
            remember_mfa=True,
            require_mfa=False)
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[int] account_lockout_duration_in_mins: The duration of time in minutes that a locked-out account remained locked before getting unlocked automatically. Defaults to 30.
        :param pulumi.Input[int] account_lockout_threshold: Number of failed login attempts allowed before account is locked-out. Defaults to 6.
        :param pulumi.Input[int] failed_login_reset_duration_in_mins: The duration of time in minutes that must elapse from the first failed login attempt after which failed login count is reset to 0. Defaults to 10.
        :param pulumi.Input[int] max_length: The maximum length of the password. Defaults to 128. (128 is now the only accepted value; other values are no longer supported, and this field may be deprecated in the future.)
        :param pulumi.Input[int] max_password_age_in_days: Maximum number of days that a password can be used before user is required to change it. Put -1 if the user should not have to change their password. Defaults to 365.
        :param pulumi.Input[int] min_length: The minimum length of the password. Defaults to 8.
        :param pulumi.Input[int] min_unique_passwords: The minimum number of unique new passwords that a user must use before an old password can be reused. Defaults to 10.
        :param pulumi.Input[bool] must_contain_digits: If the password must contain digits. Defaults to true.
        :param pulumi.Input[bool] must_contain_lowercase: If the password must contain lower case characters. Defaults to true.
        :param pulumi.Input[bool] must_contain_special_chars: If the password must contain special characters. Defaults to true.
        :param pulumi.Input[bool] must_contain_uppercase: If the password must contain upper case characters. Defaults to true.
        :param pulumi.Input[bool] remember_mfa: If MFA should be remembered on the browser. Defaults to true.
               
               [1]: https://help.sumologic.com/Manage/Security/Set-the-Password-Policy
        :param pulumi.Input[bool] require_mfa: If MFA should be required to log in. Defaults to false.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[PasswordPolicyArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Sets the [Sumologic Password Policy](https://help.sumologic.com/Manage/Security/Set-the-Password-Policy). Since there is only a single password policy for an organization,
        please ensure that only a single instance of such resource is defined.
        The behavior for defining more than one password policy resources is undefined.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_sumologic as sumologic

        example_password_policy = sumologic.PasswordPolicy("examplePasswordPolicy",
            account_lockout_duration_in_mins=30,
            account_lockout_threshold=6,
            failed_login_reset_duration_in_mins=10,
            max_length=128,
            max_password_age_in_days=365,
            min_length=8,
            min_unique_passwords=10,
            must_contain_digits=True,
            must_contain_lowercase=True,
            must_contain_special_chars=True,
            must_contain_uppercase=True,
            remember_mfa=True,
            require_mfa=False)
        ```

        :param str resource_name: The name of the resource.
        :param PasswordPolicyArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(PasswordPolicyArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 account_lockout_duration_in_mins: Optional[pulumi.Input[int]] = None,
                 account_lockout_threshold: Optional[pulumi.Input[int]] = None,
                 failed_login_reset_duration_in_mins: Optional[pulumi.Input[int]] = None,
                 max_length: Optional[pulumi.Input[int]] = None,
                 max_password_age_in_days: Optional[pulumi.Input[int]] = None,
                 min_length: Optional[pulumi.Input[int]] = None,
                 min_unique_passwords: Optional[pulumi.Input[int]] = None,
                 must_contain_digits: Optional[pulumi.Input[bool]] = None,
                 must_contain_lowercase: Optional[pulumi.Input[bool]] = None,
                 must_contain_special_chars: Optional[pulumi.Input[bool]] = None,
                 must_contain_uppercase: Optional[pulumi.Input[bool]] = None,
                 remember_mfa: Optional[pulumi.Input[bool]] = None,
                 require_mfa: Optional[pulumi.Input[bool]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = PasswordPolicyArgs.__new__(PasswordPolicyArgs)

            __props__.__dict__["account_lockout_duration_in_mins"] = account_lockout_duration_in_mins
            __props__.__dict__["account_lockout_threshold"] = account_lockout_threshold
            __props__.__dict__["failed_login_reset_duration_in_mins"] = failed_login_reset_duration_in_mins
            __props__.__dict__["max_length"] = max_length
            __props__.__dict__["max_password_age_in_days"] = max_password_age_in_days
            __props__.__dict__["min_length"] = min_length
            __props__.__dict__["min_unique_passwords"] = min_unique_passwords
            __props__.__dict__["must_contain_digits"] = must_contain_digits
            __props__.__dict__["must_contain_lowercase"] = must_contain_lowercase
            __props__.__dict__["must_contain_special_chars"] = must_contain_special_chars
            __props__.__dict__["must_contain_uppercase"] = must_contain_uppercase
            __props__.__dict__["remember_mfa"] = remember_mfa
            __props__.__dict__["require_mfa"] = require_mfa
        super(PasswordPolicy, __self__).__init__(
            'sumologic:index/passwordPolicy:PasswordPolicy',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            account_lockout_duration_in_mins: Optional[pulumi.Input[int]] = None,
            account_lockout_threshold: Optional[pulumi.Input[int]] = None,
            failed_login_reset_duration_in_mins: Optional[pulumi.Input[int]] = None,
            max_length: Optional[pulumi.Input[int]] = None,
            max_password_age_in_days: Optional[pulumi.Input[int]] = None,
            min_length: Optional[pulumi.Input[int]] = None,
            min_unique_passwords: Optional[pulumi.Input[int]] = None,
            must_contain_digits: Optional[pulumi.Input[bool]] = None,
            must_contain_lowercase: Optional[pulumi.Input[bool]] = None,
            must_contain_special_chars: Optional[pulumi.Input[bool]] = None,
            must_contain_uppercase: Optional[pulumi.Input[bool]] = None,
            remember_mfa: Optional[pulumi.Input[bool]] = None,
            require_mfa: Optional[pulumi.Input[bool]] = None) -> 'PasswordPolicy':
        """
        Get an existing PasswordPolicy resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[int] account_lockout_duration_in_mins: The duration of time in minutes that a locked-out account remained locked before getting unlocked automatically. Defaults to 30.
        :param pulumi.Input[int] account_lockout_threshold: Number of failed login attempts allowed before account is locked-out. Defaults to 6.
        :param pulumi.Input[int] failed_login_reset_duration_in_mins: The duration of time in minutes that must elapse from the first failed login attempt after which failed login count is reset to 0. Defaults to 10.
        :param pulumi.Input[int] max_length: The maximum length of the password. Defaults to 128. (128 is now the only accepted value; other values are no longer supported, and this field may be deprecated in the future.)
        :param pulumi.Input[int] max_password_age_in_days: Maximum number of days that a password can be used before user is required to change it. Put -1 if the user should not have to change their password. Defaults to 365.
        :param pulumi.Input[int] min_length: The minimum length of the password. Defaults to 8.
        :param pulumi.Input[int] min_unique_passwords: The minimum number of unique new passwords that a user must use before an old password can be reused. Defaults to 10.
        :param pulumi.Input[bool] must_contain_digits: If the password must contain digits. Defaults to true.
        :param pulumi.Input[bool] must_contain_lowercase: If the password must contain lower case characters. Defaults to true.
        :param pulumi.Input[bool] must_contain_special_chars: If the password must contain special characters. Defaults to true.
        :param pulumi.Input[bool] must_contain_uppercase: If the password must contain upper case characters. Defaults to true.
        :param pulumi.Input[bool] remember_mfa: If MFA should be remembered on the browser. Defaults to true.
               
               [1]: https://help.sumologic.com/Manage/Security/Set-the-Password-Policy
        :param pulumi.Input[bool] require_mfa: If MFA should be required to log in. Defaults to false.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _PasswordPolicyState.__new__(_PasswordPolicyState)

        __props__.__dict__["account_lockout_duration_in_mins"] = account_lockout_duration_in_mins
        __props__.__dict__["account_lockout_threshold"] = account_lockout_threshold
        __props__.__dict__["failed_login_reset_duration_in_mins"] = failed_login_reset_duration_in_mins
        __props__.__dict__["max_length"] = max_length
        __props__.__dict__["max_password_age_in_days"] = max_password_age_in_days
        __props__.__dict__["min_length"] = min_length
        __props__.__dict__["min_unique_passwords"] = min_unique_passwords
        __props__.__dict__["must_contain_digits"] = must_contain_digits
        __props__.__dict__["must_contain_lowercase"] = must_contain_lowercase
        __props__.__dict__["must_contain_special_chars"] = must_contain_special_chars
        __props__.__dict__["must_contain_uppercase"] = must_contain_uppercase
        __props__.__dict__["remember_mfa"] = remember_mfa
        __props__.__dict__["require_mfa"] = require_mfa
        return PasswordPolicy(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="accountLockoutDurationInMins")
    def account_lockout_duration_in_mins(self) -> pulumi.Output[Optional[int]]:
        """
        The duration of time in minutes that a locked-out account remained locked before getting unlocked automatically. Defaults to 30.
        """
        return pulumi.get(self, "account_lockout_duration_in_mins")

    @property
    @pulumi.getter(name="accountLockoutThreshold")
    def account_lockout_threshold(self) -> pulumi.Output[Optional[int]]:
        """
        Number of failed login attempts allowed before account is locked-out. Defaults to 6.
        """
        return pulumi.get(self, "account_lockout_threshold")

    @property
    @pulumi.getter(name="failedLoginResetDurationInMins")
    def failed_login_reset_duration_in_mins(self) -> pulumi.Output[Optional[int]]:
        """
        The duration of time in minutes that must elapse from the first failed login attempt after which failed login count is reset to 0. Defaults to 10.
        """
        return pulumi.get(self, "failed_login_reset_duration_in_mins")

    @property
    @pulumi.getter(name="maxLength")
    def max_length(self) -> pulumi.Output[Optional[int]]:
        """
        The maximum length of the password. Defaults to 128. (128 is now the only accepted value; other values are no longer supported, and this field may be deprecated in the future.)
        """
        return pulumi.get(self, "max_length")

    @property
    @pulumi.getter(name="maxPasswordAgeInDays")
    def max_password_age_in_days(self) -> pulumi.Output[Optional[int]]:
        """
        Maximum number of days that a password can be used before user is required to change it. Put -1 if the user should not have to change their password. Defaults to 365.
        """
        return pulumi.get(self, "max_password_age_in_days")

    @property
    @pulumi.getter(name="minLength")
    def min_length(self) -> pulumi.Output[Optional[int]]:
        """
        The minimum length of the password. Defaults to 8.
        """
        return pulumi.get(self, "min_length")

    @property
    @pulumi.getter(name="minUniquePasswords")
    def min_unique_passwords(self) -> pulumi.Output[Optional[int]]:
        """
        The minimum number of unique new passwords that a user must use before an old password can be reused. Defaults to 10.
        """
        return pulumi.get(self, "min_unique_passwords")

    @property
    @pulumi.getter(name="mustContainDigits")
    def must_contain_digits(self) -> pulumi.Output[Optional[bool]]:
        """
        If the password must contain digits. Defaults to true.
        """
        return pulumi.get(self, "must_contain_digits")

    @property
    @pulumi.getter(name="mustContainLowercase")
    def must_contain_lowercase(self) -> pulumi.Output[Optional[bool]]:
        """
        If the password must contain lower case characters. Defaults to true.
        """
        return pulumi.get(self, "must_contain_lowercase")

    @property
    @pulumi.getter(name="mustContainSpecialChars")
    def must_contain_special_chars(self) -> pulumi.Output[Optional[bool]]:
        """
        If the password must contain special characters. Defaults to true.
        """
        return pulumi.get(self, "must_contain_special_chars")

    @property
    @pulumi.getter(name="mustContainUppercase")
    def must_contain_uppercase(self) -> pulumi.Output[Optional[bool]]:
        """
        If the password must contain upper case characters. Defaults to true.
        """
        return pulumi.get(self, "must_contain_uppercase")

    @property
    @pulumi.getter(name="rememberMfa")
    def remember_mfa(self) -> pulumi.Output[Optional[bool]]:
        """
        If MFA should be remembered on the browser. Defaults to true.

        [1]: https://help.sumologic.com/Manage/Security/Set-the-Password-Policy
        """
        return pulumi.get(self, "remember_mfa")

    @property
    @pulumi.getter(name="requireMfa")
    def require_mfa(self) -> pulumi.Output[Optional[bool]]:
        """
        If MFA should be required to log in. Defaults to false.
        """
        return pulumi.get(self, "require_mfa")

