# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities

__all__ = ['RoleArgs', 'Role']

@pulumi.input_type
class RoleArgs:
    def __init__(__self__, *,
                 capabilities: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 filter_predicate: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a Role resource.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] capabilities: List of capabilities associated with this role. For a complete list of capability names, please see `capabilities` field in the request of [CreateRole](https://api.sumologic.com/docs/#operation/createRole) endpoint.
               
               The following attributes are exported:
        :param pulumi.Input[str] description: The description of the role.
        :param pulumi.Input[str] filter_predicate: A search filter to restrict access to specific logs.
        :param pulumi.Input[str] name: The name of the role.
        """
        if capabilities is not None:
            pulumi.set(__self__, "capabilities", capabilities)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if filter_predicate is not None:
            pulumi.set(__self__, "filter_predicate", filter_predicate)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def capabilities(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        List of capabilities associated with this role. For a complete list of capability names, please see `capabilities` field in the request of [CreateRole](https://api.sumologic.com/docs/#operation/createRole) endpoint.

        The following attributes are exported:
        """
        return pulumi.get(self, "capabilities")

    @capabilities.setter
    def capabilities(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "capabilities", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        The description of the role.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="filterPredicate")
    def filter_predicate(self) -> Optional[pulumi.Input[str]]:
        """
        A search filter to restrict access to specific logs.
        """
        return pulumi.get(self, "filter_predicate")

    @filter_predicate.setter
    def filter_predicate(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "filter_predicate", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the role.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)


@pulumi.input_type
class _RoleState:
    def __init__(__self__, *,
                 capabilities: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 filter_predicate: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering Role resources.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] capabilities: List of capabilities associated with this role. For a complete list of capability names, please see `capabilities` field in the request of [CreateRole](https://api.sumologic.com/docs/#operation/createRole) endpoint.
               
               The following attributes are exported:
        :param pulumi.Input[str] description: The description of the role.
        :param pulumi.Input[str] filter_predicate: A search filter to restrict access to specific logs.
        :param pulumi.Input[str] name: The name of the role.
        """
        if capabilities is not None:
            pulumi.set(__self__, "capabilities", capabilities)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if filter_predicate is not None:
            pulumi.set(__self__, "filter_predicate", filter_predicate)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def capabilities(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        List of capabilities associated with this role. For a complete list of capability names, please see `capabilities` field in the request of [CreateRole](https://api.sumologic.com/docs/#operation/createRole) endpoint.

        The following attributes are exported:
        """
        return pulumi.get(self, "capabilities")

    @capabilities.setter
    def capabilities(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "capabilities", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        The description of the role.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="filterPredicate")
    def filter_predicate(self) -> Optional[pulumi.Input[str]]:
        """
        A search filter to restrict access to specific logs.
        """
        return pulumi.get(self, "filter_predicate")

    @filter_predicate.setter
    def filter_predicate(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "filter_predicate", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the role.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)


class Role(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 capabilities: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 filter_predicate: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Provides a [Sumologic Role](https://help.sumologic.com/Manage/Users-and-Roles/Manage-Roles).

        ## Example Usage

        ```python
        import pulumi
        import pulumi_sumologic as sumologic

        example_role = sumologic.Role("exampleRole",
            capabilities=["manageCollectors"],
            description="Testing resource sumologic_role",
            filter_predicate="_sourceCategory=Test")
        ```

        ## Import

        Roles can be imported using the role id, e.g.hcl

        ```sh
         $ pulumi import sumologic:index/role:Role role 1234567890
        ```

         [1]https://help.sumologic.com/Manage/Users-and-Roles/Manage-Roles [2]https://api.sumologic.com/docs/#operation/createRole

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] capabilities: List of capabilities associated with this role. For a complete list of capability names, please see `capabilities` field in the request of [CreateRole](https://api.sumologic.com/docs/#operation/createRole) endpoint.
               
               The following attributes are exported:
        :param pulumi.Input[str] description: The description of the role.
        :param pulumi.Input[str] filter_predicate: A search filter to restrict access to specific logs.
        :param pulumi.Input[str] name: The name of the role.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[RoleArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a [Sumologic Role](https://help.sumologic.com/Manage/Users-and-Roles/Manage-Roles).

        ## Example Usage

        ```python
        import pulumi
        import pulumi_sumologic as sumologic

        example_role = sumologic.Role("exampleRole",
            capabilities=["manageCollectors"],
            description="Testing resource sumologic_role",
            filter_predicate="_sourceCategory=Test")
        ```

        ## Import

        Roles can be imported using the role id, e.g.hcl

        ```sh
         $ pulumi import sumologic:index/role:Role role 1234567890
        ```

         [1]https://help.sumologic.com/Manage/Users-and-Roles/Manage-Roles [2]https://api.sumologic.com/docs/#operation/createRole

        :param str resource_name: The name of the resource.
        :param RoleArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(RoleArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 capabilities: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 filter_predicate: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = RoleArgs.__new__(RoleArgs)

            __props__.__dict__["capabilities"] = capabilities
            __props__.__dict__["description"] = description
            __props__.__dict__["filter_predicate"] = filter_predicate
            __props__.__dict__["name"] = name
        super(Role, __self__).__init__(
            'sumologic:index/role:Role',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            capabilities: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            description: Optional[pulumi.Input[str]] = None,
            filter_predicate: Optional[pulumi.Input[str]] = None,
            name: Optional[pulumi.Input[str]] = None) -> 'Role':
        """
        Get an existing Role resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] capabilities: List of capabilities associated with this role. For a complete list of capability names, please see `capabilities` field in the request of [CreateRole](https://api.sumologic.com/docs/#operation/createRole) endpoint.
               
               The following attributes are exported:
        :param pulumi.Input[str] description: The description of the role.
        :param pulumi.Input[str] filter_predicate: A search filter to restrict access to specific logs.
        :param pulumi.Input[str] name: The name of the role.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _RoleState.__new__(_RoleState)

        __props__.__dict__["capabilities"] = capabilities
        __props__.__dict__["description"] = description
        __props__.__dict__["filter_predicate"] = filter_predicate
        __props__.__dict__["name"] = name
        return Role(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def capabilities(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        List of capabilities associated with this role. For a complete list of capability names, please see `capabilities` field in the request of [CreateRole](https://api.sumologic.com/docs/#operation/createRole) endpoint.

        The following attributes are exported:
        """
        return pulumi.get(self, "capabilities")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[str]]:
        """
        The description of the role.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="filterPredicate")
    def filter_predicate(self) -> pulumi.Output[Optional[str]]:
        """
        A search filter to restrict access to specific logs.
        """
        return pulumi.get(self, "filter_predicate")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        The name of the role.
        """
        return pulumi.get(self, "name")

