import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
* API Gateway
*/
export interface ApiGatewayAccountConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/api_gateway_account#cloudwatch_role_arn ApiGatewayAccount#cloudwatch_role_arn}
    */
    readonly cloudwatchRoleArn?: string;
}
export interface ApiGatewayAccountThrottleSettings {
}
export declare function apiGatewayAccountThrottleSettingsToTerraform(struct?: ApiGatewayAccountThrottleSettings): any;
export declare class ApiGatewayAccountThrottleSettingsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ApiGatewayAccountThrottleSettings | undefined;
    set internalValue(value: ApiGatewayAccountThrottleSettings | undefined);
    get burstLimit(): number;
    get rateLimit(): number;
}
export declare class ApiGatewayAccountThrottleSettingsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ApiGatewayAccountThrottleSettingsOutputReference;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/aws/r/api_gateway_account aws_api_gateway_account}
*/
export declare class ApiGatewayAccount extends cdktf.TerraformResource {
    static readonly tfResourceType = "aws_api_gateway_account";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/aws/r/api_gateway_account aws_api_gateway_account} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options ApiGatewayAccountConfig = {}
    */
    constructor(scope: Construct, id: string, config?: ApiGatewayAccountConfig);
    private _cloudwatchRoleArn?;
    get cloudwatchRoleArn(): string;
    set cloudwatchRoleArn(value: string);
    resetCloudwatchRoleArn(): void;
    get cloudwatchRoleArnInput(): string | undefined;
    get id(): string;
    private _throttleSettings;
    get throttleSettings(): ApiGatewayAccountThrottleSettingsList;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
//# sourceMappingURL=api-gateway-account.d.ts.map