"use strict";
var _a, _b;
Object.defineProperty(exports, "__esModule", { value: true });
exports.ApiGatewayMethodSettings = exports.ApiGatewayMethodSettingsSettingsOutputReference = exports.apiGatewayMethodSettingsSettingsToTerraform = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cdktf = require("cdktf");
function apiGatewayMethodSettingsSettingsToTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    return {
        cache_data_encrypted: cdktf.booleanToTerraform(struct.cacheDataEncrypted),
        cache_ttl_in_seconds: cdktf.numberToTerraform(struct.cacheTtlInSeconds),
        caching_enabled: cdktf.booleanToTerraform(struct.cachingEnabled),
        data_trace_enabled: cdktf.booleanToTerraform(struct.dataTraceEnabled),
        logging_level: cdktf.stringToTerraform(struct.loggingLevel),
        metrics_enabled: cdktf.booleanToTerraform(struct.metricsEnabled),
        require_authorization_for_cache_control: cdktf.booleanToTerraform(struct.requireAuthorizationForCacheControl),
        throttling_burst_limit: cdktf.numberToTerraform(struct.throttlingBurstLimit),
        throttling_rate_limit: cdktf.numberToTerraform(struct.throttlingRateLimit),
        unauthorized_cache_control_header_strategy: cdktf.stringToTerraform(struct.unauthorizedCacheControlHeaderStrategy),
    };
}
exports.apiGatewayMethodSettingsSettingsToTerraform = apiGatewayMethodSettingsSettingsToTerraform;
class ApiGatewayMethodSettingsSettingsOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource, terraformAttribute) {
        super(terraformResource, terraformAttribute, false, 0);
        this.isEmptyObject = false;
    }
    get internalValue() {
        let hasAnyValues = this.isEmptyObject;
        const internalValueResult = {};
        if (this._cacheDataEncrypted !== undefined) {
            hasAnyValues = true;
            internalValueResult.cacheDataEncrypted = this._cacheDataEncrypted;
        }
        if (this._cacheTtlInSeconds !== undefined) {
            hasAnyValues = true;
            internalValueResult.cacheTtlInSeconds = this._cacheTtlInSeconds;
        }
        if (this._cachingEnabled !== undefined) {
            hasAnyValues = true;
            internalValueResult.cachingEnabled = this._cachingEnabled;
        }
        if (this._dataTraceEnabled !== undefined) {
            hasAnyValues = true;
            internalValueResult.dataTraceEnabled = this._dataTraceEnabled;
        }
        if (this._loggingLevel !== undefined) {
            hasAnyValues = true;
            internalValueResult.loggingLevel = this._loggingLevel;
        }
        if (this._metricsEnabled !== undefined) {
            hasAnyValues = true;
            internalValueResult.metricsEnabled = this._metricsEnabled;
        }
        if (this._requireAuthorizationForCacheControl !== undefined) {
            hasAnyValues = true;
            internalValueResult.requireAuthorizationForCacheControl = this._requireAuthorizationForCacheControl;
        }
        if (this._throttlingBurstLimit !== undefined) {
            hasAnyValues = true;
            internalValueResult.throttlingBurstLimit = this._throttlingBurstLimit;
        }
        if (this._throttlingRateLimit !== undefined) {
            hasAnyValues = true;
            internalValueResult.throttlingRateLimit = this._throttlingRateLimit;
        }
        if (this._unauthorizedCacheControlHeaderStrategy !== undefined) {
            hasAnyValues = true;
            internalValueResult.unauthorizedCacheControlHeaderStrategy = this._unauthorizedCacheControlHeaderStrategy;
        }
        return hasAnyValues ? internalValueResult : undefined;
    }
    set internalValue(value) {
        if (value === undefined) {
            this.isEmptyObject = false;
            this._cacheDataEncrypted = undefined;
            this._cacheTtlInSeconds = undefined;
            this._cachingEnabled = undefined;
            this._dataTraceEnabled = undefined;
            this._loggingLevel = undefined;
            this._metricsEnabled = undefined;
            this._requireAuthorizationForCacheControl = undefined;
            this._throttlingBurstLimit = undefined;
            this._throttlingRateLimit = undefined;
            this._unauthorizedCacheControlHeaderStrategy = undefined;
        }
        else {
            this.isEmptyObject = Object.keys(value).length === 0;
            this._cacheDataEncrypted = value.cacheDataEncrypted;
            this._cacheTtlInSeconds = value.cacheTtlInSeconds;
            this._cachingEnabled = value.cachingEnabled;
            this._dataTraceEnabled = value.dataTraceEnabled;
            this._loggingLevel = value.loggingLevel;
            this._metricsEnabled = value.metricsEnabled;
            this._requireAuthorizationForCacheControl = value.requireAuthorizationForCacheControl;
            this._throttlingBurstLimit = value.throttlingBurstLimit;
            this._throttlingRateLimit = value.throttlingRateLimit;
            this._unauthorizedCacheControlHeaderStrategy = value.unauthorizedCacheControlHeaderStrategy;
        }
    }
    get cacheDataEncrypted() {
        return this.getBooleanAttribute('cache_data_encrypted');
    }
    set cacheDataEncrypted(value) {
        this._cacheDataEncrypted = value;
    }
    resetCacheDataEncrypted() {
        this._cacheDataEncrypted = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get cacheDataEncryptedInput() {
        return this._cacheDataEncrypted;
    }
    get cacheTtlInSeconds() {
        return this.getNumberAttribute('cache_ttl_in_seconds');
    }
    set cacheTtlInSeconds(value) {
        this._cacheTtlInSeconds = value;
    }
    resetCacheTtlInSeconds() {
        this._cacheTtlInSeconds = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get cacheTtlInSecondsInput() {
        return this._cacheTtlInSeconds;
    }
    get cachingEnabled() {
        return this.getBooleanAttribute('caching_enabled');
    }
    set cachingEnabled(value) {
        this._cachingEnabled = value;
    }
    resetCachingEnabled() {
        this._cachingEnabled = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get cachingEnabledInput() {
        return this._cachingEnabled;
    }
    get dataTraceEnabled() {
        return this.getBooleanAttribute('data_trace_enabled');
    }
    set dataTraceEnabled(value) {
        this._dataTraceEnabled = value;
    }
    resetDataTraceEnabled() {
        this._dataTraceEnabled = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get dataTraceEnabledInput() {
        return this._dataTraceEnabled;
    }
    get loggingLevel() {
        return this.getStringAttribute('logging_level');
    }
    set loggingLevel(value) {
        this._loggingLevel = value;
    }
    resetLoggingLevel() {
        this._loggingLevel = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get loggingLevelInput() {
        return this._loggingLevel;
    }
    get metricsEnabled() {
        return this.getBooleanAttribute('metrics_enabled');
    }
    set metricsEnabled(value) {
        this._metricsEnabled = value;
    }
    resetMetricsEnabled() {
        this._metricsEnabled = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get metricsEnabledInput() {
        return this._metricsEnabled;
    }
    get requireAuthorizationForCacheControl() {
        return this.getBooleanAttribute('require_authorization_for_cache_control');
    }
    set requireAuthorizationForCacheControl(value) {
        this._requireAuthorizationForCacheControl = value;
    }
    resetRequireAuthorizationForCacheControl() {
        this._requireAuthorizationForCacheControl = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get requireAuthorizationForCacheControlInput() {
        return this._requireAuthorizationForCacheControl;
    }
    get throttlingBurstLimit() {
        return this.getNumberAttribute('throttling_burst_limit');
    }
    set throttlingBurstLimit(value) {
        this._throttlingBurstLimit = value;
    }
    resetThrottlingBurstLimit() {
        this._throttlingBurstLimit = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get throttlingBurstLimitInput() {
        return this._throttlingBurstLimit;
    }
    get throttlingRateLimit() {
        return this.getNumberAttribute('throttling_rate_limit');
    }
    set throttlingRateLimit(value) {
        this._throttlingRateLimit = value;
    }
    resetThrottlingRateLimit() {
        this._throttlingRateLimit = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get throttlingRateLimitInput() {
        return this._throttlingRateLimit;
    }
    get unauthorizedCacheControlHeaderStrategy() {
        return this.getStringAttribute('unauthorized_cache_control_header_strategy');
    }
    set unauthorizedCacheControlHeaderStrategy(value) {
        this._unauthorizedCacheControlHeaderStrategy = value;
    }
    resetUnauthorizedCacheControlHeaderStrategy() {
        this._unauthorizedCacheControlHeaderStrategy = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get unauthorizedCacheControlHeaderStrategyInput() {
        return this._unauthorizedCacheControlHeaderStrategy;
    }
}
exports.ApiGatewayMethodSettingsSettingsOutputReference = ApiGatewayMethodSettingsSettingsOutputReference;
_a = JSII_RTTI_SYMBOL_1;
ApiGatewayMethodSettingsSettingsOutputReference[_a] = { fqn: "@cdktf/provider-aws.apigateway.ApiGatewayMethodSettingsSettingsOutputReference", version: "7.0.64" };
/**
* Represents a {@link https://www.terraform.io/docs/providers/aws/r/api_gateway_method_settings aws_api_gateway_method_settings}
*/
class ApiGatewayMethodSettings extends cdktf.TerraformResource {
    // ===========
    // INITIALIZER
    // ===========
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/aws/r/api_gateway_method_settings aws_api_gateway_method_settings} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options ApiGatewayMethodSettingsConfig
    */
    constructor(scope, id, config) {
        super(scope, id, {
            terraformResourceType: 'aws_api_gateway_method_settings',
            terraformGeneratorMetadata: {
                providerName: 'aws',
                providerVersion: '4.15.1',
                providerVersionConstraint: '~> 4.0'
            },
            provider: config.provider,
            dependsOn: config.dependsOn,
            count: config.count,
            lifecycle: config.lifecycle
        });
        // settings - computed: false, optional: false, required: true
        this._settings = new ApiGatewayMethodSettingsSettingsOutputReference(this, "settings");
        this._methodPath = config.methodPath;
        this._restApiId = config.restApiId;
        this._stageName = config.stageName;
        this._settings.internalValue = config.settings;
    }
    // ==========
    // ATTRIBUTES
    // ==========
    // id - computed: true, optional: true, required: false
    get id() {
        return this.getStringAttribute('id');
    }
    get methodPath() {
        return this.getStringAttribute('method_path');
    }
    set methodPath(value) {
        this._methodPath = value;
    }
    // Temporarily expose input value. Use with caution.
    get methodPathInput() {
        return this._methodPath;
    }
    get restApiId() {
        return this.getStringAttribute('rest_api_id');
    }
    set restApiId(value) {
        this._restApiId = value;
    }
    // Temporarily expose input value. Use with caution.
    get restApiIdInput() {
        return this._restApiId;
    }
    get stageName() {
        return this.getStringAttribute('stage_name');
    }
    set stageName(value) {
        this._stageName = value;
    }
    // Temporarily expose input value. Use with caution.
    get stageNameInput() {
        return this._stageName;
    }
    get settings() {
        return this._settings;
    }
    putSettings(value) {
        this._settings.internalValue = value;
    }
    // Temporarily expose input value. Use with caution.
    get settingsInput() {
        return this._settings.internalValue;
    }
    // =========
    // SYNTHESIS
    // =========
    synthesizeAttributes() {
        return {
            method_path: cdktf.stringToTerraform(this._methodPath),
            rest_api_id: cdktf.stringToTerraform(this._restApiId),
            stage_name: cdktf.stringToTerraform(this._stageName),
            settings: apiGatewayMethodSettingsSettingsToTerraform(this._settings.internalValue),
        };
    }
}
exports.ApiGatewayMethodSettings = ApiGatewayMethodSettings;
_b = JSII_RTTI_SYMBOL_1;
ApiGatewayMethodSettings[_b] = { fqn: "@cdktf/provider-aws.apigateway.ApiGatewayMethodSettings", version: "7.0.64" };
// =================
// STATIC PROPERTIES
// =================
ApiGatewayMethodSettings.tfResourceType = "aws_api_gateway_method_settings";
//# sourceMappingURL=data:application/json;base64,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