import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
* API Gateway
*/
export interface ApiGatewayUsagePlanConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/api_gateway_usage_plan#description ApiGatewayUsagePlan#description}
    */
    readonly description?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/api_gateway_usage_plan#name ApiGatewayUsagePlan#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/api_gateway_usage_plan#product_code ApiGatewayUsagePlan#product_code}
    */
    readonly productCode?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/api_gateway_usage_plan#tags ApiGatewayUsagePlan#tags}
    */
    readonly tags?: {
        [key: string]: string;
    };
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/api_gateway_usage_plan#tags_all ApiGatewayUsagePlan#tags_all}
    */
    readonly tagsAll?: {
        [key: string]: string;
    };
    /**
    * api_stages block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/api_gateway_usage_plan#api_stages ApiGatewayUsagePlan#api_stages}
    */
    readonly apiStages?: ApiGatewayUsagePlanApiStages[] | cdktf.IResolvable;
    /**
    * quota_settings block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/api_gateway_usage_plan#quota_settings ApiGatewayUsagePlan#quota_settings}
    */
    readonly quotaSettings?: ApiGatewayUsagePlanQuotaSettings;
    /**
    * throttle_settings block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/api_gateway_usage_plan#throttle_settings ApiGatewayUsagePlan#throttle_settings}
    */
    readonly throttleSettings?: ApiGatewayUsagePlanThrottleSettings;
}
export interface ApiGatewayUsagePlanApiStagesThrottle {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/api_gateway_usage_plan#burst_limit ApiGatewayUsagePlan#burst_limit}
    */
    readonly burstLimit?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/api_gateway_usage_plan#path ApiGatewayUsagePlan#path}
    */
    readonly path: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/api_gateway_usage_plan#rate_limit ApiGatewayUsagePlan#rate_limit}
    */
    readonly rateLimit?: number;
}
export declare function apiGatewayUsagePlanApiStagesThrottleToTerraform(struct?: ApiGatewayUsagePlanApiStagesThrottle | cdktf.IResolvable): any;
export interface ApiGatewayUsagePlanApiStages {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/api_gateway_usage_plan#api_id ApiGatewayUsagePlan#api_id}
    */
    readonly apiId: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/api_gateway_usage_plan#stage ApiGatewayUsagePlan#stage}
    */
    readonly stage: string;
    /**
    * throttle block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/api_gateway_usage_plan#throttle ApiGatewayUsagePlan#throttle}
    */
    readonly throttle?: ApiGatewayUsagePlanApiStagesThrottle[] | cdktf.IResolvable;
}
export declare function apiGatewayUsagePlanApiStagesToTerraform(struct?: ApiGatewayUsagePlanApiStages | cdktf.IResolvable): any;
export interface ApiGatewayUsagePlanQuotaSettings {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/api_gateway_usage_plan#limit ApiGatewayUsagePlan#limit}
    */
    readonly limit: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/api_gateway_usage_plan#offset ApiGatewayUsagePlan#offset}
    */
    readonly offset?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/api_gateway_usage_plan#period ApiGatewayUsagePlan#period}
    */
    readonly period: string;
}
export declare function apiGatewayUsagePlanQuotaSettingsToTerraform(struct?: ApiGatewayUsagePlanQuotaSettingsOutputReference | ApiGatewayUsagePlanQuotaSettings): any;
export declare class ApiGatewayUsagePlanQuotaSettingsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ApiGatewayUsagePlanQuotaSettings | undefined;
    set internalValue(value: ApiGatewayUsagePlanQuotaSettings | undefined);
    private _limit?;
    get limit(): number;
    set limit(value: number);
    get limitInput(): number | undefined;
    private _offset?;
    get offset(): number;
    set offset(value: number);
    resetOffset(): void;
    get offsetInput(): number | undefined;
    private _period?;
    get period(): string;
    set period(value: string);
    get periodInput(): string | undefined;
}
export interface ApiGatewayUsagePlanThrottleSettings {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/api_gateway_usage_plan#burst_limit ApiGatewayUsagePlan#burst_limit}
    */
    readonly burstLimit?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/api_gateway_usage_plan#rate_limit ApiGatewayUsagePlan#rate_limit}
    */
    readonly rateLimit?: number;
}
export declare function apiGatewayUsagePlanThrottleSettingsToTerraform(struct?: ApiGatewayUsagePlanThrottleSettingsOutputReference | ApiGatewayUsagePlanThrottleSettings): any;
export declare class ApiGatewayUsagePlanThrottleSettingsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ApiGatewayUsagePlanThrottleSettings | undefined;
    set internalValue(value: ApiGatewayUsagePlanThrottleSettings | undefined);
    private _burstLimit?;
    get burstLimit(): number;
    set burstLimit(value: number);
    resetBurstLimit(): void;
    get burstLimitInput(): number | undefined;
    private _rateLimit?;
    get rateLimit(): number;
    set rateLimit(value: number);
    resetRateLimit(): void;
    get rateLimitInput(): number | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/aws/r/api_gateway_usage_plan aws_api_gateway_usage_plan}
*/
export declare class ApiGatewayUsagePlan extends cdktf.TerraformResource {
    static readonly tfResourceType = "aws_api_gateway_usage_plan";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/aws/r/api_gateway_usage_plan aws_api_gateway_usage_plan} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options ApiGatewayUsagePlanConfig
    */
    constructor(scope: Construct, id: string, config: ApiGatewayUsagePlanConfig);
    get arn(): string;
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    get id(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _productCode?;
    get productCode(): string;
    set productCode(value: string);
    resetProductCode(): void;
    get productCodeInput(): string | undefined;
    private _tags?;
    get tags(): {
        [key: string]: string;
    };
    set tags(value: {
        [key: string]: string;
    });
    resetTags(): void;
    get tagsInput(): {
        [key: string]: string;
    } | undefined;
    private _tagsAll?;
    get tagsAll(): {
        [key: string]: string;
    };
    set tagsAll(value: {
        [key: string]: string;
    });
    resetTagsAll(): void;
    get tagsAllInput(): {
        [key: string]: string;
    } | undefined;
    private _apiStages?;
    get apiStages(): ApiGatewayUsagePlanApiStages[] | cdktf.IResolvable;
    set apiStages(value: ApiGatewayUsagePlanApiStages[] | cdktf.IResolvable);
    resetApiStages(): void;
    get apiStagesInput(): cdktf.IResolvable | ApiGatewayUsagePlanApiStages[] | undefined;
    private _quotaSettings;
    get quotaSettings(): ApiGatewayUsagePlanQuotaSettingsOutputReference;
    putQuotaSettings(value: ApiGatewayUsagePlanQuotaSettings): void;
    resetQuotaSettings(): void;
    get quotaSettingsInput(): ApiGatewayUsagePlanQuotaSettings | undefined;
    private _throttleSettings;
    get throttleSettings(): ApiGatewayUsagePlanThrottleSettingsOutputReference;
    putThrottleSettings(value: ApiGatewayUsagePlanThrottleSettings): void;
    resetThrottleSettings(): void;
    get throttleSettingsInput(): ApiGatewayUsagePlanThrottleSettings | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
//# sourceMappingURL=api-gateway-usage-plan.d.ts.map