import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
* API Gateway
*/
export interface DataAwsApiGatewayDomainNameConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/d/api_gateway_domain_name#domain_name DataAwsApiGatewayDomainName#domain_name}
    */
    readonly domainName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/d/api_gateway_domain_name#tags DataAwsApiGatewayDomainName#tags}
    */
    readonly tags?: {
        [key: string]: string;
    };
}
export interface DataAwsApiGatewayDomainNameEndpointConfiguration {
}
export declare function dataAwsApiGatewayDomainNameEndpointConfigurationToTerraform(struct?: DataAwsApiGatewayDomainNameEndpointConfiguration): any;
export declare class DataAwsApiGatewayDomainNameEndpointConfigurationOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAwsApiGatewayDomainNameEndpointConfiguration | undefined;
    set internalValue(value: DataAwsApiGatewayDomainNameEndpointConfiguration | undefined);
    get types(): string[];
}
export declare class DataAwsApiGatewayDomainNameEndpointConfigurationList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAwsApiGatewayDomainNameEndpointConfigurationOutputReference;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/aws/d/api_gateway_domain_name aws_api_gateway_domain_name}
*/
export declare class DataAwsApiGatewayDomainName extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "aws_api_gateway_domain_name";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/aws/d/api_gateway_domain_name aws_api_gateway_domain_name} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataAwsApiGatewayDomainNameConfig
    */
    constructor(scope: Construct, id: string, config: DataAwsApiGatewayDomainNameConfig);
    get arn(): string;
    get certificateArn(): string;
    get certificateName(): string;
    get certificateUploadDate(): string;
    get cloudfrontDomainName(): string;
    get cloudfrontZoneId(): string;
    private _domainName?;
    get domainName(): string;
    set domainName(value: string);
    get domainNameInput(): string | undefined;
    private _endpointConfiguration;
    get endpointConfiguration(): DataAwsApiGatewayDomainNameEndpointConfigurationList;
    get id(): string;
    get regionalCertificateArn(): string;
    get regionalCertificateName(): string;
    get regionalDomainName(): string;
    get regionalZoneId(): string;
    get securityPolicy(): string;
    private _tags?;
    get tags(): {
        [key: string]: string;
    };
    set tags(value: {
        [key: string]: string;
    });
    resetTags(): void;
    get tagsInput(): {
        [key: string]: string;
    } | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
//# sourceMappingURL=data-aws-api-gateway-domain-name.d.ts.map