"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Apigatewayv2Route = exports.apigatewayv2RouteRequestParameterToTerraform = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cdktf = require("cdktf");
function apigatewayv2RouteRequestParameterToTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    return {
        request_parameter_key: cdktf.stringToTerraform(struct.requestParameterKey),
        required: cdktf.booleanToTerraform(struct.required),
    };
}
exports.apigatewayv2RouteRequestParameterToTerraform = apigatewayv2RouteRequestParameterToTerraform;
/**
* Represents a {@link https://www.terraform.io/docs/providers/aws/r/apigatewayv2_route aws_apigatewayv2_route}
*/
class Apigatewayv2Route extends cdktf.TerraformResource {
    // ===========
    // INITIALIZER
    // ===========
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/aws/r/apigatewayv2_route aws_apigatewayv2_route} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options Apigatewayv2RouteConfig
    */
    constructor(scope, id, config) {
        super(scope, id, {
            terraformResourceType: 'aws_apigatewayv2_route',
            terraformGeneratorMetadata: {
                providerName: 'aws',
                providerVersion: '4.15.1',
                providerVersionConstraint: '~> 4.0'
            },
            provider: config.provider,
            dependsOn: config.dependsOn,
            count: config.count,
            lifecycle: config.lifecycle
        });
        this._apiId = config.apiId;
        this._apiKeyRequired = config.apiKeyRequired;
        this._authorizationScopes = config.authorizationScopes;
        this._authorizationType = config.authorizationType;
        this._authorizerId = config.authorizerId;
        this._modelSelectionExpression = config.modelSelectionExpression;
        this._operationName = config.operationName;
        this._requestModels = config.requestModels;
        this._routeKey = config.routeKey;
        this._routeResponseSelectionExpression = config.routeResponseSelectionExpression;
        this._target = config.target;
        this._requestParameter = config.requestParameter;
    }
    get apiId() {
        return this.getStringAttribute('api_id');
    }
    set apiId(value) {
        this._apiId = value;
    }
    // Temporarily expose input value. Use with caution.
    get apiIdInput() {
        return this._apiId;
    }
    get apiKeyRequired() {
        return this.getBooleanAttribute('api_key_required');
    }
    set apiKeyRequired(value) {
        this._apiKeyRequired = value;
    }
    resetApiKeyRequired() {
        this._apiKeyRequired = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get apiKeyRequiredInput() {
        return this._apiKeyRequired;
    }
    get authorizationScopes() {
        return cdktf.Fn.tolist(this.getListAttribute('authorization_scopes'));
    }
    set authorizationScopes(value) {
        this._authorizationScopes = value;
    }
    resetAuthorizationScopes() {
        this._authorizationScopes = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get authorizationScopesInput() {
        return this._authorizationScopes;
    }
    get authorizationType() {
        return this.getStringAttribute('authorization_type');
    }
    set authorizationType(value) {
        this._authorizationType = value;
    }
    resetAuthorizationType() {
        this._authorizationType = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get authorizationTypeInput() {
        return this._authorizationType;
    }
    get authorizerId() {
        return this.getStringAttribute('authorizer_id');
    }
    set authorizerId(value) {
        this._authorizerId = value;
    }
    resetAuthorizerId() {
        this._authorizerId = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get authorizerIdInput() {
        return this._authorizerId;
    }
    // id - computed: true, optional: true, required: false
    get id() {
        return this.getStringAttribute('id');
    }
    get modelSelectionExpression() {
        return this.getStringAttribute('model_selection_expression');
    }
    set modelSelectionExpression(value) {
        this._modelSelectionExpression = value;
    }
    resetModelSelectionExpression() {
        this._modelSelectionExpression = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get modelSelectionExpressionInput() {
        return this._modelSelectionExpression;
    }
    get operationName() {
        return this.getStringAttribute('operation_name');
    }
    set operationName(value) {
        this._operationName = value;
    }
    resetOperationName() {
        this._operationName = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get operationNameInput() {
        return this._operationName;
    }
    get requestModels() {
        return this.getStringMapAttribute('request_models');
    }
    set requestModels(value) {
        this._requestModels = value;
    }
    resetRequestModels() {
        this._requestModels = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get requestModelsInput() {
        return this._requestModels;
    }
    get routeKey() {
        return this.getStringAttribute('route_key');
    }
    set routeKey(value) {
        this._routeKey = value;
    }
    // Temporarily expose input value. Use with caution.
    get routeKeyInput() {
        return this._routeKey;
    }
    get routeResponseSelectionExpression() {
        return this.getStringAttribute('route_response_selection_expression');
    }
    set routeResponseSelectionExpression(value) {
        this._routeResponseSelectionExpression = value;
    }
    resetRouteResponseSelectionExpression() {
        this._routeResponseSelectionExpression = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get routeResponseSelectionExpressionInput() {
        return this._routeResponseSelectionExpression;
    }
    get target() {
        return this.getStringAttribute('target');
    }
    set target(value) {
        this._target = value;
    }
    resetTarget() {
        this._target = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get targetInput() {
        return this._target;
    }
    get requestParameter() {
        // Getting the computed value is not yet implemented
        return cdktf.Token.asAny(cdktf.Fn.tolist(this.interpolationForAttribute('request_parameter')));
    }
    set requestParameter(value) {
        this._requestParameter = value;
    }
    resetRequestParameter() {
        this._requestParameter = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get requestParameterInput() {
        return this._requestParameter;
    }
    // =========
    // SYNTHESIS
    // =========
    synthesizeAttributes() {
        return {
            api_id: cdktf.stringToTerraform(this._apiId),
            api_key_required: cdktf.booleanToTerraform(this._apiKeyRequired),
            authorization_scopes: cdktf.listMapper(cdktf.stringToTerraform)(this._authorizationScopes),
            authorization_type: cdktf.stringToTerraform(this._authorizationType),
            authorizer_id: cdktf.stringToTerraform(this._authorizerId),
            model_selection_expression: cdktf.stringToTerraform(this._modelSelectionExpression),
            operation_name: cdktf.stringToTerraform(this._operationName),
            request_models: cdktf.hashMapper(cdktf.stringToTerraform)(this._requestModels),
            route_key: cdktf.stringToTerraform(this._routeKey),
            route_response_selection_expression: cdktf.stringToTerraform(this._routeResponseSelectionExpression),
            target: cdktf.stringToTerraform(this._target),
            request_parameter: cdktf.listMapper(apigatewayv2RouteRequestParameterToTerraform)(this._requestParameter),
        };
    }
}
exports.Apigatewayv2Route = Apigatewayv2Route;
_a = JSII_RTTI_SYMBOL_1;
Apigatewayv2Route[_a] = { fqn: "@cdktf/provider-aws.apigatewayv2.Apigatewayv2Route", version: "7.0.64" };
// =================
// STATIC PROPERTIES
// =================
Apigatewayv2Route.tfResourceType = "aws_apigatewayv2_route";
//# sourceMappingURL=data:application/json;base64,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