import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
* Amazon API Gateway Websocket and HTTP APIs
*/
export interface DataAwsApigatewayv2ExportConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/d/apigatewayv2_export#api_id DataAwsApigatewayv2Export#api_id}
    */
    readonly apiId: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/d/apigatewayv2_export#export_version DataAwsApigatewayv2Export#export_version}
    */
    readonly exportVersion?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/d/apigatewayv2_export#include_extensions DataAwsApigatewayv2Export#include_extensions}
    */
    readonly includeExtensions?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/d/apigatewayv2_export#output_type DataAwsApigatewayv2Export#output_type}
    */
    readonly outputType: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/d/apigatewayv2_export#specification DataAwsApigatewayv2Export#specification}
    */
    readonly specification: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/d/apigatewayv2_export#stage_name DataAwsApigatewayv2Export#stage_name}
    */
    readonly stageName?: string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/aws/d/apigatewayv2_export aws_apigatewayv2_export}
*/
export declare class DataAwsApigatewayv2Export extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "aws_apigatewayv2_export";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/aws/d/apigatewayv2_export aws_apigatewayv2_export} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataAwsApigatewayv2ExportConfig
    */
    constructor(scope: Construct, id: string, config: DataAwsApigatewayv2ExportConfig);
    private _apiId?;
    get apiId(): string;
    set apiId(value: string);
    get apiIdInput(): string | undefined;
    get body(): string;
    private _exportVersion?;
    get exportVersion(): string;
    set exportVersion(value: string);
    resetExportVersion(): void;
    get exportVersionInput(): string | undefined;
    get id(): string;
    private _includeExtensions?;
    get includeExtensions(): boolean | cdktf.IResolvable;
    set includeExtensions(value: boolean | cdktf.IResolvable);
    resetIncludeExtensions(): void;
    get includeExtensionsInput(): boolean | cdktf.IResolvable | undefined;
    private _outputType?;
    get outputType(): string;
    set outputType(value: string);
    get outputTypeInput(): string | undefined;
    private _specification?;
    get specification(): string;
    set specification(value: string);
    get specificationInput(): string | undefined;
    private _stageName?;
    get stageName(): string;
    set stageName(value: string);
    resetStageName(): void;
    get stageNameInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
//# sourceMappingURL=data-aws-apigatewayv2-export.d.ts.map