"use strict";
var _a, _b;
Object.defineProperty(exports, "__esModule", { value: true });
exports.AppstreamDirectoryConfig = exports.AppstreamDirectoryConfigServiceAccountCredentialsOutputReference = exports.appstreamDirectoryConfigServiceAccountCredentialsToTerraform = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cdktf = require("cdktf");
function appstreamDirectoryConfigServiceAccountCredentialsToTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    return {
        account_name: cdktf.stringToTerraform(struct.accountName),
        account_password: cdktf.stringToTerraform(struct.accountPassword),
    };
}
exports.appstreamDirectoryConfigServiceAccountCredentialsToTerraform = appstreamDirectoryConfigServiceAccountCredentialsToTerraform;
class AppstreamDirectoryConfigServiceAccountCredentialsOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource, terraformAttribute) {
        super(terraformResource, terraformAttribute, false, 0);
        this.isEmptyObject = false;
    }
    get internalValue() {
        let hasAnyValues = this.isEmptyObject;
        const internalValueResult = {};
        if (this._accountName !== undefined) {
            hasAnyValues = true;
            internalValueResult.accountName = this._accountName;
        }
        if (this._accountPassword !== undefined) {
            hasAnyValues = true;
            internalValueResult.accountPassword = this._accountPassword;
        }
        return hasAnyValues ? internalValueResult : undefined;
    }
    set internalValue(value) {
        if (value === undefined) {
            this.isEmptyObject = false;
            this._accountName = undefined;
            this._accountPassword = undefined;
        }
        else {
            this.isEmptyObject = Object.keys(value).length === 0;
            this._accountName = value.accountName;
            this._accountPassword = value.accountPassword;
        }
    }
    get accountName() {
        return this.getStringAttribute('account_name');
    }
    set accountName(value) {
        this._accountName = value;
    }
    // Temporarily expose input value. Use with caution.
    get accountNameInput() {
        return this._accountName;
    }
    get accountPassword() {
        return this.getStringAttribute('account_password');
    }
    set accountPassword(value) {
        this._accountPassword = value;
    }
    // Temporarily expose input value. Use with caution.
    get accountPasswordInput() {
        return this._accountPassword;
    }
}
exports.AppstreamDirectoryConfigServiceAccountCredentialsOutputReference = AppstreamDirectoryConfigServiceAccountCredentialsOutputReference;
_a = JSII_RTTI_SYMBOL_1;
AppstreamDirectoryConfigServiceAccountCredentialsOutputReference[_a] = { fqn: "@cdktf/provider-aws.appstream.AppstreamDirectoryConfigServiceAccountCredentialsOutputReference", version: "7.0.64" };
/**
* Represents a {@link https://www.terraform.io/docs/providers/aws/r/appstream_directory_config aws_appstream_directory_config}
*/
class AppstreamDirectoryConfig extends cdktf.TerraformResource {
    // ===========
    // INITIALIZER
    // ===========
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/aws/r/appstream_directory_config aws_appstream_directory_config} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options AppstreamDirectoryConfigConfig
    */
    constructor(scope, id, config) {
        super(scope, id, {
            terraformResourceType: 'aws_appstream_directory_config',
            terraformGeneratorMetadata: {
                providerName: 'aws',
                providerVersion: '4.15.1',
                providerVersionConstraint: '~> 4.0'
            },
            provider: config.provider,
            dependsOn: config.dependsOn,
            count: config.count,
            lifecycle: config.lifecycle
        });
        // service_account_credentials - computed: false, optional: false, required: true
        this._serviceAccountCredentials = new AppstreamDirectoryConfigServiceAccountCredentialsOutputReference(this, "service_account_credentials");
        this._directoryName = config.directoryName;
        this._organizationalUnitDistinguishedNames = config.organizationalUnitDistinguishedNames;
        this._serviceAccountCredentials.internalValue = config.serviceAccountCredentials;
    }
    // ==========
    // ATTRIBUTES
    // ==========
    // created_time - computed: true, optional: false, required: false
    get createdTime() {
        return this.getStringAttribute('created_time');
    }
    get directoryName() {
        return this.getStringAttribute('directory_name');
    }
    set directoryName(value) {
        this._directoryName = value;
    }
    // Temporarily expose input value. Use with caution.
    get directoryNameInput() {
        return this._directoryName;
    }
    // id - computed: true, optional: true, required: false
    get id() {
        return this.getStringAttribute('id');
    }
    get organizationalUnitDistinguishedNames() {
        return cdktf.Fn.tolist(this.getListAttribute('organizational_unit_distinguished_names'));
    }
    set organizationalUnitDistinguishedNames(value) {
        this._organizationalUnitDistinguishedNames = value;
    }
    // Temporarily expose input value. Use with caution.
    get organizationalUnitDistinguishedNamesInput() {
        return this._organizationalUnitDistinguishedNames;
    }
    get serviceAccountCredentials() {
        return this._serviceAccountCredentials;
    }
    putServiceAccountCredentials(value) {
        this._serviceAccountCredentials.internalValue = value;
    }
    // Temporarily expose input value. Use with caution.
    get serviceAccountCredentialsInput() {
        return this._serviceAccountCredentials.internalValue;
    }
    // =========
    // SYNTHESIS
    // =========
    synthesizeAttributes() {
        return {
            directory_name: cdktf.stringToTerraform(this._directoryName),
            organizational_unit_distinguished_names: cdktf.listMapper(cdktf.stringToTerraform)(this._organizationalUnitDistinguishedNames),
            service_account_credentials: appstreamDirectoryConfigServiceAccountCredentialsToTerraform(this._serviceAccountCredentials.internalValue),
        };
    }
}
exports.AppstreamDirectoryConfig = AppstreamDirectoryConfig;
_b = JSII_RTTI_SYMBOL_1;
AppstreamDirectoryConfig[_b] = { fqn: "@cdktf/provider-aws.appstream.AppstreamDirectoryConfig", version: "7.0.64" };
// =================
// STATIC PROPERTIES
// =================
AppstreamDirectoryConfig.tfResourceType = "aws_appstream_directory_config";
//# sourceMappingURL=data:application/json;base64,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