import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
* AppStream
*/
export interface AppstreamStackConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/appstream_stack#description AppstreamStack#description}
    */
    readonly description?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/appstream_stack#display_name AppstreamStack#display_name}
    */
    readonly displayName?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/appstream_stack#embed_host_domains AppstreamStack#embed_host_domains}
    */
    readonly embedHostDomains?: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/appstream_stack#feedback_url AppstreamStack#feedback_url}
    */
    readonly feedbackUrl?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/appstream_stack#name AppstreamStack#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/appstream_stack#redirect_url AppstreamStack#redirect_url}
    */
    readonly redirectUrl?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/appstream_stack#tags AppstreamStack#tags}
    */
    readonly tags?: {
        [key: string]: string;
    };
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/appstream_stack#tags_all AppstreamStack#tags_all}
    */
    readonly tagsAll?: {
        [key: string]: string;
    };
    /**
    * access_endpoints block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/appstream_stack#access_endpoints AppstreamStack#access_endpoints}
    */
    readonly accessEndpoints?: AppstreamStackAccessEndpoints[] | cdktf.IResolvable;
    /**
    * application_settings block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/appstream_stack#application_settings AppstreamStack#application_settings}
    */
    readonly applicationSettings?: AppstreamStackApplicationSettings;
    /**
    * storage_connectors block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/appstream_stack#storage_connectors AppstreamStack#storage_connectors}
    */
    readonly storageConnectors?: AppstreamStackStorageConnectors[] | cdktf.IResolvable;
    /**
    * user_settings block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/appstream_stack#user_settings AppstreamStack#user_settings}
    */
    readonly userSettings?: AppstreamStackUserSettings[] | cdktf.IResolvable;
}
export interface AppstreamStackAccessEndpoints {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/appstream_stack#endpoint_type AppstreamStack#endpoint_type}
    */
    readonly endpointType: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/appstream_stack#vpce_id AppstreamStack#vpce_id}
    */
    readonly vpceId?: string;
}
export declare function appstreamStackAccessEndpointsToTerraform(struct?: AppstreamStackAccessEndpoints | cdktf.IResolvable): any;
export interface AppstreamStackApplicationSettings {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/appstream_stack#enabled AppstreamStack#enabled}
    */
    readonly enabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/appstream_stack#settings_group AppstreamStack#settings_group}
    */
    readonly settingsGroup?: string;
}
export declare function appstreamStackApplicationSettingsToTerraform(struct?: AppstreamStackApplicationSettingsOutputReference | AppstreamStackApplicationSettings): any;
export declare class AppstreamStackApplicationSettingsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): AppstreamStackApplicationSettings | undefined;
    set internalValue(value: AppstreamStackApplicationSettings | undefined);
    private _enabled?;
    get enabled(): boolean | cdktf.IResolvable;
    set enabled(value: boolean | cdktf.IResolvable);
    resetEnabled(): void;
    get enabledInput(): boolean | cdktf.IResolvable | undefined;
    private _settingsGroup?;
    get settingsGroup(): string;
    set settingsGroup(value: string);
    resetSettingsGroup(): void;
    get settingsGroupInput(): string | undefined;
}
export interface AppstreamStackStorageConnectors {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/appstream_stack#connector_type AppstreamStack#connector_type}
    */
    readonly connectorType: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/appstream_stack#domains AppstreamStack#domains}
    */
    readonly domains?: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/appstream_stack#resource_identifier AppstreamStack#resource_identifier}
    */
    readonly resourceIdentifier?: string;
}
export declare function appstreamStackStorageConnectorsToTerraform(struct?: AppstreamStackStorageConnectors | cdktf.IResolvable): any;
export interface AppstreamStackUserSettings {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/appstream_stack#action AppstreamStack#action}
    */
    readonly action: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/appstream_stack#permission AppstreamStack#permission}
    */
    readonly permission: string;
}
export declare function appstreamStackUserSettingsToTerraform(struct?: AppstreamStackUserSettings | cdktf.IResolvable): any;
/**
* Represents a {@link https://www.terraform.io/docs/providers/aws/r/appstream_stack aws_appstream_stack}
*/
export declare class AppstreamStack extends cdktf.TerraformResource {
    static readonly tfResourceType = "aws_appstream_stack";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/aws/r/appstream_stack aws_appstream_stack} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options AppstreamStackConfig
    */
    constructor(scope: Construct, id: string, config: AppstreamStackConfig);
    get arn(): string;
    get createdTime(): string;
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _displayName?;
    get displayName(): string;
    set displayName(value: string);
    resetDisplayName(): void;
    get displayNameInput(): string | undefined;
    private _embedHostDomains?;
    get embedHostDomains(): string[];
    set embedHostDomains(value: string[]);
    resetEmbedHostDomains(): void;
    get embedHostDomainsInput(): string[] | undefined;
    private _feedbackUrl?;
    get feedbackUrl(): string;
    set feedbackUrl(value: string);
    resetFeedbackUrl(): void;
    get feedbackUrlInput(): string | undefined;
    get id(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _redirectUrl?;
    get redirectUrl(): string;
    set redirectUrl(value: string);
    resetRedirectUrl(): void;
    get redirectUrlInput(): string | undefined;
    private _tags?;
    get tags(): {
        [key: string]: string;
    };
    set tags(value: {
        [key: string]: string;
    });
    resetTags(): void;
    get tagsInput(): {
        [key: string]: string;
    } | undefined;
    private _tagsAll?;
    get tagsAll(): {
        [key: string]: string;
    };
    set tagsAll(value: {
        [key: string]: string;
    });
    resetTagsAll(): void;
    get tagsAllInput(): {
        [key: string]: string;
    } | undefined;
    private _accessEndpoints?;
    get accessEndpoints(): AppstreamStackAccessEndpoints[] | cdktf.IResolvable;
    set accessEndpoints(value: AppstreamStackAccessEndpoints[] | cdktf.IResolvable);
    resetAccessEndpoints(): void;
    get accessEndpointsInput(): cdktf.IResolvable | AppstreamStackAccessEndpoints[] | undefined;
    private _applicationSettings;
    get applicationSettings(): AppstreamStackApplicationSettingsOutputReference;
    putApplicationSettings(value: AppstreamStackApplicationSettings): void;
    resetApplicationSettings(): void;
    get applicationSettingsInput(): AppstreamStackApplicationSettings | undefined;
    private _storageConnectors?;
    get storageConnectors(): AppstreamStackStorageConnectors[] | cdktf.IResolvable;
    set storageConnectors(value: AppstreamStackStorageConnectors[] | cdktf.IResolvable);
    resetStorageConnectors(): void;
    get storageConnectorsInput(): cdktf.IResolvable | AppstreamStackStorageConnectors[] | undefined;
    private _userSettings?;
    get userSettings(): AppstreamStackUserSettings[] | cdktf.IResolvable;
    set userSettings(value: AppstreamStackUserSettings[] | cdktf.IResolvable);
    resetUserSettings(): void;
    get userSettingsInput(): cdktf.IResolvable | AppstreamStackUserSettings[] | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
//# sourceMappingURL=appstream-stack.d.ts.map