import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
* AWS Auto Scaling
*/
export interface AutoscalingAttachmentConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/autoscaling_attachment#alb_target_group_arn AutoscalingAttachment#alb_target_group_arn}
    */
    readonly albTargetGroupArn?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/autoscaling_attachment#autoscaling_group_name AutoscalingAttachment#autoscaling_group_name}
    */
    readonly autoscalingGroupName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/autoscaling_attachment#elb AutoscalingAttachment#elb}
    */
    readonly elb?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/autoscaling_attachment#lb_target_group_arn AutoscalingAttachment#lb_target_group_arn}
    */
    readonly lbTargetGroupArn?: string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/aws/r/autoscaling_attachment aws_autoscaling_attachment}
*/
export declare class AutoscalingAttachment extends cdktf.TerraformResource {
    static readonly tfResourceType = "aws_autoscaling_attachment";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/aws/r/autoscaling_attachment aws_autoscaling_attachment} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options AutoscalingAttachmentConfig
    */
    constructor(scope: Construct, id: string, config: AutoscalingAttachmentConfig);
    private _albTargetGroupArn?;
    get albTargetGroupArn(): string;
    set albTargetGroupArn(value: string);
    resetAlbTargetGroupArn(): void;
    get albTargetGroupArnInput(): string | undefined;
    private _autoscalingGroupName?;
    get autoscalingGroupName(): string;
    set autoscalingGroupName(value: string);
    get autoscalingGroupNameInput(): string | undefined;
    private _elb?;
    get elb(): string;
    set elb(value: string);
    resetElb(): void;
    get elbInput(): string | undefined;
    get id(): string;
    private _lbTargetGroupArn?;
    get lbTargetGroupArn(): string;
    set lbTargetGroupArn(value: string);
    resetLbTargetGroupArn(): void;
    get lbTargetGroupArnInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
//# sourceMappingURL=autoscaling-attachment.d.ts.map