import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
* AWS Auto Scaling
*/
export interface AutoscalingNotificationConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/autoscaling_notification#group_names AutoscalingNotification#group_names}
    */
    readonly groupNames: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/autoscaling_notification#notifications AutoscalingNotification#notifications}
    */
    readonly notifications: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/autoscaling_notification#topic_arn AutoscalingNotification#topic_arn}
    */
    readonly topicArn: string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/aws/r/autoscaling_notification aws_autoscaling_notification}
*/
export declare class AutoscalingNotification extends cdktf.TerraformResource {
    static readonly tfResourceType = "aws_autoscaling_notification";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/aws/r/autoscaling_notification aws_autoscaling_notification} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options AutoscalingNotificationConfig
    */
    constructor(scope: Construct, id: string, config: AutoscalingNotificationConfig);
    private _groupNames?;
    get groupNames(): string[];
    set groupNames(value: string[]);
    get groupNamesInput(): string[] | undefined;
    get id(): string;
    private _notifications?;
    get notifications(): string[];
    set notifications(value: string[]);
    get notificationsInput(): string[] | undefined;
    private _topicArn?;
    get topicArn(): string;
    set topicArn(value: string);
    get topicArnInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
//# sourceMappingURL=autoscaling-notification.d.ts.map