import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
* AWS Auto Scaling
*/
export interface DataAwsAutoscalingGroupConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/d/autoscaling_group#name DataAwsAutoscalingGroup#name}
    */
    readonly name: string;
}
export interface DataAwsAutoscalingGroupLaunchTemplate {
}
export declare function dataAwsAutoscalingGroupLaunchTemplateToTerraform(struct?: DataAwsAutoscalingGroupLaunchTemplate): any;
export declare class DataAwsAutoscalingGroupLaunchTemplateOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAwsAutoscalingGroupLaunchTemplate | undefined;
    set internalValue(value: DataAwsAutoscalingGroupLaunchTemplate | undefined);
    get id(): string;
    get name(): string;
    get version(): string;
}
export declare class DataAwsAutoscalingGroupLaunchTemplateList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAwsAutoscalingGroupLaunchTemplateOutputReference;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/aws/d/autoscaling_group aws_autoscaling_group}
*/
export declare class DataAwsAutoscalingGroup extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "aws_autoscaling_group";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/aws/d/autoscaling_group aws_autoscaling_group} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataAwsAutoscalingGroupConfig
    */
    constructor(scope: Construct, id: string, config: DataAwsAutoscalingGroupConfig);
    get arn(): string;
    get availabilityZones(): string[];
    get defaultCooldown(): number;
    get desiredCapacity(): number;
    get enabledMetrics(): string[];
    get healthCheckGracePeriod(): number;
    get healthCheckType(): string;
    get id(): string;
    get launchConfiguration(): string;
    private _launchTemplate;
    get launchTemplate(): DataAwsAutoscalingGroupLaunchTemplateList;
    get loadBalancers(): string[];
    get maxSize(): number;
    get minSize(): number;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    get newInstancesProtectedFromScaleIn(): cdktf.IResolvable;
    get placementGroup(): string;
    get serviceLinkedRoleArn(): string;
    get status(): string;
    get targetGroupArns(): string[];
    get terminationPolicies(): string[];
    get vpcZoneIdentifier(): string;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
//# sourceMappingURL=data-aws-autoscaling-group.d.ts.map