"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.AwsProvider = exports.awsProviderIgnoreTagsToTerraform = exports.awsProviderEndpointsToTerraform = exports.awsProviderDefaultTagsToTerraform = exports.awsProviderAssumeRoleWithWebIdentityToTerraform = exports.awsProviderAssumeRoleToTerraform = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cdktf = require("cdktf");
function awsProviderAssumeRoleToTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    return {
        duration: cdktf.stringToTerraform(struct.duration),
        duration_seconds: cdktf.numberToTerraform(struct.durationSeconds),
        external_id: cdktf.stringToTerraform(struct.externalId),
        policy: cdktf.stringToTerraform(struct.policy),
        policy_arns: cdktf.listMapper(cdktf.stringToTerraform)(struct.policyArns),
        role_arn: cdktf.stringToTerraform(struct.roleArn),
        session_name: cdktf.stringToTerraform(struct.sessionName),
        tags: cdktf.hashMapper(cdktf.stringToTerraform)(struct.tags),
        transitive_tag_keys: cdktf.listMapper(cdktf.stringToTerraform)(struct.transitiveTagKeys),
    };
}
exports.awsProviderAssumeRoleToTerraform = awsProviderAssumeRoleToTerraform;
function awsProviderAssumeRoleWithWebIdentityToTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    return {
        duration: cdktf.stringToTerraform(struct.duration),
        policy: cdktf.stringToTerraform(struct.policy),
        policy_arns: cdktf.listMapper(cdktf.stringToTerraform)(struct.policyArns),
        role_arn: cdktf.stringToTerraform(struct.roleArn),
        session_name: cdktf.stringToTerraform(struct.sessionName),
        web_identity_token: cdktf.stringToTerraform(struct.webIdentityToken),
        web_identity_token_file: cdktf.stringToTerraform(struct.webIdentityTokenFile),
    };
}
exports.awsProviderAssumeRoleWithWebIdentityToTerraform = awsProviderAssumeRoleWithWebIdentityToTerraform;
function awsProviderDefaultTagsToTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    return {
        tags: cdktf.hashMapper(cdktf.stringToTerraform)(struct.tags),
    };
}
exports.awsProviderDefaultTagsToTerraform = awsProviderDefaultTagsToTerraform;
function awsProviderEndpointsToTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    return {
        accessanalyzer: cdktf.stringToTerraform(struct.accessanalyzer),
        account: cdktf.stringToTerraform(struct.account),
        acm: cdktf.stringToTerraform(struct.acm),
        acmpca: cdktf.stringToTerraform(struct.acmpca),
        alexaforbusiness: cdktf.stringToTerraform(struct.alexaforbusiness),
        amg: cdktf.stringToTerraform(struct.amg),
        amp: cdktf.stringToTerraform(struct.amp),
        amplify: cdktf.stringToTerraform(struct.amplify),
        amplifybackend: cdktf.stringToTerraform(struct.amplifybackend),
        amplifyuibuilder: cdktf.stringToTerraform(struct.amplifyuibuilder),
        apigateway: cdktf.stringToTerraform(struct.apigateway),
        apigatewaymanagementapi: cdktf.stringToTerraform(struct.apigatewaymanagementapi),
        apigatewayv2: cdktf.stringToTerraform(struct.apigatewayv2),
        appautoscaling: cdktf.stringToTerraform(struct.appautoscaling),
        appconfig: cdktf.stringToTerraform(struct.appconfig),
        appconfigdata: cdktf.stringToTerraform(struct.appconfigdata),
        appflow: cdktf.stringToTerraform(struct.appflow),
        appintegrations: cdktf.stringToTerraform(struct.appintegrations),
        appintegrationsservice: cdktf.stringToTerraform(struct.appintegrationsservice),
        applicationautoscaling: cdktf.stringToTerraform(struct.applicationautoscaling),
        applicationcostprofiler: cdktf.stringToTerraform(struct.applicationcostprofiler),
        applicationdiscovery: cdktf.stringToTerraform(struct.applicationdiscovery),
        applicationdiscoveryservice: cdktf.stringToTerraform(struct.applicationdiscoveryservice),
        applicationinsights: cdktf.stringToTerraform(struct.applicationinsights),
        appmesh: cdktf.stringToTerraform(struct.appmesh),
        appregistry: cdktf.stringToTerraform(struct.appregistry),
        apprunner: cdktf.stringToTerraform(struct.apprunner),
        appstream: cdktf.stringToTerraform(struct.appstream),
        appsync: cdktf.stringToTerraform(struct.appsync),
        athena: cdktf.stringToTerraform(struct.athena),
        auditmanager: cdktf.stringToTerraform(struct.auditmanager),
        augmentedairuntime: cdktf.stringToTerraform(struct.augmentedairuntime),
        autoscaling: cdktf.stringToTerraform(struct.autoscaling),
        autoscalingplans: cdktf.stringToTerraform(struct.autoscalingplans),
        backup: cdktf.stringToTerraform(struct.backup),
        backupgateway: cdktf.stringToTerraform(struct.backupgateway),
        batch: cdktf.stringToTerraform(struct.batch),
        billingconductor: cdktf.stringToTerraform(struct.billingconductor),
        braket: cdktf.stringToTerraform(struct.braket),
        budgets: cdktf.stringToTerraform(struct.budgets),
        ce: cdktf.stringToTerraform(struct.ce),
        chime: cdktf.stringToTerraform(struct.chime),
        chimesdkidentity: cdktf.stringToTerraform(struct.chimesdkidentity),
        chimesdkmeetings: cdktf.stringToTerraform(struct.chimesdkmeetings),
        chimesdkmessaging: cdktf.stringToTerraform(struct.chimesdkmessaging),
        cloud9: cdktf.stringToTerraform(struct.cloud9),
        cloudcontrol: cdktf.stringToTerraform(struct.cloudcontrol),
        cloudcontrolapi: cdktf.stringToTerraform(struct.cloudcontrolapi),
        clouddirectory: cdktf.stringToTerraform(struct.clouddirectory),
        cloudformation: cdktf.stringToTerraform(struct.cloudformation),
        cloudfront: cdktf.stringToTerraform(struct.cloudfront),
        cloudhsm: cdktf.stringToTerraform(struct.cloudhsm),
        cloudhsmv2: cdktf.stringToTerraform(struct.cloudhsmv2),
        cloudsearch: cdktf.stringToTerraform(struct.cloudsearch),
        cloudsearchdomain: cdktf.stringToTerraform(struct.cloudsearchdomain),
        cloudtrail: cdktf.stringToTerraform(struct.cloudtrail),
        cloudwatch: cdktf.stringToTerraform(struct.cloudwatch),
        cloudwatchevents: cdktf.stringToTerraform(struct.cloudwatchevents),
        cloudwatchevidently: cdktf.stringToTerraform(struct.cloudwatchevidently),
        cloudwatchlogs: cdktf.stringToTerraform(struct.cloudwatchlogs),
        cloudwatchrum: cdktf.stringToTerraform(struct.cloudwatchrum),
        codeartifact: cdktf.stringToTerraform(struct.codeartifact),
        codebuild: cdktf.stringToTerraform(struct.codebuild),
        codecommit: cdktf.stringToTerraform(struct.codecommit),
        codedeploy: cdktf.stringToTerraform(struct.codedeploy),
        codeguruprofiler: cdktf.stringToTerraform(struct.codeguruprofiler),
        codegurureviewer: cdktf.stringToTerraform(struct.codegurureviewer),
        codepipeline: cdktf.stringToTerraform(struct.codepipeline),
        codestar: cdktf.stringToTerraform(struct.codestar),
        codestarconnections: cdktf.stringToTerraform(struct.codestarconnections),
        codestarnotifications: cdktf.stringToTerraform(struct.codestarnotifications),
        cognitoidentity: cdktf.stringToTerraform(struct.cognitoidentity),
        cognitoidentityprovider: cdktf.stringToTerraform(struct.cognitoidentityprovider),
        cognitoidp: cdktf.stringToTerraform(struct.cognitoidp),
        cognitosync: cdktf.stringToTerraform(struct.cognitosync),
        comprehend: cdktf.stringToTerraform(struct.comprehend),
        comprehendmedical: cdktf.stringToTerraform(struct.comprehendmedical),
        computeoptimizer: cdktf.stringToTerraform(struct.computeoptimizer),
        config: cdktf.stringToTerraform(struct.config),
        configservice: cdktf.stringToTerraform(struct.configservice),
        connect: cdktf.stringToTerraform(struct.connect),
        connectcontactlens: cdktf.stringToTerraform(struct.connectcontactlens),
        connectparticipant: cdktf.stringToTerraform(struct.connectparticipant),
        connectwisdomservice: cdktf.stringToTerraform(struct.connectwisdomservice),
        costandusagereportservice: cdktf.stringToTerraform(struct.costandusagereportservice),
        costexplorer: cdktf.stringToTerraform(struct.costexplorer),
        cur: cdktf.stringToTerraform(struct.cur),
        customerprofiles: cdktf.stringToTerraform(struct.customerprofiles),
        databasemigration: cdktf.stringToTerraform(struct.databasemigration),
        databasemigrationservice: cdktf.stringToTerraform(struct.databasemigrationservice),
        databrew: cdktf.stringToTerraform(struct.databrew),
        dataexchange: cdktf.stringToTerraform(struct.dataexchange),
        datapipeline: cdktf.stringToTerraform(struct.datapipeline),
        datasync: cdktf.stringToTerraform(struct.datasync),
        dax: cdktf.stringToTerraform(struct.dax),
        deploy: cdktf.stringToTerraform(struct.deploy),
        detective: cdktf.stringToTerraform(struct.detective),
        devicefarm: cdktf.stringToTerraform(struct.devicefarm),
        devopsguru: cdktf.stringToTerraform(struct.devopsguru),
        directconnect: cdktf.stringToTerraform(struct.directconnect),
        directoryservice: cdktf.stringToTerraform(struct.directoryservice),
        discovery: cdktf.stringToTerraform(struct.discovery),
        dlm: cdktf.stringToTerraform(struct.dlm),
        dms: cdktf.stringToTerraform(struct.dms),
        docdb: cdktf.stringToTerraform(struct.docdb),
        drs: cdktf.stringToTerraform(struct.drs),
        ds: cdktf.stringToTerraform(struct.ds),
        dynamodb: cdktf.stringToTerraform(struct.dynamodb),
        dynamodbstreams: cdktf.stringToTerraform(struct.dynamodbstreams),
        ebs: cdktf.stringToTerraform(struct.ebs),
        ec2: cdktf.stringToTerraform(struct.ec2),
        ec2instanceconnect: cdktf.stringToTerraform(struct.ec2Instanceconnect),
        ecr: cdktf.stringToTerraform(struct.ecr),
        ecrpublic: cdktf.stringToTerraform(struct.ecrpublic),
        ecs: cdktf.stringToTerraform(struct.ecs),
        efs: cdktf.stringToTerraform(struct.efs),
        eks: cdktf.stringToTerraform(struct.eks),
        elasticache: cdktf.stringToTerraform(struct.elasticache),
        elasticbeanstalk: cdktf.stringToTerraform(struct.elasticbeanstalk),
        elasticinference: cdktf.stringToTerraform(struct.elasticinference),
        elasticloadbalancing: cdktf.stringToTerraform(struct.elasticloadbalancing),
        elasticloadbalancingv2: cdktf.stringToTerraform(struct.elasticloadbalancingv2),
        elasticsearch: cdktf.stringToTerraform(struct.elasticsearch),
        elasticsearchservice: cdktf.stringToTerraform(struct.elasticsearchservice),
        elastictranscoder: cdktf.stringToTerraform(struct.elastictranscoder),
        elb: cdktf.stringToTerraform(struct.elb),
        elbv2: cdktf.stringToTerraform(struct.elbv2),
        emr: cdktf.stringToTerraform(struct.emr),
        emrcontainers: cdktf.stringToTerraform(struct.emrcontainers),
        es: cdktf.stringToTerraform(struct.es),
        eventbridge: cdktf.stringToTerraform(struct.eventbridge),
        events: cdktf.stringToTerraform(struct.events),
        evidently: cdktf.stringToTerraform(struct.evidently),
        finspace: cdktf.stringToTerraform(struct.finspace),
        finspacedata: cdktf.stringToTerraform(struct.finspacedata),
        firehose: cdktf.stringToTerraform(struct.firehose),
        fis: cdktf.stringToTerraform(struct.fis),
        fms: cdktf.stringToTerraform(struct.fms),
        forecast: cdktf.stringToTerraform(struct.forecast),
        forecastquery: cdktf.stringToTerraform(struct.forecastquery),
        forecastqueryservice: cdktf.stringToTerraform(struct.forecastqueryservice),
        forecastservice: cdktf.stringToTerraform(struct.forecastservice),
        frauddetector: cdktf.stringToTerraform(struct.frauddetector),
        fsx: cdktf.stringToTerraform(struct.fsx),
        gamelift: cdktf.stringToTerraform(struct.gamelift),
        glacier: cdktf.stringToTerraform(struct.glacier),
        globalaccelerator: cdktf.stringToTerraform(struct.globalaccelerator),
        glue: cdktf.stringToTerraform(struct.glue),
        gluedatabrew: cdktf.stringToTerraform(struct.gluedatabrew),
        grafana: cdktf.stringToTerraform(struct.grafana),
        greengrass: cdktf.stringToTerraform(struct.greengrass),
        greengrassv2: cdktf.stringToTerraform(struct.greengrassv2),
        groundstation: cdktf.stringToTerraform(struct.groundstation),
        guardduty: cdktf.stringToTerraform(struct.guardduty),
        health: cdktf.stringToTerraform(struct.health),
        healthlake: cdktf.stringToTerraform(struct.healthlake),
        honeycode: cdktf.stringToTerraform(struct.honeycode),
        iam: cdktf.stringToTerraform(struct.iam),
        identitystore: cdktf.stringToTerraform(struct.identitystore),
        imagebuilder: cdktf.stringToTerraform(struct.imagebuilder),
        inspector: cdktf.stringToTerraform(struct.inspector),
        inspector2: cdktf.stringToTerraform(struct.inspector2),
        iot: cdktf.stringToTerraform(struct.iot),
        iot1clickdevices: cdktf.stringToTerraform(struct.iot1Clickdevices),
        iot1clickdevicesservice: cdktf.stringToTerraform(struct.iot1Clickdevicesservice),
        iot1clickprojects: cdktf.stringToTerraform(struct.iot1Clickprojects),
        iotanalytics: cdktf.stringToTerraform(struct.iotanalytics),
        iotdata: cdktf.stringToTerraform(struct.iotdata),
        iotdataplane: cdktf.stringToTerraform(struct.iotdataplane),
        iotdeviceadvisor: cdktf.stringToTerraform(struct.iotdeviceadvisor),
        iotevents: cdktf.stringToTerraform(struct.iotevents),
        ioteventsdata: cdktf.stringToTerraform(struct.ioteventsdata),
        iotfleethub: cdktf.stringToTerraform(struct.iotfleethub),
        iotjobsdata: cdktf.stringToTerraform(struct.iotjobsdata),
        iotjobsdataplane: cdktf.stringToTerraform(struct.iotjobsdataplane),
        iotsecuretunneling: cdktf.stringToTerraform(struct.iotsecuretunneling),
        iotsitewise: cdktf.stringToTerraform(struct.iotsitewise),
        iotthingsgraph: cdktf.stringToTerraform(struct.iotthingsgraph),
        iottwinmaker: cdktf.stringToTerraform(struct.iottwinmaker),
        iotwireless: cdktf.stringToTerraform(struct.iotwireless),
        ivs: cdktf.stringToTerraform(struct.ivs),
        kafka: cdktf.stringToTerraform(struct.kafka),
        kafkaconnect: cdktf.stringToTerraform(struct.kafkaconnect),
        kendra: cdktf.stringToTerraform(struct.kendra),
        keyspaces: cdktf.stringToTerraform(struct.keyspaces),
        kinesis: cdktf.stringToTerraform(struct.kinesis),
        kinesisanalytics: cdktf.stringToTerraform(struct.kinesisanalytics),
        kinesisanalyticsv2: cdktf.stringToTerraform(struct.kinesisanalyticsv2),
        kinesisvideo: cdktf.stringToTerraform(struct.kinesisvideo),
        kinesisvideoarchivedmedia: cdktf.stringToTerraform(struct.kinesisvideoarchivedmedia),
        kinesisvideomedia: cdktf.stringToTerraform(struct.kinesisvideomedia),
        kinesisvideosignaling: cdktf.stringToTerraform(struct.kinesisvideosignaling),
        kinesisvideosignalingchannels: cdktf.stringToTerraform(struct.kinesisvideosignalingchannels),
        kms: cdktf.stringToTerraform(struct.kms),
        lakeformation: cdktf.stringToTerraform(struct.lakeformation),
        lambda: cdktf.stringToTerraform(struct.lambda),
        lexmodelbuilding: cdktf.stringToTerraform(struct.lexmodelbuilding),
        lexmodelbuildingservice: cdktf.stringToTerraform(struct.lexmodelbuildingservice),
        lexmodels: cdktf.stringToTerraform(struct.lexmodels),
        lexmodelsv2: cdktf.stringToTerraform(struct.lexmodelsv2),
        lexruntime: cdktf.stringToTerraform(struct.lexruntime),
        lexruntimeservice: cdktf.stringToTerraform(struct.lexruntimeservice),
        lexruntimev2: cdktf.stringToTerraform(struct.lexruntimev2),
        lexv2models: cdktf.stringToTerraform(struct.lexv2Models),
        lexv2runtime: cdktf.stringToTerraform(struct.lexv2Runtime),
        licensemanager: cdktf.stringToTerraform(struct.licensemanager),
        lightsail: cdktf.stringToTerraform(struct.lightsail),
        location: cdktf.stringToTerraform(struct.location),
        locationservice: cdktf.stringToTerraform(struct.locationservice),
        logs: cdktf.stringToTerraform(struct.logs),
        lookoutequipment: cdktf.stringToTerraform(struct.lookoutequipment),
        lookoutforvision: cdktf.stringToTerraform(struct.lookoutforvision),
        lookoutmetrics: cdktf.stringToTerraform(struct.lookoutmetrics),
        lookoutvision: cdktf.stringToTerraform(struct.lookoutvision),
        machinelearning: cdktf.stringToTerraform(struct.machinelearning),
        macie: cdktf.stringToTerraform(struct.macie),
        macie2: cdktf.stringToTerraform(struct.macie2),
        managedblockchain: cdktf.stringToTerraform(struct.managedblockchain),
        managedgrafana: cdktf.stringToTerraform(struct.managedgrafana),
        marketplacecatalog: cdktf.stringToTerraform(struct.marketplacecatalog),
        marketplacecommerceanalytics: cdktf.stringToTerraform(struct.marketplacecommerceanalytics),
        marketplaceentitlement: cdktf.stringToTerraform(struct.marketplaceentitlement),
        marketplaceentitlementservice: cdktf.stringToTerraform(struct.marketplaceentitlementservice),
        marketplacemetering: cdktf.stringToTerraform(struct.marketplacemetering),
        mediaconnect: cdktf.stringToTerraform(struct.mediaconnect),
        mediaconvert: cdktf.stringToTerraform(struct.mediaconvert),
        medialive: cdktf.stringToTerraform(struct.medialive),
        mediapackage: cdktf.stringToTerraform(struct.mediapackage),
        mediapackagevod: cdktf.stringToTerraform(struct.mediapackagevod),
        mediastore: cdktf.stringToTerraform(struct.mediastore),
        mediastoredata: cdktf.stringToTerraform(struct.mediastoredata),
        mediatailor: cdktf.stringToTerraform(struct.mediatailor),
        memorydb: cdktf.stringToTerraform(struct.memorydb),
        meteringmarketplace: cdktf.stringToTerraform(struct.meteringmarketplace),
        mgh: cdktf.stringToTerraform(struct.mgh),
        mgn: cdktf.stringToTerraform(struct.mgn),
        migrationhub: cdktf.stringToTerraform(struct.migrationhub),
        migrationhubconfig: cdktf.stringToTerraform(struct.migrationhubconfig),
        migrationhubrefactorspaces: cdktf.stringToTerraform(struct.migrationhubrefactorspaces),
        migrationhubstrategy: cdktf.stringToTerraform(struct.migrationhubstrategy),
        migrationhubstrategyrecommendations: cdktf.stringToTerraform(struct.migrationhubstrategyrecommendations),
        mobile: cdktf.stringToTerraform(struct.mobile),
        mq: cdktf.stringToTerraform(struct.mq),
        mturk: cdktf.stringToTerraform(struct.mturk),
        mwaa: cdktf.stringToTerraform(struct.mwaa),
        neptune: cdktf.stringToTerraform(struct.neptune),
        networkfirewall: cdktf.stringToTerraform(struct.networkfirewall),
        networkmanager: cdktf.stringToTerraform(struct.networkmanager),
        nimble: cdktf.stringToTerraform(struct.nimble),
        nimblestudio: cdktf.stringToTerraform(struct.nimblestudio),
        opensearch: cdktf.stringToTerraform(struct.opensearch),
        opensearchservice: cdktf.stringToTerraform(struct.opensearchservice),
        opsworks: cdktf.stringToTerraform(struct.opsworks),
        opsworkscm: cdktf.stringToTerraform(struct.opsworkscm),
        organizations: cdktf.stringToTerraform(struct.organizations),
        outposts: cdktf.stringToTerraform(struct.outposts),
        panorama: cdktf.stringToTerraform(struct.panorama),
        personalize: cdktf.stringToTerraform(struct.personalize),
        personalizeevents: cdktf.stringToTerraform(struct.personalizeevents),
        personalizeruntime: cdktf.stringToTerraform(struct.personalizeruntime),
        pi: cdktf.stringToTerraform(struct.pi),
        pinpoint: cdktf.stringToTerraform(struct.pinpoint),
        pinpointemail: cdktf.stringToTerraform(struct.pinpointemail),
        pinpointsmsvoice: cdktf.stringToTerraform(struct.pinpointsmsvoice),
        polly: cdktf.stringToTerraform(struct.polly),
        pricing: cdktf.stringToTerraform(struct.pricing),
        prometheus: cdktf.stringToTerraform(struct.prometheus),
        prometheusservice: cdktf.stringToTerraform(struct.prometheusservice),
        proton: cdktf.stringToTerraform(struct.proton),
        qldb: cdktf.stringToTerraform(struct.qldb),
        qldbsession: cdktf.stringToTerraform(struct.qldbsession),
        quicksight: cdktf.stringToTerraform(struct.quicksight),
        ram: cdktf.stringToTerraform(struct.ram),
        rbin: cdktf.stringToTerraform(struct.rbin),
        rds: cdktf.stringToTerraform(struct.rds),
        rdsdata: cdktf.stringToTerraform(struct.rdsdata),
        rdsdataservice: cdktf.stringToTerraform(struct.rdsdataservice),
        recyclebin: cdktf.stringToTerraform(struct.recyclebin),
        redshift: cdktf.stringToTerraform(struct.redshift),
        redshiftdata: cdktf.stringToTerraform(struct.redshiftdata),
        redshiftdataapiservice: cdktf.stringToTerraform(struct.redshiftdataapiservice),
        rekognition: cdktf.stringToTerraform(struct.rekognition),
        resiliencehub: cdktf.stringToTerraform(struct.resiliencehub),
        resourcegroups: cdktf.stringToTerraform(struct.resourcegroups),
        resourcegroupstagging: cdktf.stringToTerraform(struct.resourcegroupstagging),
        resourcegroupstaggingapi: cdktf.stringToTerraform(struct.resourcegroupstaggingapi),
        robomaker: cdktf.stringToTerraform(struct.robomaker),
        route53: cdktf.stringToTerraform(struct.route53),
        route53domains: cdktf.stringToTerraform(struct.route53Domains),
        route53recoverycluster: cdktf.stringToTerraform(struct.route53Recoverycluster),
        route53recoverycontrolconfig: cdktf.stringToTerraform(struct.route53Recoverycontrolconfig),
        route53recoveryreadiness: cdktf.stringToTerraform(struct.route53Recoveryreadiness),
        route53resolver: cdktf.stringToTerraform(struct.route53Resolver),
        rum: cdktf.stringToTerraform(struct.rum),
        s3: cdktf.stringToTerraform(struct.s3),
        s3api: cdktf.stringToTerraform(struct.s3Api),
        s3control: cdktf.stringToTerraform(struct.s3Control),
        s3outposts: cdktf.stringToTerraform(struct.s3Outposts),
        sagemaker: cdktf.stringToTerraform(struct.sagemaker),
        sagemakera2iruntime: cdktf.stringToTerraform(struct.sagemakera2Iruntime),
        sagemakeredge: cdktf.stringToTerraform(struct.sagemakeredge),
        sagemakeredgemanager: cdktf.stringToTerraform(struct.sagemakeredgemanager),
        sagemakerfeaturestoreruntime: cdktf.stringToTerraform(struct.sagemakerfeaturestoreruntime),
        sagemakerruntime: cdktf.stringToTerraform(struct.sagemakerruntime),
        savingsplans: cdktf.stringToTerraform(struct.savingsplans),
        schemas: cdktf.stringToTerraform(struct.schemas),
        sdb: cdktf.stringToTerraform(struct.sdb),
        secretsmanager: cdktf.stringToTerraform(struct.secretsmanager),
        securityhub: cdktf.stringToTerraform(struct.securityhub),
        serverlessapplicationrepository: cdktf.stringToTerraform(struct.serverlessapplicationrepository),
        serverlessapprepo: cdktf.stringToTerraform(struct.serverlessapprepo),
        serverlessrepo: cdktf.stringToTerraform(struct.serverlessrepo),
        servicecatalog: cdktf.stringToTerraform(struct.servicecatalog),
        servicecatalogappregistry: cdktf.stringToTerraform(struct.servicecatalogappregistry),
        servicediscovery: cdktf.stringToTerraform(struct.servicediscovery),
        servicequotas: cdktf.stringToTerraform(struct.servicequotas),
        ses: cdktf.stringToTerraform(struct.ses),
        sesv2: cdktf.stringToTerraform(struct.sesv2),
        sfn: cdktf.stringToTerraform(struct.sfn),
        shield: cdktf.stringToTerraform(struct.shield),
        signer: cdktf.stringToTerraform(struct.signer),
        simpledb: cdktf.stringToTerraform(struct.simpledb),
        sms: cdktf.stringToTerraform(struct.sms),
        snowball: cdktf.stringToTerraform(struct.snowball),
        snowdevicemanagement: cdktf.stringToTerraform(struct.snowdevicemanagement),
        sns: cdktf.stringToTerraform(struct.sns),
        sqs: cdktf.stringToTerraform(struct.sqs),
        ssm: cdktf.stringToTerraform(struct.ssm),
        ssmcontacts: cdktf.stringToTerraform(struct.ssmcontacts),
        ssmincidents: cdktf.stringToTerraform(struct.ssmincidents),
        sso: cdktf.stringToTerraform(struct.sso),
        ssoadmin: cdktf.stringToTerraform(struct.ssoadmin),
        ssooidc: cdktf.stringToTerraform(struct.ssooidc),
        stepfunctions: cdktf.stringToTerraform(struct.stepfunctions),
        storagegateway: cdktf.stringToTerraform(struct.storagegateway),
        sts: cdktf.stringToTerraform(struct.sts),
        support: cdktf.stringToTerraform(struct.support),
        swf: cdktf.stringToTerraform(struct.swf),
        synthetics: cdktf.stringToTerraform(struct.synthetics),
        textract: cdktf.stringToTerraform(struct.textract),
        timestreamquery: cdktf.stringToTerraform(struct.timestreamquery),
        timestreamwrite: cdktf.stringToTerraform(struct.timestreamwrite),
        transcribe: cdktf.stringToTerraform(struct.transcribe),
        transcribeservice: cdktf.stringToTerraform(struct.transcribeservice),
        transcribestreaming: cdktf.stringToTerraform(struct.transcribestreaming),
        transcribestreamingservice: cdktf.stringToTerraform(struct.transcribestreamingservice),
        transfer: cdktf.stringToTerraform(struct.transfer),
        translate: cdktf.stringToTerraform(struct.translate),
        voiceid: cdktf.stringToTerraform(struct.voiceid),
        waf: cdktf.stringToTerraform(struct.waf),
        wafregional: cdktf.stringToTerraform(struct.wafregional),
        wafv2: cdktf.stringToTerraform(struct.wafv2),
        wellarchitected: cdktf.stringToTerraform(struct.wellarchitected),
        wisdom: cdktf.stringToTerraform(struct.wisdom),
        workdocs: cdktf.stringToTerraform(struct.workdocs),
        worklink: cdktf.stringToTerraform(struct.worklink),
        workmail: cdktf.stringToTerraform(struct.workmail),
        workmailmessageflow: cdktf.stringToTerraform(struct.workmailmessageflow),
        workspaces: cdktf.stringToTerraform(struct.workspaces),
        workspacesweb: cdktf.stringToTerraform(struct.workspacesweb),
        xray: cdktf.stringToTerraform(struct.xray),
    };
}
exports.awsProviderEndpointsToTerraform = awsProviderEndpointsToTerraform;
function awsProviderIgnoreTagsToTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    return {
        key_prefixes: cdktf.listMapper(cdktf.stringToTerraform)(struct.keyPrefixes),
        keys: cdktf.listMapper(cdktf.stringToTerraform)(struct.keys),
    };
}
exports.awsProviderIgnoreTagsToTerraform = awsProviderIgnoreTagsToTerraform;
/**
* Represents a {@link https://www.terraform.io/docs/providers/aws aws}
*/
class AwsProvider extends cdktf.TerraformProvider {
    // ===========
    // INITIALIZER
    // ===========
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/aws aws} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options AwsProviderConfig = {}
    */
    constructor(scope, id, config = {}) {
        super(scope, id, {
            terraformResourceType: 'aws',
            terraformGeneratorMetadata: {
                providerName: 'aws',
                providerVersion: '4.15.1',
                providerVersionConstraint: '~> 4.0'
            },
            terraformProviderSource: 'aws'
        });
        this._accessKey = config.accessKey;
        this._allowedAccountIds = config.allowedAccountIds;
        this._customCaBundle = config.customCaBundle;
        this._ec2MetadataServiceEndpoint = config.ec2MetadataServiceEndpoint;
        this._ec2MetadataServiceEndpointMode = config.ec2MetadataServiceEndpointMode;
        this._forbiddenAccountIds = config.forbiddenAccountIds;
        this._httpProxy = config.httpProxy;
        this._insecure = config.insecure;
        this._maxRetries = config.maxRetries;
        this._profile = config.profile;
        this._region = config.region;
        this._s3ForcePathStyle = config.s3ForcePathStyle;
        this._s3UsePathStyle = config.s3UsePathStyle;
        this._secretKey = config.secretKey;
        this._sharedConfigFiles = config.sharedConfigFiles;
        this._sharedCredentialsFile = config.sharedCredentialsFile;
        this._sharedCredentialsFiles = config.sharedCredentialsFiles;
        this._skipCredentialsValidation = config.skipCredentialsValidation;
        this._skipGetEc2Platforms = config.skipGetEc2Platforms;
        this._skipMetadataApiCheck = config.skipMetadataApiCheck;
        this._skipRegionValidation = config.skipRegionValidation;
        this._skipRequestingAccountId = config.skipRequestingAccountId;
        this._stsRegion = config.stsRegion;
        this._token = config.token;
        this._useDualstackEndpoint = config.useDualstackEndpoint;
        this._useFipsEndpoint = config.useFipsEndpoint;
        this._alias = config.alias;
        this._assumeRole = config.assumeRole;
        this._assumeRoleWithWebIdentity = config.assumeRoleWithWebIdentity;
        this._defaultTags = config.defaultTags;
        this._endpoints = config.endpoints;
        this._ignoreTags = config.ignoreTags;
    }
    get accessKey() {
        return this._accessKey;
    }
    set accessKey(value) {
        this._accessKey = value;
    }
    resetAccessKey() {
        this._accessKey = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get accessKeyInput() {
        return this._accessKey;
    }
    get allowedAccountIds() {
        return this._allowedAccountIds;
    }
    set allowedAccountIds(value) {
        this._allowedAccountIds = value;
    }
    resetAllowedAccountIds() {
        this._allowedAccountIds = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get allowedAccountIdsInput() {
        return this._allowedAccountIds;
    }
    get customCaBundle() {
        return this._customCaBundle;
    }
    set customCaBundle(value) {
        this._customCaBundle = value;
    }
    resetCustomCaBundle() {
        this._customCaBundle = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get customCaBundleInput() {
        return this._customCaBundle;
    }
    get ec2MetadataServiceEndpoint() {
        return this._ec2MetadataServiceEndpoint;
    }
    set ec2MetadataServiceEndpoint(value) {
        this._ec2MetadataServiceEndpoint = value;
    }
    resetEc2MetadataServiceEndpoint() {
        this._ec2MetadataServiceEndpoint = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get ec2MetadataServiceEndpointInput() {
        return this._ec2MetadataServiceEndpoint;
    }
    get ec2MetadataServiceEndpointMode() {
        return this._ec2MetadataServiceEndpointMode;
    }
    set ec2MetadataServiceEndpointMode(value) {
        this._ec2MetadataServiceEndpointMode = value;
    }
    resetEc2MetadataServiceEndpointMode() {
        this._ec2MetadataServiceEndpointMode = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get ec2MetadataServiceEndpointModeInput() {
        return this._ec2MetadataServiceEndpointMode;
    }
    get forbiddenAccountIds() {
        return this._forbiddenAccountIds;
    }
    set forbiddenAccountIds(value) {
        this._forbiddenAccountIds = value;
    }
    resetForbiddenAccountIds() {
        this._forbiddenAccountIds = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get forbiddenAccountIdsInput() {
        return this._forbiddenAccountIds;
    }
    get httpProxy() {
        return this._httpProxy;
    }
    set httpProxy(value) {
        this._httpProxy = value;
    }
    resetHttpProxy() {
        this._httpProxy = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get httpProxyInput() {
        return this._httpProxy;
    }
    get insecure() {
        return this._insecure;
    }
    set insecure(value) {
        this._insecure = value;
    }
    resetInsecure() {
        this._insecure = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get insecureInput() {
        return this._insecure;
    }
    get maxRetries() {
        return this._maxRetries;
    }
    set maxRetries(value) {
        this._maxRetries = value;
    }
    resetMaxRetries() {
        this._maxRetries = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get maxRetriesInput() {
        return this._maxRetries;
    }
    get profile() {
        return this._profile;
    }
    set profile(value) {
        this._profile = value;
    }
    resetProfile() {
        this._profile = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get profileInput() {
        return this._profile;
    }
    get region() {
        return this._region;
    }
    set region(value) {
        this._region = value;
    }
    resetRegion() {
        this._region = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get regionInput() {
        return this._region;
    }
    get s3ForcePathStyle() {
        return this._s3ForcePathStyle;
    }
    set s3ForcePathStyle(value) {
        this._s3ForcePathStyle = value;
    }
    resetS3ForcePathStyle() {
        this._s3ForcePathStyle = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get s3ForcePathStyleInput() {
        return this._s3ForcePathStyle;
    }
    get s3UsePathStyle() {
        return this._s3UsePathStyle;
    }
    set s3UsePathStyle(value) {
        this._s3UsePathStyle = value;
    }
    resetS3UsePathStyle() {
        this._s3UsePathStyle = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get s3UsePathStyleInput() {
        return this._s3UsePathStyle;
    }
    get secretKey() {
        return this._secretKey;
    }
    set secretKey(value) {
        this._secretKey = value;
    }
    resetSecretKey() {
        this._secretKey = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get secretKeyInput() {
        return this._secretKey;
    }
    get sharedConfigFiles() {
        return this._sharedConfigFiles;
    }
    set sharedConfigFiles(value) {
        this._sharedConfigFiles = value;
    }
    resetSharedConfigFiles() {
        this._sharedConfigFiles = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get sharedConfigFilesInput() {
        return this._sharedConfigFiles;
    }
    get sharedCredentialsFile() {
        return this._sharedCredentialsFile;
    }
    set sharedCredentialsFile(value) {
        this._sharedCredentialsFile = value;
    }
    resetSharedCredentialsFile() {
        this._sharedCredentialsFile = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get sharedCredentialsFileInput() {
        return this._sharedCredentialsFile;
    }
    get sharedCredentialsFiles() {
        return this._sharedCredentialsFiles;
    }
    set sharedCredentialsFiles(value) {
        this._sharedCredentialsFiles = value;
    }
    resetSharedCredentialsFiles() {
        this._sharedCredentialsFiles = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get sharedCredentialsFilesInput() {
        return this._sharedCredentialsFiles;
    }
    get skipCredentialsValidation() {
        return this._skipCredentialsValidation;
    }
    set skipCredentialsValidation(value) {
        this._skipCredentialsValidation = value;
    }
    resetSkipCredentialsValidation() {
        this._skipCredentialsValidation = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get skipCredentialsValidationInput() {
        return this._skipCredentialsValidation;
    }
    get skipGetEc2Platforms() {
        return this._skipGetEc2Platforms;
    }
    set skipGetEc2Platforms(value) {
        this._skipGetEc2Platforms = value;
    }
    resetSkipGetEc2Platforms() {
        this._skipGetEc2Platforms = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get skipGetEc2PlatformsInput() {
        return this._skipGetEc2Platforms;
    }
    get skipMetadataApiCheck() {
        return this._skipMetadataApiCheck;
    }
    set skipMetadataApiCheck(value) {
        this._skipMetadataApiCheck = value;
    }
    resetSkipMetadataApiCheck() {
        this._skipMetadataApiCheck = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get skipMetadataApiCheckInput() {
        return this._skipMetadataApiCheck;
    }
    get skipRegionValidation() {
        return this._skipRegionValidation;
    }
    set skipRegionValidation(value) {
        this._skipRegionValidation = value;
    }
    resetSkipRegionValidation() {
        this._skipRegionValidation = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get skipRegionValidationInput() {
        return this._skipRegionValidation;
    }
    get skipRequestingAccountId() {
        return this._skipRequestingAccountId;
    }
    set skipRequestingAccountId(value) {
        this._skipRequestingAccountId = value;
    }
    resetSkipRequestingAccountId() {
        this._skipRequestingAccountId = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get skipRequestingAccountIdInput() {
        return this._skipRequestingAccountId;
    }
    get stsRegion() {
        return this._stsRegion;
    }
    set stsRegion(value) {
        this._stsRegion = value;
    }
    resetStsRegion() {
        this._stsRegion = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get stsRegionInput() {
        return this._stsRegion;
    }
    get token() {
        return this._token;
    }
    set token(value) {
        this._token = value;
    }
    resetToken() {
        this._token = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get tokenInput() {
        return this._token;
    }
    get useDualstackEndpoint() {
        return this._useDualstackEndpoint;
    }
    set useDualstackEndpoint(value) {
        this._useDualstackEndpoint = value;
    }
    resetUseDualstackEndpoint() {
        this._useDualstackEndpoint = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get useDualstackEndpointInput() {
        return this._useDualstackEndpoint;
    }
    get useFipsEndpoint() {
        return this._useFipsEndpoint;
    }
    set useFipsEndpoint(value) {
        this._useFipsEndpoint = value;
    }
    resetUseFipsEndpoint() {
        this._useFipsEndpoint = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get useFipsEndpointInput() {
        return this._useFipsEndpoint;
    }
    get alias() {
        return this._alias;
    }
    set alias(value) {
        this._alias = value;
    }
    resetAlias() {
        this._alias = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get aliasInput() {
        return this._alias;
    }
    get assumeRole() {
        return this._assumeRole;
    }
    set assumeRole(value) {
        this._assumeRole = value;
    }
    resetAssumeRole() {
        this._assumeRole = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get assumeRoleInput() {
        return this._assumeRole;
    }
    get assumeRoleWithWebIdentity() {
        return this._assumeRoleWithWebIdentity;
    }
    set assumeRoleWithWebIdentity(value) {
        this._assumeRoleWithWebIdentity = value;
    }
    resetAssumeRoleWithWebIdentity() {
        this._assumeRoleWithWebIdentity = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get assumeRoleWithWebIdentityInput() {
        return this._assumeRoleWithWebIdentity;
    }
    get defaultTags() {
        return this._defaultTags;
    }
    set defaultTags(value) {
        this._defaultTags = value;
    }
    resetDefaultTags() {
        this._defaultTags = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get defaultTagsInput() {
        return this._defaultTags;
    }
    get endpoints() {
        return this._endpoints;
    }
    set endpoints(value) {
        this._endpoints = value;
    }
    resetEndpoints() {
        this._endpoints = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get endpointsInput() {
        return this._endpoints;
    }
    get ignoreTags() {
        return this._ignoreTags;
    }
    set ignoreTags(value) {
        this._ignoreTags = value;
    }
    resetIgnoreTags() {
        this._ignoreTags = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get ignoreTagsInput() {
        return this._ignoreTags;
    }
    // =========
    // SYNTHESIS
    // =========
    synthesizeAttributes() {
        return {
            access_key: cdktf.stringToTerraform(this._accessKey),
            allowed_account_ids: cdktf.listMapper(cdktf.stringToTerraform)(this._allowedAccountIds),
            custom_ca_bundle: cdktf.stringToTerraform(this._customCaBundle),
            ec2_metadata_service_endpoint: cdktf.stringToTerraform(this._ec2MetadataServiceEndpoint),
            ec2_metadata_service_endpoint_mode: cdktf.stringToTerraform(this._ec2MetadataServiceEndpointMode),
            forbidden_account_ids: cdktf.listMapper(cdktf.stringToTerraform)(this._forbiddenAccountIds),
            http_proxy: cdktf.stringToTerraform(this._httpProxy),
            insecure: cdktf.booleanToTerraform(this._insecure),
            max_retries: cdktf.numberToTerraform(this._maxRetries),
            profile: cdktf.stringToTerraform(this._profile),
            region: cdktf.stringToTerraform(this._region),
            s3_force_path_style: cdktf.booleanToTerraform(this._s3ForcePathStyle),
            s3_use_path_style: cdktf.booleanToTerraform(this._s3UsePathStyle),
            secret_key: cdktf.stringToTerraform(this._secretKey),
            shared_config_files: cdktf.listMapper(cdktf.stringToTerraform)(this._sharedConfigFiles),
            shared_credentials_file: cdktf.stringToTerraform(this._sharedCredentialsFile),
            shared_credentials_files: cdktf.listMapper(cdktf.stringToTerraform)(this._sharedCredentialsFiles),
            skip_credentials_validation: cdktf.booleanToTerraform(this._skipCredentialsValidation),
            skip_get_ec2_platforms: cdktf.booleanToTerraform(this._skipGetEc2Platforms),
            skip_metadata_api_check: cdktf.stringToTerraform(this._skipMetadataApiCheck),
            skip_region_validation: cdktf.booleanToTerraform(this._skipRegionValidation),
            skip_requesting_account_id: cdktf.booleanToTerraform(this._skipRequestingAccountId),
            sts_region: cdktf.stringToTerraform(this._stsRegion),
            token: cdktf.stringToTerraform(this._token),
            use_dualstack_endpoint: cdktf.booleanToTerraform(this._useDualstackEndpoint),
            use_fips_endpoint: cdktf.booleanToTerraform(this._useFipsEndpoint),
            alias: cdktf.stringToTerraform(this._alias),
            assume_role: awsProviderAssumeRoleToTerraform(this._assumeRole),
            assume_role_with_web_identity: awsProviderAssumeRoleWithWebIdentityToTerraform(this._assumeRoleWithWebIdentity),
            default_tags: awsProviderDefaultTagsToTerraform(this._defaultTags),
            endpoints: cdktf.listMapper(awsProviderEndpointsToTerraform)(this._endpoints),
            ignore_tags: awsProviderIgnoreTagsToTerraform(this._ignoreTags),
        };
    }
}
exports.AwsProvider = AwsProvider;
_a = JSII_RTTI_SYMBOL_1;
AwsProvider[_a] = { fqn: "@cdktf/provider-aws.AwsProvider", version: "7.0.64" };
// =================
// STATIC PROPERTIES
// =================
AwsProvider.tfResourceType = "aws";
//# sourceMappingURL=data:application/json;base64,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