import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
* AWS Backup
*/
export interface BackupFrameworkConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/backup_framework#description BackupFramework#description}
    */
    readonly description?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/backup_framework#name BackupFramework#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/backup_framework#tags BackupFramework#tags}
    */
    readonly tags?: {
        [key: string]: string;
    };
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/backup_framework#tags_all BackupFramework#tags_all}
    */
    readonly tagsAll?: {
        [key: string]: string;
    };
    /**
    * control block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/backup_framework#control BackupFramework#control}
    */
    readonly control: BackupFrameworkControl[] | cdktf.IResolvable;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/backup_framework#timeouts BackupFramework#timeouts}
    */
    readonly timeouts?: BackupFrameworkTimeouts;
}
export interface BackupFrameworkControlInputParameter {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/backup_framework#name BackupFramework#name}
    */
    readonly name?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/backup_framework#value BackupFramework#value}
    */
    readonly value?: string;
}
export declare function backupFrameworkControlInputParameterToTerraform(struct?: BackupFrameworkControlInputParameter | cdktf.IResolvable): any;
export interface BackupFrameworkControlScope {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/backup_framework#compliance_resource_ids BackupFramework#compliance_resource_ids}
    */
    readonly complianceResourceIds?: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/backup_framework#compliance_resource_types BackupFramework#compliance_resource_types}
    */
    readonly complianceResourceTypes?: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/backup_framework#tags BackupFramework#tags}
    */
    readonly tags?: {
        [key: string]: string;
    };
}
export declare function backupFrameworkControlScopeToTerraform(struct?: BackupFrameworkControlScopeOutputReference | BackupFrameworkControlScope): any;
export declare class BackupFrameworkControlScopeOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): BackupFrameworkControlScope | undefined;
    set internalValue(value: BackupFrameworkControlScope | undefined);
    private _complianceResourceIds?;
    get complianceResourceIds(): string[];
    set complianceResourceIds(value: string[]);
    resetComplianceResourceIds(): void;
    get complianceResourceIdsInput(): string[] | undefined;
    private _complianceResourceTypes?;
    get complianceResourceTypes(): string[];
    set complianceResourceTypes(value: string[]);
    resetComplianceResourceTypes(): void;
    get complianceResourceTypesInput(): string[] | undefined;
    private _tags?;
    get tags(): {
        [key: string]: string;
    };
    set tags(value: {
        [key: string]: string;
    });
    resetTags(): void;
    get tagsInput(): {
        [key: string]: string;
    } | undefined;
}
export interface BackupFrameworkControl {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/backup_framework#name BackupFramework#name}
    */
    readonly name: string;
    /**
    * input_parameter block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/backup_framework#input_parameter BackupFramework#input_parameter}
    */
    readonly inputParameter?: BackupFrameworkControlInputParameter[] | cdktf.IResolvable;
    /**
    * scope block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/backup_framework#scope BackupFramework#scope}
    */
    readonly scope?: BackupFrameworkControlScope;
}
export declare function backupFrameworkControlToTerraform(struct?: BackupFrameworkControl | cdktf.IResolvable): any;
export interface BackupFrameworkTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/backup_framework#create BackupFramework#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/backup_framework#delete BackupFramework#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/backup_framework#update BackupFramework#update}
    */
    readonly update?: string;
}
export declare function backupFrameworkTimeoutsToTerraform(struct?: BackupFrameworkTimeoutsOutputReference | BackupFrameworkTimeouts | cdktf.IResolvable): any;
export declare class BackupFrameworkTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): BackupFrameworkTimeouts | undefined;
    set internalValue(value: BackupFrameworkTimeouts | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/aws/r/backup_framework aws_backup_framework}
*/
export declare class BackupFramework extends cdktf.TerraformResource {
    static readonly tfResourceType = "aws_backup_framework";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/aws/r/backup_framework aws_backup_framework} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options BackupFrameworkConfig
    */
    constructor(scope: Construct, id: string, config: BackupFrameworkConfig);
    get arn(): string;
    get creationTime(): string;
    get deploymentStatus(): string;
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    get id(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    get status(): string;
    private _tags?;
    get tags(): {
        [key: string]: string;
    };
    set tags(value: {
        [key: string]: string;
    });
    resetTags(): void;
    get tagsInput(): {
        [key: string]: string;
    } | undefined;
    private _tagsAll?;
    get tagsAll(): {
        [key: string]: string;
    };
    set tagsAll(value: {
        [key: string]: string;
    });
    resetTagsAll(): void;
    get tagsAllInput(): {
        [key: string]: string;
    } | undefined;
    private _control?;
    get control(): BackupFrameworkControl[] | cdktf.IResolvable;
    set control(value: BackupFrameworkControl[] | cdktf.IResolvable);
    get controlInput(): cdktf.IResolvable | BackupFrameworkControl[] | undefined;
    private _timeouts;
    get timeouts(): BackupFrameworkTimeoutsOutputReference;
    putTimeouts(value: BackupFrameworkTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): BackupFrameworkTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
//# sourceMappingURL=backup-framework.d.ts.map