import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
* AWS Backup
*/
export interface BackupPlanConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/backup_plan#name BackupPlan#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/backup_plan#tags BackupPlan#tags}
    */
    readonly tags?: {
        [key: string]: string;
    };
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/backup_plan#tags_all BackupPlan#tags_all}
    */
    readonly tagsAll?: {
        [key: string]: string;
    };
    /**
    * advanced_backup_setting block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/backup_plan#advanced_backup_setting BackupPlan#advanced_backup_setting}
    */
    readonly advancedBackupSetting?: BackupPlanAdvancedBackupSetting[] | cdktf.IResolvable;
    /**
    * rule block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/backup_plan#rule BackupPlan#rule}
    */
    readonly rule: BackupPlanRule[] | cdktf.IResolvable;
}
export interface BackupPlanAdvancedBackupSetting {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/backup_plan#backup_options BackupPlan#backup_options}
    */
    readonly backupOptions: {
        [key: string]: string;
    };
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/backup_plan#resource_type BackupPlan#resource_type}
    */
    readonly resourceType: string;
}
export declare function backupPlanAdvancedBackupSettingToTerraform(struct?: BackupPlanAdvancedBackupSetting | cdktf.IResolvable): any;
export interface BackupPlanRuleCopyActionLifecycle {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/backup_plan#cold_storage_after BackupPlan#cold_storage_after}
    */
    readonly coldStorageAfter?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/backup_plan#delete_after BackupPlan#delete_after}
    */
    readonly deleteAfter?: number;
}
export declare function backupPlanRuleCopyActionLifecycleToTerraform(struct?: BackupPlanRuleCopyActionLifecycleOutputReference | BackupPlanRuleCopyActionLifecycle): any;
export declare class BackupPlanRuleCopyActionLifecycleOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): BackupPlanRuleCopyActionLifecycle | undefined;
    set internalValue(value: BackupPlanRuleCopyActionLifecycle | undefined);
    private _coldStorageAfter?;
    get coldStorageAfter(): number;
    set coldStorageAfter(value: number);
    resetColdStorageAfter(): void;
    get coldStorageAfterInput(): number | undefined;
    private _deleteAfter?;
    get deleteAfter(): number;
    set deleteAfter(value: number);
    resetDeleteAfter(): void;
    get deleteAfterInput(): number | undefined;
}
export interface BackupPlanRuleCopyAction {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/backup_plan#destination_vault_arn BackupPlan#destination_vault_arn}
    */
    readonly destinationVaultArn: string;
    /**
    * lifecycle block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/backup_plan#lifecycle BackupPlan#lifecycle}
    */
    readonly lifecycle?: BackupPlanRuleCopyActionLifecycle;
}
export declare function backupPlanRuleCopyActionToTerraform(struct?: BackupPlanRuleCopyAction | cdktf.IResolvable): any;
export interface BackupPlanRuleLifecycle {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/backup_plan#cold_storage_after BackupPlan#cold_storage_after}
    */
    readonly coldStorageAfter?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/backup_plan#delete_after BackupPlan#delete_after}
    */
    readonly deleteAfter?: number;
}
export declare function backupPlanRuleLifecycleToTerraform(struct?: BackupPlanRuleLifecycleOutputReference | BackupPlanRuleLifecycle): any;
export declare class BackupPlanRuleLifecycleOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): BackupPlanRuleLifecycle | undefined;
    set internalValue(value: BackupPlanRuleLifecycle | undefined);
    private _coldStorageAfter?;
    get coldStorageAfter(): number;
    set coldStorageAfter(value: number);
    resetColdStorageAfter(): void;
    get coldStorageAfterInput(): number | undefined;
    private _deleteAfter?;
    get deleteAfter(): number;
    set deleteAfter(value: number);
    resetDeleteAfter(): void;
    get deleteAfterInput(): number | undefined;
}
export interface BackupPlanRule {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/backup_plan#completion_window BackupPlan#completion_window}
    */
    readonly completionWindow?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/backup_plan#enable_continuous_backup BackupPlan#enable_continuous_backup}
    */
    readonly enableContinuousBackup?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/backup_plan#recovery_point_tags BackupPlan#recovery_point_tags}
    */
    readonly recoveryPointTags?: {
        [key: string]: string;
    };
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/backup_plan#rule_name BackupPlan#rule_name}
    */
    readonly ruleName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/backup_plan#schedule BackupPlan#schedule}
    */
    readonly schedule?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/backup_plan#start_window BackupPlan#start_window}
    */
    readonly startWindow?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/backup_plan#target_vault_name BackupPlan#target_vault_name}
    */
    readonly targetVaultName: string;
    /**
    * copy_action block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/backup_plan#copy_action BackupPlan#copy_action}
    */
    readonly copyAction?: BackupPlanRuleCopyAction[] | cdktf.IResolvable;
    /**
    * lifecycle block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/backup_plan#lifecycle BackupPlan#lifecycle}
    */
    readonly lifecycle?: BackupPlanRuleLifecycle;
}
export declare function backupPlanRuleToTerraform(struct?: BackupPlanRule | cdktf.IResolvable): any;
/**
* Represents a {@link https://www.terraform.io/docs/providers/aws/r/backup_plan aws_backup_plan}
*/
export declare class BackupPlan extends cdktf.TerraformResource {
    static readonly tfResourceType = "aws_backup_plan";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/aws/r/backup_plan aws_backup_plan} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options BackupPlanConfig
    */
    constructor(scope: Construct, id: string, config: BackupPlanConfig);
    get arn(): string;
    get id(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _tags?;
    get tags(): {
        [key: string]: string;
    };
    set tags(value: {
        [key: string]: string;
    });
    resetTags(): void;
    get tagsInput(): {
        [key: string]: string;
    } | undefined;
    private _tagsAll?;
    get tagsAll(): {
        [key: string]: string;
    };
    set tagsAll(value: {
        [key: string]: string;
    });
    resetTagsAll(): void;
    get tagsAllInput(): {
        [key: string]: string;
    } | undefined;
    get version(): string;
    private _advancedBackupSetting?;
    get advancedBackupSetting(): BackupPlanAdvancedBackupSetting[] | cdktf.IResolvable;
    set advancedBackupSetting(value: BackupPlanAdvancedBackupSetting[] | cdktf.IResolvable);
    resetAdvancedBackupSetting(): void;
    get advancedBackupSettingInput(): cdktf.IResolvable | BackupPlanAdvancedBackupSetting[] | undefined;
    private _rule?;
    get rule(): BackupPlanRule[] | cdktf.IResolvable;
    set rule(value: BackupPlanRule[] | cdktf.IResolvable);
    get ruleInput(): cdktf.IResolvable | BackupPlanRule[] | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
//# sourceMappingURL=backup-plan.d.ts.map