"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.BackupRegionSettings = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cdktf = require("cdktf");
/**
* Represents a {@link https://www.terraform.io/docs/providers/aws/r/backup_region_settings aws_backup_region_settings}
*/
class BackupRegionSettings extends cdktf.TerraformResource {
    // ===========
    // INITIALIZER
    // ===========
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/aws/r/backup_region_settings aws_backup_region_settings} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options BackupRegionSettingsConfig
    */
    constructor(scope, id, config) {
        super(scope, id, {
            terraformResourceType: 'aws_backup_region_settings',
            terraformGeneratorMetadata: {
                providerName: 'aws',
                providerVersion: '4.15.1',
                providerVersionConstraint: '~> 4.0'
            },
            provider: config.provider,
            dependsOn: config.dependsOn,
            count: config.count,
            lifecycle: config.lifecycle
        });
        this._resourceTypeManagementPreference = config.resourceTypeManagementPreference;
        this._resourceTypeOptInPreference = config.resourceTypeOptInPreference;
    }
    // ==========
    // ATTRIBUTES
    // ==========
    // id - computed: true, optional: true, required: false
    get id() {
        return this.getStringAttribute('id');
    }
    get resourceTypeManagementPreference() {
        return this.getBooleanMapAttribute('resource_type_management_preference');
    }
    set resourceTypeManagementPreference(value) {
        this._resourceTypeManagementPreference = value;
    }
    resetResourceTypeManagementPreference() {
        this._resourceTypeManagementPreference = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get resourceTypeManagementPreferenceInput() {
        return this._resourceTypeManagementPreference;
    }
    get resourceTypeOptInPreference() {
        return this.getBooleanMapAttribute('resource_type_opt_in_preference');
    }
    set resourceTypeOptInPreference(value) {
        this._resourceTypeOptInPreference = value;
    }
    // Temporarily expose input value. Use with caution.
    get resourceTypeOptInPreferenceInput() {
        return this._resourceTypeOptInPreference;
    }
    // =========
    // SYNTHESIS
    // =========
    synthesizeAttributes() {
        return {
            resource_type_management_preference: cdktf.hashMapper(cdktf.booleanToTerraform)(this._resourceTypeManagementPreference),
            resource_type_opt_in_preference: cdktf.hashMapper(cdktf.booleanToTerraform)(this._resourceTypeOptInPreference),
        };
    }
}
exports.BackupRegionSettings = BackupRegionSettings;
_a = JSII_RTTI_SYMBOL_1;
BackupRegionSettings[_a] = { fqn: "@cdktf/provider-aws.backup.BackupRegionSettings", version: "7.0.64" };
// =================
// STATIC PROPERTIES
// =================
BackupRegionSettings.tfResourceType = "aws_backup_region_settings";
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiYmFja3VwLXJlZ2lvbi1zZXR0aW5ncy5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbIi4uLy4uL3NyYy9iYWNrdXAvYmFja3VwLXJlZ2lvbi1zZXR0aW5ncy50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiOzs7OztBQUdBLCtCQUErQjtBQWdCL0I7O0VBRUU7QUFDRixNQUFhLG9CQUFxQixTQUFRLEtBQUssQ0FBQyxpQkFBaUI7SUFPL0QsY0FBYztJQUNkLGNBQWM7SUFDZCxjQUFjO0lBRWQ7Ozs7OztNQU1FO0lBQ0YsWUFBbUIsS0FBZ0IsRUFBRSxFQUFVLEVBQUUsTUFBa0M7UUFDakYsS0FBSyxDQUFDLEtBQUssRUFBRSxFQUFFLEVBQUU7WUFDZixxQkFBcUIsRUFBRSw0QkFBNEI7WUFDbkQsMEJBQTBCLEVBQUU7Z0JBQzFCLFlBQVksRUFBRSxLQUFLO2dCQUNuQixlQUFlLEVBQUUsUUFBUTtnQkFDekIseUJBQXlCLEVBQUUsUUFBUTthQUNwQztZQUNELFFBQVEsRUFBRSxNQUFNLENBQUMsUUFBUTtZQUN6QixTQUFTLEVBQUUsTUFBTSxDQUFDLFNBQVM7WUFDM0IsS0FBSyxFQUFFLE1BQU0sQ0FBQyxLQUFLO1lBQ25CLFNBQVMsRUFBRSxNQUFNLENBQUMsU0FBUztTQUM1QixDQUFDLENBQUM7UUFDSCxJQUFJLENBQUMsaUNBQWlDLEdBQUcsTUFBTSxDQUFDLGdDQUFnQyxDQUFDO1FBQ2pGLElBQUksQ0FBQyw0QkFBNEIsR0FBRyxNQUFNLENBQUMsMkJBQTJCLENBQUM7SUFDekUsQ0FBQztJQUVELGFBQWE7SUFDYixhQUFhO0lBQ2IsYUFBYTtJQUViLHVEQUF1RDtJQUN2RCxJQUFXLEVBQUU7UUFDWCxPQUFPLElBQUksQ0FBQyxrQkFBa0IsQ0FBQyxJQUFJLENBQUMsQ0FBQztJQUN2QyxDQUFDO0lBSUQsSUFBVyxnQ0FBZ0M7UUFDekMsT0FBTyxJQUFJLENBQUMsc0JBQXNCLENBQUMscUNBQXFDLENBQUMsQ0FBQztJQUM1RSxDQUFDO0lBQ0QsSUFBVyxnQ0FBZ0MsQ0FBQyxLQUF1RDtRQUNqRyxJQUFJLENBQUMsaUNBQWlDLEdBQUcsS0FBSyxDQUFDO0lBQ2pELENBQUM7SUFDTSxxQ0FBcUM7UUFDMUMsSUFBSSxDQUFDLGlDQUFpQyxHQUFHLFNBQVMsQ0FBQztJQUNyRCxDQUFDO0lBQ0Qsb0RBQW9EO0lBQ3BELElBQVcscUNBQXFDO1FBQzlDLE9BQU8sSUFBSSxDQUFDLGlDQUFpQyxDQUFDO0lBQ2hELENBQUM7SUFJRCxJQUFXLDJCQUEyQjtRQUNwQyxPQUFPLElBQUksQ0FBQyxzQkFBc0IsQ0FBQyxpQ0FBaUMsQ0FBQyxDQUFDO0lBQ3hFLENBQUM7SUFDRCxJQUFXLDJCQUEyQixDQUFDLEtBQXVEO1FBQzVGLElBQUksQ0FBQyw0QkFBNEIsR0FBRyxLQUFLLENBQUM7SUFDNUMsQ0FBQztJQUNELG9EQUFvRDtJQUNwRCxJQUFXLGdDQUFnQztRQUN6QyxPQUFPLElBQUksQ0FBQyw0QkFBNEIsQ0FBQztJQUMzQyxDQUFDO0lBRUQsWUFBWTtJQUNaLFlBQVk7SUFDWixZQUFZO0lBRUYsb0JBQW9CO1FBQzVCLE9BQU87WUFDTCxtQ0FBbUMsRUFBRSxLQUFLLENBQUMsVUFBVSxDQUFDLEtBQUssQ0FBQyxrQkFBa0IsQ0FBQyxDQUFDLElBQUksQ0FBQyxpQ0FBaUMsQ0FBQztZQUN2SCwrQkFBK0IsRUFBRSxLQUFLLENBQUMsVUFBVSxDQUFDLEtBQUssQ0FBQyxrQkFBa0IsQ0FBQyxDQUFDLElBQUksQ0FBQyw0QkFBNEIsQ0FBQztTQUMvRyxDQUFDO0lBQ0osQ0FBQzs7QUFsRkgsb0RBbUZDOzs7QUFqRkMsb0JBQW9CO0FBQ3BCLG9CQUFvQjtBQUNwQixvQkFBb0I7QUFDRyxtQ0FBYyxHQUFHLDRCQUE0QixDQUFDIiwic291cmNlc0NvbnRlbnQiOlsiLy8gZ2VuZXJhdGVkIGZyb20gdGVycmFmb3JtIHJlc291cmNlIHNjaGVtYVxuXG5pbXBvcnQgeyBDb25zdHJ1Y3QgfSBmcm9tICdjb25zdHJ1Y3RzJztcbmltcG9ydCAqIGFzIGNka3RmIGZyb20gJ2Nka3RmJztcblxuLyoqXG4qIEFXUyBCYWNrdXBcbiovXG5leHBvcnQgaW50ZXJmYWNlIEJhY2t1cFJlZ2lvblNldHRpbmdzQ29uZmlnIGV4dGVuZHMgY2RrdGYuVGVycmFmb3JtTWV0YUFyZ3VtZW50cyB7XG4gIC8qKlxuICAqIERvY3MgYXQgVGVycmFmb3JtIFJlZ2lzdHJ5OiB7QGxpbmsgaHR0cHM6Ly93d3cudGVycmFmb3JtLmlvL2RvY3MvcHJvdmlkZXJzL2F3cy9yL2JhY2t1cF9yZWdpb25fc2V0dGluZ3MjcmVzb3VyY2VfdHlwZV9tYW5hZ2VtZW50X3ByZWZlcmVuY2UgQmFja3VwUmVnaW9uU2V0dGluZ3MjcmVzb3VyY2VfdHlwZV9tYW5hZ2VtZW50X3ByZWZlcmVuY2V9XG4gICovXG4gIHJlYWRvbmx5IHJlc291cmNlVHlwZU1hbmFnZW1lbnRQcmVmZXJlbmNlPzogeyBba2V5OiBzdHJpbmddOiAoYm9vbGVhbiB8IGNka3RmLklSZXNvbHZhYmxlKSB9O1xuICAvKipcbiAgKiBEb2NzIGF0IFRlcnJhZm9ybSBSZWdpc3RyeToge0BsaW5rIGh0dHBzOi8vd3d3LnRlcnJhZm9ybS5pby9kb2NzL3Byb3ZpZGVycy9hd3Mvci9iYWNrdXBfcmVnaW9uX3NldHRpbmdzI3Jlc291cmNlX3R5cGVfb3B0X2luX3ByZWZlcmVuY2UgQmFja3VwUmVnaW9uU2V0dGluZ3MjcmVzb3VyY2VfdHlwZV9vcHRfaW5fcHJlZmVyZW5jZX1cbiAgKi9cbiAgcmVhZG9ubHkgcmVzb3VyY2VUeXBlT3B0SW5QcmVmZXJlbmNlOiB7IFtrZXk6IHN0cmluZ106IChib29sZWFuIHwgY2RrdGYuSVJlc29sdmFibGUpIH07XG59XG5cbi8qKlxuKiBSZXByZXNlbnRzIGEge0BsaW5rIGh0dHBzOi8vd3d3LnRlcnJhZm9ybS5pby9kb2NzL3Byb3ZpZGVycy9hd3Mvci9iYWNrdXBfcmVnaW9uX3NldHRpbmdzIGF3c19iYWNrdXBfcmVnaW9uX3NldHRpbmdzfVxuKi9cbmV4cG9ydCBjbGFzcyBCYWNrdXBSZWdpb25TZXR0aW5ncyBleHRlbmRzIGNka3RmLlRlcnJhZm9ybVJlc291cmNlIHtcblxuICAvLyA9PT09PT09PT09PT09PT09PVxuICAvLyBTVEFUSUMgUFJPUEVSVElFU1xuICAvLyA9PT09PT09PT09PT09PT09PVxuICBwdWJsaWMgc3RhdGljIHJlYWRvbmx5IHRmUmVzb3VyY2VUeXBlID0gXCJhd3NfYmFja3VwX3JlZ2lvbl9zZXR0aW5nc1wiO1xuXG4gIC8vID09PT09PT09PT09XG4gIC8vIElOSVRJQUxJWkVSXG4gIC8vID09PT09PT09PT09XG5cbiAgLyoqXG4gICogQ3JlYXRlIGEgbmV3IHtAbGluayBodHRwczovL3d3dy50ZXJyYWZvcm0uaW8vZG9jcy9wcm92aWRlcnMvYXdzL3IvYmFja3VwX3JlZ2lvbl9zZXR0aW5ncyBhd3NfYmFja3VwX3JlZ2lvbl9zZXR0aW5nc30gUmVzb3VyY2VcbiAgKlxuICAqIEBwYXJhbSBzY29wZSBUaGUgc2NvcGUgaW4gd2hpY2ggdG8gZGVmaW5lIHRoaXMgY29uc3RydWN0XG4gICogQHBhcmFtIGlkIFRoZSBzY29wZWQgY29uc3RydWN0IElELiBNdXN0IGJlIHVuaXF1ZSBhbW9uZ3N0IHNpYmxpbmdzIGluIHRoZSBzYW1lIHNjb3BlXG4gICogQHBhcmFtIG9wdGlvbnMgQmFja3VwUmVnaW9uU2V0dGluZ3NDb25maWdcbiAgKi9cbiAgcHVibGljIGNvbnN0cnVjdG9yKHNjb3BlOiBDb25zdHJ1Y3QsIGlkOiBzdHJpbmcsIGNvbmZpZzogQmFja3VwUmVnaW9uU2V0dGluZ3NDb25maWcpIHtcbiAgICBzdXBlcihzY29wZSwgaWQsIHtcbiAgICAgIHRlcnJhZm9ybVJlc291cmNlVHlwZTogJ2F3c19iYWNrdXBfcmVnaW9uX3NldHRpbmdzJyxcbiAgICAgIHRlcnJhZm9ybUdlbmVyYXRvck1ldGFkYXRhOiB7XG4gICAgICAgIHByb3ZpZGVyTmFtZTogJ2F3cycsXG4gICAgICAgIHByb3ZpZGVyVmVyc2lvbjogJzQuMTUuMScsXG4gICAgICAgIHByb3ZpZGVyVmVyc2lvbkNvbnN0cmFpbnQ6ICd+PiA0LjAnXG4gICAgICB9LFxuICAgICAgcHJvdmlkZXI6IGNvbmZpZy5wcm92aWRlcixcbiAgICAgIGRlcGVuZHNPbjogY29uZmlnLmRlcGVuZHNPbixcbiAgICAgIGNvdW50OiBjb25maWcuY291bnQsXG4gICAgICBsaWZlY3ljbGU6IGNvbmZpZy5saWZlY3ljbGVcbiAgICB9KTtcbiAgICB0aGlzLl9yZXNvdXJjZVR5cGVNYW5hZ2VtZW50UHJlZmVyZW5jZSA9IGNvbmZpZy5yZXNvdXJjZVR5cGVNYW5hZ2VtZW50UHJlZmVyZW5jZTtcbiAgICB0aGlzLl9yZXNvdXJjZVR5cGVPcHRJblByZWZlcmVuY2UgPSBjb25maWcucmVzb3VyY2VUeXBlT3B0SW5QcmVmZXJlbmNlO1xuICB9XG5cbiAgLy8gPT09PT09PT09PVxuICAvLyBBVFRSSUJVVEVTXG4gIC8vID09PT09PT09PT1cblxuICAvLyBpZCAtIGNvbXB1dGVkOiB0cnVlLCBvcHRpb25hbDogdHJ1ZSwgcmVxdWlyZWQ6IGZhbHNlXG4gIHB1YmxpYyBnZXQgaWQoKSB7XG4gICAgcmV0dXJuIHRoaXMuZ2V0U3RyaW5nQXR0cmlidXRlKCdpZCcpO1xuICB9XG5cbiAgLy8gcmVzb3VyY2VfdHlwZV9tYW5hZ2VtZW50X3ByZWZlcmVuY2UgLSBjb21wdXRlZDogdHJ1ZSwgb3B0aW9uYWw6IHRydWUsIHJlcXVpcmVkOiBmYWxzZVxuICBwcml2YXRlIF9yZXNvdXJjZVR5cGVNYW5hZ2VtZW50UHJlZmVyZW5jZT86IHsgW2tleTogc3RyaW5nXTogKGJvb2xlYW4gfCBjZGt0Zi5JUmVzb2x2YWJsZSkgfTsgXG4gIHB1YmxpYyBnZXQgcmVzb3VyY2VUeXBlTWFuYWdlbWVudFByZWZlcmVuY2UoKSB7XG4gICAgcmV0dXJuIHRoaXMuZ2V0Qm9vbGVhbk1hcEF0dHJpYnV0ZSgncmVzb3VyY2VfdHlwZV9tYW5hZ2VtZW50X3ByZWZlcmVuY2UnKTtcbiAgfVxuICBwdWJsaWMgc2V0IHJlc291cmNlVHlwZU1hbmFnZW1lbnRQcmVmZXJlbmNlKHZhbHVlOiB7IFtrZXk6IHN0cmluZ106IChib29sZWFuIHwgY2RrdGYuSVJlc29sdmFibGUpIH0pIHtcbiAgICB0aGlzLl9yZXNvdXJjZVR5cGVNYW5hZ2VtZW50UHJlZmVyZW5jZSA9IHZhbHVlO1xuICB9XG4gIHB1YmxpYyByZXNldFJlc291cmNlVHlwZU1hbmFnZW1lbnRQcmVmZXJlbmNlKCkge1xuICAgIHRoaXMuX3Jlc291cmNlVHlwZU1hbmFnZW1lbnRQcmVmZXJlbmNlID0gdW5kZWZpbmVkO1xuICB9XG4gIC8vIFRlbXBvcmFyaWx5IGV4cG9zZSBpbnB1dCB2YWx1ZS4gVXNlIHdpdGggY2F1dGlvbi5cbiAgcHVibGljIGdldCByZXNvdXJjZVR5cGVNYW5hZ2VtZW50UHJlZmVyZW5jZUlucHV0KCkge1xuICAgIHJldHVybiB0aGlzLl9yZXNvdXJjZVR5cGVNYW5hZ2VtZW50UHJlZmVyZW5jZTtcbiAgfVxuXG4gIC8vIHJlc291cmNlX3R5cGVfb3B0X2luX3ByZWZlcmVuY2UgLSBjb21wdXRlZDogZmFsc2UsIG9wdGlvbmFsOiBmYWxzZSwgcmVxdWlyZWQ6IHRydWVcbiAgcHJpdmF0ZSBfcmVzb3VyY2VUeXBlT3B0SW5QcmVmZXJlbmNlPzogeyBba2V5OiBzdHJpbmddOiAoYm9vbGVhbiB8IGNka3RmLklSZXNvbHZhYmxlKSB9OyBcbiAgcHVibGljIGdldCByZXNvdXJjZVR5cGVPcHRJblByZWZlcmVuY2UoKSB7XG4gICAgcmV0dXJuIHRoaXMuZ2V0Qm9vbGVhbk1hcEF0dHJpYnV0ZSgncmVzb3VyY2VfdHlwZV9vcHRfaW5fcHJlZmVyZW5jZScpO1xuICB9XG4gIHB1YmxpYyBzZXQgcmVzb3VyY2VUeXBlT3B0SW5QcmVmZXJlbmNlKHZhbHVlOiB7IFtrZXk6IHN0cmluZ106IChib29sZWFuIHwgY2RrdGYuSVJlc29sdmFibGUpIH0pIHtcbiAgICB0aGlzLl9yZXNvdXJjZVR5cGVPcHRJblByZWZlcmVuY2UgPSB2YWx1ZTtcbiAgfVxuICAvLyBUZW1wb3JhcmlseSBleHBvc2UgaW5wdXQgdmFsdWUuIFVzZSB3aXRoIGNhdXRpb24uXG4gIHB1YmxpYyBnZXQgcmVzb3VyY2VUeXBlT3B0SW5QcmVmZXJlbmNlSW5wdXQoKSB7XG4gICAgcmV0dXJuIHRoaXMuX3Jlc291cmNlVHlwZU9wdEluUHJlZmVyZW5jZTtcbiAgfVxuXG4gIC8vID09PT09PT09PVxuICAvLyBTWU5USEVTSVNcbiAgLy8gPT09PT09PT09XG5cbiAgcHJvdGVjdGVkIHN5bnRoZXNpemVBdHRyaWJ1dGVzKCk6IHsgW25hbWU6IHN0cmluZ106IGFueSB9IHtcbiAgICByZXR1cm4ge1xuICAgICAgcmVzb3VyY2VfdHlwZV9tYW5hZ2VtZW50X3ByZWZlcmVuY2U6IGNka3RmLmhhc2hNYXBwZXIoY2RrdGYuYm9vbGVhblRvVGVycmFmb3JtKSh0aGlzLl9yZXNvdXJjZVR5cGVNYW5hZ2VtZW50UHJlZmVyZW5jZSksXG4gICAgICByZXNvdXJjZV90eXBlX29wdF9pbl9wcmVmZXJlbmNlOiBjZGt0Zi5oYXNoTWFwcGVyKGNka3RmLmJvb2xlYW5Ub1RlcnJhZm9ybSkodGhpcy5fcmVzb3VyY2VUeXBlT3B0SW5QcmVmZXJlbmNlKSxcbiAgICB9O1xuICB9XG59XG4iXX0=