import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
* AWS Backup
*/
export interface BackupReportPlanConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/backup_report_plan#description BackupReportPlan#description}
    */
    readonly description?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/backup_report_plan#name BackupReportPlan#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/backup_report_plan#tags BackupReportPlan#tags}
    */
    readonly tags?: {
        [key: string]: string;
    };
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/backup_report_plan#tags_all BackupReportPlan#tags_all}
    */
    readonly tagsAll?: {
        [key: string]: string;
    };
    /**
    * report_delivery_channel block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/backup_report_plan#report_delivery_channel BackupReportPlan#report_delivery_channel}
    */
    readonly reportDeliveryChannel: BackupReportPlanReportDeliveryChannel;
    /**
    * report_setting block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/backup_report_plan#report_setting BackupReportPlan#report_setting}
    */
    readonly reportSetting: BackupReportPlanReportSetting;
}
export interface BackupReportPlanReportDeliveryChannel {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/backup_report_plan#formats BackupReportPlan#formats}
    */
    readonly formats?: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/backup_report_plan#s3_bucket_name BackupReportPlan#s3_bucket_name}
    */
    readonly s3BucketName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/backup_report_plan#s3_key_prefix BackupReportPlan#s3_key_prefix}
    */
    readonly s3KeyPrefix?: string;
}
export declare function backupReportPlanReportDeliveryChannelToTerraform(struct?: BackupReportPlanReportDeliveryChannelOutputReference | BackupReportPlanReportDeliveryChannel): any;
export declare class BackupReportPlanReportDeliveryChannelOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): BackupReportPlanReportDeliveryChannel | undefined;
    set internalValue(value: BackupReportPlanReportDeliveryChannel | undefined);
    private _formats?;
    get formats(): string[];
    set formats(value: string[]);
    resetFormats(): void;
    get formatsInput(): string[] | undefined;
    private _s3BucketName?;
    get s3BucketName(): string;
    set s3BucketName(value: string);
    get s3BucketNameInput(): string | undefined;
    private _s3KeyPrefix?;
    get s3KeyPrefix(): string;
    set s3KeyPrefix(value: string);
    resetS3KeyPrefix(): void;
    get s3KeyPrefixInput(): string | undefined;
}
export interface BackupReportPlanReportSetting {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/backup_report_plan#framework_arns BackupReportPlan#framework_arns}
    */
    readonly frameworkArns?: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/backup_report_plan#number_of_frameworks BackupReportPlan#number_of_frameworks}
    */
    readonly numberOfFrameworks?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/backup_report_plan#report_template BackupReportPlan#report_template}
    */
    readonly reportTemplate: string;
}
export declare function backupReportPlanReportSettingToTerraform(struct?: BackupReportPlanReportSettingOutputReference | BackupReportPlanReportSetting): any;
export declare class BackupReportPlanReportSettingOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): BackupReportPlanReportSetting | undefined;
    set internalValue(value: BackupReportPlanReportSetting | undefined);
    private _frameworkArns?;
    get frameworkArns(): string[];
    set frameworkArns(value: string[]);
    resetFrameworkArns(): void;
    get frameworkArnsInput(): string[] | undefined;
    private _numberOfFrameworks?;
    get numberOfFrameworks(): number;
    set numberOfFrameworks(value: number);
    resetNumberOfFrameworks(): void;
    get numberOfFrameworksInput(): number | undefined;
    private _reportTemplate?;
    get reportTemplate(): string;
    set reportTemplate(value: string);
    get reportTemplateInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/aws/r/backup_report_plan aws_backup_report_plan}
*/
export declare class BackupReportPlan extends cdktf.TerraformResource {
    static readonly tfResourceType = "aws_backup_report_plan";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/aws/r/backup_report_plan aws_backup_report_plan} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options BackupReportPlanConfig
    */
    constructor(scope: Construct, id: string, config: BackupReportPlanConfig);
    get arn(): string;
    get creationTime(): string;
    get deploymentStatus(): string;
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    get id(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _tags?;
    get tags(): {
        [key: string]: string;
    };
    set tags(value: {
        [key: string]: string;
    });
    resetTags(): void;
    get tagsInput(): {
        [key: string]: string;
    } | undefined;
    private _tagsAll?;
    get tagsAll(): {
        [key: string]: string;
    };
    set tagsAll(value: {
        [key: string]: string;
    });
    resetTagsAll(): void;
    get tagsAllInput(): {
        [key: string]: string;
    } | undefined;
    private _reportDeliveryChannel;
    get reportDeliveryChannel(): BackupReportPlanReportDeliveryChannelOutputReference;
    putReportDeliveryChannel(value: BackupReportPlanReportDeliveryChannel): void;
    get reportDeliveryChannelInput(): BackupReportPlanReportDeliveryChannel | undefined;
    private _reportSetting;
    get reportSetting(): BackupReportPlanReportSettingOutputReference;
    putReportSetting(value: BackupReportPlanReportSetting): void;
    get reportSettingInput(): BackupReportPlanReportSetting | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
//# sourceMappingURL=backup-report-plan.d.ts.map