import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
* AWS Backup
*/
export interface BackupSelectionConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/backup_selection#iam_role_arn BackupSelection#iam_role_arn}
    */
    readonly iamRoleArn: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/backup_selection#name BackupSelection#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/backup_selection#not_resources BackupSelection#not_resources}
    */
    readonly notResources?: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/backup_selection#plan_id BackupSelection#plan_id}
    */
    readonly planId: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/backup_selection#resources BackupSelection#resources}
    */
    readonly resources?: string[];
    /**
    * condition block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/backup_selection#condition BackupSelection#condition}
    */
    readonly condition?: BackupSelectionCondition[] | cdktf.IResolvable;
    /**
    * selection_tag block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/backup_selection#selection_tag BackupSelection#selection_tag}
    */
    readonly selectionTag?: BackupSelectionSelectionTag[] | cdktf.IResolvable;
}
export interface BackupSelectionConditionStringEquals {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/backup_selection#key BackupSelection#key}
    */
    readonly key: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/backup_selection#value BackupSelection#value}
    */
    readonly value: string;
}
export declare function backupSelectionConditionStringEqualsToTerraform(struct?: BackupSelectionConditionStringEquals | cdktf.IResolvable): any;
export interface BackupSelectionConditionStringLike {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/backup_selection#key BackupSelection#key}
    */
    readonly key: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/backup_selection#value BackupSelection#value}
    */
    readonly value: string;
}
export declare function backupSelectionConditionStringLikeToTerraform(struct?: BackupSelectionConditionStringLike | cdktf.IResolvable): any;
export interface BackupSelectionConditionStringNotEquals {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/backup_selection#key BackupSelection#key}
    */
    readonly key: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/backup_selection#value BackupSelection#value}
    */
    readonly value: string;
}
export declare function backupSelectionConditionStringNotEqualsToTerraform(struct?: BackupSelectionConditionStringNotEquals | cdktf.IResolvable): any;
export interface BackupSelectionConditionStringNotLike {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/backup_selection#key BackupSelection#key}
    */
    readonly key: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/backup_selection#value BackupSelection#value}
    */
    readonly value: string;
}
export declare function backupSelectionConditionStringNotLikeToTerraform(struct?: BackupSelectionConditionStringNotLike | cdktf.IResolvable): any;
export interface BackupSelectionCondition {
    /**
    * string_equals block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/backup_selection#string_equals BackupSelection#string_equals}
    */
    readonly stringEquals?: BackupSelectionConditionStringEquals[] | cdktf.IResolvable;
    /**
    * string_like block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/backup_selection#string_like BackupSelection#string_like}
    */
    readonly stringLike?: BackupSelectionConditionStringLike[] | cdktf.IResolvable;
    /**
    * string_not_equals block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/backup_selection#string_not_equals BackupSelection#string_not_equals}
    */
    readonly stringNotEquals?: BackupSelectionConditionStringNotEquals[] | cdktf.IResolvable;
    /**
    * string_not_like block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/backup_selection#string_not_like BackupSelection#string_not_like}
    */
    readonly stringNotLike?: BackupSelectionConditionStringNotLike[] | cdktf.IResolvable;
}
export declare function backupSelectionConditionToTerraform(struct?: BackupSelectionCondition | cdktf.IResolvable): any;
export interface BackupSelectionSelectionTag {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/backup_selection#key BackupSelection#key}
    */
    readonly key: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/backup_selection#type BackupSelection#type}
    */
    readonly type: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/backup_selection#value BackupSelection#value}
    */
    readonly value: string;
}
export declare function backupSelectionSelectionTagToTerraform(struct?: BackupSelectionSelectionTag | cdktf.IResolvable): any;
/**
* Represents a {@link https://www.terraform.io/docs/providers/aws/r/backup_selection aws_backup_selection}
*/
export declare class BackupSelection extends cdktf.TerraformResource {
    static readonly tfResourceType = "aws_backup_selection";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/aws/r/backup_selection aws_backup_selection} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options BackupSelectionConfig
    */
    constructor(scope: Construct, id: string, config: BackupSelectionConfig);
    private _iamRoleArn?;
    get iamRoleArn(): string;
    set iamRoleArn(value: string);
    get iamRoleArnInput(): string | undefined;
    get id(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _notResources?;
    get notResources(): string[];
    set notResources(value: string[]);
    resetNotResources(): void;
    get notResourcesInput(): string[] | undefined;
    private _planId?;
    get planId(): string;
    set planId(value: string);
    get planIdInput(): string | undefined;
    private _resources?;
    get resources(): string[];
    set resources(value: string[]);
    resetResources(): void;
    get resourcesInput(): string[] | undefined;
    private _condition?;
    get condition(): BackupSelectionCondition[] | cdktf.IResolvable;
    set condition(value: BackupSelectionCondition[] | cdktf.IResolvable);
    resetCondition(): void;
    get conditionInput(): cdktf.IResolvable | BackupSelectionCondition[] | undefined;
    private _selectionTag?;
    get selectionTag(): BackupSelectionSelectionTag[] | cdktf.IResolvable;
    set selectionTag(value: BackupSelectionSelectionTag[] | cdktf.IResolvable);
    resetSelectionTag(): void;
    get selectionTagInput(): cdktf.IResolvable | BackupSelectionSelectionTag[] | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
//# sourceMappingURL=backup-selection.d.ts.map