import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
* AWS Backup
*/
export interface DataAwsBackupReportPlanConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/d/backup_report_plan#name DataAwsBackupReportPlan#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/d/backup_report_plan#tags DataAwsBackupReportPlan#tags}
    */
    readonly tags?: {
        [key: string]: string;
    };
}
export interface DataAwsBackupReportPlanReportDeliveryChannel {
}
export declare function dataAwsBackupReportPlanReportDeliveryChannelToTerraform(struct?: DataAwsBackupReportPlanReportDeliveryChannel): any;
export declare class DataAwsBackupReportPlanReportDeliveryChannelOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAwsBackupReportPlanReportDeliveryChannel | undefined;
    set internalValue(value: DataAwsBackupReportPlanReportDeliveryChannel | undefined);
    get formats(): string[];
    get s3BucketName(): string;
    get s3KeyPrefix(): string;
}
export declare class DataAwsBackupReportPlanReportDeliveryChannelList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAwsBackupReportPlanReportDeliveryChannelOutputReference;
}
export interface DataAwsBackupReportPlanReportSetting {
}
export declare function dataAwsBackupReportPlanReportSettingToTerraform(struct?: DataAwsBackupReportPlanReportSetting): any;
export declare class DataAwsBackupReportPlanReportSettingOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAwsBackupReportPlanReportSetting | undefined;
    set internalValue(value: DataAwsBackupReportPlanReportSetting | undefined);
    get frameworkArns(): string[];
    get numberOfFrameworks(): number;
    get reportTemplate(): string;
}
export declare class DataAwsBackupReportPlanReportSettingList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAwsBackupReportPlanReportSettingOutputReference;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/aws/d/backup_report_plan aws_backup_report_plan}
*/
export declare class DataAwsBackupReportPlan extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "aws_backup_report_plan";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/aws/d/backup_report_plan aws_backup_report_plan} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataAwsBackupReportPlanConfig
    */
    constructor(scope: Construct, id: string, config: DataAwsBackupReportPlanConfig);
    get arn(): string;
    get creationTime(): string;
    get deploymentStatus(): string;
    get description(): string;
    get id(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _reportDeliveryChannel;
    get reportDeliveryChannel(): DataAwsBackupReportPlanReportDeliveryChannelList;
    private _reportSetting;
    get reportSetting(): DataAwsBackupReportPlanReportSettingList;
    private _tags?;
    get tags(): {
        [key: string]: string;
    };
    set tags(value: {
        [key: string]: string;
    });
    resetTags(): void;
    get tagsInput(): {
        [key: string]: string;
    } | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
//# sourceMappingURL=data-aws-backup-report-plan.d.ts.map