import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
* AWS Batch
*/
export interface BatchJobDefinitionConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/batch_job_definition#container_properties BatchJobDefinition#container_properties}
    */
    readonly containerProperties?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/batch_job_definition#name BatchJobDefinition#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/batch_job_definition#parameters BatchJobDefinition#parameters}
    */
    readonly parameters?: {
        [key: string]: string;
    };
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/batch_job_definition#platform_capabilities BatchJobDefinition#platform_capabilities}
    */
    readonly platformCapabilities?: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/batch_job_definition#propagate_tags BatchJobDefinition#propagate_tags}
    */
    readonly propagateTags?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/batch_job_definition#tags BatchJobDefinition#tags}
    */
    readonly tags?: {
        [key: string]: string;
    };
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/batch_job_definition#tags_all BatchJobDefinition#tags_all}
    */
    readonly tagsAll?: {
        [key: string]: string;
    };
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/batch_job_definition#type BatchJobDefinition#type}
    */
    readonly type: string;
    /**
    * retry_strategy block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/batch_job_definition#retry_strategy BatchJobDefinition#retry_strategy}
    */
    readonly retryStrategy?: BatchJobDefinitionRetryStrategy;
    /**
    * timeout block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/batch_job_definition#timeout BatchJobDefinition#timeout}
    */
    readonly timeout?: BatchJobDefinitionTimeout;
}
export interface BatchJobDefinitionRetryStrategyEvaluateOnExit {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/batch_job_definition#action BatchJobDefinition#action}
    */
    readonly action: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/batch_job_definition#on_exit_code BatchJobDefinition#on_exit_code}
    */
    readonly onExitCode?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/batch_job_definition#on_reason BatchJobDefinition#on_reason}
    */
    readonly onReason?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/batch_job_definition#on_status_reason BatchJobDefinition#on_status_reason}
    */
    readonly onStatusReason?: string;
}
export declare function batchJobDefinitionRetryStrategyEvaluateOnExitToTerraform(struct?: BatchJobDefinitionRetryStrategyEvaluateOnExit | cdktf.IResolvable): any;
export interface BatchJobDefinitionRetryStrategy {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/batch_job_definition#attempts BatchJobDefinition#attempts}
    */
    readonly attempts?: number;
    /**
    * evaluate_on_exit block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/batch_job_definition#evaluate_on_exit BatchJobDefinition#evaluate_on_exit}
    */
    readonly evaluateOnExit?: BatchJobDefinitionRetryStrategyEvaluateOnExit[] | cdktf.IResolvable;
}
export declare function batchJobDefinitionRetryStrategyToTerraform(struct?: BatchJobDefinitionRetryStrategyOutputReference | BatchJobDefinitionRetryStrategy): any;
export declare class BatchJobDefinitionRetryStrategyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): BatchJobDefinitionRetryStrategy | undefined;
    set internalValue(value: BatchJobDefinitionRetryStrategy | undefined);
    private _attempts?;
    get attempts(): number;
    set attempts(value: number);
    resetAttempts(): void;
    get attemptsInput(): number | undefined;
    private _evaluateOnExit?;
    get evaluateOnExit(): BatchJobDefinitionRetryStrategyEvaluateOnExit[] | cdktf.IResolvable;
    set evaluateOnExit(value: BatchJobDefinitionRetryStrategyEvaluateOnExit[] | cdktf.IResolvable);
    resetEvaluateOnExit(): void;
    get evaluateOnExitInput(): cdktf.IResolvable | BatchJobDefinitionRetryStrategyEvaluateOnExit[] | undefined;
}
export interface BatchJobDefinitionTimeout {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/batch_job_definition#attempt_duration_seconds BatchJobDefinition#attempt_duration_seconds}
    */
    readonly attemptDurationSeconds?: number;
}
export declare function batchJobDefinitionTimeoutToTerraform(struct?: BatchJobDefinitionTimeoutOutputReference | BatchJobDefinitionTimeout): any;
export declare class BatchJobDefinitionTimeoutOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): BatchJobDefinitionTimeout | undefined;
    set internalValue(value: BatchJobDefinitionTimeout | undefined);
    private _attemptDurationSeconds?;
    get attemptDurationSeconds(): number;
    set attemptDurationSeconds(value: number);
    resetAttemptDurationSeconds(): void;
    get attemptDurationSecondsInput(): number | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/aws/r/batch_job_definition aws_batch_job_definition}
*/
export declare class BatchJobDefinition extends cdktf.TerraformResource {
    static readonly tfResourceType = "aws_batch_job_definition";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/aws/r/batch_job_definition aws_batch_job_definition} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options BatchJobDefinitionConfig
    */
    constructor(scope: Construct, id: string, config: BatchJobDefinitionConfig);
    get arn(): string;
    private _containerProperties?;
    get containerProperties(): string;
    set containerProperties(value: string);
    resetContainerProperties(): void;
    get containerPropertiesInput(): string | undefined;
    get id(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _parameters?;
    get parameters(): {
        [key: string]: string;
    };
    set parameters(value: {
        [key: string]: string;
    });
    resetParameters(): void;
    get parametersInput(): {
        [key: string]: string;
    } | undefined;
    private _platformCapabilities?;
    get platformCapabilities(): string[];
    set platformCapabilities(value: string[]);
    resetPlatformCapabilities(): void;
    get platformCapabilitiesInput(): string[] | undefined;
    private _propagateTags?;
    get propagateTags(): boolean | cdktf.IResolvable;
    set propagateTags(value: boolean | cdktf.IResolvable);
    resetPropagateTags(): void;
    get propagateTagsInput(): boolean | cdktf.IResolvable | undefined;
    get revision(): number;
    private _tags?;
    get tags(): {
        [key: string]: string;
    };
    set tags(value: {
        [key: string]: string;
    });
    resetTags(): void;
    get tagsInput(): {
        [key: string]: string;
    } | undefined;
    private _tagsAll?;
    get tagsAll(): {
        [key: string]: string;
    };
    set tagsAll(value: {
        [key: string]: string;
    });
    resetTagsAll(): void;
    get tagsAllInput(): {
        [key: string]: string;
    } | undefined;
    private _type?;
    get type(): string;
    set type(value: string);
    get typeInput(): string | undefined;
    private _retryStrategy;
    get retryStrategy(): BatchJobDefinitionRetryStrategyOutputReference;
    putRetryStrategy(value: BatchJobDefinitionRetryStrategy): void;
    resetRetryStrategy(): void;
    get retryStrategyInput(): BatchJobDefinitionRetryStrategy | undefined;
    private _timeout;
    get timeout(): BatchJobDefinitionTimeoutOutputReference;
    putTimeout(value: BatchJobDefinitionTimeout): void;
    resetTimeout(): void;
    get timeoutInput(): BatchJobDefinitionTimeout | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
//# sourceMappingURL=batch-job-definition.d.ts.map