import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
* AWS Batch
*/
export interface BatchSchedulingPolicyConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/batch_scheduling_policy#name BatchSchedulingPolicy#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/batch_scheduling_policy#tags BatchSchedulingPolicy#tags}
    */
    readonly tags?: {
        [key: string]: string;
    };
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/batch_scheduling_policy#tags_all BatchSchedulingPolicy#tags_all}
    */
    readonly tagsAll?: {
        [key: string]: string;
    };
    /**
    * fair_share_policy block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/batch_scheduling_policy#fair_share_policy BatchSchedulingPolicy#fair_share_policy}
    */
    readonly fairSharePolicy?: BatchSchedulingPolicyFairSharePolicy;
}
export interface BatchSchedulingPolicyFairSharePolicyShareDistribution {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/batch_scheduling_policy#share_identifier BatchSchedulingPolicy#share_identifier}
    */
    readonly shareIdentifier: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/batch_scheduling_policy#weight_factor BatchSchedulingPolicy#weight_factor}
    */
    readonly weightFactor?: number;
}
export declare function batchSchedulingPolicyFairSharePolicyShareDistributionToTerraform(struct?: BatchSchedulingPolicyFairSharePolicyShareDistribution | cdktf.IResolvable): any;
export interface BatchSchedulingPolicyFairSharePolicy {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/batch_scheduling_policy#compute_reservation BatchSchedulingPolicy#compute_reservation}
    */
    readonly computeReservation?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/batch_scheduling_policy#share_decay_seconds BatchSchedulingPolicy#share_decay_seconds}
    */
    readonly shareDecaySeconds?: number;
    /**
    * share_distribution block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/batch_scheduling_policy#share_distribution BatchSchedulingPolicy#share_distribution}
    */
    readonly shareDistribution?: BatchSchedulingPolicyFairSharePolicyShareDistribution[] | cdktf.IResolvable;
}
export declare function batchSchedulingPolicyFairSharePolicyToTerraform(struct?: BatchSchedulingPolicyFairSharePolicyOutputReference | BatchSchedulingPolicyFairSharePolicy): any;
export declare class BatchSchedulingPolicyFairSharePolicyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): BatchSchedulingPolicyFairSharePolicy | undefined;
    set internalValue(value: BatchSchedulingPolicyFairSharePolicy | undefined);
    private _computeReservation?;
    get computeReservation(): number;
    set computeReservation(value: number);
    resetComputeReservation(): void;
    get computeReservationInput(): number | undefined;
    private _shareDecaySeconds?;
    get shareDecaySeconds(): number;
    set shareDecaySeconds(value: number);
    resetShareDecaySeconds(): void;
    get shareDecaySecondsInput(): number | undefined;
    private _shareDistribution?;
    get shareDistribution(): BatchSchedulingPolicyFairSharePolicyShareDistribution[] | cdktf.IResolvable;
    set shareDistribution(value: BatchSchedulingPolicyFairSharePolicyShareDistribution[] | cdktf.IResolvable);
    resetShareDistribution(): void;
    get shareDistributionInput(): cdktf.IResolvable | BatchSchedulingPolicyFairSharePolicyShareDistribution[] | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/aws/r/batch_scheduling_policy aws_batch_scheduling_policy}
*/
export declare class BatchSchedulingPolicy extends cdktf.TerraformResource {
    static readonly tfResourceType = "aws_batch_scheduling_policy";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/aws/r/batch_scheduling_policy aws_batch_scheduling_policy} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options BatchSchedulingPolicyConfig
    */
    constructor(scope: Construct, id: string, config: BatchSchedulingPolicyConfig);
    get arn(): string;
    get id(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _tags?;
    get tags(): {
        [key: string]: string;
    };
    set tags(value: {
        [key: string]: string;
    });
    resetTags(): void;
    get tagsInput(): {
        [key: string]: string;
    } | undefined;
    private _tagsAll?;
    get tagsAll(): {
        [key: string]: string;
    };
    set tagsAll(value: {
        [key: string]: string;
    });
    resetTagsAll(): void;
    get tagsAllInput(): {
        [key: string]: string;
    } | undefined;
    private _fairSharePolicy;
    get fairSharePolicy(): BatchSchedulingPolicyFairSharePolicyOutputReference;
    putFairSharePolicy(value: BatchSchedulingPolicyFairSharePolicy): void;
    resetFairSharePolicy(): void;
    get fairSharePolicyInput(): BatchSchedulingPolicyFairSharePolicy | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
//# sourceMappingURL=batch-scheduling-policy.d.ts.map