import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
* AWS Batch
*/
export interface DataAwsBatchJobQueueConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/d/batch_job_queue#name DataAwsBatchJobQueue#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/d/batch_job_queue#tags DataAwsBatchJobQueue#tags}
    */
    readonly tags?: {
        [key: string]: string;
    };
}
export interface DataAwsBatchJobQueueComputeEnvironmentOrder {
}
export declare function dataAwsBatchJobQueueComputeEnvironmentOrderToTerraform(struct?: DataAwsBatchJobQueueComputeEnvironmentOrder): any;
export declare class DataAwsBatchJobQueueComputeEnvironmentOrderOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAwsBatchJobQueueComputeEnvironmentOrder | undefined;
    set internalValue(value: DataAwsBatchJobQueueComputeEnvironmentOrder | undefined);
    get computeEnvironment(): string;
    get order(): number;
}
export declare class DataAwsBatchJobQueueComputeEnvironmentOrderList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAwsBatchJobQueueComputeEnvironmentOrderOutputReference;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/aws/d/batch_job_queue aws_batch_job_queue}
*/
export declare class DataAwsBatchJobQueue extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "aws_batch_job_queue";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/aws/d/batch_job_queue aws_batch_job_queue} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataAwsBatchJobQueueConfig
    */
    constructor(scope: Construct, id: string, config: DataAwsBatchJobQueueConfig);
    get arn(): string;
    private _computeEnvironmentOrder;
    get computeEnvironmentOrder(): DataAwsBatchJobQueueComputeEnvironmentOrderList;
    get id(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    get priority(): number;
    get schedulingPolicyArn(): string;
    get state(): string;
    get status(): string;
    get statusReason(): string;
    private _tags?;
    get tags(): {
        [key: string]: string;
    };
    set tags(value: {
        [key: string]: string;
    });
    resetTags(): void;
    get tagsInput(): {
        [key: string]: string;
    } | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
//# sourceMappingURL=data-aws-batch-job-queue.d.ts.map