import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
* AWS Batch
*/
export interface DataAwsBatchSchedulingPolicyConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/d/batch_scheduling_policy#arn DataAwsBatchSchedulingPolicy#arn}
    */
    readonly arn: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/d/batch_scheduling_policy#tags DataAwsBatchSchedulingPolicy#tags}
    */
    readonly tags?: {
        [key: string]: string;
    };
}
export interface DataAwsBatchSchedulingPolicyFairSharePolicyShareDistribution {
}
export declare function dataAwsBatchSchedulingPolicyFairSharePolicyShareDistributionToTerraform(struct?: DataAwsBatchSchedulingPolicyFairSharePolicyShareDistribution): any;
export declare class DataAwsBatchSchedulingPolicyFairSharePolicyShareDistributionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAwsBatchSchedulingPolicyFairSharePolicyShareDistribution | undefined;
    set internalValue(value: DataAwsBatchSchedulingPolicyFairSharePolicyShareDistribution | undefined);
    get shareIdentifier(): string;
    get weightFactor(): number;
}
export declare class DataAwsBatchSchedulingPolicyFairSharePolicyShareDistributionList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAwsBatchSchedulingPolicyFairSharePolicyShareDistributionOutputReference;
}
export interface DataAwsBatchSchedulingPolicyFairSharePolicy {
}
export declare function dataAwsBatchSchedulingPolicyFairSharePolicyToTerraform(struct?: DataAwsBatchSchedulingPolicyFairSharePolicy): any;
export declare class DataAwsBatchSchedulingPolicyFairSharePolicyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAwsBatchSchedulingPolicyFairSharePolicy | undefined;
    set internalValue(value: DataAwsBatchSchedulingPolicyFairSharePolicy | undefined);
    get computeReservation(): number;
    get shareDecaySeconds(): number;
    private _shareDistribution;
    get shareDistribution(): DataAwsBatchSchedulingPolicyFairSharePolicyShareDistributionList;
}
export declare class DataAwsBatchSchedulingPolicyFairSharePolicyList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAwsBatchSchedulingPolicyFairSharePolicyOutputReference;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/aws/d/batch_scheduling_policy aws_batch_scheduling_policy}
*/
export declare class DataAwsBatchSchedulingPolicy extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "aws_batch_scheduling_policy";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/aws/d/batch_scheduling_policy aws_batch_scheduling_policy} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataAwsBatchSchedulingPolicyConfig
    */
    constructor(scope: Construct, id: string, config: DataAwsBatchSchedulingPolicyConfig);
    private _arn?;
    get arn(): string;
    set arn(value: string);
    get arnInput(): string | undefined;
    private _fairSharePolicy;
    get fairSharePolicy(): DataAwsBatchSchedulingPolicyFairSharePolicyList;
    get id(): string;
    get name(): string;
    private _tags?;
    get tags(): {
        [key: string]: string;
    };
    set tags(value: {
        [key: string]: string;
    });
    resetTags(): void;
    get tagsInput(): {
        [key: string]: string;
    } | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
//# sourceMappingURL=data-aws-batch-scheduling-policy.d.ts.map