"use strict";
var _a, _b;
Object.defineProperty(exports, "__esModule", { value: true });
exports.BudgetsBudget = exports.budgetsBudgetNotificationToTerraform = exports.BudgetsBudgetCostTypesOutputReference = exports.budgetsBudgetCostTypesToTerraform = exports.budgetsBudgetCostFilterToTerraform = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cdktf = require("cdktf");
function budgetsBudgetCostFilterToTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    return {
        name: cdktf.stringToTerraform(struct.name),
        values: cdktf.listMapper(cdktf.stringToTerraform)(struct.values),
    };
}
exports.budgetsBudgetCostFilterToTerraform = budgetsBudgetCostFilterToTerraform;
function budgetsBudgetCostTypesToTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    return {
        include_credit: cdktf.booleanToTerraform(struct.includeCredit),
        include_discount: cdktf.booleanToTerraform(struct.includeDiscount),
        include_other_subscription: cdktf.booleanToTerraform(struct.includeOtherSubscription),
        include_recurring: cdktf.booleanToTerraform(struct.includeRecurring),
        include_refund: cdktf.booleanToTerraform(struct.includeRefund),
        include_subscription: cdktf.booleanToTerraform(struct.includeSubscription),
        include_support: cdktf.booleanToTerraform(struct.includeSupport),
        include_tax: cdktf.booleanToTerraform(struct.includeTax),
        include_upfront: cdktf.booleanToTerraform(struct.includeUpfront),
        use_amortized: cdktf.booleanToTerraform(struct.useAmortized),
        use_blended: cdktf.booleanToTerraform(struct.useBlended),
    };
}
exports.budgetsBudgetCostTypesToTerraform = budgetsBudgetCostTypesToTerraform;
class BudgetsBudgetCostTypesOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource, terraformAttribute) {
        super(terraformResource, terraformAttribute, false, 0);
        this.isEmptyObject = false;
    }
    get internalValue() {
        let hasAnyValues = this.isEmptyObject;
        const internalValueResult = {};
        if (this._includeCredit !== undefined) {
            hasAnyValues = true;
            internalValueResult.includeCredit = this._includeCredit;
        }
        if (this._includeDiscount !== undefined) {
            hasAnyValues = true;
            internalValueResult.includeDiscount = this._includeDiscount;
        }
        if (this._includeOtherSubscription !== undefined) {
            hasAnyValues = true;
            internalValueResult.includeOtherSubscription = this._includeOtherSubscription;
        }
        if (this._includeRecurring !== undefined) {
            hasAnyValues = true;
            internalValueResult.includeRecurring = this._includeRecurring;
        }
        if (this._includeRefund !== undefined) {
            hasAnyValues = true;
            internalValueResult.includeRefund = this._includeRefund;
        }
        if (this._includeSubscription !== undefined) {
            hasAnyValues = true;
            internalValueResult.includeSubscription = this._includeSubscription;
        }
        if (this._includeSupport !== undefined) {
            hasAnyValues = true;
            internalValueResult.includeSupport = this._includeSupport;
        }
        if (this._includeTax !== undefined) {
            hasAnyValues = true;
            internalValueResult.includeTax = this._includeTax;
        }
        if (this._includeUpfront !== undefined) {
            hasAnyValues = true;
            internalValueResult.includeUpfront = this._includeUpfront;
        }
        if (this._useAmortized !== undefined) {
            hasAnyValues = true;
            internalValueResult.useAmortized = this._useAmortized;
        }
        if (this._useBlended !== undefined) {
            hasAnyValues = true;
            internalValueResult.useBlended = this._useBlended;
        }
        return hasAnyValues ? internalValueResult : undefined;
    }
    set internalValue(value) {
        if (value === undefined) {
            this.isEmptyObject = false;
            this._includeCredit = undefined;
            this._includeDiscount = undefined;
            this._includeOtherSubscription = undefined;
            this._includeRecurring = undefined;
            this._includeRefund = undefined;
            this._includeSubscription = undefined;
            this._includeSupport = undefined;
            this._includeTax = undefined;
            this._includeUpfront = undefined;
            this._useAmortized = undefined;
            this._useBlended = undefined;
        }
        else {
            this.isEmptyObject = Object.keys(value).length === 0;
            this._includeCredit = value.includeCredit;
            this._includeDiscount = value.includeDiscount;
            this._includeOtherSubscription = value.includeOtherSubscription;
            this._includeRecurring = value.includeRecurring;
            this._includeRefund = value.includeRefund;
            this._includeSubscription = value.includeSubscription;
            this._includeSupport = value.includeSupport;
            this._includeTax = value.includeTax;
            this._includeUpfront = value.includeUpfront;
            this._useAmortized = value.useAmortized;
            this._useBlended = value.useBlended;
        }
    }
    get includeCredit() {
        return this.getBooleanAttribute('include_credit');
    }
    set includeCredit(value) {
        this._includeCredit = value;
    }
    resetIncludeCredit() {
        this._includeCredit = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get includeCreditInput() {
        return this._includeCredit;
    }
    get includeDiscount() {
        return this.getBooleanAttribute('include_discount');
    }
    set includeDiscount(value) {
        this._includeDiscount = value;
    }
    resetIncludeDiscount() {
        this._includeDiscount = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get includeDiscountInput() {
        return this._includeDiscount;
    }
    get includeOtherSubscription() {
        return this.getBooleanAttribute('include_other_subscription');
    }
    set includeOtherSubscription(value) {
        this._includeOtherSubscription = value;
    }
    resetIncludeOtherSubscription() {
        this._includeOtherSubscription = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get includeOtherSubscriptionInput() {
        return this._includeOtherSubscription;
    }
    get includeRecurring() {
        return this.getBooleanAttribute('include_recurring');
    }
    set includeRecurring(value) {
        this._includeRecurring = value;
    }
    resetIncludeRecurring() {
        this._includeRecurring = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get includeRecurringInput() {
        return this._includeRecurring;
    }
    get includeRefund() {
        return this.getBooleanAttribute('include_refund');
    }
    set includeRefund(value) {
        this._includeRefund = value;
    }
    resetIncludeRefund() {
        this._includeRefund = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get includeRefundInput() {
        return this._includeRefund;
    }
    get includeSubscription() {
        return this.getBooleanAttribute('include_subscription');
    }
    set includeSubscription(value) {
        this._includeSubscription = value;
    }
    resetIncludeSubscription() {
        this._includeSubscription = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get includeSubscriptionInput() {
        return this._includeSubscription;
    }
    get includeSupport() {
        return this.getBooleanAttribute('include_support');
    }
    set includeSupport(value) {
        this._includeSupport = value;
    }
    resetIncludeSupport() {
        this._includeSupport = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get includeSupportInput() {
        return this._includeSupport;
    }
    get includeTax() {
        return this.getBooleanAttribute('include_tax');
    }
    set includeTax(value) {
        this._includeTax = value;
    }
    resetIncludeTax() {
        this._includeTax = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get includeTaxInput() {
        return this._includeTax;
    }
    get includeUpfront() {
        return this.getBooleanAttribute('include_upfront');
    }
    set includeUpfront(value) {
        this._includeUpfront = value;
    }
    resetIncludeUpfront() {
        this._includeUpfront = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get includeUpfrontInput() {
        return this._includeUpfront;
    }
    get useAmortized() {
        return this.getBooleanAttribute('use_amortized');
    }
    set useAmortized(value) {
        this._useAmortized = value;
    }
    resetUseAmortized() {
        this._useAmortized = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get useAmortizedInput() {
        return this._useAmortized;
    }
    get useBlended() {
        return this.getBooleanAttribute('use_blended');
    }
    set useBlended(value) {
        this._useBlended = value;
    }
    resetUseBlended() {
        this._useBlended = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get useBlendedInput() {
        return this._useBlended;
    }
}
exports.BudgetsBudgetCostTypesOutputReference = BudgetsBudgetCostTypesOutputReference;
_a = JSII_RTTI_SYMBOL_1;
BudgetsBudgetCostTypesOutputReference[_a] = { fqn: "@cdktf/provider-aws.budgets.BudgetsBudgetCostTypesOutputReference", version: "7.0.64" };
function budgetsBudgetNotificationToTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    return {
        comparison_operator: cdktf.stringToTerraform(struct.comparisonOperator),
        notification_type: cdktf.stringToTerraform(struct.notificationType),
        subscriber_email_addresses: cdktf.listMapper(cdktf.stringToTerraform)(struct.subscriberEmailAddresses),
        subscriber_sns_topic_arns: cdktf.listMapper(cdktf.stringToTerraform)(struct.subscriberSnsTopicArns),
        threshold: cdktf.numberToTerraform(struct.threshold),
        threshold_type: cdktf.stringToTerraform(struct.thresholdType),
    };
}
exports.budgetsBudgetNotificationToTerraform = budgetsBudgetNotificationToTerraform;
/**
* Represents a {@link https://www.terraform.io/docs/providers/aws/r/budgets_budget aws_budgets_budget}
*/
class BudgetsBudget extends cdktf.TerraformResource {
    // ===========
    // INITIALIZER
    // ===========
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/aws/r/budgets_budget aws_budgets_budget} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options BudgetsBudgetConfig
    */
    constructor(scope, id, config) {
        super(scope, id, {
            terraformResourceType: 'aws_budgets_budget',
            terraformGeneratorMetadata: {
                providerName: 'aws',
                providerVersion: '4.15.1',
                providerVersionConstraint: '~> 4.0'
            },
            provider: config.provider,
            dependsOn: config.dependsOn,
            count: config.count,
            lifecycle: config.lifecycle
        });
        // cost_types - computed: false, optional: true, required: false
        this._costTypes = new BudgetsBudgetCostTypesOutputReference(this, "cost_types");
        this._accountId = config.accountId;
        this._budgetType = config.budgetType;
        this._costFilters = config.costFilters;
        this._limitAmount = config.limitAmount;
        this._limitUnit = config.limitUnit;
        this._name = config.name;
        this._namePrefix = config.namePrefix;
        this._timePeriodEnd = config.timePeriodEnd;
        this._timePeriodStart = config.timePeriodStart;
        this._timeUnit = config.timeUnit;
        this._costFilter = config.costFilter;
        this._costTypes.internalValue = config.costTypes;
        this._notification = config.notification;
    }
    get accountId() {
        return this.getStringAttribute('account_id');
    }
    set accountId(value) {
        this._accountId = value;
    }
    resetAccountId() {
        this._accountId = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get accountIdInput() {
        return this._accountId;
    }
    // arn - computed: true, optional: false, required: false
    get arn() {
        return this.getStringAttribute('arn');
    }
    get budgetType() {
        return this.getStringAttribute('budget_type');
    }
    set budgetType(value) {
        this._budgetType = value;
    }
    // Temporarily expose input value. Use with caution.
    get budgetTypeInput() {
        return this._budgetType;
    }
    get costFilters() {
        return this.getStringMapAttribute('cost_filters');
    }
    set costFilters(value) {
        this._costFilters = value;
    }
    resetCostFilters() {
        this._costFilters = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get costFiltersInput() {
        return this._costFilters;
    }
    // id - computed: true, optional: true, required: false
    get id() {
        return this.getStringAttribute('id');
    }
    get limitAmount() {
        return this.getStringAttribute('limit_amount');
    }
    set limitAmount(value) {
        this._limitAmount = value;
    }
    // Temporarily expose input value. Use with caution.
    get limitAmountInput() {
        return this._limitAmount;
    }
    get limitUnit() {
        return this.getStringAttribute('limit_unit');
    }
    set limitUnit(value) {
        this._limitUnit = value;
    }
    // Temporarily expose input value. Use with caution.
    get limitUnitInput() {
        return this._limitUnit;
    }
    get name() {
        return this.getStringAttribute('name');
    }
    set name(value) {
        this._name = value;
    }
    resetName() {
        this._name = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get nameInput() {
        return this._name;
    }
    get namePrefix() {
        return this.getStringAttribute('name_prefix');
    }
    set namePrefix(value) {
        this._namePrefix = value;
    }
    resetNamePrefix() {
        this._namePrefix = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get namePrefixInput() {
        return this._namePrefix;
    }
    get timePeriodEnd() {
        return this.getStringAttribute('time_period_end');
    }
    set timePeriodEnd(value) {
        this._timePeriodEnd = value;
    }
    resetTimePeriodEnd() {
        this._timePeriodEnd = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get timePeriodEndInput() {
        return this._timePeriodEnd;
    }
    get timePeriodStart() {
        return this.getStringAttribute('time_period_start');
    }
    set timePeriodStart(value) {
        this._timePeriodStart = value;
    }
    resetTimePeriodStart() {
        this._timePeriodStart = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get timePeriodStartInput() {
        return this._timePeriodStart;
    }
    get timeUnit() {
        return this.getStringAttribute('time_unit');
    }
    set timeUnit(value) {
        this._timeUnit = value;
    }
    // Temporarily expose input value. Use with caution.
    get timeUnitInput() {
        return this._timeUnit;
    }
    get costFilter() {
        // Getting the computed value is not yet implemented
        return cdktf.Token.asAny(cdktf.Fn.tolist(this.interpolationForAttribute('cost_filter')));
    }
    set costFilter(value) {
        this._costFilter = value;
    }
    resetCostFilter() {
        this._costFilter = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get costFilterInput() {
        return this._costFilter;
    }
    get costTypes() {
        return this._costTypes;
    }
    putCostTypes(value) {
        this._costTypes.internalValue = value;
    }
    resetCostTypes() {
        this._costTypes.internalValue = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get costTypesInput() {
        return this._costTypes.internalValue;
    }
    get notification() {
        // Getting the computed value is not yet implemented
        return cdktf.Token.asAny(cdktf.Fn.tolist(this.interpolationForAttribute('notification')));
    }
    set notification(value) {
        this._notification = value;
    }
    resetNotification() {
        this._notification = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get notificationInput() {
        return this._notification;
    }
    // =========
    // SYNTHESIS
    // =========
    synthesizeAttributes() {
        return {
            account_id: cdktf.stringToTerraform(this._accountId),
            budget_type: cdktf.stringToTerraform(this._budgetType),
            cost_filters: cdktf.hashMapper(cdktf.stringToTerraform)(this._costFilters),
            limit_amount: cdktf.stringToTerraform(this._limitAmount),
            limit_unit: cdktf.stringToTerraform(this._limitUnit),
            name: cdktf.stringToTerraform(this._name),
            name_prefix: cdktf.stringToTerraform(this._namePrefix),
            time_period_end: cdktf.stringToTerraform(this._timePeriodEnd),
            time_period_start: cdktf.stringToTerraform(this._timePeriodStart),
            time_unit: cdktf.stringToTerraform(this._timeUnit),
            cost_filter: cdktf.listMapper(budgetsBudgetCostFilterToTerraform)(this._costFilter),
            cost_types: budgetsBudgetCostTypesToTerraform(this._costTypes.internalValue),
            notification: cdktf.listMapper(budgetsBudgetNotificationToTerraform)(this._notification),
        };
    }
}
exports.BudgetsBudget = BudgetsBudget;
_b = JSII_RTTI_SYMBOL_1;
BudgetsBudget[_b] = { fqn: "@cdktf/provider-aws.budgets.BudgetsBudget", version: "7.0.64" };
// =================
// STATIC PROPERTIES
// =================
BudgetsBudget.tfResourceType = "aws_budgets_budget";
//# sourceMappingURL=data:application/json;base64,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