import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface CeCostCategoryConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/ce_cost_category#default_value CeCostCategory#default_value}
    */
    readonly defaultValue?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/ce_cost_category#name CeCostCategory#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/ce_cost_category#rule_version CeCostCategory#rule_version}
    */
    readonly ruleVersion: string;
    /**
    * rule block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/ce_cost_category#rule CeCostCategory#rule}
    */
    readonly rule: CeCostCategoryRule[] | cdktf.IResolvable;
    /**
    * split_charge_rule block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/ce_cost_category#split_charge_rule CeCostCategory#split_charge_rule}
    */
    readonly splitChargeRule?: CeCostCategorySplitChargeRule[] | cdktf.IResolvable;
}
export interface CeCostCategoryRuleInheritedValue {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/ce_cost_category#dimension_key CeCostCategory#dimension_key}
    */
    readonly dimensionKey?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/ce_cost_category#dimension_name CeCostCategory#dimension_name}
    */
    readonly dimensionName?: string;
}
export declare function ceCostCategoryRuleInheritedValueToTerraform(struct?: CeCostCategoryRuleInheritedValueOutputReference | CeCostCategoryRuleInheritedValue): any;
export declare class CeCostCategoryRuleInheritedValueOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): CeCostCategoryRuleInheritedValue | undefined;
    set internalValue(value: CeCostCategoryRuleInheritedValue | undefined);
    private _dimensionKey?;
    get dimensionKey(): string;
    set dimensionKey(value: string);
    resetDimensionKey(): void;
    get dimensionKeyInput(): string | undefined;
    private _dimensionName?;
    get dimensionName(): string;
    set dimensionName(value: string);
    resetDimensionName(): void;
    get dimensionNameInput(): string | undefined;
}
export interface CeCostCategoryRuleRuleAndCostCategory {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/ce_cost_category#key CeCostCategory#key}
    */
    readonly key?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/ce_cost_category#match_options CeCostCategory#match_options}
    */
    readonly matchOptions?: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/ce_cost_category#values CeCostCategory#values}
    */
    readonly values?: string[];
}
export declare function ceCostCategoryRuleRuleAndCostCategoryToTerraform(struct?: CeCostCategoryRuleRuleAndCostCategoryOutputReference | CeCostCategoryRuleRuleAndCostCategory): any;
export declare class CeCostCategoryRuleRuleAndCostCategoryOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): CeCostCategoryRuleRuleAndCostCategory | undefined;
    set internalValue(value: CeCostCategoryRuleRuleAndCostCategory | undefined);
    private _key?;
    get key(): string;
    set key(value: string);
    resetKey(): void;
    get keyInput(): string | undefined;
    private _matchOptions?;
    get matchOptions(): string[];
    set matchOptions(value: string[]);
    resetMatchOptions(): void;
    get matchOptionsInput(): string[] | undefined;
    private _values?;
    get values(): string[];
    set values(value: string[]);
    resetValues(): void;
    get valuesInput(): string[] | undefined;
}
export interface CeCostCategoryRuleRuleAndDimension {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/ce_cost_category#key CeCostCategory#key}
    */
    readonly key?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/ce_cost_category#match_options CeCostCategory#match_options}
    */
    readonly matchOptions?: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/ce_cost_category#values CeCostCategory#values}
    */
    readonly values?: string[];
}
export declare function ceCostCategoryRuleRuleAndDimensionToTerraform(struct?: CeCostCategoryRuleRuleAndDimensionOutputReference | CeCostCategoryRuleRuleAndDimension): any;
export declare class CeCostCategoryRuleRuleAndDimensionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): CeCostCategoryRuleRuleAndDimension | undefined;
    set internalValue(value: CeCostCategoryRuleRuleAndDimension | undefined);
    private _key?;
    get key(): string;
    set key(value: string);
    resetKey(): void;
    get keyInput(): string | undefined;
    private _matchOptions?;
    get matchOptions(): string[];
    set matchOptions(value: string[]);
    resetMatchOptions(): void;
    get matchOptionsInput(): string[] | undefined;
    private _values?;
    get values(): string[];
    set values(value: string[]);
    resetValues(): void;
    get valuesInput(): string[] | undefined;
}
export interface CeCostCategoryRuleRuleAndTags {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/ce_cost_category#key CeCostCategory#key}
    */
    readonly key?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/ce_cost_category#match_options CeCostCategory#match_options}
    */
    readonly matchOptions?: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/ce_cost_category#values CeCostCategory#values}
    */
    readonly values?: string[];
}
export declare function ceCostCategoryRuleRuleAndTagsToTerraform(struct?: CeCostCategoryRuleRuleAndTagsOutputReference | CeCostCategoryRuleRuleAndTags): any;
export declare class CeCostCategoryRuleRuleAndTagsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): CeCostCategoryRuleRuleAndTags | undefined;
    set internalValue(value: CeCostCategoryRuleRuleAndTags | undefined);
    private _key?;
    get key(): string;
    set key(value: string);
    resetKey(): void;
    get keyInput(): string | undefined;
    private _matchOptions?;
    get matchOptions(): string[];
    set matchOptions(value: string[]);
    resetMatchOptions(): void;
    get matchOptionsInput(): string[] | undefined;
    private _values?;
    get values(): string[];
    set values(value: string[]);
    resetValues(): void;
    get valuesInput(): string[] | undefined;
}
export interface CeCostCategoryRuleRuleAnd {
    /**
    * cost_category block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/ce_cost_category#cost_category CeCostCategory#cost_category}
    */
    readonly costCategory?: CeCostCategoryRuleRuleAndCostCategory;
    /**
    * dimension block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/ce_cost_category#dimension CeCostCategory#dimension}
    */
    readonly dimension?: CeCostCategoryRuleRuleAndDimension;
    /**
    * tags block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/ce_cost_category#tags CeCostCategory#tags}
    */
    readonly tags?: CeCostCategoryRuleRuleAndTags;
}
export declare function ceCostCategoryRuleRuleAndToTerraform(struct?: CeCostCategoryRuleRuleAnd | cdktf.IResolvable): any;
export interface CeCostCategoryRuleRuleCostCategory {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/ce_cost_category#key CeCostCategory#key}
    */
    readonly key?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/ce_cost_category#match_options CeCostCategory#match_options}
    */
    readonly matchOptions?: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/ce_cost_category#values CeCostCategory#values}
    */
    readonly values?: string[];
}
export declare function ceCostCategoryRuleRuleCostCategoryToTerraform(struct?: CeCostCategoryRuleRuleCostCategoryOutputReference | CeCostCategoryRuleRuleCostCategory): any;
export declare class CeCostCategoryRuleRuleCostCategoryOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): CeCostCategoryRuleRuleCostCategory | undefined;
    set internalValue(value: CeCostCategoryRuleRuleCostCategory | undefined);
    private _key?;
    get key(): string;
    set key(value: string);
    resetKey(): void;
    get keyInput(): string | undefined;
    private _matchOptions?;
    get matchOptions(): string[];
    set matchOptions(value: string[]);
    resetMatchOptions(): void;
    get matchOptionsInput(): string[] | undefined;
    private _values?;
    get values(): string[];
    set values(value: string[]);
    resetValues(): void;
    get valuesInput(): string[] | undefined;
}
export interface CeCostCategoryRuleRuleDimension {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/ce_cost_category#key CeCostCategory#key}
    */
    readonly key?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/ce_cost_category#match_options CeCostCategory#match_options}
    */
    readonly matchOptions?: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/ce_cost_category#values CeCostCategory#values}
    */
    readonly values?: string[];
}
export declare function ceCostCategoryRuleRuleDimensionToTerraform(struct?: CeCostCategoryRuleRuleDimensionOutputReference | CeCostCategoryRuleRuleDimension): any;
export declare class CeCostCategoryRuleRuleDimensionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): CeCostCategoryRuleRuleDimension | undefined;
    set internalValue(value: CeCostCategoryRuleRuleDimension | undefined);
    private _key?;
    get key(): string;
    set key(value: string);
    resetKey(): void;
    get keyInput(): string | undefined;
    private _matchOptions?;
    get matchOptions(): string[];
    set matchOptions(value: string[]);
    resetMatchOptions(): void;
    get matchOptionsInput(): string[] | undefined;
    private _values?;
    get values(): string[];
    set values(value: string[]);
    resetValues(): void;
    get valuesInput(): string[] | undefined;
}
export interface CeCostCategoryRuleRuleNotCostCategory {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/ce_cost_category#key CeCostCategory#key}
    */
    readonly key?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/ce_cost_category#match_options CeCostCategory#match_options}
    */
    readonly matchOptions?: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/ce_cost_category#values CeCostCategory#values}
    */
    readonly values?: string[];
}
export declare function ceCostCategoryRuleRuleNotCostCategoryToTerraform(struct?: CeCostCategoryRuleRuleNotCostCategoryOutputReference | CeCostCategoryRuleRuleNotCostCategory): any;
export declare class CeCostCategoryRuleRuleNotCostCategoryOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): CeCostCategoryRuleRuleNotCostCategory | undefined;
    set internalValue(value: CeCostCategoryRuleRuleNotCostCategory | undefined);
    private _key?;
    get key(): string;
    set key(value: string);
    resetKey(): void;
    get keyInput(): string | undefined;
    private _matchOptions?;
    get matchOptions(): string[];
    set matchOptions(value: string[]);
    resetMatchOptions(): void;
    get matchOptionsInput(): string[] | undefined;
    private _values?;
    get values(): string[];
    set values(value: string[]);
    resetValues(): void;
    get valuesInput(): string[] | undefined;
}
export interface CeCostCategoryRuleRuleNotDimension {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/ce_cost_category#key CeCostCategory#key}
    */
    readonly key?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/ce_cost_category#match_options CeCostCategory#match_options}
    */
    readonly matchOptions?: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/ce_cost_category#values CeCostCategory#values}
    */
    readonly values?: string[];
}
export declare function ceCostCategoryRuleRuleNotDimensionToTerraform(struct?: CeCostCategoryRuleRuleNotDimensionOutputReference | CeCostCategoryRuleRuleNotDimension): any;
export declare class CeCostCategoryRuleRuleNotDimensionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): CeCostCategoryRuleRuleNotDimension | undefined;
    set internalValue(value: CeCostCategoryRuleRuleNotDimension | undefined);
    private _key?;
    get key(): string;
    set key(value: string);
    resetKey(): void;
    get keyInput(): string | undefined;
    private _matchOptions?;
    get matchOptions(): string[];
    set matchOptions(value: string[]);
    resetMatchOptions(): void;
    get matchOptionsInput(): string[] | undefined;
    private _values?;
    get values(): string[];
    set values(value: string[]);
    resetValues(): void;
    get valuesInput(): string[] | undefined;
}
export interface CeCostCategoryRuleRuleNotTags {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/ce_cost_category#key CeCostCategory#key}
    */
    readonly key?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/ce_cost_category#match_options CeCostCategory#match_options}
    */
    readonly matchOptions?: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/ce_cost_category#values CeCostCategory#values}
    */
    readonly values?: string[];
}
export declare function ceCostCategoryRuleRuleNotTagsToTerraform(struct?: CeCostCategoryRuleRuleNotTagsOutputReference | CeCostCategoryRuleRuleNotTags): any;
export declare class CeCostCategoryRuleRuleNotTagsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): CeCostCategoryRuleRuleNotTags | undefined;
    set internalValue(value: CeCostCategoryRuleRuleNotTags | undefined);
    private _key?;
    get key(): string;
    set key(value: string);
    resetKey(): void;
    get keyInput(): string | undefined;
    private _matchOptions?;
    get matchOptions(): string[];
    set matchOptions(value: string[]);
    resetMatchOptions(): void;
    get matchOptionsInput(): string[] | undefined;
    private _values?;
    get values(): string[];
    set values(value: string[]);
    resetValues(): void;
    get valuesInput(): string[] | undefined;
}
export interface CeCostCategoryRuleRuleNot {
    /**
    * cost_category block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/ce_cost_category#cost_category CeCostCategory#cost_category}
    */
    readonly costCategory?: CeCostCategoryRuleRuleNotCostCategory;
    /**
    * dimension block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/ce_cost_category#dimension CeCostCategory#dimension}
    */
    readonly dimension?: CeCostCategoryRuleRuleNotDimension;
    /**
    * tags block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/ce_cost_category#tags CeCostCategory#tags}
    */
    readonly tags?: CeCostCategoryRuleRuleNotTags;
}
export declare function ceCostCategoryRuleRuleNotToTerraform(struct?: CeCostCategoryRuleRuleNotOutputReference | CeCostCategoryRuleRuleNot): any;
export declare class CeCostCategoryRuleRuleNotOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): CeCostCategoryRuleRuleNot | undefined;
    set internalValue(value: CeCostCategoryRuleRuleNot | undefined);
    private _costCategory;
    get costCategory(): CeCostCategoryRuleRuleNotCostCategoryOutputReference;
    putCostCategory(value: CeCostCategoryRuleRuleNotCostCategory): void;
    resetCostCategory(): void;
    get costCategoryInput(): CeCostCategoryRuleRuleNotCostCategory | undefined;
    private _dimension;
    get dimension(): CeCostCategoryRuleRuleNotDimensionOutputReference;
    putDimension(value: CeCostCategoryRuleRuleNotDimension): void;
    resetDimension(): void;
    get dimensionInput(): CeCostCategoryRuleRuleNotDimension | undefined;
    private _tags;
    get tags(): CeCostCategoryRuleRuleNotTagsOutputReference;
    putTags(value: CeCostCategoryRuleRuleNotTags): void;
    resetTags(): void;
    get tagsInput(): CeCostCategoryRuleRuleNotTags | undefined;
}
export interface CeCostCategoryRuleRuleOrCostCategory {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/ce_cost_category#key CeCostCategory#key}
    */
    readonly key?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/ce_cost_category#match_options CeCostCategory#match_options}
    */
    readonly matchOptions?: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/ce_cost_category#values CeCostCategory#values}
    */
    readonly values?: string[];
}
export declare function ceCostCategoryRuleRuleOrCostCategoryToTerraform(struct?: CeCostCategoryRuleRuleOrCostCategoryOutputReference | CeCostCategoryRuleRuleOrCostCategory): any;
export declare class CeCostCategoryRuleRuleOrCostCategoryOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): CeCostCategoryRuleRuleOrCostCategory | undefined;
    set internalValue(value: CeCostCategoryRuleRuleOrCostCategory | undefined);
    private _key?;
    get key(): string;
    set key(value: string);
    resetKey(): void;
    get keyInput(): string | undefined;
    private _matchOptions?;
    get matchOptions(): string[];
    set matchOptions(value: string[]);
    resetMatchOptions(): void;
    get matchOptionsInput(): string[] | undefined;
    private _values?;
    get values(): string[];
    set values(value: string[]);
    resetValues(): void;
    get valuesInput(): string[] | undefined;
}
export interface CeCostCategoryRuleRuleOrDimension {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/ce_cost_category#key CeCostCategory#key}
    */
    readonly key?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/ce_cost_category#match_options CeCostCategory#match_options}
    */
    readonly matchOptions?: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/ce_cost_category#values CeCostCategory#values}
    */
    readonly values?: string[];
}
export declare function ceCostCategoryRuleRuleOrDimensionToTerraform(struct?: CeCostCategoryRuleRuleOrDimensionOutputReference | CeCostCategoryRuleRuleOrDimension): any;
export declare class CeCostCategoryRuleRuleOrDimensionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): CeCostCategoryRuleRuleOrDimension | undefined;
    set internalValue(value: CeCostCategoryRuleRuleOrDimension | undefined);
    private _key?;
    get key(): string;
    set key(value: string);
    resetKey(): void;
    get keyInput(): string | undefined;
    private _matchOptions?;
    get matchOptions(): string[];
    set matchOptions(value: string[]);
    resetMatchOptions(): void;
    get matchOptionsInput(): string[] | undefined;
    private _values?;
    get values(): string[];
    set values(value: string[]);
    resetValues(): void;
    get valuesInput(): string[] | undefined;
}
export interface CeCostCategoryRuleRuleOrTags {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/ce_cost_category#key CeCostCategory#key}
    */
    readonly key?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/ce_cost_category#match_options CeCostCategory#match_options}
    */
    readonly matchOptions?: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/ce_cost_category#values CeCostCategory#values}
    */
    readonly values?: string[];
}
export declare function ceCostCategoryRuleRuleOrTagsToTerraform(struct?: CeCostCategoryRuleRuleOrTagsOutputReference | CeCostCategoryRuleRuleOrTags): any;
export declare class CeCostCategoryRuleRuleOrTagsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): CeCostCategoryRuleRuleOrTags | undefined;
    set internalValue(value: CeCostCategoryRuleRuleOrTags | undefined);
    private _key?;
    get key(): string;
    set key(value: string);
    resetKey(): void;
    get keyInput(): string | undefined;
    private _matchOptions?;
    get matchOptions(): string[];
    set matchOptions(value: string[]);
    resetMatchOptions(): void;
    get matchOptionsInput(): string[] | undefined;
    private _values?;
    get values(): string[];
    set values(value: string[]);
    resetValues(): void;
    get valuesInput(): string[] | undefined;
}
export interface CeCostCategoryRuleRuleOr {
    /**
    * cost_category block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/ce_cost_category#cost_category CeCostCategory#cost_category}
    */
    readonly costCategory?: CeCostCategoryRuleRuleOrCostCategory;
    /**
    * dimension block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/ce_cost_category#dimension CeCostCategory#dimension}
    */
    readonly dimension?: CeCostCategoryRuleRuleOrDimension;
    /**
    * tags block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/ce_cost_category#tags CeCostCategory#tags}
    */
    readonly tags?: CeCostCategoryRuleRuleOrTags;
}
export declare function ceCostCategoryRuleRuleOrToTerraform(struct?: CeCostCategoryRuleRuleOr | cdktf.IResolvable): any;
export interface CeCostCategoryRuleRuleTags {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/ce_cost_category#key CeCostCategory#key}
    */
    readonly key?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/ce_cost_category#match_options CeCostCategory#match_options}
    */
    readonly matchOptions?: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/ce_cost_category#values CeCostCategory#values}
    */
    readonly values?: string[];
}
export declare function ceCostCategoryRuleRuleTagsToTerraform(struct?: CeCostCategoryRuleRuleTagsOutputReference | CeCostCategoryRuleRuleTags): any;
export declare class CeCostCategoryRuleRuleTagsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): CeCostCategoryRuleRuleTags | undefined;
    set internalValue(value: CeCostCategoryRuleRuleTags | undefined);
    private _key?;
    get key(): string;
    set key(value: string);
    resetKey(): void;
    get keyInput(): string | undefined;
    private _matchOptions?;
    get matchOptions(): string[];
    set matchOptions(value: string[]);
    resetMatchOptions(): void;
    get matchOptionsInput(): string[] | undefined;
    private _values?;
    get values(): string[];
    set values(value: string[]);
    resetValues(): void;
    get valuesInput(): string[] | undefined;
}
export interface CeCostCategoryRuleRule {
    /**
    * and block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/ce_cost_category#and CeCostCategory#and}
    */
    readonly and?: CeCostCategoryRuleRuleAnd[] | cdktf.IResolvable;
    /**
    * cost_category block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/ce_cost_category#cost_category CeCostCategory#cost_category}
    */
    readonly costCategory?: CeCostCategoryRuleRuleCostCategory;
    /**
    * dimension block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/ce_cost_category#dimension CeCostCategory#dimension}
    */
    readonly dimension?: CeCostCategoryRuleRuleDimension;
    /**
    * not block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/ce_cost_category#not CeCostCategory#not}
    */
    readonly not?: CeCostCategoryRuleRuleNot;
    /**
    * or block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/ce_cost_category#or CeCostCategory#or}
    */
    readonly or?: CeCostCategoryRuleRuleOr[] | cdktf.IResolvable;
    /**
    * tags block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/ce_cost_category#tags CeCostCategory#tags}
    */
    readonly tags?: CeCostCategoryRuleRuleTags;
}
export declare function ceCostCategoryRuleRuleToTerraform(struct?: CeCostCategoryRuleRuleOutputReference | CeCostCategoryRuleRule): any;
export declare class CeCostCategoryRuleRuleOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): CeCostCategoryRuleRule | undefined;
    set internalValue(value: CeCostCategoryRuleRule | undefined);
    private _and?;
    get and(): CeCostCategoryRuleRuleAnd[] | cdktf.IResolvable;
    set and(value: CeCostCategoryRuleRuleAnd[] | cdktf.IResolvable);
    resetAnd(): void;
    get andInput(): cdktf.IResolvable | CeCostCategoryRuleRuleAnd[] | undefined;
    private _costCategory;
    get costCategory(): CeCostCategoryRuleRuleCostCategoryOutputReference;
    putCostCategory(value: CeCostCategoryRuleRuleCostCategory): void;
    resetCostCategory(): void;
    get costCategoryInput(): CeCostCategoryRuleRuleCostCategory | undefined;
    private _dimension;
    get dimension(): CeCostCategoryRuleRuleDimensionOutputReference;
    putDimension(value: CeCostCategoryRuleRuleDimension): void;
    resetDimension(): void;
    get dimensionInput(): CeCostCategoryRuleRuleDimension | undefined;
    private _not;
    get not(): CeCostCategoryRuleRuleNotOutputReference;
    putNot(value: CeCostCategoryRuleRuleNot): void;
    resetNot(): void;
    get notInput(): CeCostCategoryRuleRuleNot | undefined;
    private _or?;
    get or(): CeCostCategoryRuleRuleOr[] | cdktf.IResolvable;
    set or(value: CeCostCategoryRuleRuleOr[] | cdktf.IResolvable);
    resetOr(): void;
    get orInput(): cdktf.IResolvable | CeCostCategoryRuleRuleOr[] | undefined;
    private _tags;
    get tags(): CeCostCategoryRuleRuleTagsOutputReference;
    putTags(value: CeCostCategoryRuleRuleTags): void;
    resetTags(): void;
    get tagsInput(): CeCostCategoryRuleRuleTags | undefined;
}
export interface CeCostCategoryRule {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/ce_cost_category#type CeCostCategory#type}
    */
    readonly type?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/ce_cost_category#value CeCostCategory#value}
    */
    readonly value?: string;
    /**
    * inherited_value block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/ce_cost_category#inherited_value CeCostCategory#inherited_value}
    */
    readonly inheritedValue?: CeCostCategoryRuleInheritedValue;
    /**
    * rule block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/ce_cost_category#rule CeCostCategory#rule}
    */
    readonly rule?: CeCostCategoryRuleRule;
}
export declare function ceCostCategoryRuleToTerraform(struct?: CeCostCategoryRule | cdktf.IResolvable): any;
export interface CeCostCategorySplitChargeRuleParameter {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/ce_cost_category#type CeCostCategory#type}
    */
    readonly type?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/ce_cost_category#values CeCostCategory#values}
    */
    readonly values?: string[];
}
export declare function ceCostCategorySplitChargeRuleParameterToTerraform(struct?: CeCostCategorySplitChargeRuleParameter | cdktf.IResolvable): any;
export interface CeCostCategorySplitChargeRule {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/ce_cost_category#method CeCostCategory#method}
    */
    readonly method: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/ce_cost_category#source CeCostCategory#source}
    */
    readonly source: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/ce_cost_category#targets CeCostCategory#targets}
    */
    readonly targets: string[];
    /**
    * parameter block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/ce_cost_category#parameter CeCostCategory#parameter}
    */
    readonly parameter?: CeCostCategorySplitChargeRuleParameter[] | cdktf.IResolvable;
}
export declare function ceCostCategorySplitChargeRuleToTerraform(struct?: CeCostCategorySplitChargeRule | cdktf.IResolvable): any;
/**
* Represents a {@link https://www.terraform.io/docs/providers/aws/r/ce_cost_category aws_ce_cost_category}
*/
export declare class CeCostCategory extends cdktf.TerraformResource {
    static readonly tfResourceType = "aws_ce_cost_category";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/aws/r/ce_cost_category aws_ce_cost_category} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options CeCostCategoryConfig
    */
    constructor(scope: Construct, id: string, config: CeCostCategoryConfig);
    get arn(): string;
    private _defaultValue?;
    get defaultValue(): string;
    set defaultValue(value: string);
    resetDefaultValue(): void;
    get defaultValueInput(): string | undefined;
    get effectiveEnd(): string;
    get effectiveStart(): string;
    get id(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _ruleVersion?;
    get ruleVersion(): string;
    set ruleVersion(value: string);
    get ruleVersionInput(): string | undefined;
    private _rule?;
    get rule(): CeCostCategoryRule[] | cdktf.IResolvable;
    set rule(value: CeCostCategoryRule[] | cdktf.IResolvable);
    get ruleInput(): cdktf.IResolvable | CeCostCategoryRule[] | undefined;
    private _splitChargeRule?;
    get splitChargeRule(): CeCostCategorySplitChargeRule[] | cdktf.IResolvable;
    set splitChargeRule(value: CeCostCategorySplitChargeRule[] | cdktf.IResolvable);
    resetSplitChargeRule(): void;
    get splitChargeRuleInput(): cdktf.IResolvable | CeCostCategorySplitChargeRule[] | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
//# sourceMappingURL=ce-cost-category.d.ts.map