import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
* Amazon Chime
*/
export interface ChimeVoiceConnectorGroupConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/chime_voice_connector_group#name ChimeVoiceConnectorGroup#name}
    */
    readonly name: string;
    /**
    * connector block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/chime_voice_connector_group#connector ChimeVoiceConnectorGroup#connector}
    */
    readonly connector?: ChimeVoiceConnectorGroupConnector[] | cdktf.IResolvable;
}
export interface ChimeVoiceConnectorGroupConnector {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/chime_voice_connector_group#priority ChimeVoiceConnectorGroup#priority}
    */
    readonly priority: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/chime_voice_connector_group#voice_connector_id ChimeVoiceConnectorGroup#voice_connector_id}
    */
    readonly voiceConnectorId: string;
}
export declare function chimeVoiceConnectorGroupConnectorToTerraform(struct?: ChimeVoiceConnectorGroupConnector | cdktf.IResolvable): any;
/**
* Represents a {@link https://www.terraform.io/docs/providers/aws/r/chime_voice_connector_group aws_chime_voice_connector_group}
*/
export declare class ChimeVoiceConnectorGroup extends cdktf.TerraformResource {
    static readonly tfResourceType = "aws_chime_voice_connector_group";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/aws/r/chime_voice_connector_group aws_chime_voice_connector_group} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options ChimeVoiceConnectorGroupConfig
    */
    constructor(scope: Construct, id: string, config: ChimeVoiceConnectorGroupConfig);
    get id(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _connector?;
    get connector(): ChimeVoiceConnectorGroupConnector[] | cdktf.IResolvable;
    set connector(value: ChimeVoiceConnectorGroupConnector[] | cdktf.IResolvable);
    resetConnector(): void;
    get connectorInput(): cdktf.IResolvable | ChimeVoiceConnectorGroupConnector[] | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
//# sourceMappingURL=chime-voice-connector-group.d.ts.map