import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
* Amazon Chime
*/
export interface ChimeVoiceConnectorLoggingConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/chime_voice_connector_logging#enable_sip_logs ChimeVoiceConnectorLogging#enable_sip_logs}
    */
    readonly enableSipLogs?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/chime_voice_connector_logging#voice_connector_id ChimeVoiceConnectorLogging#voice_connector_id}
    */
    readonly voiceConnectorId: string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/aws/r/chime_voice_connector_logging aws_chime_voice_connector_logging}
*/
export declare class ChimeVoiceConnectorLogging extends cdktf.TerraformResource {
    static readonly tfResourceType = "aws_chime_voice_connector_logging";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/aws/r/chime_voice_connector_logging aws_chime_voice_connector_logging} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options ChimeVoiceConnectorLoggingConfig
    */
    constructor(scope: Construct, id: string, config: ChimeVoiceConnectorLoggingConfig);
    private _enableSipLogs?;
    get enableSipLogs(): boolean | cdktf.IResolvable;
    set enableSipLogs(value: boolean | cdktf.IResolvable);
    resetEnableSipLogs(): void;
    get enableSipLogsInput(): boolean | cdktf.IResolvable | undefined;
    get id(): string;
    private _voiceConnectorId?;
    get voiceConnectorId(): string;
    set voiceConnectorId(value: string);
    get voiceConnectorIdInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
//# sourceMappingURL=chime-voice-connector-logging.d.ts.map