import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
* AWS Cloud9
*/
export interface Cloud9EnvironmentMembershipConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/cloud9_environment_membership#environment_id Cloud9EnvironmentMembership#environment_id}
    */
    readonly environmentId: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/cloud9_environment_membership#permissions Cloud9EnvironmentMembership#permissions}
    */
    readonly permissions: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/cloud9_environment_membership#user_arn Cloud9EnvironmentMembership#user_arn}
    */
    readonly userArn: string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/aws/r/cloud9_environment_membership aws_cloud9_environment_membership}
*/
export declare class Cloud9EnvironmentMembership extends cdktf.TerraformResource {
    static readonly tfResourceType = "aws_cloud9_environment_membership";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/aws/r/cloud9_environment_membership aws_cloud9_environment_membership} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options Cloud9EnvironmentMembershipConfig
    */
    constructor(scope: Construct, id: string, config: Cloud9EnvironmentMembershipConfig);
    private _environmentId?;
    get environmentId(): string;
    set environmentId(value: string);
    get environmentIdInput(): string | undefined;
    get id(): string;
    private _permissions?;
    get permissions(): string;
    set permissions(value: string);
    get permissionsInput(): string | undefined;
    private _userArn?;
    get userArn(): string;
    set userArn(value: string);
    get userArnInput(): string | undefined;
    get userId(): string;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
//# sourceMappingURL=cloud9-environment-membership.d.ts.map