import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
* AWS CloudFront
*/
export interface DataAwsCloudfrontOriginAccessIdentitiesConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/d/cloudfront_origin_access_identities#comments DataAwsCloudfrontOriginAccessIdentities#comments}
    */
    readonly comments?: string[];
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/aws/d/cloudfront_origin_access_identities aws_cloudfront_origin_access_identities}
*/
export declare class DataAwsCloudfrontOriginAccessIdentities extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "aws_cloudfront_origin_access_identities";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/aws/d/cloudfront_origin_access_identities aws_cloudfront_origin_access_identities} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataAwsCloudfrontOriginAccessIdentitiesConfig = {}
    */
    constructor(scope: Construct, id: string, config?: DataAwsCloudfrontOriginAccessIdentitiesConfig);
    private _comments?;
    get comments(): string[];
    set comments(value: string[]);
    resetComments(): void;
    get commentsInput(): string[] | undefined;
    get iamArns(): string[];
    get id(): string;
    get ids(): string[];
    get s3CanonicalUserIds(): string[];
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
//# sourceMappingURL=data-aws-cloudfront-origin-access-identities.d.ts.map