import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface CloudsearchDomainServiceAccessPolicyConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/cloudsearch_domain_service_access_policy#access_policy CloudsearchDomainServiceAccessPolicy#access_policy}
    */
    readonly accessPolicy: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/cloudsearch_domain_service_access_policy#domain_name CloudsearchDomainServiceAccessPolicy#domain_name}
    */
    readonly domainName: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/cloudsearch_domain_service_access_policy#timeouts CloudsearchDomainServiceAccessPolicy#timeouts}
    */
    readonly timeouts?: CloudsearchDomainServiceAccessPolicyTimeouts;
}
export interface CloudsearchDomainServiceAccessPolicyTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/cloudsearch_domain_service_access_policy#delete CloudsearchDomainServiceAccessPolicy#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/cloudsearch_domain_service_access_policy#update CloudsearchDomainServiceAccessPolicy#update}
    */
    readonly update?: string;
}
export declare function cloudsearchDomainServiceAccessPolicyTimeoutsToTerraform(struct?: CloudsearchDomainServiceAccessPolicyTimeoutsOutputReference | CloudsearchDomainServiceAccessPolicyTimeouts | cdktf.IResolvable): any;
export declare class CloudsearchDomainServiceAccessPolicyTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): CloudsearchDomainServiceAccessPolicyTimeouts | undefined;
    set internalValue(value: CloudsearchDomainServiceAccessPolicyTimeouts | undefined);
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/aws/r/cloudsearch_domain_service_access_policy aws_cloudsearch_domain_service_access_policy}
*/
export declare class CloudsearchDomainServiceAccessPolicy extends cdktf.TerraformResource {
    static readonly tfResourceType = "aws_cloudsearch_domain_service_access_policy";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/aws/r/cloudsearch_domain_service_access_policy aws_cloudsearch_domain_service_access_policy} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options CloudsearchDomainServiceAccessPolicyConfig
    */
    constructor(scope: Construct, id: string, config: CloudsearchDomainServiceAccessPolicyConfig);
    private _accessPolicy?;
    get accessPolicy(): string;
    set accessPolicy(value: string);
    get accessPolicyInput(): string | undefined;
    private _domainName?;
    get domainName(): string;
    set domainName(value: string);
    get domainNameInput(): string | undefined;
    get id(): string;
    private _timeouts;
    get timeouts(): CloudsearchDomainServiceAccessPolicyTimeoutsOutputReference;
    putTimeouts(value: CloudsearchDomainServiceAccessPolicyTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): CloudsearchDomainServiceAccessPolicyTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
//# sourceMappingURL=cloudsearch-domain-service-access-policy.d.ts.map