import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface CloudsearchDomainConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/cloudsearch_domain#multi_az CloudsearchDomain#multi_az}
    */
    readonly multiAz?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/cloudsearch_domain#name CloudsearchDomain#name}
    */
    readonly name: string;
    /**
    * endpoint_options block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/cloudsearch_domain#endpoint_options CloudsearchDomain#endpoint_options}
    */
    readonly endpointOptions?: CloudsearchDomainEndpointOptions;
    /**
    * index_field block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/cloudsearch_domain#index_field CloudsearchDomain#index_field}
    */
    readonly indexField?: CloudsearchDomainIndexField[] | cdktf.IResolvable;
    /**
    * scaling_parameters block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/cloudsearch_domain#scaling_parameters CloudsearchDomain#scaling_parameters}
    */
    readonly scalingParameters?: CloudsearchDomainScalingParameters;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/cloudsearch_domain#timeouts CloudsearchDomain#timeouts}
    */
    readonly timeouts?: CloudsearchDomainTimeouts;
}
export interface CloudsearchDomainEndpointOptions {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/cloudsearch_domain#enforce_https CloudsearchDomain#enforce_https}
    */
    readonly enforceHttps?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/cloudsearch_domain#tls_security_policy CloudsearchDomain#tls_security_policy}
    */
    readonly tlsSecurityPolicy?: string;
}
export declare function cloudsearchDomainEndpointOptionsToTerraform(struct?: CloudsearchDomainEndpointOptionsOutputReference | CloudsearchDomainEndpointOptions): any;
export declare class CloudsearchDomainEndpointOptionsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): CloudsearchDomainEndpointOptions | undefined;
    set internalValue(value: CloudsearchDomainEndpointOptions | undefined);
    private _enforceHttps?;
    get enforceHttps(): boolean | cdktf.IResolvable;
    set enforceHttps(value: boolean | cdktf.IResolvable);
    resetEnforceHttps(): void;
    get enforceHttpsInput(): boolean | cdktf.IResolvable | undefined;
    private _tlsSecurityPolicy?;
    get tlsSecurityPolicy(): string;
    set tlsSecurityPolicy(value: string);
    resetTlsSecurityPolicy(): void;
    get tlsSecurityPolicyInput(): string | undefined;
}
export interface CloudsearchDomainIndexField {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/cloudsearch_domain#analysis_scheme CloudsearchDomain#analysis_scheme}
    */
    readonly analysisScheme?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/cloudsearch_domain#default_value CloudsearchDomain#default_value}
    */
    readonly defaultValue?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/cloudsearch_domain#facet CloudsearchDomain#facet}
    */
    readonly facet?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/cloudsearch_domain#highlight CloudsearchDomain#highlight}
    */
    readonly highlight?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/cloudsearch_domain#name CloudsearchDomain#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/cloudsearch_domain#return CloudsearchDomain#return}
    */
    readonly return?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/cloudsearch_domain#search CloudsearchDomain#search}
    */
    readonly search?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/cloudsearch_domain#sort CloudsearchDomain#sort}
    */
    readonly sort?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/cloudsearch_domain#type CloudsearchDomain#type}
    */
    readonly type: string;
}
export declare function cloudsearchDomainIndexFieldToTerraform(struct?: CloudsearchDomainIndexField | cdktf.IResolvable): any;
export interface CloudsearchDomainScalingParameters {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/cloudsearch_domain#desired_instance_type CloudsearchDomain#desired_instance_type}
    */
    readonly desiredInstanceType?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/cloudsearch_domain#desired_partition_count CloudsearchDomain#desired_partition_count}
    */
    readonly desiredPartitionCount?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/cloudsearch_domain#desired_replication_count CloudsearchDomain#desired_replication_count}
    */
    readonly desiredReplicationCount?: number;
}
export declare function cloudsearchDomainScalingParametersToTerraform(struct?: CloudsearchDomainScalingParametersOutputReference | CloudsearchDomainScalingParameters): any;
export declare class CloudsearchDomainScalingParametersOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): CloudsearchDomainScalingParameters | undefined;
    set internalValue(value: CloudsearchDomainScalingParameters | undefined);
    private _desiredInstanceType?;
    get desiredInstanceType(): string;
    set desiredInstanceType(value: string);
    resetDesiredInstanceType(): void;
    get desiredInstanceTypeInput(): string | undefined;
    private _desiredPartitionCount?;
    get desiredPartitionCount(): number;
    set desiredPartitionCount(value: number);
    resetDesiredPartitionCount(): void;
    get desiredPartitionCountInput(): number | undefined;
    private _desiredReplicationCount?;
    get desiredReplicationCount(): number;
    set desiredReplicationCount(value: number);
    resetDesiredReplicationCount(): void;
    get desiredReplicationCountInput(): number | undefined;
}
export interface CloudsearchDomainTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/cloudsearch_domain#create CloudsearchDomain#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/cloudsearch_domain#delete CloudsearchDomain#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/cloudsearch_domain#update CloudsearchDomain#update}
    */
    readonly update?: string;
}
export declare function cloudsearchDomainTimeoutsToTerraform(struct?: CloudsearchDomainTimeoutsOutputReference | CloudsearchDomainTimeouts | cdktf.IResolvable): any;
export declare class CloudsearchDomainTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): CloudsearchDomainTimeouts | undefined;
    set internalValue(value: CloudsearchDomainTimeouts | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/aws/r/cloudsearch_domain aws_cloudsearch_domain}
*/
export declare class CloudsearchDomain extends cdktf.TerraformResource {
    static readonly tfResourceType = "aws_cloudsearch_domain";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/aws/r/cloudsearch_domain aws_cloudsearch_domain} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options CloudsearchDomainConfig
    */
    constructor(scope: Construct, id: string, config: CloudsearchDomainConfig);
    get arn(): string;
    get documentServiceEndpoint(): string;
    get domainId(): string;
    get id(): string;
    private _multiAz?;
    get multiAz(): boolean | cdktf.IResolvable;
    set multiAz(value: boolean | cdktf.IResolvable);
    resetMultiAz(): void;
    get multiAzInput(): boolean | cdktf.IResolvable | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    get searchServiceEndpoint(): string;
    private _endpointOptions;
    get endpointOptions(): CloudsearchDomainEndpointOptionsOutputReference;
    putEndpointOptions(value: CloudsearchDomainEndpointOptions): void;
    resetEndpointOptions(): void;
    get endpointOptionsInput(): CloudsearchDomainEndpointOptions | undefined;
    private _indexField?;
    get indexField(): CloudsearchDomainIndexField[] | cdktf.IResolvable;
    set indexField(value: CloudsearchDomainIndexField[] | cdktf.IResolvable);
    resetIndexField(): void;
    get indexFieldInput(): cdktf.IResolvable | CloudsearchDomainIndexField[] | undefined;
    private _scalingParameters;
    get scalingParameters(): CloudsearchDomainScalingParametersOutputReference;
    putScalingParameters(value: CloudsearchDomainScalingParameters): void;
    resetScalingParameters(): void;
    get scalingParametersInput(): CloudsearchDomainScalingParameters | undefined;
    private _timeouts;
    get timeouts(): CloudsearchDomainTimeoutsOutputReference;
    putTimeouts(value: CloudsearchDomainTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): CloudsearchDomainTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
//# sourceMappingURL=cloudsearch-domain.d.ts.map