import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
* AWS CloudWatch
*/
export interface CloudwatchLogDestinationPolicyConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/cloudwatch_log_destination_policy#access_policy CloudwatchLogDestinationPolicy#access_policy}
    */
    readonly accessPolicy: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/cloudwatch_log_destination_policy#destination_name CloudwatchLogDestinationPolicy#destination_name}
    */
    readonly destinationName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/cloudwatch_log_destination_policy#force_update CloudwatchLogDestinationPolicy#force_update}
    */
    readonly forceUpdate?: boolean | cdktf.IResolvable;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/aws/r/cloudwatch_log_destination_policy aws_cloudwatch_log_destination_policy}
*/
export declare class CloudwatchLogDestinationPolicy extends cdktf.TerraformResource {
    static readonly tfResourceType = "aws_cloudwatch_log_destination_policy";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/aws/r/cloudwatch_log_destination_policy aws_cloudwatch_log_destination_policy} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options CloudwatchLogDestinationPolicyConfig
    */
    constructor(scope: Construct, id: string, config: CloudwatchLogDestinationPolicyConfig);
    private _accessPolicy?;
    get accessPolicy(): string;
    set accessPolicy(value: string);
    get accessPolicyInput(): string | undefined;
    private _destinationName?;
    get destinationName(): string;
    set destinationName(value: string);
    get destinationNameInput(): string | undefined;
    private _forceUpdate?;
    get forceUpdate(): boolean | cdktf.IResolvable;
    set forceUpdate(value: boolean | cdktf.IResolvable);
    resetForceUpdate(): void;
    get forceUpdateInput(): boolean | cdktf.IResolvable | undefined;
    get id(): string;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
//# sourceMappingURL=cloudwatch-log-destination-policy.d.ts.map