import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
* AWS CodePipeline
*/
export interface CodepipelineWebhookConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/codepipeline_webhook#authentication CodepipelineWebhook#authentication}
    */
    readonly authentication: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/codepipeline_webhook#name CodepipelineWebhook#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/codepipeline_webhook#tags CodepipelineWebhook#tags}
    */
    readonly tags?: {
        [key: string]: string;
    };
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/codepipeline_webhook#tags_all CodepipelineWebhook#tags_all}
    */
    readonly tagsAll?: {
        [key: string]: string;
    };
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/codepipeline_webhook#target_action CodepipelineWebhook#target_action}
    */
    readonly targetAction: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/codepipeline_webhook#target_pipeline CodepipelineWebhook#target_pipeline}
    */
    readonly targetPipeline: string;
    /**
    * authentication_configuration block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/codepipeline_webhook#authentication_configuration CodepipelineWebhook#authentication_configuration}
    */
    readonly authenticationConfiguration?: CodepipelineWebhookAuthenticationConfiguration;
    /**
    * filter block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/codepipeline_webhook#filter CodepipelineWebhook#filter}
    */
    readonly filter: CodepipelineWebhookFilter[] | cdktf.IResolvable;
}
export interface CodepipelineWebhookAuthenticationConfiguration {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/codepipeline_webhook#allowed_ip_range CodepipelineWebhook#allowed_ip_range}
    */
    readonly allowedIpRange?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/codepipeline_webhook#secret_token CodepipelineWebhook#secret_token}
    */
    readonly secretToken?: string;
}
export declare function codepipelineWebhookAuthenticationConfigurationToTerraform(struct?: CodepipelineWebhookAuthenticationConfigurationOutputReference | CodepipelineWebhookAuthenticationConfiguration): any;
export declare class CodepipelineWebhookAuthenticationConfigurationOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): CodepipelineWebhookAuthenticationConfiguration | undefined;
    set internalValue(value: CodepipelineWebhookAuthenticationConfiguration | undefined);
    private _allowedIpRange?;
    get allowedIpRange(): string;
    set allowedIpRange(value: string);
    resetAllowedIpRange(): void;
    get allowedIpRangeInput(): string | undefined;
    private _secretToken?;
    get secretToken(): string;
    set secretToken(value: string);
    resetSecretToken(): void;
    get secretTokenInput(): string | undefined;
}
export interface CodepipelineWebhookFilter {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/codepipeline_webhook#json_path CodepipelineWebhook#json_path}
    */
    readonly jsonPath: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/codepipeline_webhook#match_equals CodepipelineWebhook#match_equals}
    */
    readonly matchEquals: string;
}
export declare function codepipelineWebhookFilterToTerraform(struct?: CodepipelineWebhookFilter | cdktf.IResolvable): any;
/**
* Represents a {@link https://www.terraform.io/docs/providers/aws/r/codepipeline_webhook aws_codepipeline_webhook}
*/
export declare class CodepipelineWebhook extends cdktf.TerraformResource {
    static readonly tfResourceType = "aws_codepipeline_webhook";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/aws/r/codepipeline_webhook aws_codepipeline_webhook} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options CodepipelineWebhookConfig
    */
    constructor(scope: Construct, id: string, config: CodepipelineWebhookConfig);
    get arn(): string;
    private _authentication?;
    get authentication(): string;
    set authentication(value: string);
    get authenticationInput(): string | undefined;
    get id(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _tags?;
    get tags(): {
        [key: string]: string;
    };
    set tags(value: {
        [key: string]: string;
    });
    resetTags(): void;
    get tagsInput(): {
        [key: string]: string;
    } | undefined;
    private _tagsAll?;
    get tagsAll(): {
        [key: string]: string;
    };
    set tagsAll(value: {
        [key: string]: string;
    });
    resetTagsAll(): void;
    get tagsAllInput(): {
        [key: string]: string;
    } | undefined;
    private _targetAction?;
    get targetAction(): string;
    set targetAction(value: string);
    get targetActionInput(): string | undefined;
    private _targetPipeline?;
    get targetPipeline(): string;
    set targetPipeline(value: string);
    get targetPipelineInput(): string | undefined;
    get url(): string;
    private _authenticationConfiguration;
    get authenticationConfiguration(): CodepipelineWebhookAuthenticationConfigurationOutputReference;
    putAuthenticationConfiguration(value: CodepipelineWebhookAuthenticationConfiguration): void;
    resetAuthenticationConfiguration(): void;
    get authenticationConfigurationInput(): CodepipelineWebhookAuthenticationConfiguration | undefined;
    private _filter?;
    get filter(): CodepipelineWebhookFilter[] | cdktf.IResolvable;
    set filter(value: CodepipelineWebhookFilter[] | cdktf.IResolvable);
    get filterInput(): cdktf.IResolvable | CodepipelineWebhookFilter[] | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
//# sourceMappingURL=codepipeline-webhook.d.ts.map