import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
* AWS Cognito
*/
export interface CognitoIdentityPoolProviderPrincipalTagConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/cognito_identity_pool_provider_principal_tag#identity_pool_id CognitoIdentityPoolProviderPrincipalTag#identity_pool_id}
    */
    readonly identityPoolId: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/cognito_identity_pool_provider_principal_tag#identity_provider_name CognitoIdentityPoolProviderPrincipalTag#identity_provider_name}
    */
    readonly identityProviderName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/cognito_identity_pool_provider_principal_tag#principal_tags CognitoIdentityPoolProviderPrincipalTag#principal_tags}
    */
    readonly principalTags?: {
        [key: string]: string;
    };
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/cognito_identity_pool_provider_principal_tag#use_defaults CognitoIdentityPoolProviderPrincipalTag#use_defaults}
    */
    readonly useDefaults?: boolean | cdktf.IResolvable;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/aws/r/cognito_identity_pool_provider_principal_tag aws_cognito_identity_pool_provider_principal_tag}
*/
export declare class CognitoIdentityPoolProviderPrincipalTag extends cdktf.TerraformResource {
    static readonly tfResourceType = "aws_cognito_identity_pool_provider_principal_tag";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/aws/r/cognito_identity_pool_provider_principal_tag aws_cognito_identity_pool_provider_principal_tag} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options CognitoIdentityPoolProviderPrincipalTagConfig
    */
    constructor(scope: Construct, id: string, config: CognitoIdentityPoolProviderPrincipalTagConfig);
    get id(): string;
    private _identityPoolId?;
    get identityPoolId(): string;
    set identityPoolId(value: string);
    get identityPoolIdInput(): string | undefined;
    private _identityProviderName?;
    get identityProviderName(): string;
    set identityProviderName(value: string);
    get identityProviderNameInput(): string | undefined;
    private _principalTags?;
    get principalTags(): {
        [key: string]: string;
    };
    set principalTags(value: {
        [key: string]: string;
    });
    resetPrincipalTags(): void;
    get principalTagsInput(): {
        [key: string]: string;
    } | undefined;
    private _useDefaults?;
    get useDefaults(): boolean | cdktf.IResolvable;
    set useDefaults(value: boolean | cdktf.IResolvable);
    resetUseDefaults(): void;
    get useDefaultsInput(): boolean | cdktf.IResolvable | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
//# sourceMappingURL=cognito-identity-pool-provider-principal-tag.d.ts.map