"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.CognitoIdentityPoolProviderPrincipalTag = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cdktf = require("cdktf");
/**
* Represents a {@link https://www.terraform.io/docs/providers/aws/r/cognito_identity_pool_provider_principal_tag aws_cognito_identity_pool_provider_principal_tag}
*/
class CognitoIdentityPoolProviderPrincipalTag extends cdktf.TerraformResource {
    // ===========
    // INITIALIZER
    // ===========
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/aws/r/cognito_identity_pool_provider_principal_tag aws_cognito_identity_pool_provider_principal_tag} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options CognitoIdentityPoolProviderPrincipalTagConfig
    */
    constructor(scope, id, config) {
        super(scope, id, {
            terraformResourceType: 'aws_cognito_identity_pool_provider_principal_tag',
            terraformGeneratorMetadata: {
                providerName: 'aws',
                providerVersion: '4.15.1',
                providerVersionConstraint: '~> 4.0'
            },
            provider: config.provider,
            dependsOn: config.dependsOn,
            count: config.count,
            lifecycle: config.lifecycle
        });
        this._identityPoolId = config.identityPoolId;
        this._identityProviderName = config.identityProviderName;
        this._principalTags = config.principalTags;
        this._useDefaults = config.useDefaults;
    }
    // ==========
    // ATTRIBUTES
    // ==========
    // id - computed: true, optional: true, required: false
    get id() {
        return this.getStringAttribute('id');
    }
    get identityPoolId() {
        return this.getStringAttribute('identity_pool_id');
    }
    set identityPoolId(value) {
        this._identityPoolId = value;
    }
    // Temporarily expose input value. Use with caution.
    get identityPoolIdInput() {
        return this._identityPoolId;
    }
    get identityProviderName() {
        return this.getStringAttribute('identity_provider_name');
    }
    set identityProviderName(value) {
        this._identityProviderName = value;
    }
    // Temporarily expose input value. Use with caution.
    get identityProviderNameInput() {
        return this._identityProviderName;
    }
    get principalTags() {
        return this.getStringMapAttribute('principal_tags');
    }
    set principalTags(value) {
        this._principalTags = value;
    }
    resetPrincipalTags() {
        this._principalTags = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get principalTagsInput() {
        return this._principalTags;
    }
    get useDefaults() {
        return this.getBooleanAttribute('use_defaults');
    }
    set useDefaults(value) {
        this._useDefaults = value;
    }
    resetUseDefaults() {
        this._useDefaults = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get useDefaultsInput() {
        return this._useDefaults;
    }
    // =========
    // SYNTHESIS
    // =========
    synthesizeAttributes() {
        return {
            identity_pool_id: cdktf.stringToTerraform(this._identityPoolId),
            identity_provider_name: cdktf.stringToTerraform(this._identityProviderName),
            principal_tags: cdktf.hashMapper(cdktf.stringToTerraform)(this._principalTags),
            use_defaults: cdktf.booleanToTerraform(this._useDefaults),
        };
    }
}
exports.CognitoIdentityPoolProviderPrincipalTag = CognitoIdentityPoolProviderPrincipalTag;
_a = JSII_RTTI_SYMBOL_1;
CognitoIdentityPoolProviderPrincipalTag[_a] = { fqn: "@cdktf/provider-aws.cognito.CognitoIdentityPoolProviderPrincipalTag", version: "7.0.64" };
// =================
// STATIC PROPERTIES
// =================
CognitoIdentityPoolProviderPrincipalTag.tfResourceType = "aws_cognito_identity_pool_provider_principal_tag";
//# sourceMappingURL=data:application/json;base64,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