"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.CognitoIdentityPoolRolesAttachment = exports.cognitoIdentityPoolRolesAttachmentRoleMappingToTerraform = exports.cognitoIdentityPoolRolesAttachmentRoleMappingMappingRuleToTerraform = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cdktf = require("cdktf");
function cognitoIdentityPoolRolesAttachmentRoleMappingMappingRuleToTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    return {
        claim: cdktf.stringToTerraform(struct.claim),
        match_type: cdktf.stringToTerraform(struct.matchType),
        role_arn: cdktf.stringToTerraform(struct.roleArn),
        value: cdktf.stringToTerraform(struct.value),
    };
}
exports.cognitoIdentityPoolRolesAttachmentRoleMappingMappingRuleToTerraform = cognitoIdentityPoolRolesAttachmentRoleMappingMappingRuleToTerraform;
function cognitoIdentityPoolRolesAttachmentRoleMappingToTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    return {
        ambiguous_role_resolution: cdktf.stringToTerraform(struct.ambiguousRoleResolution),
        identity_provider: cdktf.stringToTerraform(struct.identityProvider),
        type: cdktf.stringToTerraform(struct.type),
        mapping_rule: cdktf.listMapper(cognitoIdentityPoolRolesAttachmentRoleMappingMappingRuleToTerraform)(struct.mappingRule),
    };
}
exports.cognitoIdentityPoolRolesAttachmentRoleMappingToTerraform = cognitoIdentityPoolRolesAttachmentRoleMappingToTerraform;
/**
* Represents a {@link https://www.terraform.io/docs/providers/aws/r/cognito_identity_pool_roles_attachment aws_cognito_identity_pool_roles_attachment}
*/
class CognitoIdentityPoolRolesAttachment extends cdktf.TerraformResource {
    // ===========
    // INITIALIZER
    // ===========
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/aws/r/cognito_identity_pool_roles_attachment aws_cognito_identity_pool_roles_attachment} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options CognitoIdentityPoolRolesAttachmentConfig
    */
    constructor(scope, id, config) {
        super(scope, id, {
            terraformResourceType: 'aws_cognito_identity_pool_roles_attachment',
            terraformGeneratorMetadata: {
                providerName: 'aws',
                providerVersion: '4.15.1',
                providerVersionConstraint: '~> 4.0'
            },
            provider: config.provider,
            dependsOn: config.dependsOn,
            count: config.count,
            lifecycle: config.lifecycle
        });
        this._identityPoolId = config.identityPoolId;
        this._roles = config.roles;
        this._roleMapping = config.roleMapping;
    }
    // ==========
    // ATTRIBUTES
    // ==========
    // id - computed: true, optional: true, required: false
    get id() {
        return this.getStringAttribute('id');
    }
    get identityPoolId() {
        return this.getStringAttribute('identity_pool_id');
    }
    set identityPoolId(value) {
        this._identityPoolId = value;
    }
    // Temporarily expose input value. Use with caution.
    get identityPoolIdInput() {
        return this._identityPoolId;
    }
    get roles() {
        return this.getStringMapAttribute('roles');
    }
    set roles(value) {
        this._roles = value;
    }
    // Temporarily expose input value. Use with caution.
    get rolesInput() {
        return this._roles;
    }
    get roleMapping() {
        // Getting the computed value is not yet implemented
        return cdktf.Token.asAny(cdktf.Fn.tolist(this.interpolationForAttribute('role_mapping')));
    }
    set roleMapping(value) {
        this._roleMapping = value;
    }
    resetRoleMapping() {
        this._roleMapping = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get roleMappingInput() {
        return this._roleMapping;
    }
    // =========
    // SYNTHESIS
    // =========
    synthesizeAttributes() {
        return {
            identity_pool_id: cdktf.stringToTerraform(this._identityPoolId),
            roles: cdktf.hashMapper(cdktf.stringToTerraform)(this._roles),
            role_mapping: cdktf.listMapper(cognitoIdentityPoolRolesAttachmentRoleMappingToTerraform)(this._roleMapping),
        };
    }
}
exports.CognitoIdentityPoolRolesAttachment = CognitoIdentityPoolRolesAttachment;
_a = JSII_RTTI_SYMBOL_1;
CognitoIdentityPoolRolesAttachment[_a] = { fqn: "@cdktf/provider-aws.cognito.CognitoIdentityPoolRolesAttachment", version: "7.0.64" };
// =================
// STATIC PROPERTIES
// =================
CognitoIdentityPoolRolesAttachment.tfResourceType = "aws_cognito_identity_pool_roles_attachment";
//# sourceMappingURL=data:application/json;base64,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